﻿
//
// create the mesh and add geometry using the geometry API
//

// enable in prop window
var flags = 0x8;

// create the mesh and scene node and place into documents list
var newTeapotElement = document.createMesh(1100);

// get the mesh behavior
var mesh = newTeapotElement.behavior;

var material = services.effects.createEffectInstance("Phong");

// set up the color traits
var diffuseColorTrait = material.getOrCreateTrait("MaterialDiffuse", "float4", flags);
diffuseColorTrait.value = [1, 1, 1, 1];

var ambientColorTrait = material.getOrCreateTrait("MaterialAmbient", "float4", flags);
ambientColorTrait.value = [1, 1, 1, 1]

// add to our materials collection
mesh.materials.append(material);

// get the geometry
var geom = newTeapotElement.getTrait("Geometry").value;

var points = [0.6887745261192322, 1.1807563304901123, -5.1612499163411485e-8, 0.6826959252357483, 1.1955541372299194, -5.2259334637483334e-8, 0.6796067357063293, 1.2076612710952758, -5.2788553972504815e-8, 0.6791654825210571, 1.2170783281326294, -5.3200189142899035e-8, 0.6810302734375, 1.2238045930862426, -5.349419751610185e-8, 0.6848596930503845, 1.2278403043746948, -5.367060751382269e-8, 0.6903119683265686, 1.229185700416565, -5.372941558334787e-8, 0.6970453262329102, 1.2278406620025634, -5.3670618171963724e-8, 0.7047183513641357, 1.2238047122955322, -5.3494204621529206e-8, 0.7129892110824585, 1.2170783281326294, -5.3200189142899035e-8, 0.7215163707733154, 1.207661509513855, -5.278856463064585e-8, 0.7299580574035644, 1.1955541372299194, -5.2259334637483334e-8, 0.7379726767539978, 1.1807563304901123, -5.1612499163411485e-8, 0.6825883388519287, 1.1807563304901123, 0.09457890689373016, 0.6765643358230591, 1.1955541372299194, 0.09374422580003738, 0.6735029220581055, 1.2076612710952758, 0.09332003444433212, 0.6730656027793884, 1.2170783281326294, 0.09325944632291794, 0.6749137043952942, 1.2238045930862426, 0.09351552277803421, 0.6787087321281433, 1.2278403043746948, 0.09404134005308151, 0.684112012386322, 1.229185700416565, 0.0947900116443634, 0.6907849311828613, 1.2278406620025634, 0.09571461379528045, 0.698388934135437, 1.2238047122955322, 0.09676822274923324, 0.7065855860710144, 1.2170783281326294, 0.09790394455194473, 0.7150360941886902, 1.207661509513855, 0.0990748330950737, 0.7234020233154297, 1.1955541372299194, 0.1002340167760849, 0.7313446402549744, 1.1807563304901123, 0.10133454203605652, 0.6645398139953613, 1.1807562112808227, 0.18494866788387298, 0.6586751937866211, 1.1955541372299194, 0.1833164393901825, 0.6556946635246277, 1.2076612710952758, 0.18248693645000458, 0.6552689075469971, 1.2170782089233398, 0.1823684573173523, 0.6570680141448975, 1.2238045930862426, 0.18286919593811035, 0.6607628464698791, 1.2278403043746948, 0.1838974505662918, 0.6660231351852417, 1.229185700416565, 0.18536145985126495, 0.6725196242332458, 1.2278404235839843, 0.18716950714588165, 0.6799226999282837, 1.2238047122955322, 0.1892298460006714, 0.687902569770813, 1.2170782089233398, 0.19145072996616363, 0.6961297392845154, 1.207661509513855, 0.19374042749404907, 0.7042743563652039, 1.1955541372299194, 0.19600717723369598, 0.7120069861412048, 1.1807562112808227, 0.19815927743911743, 0.6353943943977356, 1.1807563304901123, 0.27034392952919006, 0.6297869682312012, 1.1955541372299194, 0.2679580748081207, 0.6269372701644897, 1.2076612710952758, 0.26674559712409973, 0.6265300512313843, 1.2170783281326294, 0.26657241582870483, 0.6282503008842468, 1.2238045930862426, 0.26730433106422424, 0.631783127784729, 1.2278403043746948, 0.26880738139152527, 0.6368127465248108, 1.229185700416565, 0.2709473967552185, 0.6430243849754333, 1.2278406620025634, 0.27359023690223694, 0.6501026749610901, 1.2238047122955322, 0.2766018807888031, 0.6577325463294983, 1.2170783281326294, 0.27984824776649475, 0.6655987501144409, 1.207661509513855, 0.2831951081752777, 0.6733863353729248, 1.1955541372299194, 0.2865085005760193, 0.680779755115509, 1.1807563304901123, 0.2896542251110077, 0.5959174036979675, 1.1807562112808227, 0.34999939799308777, 0.59065842628479, 1.1955541372299194, 0.34691059589385986, 0.587985634803772, 1.2076612710952758, 0.3453408479690552, 0.5876038670539856, 1.2170782089233398, 0.34511658549308777, 0.5892171859741211, 1.2238044738769531, 0.3460642099380493, 0.5925304293632507, 1.2278403043746948, 0.3480101227760315, 0.5972475409507751, 1.2291855812072754, 0.3507806360721588, 0.6030732989311218, 1.2278401851654052, 0.3542022407054901, 0.6097117066383362, 1.2238045930862426, 0.3581012487411499, 0.6168676018714905, 1.2170782089233398, 0.36230406165122986, 0.6242451667785644, 1.2076613903045654, 0.36663711071014404, 0.6315487623214722, 1.1955541372299194, 0.37092673778533935, 0.638482928276062, 1.1807562112808227, 0.37499937415122986, 0.5468741655349731, 1.1807564496994018, 0.42314988374710083, 0.5420479774475098, 1.195554256439209, 0.41941553354263305, 0.5395951867103577, 1.2076613903045654, 0.41751766204833984, 0.5392447710037231, 1.2170783281326294, 0.417246550321579, 0.5407253503799438, 1.2238047122955322, 0.418392151594162, 0.5437659621238708, 1.2278403043746948, 0.4207448363304138, 0.5480948686599731, 1.2291858196258545, 0.42409437894821167, 0.5534411072731018, 1.2278406620025634, 0.4282310903072357, 0.5595332980155945, 1.2238048315048217, 0.43294504284858703, 0.5661002397537231, 1.217078447341919, 0.43802621960639953, 0.572870671749115, 1.207661509513855, 0.44326481223106384, 0.5795731544494629, 1.195554256439209, 0.4484509527683258, 0.5859366655349731, 1.1807564496994018, 0.45337480306625366, 0.4890298843383789, 1.1807563304901123, 0.48902982473373413, 0.484714150428772, 1.1955541372299194, 0.4847140908241272, 0.48252078890800476, 1.2076612710952758, 0.48252078890800476, 0.48220744729042053, 1.2170783281326294, 0.48220738768577575, 0.48353147506713867, 1.2238045930862426, 0.4835314154624939, 0.4862504005432129, 1.2278403043746948, 0.4862503409385681, 0.4901214838027954, 1.229185700416565, 0.49012142419815063, 0.49490228295326233, 1.2278406620025634, 0.4949021637439728, 0.5003499984741211, 1.2238047122955322, 0.5003499388694763, 0.5062223672866821, 1.2170783281326294, 0.5062223076820373, 0.5122765898704529, 1.207661509513855, 0.5122765302658081, 0.5182702541351318, 1.1955541372299194, 0.5182701945304871, 0.5239605903625488, 1.1807563304901123, 0.523960530757904, 0.4231499433517456, 1.1807563304901123, 0.5468741059303284, 0.41941559314727783, 1.1955541372299194, 0.542047917842865, 0.4175177216529846, 1.2076612710952758, 0.5395951271057129, 0.41724660992622375, 1.2170783281326294, 0.5392447113990784, 0.41839221119880676, 1.2238045930862426, 0.5407252907752991, 0.4207448959350586, 1.2278403043746948, 0.5437659025192261, 0.42409443855285644, 1.229185700416565, 0.5480948090553284, 0.4282311499118805, 1.2278406620025634, 0.553441047668457, 0.4329451024532318, 1.2238047122955322, 0.5595332384109497, 0.4380262792110443, 1.2170783281326294, 0.5661001801490784, 0.4432649314403534, 1.207661509513855, 0.5728706121444702, 0.44845104217529297, 1.1955541372299194, 0.5795730948448181, 0.4533748924732208, 1.1807563304901123, 0.5859366059303284, 0.34999948740005493, 1.1807563304901123, 0.5959173440933227, 0.346910685300827, 1.1955541372299194, 0.5906583666801453, 0.34534093737602234, 1.2076612710952758, 0.587985634803772, 0.3451167047023773, 1.2170783281326294, 0.5876038074493408, 0.3460642993450165, 1.2238045930862426, 0.5892172455787659, 0.34801024198532104, 1.2278403043746948, 0.5925304293632507, 0.35078075528144836, 1.229185700416565, 0.5972475409507751, 0.3542023301124573, 1.2278406620025634, 0.603073239326477, 0.35810136795043945, 1.2238047122955322, 0.6097117066383362, 0.3623041808605194, 1.2170783281326294, 0.6168676614761352, 0.3666372299194336, 1.207661509513855, 0.6242451071739197, 0.3709268569946289, 1.1955541372299194, 0.6315487623214722, 0.3749994933605194, 1.1807563304901123, 0.638482928276062, 0.2703440189361572, 1.1807563304901123, 0.6353943943977356, 0.2679581940174103, 1.1955541372299194, 0.6297869682312012, 0.2667457163333893, 1.2076612710952758, 0.626937210559845, 0.266572505235672, 1.2170783281326294, 0.6265300512313843, 0.2673044502735138, 1.2238045930862426, 0.6282503604888916, 0.2688075006008148, 1.2278403043746948, 0.6317830681800842, 0.27094748616218567, 1.229185700416565, 0.6368127465248108, 0.2735903561115265, 1.2278406620025634, 0.6430243253707886, 0.27660199999809265, 1.2238047122955322, 0.6501026153564453, 0.2798483371734619, 1.2170783281326294, 0.6577324271202087, 0.28319522738456726, 1.207661509513855, 0.6655986905097961, 0.28650858998298645, 1.1955541372299194, 0.67338627576828, 0.28965434432029724, 1.1807563304901123, 0.6807796955108643, 0.18494878709316254, 1.1807563304901123, 0.6645397543907165, 0.18331655859947204, 1.1955541372299194, 0.6586751341819763, 0.18248708546161651, 1.2076612710952758, 0.6556946039199829, 0.18236857652664184, 1.2170783281326294, 0.6552688479423523, 0.1828693300485611, 1.2238045930862426, 0.6570680737495422, 0.18389761447906494, 1.2278403043746948, 0.6607627868652344, 0.18536162376403808, 1.229185700416565, 0.6660230755805969, 0.18716968595981598, 1.2278406620025634, 0.6725196242332458, 0.18922999501228332, 1.2238047122955322, 0.6799226999282837, 0.19145090878009796, 1.2170783281326294, 0.6879025101661682, 0.19374056160449982, 1.207661509513855, 0.6961296200752258, 0.19600732624530792, 1.1955541372299194, 0.7042742967605591, 0.19815939664840698, 1.1807563304901123, 0.7120069265365601, 0.09457904100418091, 1.1807562112808227, 0.6825882196426392, 0.09374436736106872, 1.1955541372299194, 0.6765642166137695, 0.09332016110420227, 1.2076612710952758, 0.6735028028488159, 0.09325958788394928, 1.2170782089233398, 0.6730653643608093, 0.09351564198732376, 1.2238045930862426, 0.6749134659767151, 0.09404148906469345, 1.2278403043746948, 0.6787086129188538, 0.09479016810655594, 1.229185700416565, 0.6841118335723877, 0.0957147628068924, 1.2278404235839843, 0.6907846927642822, 0.09676837921142578, 1.2238047122955322, 0.6983887553215027, 0.09790410101413727, 1.2170782089233398, 0.7065854072570801, 0.09907500445842743, 1.207661509513855, 0.7150359749794006, 0.10023416578769684, 1.1955541372299194, 0.7234018445014954, 0.10133469849824905, 1.1807562112808227, 0.73134446144104, 1.3794195297123224e-7, 1.1807564496994018, 0.6887745261192322, 1.367246227346186e-7, 1.195554256439209, 0.6826958656311035, 1.3610593896373757e-7, 1.207661509513855, 0.6796067357063293, 1.3601756165826373e-7, 1.217078447341919, 0.6791654825210571, 1.3639103713103395e-7, 1.2238048315048217, 0.6810302734375, 1.3715796853830397e-7, 1.2278406620025634, 0.6848597526550293, 1.3824987377120124e-7, 1.2291858196258545, 0.6903119087219238, 1.395983844076909e-7, 1.227840781211853, 0.6970452666282654, 1.4113507518231927e-7, 1.2238048315048217, 0.7047183513641357, 1.427914781970685e-7, 1.217078447341919, 0.7129891514778137, 1.4449921081904904e-7, 1.207661509513855, 0.7215163111686706, 1.461898619936619e-7, 1.195554256439209, 0.7299579977989197, 1.4779494961203454e-7, 1.1807564496994018, 0.737972617149353, -0.10388048738241195, 1.1807563304901123, 0.6825882792472839, -0.10090883076190948, 1.1955541372299194, 0.6765642762184143, -0.09870291501283645, 1.2076612710952758, 0.6735028624534607, -0.09718357771635055, 1.2170783281326294, 0.6730655431747436, -0.0962715744972229, 1.2238045930862426, 0.6749136447906494, -0.09588770568370819, 1.2278403043746948, 0.6787086725234985, -0.09595274925231933, 1.229185700416565, 0.6841119527816772, -0.09638751298189163, 1.2278406620025634, 0.6907848715782165, -0.09711277484893799, 1.2238047122955322, 0.6983888745307922, -0.09804932773113251, 1.2170783281326294, 0.7065855264663696, -0.0991179496049881, 1.207661509513855, 0.7150360345840454, -0.10023944824934006, 1.1955541372299194, 0.7234019637107849, -0.1013345941901207, 1.1807563304901123, 0.7313445806503296, -0.20032313466072082, 1.1807562112808227, 0.6645397543907165, -0.1951587051153183, 1.1955541372299194, 0.6586751341819763, -0.1913842260837555, 1.2076612710952758, 0.6556946039199829, -0.18885460495948791, 1.2170782089233398, 0.6552688479423523, -0.18742462992668152, 1.2238045930862426, 0.6570679545402527, -0.1869492530822754, 1.2278403043746948, 0.6607627868652344, -0.18728332221508026, 1.229185700416565, 0.6660230755805969, -0.18828174471855163, 1.2278404235839843, 0.6725195646286011, -0.18979933857917786, 1.2238047122955322, 0.6799226403236389, -0.19169102609157562, 1.2170782089233398, 0.6879025101661682, -0.19381166994571686, 1.207661509513855, 0.6961296796798706, -0.19601614773273468, 1.1955541372299194, 0.7042742967605591, -0.198159322142601, 1.1807562112808227, 0.7120069265365601, -0.28902390599250793, 1.1807563304901123, 0.6353943347930908, -0.2823464870452881, 1.1955541372299194, 0.6297869086265564, -0.27755579352378845, 1.2076612710952758, 0.626937210559845, -0.2744530439376831, 1.2170783281326294, 0.6265299916267395, -0.27283915877342224, 1.2238045930862426, 0.628250241279602, -0.27251535654067993, 1.2278403043746948, 0.6317830681800842, -0.2732824385166168, 1.229185700416565, 0.636812686920166, -0.2749415636062622, 1.2278406620025634, 0.6430243253707886, -0.2772938013076782, 1.2238047122955322, 0.6501026153564453, -0.2801401615142822, 1.2170783281326294, 0.6577324867248535, -0.2832816541194916, 1.207661509513855, 0.6655986905097961, -0.2865193486213684, 1.1955541372299194, 0.67338627576828, -0.28965428471565246, 1.1807563304901123, 0.6807796955108643, -0.3696787357330322, 1.1807562112808227, 0.5959173440933227, -0.36206871271133423, 1.1955541372299194, 0.5906583666801453, -0.3567293882369995, 1.2076612710952758, 0.5879855751991272, -0.35341885685920715, 1.2170782089233398, 0.5876038074493408, -0.35189518332481384, 1.2238044738769531, 0.5892171263694763, -0.35191643238067627, 1.2278403043746948, 0.592530369758606, -0.35324057936668396, 1.2291855812072754, 0.5972474813461304, -0.35562586784362793, 1.2278401851654052, 0.603073239326477, -0.35883012413978576, 1.2238045930862426, 0.6097116470336914, -0.36261165142059326, 1.2170782089233398, 0.6168675422668457, -0.366728276014328, 1.2076613903045654, 0.6242451071739197, -0.3709382116794586, 1.1955541372299194, 0.6315487027168274, -0.37499943375587463, 1.1807562112808227, 0.6384828686714172, -0.4419836103916168, 1.1807564496994018, 0.5468741059303284, -0.43392229080200195, 1.195554256439209, 0.542047917842865, -0.42841681838035583, 1.2076613903045654, 0.5395951271057129, -0.4251920282840729, 1.2170783281326294, 0.5392447113990784, -0.42397257685661316, 1.2238047122955322, 0.5407252907752991, -0.4244832992553711, 1.2278403043746948, 0.5437659025192261, -0.42644867300987243, 1.2291858196258545, 0.5480948090553284, -0.4295935034751892, 1.2278406620025634, 0.553441047668457, -0.43364259600639343, 1.2238048315048217, 0.5595332384109497, -0.4383205473423004, 1.217078447341919, 0.5661001801490784, -0.443352073431015, 1.207661509513855, 0.5728706121444702, -0.44846194982528686, 1.195554256439209, 0.5795730948448181, -0.45337486267089843, 1.1807564496994018, 0.5859366059303284, -0.5056342482566833, 1.1807563304901123, 0.48902982473373413, -0.49750369787216186, 1.1955541372299194, 0.4847140908241272, -0.49212977290153503, 1.2076612710952758, 0.48252072930336, -0.48921236395835876, 1.2170783281326294, 0.48220738768577575, -0.48845136165618896, 1.2238045930862426, 0.4835314154624939, -0.4895462691783905, 1.2278403043746948, 0.4862503409385681, -0.4921970069408417, 1.229185700416565, 0.49012142419815063, -0.49610334634780884, 1.2278406620025634, 0.49490222334861755, -0.5009650588035583, 1.2238047122955322, 0.5003499388694763, -0.5064817667007446, 1.2170783281326294, 0.5062223076820373, -0.5123534798622131, 1.207661509513855, 0.5122765302658081, -0.5182798504829407, 1.1955541372299194, 0.5182701945304871, -0.5239605903625488, 1.1807563304901123, 0.523960530757904, -0.5603268146514893, 1.1807563304901123, 0.42314988374710083, -0.5524098873138428, 1.1955541372299194, 0.41941553354263305, -0.5473802089691162, 1.2076612710952758, 0.41751766204833984, -0.5449200868606567, 1.2170783281326294, 0.417246550321579, -0.5447113513946533, 1.2238045930862426, 0.418392151594162, -0.5464361906051636, 1.2278403043746948, 0.4207448363304138, -0.5497764945030212, 1.229185700416565, 0.42409437894821167, -0.5544142723083496, 1.2278406620025634, 0.4282310903072357, -0.560031533241272, 1.2238047122955322, 0.43294504284858703, -0.5663104057312012, 1.2170783281326294, 0.43802621960639953, -0.5729328989982605, 1.207661509513855, 0.4432648718357086, -0.5795809626579285, 1.1955541372299194, 0.4484509825706482, -0.5859366655349731, 1.1807563304901123, 0.45337483286857605, -0.6057570576667786, 1.1807563304901123, 0.34999942779541015, -0.5982373952865601, 1.1955541372299194, 0.34691062569618225, -0.5936799049377441, 1.2076612710952758, 0.34534087777137756, -0.5917549133300781, 1.2170783281326294, 0.34511664509773254, -0.5921327471733093, 1.2238045930862426, 0.3460642397403717, -0.5944835543632507, 1.2278403043746948, 0.34801018238067627, -0.5984775424003601, 1.229185700416565, 0.3507806956768036, -0.6037850379943848, 1.2278406620025634, 0.3542022705078125, -0.6100762486457825, 1.2238047122955322, 0.3581013083457947, -0.6170214414596558, 1.2170783281326294, 0.36230412125587463, -0.6242907047271728, 1.207661509513855, 0.3666371703147888, -0.6315545439720154, 1.1955541372299194, 0.37092679738998413, -0.6384829878807068, 1.1807563304901123, 0.37499943375587463, -0.6416211128234863, 1.1807563304901123, 0.27034395933151245, -0.6345831751823425, 1.1955541372299194, 0.2679581344127655, -0.630540668964386, 1.2076612710952758, 0.2667456567287445, -0.6291570663452148, 1.2170783281326294, 0.2665724456310272, -0.630095362663269, 1.2238045930862426, 0.267304390668869, -0.6330190300941467, 1.2278403043746948, 0.26880744099617004, -0.6375910639762878, 1.229185700416565, 0.2709474265575409, -0.643474817276001, 1.2278406620025634, 0.2735902965068817, -0.6503332853317261, 1.2238047122955322, 0.2766019403934479, -0.6578298211097717, 1.2170783281326294, 0.27984827756881714, -0.665627658367157, 1.207661509513855, 0.2831951677799225, -0.6733899116516113, 1.1955541372299194, 0.2865085303783417, -0.680779755115509, 1.1807563304901123, 0.28965428471565246, -0.6676146388053894, 1.1807563304901123, 0.18494874238967895, -0.6610435843467712, 1.1955541372299194, 0.18331649899482727, -0.6574740409851074, 1.2076612710952758, 0.18248702585697174, -0.6565660238265991, 1.2170783281326294, 0.18236851692199707, -0.6579791307449341, 1.2238045930862426, 0.18286927044391632, -0.6613731384277344, 1.2278403043746948, 0.18389755487442016, -0.6664075255393982, 1.229185700416565, 0.1853615641593933, -0.6727420687675476, 1.2278406620025634, 0.1871696263551712, -0.6800365447998047, 1.2238047122955322, 0.18922993540763855, -0.6879505515098572, 1.2170783281326294, 0.19145084917545318, -0.6961439251899719, 1.207661509513855, 0.19374050199985504, -0.7042760848999023, 1.1955541372299194, 0.19600726664066315, -0.7120069861412048, 1.1807563304901123, 0.1981593519449234, -0.6834338903427124, 1.1807562112808227, 0.09457898885011673, -0.6772156357765198, 1.1955541372299194, 0.09374431520700455, -0.6739922761917114, 1.2076612710952758, 0.09332010895013809, -0.6734222769737244, 1.2170782089233398, 0.0932595357298851, -0.6751641035079956, 1.2238045930862426, 0.09351558983325958, -0.678876519203186, 1.2278403043746948, 0.09404143691062927, -0.6842175126075745, 1.229185700416565, 0.09479011595249176, -0.6908459663391113, 1.2278404235839843, 0.09571471065282821, -0.6984201669692993, 1.2238047122955322, 0.0967683270573616, -0.7065986394882202, 1.2170782089233398, 0.09790404886007309, -0.7150399684906006, 1.207661509513855, 0.09907495230436325, -0.7234023809432983, 1.1955541372299194, 0.10023411363363266, -0.7313445210456848, 1.1807562112808227, 0.10133464634418487, -0.688774585723877, 1.1807564496994018, 8.632945025510707e-8, -0.6826959252357483, 1.195554256439209, 8.446528454442159e-8, -0.6796067953109741, 1.207661509513855, 8.331737433309172e-8, -0.6791655421257019, 1.217078447341919, 8.281736540993734e-8, -0.6810303330421448, 1.2238048315048217, 8.289683250950475e-8, -0.6848598122596741, 1.2278406620025634, 8.348735036634025e-8, -0.6903119683265686, 1.2291858196258545, 8.452045108242601e-8, -0.6970453262329102, 1.227840781211853, 8.592775913029982e-8, -0.7047184109687805, 1.2238048315048217, 8.764087056079006e-8, -0.7129892110824585, 1.217078447341919, 8.959128194874211e-8, -0.7215163707733154, 1.207661509513855, 9.171064618840319e-8, -0.7299580574035644, 1.195554256439209, 9.39305238034649e-8, -0.7379726767539978, 1.1807564496994018, 9.618244689590938e-8, -0.6825883388519287, 1.1807563304901123, -0.09457901120185852, -0.6765643358230591, 1.1955541372299194, -0.09374433010816574, -0.6735029220581055, 1.2076612710952758, -0.09332013875246048, -0.6730656027793884, 1.2170783281326294, -0.0932595506310463, -0.6749137043952942, 1.2238045930862426, -0.09351562708616257, -0.6787087321281433, 1.2278403043746948, -0.09404144436120987, -0.684112012386322, 1.229185700416565, -0.09479011595249176, -0.6907849311828613, 1.2278406620025634, -0.09571471810340881, -0.698388934135437, 1.2238047122955322, -0.0967683270573616, -0.7065855860710144, 1.2170783281326294, -0.09790404886007309, -0.7150360941886902, 1.207661509513855, -0.09907493740320205, -0.7234020233154297, 1.1955541372299194, -0.10023412108421325, -0.7313446402549744, 1.1807563304901123, -0.10133464634418487, -0.6645398139953613, 1.1807562112808227, -0.18494875729084015, -0.6586751937866211, 1.1955541372299194, -0.18331655859947204, -0.6556946635246277, 1.2076612710952758, -0.18248705565929413, -0.6552689075469971, 1.2170782089233398, -0.18236857652664184, -0.6570680141448975, 1.2238045930862426, -0.1828693151473999, -0.6607628464698791, 1.2278403043746948, -0.18389756977558136, -0.6660231351852417, 1.229185700416565, -0.1853615790605545, -0.6725196242332458, 1.2278404235839843, -0.1871696263551712, -0.6799226999282837, 1.2238047122955322, -0.18922996520996094, -0.687902569770813, 1.2170782089233398, -0.19145084917545318, -0.6961297392845154, 1.207661509513855, -0.19374054670333862, -0.7042743563652039, 1.1955541372299194, -0.19600729644298553, -0.7120069861412048, 1.1807562112808227, -0.1981593668460846, -0.6353943943977356, 1.1807563304901123, -0.2703440487384796, -0.6297869682312012, 1.1955541372299194, -0.2679581940174103, -0.6269372701644897, 1.2076612710952758, -0.2667457163333893, -0.6265300512313843, 1.2170783281326294, -0.2665725350379944, -0.6282503008842468, 1.2238045930862426, -0.2673044502735138, -0.631783127784729, 1.2278403043746948, -0.2688075006008148, -0.6368127465248108, 1.229185700416565, -0.27094751596450805, -0.6430243849754333, 1.2278406620025634, -0.2735903561115265, -0.6501026749610901, 1.2238047122955322, -0.27660199999809265, -0.6577325463294983, 1.2170783281326294, -0.2798483669757843, -0.6655987501144409, 1.207661509513855, -0.28319522738456726, -0.6733863353729248, 1.1955541372299194, -0.28650861978530884, -0.680779755115509, 1.1807563304901123, -0.28965434432029724, -0.5959174036979675, 1.1807562112808227, -0.3499995172023773, -0.59065842628479, 1.1955541372299194, -0.3469107151031494, -0.587985634803772, 1.2076612710952758, -0.3453409671783447, -0.5876038670539856, 1.2170782089233398, -0.3451167047023773, -0.5892171859741211, 1.2238044738769531, -0.34606432914733886, -0.5925304293632507, 1.2278403043746948, -0.34801024198532104, -0.5972475409507751, 1.2291855812072754, -0.35078075528144836, -0.6030732989311218, 1.2278401851654052, -0.35420235991477966, -0.6097117066383362, 1.2238045930862426, -0.35810136795043945, -0.6168676018714905, 1.2170782089233398, -0.3623041808605194, -0.6242451667785644, 1.2076613903045654, -0.3666372299194336, -0.6315487623214722, 1.1955541372299194, -0.3709268569946289, -0.638482928276062, 1.1807562112808227, -0.3749994933605194, -0.5468741655349731, 1.1807564496994018, -0.4231500029563904, -0.5420479774475098, 1.195554256439209, -0.4194156527519226, -0.5395951867103577, 1.2076613903045654, -0.4175177812576294, -0.5392447710037231, 1.2170783281326294, -0.41724666953086853, -0.5407253503799438, 1.2238047122955322, -0.41839227080345154, -0.5437659621238708, 1.2278403043746948, -0.42074495553970337, -0.5480948686599731, 1.2291858196258545, -0.4240944981575012, -0.5534411072731018, 1.2278406620025634, -0.42823120951652527, -0.5595332980155945, 1.2238048315048217, -0.4329451620578766, -0.5661002397537231, 1.217078447341919, -0.4380263388156891, -0.572870671749115, 1.207661509513855, -0.4432649314403534, -0.5795731544494629, 1.195554256439209, -0.44845107197761535, -0.5859366655349731, 1.1807564496994018, -0.4533749222755432, -0.4890298843383789, 1.1807563304901123, -0.4890299439430237, -0.484714150428772, 1.1955541372299194, -0.48471421003341675, -0.48252078890800476, 1.2076612710952758, -0.4825209081172943, -0.48220744729042053, 1.2170783281326294, -0.4822075068950653, -0.48353147506713867, 1.2238045930862426, -0.48353153467178344, -0.4862504005432129, 1.2278403043746948, -0.48625046014785766, -0.4901214838027954, 1.229185700416565, -0.4901215434074402, -0.49490228295326233, 1.2278406620025634, -0.49490228295326233, -0.5003499984741211, 1.2238047122955322, -0.5003500580787659, -0.5062223672866821, 1.2170783281326294, -0.5062224268913269, -0.5122765898704529, 1.207661509513855, -0.5122766494750977, -0.5182702541351318, 1.1955541372299194, -0.5182703137397766, -0.5239605903625488, 1.1807563304901123, -0.5239606499671936, -0.4231499433517456, 1.1807563304901123, -0.5468742251396179, -0.41941559314727783, 1.1955541372299194, -0.5420480370521545, -0.4175177216529846, 1.2076612710952758, -0.5395952463150024, -0.41724660992622375, 1.2170783281326294, -0.5392448306083679, -0.41839221119880676, 1.2238045930862426, -0.5407254099845886, -0.4207448959350586, 1.2278403043746948, -0.5437660217285156, -0.42409443855285644, 1.229185700416565, -0.5480949282646179, -0.4282311499118805, 1.2278406620025634, -0.5534411668777466, -0.4329451024532318, 1.2238047122955322, -0.5595333576202393, -0.4380262792110443, 1.2170783281326294, -0.5661002993583679, -0.4432649314403534, 1.207661509513855, -0.5728707313537598, -0.44845104217529297, 1.1955541372299194, -0.5795732140541077, -0.4533748924732208, 1.1807563304901123, -0.5859367251396179, -0.34999948740005493, 1.1807563304901123, -0.5959174633026123, -0.346910685300827, 1.1955541372299194, -0.5906584858894348, -0.34534093737602234, 1.2076612710952758, -0.5879857540130615, -0.3451167047023773, 1.2170783281326294, -0.5876039266586304, -0.3460642993450165, 1.2238045930862426, -0.5892173647880554, -0.34801024198532104, 1.2278403043746948, -0.5925305485725403, -0.35078075528144836, 1.229185700416565, -0.5972476601600647, -0.3542023301124573, 1.2278406620025634, -0.6030733585357666, -0.35810136795043945, 1.2238047122955322, -0.6097118258476257, -0.3623041808605194, 1.2170783281326294, -0.6168677806854248, -0.3666372299194336, 1.207661509513855, -0.6242452263832092, -0.3709268569946289, 1.1955541372299194, -0.6315488815307617, -0.3749994933605194, 1.1807563304901123, -0.6384830474853516, -0.2703440189361572, 1.1807563304901123, -0.6353945136070251, -0.2679581940174103, 1.1955541372299194, -0.6297870874404907, -0.2667457163333893, 1.2076612710952758, -0.6269373297691345, -0.266572505235672, 1.2170783281326294, -0.6265301704406738, -0.2673044502735138, 1.2238045930862426, -0.6282504796981811, -0.2688075006008148, 1.2278403043746948, -0.6317831873893738, -0.27094748616218567, 1.229185700416565, -0.6368128657341003, -0.2735903561115265, 1.2278406620025634, -0.6430244445800781, -0.27660199999809265, 1.2238047122955322, -0.6501027345657349, -0.2798483371734619, 1.2170783281326294, -0.6577325463294983, -0.28319522738456726, 1.207661509513855, -0.6655988097190857, -0.28650858998298645, 1.1955541372299194, -0.6733863949775696, -0.28965434432029724, 1.1807563304901123, -0.6807798147201538, -0.18494878709316254, 1.1807563304901123, -0.6645398736000061, -0.18331655859947204, 1.1955541372299194, -0.6586752533912659, -0.18248708546161651, 1.2076612710952758, -0.6556947231292725, -0.18236857652664184, 1.2170783281326294, -0.6552689671516418, -0.1828693300485611, 1.2238045930862426, -0.6570681929588318, -0.18389761447906494, 1.2278403043746948, -0.6607629060745239, -0.18536162376403808, 1.229185700416565, -0.6660231947898865, -0.18716968595981598, 1.2278406620025634, -0.6725197434425354, -0.18922999501228332, 1.2238047122955322, -0.6799228191375732, -0.19145090878009796, 1.2170783281326294, -0.6879026293754578, -0.19374056160449982, 1.207661509513855, -0.6961297392845154, -0.19600732624530792, 1.1955541372299194, -0.7042744159698486, -0.19815939664840698, 1.1807563304901123, -0.7120070457458496, -0.09457904100418091, 1.1807562112808227, -0.6825883388519287, -0.09374436736106872, 1.1955541372299194, -0.6765643358230591, -0.09332016110420227, 1.2076612710952758, -0.6735029220581055, -0.09325958788394928, 1.2170782089233398, -0.6730654835700989, -0.09351564198732376, 1.2238045930862426, -0.6749135851860046, -0.09404148906469345, 1.2278403043746948, -0.6787087321281433, -0.09479016810655594, 1.229185700416565, -0.6841119527816772, -0.0957147628068924, 1.2278404235839843, -0.6907848119735718, -0.09676837921142578, 1.2238047122955322, -0.6983888745307922, -0.09790410101413727, 1.2170782089233398, -0.7065855264663696, -0.09907500445842743, 1.207661509513855, -0.7150360941886902, -0.10023416578769684, 1.1955541372299194, -0.7234019637107849, -0.10133469849824905, 1.1807562112808227, -0.7313445806503296, -1.3794195297123224e-7, 1.1807564496994018, -0.6887746453285217, -1.367246227346186e-7, 1.195554256439209, -0.6826959848403931, -1.3610593896373757e-7, 1.207661509513855, -0.6796068549156189, -1.3601756165826373e-7, 1.217078447341919, -0.6791656017303467, -1.3639103713103395e-7, 1.2238048315048217, -0.6810303926467895, -1.3715796853830397e-7, 1.2278406620025634, -0.6848598718643188, -1.3824987377120124e-7, 1.2291858196258545, -0.6903120279312134, -1.395983844076909e-7, 1.227840781211853, -0.6970453858375549, -1.4113507518231927e-7, 1.2238048315048217, -0.7047184705734253, -1.427914781970685e-7, 1.217078447341919, -0.7129892706871033, -1.4449921081904904e-7, 1.207661509513855, -0.7215164303779602, -1.461898619936619e-7, 1.195554256439209, -0.7299581170082092, -1.4779494961203454e-7, 1.1807564496994018, -0.7379727363586426, 0.09457895904779434, 1.1807563304901123, -0.6825883984565735, 0.09374427795410156, 1.1955541372299194, -0.6765643954277039, 0.0933200865983963, 1.2076612710952758, -0.6735029816627502, 0.09325949847698211, 1.2170783281326294, -0.6730656623840332, 0.09351557493209839, 1.2238045930862426, -0.674913763999939, 0.09404139220714569, 1.2278403043746948, -0.6787087917327881, 0.09479006379842758, 1.229185700416565, -0.6841120719909668, 0.09571466594934463, 1.2278406620025634, -0.6907849907875061, 0.09676827490329742, 1.2238047122955322, -0.6983889937400818, 0.09790399670600891, 1.2170783281326294, -0.7065856456756592, 0.09907488524913788, 1.207661509513855, -0.715036153793335, 0.10023406893014908, 1.1955541372299194, -0.7234020829200745, 0.1013345941901207, 1.1807563304901123, -0.7313446998596191, 0.18494871258735657, 1.1807562112808227, -0.6645398736000061, 0.18331649899482727, 1.1955541372299194, -0.6586752533912659, 0.18248699605464935, 1.2076612710952758, -0.6556947231292725, 0.18236851692199707, 1.2170782089233398, -0.6552689671516418, 0.18286925554275513, 1.2238045930862426, -0.6570680737495422, 0.18389751017093658, 1.2278403043746948, -0.6607629060745239, 0.18536151945590973, 1.229185700416565, -0.6660231947898865, 0.18716956675052643, 1.2278404235839843, -0.6725196838378906, 0.18922990560531616, 1.2238047122955322, -0.6799227595329285, 0.1914507895708084, 1.2170782089233398, -0.6879026293754578, 0.19374048709869385, 1.207661509513855, -0.6961297988891602, 0.19600723683834076, 1.1955541372299194, -0.7042744159698486, 0.198159322142601, 1.1807562112808227, -0.7120070457458496, 0.27034398913383484, 1.1807563304901123, -0.6353944540023804, 0.2679581344127655, 1.1955541372299194, -0.629787027835846, 0.2667456567287445, 1.2076612710952758, -0.6269373297691345, 0.2665724754333496, 1.2170783281326294, -0.626530110836029, 0.267304390668869, 1.2238045930862426, -0.6282503604888916, 0.26880744099617004, 1.2278403043746948, -0.6317831873893738, 0.2709474563598633, 1.229185700416565, -0.6368128061294556, 0.2735902965068817, 1.2278406620025634, -0.6430244445800781, 0.2766019403934479, 1.2238047122955322, -0.6501027345657349, 0.2798483073711395, 1.2170783281326294, -0.6577326059341431, 0.2831951677799225, 1.207661509513855, -0.6655988097190857, 0.28650856018066406, 1.1955541372299194, -0.6733863949775696, 0.28965428471565246, 1.1807563304901123, -0.6807798147201538, 0.34999945759773254, 1.1807562112808227, -0.5959174633026123, 0.34691065549850464, 1.1955541372299194, -0.5906584858894348, 0.34534090757369995, 1.2076612710952758, -0.5879856944084167, 0.34511664509773254, 1.2170782089233398, -0.5876039266586304, 0.3460642695426941, 1.2238044738769531, -0.5892172455787659, 0.34801018238067627, 1.2278403043746948, -0.5925304889678955, 0.3507806956768036, 1.2291855812072754, -0.5972476005554199, 0.3542023003101349, 1.2278401851654052, -0.6030733585357666, 0.3581013083457947, 1.2238045930862426, -0.609711766242981, 0.36230412125587463, 1.2170782089233398, -0.6168676614761352, 0.3666371703147888, 1.2076613903045654, -0.6242452263832092, 0.37092679738998413, 1.1955541372299194, -0.6315488219261169, 0.37499943375587463, 1.1807562112808227, -0.6384829878807068, 0.4231499433517456, 1.1807564496994018, -0.5468742251396179, 0.41941559314727783, 1.195554256439209, -0.5420480370521545, 0.4175177216529846, 1.2076613903045654, -0.5395952463150024, 0.41724660992622375, 1.2170783281326294, -0.5392448306083679, 0.41839221119880676, 1.2238047122955322, -0.5407254099845886, 0.4207448959350586, 1.2278403043746948, -0.5437660217285156, 0.42409443855285644, 1.2291858196258545, -0.5480949282646179, 0.4282311499118805, 1.2278406620025634, -0.5534411668777466, 0.4329451024532318, 1.2238048315048217, -0.5595333576202393, 0.4380262792110443, 1.217078447341919, -0.5661002993583679, 0.4432648718357086, 1.207661509513855, -0.5728707313537598, 0.4484510123729706, 1.195554256439209, -0.5795732140541077, 0.45337486267089843, 1.1807564496994018, -0.5859367251396179, 0.4890298843383789, 1.1807563304901123, -0.4890299439430237, 0.484714150428772, 1.1955541372299194, -0.48471421003341675, 0.48252084851264953, 1.2076612710952758, -0.48252084851264953, 0.48220744729042053, 1.2170783281326294, -0.4822075068950653, 0.48353147506713867, 1.2238045930862426, -0.48353153467178344, 0.4862504005432129, 1.2278403043746948, -0.48625046014785766, 0.4901214838027954, 1.229185700416565, -0.4901215434074402, 0.49490222334861755, 1.2278406620025634, -0.4949023425579071, 0.5003499984741211, 1.2238047122955322, -0.5003500580787659, 0.5062223672866821, 1.2170783281326294, -0.5062224268913269, 0.5122765898704529, 1.207661509513855, -0.5122766494750977, 0.5182702541351318, 1.1955541372299194, -0.5182703137397766, 0.5239605903625488, 1.1807563304901123, -0.5239606499671936, 0.5468741655349731, 1.1807563304901123, -0.4231500029563904, 0.5420479774475098, 1.1955541372299194, -0.4194156527519226, 0.5395951867103577, 1.2076612710952758, -0.4175177812576294, 0.5392447710037231, 1.2170783281326294, -0.41724666953086853, 0.5407253503799438, 1.2238045930862426, -0.41839227080345154, 0.5437659621238708, 1.2278403043746948, -0.42074495553970337, 0.5480948686599731, 1.229185700416565, -0.4240944981575012, 0.5534411072731018, 1.2278406620025634, -0.42823120951652527, 0.5595332980155945, 1.2238047122955322, -0.4329451620578766, 0.5661002397537231, 1.2170783281326294, -0.4380263388156891, 0.572870671749115, 1.207661509513855, -0.44326499104499817, 0.5795731544494629, 1.1955541372299194, -0.44845110177993774, 0.5859366655349731, 1.1807563304901123, -0.4533749520778656, 0.5959174036979675, 1.1807563304901123, -0.3499995470046997, 0.59065842628479, 1.1955541372299194, -0.3469107449054718, 0.5879856944084167, 1.2076612710952758, -0.3453409969806671, 0.5876038670539856, 1.2170783281326294, -0.3451167643070221, 0.5892173051834106, 1.2238045930862426, -0.34606435894966125, 0.5925304889678955, 1.2278403043746948, -0.3480103015899658, 0.5972476005554199, 1.229185700416565, -0.35078081488609314, 0.6030732989311218, 1.2278406620025634, -0.35420238971710205, 0.609711766242981, 1.2238047122955322, -0.35810142755508423, 0.61686772108078, 1.2170783281326294, -0.3623042404651642, 0.6242451667785644, 1.207661509513855, -0.36663728952407837, 0.6315488219261169, 1.1955541372299194, -0.3709269165992737, 0.6384829878807068, 1.1807563304901123, -0.3749995529651642, 0.6353944540023804, 1.1807563304901123, -0.270344078540802, 0.629787027835846, 1.1955541372299194, -0.26795825362205505, 0.6269372701644897, 1.2076612710952758, -0.26674577593803405, 0.626530110836029, 1.2170783281326294, -0.2665725648403168, 0.6282504200935364, 1.2238045930862426, -0.26730450987815857, 0.631783127784729, 1.2278403043746948, -0.2688075602054596, 0.6368128061294556, 1.229185700416565, -0.27094754576683044, 0.6430243849754333, 1.2278406620025634, -0.27359041571617126, 0.6501026749610901, 1.2238047122955322, -0.2766020596027374, 0.6577324867248535, 1.2170783281326294, -0.2798483967781067, 0.6655987501144409, 1.207661509513855, -0.28319528698921203, 0.6733863353729248, 1.1955541372299194, -0.2865086495876312, 0.680779755115509, 1.1807563304901123, -0.289654403924942, 0.6645398139953613, 1.1807563304901123, -0.18494883179664612, 0.6586751937866211, 1.1955541372299194, -0.18331661820411682, 0.6556946635246277, 1.2076612710952758, -0.1824871450662613, 0.6552689075469971, 1.2170783281326294, -0.18236863613128662, 0.657068133354187, 1.2238045930862426, -0.18286938965320587, 0.6607628464698791, 1.2278403043746948, -0.18389767408370972, 0.6660231351852417, 1.229185700416565, -0.18536168336868286, 0.6725196838378906, 1.2278406620025634, -0.18716974556446075, 0.6799227595329285, 1.2238047122955322, -0.1892300546169281, 0.687902569770813, 1.2170783281326294, -0.19145096838474274, 0.6961296796798706, 1.207661509513855, -0.1937406212091446, 0.7042743563652039, 1.1955541372299194, -0.1960073858499527, 0.7120069861412048, 1.1807563304901123, -0.19815944135189056, 0.6825882792472839, 1.1807562112808227, -0.09457909315824508, 0.6765642762184143, 1.1955541372299194, -0.0937444195151329, 0.6735028624534607, 1.2076612710952758, -0.09332021325826645, 0.6730654239654541, 1.2170782089233398, -0.09325964003801346, 0.6749135255813599, 1.2238045930862426, -0.09351569414138794, 0.6787086725234985, 1.2278403043746948, -0.09404154121875763, 0.6841118931770325, 1.229185700416565, -0.09479022026062012, 0.690784752368927, 1.2278404235839843, -0.09571481496095657, 0.6983888149261475, 1.2238047122955322, -0.09676843136548996, 0.7065854668617248, 1.2170782089233398, -0.09790415316820144, 0.7150360345840454, 1.207661509513855, -0.09907505661249161, 0.7234019041061401, 1.1955541372299194, -0.10023421794176101, 0.7313445210456848, 1.1807562112808227, -0.10133475065231323, 0.7686504125595093, 1.116205096244812, -4.879087356357559e-8, 0.7989009022712707, 1.0517817735671997, -4.597483993507012e-8, 0.8282974362373352, 0.9876150488853455, -4.317002577636231e-8, 0.8564126491546631, 0.9238322973251343, -4.038199463707315e-8, 0.8828197717666626, 0.8605623245239258, -3.761637401566986e-8, 0.9070914387702942, 0.7979329228401184, -3.487875588348288e-8, 0.9288005828857422, 0.7360722422599792, -3.2174742869983674e-8, 0.9475204348564148, 0.6751083731651306, -2.9509925170145834e-8, 0.962823748588562, 0.6151694059371948, -2.6889910742511347e-8, 0.9742833375930786, 0.5563836097717285, -2.4320300440194842e-8, 0.981472373008728, 0.49887901544570923, -2.1806695116310948e-8, 0.9839635491371155, 0.4427835941314697, -1.9354686742190097e-8, 0.7617469429969788, 1.116205096244812, 0.10554704815149307, 0.7917256951332092, 1.0517817735671997, 0.10970090329647064, 0.8208582401275635, 0.9876150488853455, 0.11373747140169143, 0.848720908164978, 0.9238325357437134, 0.11759812384843826, 0.8748908042907715, 0.8605623245239258, 0.12122420966625213, 0.8989444375038147, 0.7979329824447632, 0.12455706298351288, 0.9204586744308472, 0.7360722422599792, 0.1275380551815033, 0.9390104413032532, 0.6751084327697754, 0.13010857999324798, 0.9541763067245483, 0.6151694655418396, 0.13220994174480438, 0.9655328989028931, 0.5563836097717285, 0.13378353416919708, 0.9726573824882507, 0.49887901544570923, 0.1347706913948059, 0.9751262068748474, 0.4427835941314697, 0.13511277735233307, 0.741605281829834, 1.116205096244812, 0.20639680325984955, 0.7707914113998413, 1.0517817735671997, 0.2145196497440338, 0.7991536259651184, 0.9876149296760559, 0.22241313755512237, 0.8262795805931091, 0.9238322973251343, 0.22996260225772858, 0.8517574667930603, 0.8605623245239258, 0.23705339431762695, 0.8751751184463501, 0.7979328632354736, 0.24357080459594726, 0.8961204886436462, 0.7360720634460449, 0.24940013885498047, 0.9141817092895508, 0.6751083135604858, 0.2544267773628235, 0.9289464950561523, 0.61516934633255, 0.2585359513759613, 0.9400028586387634, 0.5563835501670837, 0.2616131007671356, 0.9469389915466309, 0.49887895584106445, 0.2635434567928314, 0.9493424892425537, 0.44278356432914734, 0.26421239972114563, 0.7090799808502197, 1.116205096244812, 0.30169519782066345, 0.736985981464386, 1.0517817735671997, 0.3135685622692108, 0.7641043066978455, 0.9876150488853455, 0.3251067101955414, 0.7900406122207642, 0.9238322973251343, 0.3361419439315796, 0.8144012689590454, 0.8605623245239258, 0.3465067148208618, 0.8367918133735657, 0.7979329228401184, 0.3560333251953125, 0.856818675994873, 0.7360721826553345, 0.36455416679382324, 0.8740876317024231, 0.6751083135604858, 0.3719016909599304, 0.8882048726081848, 0.6151694059371948, 0.37790825963020324, 0.8987764120101929, 0.5563836097717285, 0.38240620493888855, 0.9054082036018372, 0.49887898564338684, 0.38522785902023315, 0.9077064394950867, 0.4427835941314697, 0.38620567321777343, 0.6650247573852539, 1.116205096244812, 0.3905881941318512, 0.6911971569061279, 1.0517817735671997, 0.40595993399620056, 0.7166306376457214, 0.9876149296760559, 0.4208977520465851, 0.7409554123878479, 0.9238321185112, 0.4351844787597656, 0.7638024687767029, 0.860562264919281, 0.44860315322875976, 0.7848020195960998, 0.7979328632354736, 0.4609367847442627, 0.8035845160484314, 0.7360720634460449, 0.47196829319000244, 0.8197805881500244, 0.6751083135604858, 0.4814806878566742, 0.8330206871032715, 0.61516934633255, 0.48925700783729553, 0.8429353833198547, 0.5563835501670837, 0.49508023262023926, 0.8491551876068115, 0.49887898564338684, 0.4987333416938782, 0.8513105511665344, 0.4427835941314697, 0.4999992251396179, 0.6102942228317261, 1.1162052154541015, 0.4722217619419098, 0.6343125104904175, 1.0517820119857788, 0.4908061921596527, 0.6576527953147888, 0.9876150488853455, 0.5088660717010498, 0.679975688457489, 0.9238325357437134, 0.5261386632919311, 0.7009423971176147, 0.8605625033378601, 0.5423620343208313, 0.7202138304710388, 0.7979329824447632, 0.557273268699646, 0.7374504208564758, 0.7360722422599792, 0.5706104040145874, 0.7523136734962463, 0.6751084327697754, 0.5821109414100647, 0.764464259147644, 0.6151694059371948, 0.5915125608444214, 0.773563027381897, 0.5563836097717285, 0.5985528826713562, 0.7792708873748779, 0.4988790452480316, 0.6029693484306335, 0.7812488675117493, 0.4427836239337921, 0.6044998168945312, 0.5457417368888855, 1.116205096244812, 0.5457416772842407, 0.5672197341918945, 1.0517817735671997, 0.5672196745872498, 0.588091254234314, 0.9876150488853455, 0.5880911946296692, 0.6080530285835266, 0.9238322973251343, 0.6080529689788818, 0.6268020868301392, 0.8605623245239258, 0.6268020272254944, 0.6440349221229553, 0.7979329228401184, 0.6440348625183105, 0.6594484448432922, 0.7360722422599792, 0.6594483852386475, 0.672739565372467, 0.6751083731651306, 0.672739565372467, 0.6836047768592834, 0.6151694655418396, 0.6836047768592834, 0.6917412281036377, 0.5563836693763733, 0.6917412281036377, 0.6968454718589783, 0.4988790452480316, 0.6968454718589783, 0.6986141800880432, 0.4427836239337921, 0.6986141800880432, 0.47222182154655456, 1.116205096244812, 0.6102941632270813, 0.4908062517642975, 1.0517817735671997, 0.6343123912811279, 0.5088661313056946, 0.9876150488853455, 0.657652735710144, 0.5261387228965759, 0.9238325357437134, 0.6799756288528442, 0.5423620343208313, 0.8605623841285706, 0.70094233751297, 0.5572733283042908, 0.797933042049408, 0.7202137112617493, 0.5706104636192322, 0.736072301864624, 0.737450361251831, 0.5821109414100647, 0.6751083731651306, 0.7523135542869568, 0.5915125608444214, 0.6151694655418396, 0.764464259147644, 0.5985528826713562, 0.5563836097717285, 0.7735629081726074, 0.6029693484306335, 0.4988790452480316, 0.7792708277702331, 0.6044998168945312, 0.4427836239337921, 0.7812488079071045, 0.39058831334114074, 1.116205096244812, 0.6650248169898987, 0.4059600830078125, 1.0517817735671997, 0.6911972165107727, 0.420897901058197, 0.9876151084899902, 0.7166305780410767, 0.4351845681667328, 0.923832356929779, 0.7409554719924927, 0.44860324263572693, 0.8605623841285706, 0.7638024687767029, 0.46093690395355224, 0.7979329824447632, 0.7848020195960998, 0.471968412399292, 0.736072301864624, 0.8035845160484314, 0.48148083686828613, 0.6751084327697754, 0.8197805881500244, 0.4892570972442627, 0.6151694655418396, 0.8330207467079163, 0.4950803816318512, 0.5563836693763733, 0.8429355621337891, 0.49873337149620056, 0.4988790452480316, 0.8491553068161011, 0.4999993145465851, 0.4427836239337921, 0.851310670375824, 0.3016953766345978, 1.116205096244812, 0.709079921245575, 0.31356871128082275, 1.0517817735671997, 0.7369859218597412, 0.32510682940483093, 0.9876151084899902, 0.7641042470932007, 0.33614203333854675, 0.923832356929779, 0.7900405526161194, 0.3465067744255066, 0.8605623841285706, 0.8144012093544006, 0.3560335040092468, 0.7979329228401184, 0.8367917537689209, 0.36455437541007995, 0.736072301864624, 0.8568186163902283, 0.37190183997154236, 0.6751083731651306, 0.8740876317024231, 0.3779083490371704, 0.6151694059371948, 0.8882048726081848, 0.38240623474121093, 0.5563836097717285, 0.8987764120101929, 0.3852279484272003, 0.4988790452480316, 0.9054082036018372, 0.386205792427063, 0.4427836239337921, 0.9077064394950867, 0.20639696717262268, 1.116205096244812, 0.741605281829834, 0.21451981365680694, 1.0517817735671997, 0.7707913517951965, 0.2224133163690567, 0.9876151084899902, 0.7991535663604736, 0.2299627661705017, 0.923832356929779, 0.8262795209884643, 0.23705357313156128, 0.8605623841285706, 0.8517574071884155, 0.2435709685087204, 0.7979329228401184, 0.8751750588417053, 0.2494003027677536, 0.7360722422599792, 0.8961206078529358, 0.2544269263744354, 0.6751083731651306, 0.9141817092895508, 0.25853610038757324, 0.6151694059371948, 0.9289466142654419, 0.26161324977874756, 0.5563836097717285, 0.940002977848053, 0.26354360580444336, 0.49887898564338684, 0.9469390511512756, 0.26421257853507995, 0.4427835941314697, 0.9493425488471985, 0.1055472195148468, 1.116205096244812, 0.7617467641830444, 0.10970107465982437, 1.0517817735671997, 0.7917254567146301, 0.11373765021562576, 0.9876149892807007, 0.8208581209182739, 0.1175982803106308, 0.923832356929779, 0.8487208485603332, 0.12122437357902527, 0.8605623841285706, 0.8748906850814819, 0.12455723434686661, 0.7979329824447632, 0.8989443182945251, 0.12753824889659881, 0.7360722422599792, 0.9204586148262024, 0.13010874390602112, 0.6751084327697754, 0.9390103816986084, 0.13221010565757751, 0.6151694059371948, 0.954176127910614, 0.13378368318080902, 0.5563836097717285, 0.9655328989028931, 0.13477084040641785, 0.4988790452480316, 0.9726572632789612, 0.135112926363945, 0.4427836239337921, 0.9751261472702026, 1.5393884211789555e-7, 1.1162052154541015, 0.7686503529548645, 1.5999717106751632e-7, 1.0517818927764892, 0.798900842666626, 1.6588447238063963e-7, 0.9876151084899902, 0.8282973766326904, 1.7151513986846112e-7, 0.9238324165344238, 0.8564125895500183, 1.7680372366157826e-7, 0.8605625629425049, 0.8828197121620178, 1.816646459928961e-7, 0.797933042049408, 0.9070913791656494, 1.860124001495933e-7, 0.7360722422599792, 0.9288005232810974, 1.8976145099713903e-7, 0.6751083731651306, 0.9475204348564148, 1.9282627761185722e-7, 0.6151694655418396, 0.962823748588562, 1.9512130222665291e-7, 0.5563836693763733, 0.9742833375930786, 1.9656103233955946e-7, 0.49887898564338684, 0.9814723134040832, 1.970599612377555e-7, 0.4427835941314697, 0.9839635491371155, -0.10554710030555725, 1.116205096244812, 0.761746883392334, -0.10970094799995422, 1.0517817735671997, 0.7917256355285644, -0.11373751610517502, 0.9876151084899902, 0.8208581805229187, -0.11759816110134125, 0.9238325953483581, 0.8487208485603332, -0.12122424691915512, 0.8605623841285706, 0.8748907446861267, -0.12455710023641586, 0.797933042049408, 0.8989443778991699, -0.12753808498382568, 0.736072301864624, 0.9204586148262024, -0.13010860979557037, 0.6751084923744202, 0.9390104413032532, -0.13220997154712677, 0.6151695251464844, 0.9541763067245483, -0.13378356397151947, 0.5563836693763733, 0.9655328989028931, -0.1347707062959671, 0.4988790452480316, 0.9726573824882507, -0.13511279225349426, 0.4427836239337921, 0.9751262068748474, -0.20639684796333313, 1.116205096244812, 0.7416052222251892, -0.2145196944475174, 1.0517817735671997, 0.7707913517951965, -0.22241318225860596, 0.9876149892807007, 0.7991535663604736, -0.22996264696121216, 0.923832356929779, 0.8262795209884643, -0.23705343902111053, 0.8605623841285706, 0.8517574071884155, -0.24357083439826965, 0.7979329228401184, 0.8751750588417053, -0.24940016865730286, 0.7360721230506897, 0.8961204290390015, -0.2544268071651459, 0.6751083731651306, 0.9141817092895508, -0.2585359811782837, 0.6151694059371948, 0.9289464950561523, -0.261613130569458, 0.5563836097717285, 0.9400028586387634, -0.2635434865951538, 0.49887898564338684, 0.9469389915466309, -0.264212429523468, 0.4427835941314697, 0.9493424892425537, -0.3016952574253082, 1.116205096244812, 0.709079921245575, -0.3135686218738556, 1.0517817735671997, 0.7369859218597412, -0.32510673999786377, 0.9876151084899902, 0.7641042470932007, -0.336141973733902, 0.923832356929779, 0.7900405526161194, -0.3465067446231842, 0.8605623841285706, 0.8144012093544006, -0.3560333549976349, 0.7979329824447632, 0.8367917537689209, -0.36455419659614563, 0.7360722422599792, 0.8568186163902283, -0.3719017207622528, 0.6751083731651306, 0.8740876317024231, -0.37790828943252563, 0.6151694655418396, 0.8882048726081848, -0.38240623474121093, 0.5563836693763733, 0.8987764120101929, -0.38522788882255554, 0.49887898564338684, 0.9054082036018372, -0.3862057030200958, 0.4427835941314697, 0.9077064394950867, -0.39058825373649597, 1.116205096244812, 0.6650246977806091, -0.40595999360084533, 1.0517817735671997, 0.6911970973014831, -0.42089778184890747, 0.9876149892807007, 0.7166305780410767, -0.435184508562088, 0.9238321781158447, 0.7409553527832031, -0.44860318303108215, 0.8605623245239258, 0.7638024091720581, -0.4609368145465851, 0.7979329228401184, 0.7848019599914551, -0.47196832299232483, 0.7360721230506897, 0.8035844564437866, -0.4814807176589966, 0.6751083731651306, 0.8197805881500244, -0.4892570376396179, 0.6151694059371948, 0.8330206871032715, -0.49508026242256164, 0.5563836097717285, 0.8429353833198547, -0.49873337149620056, 0.49887898564338684, 0.8491551876068115, -0.4999992549419403, 0.4427835941314697, 0.8513105511665344, -0.47222182154655456, 1.1162052154541015, 0.6102941632270813, -0.4908062517642975, 1.0517820119857788, 0.6343124508857727, -0.5088661313056946, 0.9876150488853455, 0.657652735710144, -0.5261387228965759, 0.9238325357437134, 0.6799756288528442, -0.5423620939254761, 0.8605625629425049, 0.70094233751297, -0.5572733283042908, 0.797933042049408, 0.720213770866394, -0.5706104636192322, 0.736072301864624, 0.737450361251831, -0.5821109414100647, 0.6751084923744202, 0.7523136734962463, -0.5915125608444214, 0.6151694655418396, 0.764464259147644, -0.5985528826713562, 0.5563836693763733, 0.773563027381897, -0.6029693484306335, 0.4988790452480316, 0.7792708873748779, -0.6044998168945312, 0.4427836239337921, 0.7812488675117493, -0.5457417368888855, 1.116205096244812, 0.5457416772842407, -0.5672197341918945, 1.0517817735671997, 0.5672196745872498, -0.588091254234314, 0.9876150488853455, 0.5880911946296692, -0.6080530285835266, 0.9238322973251343, 0.6080529689788818, -0.6268020868301392, 0.8605623245239258, 0.6268020272254944, -0.6440349221229553, 0.7979329228401184, 0.6440348625183105, -0.6594484448432922, 0.7360722422599792, 0.6594483852386475, -0.672739565372467, 0.6751083731651306, 0.672739565372467, -0.6836047768592834, 0.6151694655418396, 0.6836047768592834, -0.6917412281036377, 0.5563836693763733, 0.6917412281036377, -0.6968454718589783, 0.4988790452480316, 0.6968454718589783, -0.6986141800880432, 0.4427836239337921, 0.6986141800880432, -0.6102942228317261, 1.116205096244812, 0.4722217619419098, -0.6343124508857727, 1.0517817735671997, 0.4908061921596527, -0.6576527953147888, 0.9876150488853455, 0.5088660717010498, -0.679975688457489, 0.9238325357437134, 0.5261386632919311, -0.7009423971176147, 0.8605623245239258, 0.5423619747161865, -0.720213770866394, 0.7979329824447632, 0.557273268699646, -0.7374504208564758, 0.7360722422599792, 0.5706104040145874, -0.7523135542869568, 0.6751083135604858, 0.5821109414100647, -0.764464259147644, 0.6151694059371948, 0.5915125608444214, -0.7735629081726074, 0.5563835501670837, 0.5985528826713562, -0.7792708277702331, 0.4988790452480316, 0.6029693484306335, -0.7812488079071045, 0.4427836239337921, 0.6044998168945312, -0.6650248765945435, 1.116205096244812, 0.39058825373649597, -0.6911972761154175, 1.0517817735671997, 0.4059600234031677, -0.7166306376457214, 0.9876150488853455, 0.42089787125587463, -0.7409555315971374, 0.9238322973251343, 0.4351845383644104, -0.7638025283813477, 0.8605623245239258, 0.44860321283340454, -0.7848020792007446, 0.7979329228401184, 0.46093687415122986, -0.8035845756530762, 0.7360722422599792, 0.4719683825969696, -0.8197805881500244, 0.6751083731651306, 0.48148080706596374, -0.8330207467079163, 0.6151694059371948, 0.4892570674419403, -0.8429355621337891, 0.5563836097717285, 0.4950803518295288, -0.8491553068161011, 0.4988790452480316, 0.4987333416938782, -0.851310670375824, 0.4427836239337921, 0.4999992847442627, -0.7090799808502197, 1.116205096244812, 0.301695317029953, -0.736985981464386, 1.0517817735671997, 0.313568651676178, -0.7641043066978455, 0.9876150488853455, 0.32510679960250854, -0.7900406122207642, 0.9238322973251343, 0.33614200353622436, -0.8144012689590454, 0.8605623245239258, 0.3465067446231842, -0.8367918133735657, 0.7979328632354736, 0.35603347420692444, -0.856818675994873, 0.7360722422599792, 0.36455434560775757, -0.8740876317024231, 0.6751083135604858, 0.37190181016921997, -0.8882048726081848, 0.61516934633255, 0.377908319234848, -0.8987764120101929, 0.5563835501670837, 0.38240620493888855, -0.9054082036018372, 0.4988790452480316, 0.38522791862487793, -0.9077064394950867, 0.4427836239337921, 0.3862057626247406, -0.7416053414344788, 1.116205096244812, 0.2063969224691391, -0.7707914113998413, 1.0517817735671997, 0.21451976895332336, -0.7991536259651184, 0.9876150488853455, 0.22241327166557312, -0.8262795805931091, 0.9238322973251343, 0.22996272146701813, -0.8517574667930603, 0.8605623245239258, 0.2370535284280777, -0.8751751184463501, 0.7979328632354736, 0.243570938706398, -0.8961206674575806, 0.7360721826553345, 0.2494002729654312, -0.9141817092895508, 0.6751083135604858, 0.25442689657211303, -0.9289466142654419, 0.61516934633255, 0.25853607058525085, -0.940002977848053, 0.5563835501670837, 0.26161321997642517, -0.9469390511512756, 0.49887895584106445, 0.26354357600212097, -0.9493425488471985, 0.44278356432914734, 0.26421254873275757, -0.7617468237876892, 1.116205096244812, 0.10554716736078262, -0.7917255163192749, 1.0517817735671997, 0.10970102995634079, -0.8208581805229187, 0.9876149296760559, 0.11373760551214218, -0.848720908164978, 0.9238322973251343, 0.11759824305772781, -0.8748907446861267, 0.8605623245239258, 0.12122433632612228, -0.8989443778991699, 0.7979329228401184, 0.12455719709396362, -0.9204586744308472, 0.7360721826553345, 0.12753821909427643, -0.9390103816986084, 0.6751083731651306, 0.13010871410369873, -0.954176127910614, 0.61516934633255, 0.13221007585525513, -0.9655328989028931, 0.5563835501670837, 0.13378365337848663, -0.9726572632789612, 0.49887901544570923, 0.13477082550525665, -0.9751261472702026, 0.4427835941314697, 0.1351129114627838, -0.7686504125595093, 1.1162052154541015, 1.051479614488926e-7, -0.7989009022712707, 1.0517818927764892, 1.1402232757973252e-7, -0.8282974362373352, 0.9876150488853455, 1.2271445370970468e-7, -0.8564126491546631, 0.923832356929779, 1.3113313457324693e-7, -0.8828197717666626, 0.8605625033378601, 1.3918733543505368e-7, -0.9070914387702942, 0.7979329824447632, 1.467858794512722e-7, -0.9288005828857422, 0.7360721826553345, 1.538376608323233e-7, -0.9475204348564148, 0.6751083135604858, 1.6025153115606372e-7, -0.962823748588562, 0.6151694059371948, 1.6593637042205955e-7, -0.9742833375930786, 0.5563836097717285, 1.7080100178645807e-7, -0.9814723134040832, 0.49887895584106445, 1.7475434788138955e-7, -0.9839635491371155, 0.44278356432914734, 1.777052744955654e-7, -0.7617469429969788, 1.116205096244812, -0.10554715245962143, -0.7917256951332092, 1.0517817735671997, -0.1097009927034378, -0.8208582401275635, 0.9876150488853455, -0.1137375608086586, -0.848720908164978, 0.9238325357437134, -0.11759819835424423, -0.8748908042907715, 0.8605623245239258, -0.1212242841720581, -0.8989444375038147, 0.7979329824447632, -0.12455713748931885, -0.9204586744308472, 0.7360722422599792, -0.12753811478614807, -0.9390104413032532, 0.6751084327697754, -0.13010863959789276, -0.9541763067245483, 0.6151694655418396, -0.13221000134944916, -0.9655328989028931, 0.5563836097717285, -0.13378359377384186, -0.9726573824882507, 0.49887901544570923, -0.1347707211971283, -0.9751262068748474, 0.4427835941314697, -0.13511280715465546, -0.741605281829834, 1.116205096244812, -0.2063968926668167, -0.7707914113998413, 1.0517817735671997, -0.21451973915100098, -0.7991536259651184, 0.9876149296760559, -0.22241322696208954, -0.8262795805931091, 0.9238322973251343, -0.22996269166469574, -0.8517574667930603, 0.8605623245239258, -0.23705348372459412, -0.8751751184463501, 0.7979328632354736, -0.24357086420059204, -0.8961204886436462, 0.7360720634460449, -0.24940019845962524, -0.9141817092895508, 0.6751083135604858, -0.25442683696746826, -0.9289464950561523, 0.61516934633255, -0.2585360109806061, -0.9400028586387634, 0.5563835501670837, -0.2616131603717804, -0.9469389915466309, 0.49887895584106445, -0.2635435163974762, -0.9493424892425537, 0.44278356432914734, -0.2642124593257904, -0.7090799808502197, 1.116205096244812, -0.301695317029953, -0.736985981464386, 1.0517817735671997, -0.31356868147850036, -0.7641043066978455, 0.9876150488853455, -0.32510676980018615, -0.7900406122207642, 0.9238322973251343, -0.33614200353622436, -0.8144012689590454, 0.8605623245239258, -0.3465067744255066, -0.8367918133735657, 0.7979329228401184, -0.3560333847999573, -0.856818675994873, 0.7360721826553345, -0.364554226398468, -0.8740876317024231, 0.6751083135604858, -0.3719017505645752, -0.8882048726081848, 0.6151694059371948, -0.377908319234848, -0.8987764120101929, 0.5563836097717285, -0.3824062645435333, -0.9054082036018372, 0.49887892603874206, -0.38522791862487793, -0.9077064394950867, 0.44278353452682495, -0.3862057328224182, -0.6650247573852539, 1.116205096244812, -0.39058831334114074, -0.6911971569061279, 1.0517817735671997, -0.4059600532054901, -0.7166306376457214, 0.9876149296760559, -0.42089781165122986, -0.7409554123878479, 0.9238321185112, -0.4351845383644104, -0.7638024687767029, 0.860562264919281, -0.44860321283340454, -0.7848020195960998, 0.7979328632354736, -0.46093684434890747, -0.8035845160484314, 0.7360720634460449, -0.4719683527946472, -0.8197805881500244, 0.6751083135604858, -0.48148074746131897, -0.8330206871032715, 0.61516934633255, -0.4892570674419403, -0.8429353833198547, 0.5563835501670837, -0.49508029222488403, -0.8491551876068115, 0.49887892603874206, -0.49873340129852295, -0.8513105511665344, 0.44278353452682495, -0.4999992847442627, -0.6102942228317261, 1.1162052154541015, -0.47222188115119934, -0.6343125104904175, 1.0517820119857788, -0.49080631136894226, -0.6576527953147888, 0.9876150488853455, -0.5088661909103393, -0.679975688457489, 0.9238325357437134, -0.5261387825012207, -0.7009423971176147, 0.8605625033378601, -0.5423621535301208, -0.7202138304710388, 0.7979329824447632, -0.5572733879089355, -0.7374504208564758, 0.7360722422599792, -0.570610523223877, -0.7523136734962463, 0.6751084327697754, -0.5821109414100647, -0.764464259147644, 0.6151694059371948, -0.5915125608444214, -0.773563027381897, 0.5563836097717285, -0.5985528826713562, -0.7792708873748779, 0.49887898564338684, -0.6029693484306335, -0.7812488675117493, 0.44278356432914734, -0.6044998168945312, -0.5457417368888855, 1.116205096244812, -0.5457417964935303, -0.5672197341918945, 1.0517817735671997, -0.5672197937965393, -0.588091254234314, 0.9876150488853455, -0.5880913138389587, -0.6080530285835266, 0.9238322973251343, -0.6080530881881714, -0.6268020868301392, 0.8605623245239258, -0.6268021464347839, -0.6440349221229553, 0.7979329228401184, -0.6440349817276001, -0.6594484448432922, 0.7360722422599792, -0.659448504447937, -0.672739565372467, 0.6751083731651306, -0.672739565372467, -0.6836047768592834, 0.61516934633255, -0.6836047768592834, -0.6917412281036377, 0.5563835501670837, -0.6917412281036377, -0.6968454718589783, 0.49887898564338684, -0.6968454718589783, -0.6986141800880432, 0.44278356432914734, -0.6986141800880432, -0.47222182154655456, 1.116205096244812, -0.6102942824363708, -0.4908062517642975, 1.0517817735671997, -0.6343125104904175, -0.5088661313056946, 0.9876150488853455, -0.6576528549194336, -0.5261387228965759, 0.9238325357437134, -0.6799757480621338, -0.5423620343208313, 0.860562264919281, -0.7009424567222595, -0.5572733283042908, 0.7979329228401184, -0.7202138304710388, -0.5706104636192322, 0.7360721826553345, -0.7374504804611206, -0.5821109414100647, 0.6751082539558411, -0.7523135542869568, -0.5915125608444214, 0.61516934633255, -0.764464259147644, -0.5985528826713562, 0.556383490562439, -0.7735629081726074, -0.6029693484306335, 0.49887898564338684, -0.7792708277702331, -0.6044998168945312, 0.44278356432914734, -0.7812488079071045, -0.39058831334114074, 1.116205096244812, -0.6650249361991882, -0.4059600830078125, 1.0517817735671997, -0.6911973357200623, -0.420897901058197, 0.9876149892807007, -0.7166306972503662, -0.4351845681667328, 0.9238322377204895, -0.7409555912017822, -0.44860324263572693, 0.860562264919281, -0.7638025879859924, -0.46093690395355224, 0.7979328632354736, -0.7848021388053894, -0.471968412399292, 0.7360721826553345, -0.803584635257721, -0.48148083686828613, 0.6751083135604858, -0.8197805881500244, -0.4892570972442627, 0.61516934633255, -0.8330207467079163, -0.4950803816318512, 0.5563835501670837, -0.8429355621337891, -0.49873337149620056, 0.49887898564338684, -0.8491553068161011, -0.4999993145465851, 0.44278356432914734, -0.851310670375824, -0.3016953766345978, 1.116205096244812, -0.7090800404548645, -0.31356871128082275, 1.0517817735671997, -0.7369860410690308, -0.32510682940483093, 0.9876149892807007, -0.7641043663024902, -0.33614203333854675, 0.9238322377204895, -0.7900406718254089, -0.3465067744255066, 0.860562264919281, -0.8144013285636902, -0.3560335040092468, 0.7979328036308289, -0.8367918729782104, -0.36455437541007995, 0.7360721826553345, -0.8568187355995178, -0.37190183997154236, 0.6751082539558411, -0.8740876317024231, -0.3779083490371704, 0.6151692867279053, -0.8882048726081848, -0.38240623474121093, 0.556383490562439, -0.8987764120101929, -0.3852279484272003, 0.49887898564338684, -0.9054082036018372, -0.386205792427063, 0.44278356432914734, -0.9077064394950867, -0.20639696717262268, 1.116205096244812, -0.7416054010391235, -0.21451981365680694, 1.0517817735671997, -0.7707914710044861, -0.2224133163690567, 0.9876149892807007, -0.7991536855697632, -0.2299627661705017, 0.9238322377204895, -0.8262796401977539, -0.23705357313156128, 0.860562264919281, -0.8517575263977051, -0.2435709685087204, 0.7979328036308289, -0.8751751780509949, -0.2494003027677536, 0.7360721230506897, -0.8961207270622253, -0.2544269263744354, 0.6751082539558411, -0.9141817092895508, -0.25853610038757324, 0.6151692867279053, -0.9289466142654419, -0.26161324977874756, 0.556383490562439, -0.940002977848053, -0.26354360580444336, 0.49887892603874206, -0.9469390511512756, -0.26421257853507995, 0.44278353452682495, -0.9493425488471985, -0.1055472195148468, 1.116205096244812, -0.761746883392334, -0.10970107465982437, 1.0517817735671997, -0.7917255759239197, -0.11373765021562576, 0.9876148700714111, -0.8208582401275635, -0.1175982803106308, 0.9238322377204895, -0.8487209677696228, -0.12122437357902527, 0.860562264919281, -0.8748908042907715, -0.12455723434686661, 0.7979328632354736, -0.8989444375038147, -0.12753824889659881, 0.7360721230506897, -0.9204587340354919, -0.13010874390602112, 0.6751083135604858, -0.9390103816986084, -0.13221010565757751, 0.6151692867279053, -0.954176127910614, -0.13378368318080902, 0.556383490562439, -0.9655328989028931, -0.13477084040641785, 0.49887898564338684, -0.9726572632789612, -0.135112926363945, 0.44278356432914734, -0.9751261472702026, -1.5393884211789555e-7, 1.1162052154541015, -0.768650472164154, -1.5999717106751632e-7, 1.0517818927764892, -0.7989009618759155, -1.6588447238063963e-7, 0.9876149892807007, -0.82829749584198, -1.7151513986846112e-7, 0.9238322973251343, -0.8564127087593079, -1.7680372366157826e-7, 0.8605624437332153, -0.8828198313713074, -1.816646459928961e-7, 0.7979329228401184, -0.907091498374939, -1.860124001495933e-7, 0.7360721230506897, -0.928800642490387, -1.8976145099713903e-7, 0.6751082539558411, -0.9475204348564148, -1.9282627761185722e-7, 0.61516934633255, -0.962823748588562, -1.9512130222665291e-7, 0.5563835501670837, -0.9742833375930786, -1.9656103233955946e-7, 0.49887892603874206, -0.9814723134040832, -1.970599612377555e-7, 0.44278353452682495, -0.9839635491371155, 0.10554710030555725, 1.116205096244812, -0.7617470026016235, 0.10970094799995422, 1.0517817735671997, -0.791725754737854, 0.11373751610517502, 0.9876149892807007, -0.8208582997322082, 0.11759816110134125, 0.9238324761390686, -0.8487209677696228, 0.12122424691915512, 0.860562264919281, -0.8748908638954163, 0.12455710023641586, 0.7979329228401184, -0.8989444971084595, 0.12753808498382568, 0.7360721826553345, -0.9204587340354919, 0.13010860979557037, 0.6751083731651306, -0.9390104413032532, 0.13220997154712677, 0.6151694059371948, -0.9541763067245483, 0.13378356397151947, 0.5563835501670837, -0.9655328989028931, 0.1347707062959671, 0.49887898564338684, -0.9726573824882507, 0.13511279225349426, 0.44278356432914734, -0.9751262068748474, 0.20639684796333313, 1.116205096244812, -0.7416053414344788, 0.2145196944475174, 1.0517817735671997, -0.7707914710044861, 0.22241318225860596, 0.9876148700714111, -0.7991536855697632, 0.22996264696121216, 0.9238322377204895, -0.8262796401977539, 0.23705343902111053, 0.860562264919281, -0.8517575263977051, 0.24357083439826965, 0.7979328036308289, -0.8751751780509949, 0.24940016865730286, 0.7360720038414001, -0.896120548248291, 0.2544268071651459, 0.6751082539558411, -0.9141817092895508, 0.2585359811782837, 0.6151692867279053, -0.9289464950561523, 0.261613130569458, 0.556383490562439, -0.9400028586387634, 0.2635434865951538, 0.49887892603874206, -0.9469389915466309, 0.264212429523468, 0.44278353452682495, -0.9493424892425537, 0.3016952574253082, 1.116205096244812, -0.7090800404548645, 0.3135686218738556, 1.0517817735671997, -0.7369860410690308, 0.32510673999786377, 0.9876149892807007, -0.7641043663024902, 0.336141973733902, 0.9238322377204895, -0.7900406718254089, 0.3465067446231842, 0.860562264919281, -0.8144013285636902, 0.3560333549976349, 0.7979328632354736, -0.8367918729782104, 0.36455419659614563, 0.7360721230506897, -0.8568187355995178, 0.3719017207622528, 0.6751082539558411, -0.8740876317024231, 0.37790828943252563, 0.61516934633255, -0.8882048726081848, 0.38240623474121093, 0.5563835501670837, -0.8987764120101929, 0.38522788882255554, 0.49887892603874206, -0.9054082036018372, 0.3862057030200958, 0.44278353452682495, -0.9077064394950867, 0.39058825373649597, 1.116205096244812, -0.6650248169898987, 0.40595999360084533, 1.0517817735671997, -0.6911972165107727, 0.42089778184890747, 0.9876148700714111, -0.7166306972503662, 0.435184508562088, 0.9238320589065552, -0.7409554719924927, 0.44860318303108215, 0.8605622053146362, -0.7638025283813477, 0.4609368145465851, 0.7979328036308289, -0.7848020792007446, 0.47196832299232483, 0.7360720038414001, -0.8035845756530762, 0.4814807176589966, 0.6751082539558411, -0.8197805881500244, 0.4892570376396179, 0.6151692867279053, -0.8330206871032715, 0.49508026242256164, 0.556383490562439, -0.8429353833198547, 0.49873337149620056, 0.49887892603874206, -0.8491551876068115, 0.4999992549419403, 0.44278353452682495, -0.8513105511665344, 0.47222182154655456, 1.1162052154541015, -0.6102942824363708, 0.4908062517642975, 1.0517820119857788, -0.6343125700950623, 0.5088661313056946, 0.9876150488853455, -0.6576528549194336, 0.5261387228965759, 0.9238325357437134, -0.6799757480621338, 0.5423620939254761, 0.8605624437332153, -0.7009424567222595, 0.5572733283042908, 0.7979329228401184, -0.7202138900756836, 0.5706104636192322, 0.7360721826553345, -0.7374504804611206, 0.5821109414100647, 0.6751083731651306, -0.7523136734962463, 0.5915125608444214, 0.61516934633255, -0.764464259147644, 0.5985528826713562, 0.5563835501670837, -0.773563027381897, 0.6029693484306335, 0.49887898564338684, -0.7792708873748779, 0.6044998168945312, 0.44278356432914734, -0.7812488675117493, 0.5457417368888855, 1.116205096244812, -0.5457417964935303, 0.5672197341918945, 1.0517817735671997, -0.5672197937965393, 0.588091254234314, 0.9876150488853455, -0.5880913138389587, 0.6080530285835266, 0.9238322973251343, -0.6080530881881714, 0.6268020868301392, 0.8605623245239258, -0.6268021464347839, 0.6440349221229553, 0.7979329228401184, -0.6440349817276001, 0.6594484448432922, 0.7360722422599792, -0.659448504447937, 0.672739565372467, 0.6751083731651306, -0.672739565372467, 0.6836047768592834, 0.61516934633255, -0.6836047768592834, 0.6917412281036377, 0.5563835501670837, -0.6917412281036377, 0.6968454718589783, 0.49887898564338684, -0.6968454718589783, 0.6986141800880432, 0.44278356432914734, -0.6986141800880432, 0.6102942228317261, 1.116205096244812, -0.47222188115119934, 0.6343124508857727, 1.0517817735671997, -0.49080631136894226, 0.6576527953147888, 0.9876150488853455, -0.5088661909103393, 0.679975688457489, 0.9238325357437134, -0.5261387825012207, 0.7009423971176147, 0.8605623245239258, -0.5423620939254761, 0.720213770866394, 0.7979329824447632, -0.5572733879089355, 0.7374504208564758, 0.7360722422599792, -0.570610523223877, 0.7523135542869568, 0.6751083135604858, -0.5821109414100647, 0.764464259147644, 0.6151694059371948, -0.5915125608444214, 0.7735629081726074, 0.5563835501670837, -0.5985528826713562, 0.7792708277702331, 0.49887898564338684, -0.6029693484306335, 0.7812488079071045, 0.44278356432914734, -0.6044998168945312, 0.6650248765945435, 1.116205096244812, -0.3905883729457855, 0.6911972761154175, 1.0517817735671997, -0.4059601426124573, 0.7166306376457214, 0.9876150488853455, -0.4208979308605194, 0.7409555315971374, 0.9238322973251343, -0.4351845979690552, 0.7638025283813477, 0.8605623245239258, -0.4486032724380493, 0.7848020792007446, 0.7979329228401184, -0.46093693375587463, 0.8035845756530762, 0.7360722422599792, -0.4719684422016144, 0.8197805881500244, 0.6751083731651306, -0.4814808666706085, 0.8330207467079163, 0.6151694059371948, -0.4892571270465851, 0.8429355621337891, 0.5563836097717285, -0.4950804114341736, 0.8491553068161011, 0.49887898564338684, -0.49873340129852295, 0.851310670375824, 0.44278356432914734, -0.49999934434890747, 0.7090799808502197, 1.116205096244812, -0.30169543623924255, 0.736985981464386, 1.0517817735671997, -0.31356877088546753, 0.7641043066978455, 0.9876150488853455, -0.3251068592071533, 0.7900406122207642, 0.9238322973251343, -0.33614206314086914, 0.8144012689590454, 0.8605623245239258, -0.346506804227829, 0.8367918133735657, 0.7979328632354736, -0.3560335338115692, 0.856818675994873, 0.7360722422599792, -0.36455440521240234, 0.8740876317024231, 0.6751083135604858, -0.37190186977386474, 0.8882048726081848, 0.61516934633255, -0.3779083788394928, 0.8987764120101929, 0.5563835501670837, -0.3824062645435333, 0.9054082036018372, 0.49887898564338684, -0.3852279782295227, 0.9077064394950867, 0.44278356432914734, -0.3862058222293854, 0.7416053414344788, 1.116205096244812, -0.20639701187610626, 0.7707914113998413, 1.0517817735671997, -0.21451985836029053, 0.7991536259651184, 0.9876150488853455, -0.22241336107254028, 0.8262795805931091, 0.9238322973251343, -0.2299628108739853, 0.8517574667930603, 0.8605623245239258, -0.23705361783504486, 0.8751751184463501, 0.7979328632354736, -0.24357099831104278, 0.8961206674575806, 0.7360721826553345, -0.249400332570076, 0.9141817092895508, 0.6751083135604858, -0.2544269561767578, 0.9289466142654419, 0.61516934633255, -0.25853613018989563, 0.940002977848053, 0.5563835501670837, -0.26161327958106994, 0.9469390511512756, 0.49887895584106445, -0.26354363560676574, 0.9493425488471985, 0.44278356432914734, -0.26421260833740234, 0.7617468237876892, 1.116205096244812, -0.10554727166891098, 0.7917255163192749, 1.0517817735671997, -0.10970111936330795, 0.8208581805229187, 0.9876149296760559, -0.11373769491910934, 0.848720908164978, 0.9238322973251343, -0.11759831756353378, 0.8748907446861267, 0.8605623245239258, -0.12122441083192825, 0.8989443778991699, 0.7979329228401184, -0.12455727159976959, 0.9204586744308472, 0.7360721826553345, -0.1275382786989212, 0.9390103816986084, 0.6751083731651306, -0.1301087737083435, 0.954176127910614, 0.61516934633255, -0.1322101354598999, 0.9655328989028931, 0.5563835501670837, -0.1337837129831314, 0.9726572632789612, 0.49887901544570923, -0.13477085530757904, 0.9751261472702026, 0.4427835941314697, -0.1351129412651062, 0.979123592376709, 0.38972046971321106, -1.7035223009997935e-8, 0.9657419323921204, 0.3411415219306946, -1.4911769596892554e-8, 0.9455274939537048, 0.29691869020462036, -1.2978729202473005e-8, 0.9201880097389221, 0.2569237947463989, -1.1230496532732559e-8, 0.8914322257041931, 0.22102877497673035, -9.661475175448686e-9, 0.8609681129455566, 0.18910549581050873, -8.266064277506757e-9, 0.8305039405822754, 0.1610257923603058, -7.038661653524514e-9, 0.8017480969429016, 0.13666163384914398, -5.973670003101006e-9, 0.7764087319374084, 0.11588478833436966, -5.0654849204079255e-9, 0.7561942934989929, 0.09856719523668289, -4.3085091050443225e-9, 0.7428128123283386, 0.08458073437213898, -3.697141481850963e-9, 0.7379726767539978, 0.07379727065563202, -3.225781197713218e-9, 0.9703295826911926, 0.38972046971321106, 0.13444817066192627, 0.9570682644844055, 0.3411415219306946, 0.13261067867279053, 0.937035322189331, 0.29691869020462036, 0.12983492016792297, 0.9119235277175903, 0.2569237947463989, 0.12635545432567596, 0.8834259510040283, 0.22102877497673035, 0.12240685522556305, 0.8532353639602661, 0.18910549581050873, 0.11822368204593658, 0.8230448961257935, 0.1610257923603058, 0.11404050141572952, 0.7945472598075867, 0.13666163384914398, 0.11009189486503601, 0.7694355249404907, 0.11588479578495025, 0.1066124215722084, 0.7494025230407715, 0.09856720268726349, 0.10383667796850204, 0.7361413240432739, 0.08458074182271957, 0.1019992083311081, 0.7313446402549744, 0.07379727810621261, 0.1013345941901207, 0.9446729421615601, 0.38972043991088867, 0.2629127502441406, 0.931762158870697, 0.3411415219306946, 0.25931957364082336, 0.9122588038444519, 0.29691869020462036, 0.25389161705970764, 0.8878109455108643, 0.2569237947463989, 0.2470875233411789, 0.8600668907165527, 0.22102877497673035, 0.23936603963375091, 0.8306747674942017, 0.18910549581050873, 0.23118585348129272, 0.801282525062561, 0.16102580726146698, 0.22300569713115692, 0.7735384106636047, 0.1366616189479828, 0.21528419852256775, 0.7490906715393066, 0.11588478833436966, 0.2084801197052002, 0.7295874357223511, 0.09856720268726349, 0.20305213332176208, 0.7166768312454224, 0.08458074182271957, 0.1994589865207672, 0.7120069861412048, 0.07379727065563202, 0.198159322142601, 0.9032415747642517, 0.38972046971321106, 0.3843059241771698, 0.8908970355987549, 0.34114155173301697, 0.37905368208885193, 0.8722490072250366, 0.29691872000694275, 0.37111952900886535, 0.8488734364509582, 0.2569238245487213, 0.3611738085746765, 0.8223462700843811, 0.22102877497673035, 0.3498871922492981, 0.7942430973052978, 0.18910549581050873, 0.33792996406555176, 0.7661399245262146, 0.16102580726146698, 0.3259727954864502, 0.7396125793457031, 0.1366616189479828, 0.314686119556427, 0.7162370085716248, 0.11588480323553085, 0.30474042892456054, 0.697589099407196, 0.09856721013784408, 0.296806275844574, 0.6852447986602783, 0.08458074927330017, 0.2915540337562561, 0.680779755115509, 0.07379728555679321, 0.28965428471565246, 0.8471229672431946, 0.38972046971321106, 0.49753978848457336, 0.8355454206466675, 0.34114155173301697, 0.49074000120162964, 0.8180562257766724, 0.29691872000694275, 0.4804680049419403, 0.7961328029632568, 0.2569238245487213, 0.4675918221473694, 0.771253764629364, 0.22102877497673035, 0.4529796540737152, 0.744896650314331, 0.18910549581050873, 0.43749934434890747, 0.7185395359992981, 0.16102580726146698, 0.4220190942287445, 0.6936604380607605, 0.1366616189479828, 0.4074067771434784, 0.6717371940612793, 0.11588479578495025, 0.39453068375587463, 0.6542479395866394, 0.09856721013784408, 0.3842586874961853, 0.6426705121994018, 0.08458074927330017, 0.37745893001556396, 0.638482928276062, 0.07379727810621261, 0.37499943375587463, 0.7774060964584351, 0.38972049951553344, 0.6015264391899109, 0.7667813301086426, 0.34114155173301697, 0.5933054089546204, 0.750731348991394, 0.29691872000694275, 0.5808865427970886, 0.7306123375892639, 0.2569238245487213, 0.565319299697876, 0.7077807188034058, 0.22102880477905273, 0.547653079032898, 0.6835927367210388, 0.18910552561283111, 0.5289373397827148, 0.6594047546386719, 0.16102580726146698, 0.5102216005325317, 0.6365731358528137, 0.13666164875030517, 0.4925554096698761, 0.6164541244506836, 0.11588481068611145, 0.47698813676834106, 0.6004043221473694, 0.09856721758842468, 0.4645693302154541, 0.5897794961929321, 0.08458076417446136, 0.45634835958480835, 0.5859366655349731, 0.0737973004579544, 0.45337486267089843, 0.6951776742935181, 0.38972049951553344, 0.6951776742935181, 0.6856768131256103, 0.34114155173301697, 0.6856768131256103, 0.6713245511054993, 0.29691872000694275, 0.6713245511054993, 0.6533335447311401, 0.2569238245487213, 0.6533335447311401, 0.6329168677330017, 0.22102880477905273, 0.6329168677330017, 0.6112874150276184, 0.18910552561283111, 0.6112874150276184, 0.5896578431129456, 0.16102582216262817, 0.5896578431129456, 0.5692411065101623, 0.13666166365146637, 0.5692411065101623, 0.5512502789497375, 0.11588481068611145, 0.5512502789497375, 0.5368979573249817, 0.09856721758842468, 0.5368979573249817, 0.527397096157074, 0.08458075672388077, 0.527397096157074, 0.5239605903625488, 0.07379729300737381, 0.5239605903625488, 0.6015264391899109, 0.38972049951553344, 0.7774059176445007, 0.5933054089546204, 0.34114155173301697, 0.766781210899353, 0.5808865427970886, 0.29691872000694275, 0.7507312297821045, 0.565319299697876, 0.2569238245487213, 0.7306122183799744, 0.547653079032898, 0.22102880477905273, 0.7077807188034058, 0.5289373993873596, 0.18910552561283111, 0.6835927367210388, 0.5102216005325317, 0.16102582216262817, 0.6594046950340271, 0.4925554096698761, 0.13666166365146637, 0.636573076248169, 0.47698813676834106, 0.11588481813669205, 0.6164541244506836, 0.4645693302154541, 0.09856722503900528, 0.6004043221473694, 0.45634838938713073, 0.08458075672388077, 0.5897794961929321, 0.4533748924732208, 0.07379729300737381, 0.5859366655349731, 0.4975398778915405, 0.38972049951553344, 0.8471231460571289, 0.490740031003952, 0.34114155173301697, 0.8355456590652466, 0.48046809434890747, 0.29691872000694275, 0.8180563449859619, 0.4675918519496918, 0.2569238245487213, 0.7961330413818359, 0.45297971367836, 0.22102880477905273, 0.7712540030479431, 0.43749940395355224, 0.18910552561283111, 0.7448967695236206, 0.4220191240310669, 0.16102582216262817, 0.7185396552085876, 0.40740686655044555, 0.13666166365146637, 0.6936604976654053, 0.39453068375587463, 0.11588481813669205, 0.6717373132705688, 0.3842587471008301, 0.09856722503900528, 0.6542479395866394, 0.37745898962020874, 0.08458076417446136, 0.6426705718040466, 0.3749994933605194, 0.0737973004579544, 0.6384829878807068, 0.38430607318878174, 0.38972049951553344, 0.9032415747642517, 0.37905383110046386, 0.34114155173301697, 0.8908970355987549, 0.37111958861351013, 0.29691872000694275, 0.8722490072250366, 0.3611738979816437, 0.2569238245487213, 0.8488734364509582, 0.3498872220516205, 0.22102880477905273, 0.8223462700843811, 0.33793002367019653, 0.18910552561283111, 0.7942430973052978, 0.32597288489341736, 0.16102582216262817, 0.7661399245262146, 0.31468620896339416, 0.13666166365146637, 0.7396125793457031, 0.3047405183315277, 0.11588481813669205, 0.7162370085716248, 0.29680633544921875, 0.09856722503900528, 0.697589099407196, 0.2915540933609009, 0.08458076417446136, 0.6852447986602783, 0.28965434432029724, 0.0737973004579544, 0.680779755115509, 0.26291295886039734, 0.38972046971321106, 0.9446729421615601, 0.2593197524547577, 0.34114155173301697, 0.931762158870697, 0.2538917660713196, 0.29691872000694275, 0.9122589826583862, 0.24708765745162964, 0.2569238245487213, 0.8878109455108643, 0.23936618864536285, 0.22102880477905273, 0.8600670099258423, 0.23118598759174347, 0.18910551071166992, 0.8306747674942017, 0.22300581634044647, 0.16102582216262817, 0.801282525062561, 0.2152843028306961, 0.13666163384914398, 0.7735384702682495, 0.20848020911216736, 0.11588481813669205, 0.7490906715393066, 0.20305223762989044, 0.09856722503900528, 0.7295874357223511, 0.19945906102657318, 0.08458076417446136, 0.7166768312454224, 0.19815939664840698, 0.0737973004579544, 0.7120069861412048, 0.1344483196735382, 0.38972049951553344, 0.9703295230865478, 0.13261084258556366, 0.34114155173301697, 0.957068145275116, 0.1298350989818573, 0.29691872000694275, 0.9370352625846863, 0.1263556033372879, 0.2569238245487213, 0.911923348903656, 0.12240701168775558, 0.22102881968021393, 0.8834259510040283, 0.11822381615638733, 0.1891055405139923, 0.8532353639602661, 0.11404063552618027, 0.16102582216262817, 0.8230448961257935, 0.11009201407432556, 0.13666166365146637, 0.7945472002029419, 0.10661255568265915, 0.11588481813669205, 0.7694354057312012, 0.103836789727211, 0.09856722503900528, 0.7494025230407715, 0.10199932008981705, 0.08458076417446136, 0.7361412048339844, 0.10133469849824905, 0.07379729300737381, 0.7313445210456848, 1.9609065304848627e-7, 0.38972046971321106, 0.979123592376709, 1.9341071322287462e-7, 0.34114155173301697, 0.9657419323921204, 1.8936231072075316e-7, 0.29691872000694275, 0.9455274939537048, 1.8428752923682623e-7, 0.2569238245487213, 0.9201880097389221, 1.785285661526359e-7, 0.22102880477905273, 0.8914322257041931, 1.724274767411771e-7, 0.18910552561283111, 0.8609681129455566, 1.6632635890800884e-7, 0.16102582216262817, 0.8305039405822754, 1.6056735319125437e-7, 0.13666164875030517, 0.8017480969429016, 1.554926285507463e-7, 0.11588482558727264, 0.7764087319374084, 1.5144421183777012e-7, 0.09856722503900528, 0.7561942934989929, 1.487642862230132e-7, 0.08458077162504196, 0.7428128123283386, 1.4779494961203454e-7, 0.073797307908535, 0.7379726767539978, -0.13444818556308746, 0.38972049951553344, 0.9703295826911926, -0.13261069357395172, 0.34114155173301697, 0.9570682644844055, -0.12983493506908417, 0.29691872000694275, 0.937035322189331, -0.12635546922683716, 0.2569238245487213, 0.9119235277175903, -0.12240686267614364, 0.22102881968021393, 0.8834259510040283, -0.11822368949651718, 0.1891055405139923, 0.8532353639602661, -0.11404050886631012, 0.16102582216262817, 0.8230448961257935, -0.11009190231561661, 0.13666166365146637, 0.7945472598075867, -0.106612429022789, 0.11588482558727264, 0.7694355249404907, -0.10383668541908264, 0.09856722503900528, 0.7494025230407715, -0.1019992083311081, 0.08458076417446136, 0.7361413240432739, -0.1013345941901207, 0.0737973004579544, 0.7313446402549744, -0.262912780046463, 0.38972046971321106, 0.9446729421615601, -0.25931960344314575, 0.34114155173301697, 0.931762158870697, -0.25389161705970764, 0.29691872000694275, 0.9122588038444519, -0.2470875382423401, 0.2569238245487213, 0.8878109455108643, -0.2393660545349121, 0.22102880477905273, 0.8600668907165527, -0.23118586838245392, 0.18910551071166992, 0.8306747674942017, -0.22300569713115692, 0.16102582216262817, 0.801282525062561, -0.21528419852256775, 0.13666163384914398, 0.7735384106636047, -0.2084801197052002, 0.11588481068611145, 0.7490906715393066, -0.20305213332176208, 0.09856722503900528, 0.7295874357223511, -0.1994589865207672, 0.08458076417446136, 0.7166768312454224, -0.198159322142601, 0.07379729300737381, 0.7120069861412048, -0.3843059539794922, 0.38972046971321106, 0.9032415747642517, -0.3790537118911743, 0.34114155173301697, 0.8908970355987549, -0.37111952900886535, 0.29691872000694275, 0.8722490072250366, -0.3611738085746765, 0.2569238245487213, 0.8488734364509582, -0.3498871922492981, 0.22102878987789154, 0.8223462700843811, -0.33792996406555176, 0.18910551071166992, 0.7942430973052978, -0.3259727954864502, 0.16102582216262817, 0.7661399245262146, -0.314686119556427, 0.13666163384914398, 0.7396125793457031, -0.30474042892456054, 0.11588481813669205, 0.7162370085716248, -0.296806275844574, 0.09856722503900528, 0.697589099407196, -0.2915540337562561, 0.08458076417446136, 0.6852447986602783, -0.28965428471565246, 0.0737973004579544, 0.680779755115509, -0.49753981828689575, 0.38972046971321106, 0.8471229672431946, -0.490740031003952, 0.34114155173301697, 0.8355454206466675, -0.4804680049419403, 0.29691872000694275, 0.8180562257766724, -0.4675918221473694, 0.2569238245487213, 0.7961328029632568, -0.4529796540737152, 0.22102878987789154, 0.771253764629364, -0.43749934434890747, 0.18910551071166992, 0.744896650314331, -0.4220190942287445, 0.16102582216262817, 0.7185395359992981, -0.4074067771434784, 0.13666163384914398, 0.6936604380607605, -0.39453068375587463, 0.11588481068611145, 0.6717371940612793, -0.3842586874961853, 0.09856722503900528, 0.6542479395866394, -0.37745893001556396, 0.08458076417446136, 0.6426705121994018, -0.37499943375587463, 0.07379729300737381, 0.638482928276062, -0.6015264391899109, 0.38972049951553344, 0.7774060964584351, -0.5933054089546204, 0.34114155173301697, 0.7667813301086426, -0.5808865427970886, 0.29691872000694275, 0.750731348991394, -0.565319299697876, 0.2569238245487213, 0.7306123375892639, -0.547653079032898, 0.22102880477905273, 0.7077807188034058, -0.5289373397827148, 0.18910552561283111, 0.6835927367210388, -0.5102216005325317, 0.16102582216262817, 0.6594047546386719, -0.4925554096698761, 0.13666166365146637, 0.6365731358528137, -0.47698813676834106, 0.11588481813669205, 0.6164541244506836, -0.4645693302154541, 0.09856722503900528, 0.6004043221473694, -0.45634835958480835, 0.08458076417446136, 0.5897794961929321, -0.45337486267089843, 0.0737973004579544, 0.5859366655349731, -0.6951776742935181, 0.38972049951553344, 0.6951776742935181, -0.6856768131256103, 0.34114155173301697, 0.6856768131256103, -0.6713245511054993, 0.29691872000694275, 0.6713245511054993, -0.6533335447311401, 0.2569238245487213, 0.6533335447311401, -0.6329168677330017, 0.22102880477905273, 0.6329168677330017, -0.6112874150276184, 0.18910552561283111, 0.6112874150276184, -0.5896578431129456, 0.16102582216262817, 0.5896578431129456, -0.5692411065101623, 0.13666166365146637, 0.5692411065101623, -0.5512502789497375, 0.11588481068611145, 0.5512502789497375, -0.5368979573249817, 0.09856721758842468, 0.5368979573249817, -0.527397096157074, 0.08458075672388077, 0.527397096157074, -0.5239605903625488, 0.07379729300737381, 0.5239605903625488, -0.7774059176445007, 0.38972049951553344, 0.6015264391899109, -0.766781210899353, 0.34114155173301697, 0.5933054089546204, -0.7507312297821045, 0.29691872000694275, 0.5808865427970886, -0.7306122183799744, 0.2569238245487213, 0.565319299697876, -0.7077807188034058, 0.22102880477905273, 0.547653079032898, -0.6835927367210388, 0.18910552561283111, 0.5289373993873596, -0.6594046950340271, 0.16102580726146698, 0.5102216005325317, -0.636573076248169, 0.13666164875030517, 0.4925554096698761, -0.6164541244506836, 0.11588481068611145, 0.47698813676834106, -0.6004043221473694, 0.09856721758842468, 0.4645693302154541, -0.5897794961929321, 0.08458075672388077, 0.45634838938713073, -0.5859366655349731, 0.07379729300737381, 0.4533748924732208, -0.8471231460571289, 0.38972049951553344, 0.49753984808921814, -0.8355456590652466, 0.34114155173301697, 0.49074000120162964, -0.8180563449859619, 0.29691872000694275, 0.48046809434890747, -0.7961330413818359, 0.2569238245487213, 0.4675918519496918, -0.7712540030479431, 0.22102878987789154, 0.45297971367836, -0.7448967695236206, 0.18910551071166992, 0.43749940395355224, -0.7185396552085876, 0.16102580726146698, 0.4220191240310669, -0.6936604976654053, 0.13666164875030517, 0.40740686655044555, -0.6717373132705688, 0.11588480323553085, 0.39453068375587463, -0.6542479395866394, 0.09856721013784408, 0.3842587471008301, -0.6426705718040466, 0.08458074927330017, 0.37745898962020874, -0.6384829878807068, 0.07379728555679321, 0.3749994933605194, -0.9032415747642517, 0.38972049951553344, 0.38430604338645935, -0.8908970355987549, 0.34114155173301697, 0.3790538012981415, -0.8722490072250366, 0.29691872000694275, 0.37111958861351013, -0.8488734364509582, 0.2569238245487213, 0.3611738979816437, -0.8223462700843811, 0.22102878987789154, 0.3498872220516205, -0.7942430973052978, 0.18910551071166992, 0.33793002367019653, -0.7661399245262146, 0.16102580726146698, 0.32597288489341736, -0.7396125793457031, 0.13666164875030517, 0.31468620896339416, -0.7162370085716248, 0.11588480323553085, 0.3047405183315277, -0.697589099407196, 0.09856721013784408, 0.29680633544921875, -0.6852447986602783, 0.08458074927330017, 0.2915540933609009, -0.680779755115509, 0.07379728555679321, 0.28965434432029724, -0.9446729421615601, 0.38972043991088867, 0.26291292905807495, -0.931762158870697, 0.3411415219306946, 0.2593197226524353, -0.9122589826583862, 0.29691869020462036, 0.2538917660713196, -0.8878109455108643, 0.2569237947463989, 0.24708764255046844, -0.8600670099258423, 0.22102877497673035, 0.23936617374420166, -0.8306747674942017, 0.18910549581050873, 0.23118597269058227, -0.801282525062561, 0.16102580726146698, 0.22300581634044647, -0.7735384702682495, 0.1366616189479828, 0.2152843028306961, -0.7490906715393066, 0.11588479578495025, 0.20848020911216736, -0.7295874357223511, 0.09856720268726349, 0.20305223762989044, -0.7166768312454224, 0.08458074182271957, 0.19945906102657318, -0.7120069861412048, 0.07379727810621261, 0.19815939664840698, -0.9703295230865478, 0.38972046971321106, 0.13444830477237701, -0.957068145275116, 0.3411415219306946, 0.13261082768440246, -0.9370352625846863, 0.29691869020462036, 0.1298350840806961, -0.911923348903656, 0.2569237947463989, 0.1263555884361267, -0.8834259510040283, 0.22102877497673035, 0.12240700423717499, -0.8532353639602661, 0.18910549581050873, 0.11822380870580673, -0.8230448961257935, 0.1610257923603058, 0.11404062807559967, -0.7945472002029419, 0.13666163384914398, 0.11009200662374496, -0.7694354057312012, 0.11588478833436966, 0.10661254823207855, -0.7494025230407715, 0.09856720268726349, 0.1038367822766304, -0.7361412048339844, 0.08458074182271957, 0.10199932008981705, -0.7313445210456848, 0.07379727065563202, 0.10133469849824905, -0.979123592376709, 0.38972043991088867, 1.7905543359120202e-7, -0.9657419323921204, 0.3411415219306946, 1.784989365205547e-7, -0.9455274939537048, 0.29691869020462036, 1.763835797419233e-7, -0.9201880097389221, 0.2569237947463989, 1.7305703181591525e-7, -0.8914322257041931, 0.22102876007556915, 1.6886708920083038e-7, -0.8609681129455566, 0.18910548090934753, 1.641614062464214e-7, -0.8305039405822754, 0.1610257923603058, 1.5928769414585986e-7, -0.8017480969429016, 0.1366616189479828, 1.5459367830317205e-7, -0.7764087319374084, 0.11588478833436966, 1.5042714096580312e-7, -0.7561942934989929, 0.09856719523668289, 1.4713570806179632e-7, -0.7428128123283386, 0.08458074182271957, 1.450671476277421e-7, -0.7379726767539978, 0.07379727810621261, 1.4456917085681198e-7, -0.9703295826911926, 0.38972046971321106, -0.13444820046424866, -0.9570682644844055, 0.3411415219306946, -0.13261070847511291, -0.937035322189331, 0.29691869020462036, -0.12983494997024536, -0.9119235277175903, 0.2569237947463989, -0.12635548412799835, -0.8834259510040283, 0.22102877497673035, -0.12240687012672424, -0.8532353639602661, 0.18910549581050873, -0.11822369694709778, -0.8230448961257935, 0.1610257923603058, -0.11404051631689071, -0.7945472598075867, 0.13666163384914398, -0.1100919097661972, -0.7694355249404907, 0.11588478088378906, -0.1066124364733696, -0.7494025230407715, 0.0985671877861023, -0.10383669286966324, -0.7361413240432739, 0.08458072692155838, -0.1019992083311081, -0.7313446402549744, 0.07379726320505142, -0.1013345941901207, -0.9446729421615601, 0.38972043991088867, -0.2629128098487854, -0.931762158870697, 0.3411415219306946, -0.25931963324546814, -0.9122588038444519, 0.29691869020462036, -0.25389161705970764, -0.8878109455108643, 0.2569237947463989, -0.24708755314350128, -0.8600668907165527, 0.22102874517440796, -0.2393660694360733, -0.8306747674942017, 0.18910546600818634, -0.2311858832836151, -0.801282525062561, 0.1610257774591446, -0.22300569713115692, -0.7735384106636047, 0.1366615891456604, -0.21528419852256775, -0.7490906715393066, 0.11588477343320846, -0.2084801197052002, -0.7295874357223511, 0.0985671877861023, -0.20305213332176208, -0.7166768312454224, 0.08458072692155838, -0.1994589865207672, -0.7120069861412048, 0.07379725575447082, -0.198159322142601, -0.9032415747642517, 0.3897204101085663, -0.3843059837818146, -0.8908970355987549, 0.3411414921283722, -0.3790537416934967, -0.8722490072250366, 0.296918660402298, -0.37111952900886535, -0.8488734364509582, 0.25692376494407654, -0.3611738085746765, -0.8223462700843811, 0.22102874517440796, -0.3498871922492981, -0.7942430973052978, 0.18910546600818634, -0.33792996406555176, -0.7661399245262146, 0.1610257774591446, -0.3259727954864502, -0.7396125793457031, 0.1366615891456604, -0.314686119556427, -0.7162370085716248, 0.11588477343320846, -0.30474042892456054, -0.697589099407196, 0.0985671803355217, -0.296806275844574, -0.6852447986602783, 0.08458071947097778, -0.2915540337562561, -0.680779755115509, 0.07379725575447082, -0.28965428471565246, -0.8471229672431946, 0.3897204101085663, -0.49753984808921814, -0.8355454206466675, 0.3411414921283722, -0.4907400608062744, -0.8180562257766724, 0.296918660402298, -0.4804680049419403, -0.7961328029632568, 0.25692376494407654, -0.4675918221473694, -0.771253764629364, 0.22102874517440796, -0.4529796540737152, -0.744896650314331, 0.18910546600818634, -0.43749934434890747, -0.7185395359992981, 0.1610257774591446, -0.4220190942287445, -0.6936604380607605, 0.1366615891456604, -0.4074067771434784, -0.6717371940612793, 0.11588476598262787, -0.39453068375587463, -0.6542479395866394, 0.0985671803355217, -0.3842586874961853, -0.6426705121994018, 0.08458071947097778, -0.37745893001556396, -0.638482928276062, 0.07379724830389023, -0.37499943375587463, -0.7774060964584351, 0.38972043991088867, -0.6015264391899109, -0.7667813301086426, 0.3411414921283722, -0.5933054089546204, -0.750731348991394, 0.296918660402298, -0.5808865427970886, -0.7306123375892639, 0.25692376494407654, -0.565319299697876, -0.7077807188034058, 0.22102874517440796, -0.547653079032898, -0.6835927367210388, 0.18910546600818634, -0.5289373397827148, -0.6594047546386719, 0.1610257774591446, -0.5102216005325317, -0.6365731358528137, 0.1366616189479828, -0.4925554096698761, -0.6164541244506836, 0.11588476598262787, -0.47698813676834106, -0.6004043221473694, 0.0985671728849411, -0.4645693302154541, -0.5897794961929321, 0.08458071947097778, -0.45634835958480835, -0.5859366655349731, 0.07379725575447082, -0.45337486267089843, -0.6951776742935181, 0.38972043991088867, -0.6951776742935181, -0.6856768131256103, 0.3411414921283722, -0.6856768131256103, -0.6713245511054993, 0.296918660402298, -0.6713245511054993, -0.6533335447311401, 0.25692376494407654, -0.6533335447311401, -0.6329168677330017, 0.22102874517440796, -0.6329168677330017, -0.6112874150276184, 0.18910546600818634, -0.6112874150276184, -0.5896578431129456, 0.1610257625579834, -0.5896578431129456, -0.5692411065101623, 0.1366616040468216, -0.5692411065101623, -0.5512502789497375, 0.11588476598262787, -0.5512502789497375, -0.5368979573249817, 0.0985671728849411, -0.5368979573249817, -0.527397096157074, 0.08458071202039718, -0.527397096157074, -0.5239605903625488, 0.07379724830389023, -0.5239605903625488, -0.6015264391899109, 0.38972043991088867, -0.7774059176445007, -0.5933054089546204, 0.3411414921283722, -0.766781210899353, -0.5808865427970886, 0.296918660402298, -0.7507312297821045, -0.565319299697876, 0.25692376494407654, -0.7306122183799744, -0.547653079032898, 0.22102874517440796, -0.7077807188034058, -0.5289373993873596, 0.18910546600818634, -0.6835927367210388, -0.5102216005325317, 0.1610257625579834, -0.6594046950340271, -0.4925554096698761, 0.1366616040468216, -0.636573076248169, -0.47698813676834106, 0.11588475853204727, -0.6164541244506836, -0.4645693302154541, 0.0985671654343605, -0.6004043221473694, -0.45634838938713073, 0.08458071202039718, -0.5897794961929321, -0.4533748924732208, 0.07379724830389023, -0.5859366655349731, -0.4975398778915405, 0.38972043991088867, -0.8471231460571289, -0.490740031003952, 0.3411414921283722, -0.8355456590652466, -0.48046809434890747, 0.296918660402298, -0.8180563449859619, -0.4675918519496918, 0.25692376494407654, -0.7961330413818359, -0.45297971367836, 0.22102874517440796, -0.7712540030479431, -0.43749940395355224, 0.18910546600818634, -0.7448967695236206, -0.4220191240310669, 0.1610257625579834, -0.7185396552085876, -0.40740686655044555, 0.1366616040468216, -0.6936604976654053, -0.39453068375587463, 0.11588475853204727, -0.6717373132705688, -0.3842587471008301, 0.0985671654343605, -0.6542479395866394, -0.37745898962020874, 0.08458070456981659, -0.6426705718040466, -0.3749994933605194, 0.07379724085330963, -0.6384829878807068, -0.38430607318878174, 0.38972043991088867, -0.9032415747642517, -0.37905383110046386, 0.3411414921283722, -0.8908970355987549, -0.37111958861351013, 0.296918660402298, -0.8722490072250366, -0.3611738979816437, 0.25692376494407654, -0.8488734364509582, -0.3498872220516205, 0.22102874517440796, -0.8223462700843811, -0.33793002367019653, 0.18910546600818634, -0.7942430973052978, -0.32597288489341736, 0.1610257625579834, -0.7661399245262146, -0.31468620896339416, 0.1366616040468216, -0.7396125793457031, -0.3047405183315277, 0.11588475853204727, -0.7162370085716248, -0.29680633544921875, 0.0985671654343605, -0.697589099407196, -0.2915540933609009, 0.08458070456981659, -0.6852447986602783, -0.28965434432029724, 0.07379724085330963, -0.680779755115509, -0.26291295886039734, 0.3897204101085663, -0.9446729421615601, -0.2593197524547577, 0.3411414921283722, -0.931762158870697, -0.2538917660713196, 0.296918660402298, -0.9122589826583862, -0.24708765745162964, 0.25692376494407654, -0.8878109455108643, -0.23936618864536285, 0.22102871537208557, -0.8600670099258423, -0.23118598759174347, 0.18910545110702515, -0.8306747674942017, -0.22300581634044647, 0.1610257625579834, -0.801282525062561, -0.2152843028306961, 0.1366615742444992, -0.7735384702682495, -0.20848020911216736, 0.11588475853204727, -0.7490906715393066, -0.20305223762989044, 0.0985671654343605, -0.7295874357223511, -0.19945906102657318, 0.08458070456981659, -0.7166768312454224, -0.19815939664840698, 0.07379724085330963, -0.7120069861412048, -0.1344483196735382, 0.38972043991088867, -0.9703295230865478, -0.13261084258556366, 0.3411414921283722, -0.957068145275116, -0.1298350989818573, 0.296918660402298, -0.9370352625846863, -0.1263556033372879, 0.25692376494407654, -0.911923348903656, -0.12240701168775558, 0.22102873027324676, -0.8834259510040283, -0.11822381615638733, 0.18910545110702515, -0.8532353639602661, -0.11404063552618027, 0.1610257625579834, -0.8230448961257935, -0.11009201407432556, 0.1366616040468216, -0.7945472002029419, -0.10661255568265915, 0.11588474363088608, -0.7694354057312012, -0.103836789727211, 0.0985671654343605, -0.7494025230407715, -0.10199932008981705, 0.08458070456981659, -0.7361412048339844, -0.10133469849824905, 0.07379723340272903, -0.7313445210456848, -1.9609065304848627e-7, 0.3897204101085663, -0.979123592376709, -1.9341071322287462e-7, 0.3411414921283722, -0.9657419323921204, -1.8936231072075316e-7, 0.296918660402298, -0.9455274939537048, -1.8428752923682623e-7, 0.25692376494407654, -0.9201880097389221, -1.785285661526359e-7, 0.22102871537208557, -0.8914322257041931, -1.724274767411771e-7, 0.18910543620586395, -0.8609681129455566, -1.6632635890800884e-7, 0.1610257625579834, -0.8305039405822754, -1.6056735319125437e-7, 0.1366615891456604, -0.8017480969429016, -1.554926285507463e-7, 0.11588475108146667, -0.7764087319374084, -1.5144421183777012e-7, 0.0985671654343605, -0.7561942934989929, -1.487642862230132e-7, 0.08458071202039718, -0.7428128123283386, -1.4779494961203454e-7, 0.07379724830389023, -0.7379726767539978, 0.13444818556308746, 0.38972043991088867, -0.9703295826911926, 0.13261069357395172, 0.3411414921283722, -0.9570682644844055, 0.12983493506908417, 0.296918660402298, -0.937035322189331, 0.12635546922683716, 0.25692376494407654, -0.9119235277175903, 0.12240686267614364, 0.22102873027324676, -0.8834259510040283, 0.11822368949651718, 0.18910545110702515, -0.8532353639602661, 0.11404050886631012, 0.1610257625579834, -0.8230448961257935, 0.11009190231561661, 0.1366616040468216, -0.7945472598075867, 0.106612429022789, 0.11588475108146667, -0.7694355249404907, 0.10383668541908264, 0.0985671654343605, -0.7494025230407715, 0.1019992083311081, 0.08458070456981659, -0.7361413240432739, 0.1013345941901207, 0.07379724085330963, -0.7313446402549744, 0.262912780046463, 0.3897204101085663, -0.9446729421615601, 0.25931960344314575, 0.3411414921283722, -0.931762158870697, 0.25389161705970764, 0.296918660402298, -0.9122588038444519, 0.2470875382423401, 0.25692376494407654, -0.8878109455108643, 0.2393660545349121, 0.22102871537208557, -0.8600668907165527, 0.23118586838245392, 0.18910545110702515, -0.8306747674942017, 0.22300569713115692, 0.1610257625579834, -0.801282525062561, 0.21528419852256775, 0.1366615742444992, -0.7735384106636047, 0.2084801197052002, 0.11588475108146667, -0.7490906715393066, 0.20305213332176208, 0.0985671654343605, -0.7295874357223511, 0.1994589865207672, 0.08458070456981659, -0.7166768312454224, 0.198159322142601, 0.07379723340272903, -0.7120069861412048, 0.3843059539794922, 0.3897204101085663, -0.9032415747642517, 0.3790537118911743, 0.3411414921283722, -0.8908970355987549, 0.37111952900886535, 0.296918660402298, -0.8722490072250366, 0.3611738085746765, 0.25692376494407654, -0.8488734364509582, 0.3498871922492981, 0.22102873027324676, -0.8223462700843811, 0.33792996406555176, 0.18910545110702515, -0.7942430973052978, 0.3259727954864502, 0.1610257625579834, -0.7661399245262146, 0.314686119556427, 0.1366615742444992, -0.7396125793457031, 0.30474042892456054, 0.11588475853204727, -0.7162370085716248, 0.296806275844574, 0.0985671654343605, -0.697589099407196, 0.2915540337562561, 0.08458070456981659, -0.6852447986602783, 0.28965428471565246, 0.07379724085330963, -0.680779755115509, 0.49753981828689575, 0.3897204101085663, -0.8471229672431946, 0.490740031003952, 0.3411414921283722, -0.8355454206466675, 0.4804680049419403, 0.296918660402298, -0.8180562257766724, 0.4675918221473694, 0.25692376494407654, -0.7961328029632568, 0.4529796540737152, 0.22102873027324676, -0.771253764629364, 0.43749934434890747, 0.18910545110702515, -0.744896650314331, 0.4220190942287445, 0.1610257625579834, -0.7185395359992981, 0.4074067771434784, 0.1366615742444992, -0.6936604380607605, 0.39453068375587463, 0.11588475108146667, -0.6717371940612793, 0.3842586874961853, 0.0985671654343605, -0.6542479395866394, 0.37745893001556396, 0.08458070456981659, -0.6426705121994018, 0.37499943375587463, 0.07379723340272903, -0.638482928276062, 0.6015264391899109, 0.38972043991088867, -0.7774060964584351, 0.5933054089546204, 0.3411414921283722, -0.7667813301086426, 0.5808865427970886, 0.296918660402298, -0.750731348991394, 0.565319299697876, 0.25692376494407654, -0.7306123375892639, 0.547653079032898, 0.22102874517440796, -0.7077807188034058, 0.5289373397827148, 0.18910546600818634, -0.6835927367210388, 0.5102216005325317, 0.1610257625579834, -0.6594047546386719, 0.4925554096698761, 0.1366616040468216, -0.6365731358528137, 0.47698813676834106, 0.11588475853204727, -0.6164541244506836, 0.4645693302154541, 0.0985671654343605, -0.6004043221473694, 0.45634835958480835, 0.08458071947097778, -0.5897794961929321, 0.45337486267089843, 0.07379725575447082, -0.5859366655349731, 0.6951776742935181, 0.38972043991088867, -0.6951776742935181, 0.6856768131256103, 0.3411414921283722, -0.6856768131256103, 0.6713245511054993, 0.296918660402298, -0.6713245511054993, 0.6533335447311401, 0.25692376494407654, -0.6533335447311401, 0.6329168677330017, 0.22102874517440796, -0.6329168677330017, 0.6112874150276184, 0.18910546600818634, -0.6112874150276184, 0.5896578431129456, 0.1610257625579834, -0.5896578431129456, 0.5692411065101623, 0.1366616040468216, -0.5692411065101623, 0.5512502789497375, 0.11588476598262787, -0.5512502789497375, 0.5368979573249817, 0.0985671728849411, -0.5368979573249817, 0.527397096157074, 0.08458071202039718, -0.527397096157074, 0.5239605903625488, 0.07379724830389023, -0.5239605903625488, 0.7774059176445007, 0.38972043991088867, -0.6015264391899109, 0.766781210899353, 0.3411414921283722, -0.5933054089546204, 0.7507312297821045, 0.296918660402298, -0.5808865427970886, 0.7306122183799744, 0.25692376494407654, -0.565319299697876, 0.7077807188034058, 0.22102874517440796, -0.547653079032898, 0.6835927367210388, 0.18910546600818634, -0.5289373993873596, 0.6594046950340271, 0.1610257774591446, -0.5102216005325317, 0.636573076248169, 0.1366616189479828, -0.4925554096698761, 0.6164541244506836, 0.11588476598262787, -0.47698813676834106, 0.6004043221473694, 0.0985671728849411, -0.4645693302154541, 0.5897794961929321, 0.08458071202039718, -0.45634838938713073, 0.5859366655349731, 0.07379724830389023, -0.4533748924732208, 0.8471231460571289, 0.38972043991088867, -0.4975399076938629, 0.8355456590652466, 0.3411414921283722, -0.4907400608062744, 0.8180563449859619, 0.296918660402298, -0.48046809434890747, 0.7961330413818359, 0.25692376494407654, -0.4675918519496918, 0.7712540030479431, 0.22102876007556915, -0.45297971367836, 0.7448967695236206, 0.18910548090934753, -0.43749940395355224, 0.7185396552085876, 0.1610257774591446, -0.4220191240310669, 0.6936604976654053, 0.1366616189479828, -0.40740686655044555, 0.6717373132705688, 0.11588477343320846, -0.39453068375587463, 0.6542479395866394, 0.0985671803355217, -0.3842587471008301, 0.6426705718040466, 0.08458071947097778, -0.37745898962020874, 0.6384829878807068, 0.07379725575447082, -0.3749994933605194, 0.9032415747642517, 0.38972043991088867, -0.3843061029911041, 0.8908970355987549, 0.3411414921283722, -0.37905386090278625, 0.8722490072250366, 0.296918660402298, -0.37111958861351013, 0.8488734364509582, 0.25692376494407654, -0.3611738979816437, 0.8223462700843811, 0.22102876007556915, -0.3498872220516205, 0.7942430973052978, 0.18910548090934753, -0.33793002367019653, 0.7661399245262146, 0.1610257774591446, -0.32597288489341736, 0.7396125793457031, 0.1366616189479828, -0.31468620896339416, 0.7162370085716248, 0.11588477343320846, -0.3047405183315277, 0.697589099407196, 0.0985671803355217, -0.29680633544921875, 0.6852447986602783, 0.08458071947097778, -0.2915540933609009, 0.680779755115509, 0.07379725575447082, -0.28965434432029724, 0.9446729421615601, 0.38972043991088867, -0.2629129886627197, 0.931762158870697, 0.3411415219306946, -0.2593197822570801, 0.9122589826583862, 0.29691869020462036, -0.2538917660713196, 0.8878109455108643, 0.2569237947463989, -0.24708767235279083, 0.8600670099258423, 0.22102874517440796, -0.23936620354652405, 0.8306747674942017, 0.18910546600818634, -0.23118600249290466, 0.801282525062561, 0.1610257774591446, -0.22300581634044647, 0.7735384702682495, 0.1366615891456604, -0.2152843028306961, 0.7490906715393066, 0.11588478088378906, -0.20848020911216736, 0.7295874357223511, 0.0985671877861023, -0.20305223762989044, 0.7166768312454224, 0.08458072692155838, -0.19945906102657318, 0.7120069861412048, 0.07379726320505142, -0.19815939664840698, 0.9703295230865478, 0.38972046971321106, -0.1344483345746994, 0.957068145275116, 0.3411415219306946, -0.13261085748672485, 0.9370352625846863, 0.29691869020462036, -0.1298351138830185, 0.911923348903656, 0.2569237947463989, -0.1263556182384491, 0.8834259510040283, 0.22102877497673035, -0.12240701913833618, 0.8532353639602661, 0.18910549581050873, -0.11822382360696792, 0.8230448961257935, 0.1610257923603058, -0.11404064297676086, 0.7945472002029419, 0.13666163384914398, -0.11009202152490616, 0.7694354057312012, 0.11588477343320846, -0.10661256313323974, 0.7494025230407715, 0.0985671877861023, -0.1038367971777916, 0.7361412048339844, 0.08458072692155838, -0.10199932008981705, 0.7313445210456848, 0.07379725575447082, -0.10133469849824905, 0.7368409633636475, 0.06459397077560425, -2.8234921067848972e-9, 0.7319936752319336, 0.05551877245306969, -2.426802758748181e-9, 0.721252977848053, 0.04669983685016632, -2.041314894896118e-9, 0.7024405002593994, 0.03826524689793587, -1.6726271478972876e-9, 0.6733786463737488, 0.03034314699470997, -1.3263411480224363e-9, 0.6318891048431396, 0.02306164614856243, -1.0080566381631683e-9, 0.5757937431335449, 0.016548866406083107, -7.233739718337517e-10, 0.5029147267341614, 0.010932931676506996, -4.77893669081908e-10, 0.4110738933086395, 0.006341955158859491, -2.7721566708827083e-10, 0.2980932593345642, 0.0029040619265288114, -1.269405830450765e-10, 0.16179470717906952, 0.0007473699515685439, -3.266857964701053e-11, 0, 0, 0, 0.7302231192588806, 0.06459397822618484, 0.10117920488119125, 0.7254194021224976, 0.055518776178359985, 0.10051358491182327, 0.7147751450538635, 0.04669984057545662, 0.0990387350320816, 0.6961316466331482, 0.038265250623226166, 0.09645551443099975, 0.6673308610916138, 0.030343150720000267, 0.092464879155159, 0.6262139081954956, 0.02306164987385273, 0.08676774799823761, 0.5706223249435425, 0.016548870131373405, 0.07906502485275268, 0.4983978271484375, 0.01093293447047472, 0.0690576508641243, 0.4073818325996399, 0.006341957487165928, 0.05644654482603073, 0.2954159080982208, 0.0029040637891739607, 0.04093261808156967, 0.1603415310382843, 0.0007473709410987794, 0.022216811776161194, 0.7109150886535644, 0.06459397077560425, 0.19785544276237488, 0.706238329410553, 0.055518779903650284, 0.19655385613441467, 0.6958755254745483, 0.04669984057545662, 0.19366976618766785, 0.6777250170707703, 0.03826524689793587, 0.18861830234527588, 0.6496857404708862, 0.030343152582645416, 0.18081465363502502, 0.6096559166908264, 0.023061653599143028, 0.16967391967773437, 0.555534303188324, 0.016548873856663704, 0.15461128950119018, 0.4852195978164673, 0.01093293633311987, 0.13504190742969513, 0.3966101408004761, 0.006341959349811077, 0.11038095504045486, 0.2876047194004059, 0.0029040651861578226, 0.08004355430603027, 0.15610188245773315, 0.0007473718142136931, 0.04344487190246582, 0.6797357797622681, 0.06459398567676544, 0.28921008110046386, 0.6752641201019287, 0.05551878362894058, 0.2873075306415558, 0.6653558015823364, 0.046699848026037216, 0.28309181332588196, 0.6480013728141785, 0.03826525807380676, 0.2757079005241394, 0.6211917996406555, 0.030343158170580864, 0.2643011510372162, 0.5829176902770996, 0.023061657324433326, 0.24801647663116455, 0.5311697125434875, 0.016548875719308853, 0.22599905729293823, 0.46393883228302, 0.010932940058410167, 0.19739402830600738, 0.37921565771102905, 0.006341962143778801, 0.16134651005268097, 0.2749910056591034, 0.002904067048802972, 0.11700160056352615, 0.14925560355186462, 0.0007473727455362678, 0.0635044202208519, 0.6375038027763367, 0.06459397822618484, 0.37442436814308166, 0.6333100199699402, 0.05551878735423088, 0.37196123600006103, 0.6240172982215881, 0.046699848026037216, 0.3665033280849457, 0.6077410578727722, 0.038265254348516464, 0.35694384574890136, 0.5825971961021423, 0.030343160033226013, 0.3421761095523834, 0.5467010140419006, 0.023061661049723625, 0.32109326124191284, 0.4981682002544403, 0.01654887944459915, 0.2925885319709778, 0.435114324092865, 0.010932941921055317, 0.2555551528930664, 0.3556550145149231, 0.00634196400642395, 0.20888642966747284, 0.25790587067604065, 0.00290406821295619, 0.15147550404071808, 0.13998235762119293, 0.0007473735022358596, 0.08221566677093506, 0.5850381255149841, 0.06459400057792663, 0.4526795744895935, 0.5811893939971924, 0.05551880598068237, 0.4497016966342926, 0.5726615190505981, 0.04669985547661781, 0.4431030750274658, 0.5577248334884643, 0.03826526552438736, 0.4315456449985504, 0.5346502065658569, 0.03034316934645176, 0.4136914908885956, 0.5017082095146179, 0.023061666637659073, 0.3882022500038147, 0.4571695327758789, 0.01654888316988945, 0.35373997688293457, 0.3993050158023834, 0.010932945646345615, 0.30896660685539245, 0.3263850808143616, 0.006341966800391674, 0.25254401564598083, 0.2366805076599121, 0.002904070308431983, 0.18313412368297577, 0.128462016582489, 0.0007473743753507733, 0.09939886629581451, 0.5231571197509766, 0.06459399312734604, 0.5231571197509766, 0.5197154879570007, 0.05551879480481148, 0.5197154879570007, 0.5120896697044373, 0.04669985920190811, 0.5120896697044373, 0.4987327754497528, 0.03826526924967766, 0.4987327754497528, 0.47809892892837524, 0.03034316748380661, 0.47809892892837524, 0.44864127039909363, 0.023061666637659073, 0.44864127039909363, 0.40881362557411194, 0.0165488850325346, 0.40881362557411194, 0.3570694625377655, 0.010932947508990764, 0.3570694625377655, 0.29186245799064636, 0.006341967731714249, 0.29186245799064636, 0.2116462141275406, 0.0029040712397545576, 0.2116462141275406, 0.11487423628568649, 0.0007473749574273825, 0.11487423628568649, 0.4526796340942383, 0.06459399312734604, 0.5850381255149841, 0.4497016966342926, 0.055518798530101776, 0.5811893939971924, 0.4431031346321106, 0.04669986292719841, 0.5726615190505981, 0.4315456449985504, 0.03826527297496796, 0.5577248334884643, 0.4136914908885956, 0.03034317120909691, 0.5346502065658569, 0.3882022500038147, 0.023061668500304222, 0.5017082095146179, 0.35373997688293457, 0.01654888689517975, 0.4571695327758789, 0.30896660685539245, 0.010932949371635913, 0.3993050158023834, 0.25254401564598083, 0.006341969594359398, 0.3263850808143616, 0.18313412368297577, 0.0029040721710771322, 0.2366805076599121, 0.09939886629581451, 0.0007473755395039916, 0.128462016582489, 0.37442445755004883, 0.06459400057792663, 0.6375038623809814, 0.3719612658023834, 0.055518798530101776, 0.6333100199699402, 0.36650341749191284, 0.04669986292719841, 0.6240173578262329, 0.35694390535354614, 0.03826527297496796, 0.6077410578727722, 0.3421761691570282, 0.030343173071742058, 0.5825971961021423, 0.3210933208465576, 0.02306167036294937, 0.5467010736465454, 0.29258856177330017, 0.016548888757824898, 0.4981682598590851, 0.2555552124977112, 0.010932950302958488, 0.43511438369750976, 0.20888645946979523, 0.0063419705256819725, 0.3556550443172455, 0.15147554874420166, 0.002904073102399707, 0.25790587067604065, 0.08221568167209625, 0.0007473760633729398, 0.13998237252235412, 0.28921014070510864, 0.06459400057792663, 0.6797357797622681, 0.28730759024620056, 0.055518802255392075, 0.6752641201019287, 0.28309184312820434, 0.04669986665248871, 0.6653558015823364, 0.2757079601287842, 0.038265276700258255, 0.6480014324188232, 0.26430121064186096, 0.030343174934387207, 0.6211917996406555, 0.24801650643348694, 0.02306167222559452, 0.5829176902770996, 0.22599910199642181, 0.016548888757824898, 0.5311697721481323, 0.19739408791065216, 0.010932952165603637, 0.46393883228302, 0.16134655475616455, 0.006341971922665834, 0.37921568751335144, 0.11700160801410675, 0.0029040740337222814, 0.2749910056591034, 0.0635044276714325, 0.0007473764708265662, 0.14925560355186462, 0.19785551726818085, 0.06459400057792663, 0.7109150886535644, 0.19655394554138183, 0.055518802255392075, 0.706238329410553, 0.193669855594635, 0.04669986665248871, 0.6958755254745483, 0.18861837685108185, 0.038265276700258255, 0.6777250170707703, 0.180814728140831, 0.030343174934387207, 0.6496857404708862, 0.16967399418354034, 0.02306167222559452, 0.6096559762954712, 0.15461137890815735, 0.016548890620470047, 0.555534303188324, 0.1350419670343399, 0.010932953096926212, 0.4852195978164673, 0.11038099974393844, 0.006341972388327122, 0.3966101408004761, 0.08004358410835266, 0.0029040744993835687, 0.28760477900505066, 0.043444886803627014, 0.0007473767618648708, 0.15610191226005554, 0.10117930173873901, 0.06459399312734604, 0.7302230000495911, 0.10051370412111282, 0.05551880598068237, 0.7254192233085632, 0.09903883934020996, 0.04669986292719841, 0.7147750854492187, 0.09645561128854751, 0.03826526924967766, 0.6961316466331482, 0.09246497601270675, 0.030343174934387207, 0.6673307418823242, 0.08676782995462417, 0.02306167408823967, 0.626213788986206, 0.07906511425971985, 0.016548890620470047, 0.5706223249435425, 0.06905772536993027, 0.010932952165603637, 0.4983977675437927, 0.05644660443067551, 0.006341972388327122, 0.4073818325996399, 0.04093266651034355, 0.0029040744993835687, 0.2954159080982208, 0.022216835990548134, 0.0007473768782801926, 0.1603415310382843, 1.4756830069018178e-7, 0.06459400802850723, 0.7368409633636475, 1.4659754299373162e-7, 0.05551882088184357, 0.7319936752319336, 1.4444648854805564e-7, 0.04669986665248871, 0.721252977848053, 1.4067889253510657e-7, 0.038265276700258255, 0.7024405002593994, 1.3485863803452957e-7, 0.030343180522322654, 0.6733787655830383, 1.2654942338485853e-7, 0.023061677813529968, 0.6318891048431396, 1.1531512456031123e-7, 0.016548894345760345, 0.5757937431335449, 1.0071953226997721e-7, 0.010932954028248787, 0.5029147267341614, 8.232643011751861e-8, 0.006341973785310984, 0.4110738933086395, 5.96996017065976e-8, 0.0029040754307061433, 0.2980932891368866, 3.240288037886785e-8, 0.0007473771111108363, 0.16179470717906952, -0.10117920488119125, 0.06459400057792663, 0.7302231192588806, -0.10051358491182327, 0.05551880598068237, 0.7254194021224976, -0.0990387350320816, 0.04669986665248871, 0.7147751450538635, -0.09645551443099975, 0.038265276700258255, 0.6961316466331482, -0.092464879155159, 0.030343176797032356, 0.6673308610916138, -0.08676774799823761, 0.02306167408823967, 0.6262139081954956, -0.07906502485275268, 0.016548890620470047, 0.5706223249435425, -0.0690576508641243, 0.010932953096926212, 0.4983978271484375, -0.05644654482603073, 0.006341972853988409, 0.4073818325996399, -0.04093261808156967, 0.0029040747322142124, 0.2954159080982208, -0.022216811776161194, 0.0007473769364878535, 0.1603415310382843, -0.19785544276237488, 0.06459399312734604, 0.7109150886535644, -0.19655385613441467, 0.055518802255392075, 0.706238329410553, -0.19366976618766785, 0.04669986292719841, 0.6958755254745483, -0.18861830234527588, 0.03826526924967766, 0.6777250170707703, -0.18081465363502502, 0.030343173071742058, 0.6496857404708862, -0.16967391967773437, 0.02306167222559452, 0.6096559166908264, -0.15461128950119018, 0.016548890620470047, 0.555534303188324, -0.13504190742969513, 0.010932952165603637, 0.4852195978164673, -0.11038095504045486, 0.006341971922665834, 0.3966101408004761, -0.08004355430603027, 0.002904074266552925, 0.2876047194004059, -0.04344487190246582, 0.0007473767036572099, 0.15610188245773315, -0.28921008110046386, 0.06459400057792663, 0.6797357797622681, -0.2873075306415558, 0.055518802255392075, 0.6752641201019287, -0.28309181332588196, 0.04669986665248871, 0.6653558015823364, -0.2757079005241394, 0.038265276700258255, 0.6480013728141785, -0.2643011510372162, 0.030343174934387207, 0.6211917996406555, -0.24801647663116455, 0.02306167222559452, 0.5829176902770996, -0.22599905729293823, 0.016548888757824898, 0.5311697125434875, -0.19739402830600738, 0.010932952165603637, 0.46393883228302, -0.16134651005268097, 0.006341971922665834, 0.37921565771102905, -0.11700160056352615, 0.0029040740337222814, 0.2749910056591034, -0.0635044202208519, 0.0007473764708265662, 0.14925560355186462, -0.37442436814308166, 0.06459399312734604, 0.6375038027763367, -0.37196123600006103, 0.055518798530101776, 0.6333100199699402, -0.3665033280849457, 0.04669985920190811, 0.6240172982215881, -0.35694384574890136, 0.03826526552438736, 0.6077410578727722, -0.3421761095523834, 0.03034317120909691, 0.5825971961021423, -0.32109326124191284, 0.02306167036294937, 0.5467010140419006, -0.2925885319709778, 0.016548888757824898, 0.4981682002544403, -0.2555551528930664, 0.010932949371635913, 0.435114324092865, -0.20888642966747284, 0.006341970060020685, 0.3556550145149231, -0.15147550404071808, 0.002904072869569063, 0.25790587067604065, -0.08221566677093506, 0.0007473760051652789, 0.13998235762119293, -0.4526795744895935, 0.06459400057792663, 0.5850381255149841, -0.4497016966342926, 0.05551881343126297, 0.5811893939971924, -0.4431030750274658, 0.04669986292719841, 0.5726615190505981, -0.4315456449985504, 0.03826527297496796, 0.5577248334884643, -0.4136914908885956, 0.030343174934387207, 0.5346502065658569, -0.3882022500038147, 0.02306167222559452, 0.5017082095146179, -0.35373997688293457, 0.016548888757824898, 0.4571695327758789, -0.30896660685539245, 0.010932949371635913, 0.3993050158023834, -0.25254401564598083, 0.006341970060020685, 0.3263850808143616, -0.18313412368297577, 0.0029040726367384195, 0.2366805076599121, -0.09939886629581451, 0.0007473755977116525, 0.128462016582489, -0.5231571197509766, 0.06459399312734604, 0.5231571197509766, -0.5197154879570007, 0.05551879480481148, 0.5197154879570007, -0.5120896697044373, 0.04669985920190811, 0.5120896697044373, -0.4987327754497528, 0.03826526924967766, 0.4987327754497528, -0.47809892892837524, 0.03034316748380661, 0.47809892892837524, -0.44864127039909363, 0.023061666637659073, 0.44864127039909363, -0.40881362557411194, 0.0165488850325346, 0.40881362557411194, -0.3570694625377655, 0.010932947508990764, 0.3570694625377655, -0.29186245799064636, 0.006341967731714249, 0.29186245799064636, -0.2116462141275406, 0.0029040712397545576, 0.2116462141275406, -0.11487423628568649, 0.0007473749574273825, 0.11487423628568649, -0.5850381255149841, 0.06459399312734604, 0.4526796340942383, -0.5811893939971924, 0.05551879107952118, 0.4497016966342926, -0.5726615190505981, 0.04669985547661781, 0.4431031346321106, -0.5577248334884643, 0.03826526552438736, 0.4315456449985504, -0.5346502065658569, 0.03034316562116146, 0.4136914908885956, -0.5017082095146179, 0.023061662912368774, 0.3882022500038147, -0.4571695327758789, 0.0165488813072443, 0.35373997688293457, -0.3993050158023834, 0.010932945646345615, 0.30896660685539245, -0.3263850808143616, 0.006341966334730387, 0.25254401564598083, -0.2366805076599121, 0.0029040698427706957, 0.18313412368297577, -0.128462016582489, 0.0007473743171431124, 0.09939886629581451, -0.6375038623809814, 0.06459398567676544, 0.37442445755004883, -0.6333100199699402, 0.05551878735423088, 0.3719612658023834, -0.6240173578262329, 0.046699851751327515, 0.36650341749191284, -0.6077410578727722, 0.03826526179909706, 0.35694390535354614, -0.5825971961021423, 0.030343161895871162, 0.3421761691570282, -0.5467010736465454, 0.023061661049723625, 0.3210933208465576, -0.4981682598590851, 0.01654887944459915, 0.29258856177330017, -0.43511438369750976, 0.010932942852377891, 0.2555552124977112, -0.3556550443172455, 0.0063419644720852375, 0.20888645946979523, -0.25790587067604065, 0.0029040684457868337, 0.15147554874420166, -0.13998237252235412, 0.0007473735604435205, 0.08221568167209625, -0.6797357797622681, 0.06459398567676544, 0.28921014070510864, -0.6752641201019287, 0.05551878362894058, 0.28730759024620056, -0.6653558015823364, 0.046699848026037216, 0.28309184312820434, -0.6480014324188232, 0.03826525807380676, 0.2757079601287842, -0.6211917996406555, 0.030343158170580864, 0.26430121064186096, -0.5829176902770996, 0.023061657324433326, 0.24801650643348694, -0.5311697721481323, 0.016548875719308853, 0.22599910199642181, -0.46393883228302, 0.010932940058410167, 0.19739408791065216, -0.37921568751335144, 0.006341962143778801, 0.16134655475616455, -0.2749910056591034, 0.002904067048802972, 0.11700160801410675, -0.14925560355186462, 0.0007473727455362678, 0.0635044276714325, -0.7109150886535644, 0.06459397822618484, 0.19785551726818085, -0.706238329410553, 0.055518779903650284, 0.19655394554138183, -0.6958755254745483, 0.04669984430074692, 0.193669855594635, -0.6777250170707703, 0.038265254348516464, 0.18861837685108185, -0.6496857404708862, 0.030343154445290565, 0.180814728140831, -0.6096559762954712, 0.023061653599143028, 0.16967399418354034, -0.555534303188324, 0.016548873856663704, 0.15461137890815735, -0.4852195978164673, 0.010932937264442443, 0.1350419670343399, -0.3966101408004761, 0.006341959815472364, 0.11038099974393844, -0.28760477900505066, 0.0029040654189884662, 0.08004358410835266, -0.15610191226005554, 0.0007473718724213541, 0.043444886803627014, -0.7302230000495911, 0.06459397077560425, 0.10117930173873901, -0.7254192233085632, 0.055518776178359985, 0.10051370412111282, -0.7147750854492187, 0.04669983685016632, 0.09903883934020996, -0.6961316466331482, 0.03826524317264557, 0.09645561128854751, -0.6673307418823242, 0.030343148857355118, 0.09246497601270675, -0.626213788986206, 0.02306164987385273, 0.08676782995462417, -0.5706223249435425, 0.016548870131373405, 0.07906511425971985, -0.4983977675437927, 0.010932933539152145, 0.06905772536993027, -0.4073818325996399, 0.006341957021504641, 0.05644660443067551, -0.2954159080982208, 0.002904063556343317, 0.04093266651034355, -0.1603415310382843, 0.0007473708828911185, 0.022216835990548134, -0.7368409633636475, 0.06459397822618484, 1.4474480281023716e-7, -0.7319936752319336, 0.05551878735423088, 1.4417074112316186e-7, -0.721252977848053, 0.04669983685016632, 1.4240517032249045e-7, -0.7024405002593994, 0.03826524689793587, 1.3900626072427258e-7, -0.6733787655830383, 0.030343150720000267, 1.3353229633139563e-7, -0.6318891048431396, 0.02306164987385273, 1.2554136219478096e-7, -0.5757937431335449, 0.016548868268728256, 1.145917494227433e-7, -0.5029147267341614, 0.010932931676506996, 1.0024163543675968e-7, -0.4110738933086395, 0.006341955624520779, 8.204921186916181e-8, -0.2980932891368866, 0.0029040623921900987, 5.9572659694140384e-8, -0.16179470717906952, 0.0007473700097762048, 3.237021317659128e-8, -0.7302231192588806, 0.06459396332502365, -0.10117920488119125, -0.7254194021224976, 0.05551876872777939, -0.10051358491182327, -0.7147751450538635, 0.04669983312487602, -0.0990387350320816, -0.6961316466331482, 0.03826524317264557, -0.09645551443099975, -0.6673308610916138, 0.03034314326941967, -0.092464879155159, -0.6262139081954956, 0.023061642423272133, -0.08676774799823761, -0.5706223249435425, 0.01654886268079281, -0.07906502485275268, -0.4983978271484375, 0.010932928882539272, -0.0690576508641243, -0.4073818325996399, 0.006341952830553055, -0.05644654482603073, -0.2954159080982208, 0.0029040600638836622, -0.04093261808156967, -0.1603415310382843, 0.0007473689620383084, -0.022216811776161194, -0.7109150886535644, 0.06459395587444305, -0.19785544276237488, -0.706238329410553, 0.05551876500248909, -0.19655385613441467, -0.6958755254745483, 0.046699825674295425, -0.19366976618766785, -0.6777250170707703, 0.03826523199677467, -0.18861830234527588, -0.6496857404708862, 0.030343137681484222, -0.18081465363502502, -0.6096559166908264, 0.023061638697981834, -0.16967391967773437, -0.555534303188324, 0.01654885895550251, -0.15461128950119018, -0.4852195978164673, 0.010932925157248973, -0.13504190742969513, -0.3966101408004761, 0.006341950036585331, -0.11038095504045486, -0.2876047194004059, 0.002904058201238513, -0.08004355430603027, -0.15610188245773315, 0.0007473679725080728, -0.04344487190246582, -0.6797357797622681, 0.06459395587444305, -0.28921008110046386, -0.6752641201019287, 0.05551876127719879, -0.2873075306415558, -0.6653558015823364, 0.046699825674295425, -0.28309181332588196, -0.6480013728141785, 0.03826523572206497, -0.2757079005241394, -0.6211917996406555, 0.030343135818839073, -0.2643011510372162, -0.5829176902770996, 0.023061634972691536, -0.24801647663116455, -0.5311697125434875, 0.01654885709285736, -0.22599905729293823, -0.46393883228302, 0.010932923294603824, -0.19739402830600738, -0.37921565771102905, 0.006341948173940182, -0.16134651005268097, -0.2749910056591034, 0.002904056804254651, -0.11700160056352615, -0.14925560355186462, 0.0007473671576008201, -0.0635044202208519, -0.6375038027763367, 0.06459394842386246, -0.37442436814308166, -0.6333100199699402, 0.05551875755190849, -0.37196123600006103, -0.6240172982215881, 0.04669981822371483, -0.3665033280849457, -0.6077410578727722, 0.03826522454619408, -0.35694384574890136, -0.5825971961021423, 0.030343130230903625, -0.3421761095523834, -0.5467010140419006, 0.023061631247401237, -0.32109326124191284, -0.4981682002544403, 0.016548853367567062, -0.2925885319709778, -0.435114324092865, 0.010932919569313526, -0.2555551528930664, -0.3556550145149231, 0.006341945379972458, -0.20888642966747284, -0.25790587067604065, 0.0029040551744401455, -0.15147550404071808, -0.13998235762119293, 0.0007473662844859064, -0.08221566677093506, -0.5850381255149841, 0.06459395587444305, -0.4526795744895935, -0.5811893939971924, 0.05551876872777939, -0.4497016966342926, -0.5726615190505981, 0.04669981822371483, -0.4431030750274658, -0.5577248334884643, 0.038265228271484375, -0.4315456449985504, -0.5346502065658569, 0.030343132093548774, -0.4136914908885956, -0.5017082095146179, 0.023061633110046386, -0.3882022500038147, -0.4571695327758789, 0.016548853367567062, -0.35373997688293457, -0.3993050158023834, 0.010932917706668377, -0.30896660685539245, -0.3263850808143616, 0.006341944448649883, -0.25254401564598083, -0.2366805076599121, 0.0029040544759482145, -0.18313412368297577, -0.128462016582489, 0.0007473656442016363, -0.09939886629581451, -0.5231571197509766, 0.06459394842386246, -0.5231571197509766, -0.5197154879570007, 0.055518750101327896, -0.5197154879570007, -0.5120896697044373, 0.04669981449842453, -0.5120896697044373, -0.4987327754497528, 0.03826522454619408, -0.4987327754497528, -0.47809892892837524, 0.030343126505613327, -0.47809892892837524, -0.44864127039909363, 0.02306162565946579, -0.44864127039909363, -0.40881362557411194, 0.016548847779631614, -0.40881362557411194, -0.3570694625377655, 0.010932915844023227, -0.3570694625377655, -0.29186245799064636, 0.006341942586004734, -0.29186245799064636, -0.2116462141275406, 0.0029040526133030653, -0.2116462141275406, -0.11487423628568649, 0.0007473649457097053, -0.11487423628568649, -0.4526796340942383, 0.06459394842386246, -0.5850381255149841, -0.4497016966342926, 0.0555187463760376, -0.5811893939971924, -0.4431031346321106, 0.04669981077313423, -0.5726615190505981, -0.4315456449985504, 0.03826522082090378, -0.5577248334884643, -0.4136914908885956, 0.03034312278032303, -0.5346502065658569, -0.3882022500038147, 0.02306162379682064, -0.5017082095146179, -0.35373997688293457, 0.016548845916986465, -0.4571695327758789, -0.30896660685539245, 0.010932913981378078, -0.3993050158023834, -0.25254401564598083, 0.006341940723359585, -0.3263850808143616, -0.18313412368297577, 0.0029040516819804907, -0.2366805076599121, -0.09939886629581451, 0.0007473643636330962, -0.128462016582489, -0.37442445755004883, 0.06459394097328186, -0.6375038623809814, -0.3719612658023834, 0.0555187463760376, -0.6333100199699402, -0.36650341749191284, 0.04669981077313423, -0.6240173578262329, -0.35694390535354614, 0.03826522082090378, -0.6077410578727722, -0.3421761691570282, 0.03034312091767788, -0.5825971961021423, -0.3210933208465576, 0.02306162193417549, -0.5467010736465454, -0.29258856177330017, 0.016548844054341316, -0.4981682598590851, -0.2555552124977112, 0.010932913050055503, -0.43511438369750976, -0.20888645946979523, 0.00634193979203701, -0.3556550443172455, -0.15147554874420166, 0.002904050750657916, -0.25790587067604065, -0.08221568167209625, 0.000747363839764148, -0.13998237252235412, -0.28921014070510864, 0.06459394097328186, -0.6797357797622681, -0.28730759024620056, 0.0555187426507473, -0.6752641201019287, -0.28309184312820434, 0.04669980704784393, -0.6653558015823364, -0.2757079601287842, 0.03826521709561348, -0.6480014324188232, -0.26430121064186096, 0.03034311905503273, -0.6211917996406555, -0.24801650643348694, 0.023061620071530342, -0.5829176902770996, -0.22599910199642181, 0.016548844054341316, -0.5311697721481323, -0.19739408791065216, 0.010932911187410354, -0.46393883228302, -0.16134655475616455, 0.006341938395053148, -0.37921568751335144, -0.11700160801410675, 0.0029040498193353414, -0.2749910056591034, -0.0635044276714325, 0.0007473634323105216, -0.14925560355186462, -0.19785551726818085, 0.06459394097328186, -0.7109150886535644, -0.19655394554138183, 0.0555187426507473, -0.706238329410553, -0.193669855594635, 0.04669980704784393, -0.6958755254745483, -0.18861837685108185, 0.03826521709561348, -0.6777250170707703, -0.180814728140831, 0.03034311905503273, -0.6496857404708862, -0.16967399418354034, 0.023061620071530342, -0.6096559762954712, -0.15461137890815735, 0.016548842191696167, -0.555534303188324, -0.1350419670343399, 0.01093291025608778, -0.4852195978164673, -0.11038099974393844, 0.006341937929391861, -0.3966101408004761, -0.08004358410835266, 0.002904049353674054, -0.28760477900505066, -0.043444886803627014, 0.000747363141272217, -0.15610191226005554, -0.10117930173873901, 0.06459393352270126, -0.7302230000495911, -0.10051370412111282, 0.055518738925457, -0.7254192233085632, -0.09903883934020996, 0.046699803322553635, -0.7147750854492187, -0.09645561128854751, 0.03826520964503288, -0.6961316466331482, -0.09246497601270675, 0.03034311532974243, -0.6673307418823242, -0.08676782995462417, 0.023061618208885193, -0.626213788986206, -0.07906511425971985, 0.016548842191696167, -0.5706223249435425, -0.06905772536993027, 0.010932909324765205, -0.4983977675437927, -0.05644660443067551, 0.006341936998069286, -0.4073818325996399, -0.04093266651034355, 0.002904048888012767, -0.2954159080982208, -0.022216835990548134, 0.0007473629084415734, -0.1603415310382843, -1.4756830069018178e-7, 0.06459394842386246, -0.7368409633636475, -1.4659754299373162e-7, 0.055518753826618195, -0.7319936752319336, -1.4444648854805564e-7, 0.04669980704784393, -0.721252977848053, -1.4067889253510657e-7, 0.03826521709561348, -0.7024405002593994, -1.3485863803452957e-7, 0.03034312091767788, -0.6733787655830383, -1.2654942338485853e-7, 0.02306162193417549, -0.6318891048431396, -1.1531512456031123e-7, 0.016548842191696167, -0.5757937431335449, -1.0071953226997721e-7, 0.010932909324765205, -0.5029147267341614, -8.232643011751861e-8, 0.006341937463730574, -0.4110738933086395, -5.96996017065976e-8, 0.002904049353674054, -0.2980932891368866, -3.240288037886785e-8, 0.0007473629084415734, -0.16179470717906952, 0.10117920488119125, 0.06459394097328186, -0.7302231192588806, 0.10051358491182327, 0.055518738925457, -0.7254194021224976, 0.0990387350320816, 0.04669980704784393, -0.7147751450538635, 0.09645551443099975, 0.03826521709561348, -0.6961316466331482, 0.092464879155159, 0.03034311719238758, -0.6673308610916138, 0.08676774799823761, 0.023061618208885193, -0.6262139081954956, 0.07906502485275268, 0.016548842191696167, -0.5706223249435425, 0.0690576508641243, 0.01093291025608778, -0.4983978271484375, 0.05644654482603073, 0.006341937463730574, -0.4073818325996399, 0.04093261808156967, 0.0029040491208434105, -0.2954159080982208, 0.022216811776161194, 0.0007473629666492343, -0.1603415310382843, 0.19785544276237488, 0.06459393352270126, -0.7109150886535644, 0.19655385613441467, 0.0555187426507473, -0.706238329410553, 0.19366976618766785, 0.046699803322553635, -0.6958755254745483, 0.18861830234527588, 0.03826520964503288, -0.6777250170707703, 0.18081465363502502, 0.03034311719238758, -0.6496857404708862, 0.16967391967773437, 0.023061620071530342, -0.6096559166908264, 0.15461128950119018, 0.016548842191696167, -0.555534303188324, 0.13504190742969513, 0.010932909324765205, -0.4852195978164673, 0.11038095504045486, 0.006341937463730574, -0.3966101408004761, 0.08004355430603027, 0.0029040491208434105, -0.2876047194004059, 0.04344487190246582, 0.0007473630830645561, -0.15610188245773315, 0.28921008110046386, 0.06459394097328186, -0.6797357797622681, 0.2873075306415558, 0.0555187426507473, -0.6752641201019287, 0.28309181332588196, 0.04669980704784393, -0.6653558015823364, 0.2757079005241394, 0.03826521709561348, -0.6480013728141785, 0.2643011510372162, 0.03034311905503273, -0.6211917996406555, 0.24801647663116455, 0.023061620071530342, -0.5829176902770996, 0.22599905729293823, 0.016548844054341316, -0.5311697125434875, 0.19739402830600738, 0.010932911187410354, -0.46393883228302, 0.16134651005268097, 0.006341938395053148, -0.37921565771102905, 0.11700160056352615, 0.0029040498193353414, -0.2749910056591034, 0.0635044202208519, 0.0007473634323105216, -0.14925560355186462, 0.37442436814308166, 0.06459393352270126, -0.6375038027763367, 0.37196123600006103, 0.0555187463760376, -0.6333100199699402, 0.3665033280849457, 0.04669980704784393, -0.6240172982215881, 0.35694384574890136, 0.03826521337032318, -0.6077410578727722, 0.3421761095523834, 0.03034311905503273, -0.5825971961021423, 0.32109326124191284, 0.02306162193417549, -0.5467010140419006, 0.2925885319709778, 0.016548844054341316, -0.4981682002544403, 0.2555551528930664, 0.01093291211873293, -0.435114324092865, 0.20888642966747284, 0.006341939326375723, -0.3556550145149231, 0.15147550404071808, 0.0029040505178272724, -0.25790587067604065, 0.08221566677093506, 0.0007473637815564871, -0.13998235762119293, 0.4526795744895935, 0.06459395587444305, -0.5850381255149841, 0.4497016966342926, 0.05551876127719879, -0.5811893939971924, 0.4431030750274658, 0.04669981077313423, -0.5726615190505981, 0.4315456449985504, 0.03826522082090378, -0.5577248334884643, 0.4136914908885956, 0.030343126505613327, -0.5346502065658569, 0.3882022500038147, 0.02306162752211094, -0.5017082095146179, 0.35373997688293457, 0.016548847779631614, -0.4571695327758789, 0.30896660685539245, 0.010932913981378078, -0.3993050158023834, 0.25254401564598083, 0.006341941189020872, -0.3263850808143616, 0.18313412368297577, 0.002904052147641778, -0.2366805076599121, 0.09939886629581451, 0.0007473644218407571, -0.128462016582489, 0.5231571197509766, 0.06459394842386246, -0.5231571197509766, 0.5197154879570007, 0.055518750101327896, -0.5197154879570007, 0.5120896697044373, 0.04669981449842453, -0.5120896697044373, 0.4987327754497528, 0.03826522454619408, -0.4987327754497528, 0.47809892892837524, 0.030343126505613327, -0.47809892892837524, 0.44864127039909363, 0.02306162565946579, -0.44864127039909363, 0.40881362557411194, 0.016548847779631614, -0.40881362557411194, 0.3570694625377655, 0.010932915844023227, -0.3570694625377655, 0.29186245799064636, 0.006341942586004734, -0.29186245799064636, 0.2116462141275406, 0.0029040526133030653, -0.2116462141275406, 0.11487423628568649, 0.0007473649457097053, -0.11487423628568649, 0.5850381255149841, 0.06459394842386246, -0.4526796340942383, 0.5811893939971924, 0.055518753826618195, -0.4497016966342926, 0.5726615190505981, 0.04669981822371483, -0.4431031346321106, 0.5577248334884643, 0.038265228271484375, -0.4315456449985504, 0.5346502065658569, 0.030343128368258476, -0.4136914908885956, 0.5017082095146179, 0.023061629384756088, -0.3882022500038147, 0.4571695327758789, 0.016548851504921913, -0.35373997688293457, 0.3993050158023834, 0.010932917706668377, -0.30896660685539245, 0.3263850808143616, 0.006341943982988596, -0.25254401564598083, 0.2366805076599121, 0.0029040540102869272, -0.18313412368297577, 0.128462016582489, 0.0007473655859939754, -0.09939886629581451, 0.6375038623809814, 0.06459395587444305, -0.37442445755004883, 0.6333100199699402, 0.05551875755190849, -0.3719612658023834, 0.6240173578262329, 0.04669982194900513, -0.36650341749191284, 0.6077410578727722, 0.03826523199677467, -0.35694390535354614, 0.5825971961021423, 0.030343132093548774, -0.3421761691570282, 0.5467010736465454, 0.023061631247401237, -0.3210933208465576, 0.4981682598590851, 0.016548853367567062, -0.29258856177330017, 0.43511438369750976, 0.0109329205006361, -0.2555552124977112, 0.3556550443172455, 0.006341945845633745, -0.20888645946979523, 0.25790587067604065, 0.002904055407270789, -0.15147554874420166, 0.13998237252235412, 0.0007473663426935673, -0.08221568167209625, 0.6797357797622681, 0.06459395587444305, -0.28921014070510864, 0.6752641201019287, 0.05551876127719879, -0.28730759024620056, 0.6653558015823364, 0.046699825674295425, -0.28309184312820434, 0.6480014324188232, 0.03826523572206497, -0.2757079601287842, 0.6211917996406555, 0.030343135818839073, -0.26430121064186096, 0.5829176902770996, 0.023061634972691536, -0.24801650643348694, 0.5311697721481323, 0.01654885709285736, -0.22599910199642181, 0.46393883228302, 0.010932923294603824, -0.19739408791065216, 0.37921568751335144, 0.006341948173940182, -0.16134655475616455, 0.2749910056591034, 0.002904056804254651, -0.11700160801410675, 0.14925560355186462, 0.0007473671576008201, -0.0635044276714325, 0.7109150886535644, 0.06459396332502365, -0.19785551726818085, 0.706238329410553, 0.05551876500248909, -0.19655394554138183, 0.6958755254745483, 0.046699829399585724, -0.193669855594635, 0.6777250170707703, 0.03826523944735527, -0.18861837685108185, 0.6496857404708862, 0.03034313954412937, -0.180814728140831, 0.6096559762954712, 0.023061638697981834, -0.16967399418354034, 0.555534303188324, 0.01654885895550251, -0.15461137890815735, 0.4852195978164673, 0.010932926088571548, -0.1350419670343399, 0.3966101408004761, 0.006341950502246618, -0.11038099974393844, 0.28760477900505066, 0.0029040584340691566, -0.08004358410835266, 0.15610191226005554, 0.0007473680307157338, -0.043444886803627014, 0.7302230000495911, 0.06459395587444305, -0.10117930173873901, 0.7254192233085632, 0.05551876872777939, -0.10051370412111282, 0.7147750854492187, 0.046699829399585724, -0.09903883934020996, 0.6961316466331482, 0.03826523572206497, -0.09645561128854751, 0.6673307418823242, 0.03034314140677452, -0.09246497601270675, 0.626213788986206, 0.023061642423272133, -0.08676782995462417, 0.5706223249435425, 0.01654886268079281, -0.07906511425971985, 0.4983977675437927, 0.010932927951216697, -0.06905772536993027, 0.4073818325996399, 0.0063419523648917675, -0.05644660443067551, 0.2954159080982208, 0.0029040598310530185, -0.04093266651034355, 0.1603415310382843, 0.0007473689038306475, -0.022216835990548134, -0.7871708869934082, 0.9962632060050964, -4.35480487226414e-8, -0.8701643943786621, 0.9961992502212524, -4.354525273697618e-8, -0.9468371272087097, 0.9957507252693176, -4.352564531018288e-8, -1.017018437385559, 0.9945334792137146, -4.3472439870129165e-8, -1.0805375576019287, 0.9921631217002869, -4.336882852840063e-8, -1.1372239589691162, 0.9882556200027466, -4.3198024712864935e-8, -1.1869062185287475, 0.9824261665344238, -4.294321342968033e-8, -1.2294135093688964, 0.9742904901504517, -4.2587590343146075e-8, -1.264575481414795, 0.9634643793106079, -4.211436888112985e-8, -1.2922208309173584, 0.9495633244514465, -4.1506734049789884e-8, -1.3121790885925293, 0.9322029948234558, -4.074788861885281e-8, -1.324279546737671, 0.910999059677124, -3.9821035358045265e-8, -1.3283507823944091, 0.8855671882629394, -3.8709373484380194e-8, -0.7862029671669006, 0.9984412789344788, 0.03382370248436928, -0.8698827028274536, 0.9983760118484497, 0.03382370248436928, -0.9471644759178162, 0.9979186058044434, 0.03382370248436928, -1.017880916595459, 0.996677577495575, 0.03382370248436928, -1.0818642377853393, 0.9942605495452881, 0.03382369503378868, -1.1389474868774414, 0.9902761578559875, 0.03382370248436928, -1.1889632940292358, 0.9843319654464722, 0.03382370248436928, -1.231743335723877, 0.9760362505912781, 0.033823706209659576, -1.2671208381652832, 0.9649969935417175, 0.033823706209659576, -1.2949284315109253, 0.9508225321769714, 0.033823709934949875, -1.3149980306625366, 0.9331206679344177, 0.033823706209659576, -1.327162742614746, 0.9114995002746582, 0.03382370248436928, -1.3312549591064453, 0.8855671882629394, 0.033823709934949875, -0.7835265398025513, 1.0044628381729126, 0.061497677117586136, -0.8691034913063049, 1.0043941736221313, 0.06149768456816673, -0.9480686187744141, 1.003912329673767, 0.06149767339229584, -1.0202642679214477, 1.0026050806045532, 0.061497677117586136, -1.08553147315979, 1.0000591278076171, 0.06149766966700554, -1.1437128782272338, 0.9958622455596924, 0.061497677117586136, -1.1946499347686767, 0.9896008372306824, 0.061497677117586136, -1.2381845712661743, 0.9808626174926758, 0.061497677117586136, -1.2741584777832031, 0.9692344069480896, 0.061497677117586136, -1.3024134635925293, 0.9543037414550781, 0.061497680842876434, -1.322791337966919, 0.9356575012207031, 0.061497680842876434, -1.3351340293884277, 0.9128828644752502, 0.061497680842876434, -1.3392835855484008, 0.8855671286582947, 0.06149768456816673, -0.7794836759567261, 1.0135594606399536, 0.08302187919616699, -0.8679267764091492, 1.0134854316711425, 0.08302188664674759, -0.9494351744651794, 1.0129667520523071, 0.0830218717455864, -1.0238648653030395, 1.0115596055984497, 0.08302187919616699, -1.0910718441009521, 1.0088187456130981, 0.0830218642950058, -1.1509121656417846, 1.0043007135391235, 0.08302187919616699, -1.2032414674758911, 0.9975603222846985, 0.08302188664674759, -1.2479151487350463, 0.9881534576416016, 0.0830218717455864, -1.2847899198532104, 0.975635826587677, 0.08302187919616699, -1.313720941543579, 0.9595627188682556, 0.0830218717455864, -1.3345645666122436, 0.9394898414611816, 0.0830218717455864, -1.347176432609558, 0.9149727821350098, 0.08302188664674759, -1.3514124155044555, 0.8855671286582947, 0.08302188664674759, -0.7744156718254089, 1.0249619483947754, 0.09839631617069244, -0.8664514422416687, 1.0248812437057495, 0.09839632362127304, -0.9511478543281555, 1.0243165493011474, 0.09839631617069244, -1.0283784866333007, 1.022783875465393, 0.09839631617069244, -1.0980167388916015, 1.019798994064331, 0.09839630126953125, -1.1599361896514892, 1.0148783922195434, 0.09839631617069244, -1.2140103578567504, 1.007537603378296, 0.09839632362127304, -1.2601126432418823, 0.997292697429657, 0.09839632362127304, -1.2981163263320922, 0.9836598038673401, 0.09839631617069244, -1.327895164489746, 0.9661547541618347, 0.09839631617069244, -1.3493221998214721, 0.9442936778068542, 0.09839631617069244, -1.3622714281082153, 0.9175924062728882, 0.09839633107185364, -1.366615891456604, 0.8855671286582947, 0.09839632362127304, -0.768664538860321, 1.0379022359848022, 0.10762098431587219, -0.8647773861885071, 1.0378140211105346, 0.10762099176645279, -0.9530913829803467, 1.0371968746185302, 0.107620969414711, -1.0335007905960083, 1.0355219841003418, 0.10762099176645279, -1.1058980226516723, 1.0322600603103637, 0.107620969414711, -1.1701773405075073, 1.026882529258728, 0.10762098431587219, -1.2262318134307861, 1.0188603401184082, 0.10762098431587219, -1.2739547491073608, 1.0076643228530883, 0.10762098431587219, -1.3132400512695312, 0.9927658438682556, 0.10762099921703338, -1.343980312347412, 0.9736358523368835, 0.10762098431587219, -1.366070032119751, 0.9497454166412353, 0.10762098431587219, -1.3794020414352417, 0.9205654263496399, 0.10762099921703338, -1.3838695287704467, 0.8855671882629394, 0.10762099176645279, -0.7625717520713806, 1.051611065864563, 0.11069586127996445, -0.8630039095878601, 1.051514983177185, 0.11069587618112564, -0.9551507234573364, 1.0508421659469604, 0.11069586127996445, -1.0389271974563598, 1.0490167140960693, 0.11069587618112564, -1.114247441291809, 1.0454611778259277, 0.11069584637880325, -1.181026816368103, 1.0395997762680053, 0.11069586127996445, -1.2391791343688964, 1.030855655670166, 0.11069586127996445, -1.2886192798614502, 1.018652081489563, 0.11069585382938385, -1.3292618989944458, 1.0024129152297973, 0.11069585382938385, -1.3610213994979858, 0.9815613031387329, 0.11069585382938385, -1.383812665939331, 0.9555208086967468, 0.11069585382938385, -1.3975499868392944, 0.9237149953842163, 0.11069586873054504, -1.4021481275558471, 0.8855671882629394, 0.11069586873054504, -0.7564789056777954, 1.0653200149536132, 0.107620969414711, -0.8612303733825684, 1.065216064453125, 0.1076209768652916, -0.9572098255157471, 1.0644879341125488, 0.1076209619641304, -1.0443534851074218, 1.0625114440917968, 0.107620969414711, -1.122597098350525, 1.0586622953414917, 0.1076209545135498, -1.19187593460083, 1.0523170232772827, 0.107620969414711, -1.2521262168884277, 1.0428508520126342, 0.107620969414711, -1.3032838106155395, 1.0296398401260376, 0.1076209619641304, -1.3452837467193603, 1.0120600461959838, 0.1076209768652916, -1.3780622482299804, 0.9894867539405823, 0.107620969414711, -1.4015551805496215, 0.9612964391708374, 0.107620969414711, -1.4156979322433471, 0.9268645644187927, 0.10762098431587219, -1.4204264879226684, 0.8855671882629394, 0.1076209768652916, -0.7507277131080627, 1.078260064125061, 0.09839633107185364, -0.859556257724762, 1.078148603439331, 0.09839633107185364, -0.9591535329818726, 1.077367901802063, 0.09839632362127304, -1.0494757890701294, 1.075249195098877, 0.09839631617069244, -1.1304781436920166, 1.0711231231689453, 0.09839632362127304, -1.2021170854568481, 1.0643211603164672, 0.09839633852243423, -1.2643475532531738, 1.054173469543457, 0.09839633107185364, -1.3171255588531494, 1.0400114059448242, 0.09839633852243423, -1.3604071140289306, 1.0211658477783203, 0.09839632362127304, -1.3941476345062255, 0.9969677925109863, 0.09839633107185364, -1.4183030128479004, 0.9667479991912842, 0.09839632362127304, -1.4328283071517944, 0.9298375248908997, 0.09839633107185364, -1.4376800060272216, 0.8855671882629394, 0.09839633852243423, -0.7456598877906799, 1.089662790298462, 0.08302190154790878, -0.858081042766571, 1.089544653892517, 0.08302192389965057, -0.9608663320541382, 1.0887179374694824, 0.08302190154790878, -1.053989291191101, 1.086473822593689, 0.08302190154790878, -1.137423038482666, 1.0821036100387573, 0.08302189409732818, -1.2111412286758422, 1.0748989582061767, 0.08302188664674759, -1.2751168012619018, 1.0641508102416992, 0.08302190154790878, -1.329323410987854, 1.0491507053375244, 0.08302190154790878, -1.3737338781356811, 1.0291900634765625, 0.08302190154790878, -1.408321738243103, 1.0035600662231445, 0.08302188664674759, -1.4330605268478393, 0.9715518951416016, 0.08302190154790878, -1.4479235410690307, 0.9324572086334228, 0.08302190899848938, -1.4528837203979492, 0.8855671882629394, 0.08302190899848938, -0.74161696434021, 1.0987592935562133, 0.06149769946932793, -0.8569042682647705, 1.0986360311508178, 0.061497706919908524, -0.9622326493263245, 1.0977723598480224, 0.06149769201874733, -1.0575900077819824, 1.095428228378296, 0.06149769946932793, -1.1429634094238281, 1.0908631086349487, 0.06149769201874733, -1.2183403968811035, 1.0833373069763183, 0.06149769946932793, -1.283708095550537, 1.0721102952957153, 0.06149769946932793, -1.3390538692474365, 1.0564417839050293, 0.06149769574403763, -1.3843653202056884, 1.0355912446975708, 0.06149769574403763, -1.4196293354034423, 1.0088188648223877, 0.06149769574403763, -1.444833755493164, 0.9753842353820801, 0.06149769946932793, -1.459965705871582, 0.9345470666885376, 0.06149769946932793, -1.4650124311447143, 0.8855671286582947, 0.06149771064519882, -0.7389406561851501, 1.1047810316085815, 0.033823736011981964, -0.8561251163482666, 1.10465407371521, 0.03382373973727226, -0.963137149810791, 1.1037662029266357, 0.033823736011981964, -1.0599737167358398, 1.101355791091919, 0.033823736011981964, -1.1466310024261474, 1.0966618061065673, 0.033823732286691666, -1.2231059074401855, 1.0889233350753784, 0.033823736011981964, -1.2893950939178466, 1.0773791074752807, 0.033823736011981964, -1.345495343208313, 1.0612679719924926, 0.03382373973727226, -1.3914027214050293, 1.0398287773132324, 0.03382373973727226, -1.4271146059036254, 1.0123002529144287, 0.03382373973727226, -1.4526270627975463, 0.9779210686683655, 0.03382374718785286, -1.4679373502731323, 0.9359305500984192, 0.03382374718785286, -1.473041296005249, 0.8855671882629394, 0.03382374718785286, -0.7379726767539978, 1.1069589853286743, 4.397200825678738e-9, -0.8558433651924133, 1.1068309545516967, 4.402799902436527e-9, -0.9634642004966736, 1.1059340238571167, 4.442000545168412e-9, -1.060835838317871, 1.1034997701644897, 4.548404319848487e-9, -1.147957444190979, 1.0987590551376342, 4.7556270033055625e-9, -1.2248296737670898, 1.0909438133239746, 5.097245292517982e-9, -1.291452169418335, 1.0792850255966186, 5.606867858887199e-9, -1.3478249311447143, 1.0630137920379638, 6.318106926528344e-9, -1.3939484357833862, 1.0413613319396972, 7.264564061415513e-9, -1.4298220872879028, 1.0135594606399536, 8.479826618668085e-9, -1.4554462432861328, 0.9788386821746826, 9.99751392782855e-9, -1.4708205461502075, 0.9364308714866638, 1.1851220449443644e-8, -1.4759453535079956, 0.8855671286582947, 1.4074547749487465e-8, -0.7389407157897949, 1.1047810316085815, -0.03382379561662674, -0.8561251759529114, 1.10465407371521, -0.03382379561662674, -0.963137149810791, 1.1037662029266357, -0.03382379561662674, -1.0599735975265503, 1.101355791091919, -0.03382379561662674, -1.1466310024261474, 1.0966618061065673, -0.03382378816604614, -1.2231061458587646, 1.0889233350753784, -0.03382379561662674, -1.2893952131271362, 1.0773791074752807, -0.03382379561662674, -1.345495581626892, 1.0612679719924926, -0.03382379189133644, -1.391403079032898, 1.0398287773132324, -0.03382379189133644, -1.427114725112915, 1.0123002529144287, -0.03382379561662674, -1.452627420425415, 0.9779210686683655, -0.03382378816604614, -1.4679374694824218, 0.9359305500984192, -0.033823784440755844, -1.4730415344238281, 0.8855671882629394, -0.033823784440755844, -0.7416169047355652, 1.0987592935562133, -0.0614977702498436, -0.8569042086601257, 1.0986360311508178, -0.061497777700424194, -0.9622326493263245, 1.0977723598480224, -0.0614977665245533, -1.0575900077819824, 1.095428228378296, -0.0614977702498436, -1.1429632902145385, 1.0908631086349487, -0.061497762799263, -1.2183401584625244, 1.0833373069763183, -0.0614977702498436, -1.283708095550537, 1.0721102952957153, -0.0614977702498436, -1.3390538692474365, 1.0564417839050293, -0.0614977665245533, -1.3843653202056884, 1.0355912446975708, -0.061497762799263, -1.4196293354034423, 1.0088188648223877, -0.0614977665245533, -1.444833755493164, 0.9753842353820801, -0.061497762799263, -1.4599655866622924, 0.9345470666885376, -0.061497762799263, -1.4650123119354248, 0.8855671286582947, -0.0614977590739727, -0.7456598281860352, 1.089662790298462, -0.08302196860313415, -0.858081042766571, 1.089544653892517, -0.08302197605371475, -0.9608663320541382, 1.0887179374694824, -0.08302196115255356, -1.053989291191101, 1.086473822593689, -0.08302196860313415, -1.1374231576919555, 1.0821036100387573, -0.08302195370197296, -1.2111412286758422, 1.0748989582061767, -0.08302196860313415, -1.2751168012619018, 1.0641508102416992, -0.08302197605371475, -1.3293230533599853, 1.0491507053375244, -0.08302196115255356, -1.3737338781356811, 1.0291900634765625, -0.08302196860313415, -1.4083218574523925, 1.0035600662231445, -0.08302196115255356, -1.4330605268478393, 0.9715518951416016, -0.08302196115255356, -1.4479233026504516, 0.9324571490287781, -0.08302196115255356, -1.4528836011886596, 0.8855671286582947, -0.08302196115255356, -0.750727653503418, 1.0782599449157714, -0.0983964055776596, -0.8595561385154724, 1.0781484842300415, -0.0983964130282402, -0.9591534733772278, 1.0773677825927734, -0.0983964055776596, -1.0494756698608398, 1.0752490758895874, -0.0983964055776596, -1.1304781436920166, 1.0711231231689453, -0.09839639067649841, -1.2021170854568481, 1.0643209218978881, -0.0983964055776596, -1.2643475532531738, 1.0541733503341674, -0.0983964130282402, -1.3171255588531494, 1.0400112867355346, -0.0983964130282402, -1.3604069948196411, 1.0211658477783203, -0.0983964055776596, -1.3941476345062255, 0.9969676733016968, -0.0983964055776596, -1.4183027744293213, 0.9667479395866394, -0.0983964055776596, -1.4328281879425048, 0.9298374056816101, -0.0983964055776596, -1.4376798868179321, 0.8855671286582947, -0.09839639812707901, -0.7564789056777954, 1.0653198957443237, -0.10762107372283935, -0.8612303733825684, 1.0652159452438354, -0.10762108117341995, -0.9572098255157471, 1.0644878149032592, -0.10762105882167816, -1.0443534851074218, 1.0625113248825073, -0.10762108117341995, -1.122597098350525, 1.0586621761322021, -0.10762105882167816, -1.19187593460083, 1.0523169040679931, -0.10762107372283935, -1.2521262168884277, 1.0428508520126342, -0.10762107372283935, -1.3032838106155395, 1.0296398401260376, -0.10762107372283935, -1.3452837467193603, 1.0120599269866943, -0.10762108862400055, -1.3780622482299804, 0.9894867539405823, -0.10762107372283935, -1.4015551805496215, 0.9612963795661926, -0.10762107372283935, -1.4156979322433471, 0.9268645644187927, -0.10762107372283935, -1.4204264879226684, 0.8855671882629394, -0.10762106627225876, -0.7625718116760254, 1.051611065864563, -0.11069595068693161, -0.8630039095878601, 1.051514983177185, -0.1106959655880928, -0.9551507234573364, 1.0508421659469604, -0.11069595068693161, -1.0389271974563598, 1.0490167140960693, -0.1106959655880928, -1.114247441291809, 1.0454611778259277, -0.11069593578577041, -1.181026816368103, 1.0395997762680053, -0.11069595068693161, -1.2391791343688964, 1.030855655670166, -0.11069595068693161, -1.2886192798614502, 1.018652081489563, -0.11069594323635101, -1.3292618989944458, 1.0024129152297973, -0.11069594323635101, -1.361021637916565, 0.9815613031387329, -0.11069594323635101, -1.3838127851486206, 0.9555208086967468, -0.11069594323635101, -1.397550106048584, 0.9237149953842163, -0.11069594323635101, -1.4021482467651367, 0.8855671882629394, -0.11069594323635101, -0.7686646580696106, 1.0379022359848022, -0.10762105882167816, -0.8647774457931518, 1.0378140211105346, -0.10762106627225876, -0.9530915021896362, 1.0371968746185302, -0.10762105137109756, -1.0335007905960083, 1.0355219841003418, -0.10762105882167816, -1.105898141860962, 1.0322600603103637, -0.10762104392051697, -1.1701773405075073, 1.026882529258728, -0.10762105882167816, -1.2262319326400756, 1.0188603401184082, -0.10762105882167816, -1.2739547491073608, 1.0076643228530883, -0.10762105137109756, -1.3132400512695312, 0.9927658438682556, -0.10762106627225876, -1.343980312347412, 0.9736358523368835, -0.10762105882167816, -1.366070032119751, 0.9497454166412353, -0.10762105882167816, -1.3794020414352417, 0.9205654263496399, -0.10762105882167816, -1.3838695287704467, 0.8855671882629394, -0.10762105137109756, -0.7744157314300537, 1.024962067604065, -0.0983964204788208, -0.8664515018463135, 1.024881362915039, -0.0983964204788208, -0.9511478543281555, 1.0243167877197265, -0.0983964130282402, -1.0283784866333007, 1.0227841138839721, -0.0983964055776596, -1.0980167388916015, 1.0197991132736206, -0.0983964130282402, -1.159936547279358, 1.014878511428833, -0.0983964279294014, -1.2140105962753296, 1.0075377225875854, -0.0983964204788208, -1.2601128816604614, 0.9972928762435913, -0.0983964279294014, -1.2981165647506713, 0.9836600422859192, -0.0983964130282402, -1.3278952836990356, 0.9661548733711243, -0.0983964204788208, -1.3493226766586303, 0.9442937970161438, -0.0983964130282402, -1.3622715473175048, 0.9175925254821777, -0.0983964055776596, -1.366616129875183, 0.8855671882629394, -0.0983964130282402, -0.7794836163520813, 1.0135594606399536, -0.08302199095487594, -0.8679266571998596, 1.0134854316711425, -0.08302201330661773, -0.9494351148605347, 1.0129667520523071, -0.08302199095487594, -1.0238648653030395, 1.0115596055984497, -0.08302199095487594, -1.0910718441009521, 1.0088187456130981, -0.08302198350429535, -1.1509121656417846, 1.0043007135391235, -0.08302197605371475, -1.2032413482666015, 0.9975603222846985, -0.08302199095487594, -1.2479151487350463, 0.9881534576416016, -0.08302199095487594, -1.2847896814346313, 0.975635826587677, -0.08302199095487594, -1.3137208223342895, 0.9595627188682556, -0.08302197605371475, -1.334564447402954, 0.9394898414611816, -0.08302199095487594, -1.347176432609558, 0.9149728417396545, -0.08302198350429535, -1.351412296295166, 0.8855671882629394, -0.08302198350429535, -0.7835265398025513, 1.004462718963623, -0.06149779260158539, -0.8691034913063049, 1.0043940544128418, -0.061497800052165985, -0.9480687975883484, 1.0039122104644775, -0.06149778515100479, -1.0202643871307373, 1.0026049613952636, -0.06149779260158539, -1.0855318307876587, 1.0000591278076171, -0.06149778515100479, -1.1437132358551025, 0.9958620071411133, -0.06149779260158539, -1.1946501731872558, 0.9896007776260376, -0.06149779260158539, -1.2381848096847534, 0.980862557888031, -0.06149778515100479, -1.2741585969924926, 0.9692343473434448, -0.06149778142571449, -1.3024135828018188, 0.9543037414550781, -0.06149778142571449, -1.3227914571762085, 0.9356574416160583, -0.06149778142571449, -1.3351343870162963, 0.9128828644752502, -0.06149778142571449, -1.33928382396698, 0.8855671286582947, -0.06149778515100479, -0.7862029075622559, 0.9984412789344788, -0.033823829144239426, -0.8698827028274536, 0.9983760118484497, -0.033823832869529724, -0.9471643567085266, 0.9979186058044434, -0.033823829144239426, -1.017880916595459, 0.996677577495575, -0.033823829144239426, -1.0818642377853393, 0.9942605495452881, -0.03382382541894913, -1.1389474868774414, 0.9902761578559875, -0.033823829144239426, -1.1889630556106567, 0.9843319654464722, -0.033823829144239426, -1.231743335723877, 0.9760362505912781, -0.03382382541894913, -1.2671208381652832, 0.9649969935417175, -0.03382382541894913, -1.2949284315109253, 0.9508225321769714, -0.03382382541894913, -1.3149980306625366, 0.9331206679344177, -0.033823829144239426, -1.327162742614746, 0.9114995002746582, -0.033823829144239426, -1.3312549591064453, 0.8855671882629394, -0.03382382169365883, -1.3262724876403808, 0.855715274810791, -3.7404504382720915e-8, -1.3199231624603271, 0.8220195174217224, -3.5931613240336446e-8, -1.3091328144073486, 0.7852490544319153, -3.432432649219663e-8, -1.293729543685913, 0.746172308921814, -3.2616227940707176e-8, -1.2735438346862793, 0.7055582404136658, -3.084093336269689e-8, -1.248403787612915, 0.6641753911972046, -2.9032030113285145e-8, -1.2181390523910522, 0.6227925419807434, -2.7223128640230243e-8, -1.182578444480896, 0.5821784734725952, -2.5447828733149436e-8, -1.1415514945983886, 0.5431017875671387, -2.3739733734373658e-8, -1.094887137413025, 0.5063312649726868, -2.2132443433520166e-8, -1.042414903640747, 0.4726356565952301, -2.0659561172919893e-8, -0.9839635491371155, 0.4427835941314697, -1.9354686742190097e-8, -1.3291466236114502, 0.8552212715148926, 0.033823709934949875, -1.3227086067199707, 0.8211237788200378, 0.033823709934949875, -1.311772108078003, 0.7840296030044556, 0.03382371366024017, -1.2961678504943847, 0.744693398475647, 0.033823706209659576, -1.2757266759872436, 0.7038703560829163, 0.03382371738553047, -1.250279426574707, 0.6623151302337646, 0.03382371738553047, -1.2196569442749023, 0.6207824945449829, 0.03382372111082077, -1.1836899518966674, 0.5800273418426514, 0.03382372111082077, -1.1422096490859985, 0.5408046841621399, 0.03382372856140137, -1.0950465202331543, 0.5038692355155945, 0.03382372483611107, -1.0420316457748413, 0.46997591853141784, 0.03382372111082077, -0.9829957485198975, 0.43987953662872314, 0.03382372856140137, -1.3370925188064575, 0.8538558483123779, 0.06149769201874733, -1.330409049987793, 0.8186472654342651, 0.061497680842876434, -1.319069266319275, 0.7806580066680908, 0.06149768829345703, -1.302907943725586, 0.7406045198440552, 0.061497680842876434, -1.2817611694335937, 0.699203610420227, 0.06149769201874733, -1.2554644346237182, 0.6571714878082275, 0.06149769201874733, -1.2238529920578003, 0.6152246594429016, 0.06149769574403763, -1.1867625713348388, 0.5740799903869629, 0.06149769201874733, -1.1440285444259643, 0.5344535708427429, 0.06149769946932793, -1.0954861640930175, 0.4970622956752777, 0.06149769946932793, -1.040971279144287, 0.4626224637031555, 0.061497703194618225, -0.9803192019462585, 0.4318506121635437, 0.061497703194618225, -1.3490961790084838, 0.851793110370636, 0.08302189409732818, -1.3420418500900268, 0.8149061799049377, 0.08302187919616699, -1.330092430114746, 0.775564968585968, 0.08302188664674759, -1.313090205192566, 0.7344279885292053, 0.08302187919616699, -1.2908779382705688, 0.692154049873352, 0.08302189409732818, -1.2632977962493896, 0.6494014859199524, 0.08302190154790878, -1.2301924228668213, 0.6068292856216431, 0.08302188664674759, -1.1914044618606567, 0.5650957226753235, 0.08302190154790878, -1.1467764377593994, 0.5248596668243408, 0.08302189409732818, -1.0961507558822631, 0.4867796003818512, 0.08302189409732818, -1.0393699407577514, 0.4515141248703003, 0.08302190154790878, -0.9762763977050781, 0.41972190141677856, 0.08302190899848938, -1.364142656326294, 0.8492075204849243, 0.09839633107185364, -1.356623649597168, 0.8102166056632996, 0.09839632362127304, -1.3439102172851562, 0.7691805362701416, 0.09839632362127304, -1.3258535861968994, 0.7266853451728821, 0.09839631617069244, -1.3023053407669067, 0.6833170056343079, 0.09839633107185364, -1.2731165885925293, 0.6396616101264954, 0.09839633852243423, -1.2381387948989868, 0.596305251121521, 0.09839634597301483, -1.1972229480743408, 0.5538337230682373, 0.09839633852243423, -1.1502208709716796, 0.512833297252655, 0.09839633852243423, -1.0969833135604858, 0.47388988733291626, 0.09839633852243423, -1.0373622179031372, 0.4375896155834198, 0.09839634597301483, -0.971208393573761, 0.4045183062553406, 0.09839634597301483, -1.3812183141708374, 0.8462733030319214, 0.10762099921703338, -1.3731715679168701, 0.804894745349884, 0.1076209768652916, -1.3595911264419555, 0.7619355320930481, 0.10762100666761398, -1.340338110923767, 0.7178989052772522, 0.10762098431587219, -1.3152738809585571, 0.6732887029647827, 0.10762099921703338, -1.2842596769332885, 0.6286087036132812, 0.10762099921703338, -1.2471567392349243, 0.5843624472618103, 0.10762100666761398, -1.2038263082504272, 0.5410534739494324, 0.10762102156877518, -1.1541301012039184, 0.49918562173843384, 0.10762100666761398, -1.0979288816452026, 0.4592624604701996, 0.10762100666761398, -1.0350841283798217, 0.4217876195907593, 0.10762102156877518, -0.9654573202133179, 0.38726484775543213, 0.10762101411819458, -1.399308204650879, 0.8431647419929504, 0.11069588363170624, -1.390702486038208, 0.7992567420005798, 0.11069586873054504, -1.3762036561965942, 0.7542600035667419, 0.11069589108228683, -1.3556829690933227, 0.7085903286933899, 0.11069586127996445, -1.3290127515792846, 0.6626646518707275, 0.11069587618112564, -1.2960644960403442, 0.6168990135192871, 0.11069587618112564, -1.2567102909088134, 0.571709930896759, 0.11069587618112564, -1.2108217477798462, 0.527513861656189, 0.11069587618112564, -1.158271312713623, 0.4847269654273987, 0.11069587618112564, -1.0989302396774292, 0.44376590847969055, 0.11069587618112564, -1.0326706171035766, 0.40504691004753113, 0.11069589108228683, -0.9593644142150879, 0.3689863383769989, 0.11069589108228683, -1.4173978567123413, 0.8400562405586243, 0.10762098431587219, -1.4082335233688354, 0.7936188578605652, 0.107620969414711, -1.3928163051605224, 0.7465844750404358, 0.10762098431587219, -1.3710278272628784, 0.6992818713188171, 0.107620969414711, -1.3427515029907226, 0.6520405411720276, 0.10762098431587219, -1.3078693151474, 0.6051893830299377, 0.10762098431587219, -1.2662638425827026, 0.5590575933456421, 0.10762098431587219, -1.2178173065185546, 0.513974130153656, 0.10762099921703338, -1.162412405014038, 0.4702683985233307, 0.10762099176645279, -1.0999314785003662, 0.4282693564891815, 0.10762099176645279, -1.0302571058273315, 0.3883061707019806, 0.10762100666761398, -0.9532715678215027, 0.35070785880088806, 0.10762099921703338, -1.4344735145568847, 0.8371219038963318, 0.09839633852243423, -1.4247814416885376, 0.7882969975471497, 0.09839633107185364, -1.4084970951080322, 0.7393393516540527, 0.09839633107185364, -1.385512351989746, 0.6904953122138977, 0.09839633852243423, -1.3557199239730835, 0.6420122385025024, 0.09839635342359543, -1.3190122842788696, 0.5941363573074341, 0.09839635342359543, -1.2752816677093505, 0.5471146702766418, 0.09839636087417602, -1.2244206666946411, 0.5011938214302063, 0.09839634597301483, -1.1663215160369873, 0.4566206634044647, 0.09839635342359543, -1.1008769273757934, 0.4136418104171753, 0.09839635342359543, -1.0279790163040161, 0.37250417470932007, 0.09839635342359543, -0.9475204944610596, 0.33345434069633484, 0.09839636087417602, -1.449520230293274, 0.8345363140106201, 0.08302193135023117, -1.4393633604049682, 0.7836073637008667, 0.08302190899848938, -1.422315001487732, 0.7329548597335815, 0.08302191644906997, -1.3982759714126587, 0.6827527284622192, 0.08302190899848938, -1.36714768409729, 0.633175253868103, 0.08302190154790878, -1.3288313150405883, 0.5843965411186218, 0.08302192389965057, -1.2832280397415161, 0.5365906357765198, 0.08302192389965057, -1.2302391529083252, 0.4899318814277649, 0.08302192389965057, -1.1697659492492675, 0.4445943236351013, 0.08302190899848938, -1.1017097234725952, 0.40075215697288513, 0.08302193135023117, -1.0259716510772705, 0.3585796356201172, 0.08302193135023117, -0.9424525499343872, 0.31825071573257446, 0.08302193135023117, -1.4615237712860107, 0.832473635673523, 0.06149771809577942, -1.4509962797164917, 0.7798663377761841, 0.061497706919908524, -1.4333384037017822, 0.7278618812561035, 0.06149771437048912, -1.4084579944610595, 0.6765761375427246, 0.06149771064519882, -1.376264214515686, 0.626125693321228, 0.06149772182106972, -1.3366643190383911, 0.5766265392303467, 0.06149772182106972, -1.2895673513412475, 0.5281951427459717, 0.06149771809577942, -1.2348809242248535, 0.4809476435184479, 0.06149771809577942, -1.1725138425827026, 0.43500033020973205, 0.06149772182106972, -1.1023740768432617, 0.39046943187713623, 0.06149772182106972, -1.0243699550628662, 0.3474712669849396, 0.061497725546360016, -0.9384096264839172, 0.30612197518348694, 0.06149773299694061, -1.4694699048995971, 0.8311081528663635, 0.03382375091314316, -1.4586968421936035, 0.7773898839950561, 0.03382375091314316, -1.440635323524475, 0.7244903445243835, 0.03382375091314316, -1.4151982069015503, 0.6724873185157776, 0.03382375091314316, -1.3822990655899047, 0.6214590072631836, 0.033823758363723755, -1.341849684715271, 0.5714830160140991, 0.033823758363723755, -1.2937637567520141, 0.5226375460624695, 0.03382376208901405, -1.2379539012908935, 0.4750002920627594, 0.03382376208901405, -1.1743329763412475, 0.42864933609962463, 0.03382376581430435, -1.102813959121704, 0.38366255164146423, 0.03382376953959465, -1.0233098268508911, 0.34011784195899963, 0.03382377326488495, -0.9357333779335022, 0.29809311032295227, 0.03382377326488495, -1.472343921661377, 0.8306143283843994, 1.647661207471174e-8, -1.4614819288253784, 0.7764941453933716, 1.8842275295583022e-8, -1.443274736404419, 0.723270833492279, 2.11687414264361e-8, -1.4176363945007324, 0.6710084676742554, 2.345320204710788e-8, -1.3844817876815796, 0.6197711229324341, 2.5692861171933146e-8, -1.3437252044677734, 0.5696226954460144, 2.7884917486176164e-8, -1.2952816486358642, 0.5206273198127747, 3.002657322781488e-8, -1.2390652894973754, 0.47284919023513794, 3.211502175304304e-8, -1.1749908924102783, 0.42635220289230346, 3.4147468852552265e-8, -1.102973222732544, 0.38120055198669433, 3.612110788253631e-8, -1.0229264497756958, 0.33745816349983215, 3.8033153515470985e-8, -0.9347653985023498, 0.29518911242485046, 3.988079200212269e-8, -1.4694700241088867, 0.8311081528663635, -0.033823784440755844, -1.458696961402893, 0.7773898839950561, -0.033823780715465546, -1.4406355619430542, 0.7244904041290283, -0.033823780715465546, -1.4151984453201294, 0.6724873185157776, -0.03382376953959465, -1.3822990655899047, 0.6214590072631836, -0.03382377326488495, -1.341849684715271, 0.5714830756187439, -0.03382377326488495, -1.2937637567520141, 0.5226375460624695, -0.03382376953959465, -1.2379539012908935, 0.47500041127204895, -0.03382376953959465, -1.174333095550537, 0.4286493957042694, -0.03382376953959465, -1.1028140783309936, 0.383662611246109, -0.03382376581430435, -1.0233098268508911, 0.340117871761322, -0.033823758363723755, -0.9357334971427917, 0.29809316992759704, -0.033823758363723755, -1.4615235328674316, 0.832473635673523, -0.0614977665245533, -1.4509960412979126, 0.7798663377761841, -0.061497751623392105, -1.4333381652832031, 0.727861762046814, -0.061497755348682404, -1.40845787525177, 0.6765760779380798, -0.06149774417281151, -1.3762640953063964, 0.626125693321228, -0.06149774789810181, -1.3366643190383911, 0.5766264796257019, -0.06149774789810181, -1.2895673513412475, 0.5281951427459717, -0.06149774417281151, -1.2348809242248535, 0.4809476137161255, -0.06149774044752121, -1.1725138425827026, 0.43500030040740967, -0.06149774044752121, -1.1023740768432617, 0.39046943187713623, -0.06149774044752121, -1.0243699550628662, 0.3474712669849396, -0.06149773672223091, -0.9384096264839172, 0.30612197518348694, -0.06149773672223091, -1.4495201110839843, 0.8345362544059753, -0.08302196860313415, -1.4393632411956787, 0.7836074233055115, -0.08302195370197296, -1.4223147630691528, 0.7329549193382263, -0.08302195370197296, -1.3982759714126587, 0.6827527284622192, -0.08302193880081177, -1.36714768409729, 0.6331753134727478, -0.08302195370197296, -1.3288311958312988, 0.5843966007232666, -0.08302195370197296, -1.283227801322937, 0.5365906357765198, -0.08302193880081177, -1.2302391529083252, 0.4899318814277649, -0.08302194625139236, -1.1697659492492675, 0.4445943832397461, -0.08302193880081177, -1.1017097234725952, 0.40075215697288513, -0.08302193135023117, -1.025971531867981, 0.3585796356201172, -0.08302193880081177, -0.9424525499343872, 0.31825071573257446, -0.08302193880081177, -1.4344733953475952, 0.8371217846870422, -0.0983964055776596, -1.4247814416885376, 0.7882969379425049, -0.09839639812707901, -1.4084969758987426, 0.7393392324447632, -0.09839639067649841, -1.3855122327804565, 0.6904952526092529, -0.09839637577533722, -1.355719804763794, 0.6420121192932129, -0.09839639067649841, -1.31901216506958, 0.5941362977027893, -0.09839639067649841, -1.275281548500061, 0.5471146106719971, -0.09839639067649841, -1.224420428276062, 0.5011937618255615, -0.09839638322591781, -1.1663212776184082, 0.45662060379981994, -0.09839638322591781, -1.1008766889572143, 0.4136417806148529, -0.09839637577533722, -1.0279788970947265, 0.3725041449069977, -0.09839638322591781, -0.94752037525177, 0.33345431089401245, -0.09839637577533722, -1.4173978567123413, 0.8400562405586243, -0.10762107372283935, -1.4082335233688354, 0.7936188578605652, -0.10762105137109756, -1.3928163051605224, 0.7465844750404358, -0.10762106627225876, -1.3710278272628784, 0.6992818713188171, -0.10762104392051697, -1.3427515029907226, 0.6520405411720276, -0.10762105882167816, -1.3078693151474, 0.6051894426345825, -0.10762105882167816, -1.2662638425827026, 0.5590575933456421, -0.10762105137109756, -1.2178173065185546, 0.5139741897583008, -0.10762106627225876, -1.162412405014038, 0.47026845812797546, -0.10762105137109756, -1.0999314785003662, 0.4282694160938263, -0.10762105137109756, -1.0302571058273315, 0.3883061707019806, -0.10762105137109756, -0.9532715678215027, 0.35070785880088806, -0.10762104392051697, -1.3993083238601684, 0.8431647419929504, -0.11069595813751221, -1.390702724456787, 0.7992567420005798, -0.11069594323635101, -1.3762038946151733, 0.7542598843574524, -0.11069595068693161, -1.3556829690933227, 0.7085903286933899, -0.11069592088460922, -1.3290128707885742, 0.6626645922660828, -0.11069593578577041, -1.2960644960403442, 0.6168990135192871, -0.11069593578577041, -1.2567102909088134, 0.571709930896759, -0.11069592088460922, -1.2108217477798462, 0.5275138020515442, -0.11069592088460922, -1.158271312713623, 0.4847269654273987, -0.11069592088460922, -1.0989302396774292, 0.44376590847969055, -0.11069592088460922, -1.0326707363128662, 0.40504691004753113, -0.11069592088460922, -0.9593644738197327, 0.3689863383769989, -0.11069592088460922, -1.3812183141708374, 0.8462733030319214, -0.10762105882167816, -1.3731715679168701, 0.804894745349884, -0.10762104392051697, -1.3595911264419555, 0.7619355320930481, -0.10762104392051697, -1.340338110923767, 0.7178987860679626, -0.10762102901935577, -1.3152738809585571, 0.6732887029647827, -0.10762104392051697, -1.2842596769332885, 0.6286087036132812, -0.10762104392051697, -1.2471567392349243, 0.5843623876571655, -0.10762102901935577, -1.2038263082504272, 0.5410534143447876, -0.10762104392051697, -1.1541301012039184, 0.49918556213378906, -0.10762103646993637, -1.0979288816452026, 0.4592624008655548, -0.10762103646993637, -1.0350841283798217, 0.4217876195907593, -0.10762103646993637, -0.9654573202133179, 0.38726481795310974, -0.10762102901935577, -1.3641427755355835, 0.8492075800895691, -0.0983964130282402, -1.3566237688064575, 0.8102166056632996, -0.0983964055776596, -1.3439104557037353, 0.7691806554794311, -0.09839639812707901, -1.325853705406189, 0.7266854047775268, -0.09839639812707901, -1.3023055791854858, 0.6833171844482422, -0.0983964130282402, -1.2731168270111084, 0.6396617293357849, -0.0983964055776596, -1.2381389141082763, 0.5963053107261658, -0.0983964055776596, -1.19722318649292, 0.5538338422775268, -0.09839639067649841, -1.1502209901809692, 0.5128333568572998, -0.09839639812707901, -1.096983551979065, 0.4738900065422058, -0.09839639067649841, -1.0373623371124267, 0.4375896751880646, -0.09839639067649841, -0.9712084531784058, 0.40451836585998535, -0.09839639067649841, -1.3490960597991943, 0.8517932891845703, -0.08302200585603714, -1.3420417308807373, 0.8149061799049377, -0.08302198350429535, -1.3300923109054565, 0.775564968585968, -0.08302198350429535, -1.3130900859832763, 0.7344279885292053, -0.08302196860313415, -1.2908779382705688, 0.692154049873352, -0.08302196115255356, -1.2632977962493896, 0.6494015455245972, -0.08302197605371475, -1.2301923036575317, 0.6068292856216431, -0.08302197605371475, -1.1914044618606567, 0.5650957822799683, -0.08302196860313415, -1.1467764377593994, 0.5248597264289856, -0.08302195370197296, -1.0961506366729736, 0.48677965998649597, -0.08302196860313415, -1.039369821548462, 0.4515141546726227, -0.08302196860313415, -0.9762763381004333, 0.41972196102142334, -0.08302196115255356, -1.3370927572250366, 0.8538558483123779, -0.06149779260158539, -1.330409049987793, 0.8186473250389099, -0.061497777700424194, -1.3190693855285644, 0.7806580066680908, -0.06149778142571449, -1.302907943725586, 0.7406045198440552, -0.061497773975133896, -1.281761646270752, 0.6992036700248718, -0.061497777700424194, -1.2554645538330078, 0.6571714878082275, -0.061497777700424194, -1.2238532304763794, 0.6152247190475464, -0.0614977665245533, -1.1867626905441284, 0.5740799903869629, -0.0614977665245533, -1.1440285444259643, 0.5344535708427429, -0.061497762799263, -1.0954861640930175, 0.4970622956752777, -0.061497762799263, -1.0409713983535766, 0.4626224637031555, -0.0614977590739727, -0.9803192615509033, 0.4318506121635437, -0.0614977665245533, -1.3291466236114502, 0.8552212119102478, -0.03382382541894913, -1.3227086067199707, 0.8211237788200378, -0.03382382169365883, -1.311772108078003, 0.7840296030044556, -0.03382381796836853, -1.2961678504943847, 0.7446932792663574, -0.03382381424307823, -1.2757266759872436, 0.7038702964782715, -0.03382381424307823, -1.2502793073654174, 0.6623149514198303, -0.03382381424307823, -1.2196569442749023, 0.6207823753356934, -0.03382381051778793, -1.183689832687378, 0.5800272226333618, -0.03382381051778793, -1.142209529876709, 0.5408046245574951, -0.033823806792497635, -1.0950462818145752, 0.5038691759109497, -0.03382381051778793, -1.0420315265655517, 0.46997588872909546, -0.03382381051778793, -0.9829955101013184, 0.43987950682640075, -0.033823803067207336, 0.8363690376281738, 0.7010740637779236, -3.064491949089643e-8, 0.9353064894676208, 0.7076936364173889, -3.093427380918001e-8, 1.0128902196884155, 0.7263563275337219, -3.1750044371392505e-8, 1.07236647605896, 0.7552688717842102, -3.301385120835221e-8, 1.1169805526733398, 0.792637288570404, -3.4647278823740635e-8, 1.1499789953231811, 0.8366679549217224, -3.657191882666666e-8, 1.1746065616607666, 0.8855671882629394, -3.8709373484380194e-8, 1.194109320640564, 0.9375413060188293, -4.098123440599011e-8, 1.2117328643798828, 0.9907966256141663, -4.3309096753318954e-8, 1.2307230234146118, 1.0435395240783691, -4.561456279361664e-8, 1.2543257474899292, 1.0939761400222778, -4.781921347785101e-8, 1.2857863903045654, 1.1403127908706665, -4.984465817869932e-8, 1.3283507823944091, 1.1807563304901123, -5.1612499163411485e-8, 0.8363691568374634, 0.6930879354476929, 0.07441221922636032, 0.9363450407981873, 0.7003083229064941, 0.07350269705057144, 1.0146650075912475, 0.7196676731109619, 0.07098808139562607, 1.07463538646698, 0.7493472695350647, 0.06718944013118744, 1.1195621490478515, 0.7875282764434814, 0.062427740544080734, 1.1527520418167114, 0.8323916792869568, 0.0570240393280983, 1.1775106191635131, 0.8821186423301697, 0.0512993149459362, 1.1971443891525268, 0.9348901510238647, 0.04557458683848381, 1.2149596214294433, 0.9888874888420105, 0.040170878171920776, 1.234262466430664, 1.042291522026062, 0.035409193485975265, 1.2583591938018798, 1.0932836532592773, 0.03161054477095604, 1.2905558347702026, 1.1400448083877563, 0.02909594587981701, 1.3341588973999023, 1.1807563304901123, 0.028186405077576637, 0.8363689184188843, 0.6710084676742554, 0.13529495894908905, 0.9392163157463074, 0.679889976978302, 0.13364127278327942, 1.0195714235305786, 0.7011752128601074, 0.1290692538022995, 1.080907940864563, 0.7329759001731873, 0.12216264009475708, 1.1266988515853881, 0.7734032869338989, 0.11350499838590622, 1.160418152809143, 0.8205690383911133, 0.1036800965666771, 1.1855393648147583, 0.8725842833518982, 0.09327150881290436, 1.2055354118347168, 0.9275605082511902, 0.08286292105913162, 1.2238805294036865, 0.9836092591285706, 0.0730379968881607, 1.2440475225448608, 1.0388416051864624, 0.06438039243221283, 1.269510269165039, 1.0913695096969604, 0.05747374892234802, 1.3037420511245727, 1.1393038034439087, 0.05290175601840019, 1.3502166271209716, 1.1807562112808227, 0.05124805122613907, 0.8363690972328186, 0.6376544833183289, 0.1826482117176056, 0.943554162979126, 0.6490452289581299, 0.18041573464870453, 1.0269832611083984, 0.6732398271560669, 0.1742435246706009, 1.0903832912445068, 0.7082447409629822, 0.16491958498954773, 1.1374799013137817, 0.7520657777786255, 0.15323178470134735, 1.1719995737075805, 0.8027094602584839, 0.139968141913414, 1.1976680755615234, 0.8581815361976623, 0.12591655552387237, 1.2182117700576782, 0.9164881110191345, 0.11186496913433075, 1.2373569011688232, 0.9756357073783874, 0.0986013114452362, 1.2588294744491577, 1.033630132675171, 0.08691354840993881, 1.28635573387146, 1.088477611541748, 0.07758958637714386, 1.3236619234085083, 1.1381841897964477, 0.07141738384962082, 1.3744741678237915, 1.1807563304901123, 0.06918488442897796, 0.836368978023529, 0.595844566822052, 0.21647195518016815, 0.948991596698761, 0.6103806495666504, 0.2138260304927826, 1.0362744331359863, 0.6382222771644592, 0.20651084184646606, 1.1022610664367675, 0.6772436499595642, 0.1954602152109146, 1.1509941816329956, 0.7253186702728271, 0.18160803616046905, 1.1865167617797851, 0.7803219556808472, 0.16588817536830902, 1.2128715515136718, 0.840127170085907, 0.14923445880413055, 1.23410165309906, 0.9026086330413818, 0.1325806975364685, 1.2542498111724853, 0.965640664100647, 0.11686081439256668, 1.277358889579773, 1.027097225189209, 0.10300865024328232, 1.307471752166748, 1.084852695465088, 0.09195803850889206, 1.3486316204071045, 1.136780858039856, 0.08464283496141434, 1.4048811197280883, 1.1807562112808227, 0.08199690282344818, 0.836368978023529, 0.5483973622322082, 0.23676623404026031, 0.9551620483398437, 0.5665029883384705, 0.23387226462364197, 1.046818494796753, 0.5984833240509033, 0.2258712500333786, 1.1157406568527221, 0.6420626044273376, 0.21378463506698608, 1.1663308143615722, 0.6949653029441833, 0.1986338198184967, 1.2029917240142822, 0.7549159526824951, 0.18144018948078155, 1.2301253080368042, 0.819638729095459, 0.1632251888513565, 1.252134084701538, 0.8868579864501953, 0.14501014351844787, 1.2734203338623046, 0.9542981386184692, 0.12781652808189392, 1.298386573791504, 1.0196837186813354, 0.11266570538282394, 1.331435203552246, 1.0807390213012695, 0.10057911276817322, 1.3769681453704834, 1.135188341140747, 0.09257809817790985, 1.439388394355774, 1.1807564496994018, 0.08968412131071091, 0.8363690376281738, 0.4981316030025482, 0.2435309737920761, 0.9616991877555847, 0.5200188755989075, 0.2405543029308319, 1.0579885244369506, 0.5563835501670837, 0.23232467472553253, 1.1300204992294311, 0.6047915816307068, 0.21989275515079498, 1.1825783252716064, 0.6628087759017944, 0.20430904626846313, 1.2204450368881225, 0.7280006408691406, 0.1866241991519928, 1.248403787612915, 0.7979329824447632, 0.16788876056671142, 1.2712376117706298, 0.8701713681221008, 0.14915329217910766, 1.2937297821044921, 0.9422817826271057, 0.13146841526031494, 1.3206634521484375, 1.0118297338485717, 0.11588473618030548, 1.356821894645691, 1.076380968093872, 0.10345280170440674, 1.4069881439208984, 1.1335011720657348, 0.09522319585084915, 1.4759453535079956, 1.1807563304901123, 0.09224653244018554, 0.8363690376281738, 0.44786572456359863, 0.23676623404026031, 0.9682362079620361, 0.47353455424308777, 0.23387227952480316, 1.069158673286438, 0.5142838358879089, 0.2258712500333786, 1.1443008184432983, 0.5675207376480102, 0.21378463506698608, 1.198825716972351, 0.630652129650116, 0.1986338049173355, 1.2378984689712524, 0.7010853886604309, 0.18144018948078155, 1.2666821479797363, 0.7762272357940674, 0.1632251888513565, 1.2903411388397216, 0.8534849286079407, 0.14501014351844787, 1.3140392303466796, 0.9302653074264526, 0.12781654298305511, 1.3429404497146606, 1.003975749015808, 0.11266571283340454, 1.3822087049484253, 1.072022795677185, 0.10057911276817322, 1.437008023262024, 1.131813883781433, 0.09257812052965164, 1.5125023126602172, 1.1807563304901123, 0.0896841287612915, 0.8363690376281738, 0.40041854977607727, 0.21647199988365173, 0.9744067788124084, 0.4296569228172302, 0.21382609009742737, 1.079702377319336, 0.47454485297203064, 0.20651087164878845, 1.1577800512313842, 0.5323397517204285, 0.195460245013237, 1.2141622304916381, 0.6002987623214722, 0.18160806596279144, 1.25437331199646, 0.6756793856620789, 0.16588817536830902, 1.283935785293579, 0.7557386755943298, 0.14923447370529175, 1.3083735704421997, 0.8377341032028198, 0.1325807422399521, 1.3332098722457885, 0.9189227819442749, 0.11686084419488907, 1.3639681339263916, 0.9965620040893555, 0.10300865024328232, 1.4061721563339233, 1.0679092407226562, 0.09195805341005325, 1.4653444290161132, 1.1302214860916137, 0.08464284986257553, 1.5470094680786132, 1.1807563304901123, 0.08199691027402878, 0.8363690376281738, 0.3586086332798004, 0.18264825642108917, 0.979844331741333, 0.3909924030303955, 0.18041576445102692, 1.0889936685562133, 0.4395272731781006, 0.17424355447292328, 1.169657826423645, 0.5013386011123657, 0.16491961479187012, 1.2276767492294311, 0.5735516548156738, 0.15323179960250854, 1.268890619277954, 0.6532918810844421, 0.1399681568145752, 1.2991392612457275, 0.7376844882965088, 0.12591658532619476, 1.3242634534835815, 0.8238546252250671, 0.11186497658491134, 1.3501026630401611, 0.908927857875824, 0.098601333796978, 1.3824976682662963, 0.9900292754173279, 0.08691354840993881, 1.4272879362106323, 1.0642842054367065, 0.07758960127830505, 1.490314245223999, 1.128818154335022, 0.07141739875078201, 1.5774164199829101, 1.1807563304901123, 0.06918489187955856, 0.8363691568374634, 0.3252546489238739, 0.13529501855373382, 0.9841819405555725, 0.3601476550102234, 0.1336413323879242, 1.0964057445526123, 0.41159185767173767, 0.12906931340694427, 1.179133415222168, 0.47660741209983825, 0.12216268479824066, 1.2384577989578247, 0.5522140860557556, 0.11350506544113159, 1.2804718017578125, 0.635432243347168, 0.10368012636899948, 1.3112680912017822, 0.7232815027236938, 0.09327155351638794, 1.3369394540786743, 0.8127822875976562, 0.0828629583120346, 1.3635790348052978, 0.9009543061256409, 0.07303803414106369, 1.3972795009613037, 0.9848177433013916, 0.06438041478395462, 1.4441335201263427, 1.0613924264907837, 0.05747377499938011, 1.510233998298645, 1.127698540687561, 0.05290178209543228, 1.6016740798950195, 1.1807563304901123, 0.05124806985259056, 0.8363690376281738, 0.3031752109527588, 0.07441231608390808, 0.9870532751083374, 0.33972933888435363, 0.0735027864575386, 1.1013120412826538, 0.39309942722320556, 0.07098817825317383, 1.1854058504104614, 0.4602360427379608, 0.06718951463699341, 1.2455943822860717, 0.5380892157554626, 0.062427818775177, 1.2881381511688232, 0.623609721660614, 0.05702411010861397, 1.3192968368530273, 0.7137473225593567, 0.05129937827587128, 1.345330834388733, 0.8054526448249817, 0.045574646443128586, 1.372499942779541, 0.8956760764122009, 0.040170926600694656, 1.4070645570755004, 0.9813677072525024, 0.03540923446416855, 1.455284595489502, 1.0594780445098877, 0.03161058574914932, 1.5234203338623046, 1.1269575357437133, 0.029095979407429695, 1.6177318096160888, 1.1807562112808227, 0.028186434879899025, 0.836368978023529, 0.29518911242485046, 1.0322149535113567e-7, 0.9880918860435486, 0.3323439657688141, 1.0017802765105443e-7, 1.1030868291854858, 0.3864106833934784, 9.389050603658688e-8, 1.1876747608184814, 0.4543145000934601, 8.499433334918649e-8, 1.2481759786605835, 0.53298020362854, 7.412485558688786e-8, 1.2909111976623535, 0.6193333864212036, 6.191744716943503e-8, 1.3222010135650634, 0.7102987766265869, 4.900746830571734e-8, 1.3483660221099853, 0.8028015494346619, 3.603028275733777e-8, 1.3757269382476806, 0.8937669396400452, 2.362125428589934e-8, 1.4106040000915527, 0.9801199436187744, 1.241576086385976e-8, 1.4593181610107421, 1.0587857961654663, 3.0491555946809967e-9, 1.528189778327942, 1.1266895532608032, -3.8431906546065874e-9, 1.6235398054122924, 1.1807564496994018, -7.625910569686311e-9, 0.8363691568374634, 0.3031752407550812, -0.0744122639298439, 0.987053394317627, 0.33972933888435363, -0.07350274175405502, 1.1013123989105224, 0.39309948682785034, -0.07098812609910965, 1.18540620803833, 0.4602360427379608, -0.06718949228525162, 1.2455945014953613, 0.5380893349647522, -0.06242779642343521, 1.2881386280059814, 0.6236097812652588, -0.05702410265803337, 1.3192970752716064, 0.7137474417686462, -0.051299382001161575, 1.3453311920166015, 0.8054527640342712, -0.04557466134428978, 1.3725003004074096, 0.8956761360168457, -0.04017096385359764, 1.4070649147033691, 0.981367826461792, -0.03540928289294243, 1.455284833908081, 1.0594781637191772, -0.0316106379032135, 1.5234206914901733, 1.1269575357437133, -0.029096044600009918, 1.6177319288253784, 1.1807563304901123, -0.028186509385704994, 0.8363689184188843, 0.3252546489238739, -0.13529500365257263, 0.984181821346283, 0.3601476550102234, -0.133641317486763, 1.0964056253433227, 0.4115918278694153, -0.12906929850578308, 1.179133415222168, 0.47660741209983825, -0.12216269224882126, 1.2384576797485351, 0.5522140860557556, -0.113505057990551, 1.2804718017578125, 0.635432243347168, -0.10368016362190246, 1.3112680912017822, 0.7232815027236938, -0.09327157586812973, 1.3369394540786743, 0.8127822875976562, -0.08286299556493759, 1.3635790348052978, 0.9009542465209961, -0.07303807884454727, 1.3972795009613037, 0.984817624092102, -0.06438048183917999, 1.4441336393356323, 1.0613924264907837, -0.057473842054605484, 1.5102341175079345, 1.127698540687561, -0.05290185287594795, 1.6016740798950195, 1.1807562112808227, -0.051248155534267426, 0.8363690972328186, 0.35860857367515564, -0.18264825642108917, 0.979844331741333, 0.39099234342575073, -0.1804157793521881, 1.0889936685562133, 0.4395272135734558, -0.17424356937408447, 1.169657826423645, 0.501338541507721, -0.1649196296930313, 1.2276767492294311, 0.5735516548156738, -0.15323184430599213, 1.2688905000686645, 0.6532918810844421, -0.13996820151805878, 1.2991392612457275, 0.7376843690872192, -0.12591663002967834, 1.324263334274292, 0.8238546252250671, -0.11186504364013672, 1.3501027822494506, 0.908927857875824, -0.09860139340162277, 1.3824976682662963, 0.9900292754173279, -0.08691363781690597, 1.4272879362106323, 1.0642842054367065, -0.07758967578411102, 1.4903143644332885, 1.128818154335022, -0.07141748815774917, 1.5774166584014892, 1.1807563304901123, -0.06918498873710632, 0.836368978023529, 0.4004184901714325, -0.21647199988365173, 0.9744066596031189, 0.4296568036079407, -0.21382607519626617, 1.079702377319336, 0.47454479336738586, -0.20651088654994964, 1.1577800512313842, 0.5323396921157837, -0.1954602748155594, 1.2141621112823486, 0.6002986431121826, -0.18160809576511383, 1.25437331199646, 0.6756793260574341, -0.1658882349729538, 1.2839356660842895, 0.7557386159896851, -0.14923451840877533, 1.3083733320236206, 0.8377339839935303, -0.13258077204227447, 1.333209753036499, 0.9189227223396301, -0.11686089634895325, 1.3639681339263916, 0.9965620040893555, -0.10300873965024948, 1.4061719179153442, 1.0679091215133667, -0.09195812791585922, 1.4653444290161132, 1.1302213668823242, -0.0846429392695427, 1.5470093488693237, 1.1807562112808227, -0.08199700713157654, 0.836368978023529, 0.44786569476127624, -0.2367662787437439, 0.9682362079620361, 0.47353455424308777, -0.23387230932712555, 1.069158673286438, 0.5142837762832642, -0.22587130963802338, 1.1443008184432983, 0.5675207376480102, -0.21378469467163086, 1.1988258361816406, 0.630652129650116, -0.19863387942314148, 1.2378984689712524, 0.7010853886604309, -0.18144024908542633, 1.2666822671890258, 0.7762272953987122, -0.16322524845600128, 1.2903412580490112, 0.8534849882125854, -0.14501023292541504, 1.3140392303466796, 0.9302654266357422, -0.12781661748886108, 1.3429405689239502, 1.003975749015808, -0.11266579478979111, 1.3822087049484253, 1.072022795677185, -0.10057920217514038, 1.4370081424713134, 1.1318141222000122, -0.09257820248603821, 1.5125024318695068, 1.1807564496994018, -0.08968422561883926, 0.8363690376281738, 0.49813151359558105, -0.2435310035943985, 0.9616991877555847, 0.5200188159942627, -0.24055436253547668, 1.0579885244369506, 0.5563835501670837, -0.2323247343301773, 1.1300204992294311, 0.6047915816307068, -0.21989281475543976, 1.1825783252716064, 0.6628087759017944, -0.2043091058731079, 1.2204450368881225, 0.7280007600784302, -0.18662425875663757, 1.248403787612915, 0.7979329824447632, -0.1678888201713562, 1.2712376117706298, 0.8701713681221008, -0.14915338158607483, 1.2937297821044921, 0.9422817826271057, -0.1314685046672821, 1.3206634521484375, 1.0118297338485717, -0.11588482558727264, 1.356821894645691, 1.076380968093872, -0.1034528911113739, 1.4069881439208984, 1.1335011720657348, -0.09522330015897751, 1.4759453535079956, 1.1807563304901123, -0.0922466367483139, 0.8363690376281738, 0.5483973622322082, -0.2367662787437439, 0.9551620483398437, 0.5665029883384705, -0.23387232422828674, 1.046818494796753, 0.5984833240509033, -0.22587130963802338, 1.1157406568527221, 0.6420626640319824, -0.21378469467163086, 1.1663308143615722, 0.6949653029441833, -0.19863386452198028, 1.2029916048049926, 0.7549158930778503, -0.18144024908542633, 1.2301253080368042, 0.8196386694908142, -0.16322524845600128, 1.252134084701538, 0.8868578672409058, -0.14501023292541504, 1.2734203338623046, 0.9542981386184692, -0.12781663239002228, 1.298386573791504, 1.0196837186813354, -0.1126658022403717, 1.331435203552246, 1.0807390213012695, -0.10057920217514038, 1.3769681453704834, 1.1351882219314575, -0.09257822483778, 1.439388394355774, 1.1807563304901123, -0.08968423306941986, 0.8363690376281738, 0.595844566822052, -0.21647204458713531, 0.948991596698761, 0.6103806495666504, -0.21382613480091095, 1.0362744331359863, 0.6382222771644592, -0.20651091635227203, 1.1022613048553466, 0.6772437691688538, -0.19546030461788177, 1.1509943008422851, 0.7253187894821167, -0.18160812556743622, 1.1865170001983642, 0.7803219556808472, -0.1658882349729538, 1.212871789932251, 0.840127170085907, -0.14923453330993652, 1.2341018915176391, 0.9026086926460266, -0.13258081674575806, 1.254249930381775, 0.9656407237052917, -0.11686092615127563, 1.277358889579773, 1.027097463607788, -0.10300873965024948, 1.3074719905853271, 1.084852695465088, -0.09195814281702041, 1.3486318588256836, 1.136780858039856, -0.08464295417070389, 1.4048813581466674, 1.1807563304901123, -0.08199701458215713, 0.8363690376281738, 0.6376545429229736, -0.18264830112457275, 0.943554162979126, 0.6490452289581299, -0.1804158091545105, 1.026983380317688, 0.6732398271560669, -0.17424359917640686, 1.0903832912445068, 0.708244800567627, -0.1649196594953537, 1.1374799013137817, 0.752065896987915, -0.15323185920715332, 1.1719995737075805, 0.8027094602584839, -0.13996821641921997, 1.1976680755615234, 0.8581815361976623, -0.12591665983200073, 1.2182117700576782, 0.9164881110191345, -0.11186505109071731, 1.2373569011688232, 0.9756357073783874, -0.09860141575336456, 1.2588293552398681, 1.033630132675171, -0.08691363781690597, 1.2863556146621704, 1.088477611541748, -0.07758969068527221, 1.3236619234085083, 1.1381841897964477, -0.07141750305891037, 1.3744739294052124, 1.1807563304901123, -0.06918499618768692, 0.8363691568374634, 0.6710084676742554, -0.1352950632572174, 0.9392164349555969, 0.6798900365829468, -0.13364137709140777, 1.0195715427398681, 0.701175332069397, -0.12906935811042786, 1.080907940864563, 0.732975959777832, -0.12216273695230484, 1.1266989707946777, 0.7734033465385437, -0.11350512504577637, 1.1604182720184326, 0.8205691576004028, -0.10368019342422485, 1.1855393648147583, 0.872584342956543, -0.09327162057161331, 1.205535650253296, 0.9275606274604797, -0.08286303281784057, 1.2238805294036865, 0.9836092591285706, -0.07303811609745025, 1.2440475225448608, 1.038841724395752, -0.06438050419092178, 1.269510269165039, 1.0913695096969604, -0.05747386813163757, 1.3037421703338623, 1.1393038034439087, -0.05290187895298004, 1.3502166271209716, 1.1807563304901123, -0.05124817416071892, 0.8363690376281738, 0.6930878758430481, -0.07441236078739166, 0.9363450407981873, 0.7003082633018494, -0.07350283116102218, 1.0146650075912475, 0.7196676135063171, -0.07098822295665741, 1.07463538646698, 0.7493473291397095, -0.06718956679105758, 1.1195621490478515, 0.7875282764434814, -0.06242787465453148, 1.1527520418167114, 0.8323917388916016, -0.05702417343854904, 1.1775106191635131, 0.8821186423301697, -0.05129944533109665, 1.1971443891525268, 0.9348902106285095, -0.045574720948934555, 1.2149596214294433, 0.9888874888420105, -0.04017101228237152, 1.234262466430664, 1.042291522026062, -0.03540932387113571, 1.2583591938018798, 1.093283772468567, -0.031610678881406784, 1.2905558347702026, 1.1400448083877563, -0.029096078127622604, 1.3341588973999023, 1.1807562112808227, -0.028186539188027382, 1.3405935764312744, 1.1892122030258178, -5.198211994184021e-8, 1.3524943590164184, 1.1961305141448974, -5.228452337746603e-8, 1.363712191581726, 1.2015116214752197, -5.251974499742573e-8, 1.3739044666290283, 1.2053552865982055, -5.268775282729621e-8, 1.3827308416366577, 1.2076613903045654, -5.2788557525218493e-8, 1.3898484706878662, 1.208430290222168, -5.2822166196619946e-8, 1.3949164152145385, 1.2076613903045654, -5.2788557525218493e-8, 1.3975926637649536, 1.2053554058074951, -5.2687759932723566e-8, 1.397535800933838, 1.2015117406845092, -5.251974855013941e-8, 1.3944039344787597, 1.1961307525634765, -5.2284537588320745e-8, 1.3878555297851562, 1.1892122030258178, -5.198211994184021e-8, 1.3775490522384643, 1.1807563304901123, -5.1612499163411485e-8, 1.3466453552246093, 1.189257264137268, 0.02796456776559353, 1.358680009841919, 1.1962188482284546, 0.027351250872015953, 1.3699325323104858, 1.2016392946243286, 0.026424748823046684, 1.3800712823867797, 1.2055166959762573, 0.025263363495469093, 1.3887665271759033, 1.2078489065170288, 0.023945389315485954, 1.3956869840621948, 1.2086344957351684, 0.022549113258719444, 1.4005022048950195, 1.2078710794448852, 0.021152840927243232, 1.4028810262680053, 1.2055572271347046, 0.019834863021969795, 1.4024931192398071, 1.201690435409546, 0.018673475831747055, 1.399007797241211, 1.1962693929672241, 0.017746977508068084, 1.3920938968658447, 1.1892918348312378, 0.01713365875184536, 1.3814210891723632, 1.1807563304901123, 0.01691182143986225, 1.3633772134780883, 1.189381718635559, 0.0508447140455246, 1.3757814168930053, 1.1964627504348754, 0.049729589372873306, 1.3871296644210815, 1.2019920349121093, 0.048045042902231216, 1.3971201181411743, 1.2059626579284668, 0.045933421701192856, 1.4054534435272216, 1.2083672285079956, 0.04353711009025574, 1.4118282794952392, 1.2091988325119018, 0.040998425334692, 1.4159443378448486, 1.2084503173828125, 0.03845975175499916, 1.4175013303756713, 1.2061147689819336, 0.03606342524290085, 1.4161983728408813, 1.2021843194961547, 0.03395181894302368, 1.4117354154586792, 1.1966526508331298, 0.03226726874709129, 1.4038115739822387, 1.1895123720169067, 0.03115215338766575, 1.392126202583313, 1.1807562112808227, 0.03074880875647068, 1.388653039932251, 1.1895700693130493, 0.06864037364721298, 1.4016159772872924, 1.196831226348877, 0.06713495403528213, 1.413108468055725, 1.2025251388549804, 0.06486082822084427, 1.422874927520752, 1.2066364288330078, 0.06201014295220375, 1.4306612014770507, 1.2091504335403442, 0.05877511203289032, 1.4362119436264038, 1.2100517749786377, 0.055347900837659836, 1.439272403717041, 1.2093256711959838, 0.051920682191848755, 1.4395875930786132, 1.2069569826126098, 0.048685647547245026, 1.4369027614593505, 1.2029306888580322, 0.045834969729185104, 1.4309626817703247, 1.1972317695617675, 0.04356084018945694, 1.4215127229690551, 1.189845323562622, 0.04205542430281639, 1.4082978963851928, 1.1807563304901123, 0.04151090979576111, 1.4203364849090576, 1.1898057460784912, 0.08135157078504562, 1.43399977684021, 1.1972929239273071, 0.07956736534833908, 1.4456732273101806, 1.203193187713623, 0.07687210291624069, 1.455159068107605, 1.207481026649475, 0.07349351048469543, 1.4622597694396972, 1.2101318836212158, 0.06965940445661545, 1.4667774438858032, 1.2111204862594604, 0.06559751182794571, 1.4685145616531372, 1.210422396659851, 0.06153564155101776, 1.467273235321045, 1.2080124616622924, 0.057701513171195984, 1.4628556966781616, 1.203865885734558, 0.05432293564081192, 1.455064296722412, 1.1979575157165527, 0.05162766948342323, 1.4437015056610107, 1.1902625560760498, 0.049843478947877884, 1.4285694360733032, 1.1807562112808227, 0.049198128283023834, 1.4562925100326538, 1.1900737285614013, 0.08897827565670013, 1.4707502126693725, 1.1978175640106201, 0.08702681213617325, 1.482629418373108, 1.2039514780044555, 0.08407886326313019, 1.4917963743209838, 1.208439826965332, 0.0803835391998291, 1.4981189966201782, 1.2112458944320678, 0.07618997246026993, 1.5014644861221313, 1.2123339176177978, 0.0717473030090332, 1.501699686050415, 1.211667537689209, 0.06730460375547409, 1.4986916780471801, 1.2092108726501464, 0.06311104446649551, 1.4923080205917358, 1.2049274444580078, 0.059415724128484726, 1.4824156761169433, 1.1987814903259277, 0.056467775255441666, 1.4688819646835327, 1.1907364130020141, 0.05451631918549538, 1.4515739679336547, 1.1807564496994018, 0.05381046235561371, 1.4943841695785522, 1.1903573274612426, 0.0915205255150795, 1.509683609008789, 1.198372721672058, 0.08951330184936523, 1.5217803716659546, 1.2047548294067382, 0.08648113161325455, 1.5306099653244018, 1.209455132484436, 0.08268020302057266, 1.5361086130142212, 1.2124261856079101, 0.07836683094501495, 1.5382118225097656, 1.2136191129684448, 0.07379721105098724, 1.536855936050415, 1.2129865884780883, 0.06922759860754013, 1.5319768190383911, 1.2104802131652832, 0.06491421163082123, 1.5235099792480468, 1.2060520648956298, 0.06111330911517143, 1.5113919973373413, 1.1996541023254394, 0.05808113142848015, 1.495558500289917, 1.1912380456924438, 0.05607391521334648, 1.4759453535079956, 1.1807563304901123, 0.055347900837659836, 1.5324758291244506, 1.1906410455703735, 0.08897828310728073, 1.5486171245574951, 1.1989281177520752, 0.08702681213617325, 1.5609314441680908, 1.205557942390442, 0.08407886326313019, 1.5694235563278198, 1.2104706764221191, 0.0803835391998291, 1.574097990989685, 1.2136061191558838, 0.07618997246026993, 1.5749592781066894, 1.2149041891098022, 0.0717473030090332, 1.572012186050415, 1.2143055200576782, 0.06730460375547409, 1.5652616024017334, 1.21174955368042, 0.06311104446649551, 1.5547120571136474, 1.2071765661239624, 0.05941572040319443, 1.5403681993484497, 1.2005265951156616, 0.05646776780486107, 1.5222349166870117, 1.191739797592163, 0.05451630800962448, 1.5003167390823364, 1.1807563304901123, 0.05381045490503311, 1.5684313774108886, 1.190908670425415, 0.08135157823562622, 1.5853673219680786, 1.19945228099823, 0.07956738024950027, 1.5978872776031494, 1.206316351890564, 0.07687210291624069, 1.606060266494751, 1.211429238319397, 0.07349352538585663, 1.6099567413330078, 1.2147198915481567, 0.06965941190719604, 1.609645962715149, 1.21611750125885, 0.0655975192785263, 1.6051969528198242, 1.215550422668457, 0.06153564155101776, 1.5966798067092895, 1.2129477262496948, 0.05770152434706688, 1.5841641426086425, 1.208238124847412, 0.05432294309139252, 1.5677194595336914, 1.201350450515747, 0.05162767320871353, 1.5474151372909546, 1.192213535308838, 0.049843478947877884, 1.523321270942688, 1.1807563304901123, 0.04919813573360443, 1.6001150608062744, 1.1911447048187255, 0.06864038854837417, 1.6177512407302856, 1.1999140977859497, 0.06713496148586273, 1.6304525136947631, 1.2069844007492065, 0.06486084312200546, 1.6383447647094726, 1.2122737169265747, 0.06201015040278435, 1.6415555477142334, 1.215701699256897, 0.05877511948347092, 1.6402117013931274, 1.217186450958252, 0.05534790828824043, 1.63443922996521, 1.2166473865509033, 0.05192069336771965, 1.6243658065795898, 1.214003562927246, 0.04868565872311592, 1.6101173162460327, 1.209173560142517, 0.0458349771797657, 1.591821312904358, 1.2020763158798217, 0.04356084764003754, 1.5696042776107788, 1.1926307678222656, 0.042055435478687286, 1.5435928106307983, 1.1807563304901123, 0.041510920971632004, 1.625390887260437, 1.1913328170776367, 0.05084473267197609, 1.6435856819152832, 1.2002825736999511, 0.0497296079993248, 1.656430959701538, 1.2075172662734985, 0.04804506152868271, 1.6640994548797607, 1.2129476070404052, 0.045933447778224945, 1.6667637825012207, 1.2164846658706665, 0.04353712499141693, 1.6645952463150024, 1.2180393934249878, 0.040998440235853195, 1.6577671766281128, 1.2175226211547851, 0.038459762930870056, 1.6464518308639526, 1.2148457765579223, 0.03606344386935234, 1.6308214664459228, 1.209919810295105, 0.03395182266831398, 1.6110485792160034, 1.20265531539917, 0.03226727992296219, 1.5873054265975952, 1.1929638385772705, 0.031152162700891495, 1.5597643852233886, 1.1807563304901123, 0.030748821794986725, 1.6421226263046264, 1.1914572715759277, 0.027964595705270767, 1.6606870889663696, 1.2005265951156616, 0.027351275086402893, 1.673628568649292, 1.2078701257705688, 0.02642478048801422, 1.6811484098434448, 1.2133936882019043, 0.025263387709856033, 1.68345046043396, 1.2170031070709228, 0.023945411667227745, 1.6807366609573364, 1.2186038494110107, 0.022549133747816086, 1.6732097864151, 1.218101978302002, 0.021152859553694725, 1.6610723733901977, 1.2154033184051513, 0.019834881648421287, 1.6445268392562866, 1.2104135751724243, 0.018673494458198547, 1.6237764358520507, 1.2030388116836547, 0.017746996134519577, 1.5990231037139892, 1.19318425655365, 0.017133679240942, 1.5704697370529174, 1.1807562112808227, 0.016911840066313743, 1.6481746435165405, 1.1915024518966674, -8.441826793159634e-9, 1.6668729782104492, 1.2006149291992187, -9.797258115895601e-9, 1.6798486709594726, 1.2079980373382568, -1.1565845170480315e-8, 1.6873151063919067, 1.213555097579956, -1.362116464065366e-8, 1.6894861459732055, 1.2171906232833862, -1.583685360628806e-8, 1.6865750551223754, 1.2188081741333007, -1.8086524278260185e-8, 1.6787952184677124, 1.2183117866516113, -2.024379242016039e-8, 1.66636061668396, 1.2156052589416504, -2.2182266690151664e-8, 1.6494841575622558, 1.2105923891067504, -2.3775553970040164e-8, 1.6283799409866333, 1.2031774520874023, -2.4897293116055152e-8, 1.6032613515853881, 1.193264126777649, -2.5421083904575425e-8, 1.5743415355682373, 1.1807564496994018, -2.5220543875548174e-8, 1.6421229839324951, 1.1914572715759277, -0.027964672073721885, 1.6606873273849487, 1.2005265951156616, -0.02735135518014431, 1.673628568649292, 1.2078701257705688, -0.02642485313117504, 1.681148886680603, 1.2133936882019043, -0.02526346780359745, 1.683450698852539, 1.2170032262802124, -0.02394549548625946, 1.680736780166626, 1.2186038494110107, -0.02254921942949295, 1.6732099056243896, 1.2181018590927124, -0.02115294709801674, 1.6610723733901977, 1.2154033184051513, -0.0198349691927433, 1.6445270776748657, 1.2104135751724243, -0.018673580139875412, 1.6237764358520507, 1.2030386924743652, -0.01774708181619644, 1.5990231037139892, 1.19318425655365, -0.017133763059973717, 1.570469856262207, 1.1807563304901123, -0.016911925747990608, 1.625390887260437, 1.1913326978683471, -0.050844818353652954, 1.6435856819152832, 1.2002825736999511, -0.04972969368100166, 1.656430959701538, 1.2075172662734985, -0.04804514721035957, 1.6640994548797607, 1.2129474878311157, -0.04593352600932121, 1.6667635440826416, 1.216484546661377, -0.043537214398384094, 1.664595127105713, 1.2180392742156982, -0.04099852964282036, 1.6577671766281128, 1.217522382736206, -0.03845985606312752, 1.6464518308639526, 1.2148457765579223, -0.036063529551029205, 1.6308213472366333, 1.2099195718765258, -0.03395192325115204, 1.6110485792160034, 1.20265531539917, -0.03226737305521965, 1.5873054265975952, 1.1929638385772705, -0.031152257695794105, 1.5597643852233886, 1.1807562112808227, -0.030748913064599037, 1.600115180015564, 1.1911447048187255, -0.06864047795534134, 1.6177513599395752, 1.1999142169952392, -0.06713505834341049, 1.6304525136947631, 1.2069844007492065, -0.06486093252897262, 1.6383447647094726, 1.2122737169265747, -0.06201024726033211, 1.6415555477142334, 1.215701699256897, -0.05877521634101868, 1.640211820602417, 1.217186450958252, -0.05534800514578819, 1.63443922996521, 1.2166475057601928, -0.05192078649997711, 1.6243658065795898, 1.214003562927246, -0.04868575185537338, 1.6101173162460327, 1.209173560142517, -0.04583507403731346, 1.591821312904358, 1.2020763158798217, -0.0435609444975853, 1.5696042776107788, 1.1926307678222656, -0.04205552861094475, 1.5435928106307983, 1.1807563304901123, -0.041511014103889465, 1.5684312582015991, 1.1909085512161254, -0.08135167509317398, 1.5853673219680786, 1.19945228099823, -0.07956746965646744, 1.5978870391845703, 1.2063161134719848, -0.07687220722436905, 1.60606050491333, 1.2114291191101074, -0.07349361479282379, 1.6099567413330078, 1.2147198915481567, -0.0696595087647438, 1.6096457242965698, 1.2161173820495605, -0.06559761613607406, 1.6051969528198242, 1.2155503034591674, -0.06153574585914612, 1.5966798067092895, 1.2129476070404052, -0.05770161747932434, 1.5841641426086425, 1.2082380056381225, -0.05432303994894028, 1.5677193403244018, 1.2013503313064575, -0.05162777379155159, 1.5474151372909546, 1.192213535308838, -0.04984358325600624, 1.523321270942688, 1.1807562112808227, -0.04919823259115219, 1.5324760675430297, 1.1906410455703735, -0.08897837996482849, 1.5486171245574951, 1.1989282369613647, -0.0870269164443016, 1.56093168258667, 1.205557942390442, -0.08407896757125854, 1.5694235563278198, 1.2104706764221191, -0.08038364350795746, 1.574097990989685, 1.2136061191558838, -0.07619007676839828, 1.5749592781066894, 1.2149043083190918, -0.07174740731716156, 1.5720123052597046, 1.2143055200576782, -0.06730470806360245, 1.5652616024017334, 1.21174955368042, -0.06311114877462387, 1.5547120571136474, 1.207176685333252, -0.05941582843661308, 1.5403680801391601, 1.2005267143249511, -0.05646787956357002, 1.5222347974777221, 1.1917399168014526, -0.054516423493623733, 1.5003166198730468, 1.1807564496994018, -0.053810566663742065, 1.4943841695785522, 1.1903573274612426, -0.09152062982320785, 1.509683609008789, 1.198372721672058, -0.08951340615749359, 1.5217803716659546, 1.2047548294067382, -0.0864812359213829, 1.5306099653244018, 1.209455132484436, -0.08268030732870102, 1.5361084938049316, 1.2124261856079101, -0.07836693525314331, 1.538211703300476, 1.2136191129684448, -0.0737973153591156, 1.536855936050415, 1.2129865884780883, -0.06922770291566849, 1.5319768190383911, 1.2104802131652832, -0.06491431593894958, 1.5235099792480468, 1.2060520648956298, -0.06111341342329979, 1.5113919973373413, 1.1996541023254394, -0.058081235736608505, 1.495558500289917, 1.1912380456924438, -0.05607401952147484, 1.4759453535079956, 1.1807563304901123, -0.05534800514578819, 1.4562925100326538, 1.1900736093521118, -0.08897838741540909, 1.4707502126693725, 1.1978174448013305, -0.0870269164443016, 1.482629418373108, 1.2039514780044555, -0.08407896757125854, 1.4917963743209838, 1.2084394693374633, -0.08038364350795746, 1.4981193542480468, 1.2112458944320678, -0.07619007676839828, 1.501464605331421, 1.2123339176177978, -0.07174740731716156, 1.501699686050415, 1.211667537689209, -0.06730470806360245, 1.4986917972564697, 1.2092108726501464, -0.06311114877462387, 1.4923081398010254, 1.2049274444580078, -0.059415824711322784, 1.4824156761169433, 1.1987813711166381, -0.056467872112989426, 1.4688820838928222, 1.1907362937927246, -0.05451641231775284, 1.4515739679336547, 1.1807563304901123, -0.05381055921316147, 1.4203368425369262, 1.1898058652877807, -0.08135168254375458, 1.4339998960494995, 1.1972931623458862, -0.07956748455762863, 1.4456733465194702, 1.203193187713623, -0.07687220722436905, 1.455159306526184, 1.2074811458587646, -0.07349362969398498, 1.4622598886489868, 1.2101320028305053, -0.0696595162153244, 1.4667774438858032, 1.21112060546875, -0.06559762358665466, 1.4685146808624267, 1.2104225158691406, -0.06153574585914612, 1.4672731161117553, 1.208012580871582, -0.057701628655195236, 1.4628556966781616, 1.2038660049438476, -0.054323047399520874, 1.4550644159317016, 1.1979576349258422, -0.05162777751684189, 1.4437015056610107, 1.1902625560760498, -0.04984358325600624, 1.4285693168640136, 1.1807563304901123, -0.04919824004173279, 1.3886529207229614, 1.1895700693130493, -0.06864049285650253, 1.4016159772872924, 1.196831226348877, -0.06713506579399109, 1.413108468055725, 1.2025251388549804, -0.06486094743013382, 1.422874927520752, 1.2066364288330078, -0.062010254710912704, 1.4306613206863403, 1.2091504335403442, -0.058775223791599274, 1.436212182044983, 1.2100517749786377, -0.05534801259636879, 1.439272403717041, 1.2093255519866943, -0.05192079767584801, 1.4395877122879028, 1.2069569826126098, -0.04868576303124428, 1.4369027614593505, 1.2029305696487426, -0.04583508148789406, 1.4309626817703247, 1.1972317695617675, -0.043560951948165894, 1.4215127229690551, 1.189845323562622, -0.04205553978681564, 1.4082980155944824, 1.1807563304901123, -0.04151102527976036, 1.3633772134780883, 1.1893818378448486, -0.050844836980104446, 1.3757814168930053, 1.1964627504348754, -0.049729712307453155, 1.3871296644210815, 1.201992392539978, -0.048045165836811066, 1.3971201181411743, 1.2059626579284668, -0.0459335520863533, 1.4054534435272216, 1.2083673477172851, -0.04353722929954529, 1.4118282794952392, 1.2091989517211914, -0.04099854454398155, 1.4159443378448486, 1.2084505558013916, -0.03845986723899841, 1.4175013303756713, 1.2061147689819336, -0.0360635481774807, 1.4161986112594604, 1.2021845579147338, -0.03395192697644234, 1.4117354154586792, 1.1966526508331298, -0.032267384231090546, 1.4038115739822387, 1.1895123720169067, -0.03115226700901985, 1.392126202583313, 1.1807563304901123, -0.030748926103115082, 1.3466452360153198, 1.1892571449279785, -0.027964700013399124, 1.3586798906326294, 1.1962188482284546, -0.02735137939453125, 1.3699322938919067, 1.2016392946243286, -0.026424884796142578, 1.3800712823867797, 1.2055166959762573, -0.02526349201798439, 1.3887665271759033, 1.2078489065170288, -0.02394551783800125, 1.3956868648529052, 1.2086344957351684, -0.022549239918589592, 1.40050208568573, 1.2078710794448852, -0.02115296572446823, 1.4028810262680053, 1.205557107925415, -0.019834987819194793, 1.4024931192398071, 1.201690435409546, -0.018673598766326904, 1.399007797241211, 1.1962693929672241, -0.017747100442647934, 1.3920938968658447, 1.1892919540405273, -0.01713378354907036, 1.3814210891723632, 1.1807562112808227, -0.0169119443744421, 0, 1.549742579460144, -6.774140359766534e-8, 0.08273722231388092, 1.5467960834503173, -6.761261062138146e-8, 0.1371171474456787, 1.5384678840637207, -6.724857115614213e-8, 0.16758130490779877, 1.5255279541015625, -6.66829436113403e-8, 0.1785711795091629, 1.5087440013885498, -6.594930113124064e-8, 0.17452825605869293, 1.4888856410980224, -6.508125949267196e-8, 0.15989409387111664, 1.466720700263977, -6.411239894532627e-8, 0.13911013305187225, 1.4430184364318847, -6.307634237145976e-8, 0.11661791056394577, 1.418547511100769, -6.200668423161915e-8, 0.0968589261174202, 1.3940764665603637, -6.093701898635118e-8, 0.08427466452121734, 1.370374321937561, -5.990096241248466e-8, 0.08330664038658142, 1.3482096195220947, -5.893211607599369e-8, 0.09839636087417602, 1.3283507823944091, -5.806406022657029e-8, 0.0819980651140213, 1.546796202659607, 0.011404401622712612, 0.13589218258857727, 1.5384682416915893, 0.01889992319047451, 0.1660841405391693, 1.5255281925201416, 0.023098532110452652, 0.17697568237781525, 1.508744239807129, 0.024612268432974815, 0.1729687601327896, 1.4888856410980224, 0.024053171277046203, 0.15846507251262665, 1.4667208194732666, 0.02203327789902687, 0.13786645233631134, 1.4430184364318847, 0.019164619967341423, 0.11557470262050628, 1.418547511100769, 0.016059240326285362, 0.09599164873361587, 1.3940765857696533, 0.013329173438251018, 0.08351907134056091, 1.3703745603561401, 0.011586455628275871, 0.0825587809085846, 1.3482097387313842, 0.0114431232213974, 0.0975126177072525, 1.3283509016036987, 0.013511220924556255, 0.07984045147895813, 1.5467959642410278, 0.022288180887699127, 0.13231638073921204, 1.5384678840637207, 0.03693705052137375, 0.16171373426914215, 1.5255279541015625, 0.045142751187086105, 0.1723184585571289, 1.5087437629699707, 0.04810144007205963, 0.16841651499271393, 1.4888854026794433, 0.04700932279229164, 0.15429380536079407, 1.4667205810546875, 0.04306257888674736, 0.13423627614974975, 1.4430184364318847, 0.03745738044381142, 0.11252987384796142, 1.4185473918914795, 0.031389929354190826, 0.09346053004264831, 1.3940762281417846, 0.026056397706270218, 0.08131419122219085, 1.370374321937561, 0.022652972489595413, 0.08037678152322769, 1.3482095003128051, 0.022375835105776787, 0.09493426233530044, 1.3283506631851196, 0.026421183720231056, 0.07635414600372314, 1.546796202659607, 0.03256148472428322, 0.12653860449790954, 1.5384682416915893, 0.05396253988146782, 0.15465211868286133, 1.5255279541015625, 0.06595070660114288, 0.16479340195655823, 1.5087441205978393, 0.07027358561754226, 0.16106118261814117, 1.4888856410980224, 0.0686788409948349, 0.1475541740655899, 1.4667208194732666, 0.06291401386260986, 0.12837113440036774, 1.4430184364318847, 0.054726772010326385, 0.1076107770204544, 1.418547511100769, 0.045864712446928024, 0.08937180787324905, 1.3940764665603637, 0.03807544335722923, 0.077752985060215, 1.370374321937561, 0.033106569200754166, 0.07685301452875137, 1.3482096195220947, 0.03270572051405907, 0.0907706469297409, 1.3283507823944091, 0.03862050920724869, 0.07162894308567047, 1.5467958450317382, 0.042134568095207214, 0.11870763450860977, 1.5384676456451416, 0.069827601313591, 0.1450810730457306, 1.5255275964736938, 0.08534055203199386, 0.1545942723751068, 1.5087437629699707, 0.09093489497900009, 0.1510922610759735, 1.4888851642608642, 0.08887216448783874, 0.1384199559688568, 1.466720461845398, 0.08141380548477173, 0.12042244523763656, 1.4430183172225952, 0.0708213597536087, 0.10094466805458069, 1.4185473918914795, 0.05935629829764366, 0.08383164554834366, 1.3940762281417846, 0.04928012192249298, 0.07292837649583816, 1.370374321937561, 0.042854323983192444, 0.07207983732223511, 1.3482093811035156, 0.04234040156006813, 0.08513106405735016, 1.32835054397583, 0.049999866634607315, 0.06575461477041244, 1.5467960834503173, 0.050917621701955795, 0.10897225886583328, 1.5384678840637207, 0.08438342809677124, 0.1331825703382492, 1.5255279541015625, 0.10313038527965545, 0.14191503822803497, 1.5087440013885498, 0.10989146679639816, 0.13869935274124145, 1.488885521888733, 0.10739970207214355, 0.1270650327205658, 1.466720700263977, 0.09838810563087463, 0.1105416789650917, 1.4430184364318847, 0.08558966964483261, 0.0926588848233223, 1.418547511100769, 0.0717373788356781, 0.07694622129201889, 1.3940762281417846, 0.0595642551779747, 0.0669332891702652, 1.370374321937561, 0.05180330201983452, 0.06614962965250015, 1.3482095003128051, 0.05118751898407936, 0.07812488824129104, 1.3283507823944091, 0.06044992804527283, 0.0588209368288517, 1.5467960834503173, 0.05882086977362633, 0.09748129546642303, 1.5384678840637207, 0.09748122841119766, 0.11913839727640152, 1.5255279541015625, 0.11913833022117615, 0.1269495040178299, 1.5087440013885498, 0.12694944441318512, 0.12407202273607254, 1.4888856410980224, 0.12407195568084717, 0.11366317421197891, 1.466720700263977, 0.11366310715675354, 0.09888029843568802, 1.4430184364318847, 0.09888023883104324, 0.08288072049617767, 1.418547511100769, 0.0828806608915329, 0.06882172077894211, 1.3940764665603637, 0.06882166117429733, 0.05986063554883003, 1.3703744411468505, 0.05986057594418526, 0.05915474891662598, 1.3482097387313842, 0.0591546893119812, 0.06986141949892044, 1.3283509016036987, 0.06986135989427566, 0.05091768875718117, 1.5467960834503173, 0.06575454771518707, 0.08438349515199661, 1.5384678840637207, 0.10897219181060791, 0.10313045233488083, 1.5255279541015625, 0.13318251073360443, 0.10989153385162353, 1.5087440013885498, 0.1419149786233902, 0.10739976912736893, 1.4888856410980224, 0.13869929313659668, 0.0983881726861, 1.4667205810546875, 0.12706497311592102, 0.08558973670005798, 1.4430184364318847, 0.11054161936044693, 0.07173743844032287, 1.418547511100769, 0.09265882521867752, 0.059564318507909775, 1.3940763473510742, 0.07694616913795471, 0.05180336534976959, 1.370374321937561, 0.06693322956562042, 0.051187582314014435, 1.3482096195220947, 0.06614957749843597, 0.0604499913752079, 1.3283506631851196, 0.07812483608722687, 0.04213463515043259, 1.5467960834503173, 0.0716288834810257, 0.06982766836881637, 1.5384678840637207, 0.118707574903965, 0.08534061908721924, 1.5255279541015625, 0.14508101344108581, 0.09093496203422546, 1.5087440013885498, 0.15459424257278442, 0.08887223154306412, 1.4888856410980224, 0.15109220147132873, 0.0814138725399971, 1.466720700263977, 0.13841991126537323, 0.07082141935825348, 1.4430184364318847, 0.12042240053415298, 0.059356361627578735, 1.418547511100769, 0.10094461590051651, 0.049280181527137756, 1.3940764665603637, 0.08383159339427948, 0.04285438358783722, 1.370374321937561, 0.07292831689119339, 0.042340461164712906, 1.3482096195220947, 0.07207977771759033, 0.04999992996454239, 1.3283507823944091, 0.08513100445270538, 0.032561566680669785, 1.5467960834503173, 0.07635407894849777, 0.053962621837854385, 1.5384678840637207, 0.12653852999210358, 0.06595080345869064, 1.5255279541015625, 0.15465205907821655, 0.07027368992567062, 1.5087440013885498, 0.16479334235191345, 0.06867892295122146, 1.4888856410980224, 0.1610611230134964, 0.06291411072015762, 1.4667205810546875, 0.14755411446094513, 0.05472686514258385, 1.4430184364318847, 0.12837107479572296, 0.04586479067802429, 1.418547511100769, 0.10761070996522903, 0.038075514137744904, 1.3940763473510742, 0.08937174826860428, 0.033106639981269836, 1.370374321937561, 0.07775292545557022, 0.03270579129457474, 1.3482096195220947, 0.0768529400229454, 0.03862058371305466, 1.3283506631851196, 0.09077057987451553, 0.022288260981440544, 1.5467960834503173, 0.07984036952257156, 0.03693713992834091, 1.5384678840637207, 0.13231629133224487, 0.04514283686876297, 1.5255279541015625, 0.16171365976333618, 0.04810153320431709, 1.5087440013885498, 0.17231838405132294, 0.047009412199258804, 1.4888856410980224, 0.16841644048690796, 0.043062660843133926, 1.4667205810546875, 0.1542937308549881, 0.03745746240019798, 1.4430184364318847, 0.1342362016439438, 0.031390007585287094, 1.418547511100769, 0.11252979934215545, 0.026056472212076187, 1.3940763473510742, 0.09346047043800354, 0.022653046995401382, 1.370374321937561, 0.08131412416696548, 0.022375909611582756, 1.3482096195220947, 0.08037672191858291, 0.026421258226037025, 1.3283506631851196, 0.09493420273065567, 0.011404480785131454, 1.5467959642410278, 0.08199799805879593, 0.018900007009506225, 1.5384678840637207, 0.1358921080827713, 0.023098619654774666, 1.5255279541015625, 0.16608405113220215, 0.024612359702587127, 1.5087437629699707, 0.17697562277317047, 0.024053260684013366, 1.4888854026794433, 0.17296868562698364, 0.022033363580703735, 1.4667205810546875, 0.15846499800682068, 0.01916470378637314, 1.4430184364318847, 0.13786637783050537, 0.01605932042002678, 1.418547511100769, 0.11557463556528091, 0.013329248875379562, 1.3940764665603637, 0.0959915742278099, 0.011586527340114116, 1.370374321937561, 0.08351900428533554, 0.01144319586455822, 1.3482096195220947, 0.08255871385335922, 0.01351129449903965, 1.3283507823944091, 0.09751255065202713, 1.66438347548592e-8, 1.5467959642410278, 0.08273714035749435, 2.758285333470667e-8, 1.5384678840637207, 0.13711705803871155, 3.371022572196125e-8, 1.5255279541015625, 0.1675812304019928, 3.5919121899041784e-8, 1.5087440013885498, 0.17857106029987335, 3.51027296119355e-8, 1.4888854026794433, 0.17452819645404816, 3.215420107949285e-8, 1.466720700263977, 0.15989401936531067, 2.7966720494987385e-8, 1.4430184364318847, 0.13911007344722748, 2.3433454288124267e-8, 1.418547511100769, 0.1166178435087204, 1.9447575994036015e-8, 1.3940764665603637, 0.09685885161161423, 1.690225559514147e-8, 1.3703745603561401, 0.08427459746599197, 1.6690670179286826e-8, 1.3482097387313842, 0.08330657333135605, 1.9705995057961445e-8, 1.3283509016036987, 0.09839628636837005, -0.011404469609260559, 1.546796202659607, 0.08199799805879593, -0.018899990245699882, 1.5384682416915893, 0.1358921080827713, -0.023098599165678024, 1.5255281925201416, 0.16608408093452454, -0.02461233362555504, 1.508744239807129, 0.17697562277317047, -0.024053236469626426, 1.4888856410980224, 0.17296870052814484, -0.022033341228961944, 1.4667208194732666, 0.15846501290798187, -0.019164683297276497, 1.4430184364318847, 0.13786639273166656, -0.016059301793575287, 1.418547511100769, 0.11557464301586151, -0.013329233974218368, 1.3940765857696533, 0.0959915891289711, -0.011586515232920646, 1.3703745603561401, 0.08351901173591614, -0.0114431818947196, 1.3482097387313842, 0.08255872130393982, -0.013511278666555881, 1.3283509016036987, 0.09751255810260773, -0.0222882479429245, 1.5467959642410278, 0.07984038442373276, -0.03693711757659912, 1.5384678840637207, 0.13231630623340607, -0.04514281824231148, 1.5255279541015625, 0.16171367466449737, -0.048101507127285004, 1.5087437629699707, 0.17231839895248413, -0.047009386122226715, 1.4888854026794433, 0.16841645538806915, -0.043062642216682434, 1.4667205810546875, 0.1542937457561493, -0.03745744377374649, 1.4430184364318847, 0.13423621654510498, -0.0313899926841259, 1.4185473918914795, 0.11252981424331665, -0.026056459173560142, 1.3940762281417846, 0.09346047043800354, -0.02265303209424019, 1.370374321937561, 0.08131413161754608, -0.022375894710421562, 1.3482095003128051, 0.08037672191858291, -0.026421241462230682, 1.3283506631851196, 0.09493420273065567, -0.03256155177950859, 1.546796202659607, 0.07635407894849777, -0.05396260693669319, 1.5384682416915893, 0.12653852999210358, -0.06595077365636825, 1.5255279541015625, 0.15465205907821655, -0.07027365267276764, 1.5087441205978393, 0.16479334235191345, -0.06867890805006027, 1.4888856410980224, 0.1610611230134964, -0.06291408091783523, 1.4667208194732666, 0.14755411446094513, -0.05472683534026146, 1.4430184364318847, 0.12837107479572296, -0.0458647757768631, 1.418547511100769, 0.10761071741580963, -0.03807550296187401, 1.3940764665603637, 0.08937174826860428, -0.03310662880539894, 1.370374321937561, 0.07775292545557022, -0.03270578011870384, 1.3482096195220947, 0.0768529549241066, -0.03862056881189346, 1.3283507823944091, 0.09077058732509613, -0.04213463515043259, 1.5467958450317382, 0.0716288760304451, -0.06982766836881637, 1.5384676456451416, 0.1187075674533844, -0.08534061908721924, 1.5255275964736938, 0.14508101344108581, -0.09093496203422546, 1.5087437629699707, 0.15459421277046204, -0.08887223154306412, 1.4888851642608642, 0.15109220147132873, -0.0814138725399971, 1.466720461845398, 0.13841989636421204, -0.07082141935825348, 1.4430183172225952, 0.12042238563299179, -0.059356361627578735, 1.4185473918914795, 0.10094460844993591, -0.049280181527137756, 1.3940762281417846, 0.08383158594369888, -0.04285438358783722, 1.370374321937561, 0.07292831689119339, -0.042340461164712906, 1.3482093811035156, 0.07207977771759033, -0.04999992623925209, 1.32835054397583, 0.08513100445270538, -0.05091768875718117, 1.5467960834503173, 0.06575454771518707, -0.08438349515199661, 1.5384678840637207, 0.10897219181060791, -0.10313045233488083, 1.5255279541015625, 0.13318251073360443, -0.10989153385162353, 1.5087440013885498, 0.1419149786233902, -0.10739976912736893, 1.488885521888733, 0.13869929313659668, -0.0983881726861, 1.466720700263977, 0.12706497311592102, -0.08558972924947738, 1.4430184364318847, 0.11054161936044693, -0.07173743844032287, 1.418547511100769, 0.09265882521867752, -0.059564314782619476, 1.3940762281417846, 0.07694616168737411, -0.051803361624479294, 1.370374321937561, 0.06693322956562042, -0.051187578588724136, 1.3482095003128051, 0.06614957004785538, -0.0604499876499176, 1.3283507823944091, 0.07812482863664627, -0.0588209368288517, 1.5467960834503173, 0.05882086977362633, -0.09748129546642303, 1.5384678840637207, 0.09748122841119766, -0.11913839727640152, 1.5255279541015625, 0.11913833022117615, -0.1269495040178299, 1.5087440013885498, 0.12694944441318512, -0.12407202273607254, 1.4888856410980224, 0.12407195568084717, -0.11366317421197891, 1.466720700263977, 0.11366310715675354, -0.09888029843568802, 1.4430184364318847, 0.09888023883104324, -0.08288072049617767, 1.418547511100769, 0.0828806608915329, -0.06882172077894211, 1.3940764665603637, 0.06882166117429733, -0.05986063554883003, 1.3703744411468505, 0.05986057594418526, -0.05915474891662598, 1.3482097387313842, 0.0591546893119812, -0.06986141949892044, 1.3283509016036987, 0.06986135989427566, -0.06575461477041244, 1.5467960834503173, 0.050917621701955795, -0.10897225886583328, 1.5384678840637207, 0.08438342809677124, -0.1331825703382492, 1.5255279541015625, 0.10313038527965545, -0.14191503822803497, 1.5087440013885498, 0.10989146679639816, -0.13869935274124145, 1.4888856410980224, 0.10739970207214355, -0.1270650327205658, 1.4667205810546875, 0.09838810563087463, -0.1105416789650917, 1.4430184364318847, 0.08558967709541321, -0.0926588848233223, 1.418547511100769, 0.0717373788356781, -0.07694622874259949, 1.3940763473510742, 0.059564258903265, -0.0669332891702652, 1.370374321937561, 0.05180330574512482, -0.06614963710308075, 1.3482096195220947, 0.05118752270936966, -0.07812489569187164, 1.3283506631851196, 0.060449931770563126, -0.07162895053625107, 1.5467960834503173, 0.042134568095207214, -0.11870764195919037, 1.5384678840637207, 0.069827601313591, -0.1450810730457306, 1.5255279541015625, 0.08534055203199386, -0.1545943021774292, 1.5087440013885498, 0.09093489497900009, -0.1510922610759735, 1.4888856410980224, 0.08887216448783874, -0.138419970870018, 1.466720700263977, 0.08141380548477173, -0.12042246013879776, 1.4430184364318847, 0.0708213597536087, -0.10094467550516128, 1.418547511100769, 0.05935629829764366, -0.08383165299892425, 1.3940764665603637, 0.04928012192249298, -0.07292837649583816, 1.370374321937561, 0.042854323983192444, -0.07207983732223511, 1.3482096195220947, 0.04234040156006813, -0.08513106405735016, 1.3283507823944091, 0.049999870359897613, -0.07635414600372314, 1.5467960834503173, 0.03256149962544441, -0.12653860449790954, 1.5384678840637207, 0.05396255478262901, -0.15465211868286133, 1.5255279541015625, 0.06595073640346527, -0.16479340195655823, 1.5087440013885498, 0.07027362287044525, -0.16106118261814117, 1.4888856410980224, 0.0686788558959961, -0.1475541740655899, 1.4667205810546875, 0.06291404366493225, -0.12837113440036774, 1.4430184364318847, 0.05472680181264877, -0.10761076956987381, 1.418547511100769, 0.04586472734808922, -0.08937180787324905, 1.3940763473510742, 0.03807545453310013, -0.077752985060215, 1.370374321937561, 0.03310658037662506, -0.07685299962759018, 1.3482096195220947, 0.03270573168992996, -0.09077063947916031, 1.3283506631851196, 0.03862052410840988, -0.07984043657779693, 1.5467960834503173, 0.022288193926215172, -0.13231636583805084, 1.5384678840637207, 0.03693707287311554, -0.16171371936798096, 1.5255279541015625, 0.0451427698135376, -0.1723184436559677, 1.5087440013885498, 0.04810146614909172, -0.16841650009155273, 1.4888856410980224, 0.04700934886932373, -0.15429379045963287, 1.4667205810546875, 0.04306259751319885, -0.13423626124858856, 1.4430184364318847, 0.03745739907026291, -0.11252985894680023, 1.418547511100769, 0.03138994425535202, -0.09346053004264831, 1.3940763473510742, 0.026056410744786262, -0.08131418377161026, 1.370374321937561, 0.022652987390756607, -0.08037678152322769, 1.3482096195220947, 0.02237585000693798, -0.09493426233530044, 1.3283506631851196, 0.0264212004840374, -0.0819980651140213, 1.5467959642410278, 0.011404412798583507, -0.13589218258857727, 1.5384678840637207, 0.018899939954280853, -0.16608411073684692, 1.5255279541015625, 0.023098552599549293, -0.17697568237781525, 1.5087437629699707, 0.024612294510006904, -0.17296874523162842, 1.4888854026794433, 0.024053195491433143, -0.15846505761146545, 1.4667205810546875, 0.02203330025076866, -0.13786643743515015, 1.4430184364318847, 0.019164640456438064, -0.11557469516992569, 1.418547511100769, 0.016059258952736854, -0.09599163383245468, 1.3940764665603637, 0.013329188339412212, -0.08351906388998031, 1.370374321937561, 0.011586467735469341, -0.082558773458004, 1.3482096195220947, 0.01144313719123602, -0.0975126102566719, 1.3283507823944091, 0.013511236757040023, -0.08273720741271972, 1.5467959642410278, -5.096876876109491e-8, -0.13711713254451752, 1.5384678840637207, -3.9665717821435464e-8, -0.16758129000663757, 1.5255279541015625, -3.2972717889379055e-8, -0.17857111990451813, 1.5087440013885498, -3.003017923219886e-8, -0.17452825605869293, 1.4888854026794433, -2.99785227753091e-8, -0.15989407896995544, 1.466720700263977, -3.1958197865833426e-8, -0.13911013305187225, 1.4430184364318847, -3.5109621876472374e-8, -0.11661790311336517, 1.418547511100769, -3.857322994349488e-8, -0.096858911216259, 1.3940764665603637, -4.148944299231516e-8, -0.08427465707063675, 1.3703745603561401, -4.2998721028197906e-8, -0.08330663293600082, 1.3482097387313842, -4.224144944942054e-8, -0.09839634597301483, 1.3283509016036987, -3.835807405039304e-8, -0.0819980651140213, 1.546796202659607, -0.011404537595808506, -0.13589218258857727, 1.5384682416915893, -0.018900057300925255, -0.1660841405391693, 1.5255281925201416, -0.023098666220903396, -0.17697568237781525, 1.508744239807129, -0.02461239881813526, -0.1729687601327896, 1.4888856410980224, -0.02405330166220665, -0.15846507251262665, 1.4667208194732666, -0.02203340455889702, -0.13786645233631134, 1.4430184364318847, -0.01916474662721157, -0.11557470262050628, 1.418547511100769, -0.01605936326086521, -0.09599164873361587, 1.3940765857696533, -0.013329294510185718, -0.08351907134056091, 1.3703745603561401, -0.011586574837565422, -0.0825587809085846, 1.3482097387313842, -0.011443240568041801, -0.0975126177072525, 1.3283509016036987, -0.013511336408555507, -0.07984045147895813, 1.5467959642410278, -0.022288314998149872, -0.13231638073921204, 1.5384678840637207, -0.03693718463182449, -0.16171373426914215, 1.5255279541015625, -0.04514288529753685, -0.1723184585571289, 1.5087437629699707, -0.048101574182510376, -0.16841651499271393, 1.4888854026794433, -0.04700944945216179, -0.15429380536079407, 1.4667205810546875, -0.04306270554661751, -0.13423627614974975, 1.4430184364318847, -0.037457507103681564, -0.11252987384796142, 1.4185473918914795, -0.031390056014060974, -0.09346053004264831, 1.3940762281417846, -0.026056520640850067, -0.08131419122219085, 1.370374321937561, -0.022653091698884964, -0.08037678152322769, 1.3482095003128051, -0.022375954315066337, -0.09493426233530044, 1.3283506631851196, -0.02642129920423031, -0.07635414600372314, 1.546796202659607, -0.03256161883473396, -0.12653860449790954, 1.5384682416915893, -0.053962673991918564, -0.15465211868286133, 1.5255279541015625, -0.06595084071159363, -0.16479340195655823, 1.5087441205978393, -0.07027371972799301, -0.16106118261814117, 1.4888856410980224, -0.06867897510528564, -0.1475541740655899, 1.4667208194732666, -0.06291414797306061, -0.12837113440036774, 1.4430184364318847, -0.05472689867019653, -0.1076107770204544, 1.418547511100769, -0.04586483910679817, -0.08937180787324905, 1.3940764665603637, -0.038075562566518784, -0.077752985060215, 1.370374321937561, -0.033106688410043716, -0.07685301452875137, 1.3482096195220947, -0.03270583972334862, -0.0907706469297409, 1.3283507823944091, -0.03862062841653824, -0.07162894308567047, 1.5467958450317382, -0.04213470220565796, -0.11870763450860977, 1.5384676456451416, -0.06982773542404175, -0.1450810730457306, 1.5255275964736938, -0.08534068614244461, -0.1545942723751068, 1.5087437629699707, -0.09093502908945083, -0.1510922610759735, 1.4888851642608642, -0.08887229859828949, -0.1384199559688568, 1.466720461845398, -0.08141393959522247, -0.12042244523763656, 1.4430183172225952, -0.07082147896289825, -0.10094466805458069, 1.4185473918914795, -0.05935642495751381, -0.08383164554834366, 1.3940762281417846, -0.04928024113178253, -0.07292837649583816, 1.370374321937561, -0.042854443192481995, -0.07207983732223511, 1.3482093811035156, -0.04234052076935768, -0.08513106405735016, 1.32835054397583, -0.049999985843896866, -0.06575461477041244, 1.5467960834503173, -0.05091775581240654, -0.10897225886583328, 1.5384678840637207, -0.08438356220722198, -0.1331825703382492, 1.5255279541015625, -0.1031305193901062, -0.14191503822803497, 1.5087440013885498, -0.10989160090684891, -0.13869935274124145, 1.488885521888733, -0.1073998361825943, -0.1270650327205658, 1.466720700263977, -0.09838823974132538, -0.1105416789650917, 1.4430184364318847, -0.08558978885412216, -0.0926588848233223, 1.418547511100769, -0.07173749804496765, -0.07694622129201889, 1.3940762281417846, -0.05956437438726425, -0.0669332891702652, 1.370374321937561, -0.05180342122912407, -0.06614962965250015, 1.3482095003128051, -0.05118763819336891, -0.07812488824129104, 1.3283507823944091, -0.06045004725456238, -0.0588209368288517, 1.5467960834503173, -0.05882100388407707, -0.09748129546642303, 1.5384678840637207, -0.09748136252164841, -0.11913839727640152, 1.5255279541015625, -0.11913846433162689, -0.1269495040178299, 1.5087440013885498, -0.12694956362247467, -0.12407202273607254, 1.4888856410980224, -0.12407208979129791, -0.11366317421197891, 1.466720700263977, -0.11366324126720428, -0.09888029843568802, 1.4430184364318847, -0.0988803580403328, -0.08288072049617767, 1.418547511100769, -0.08288078010082245, -0.06882172077894211, 1.3940764665603637, -0.06882178038358688, -0.05986063554883003, 1.3703744411468505, -0.05986069515347481, -0.05915474891662598, 1.3482097387313842, -0.05915480852127075, -0.06986141949892044, 1.3283509016036987, -0.06986147910356521, -0.05091768875718117, 1.5467960834503173, -0.06575468182563782, -0.08438349515199661, 1.5384678840637207, -0.10897232592105865, -0.10313045233488083, 1.5255279541015625, -0.13318262994289398, -0.10989153385162353, 1.5087440013885498, -0.14191509783267975, -0.10739976912736893, 1.4888856410980224, -0.13869941234588623, -0.0983881726861, 1.4667205810546875, -0.12706509232521057, -0.08558973670005798, 1.4430184364318847, -0.11054173856973648, -0.07173743844032287, 1.418547511100769, -0.09265894442796707, -0.059564318507909775, 1.3940763473510742, -0.07694628834724426, -0.05180336534976959, 1.370374321937561, -0.06693334877490997, -0.051187582314014435, 1.3482096195220947, -0.06614969670772552, -0.0604499913752079, 1.3283506631851196, -0.07812495529651642, -0.04213463515043259, 1.5467960834503173, -0.07162901759147644, -0.06982766836881637, 1.5384678840637207, -0.11870770901441574, -0.08534061908721924, 1.5255279541015625, -0.14508113265037537, -0.09093496203422546, 1.5087440013885498, -0.15459436178207397, -0.08887223154306412, 1.4888856410980224, -0.1510923206806183, -0.0814138725399971, 1.466720700263977, -0.13842003047466278, -0.07082141935825348, 1.4430184364318847, -0.12042251974344253, -0.059356361627578735, 1.418547511100769, -0.10094473510980606, -0.049280181527137756, 1.3940764665603637, -0.08383171260356903, -0.04285438358783722, 1.370374321937561, -0.07292843610048294, -0.042340461164712906, 1.3482096195220947, -0.07207989692687988, -0.04999992996454239, 1.3283507823944091, -0.08513112366199493, -0.032561566680669785, 1.5467960834503173, -0.07635421305894851, -0.053962621837854385, 1.5384678840637207, -0.12653867900371551, -0.06595080345869064, 1.5255279541015625, -0.1546521782875061, -0.07027368992567062, 1.5087440013885498, -0.164793461561203, -0.06867892295122146, 1.4888856410980224, -0.16106124222278595, -0.06291411072015762, 1.4667205810546875, -0.14755423367023468, -0.05472686514258385, 1.4430184364318847, -0.1283711940050125, -0.04586479067802429, 1.418547511100769, -0.10761082917451858, -0.038075514137744904, 1.3940763473510742, -0.08937186747789383, -0.033106639981269836, 1.370374321937561, -0.07775304466485977, -0.03270579129457474, 1.3482096195220947, -0.07685305923223495, -0.03862058371305466, 1.3283506631851196, -0.09077069908380508, -0.022288260981440544, 1.5467960834503173, -0.07984050363302231, -0.03693713992834091, 1.5384678840637207, -0.1323164403438568, -0.04514283686876297, 1.5255279541015625, -0.16171377897262573, -0.04810153320431709, 1.5087440013885498, -0.1723185032606125, -0.047009412199258804, 1.4888856410980224, -0.1684165596961975, -0.043062660843133926, 1.4667205810546875, -0.15429385006427765, -0.03745746240019798, 1.4430184364318847, -0.13423632085323334, -0.031390007585287094, 1.418547511100769, -0.11252991855144501, -0.026056472212076187, 1.3940763473510742, -0.09346058964729309, -0.022653046995401382, 1.370374321937561, -0.08131424337625503, -0.022375909611582756, 1.3482096195220947, -0.08037684112787247, -0.026421258226037025, 1.3283506631851196, -0.09493432193994522, -0.011404480785131454, 1.5467959642410278, -0.08199813216924667, -0.018900007009506225, 1.5384678840637207, -0.13589225709438324, -0.023098619654774666, 1.5255279541015625, -0.1660841703414917, -0.024612359702587127, 1.5087437629699707, -0.17697574198246002, -0.024053260684013366, 1.4888854026794433, -0.1729688048362732, -0.022033363580703735, 1.4667205810546875, -0.15846511721611023, -0.01916470378637314, 1.4430184364318847, -0.13786649703979492, -0.01605932042002678, 1.418547511100769, -0.11557475477457046, -0.013329248875379562, 1.3940764665603637, -0.09599169343709945, -0.011586527340114116, 1.370374321937561, -0.08351912349462509, -0.01144319586455822, 1.3482096195220947, -0.08255883306264877, -0.01351129449903965, 1.3283507823944091, -0.09751266986131668, -1.66438347548592e-8, 1.5467959642410278, -0.0827372744679451, -2.758285333470667e-8, 1.5384678840637207, -0.1371172070503235, -3.371022572196125e-8, 1.5255279541015625, -0.16758134961128235, -3.5919121899041784e-8, 1.5087440013885498, -0.1785711795091629, -3.51027296119355e-8, 1.4888854026794433, -0.1745283156633377, -3.215420107949285e-8, 1.466720700263977, -0.15989413857460022, -2.7966720494987385e-8, 1.4430184364318847, -0.13911019265651703, -2.3433454288124267e-8, 1.418547511100769, -0.11661796271800995, -1.9447575994036015e-8, 1.3940764665603637, -0.09685897082090378, -1.690225559514147e-8, 1.3703745603561401, -0.08427471667528152, -1.6690670179286826e-8, 1.3482097387313842, -0.0833066925406456, -1.9705995057961445e-8, 1.3283509016036987, -0.0983964055776596, 0.011404469609260559, 1.546796202659607, -0.08199813216924667, 0.018899990245699882, 1.5384682416915893, -0.13589225709438324, 0.023098599165678024, 1.5255281925201416, -0.1660842001438141, 0.02461233362555504, 1.508744239807129, -0.17697574198246002, 0.024053236469626426, 1.4888856410980224, -0.1729688197374344, 0.022033341228961944, 1.4667208194732666, -0.15846513211727142, 0.019164683297276497, 1.4430184364318847, -0.13786651194095611, 0.016059301793575287, 1.418547511100769, -0.11557476222515106, 0.013329233974218368, 1.3940765857696533, -0.09599170833826065, 0.011586515232920646, 1.3703745603561401, -0.08351913094520569, 0.0114431818947196, 1.3482097387313842, -0.08255884051322937, 0.013511278666555881, 1.3283509016036987, -0.09751267731189728, 0.0222882479429245, 1.5467959642410278, -0.0798405185341835, 0.03693711757659912, 1.5384678840637207, -0.132316455245018, 0.04514281824231148, 1.5255279541015625, -0.16171379387378693, 0.048101507127285004, 1.5087437629699707, -0.17231851816177368, 0.047009386122226715, 1.4888854026794433, -0.1684165745973587, 0.043062642216682434, 1.4667205810546875, -0.15429386496543884, 0.03745744377374649, 1.4430184364318847, -0.13423633575439453, 0.0313899926841259, 1.4185473918914795, -0.1125299334526062, 0.026056459173560142, 1.3940762281417846, -0.09346058964729309, 0.02265303209424019, 1.370374321937561, -0.08131425082683563, 0.022375894710421562, 1.3482095003128051, -0.08037684112787247, 0.026421241462230682, 1.3283506631851196, -0.09493432193994522, 0.03256155177950859, 1.546796202659607, -0.07635421305894851, 0.05396260693669319, 1.5384682416915893, -0.12653867900371551, 0.06595077365636825, 1.5255279541015625, -0.1546521782875061, 0.07027365267276764, 1.5087441205978393, -0.164793461561203, 0.06867890805006027, 1.4888856410980224, -0.16106124222278595, 0.06291408091783523, 1.4667208194732666, -0.14755423367023468, 0.05472683534026146, 1.4430184364318847, -0.1283711940050125, 0.0458647757768631, 1.418547511100769, -0.10761083662509918, 0.03807550296187401, 1.3940764665603637, -0.08937186747789383, 0.03310662880539894, 1.370374321937561, -0.07775304466485977, 0.03270578011870384, 1.3482096195220947, -0.07685307413339615, 0.03862056881189346, 1.3283507823944091, -0.09077070653438568, 0.04213463515043259, 1.5467958450317382, -0.07162901014089584, 0.06982766836881637, 1.5384676456451416, -0.11870770156383514, 0.08534061908721924, 1.5255275964736938, -0.14508113265037537, 0.09093496203422546, 1.5087437629699707, -0.1545943319797516, 0.08887223154306412, 1.4888851642608642, -0.1510923206806183, 0.0814138725399971, 1.466720461845398, -0.1384200155735016, 0.07082141935825348, 1.4430183172225952, -0.12042250484228134, 0.059356361627578735, 1.4185473918914795, -0.10094472765922546, 0.049280181527137756, 1.3940762281417846, -0.08383170515298843, 0.04285438358783722, 1.370374321937561, -0.07292843610048294, 0.042340461164712906, 1.3482093811035156, -0.07207989692687988, 0.04999992623925209, 1.32835054397583, -0.08513112366199493, 0.05091768875718117, 1.5467960834503173, -0.06575468182563782, 0.08438349515199661, 1.5384678840637207, -0.10897232592105865, 0.10313045233488083, 1.5255279541015625, -0.13318262994289398, 0.10989153385162353, 1.5087440013885498, -0.14191509783267975, 0.10739976912736893, 1.488885521888733, -0.13869941234588623, 0.0983881726861, 1.466720700263977, -0.12706509232521057, 0.08558972924947738, 1.4430184364318847, -0.11054173856973648, 0.07173743844032287, 1.418547511100769, -0.09265894442796707, 0.059564314782619476, 1.3940762281417846, -0.07694628089666366, 0.051803361624479294, 1.370374321937561, -0.06693334877490997, 0.051187578588724136, 1.3482095003128051, -0.06614968925714493, 0.0604499876499176, 1.3283507823944091, -0.07812494784593582, 0.0588209368288517, 1.5467960834503173, -0.05882100388407707, 0.09748129546642303, 1.5384678840637207, -0.09748136252164841, 0.11913839727640152, 1.5255279541015625, -0.11913846433162689, 0.1269495040178299, 1.5087440013885498, -0.12694956362247467, 0.12407202273607254, 1.4888856410980224, -0.12407208979129791, 0.11366317421197891, 1.466720700263977, -0.11366324126720428, 0.09888029843568802, 1.4430184364318847, -0.0988803580403328, 0.08288072049617767, 1.418547511100769, -0.08288078010082245, 0.06882172077894211, 1.3940764665603637, -0.06882178038358688, 0.05986063554883003, 1.3703744411468505, -0.05986069515347481, 0.05915474891662598, 1.3482097387313842, -0.05915480852127075, 0.06986141949892044, 1.3283509016036987, -0.06986147910356521, 0.06575461477041244, 1.5467960834503173, -0.05091775581240654, 0.10897225886583328, 1.5384678840637207, -0.08438356220722198, 0.1331825703382492, 1.5255279541015625, -0.1031305193901062, 0.14191503822803497, 1.5087440013885498, -0.10989160090684891, 0.13869935274124145, 1.4888856410980224, -0.1073998361825943, 0.1270650327205658, 1.4667205810546875, -0.09838823974132538, 0.1105416789650917, 1.4430184364318847, -0.08558979630470276, 0.0926588848233223, 1.418547511100769, -0.07173749804496765, 0.07694622874259949, 1.3940763473510742, -0.05956437811255455, 0.0669332891702652, 1.370374321937561, -0.05180342495441437, 0.06614963710308075, 1.3482096195220947, -0.05118764191865921, 0.07812489569187164, 1.3283506631851196, -0.060450050979852676, 0.07162895053625107, 1.5467960834503173, -0.04213470220565796, 0.11870764195919037, 1.5384678840637207, -0.06982773542404175, 0.1450810730457306, 1.5255279541015625, -0.08534068614244461, 0.1545943021774292, 1.5087440013885498, -0.09093502908945083, 0.1510922610759735, 1.4888856410980224, -0.08887229859828949, 0.138419970870018, 1.466720700263977, -0.08141393959522247, 0.12042246013879776, 1.4430184364318847, -0.07082147896289825, 0.10094467550516128, 1.418547511100769, -0.05935642495751381, 0.08383165299892425, 1.3940764665603637, -0.04928024113178253, 0.07292837649583816, 1.370374321937561, -0.042854443192481995, 0.07207983732223511, 1.3482096195220947, -0.04234052076935768, 0.08513106405735016, 1.3283507823944091, -0.049999989569187164, 0.07635414600372314, 1.5467960834503173, -0.03256163373589516, 0.12653860449790954, 1.5384678840637207, -0.05396268889307976, 0.15465211868286133, 1.5255279541015625, -0.06595087051391601, 0.16479340195655823, 1.5087440013885498, -0.070273756980896, 0.16106118261814117, 1.4888856410980224, -0.06867899000644684, 0.1475541740655899, 1.4667205810546875, -0.062914177775383, 0.12837113440036774, 1.4430184364318847, -0.05472692847251892, 0.10761076956987381, 1.418547511100769, -0.045864854007959366, 0.08937180787324905, 1.3940763473510742, -0.03807557374238968, 0.077752985060215, 1.370374321937561, -0.03310669958591461, 0.07685299962759018, 1.3482096195220947, -0.03270585089921951, 0.09077063947916031, 1.3283506631851196, -0.03862064331769943, 0.07984043657779693, 1.5467960834503173, -0.022288328036665916, 0.13231636583805084, 1.5384678840637207, -0.036937206983566284, 0.16171371936798096, 1.5255279541015625, -0.04514290392398834, 0.1723184436559677, 1.5087440013885498, -0.048101600259542465, 0.16841650009155273, 1.4888856410980224, -0.04700947552919388, 0.15429379045963287, 1.4667205810546875, -0.043062724173069, 0.13423626124858856, 1.4430184364318847, -0.03745752573013306, 0.11252985894680023, 1.418547511100769, -0.03139007091522217, 0.09346053004264831, 1.3940763473510742, -0.026056533679366112, 0.08131418377161026, 1.370374321937561, -0.022653106600046158, 0.08037678152322769, 1.3482096195220947, -0.02237596921622753, 0.09493426233530044, 1.3283506631851196, -0.02642131596803665, 0.0819980651140213, 1.5467959642410278, -0.011404548771679401, 0.13589218258857727, 1.5384678840637207, -0.018900074064731598, 0.16608411073684692, 1.5255279541015625, -0.023098686710000038, 0.17697568237781525, 1.5087437629699707, -0.02461242489516735, 0.17296874523162842, 1.4888854026794433, -0.02405332587659359, 0.15846505761146545, 1.4667205810546875, -0.02203342691063881, 0.13786643743515015, 1.4430184364318847, -0.019164767116308212, 0.11557469516992569, 1.418547511100769, -0.016059381887316704, 0.09599163383245468, 1.3940764665603637, -0.013329309411346912, 0.08351906388998031, 1.370374321937561, -0.011586586944758892, 0.082558773458004, 1.3482096195220947, -0.01144325453788042, 0.0975126102566719, 1.3283507823944091, -0.013511352241039276, 0.12971465289592743, 1.3113535642623901, -5.73210883203501e-8, 0.17264914512634277, 1.296918511390686, -5.6690112160140415e-8, 0.2244666963815689, 1.2845337390899658, -5.6148753202478474e-8, 0.28243401646614074, 1.273686170578003, -5.5674590271337365e-8, 0.3438178300857544, 1.2638635635375976, -5.524523061239961e-8, 0.4058850109577179, 1.2545535564422607, -5.483827791863405e-8, 0.4659021198749542, 1.2452435493469238, -5.443132522486849e-8, 0.5211362242698669, 1.235420823097229, -5.400196201321705e-8, 0.5688538551330566, 1.2245732545852661, -5.3527799082075944e-8, 0.6063219904899597, 1.2121883630752563, -5.2986440124414e-8, 0.6308072209358215, 1.1977535486221313, -5.2355471069631676e-8, 0.6395763158798218, 1.1807563304901123, -5.1612499163411485e-8, 0.12854963541030884, 1.3113536834716796, 0.01781168393790722, 0.171098530292511, 1.2969187498092651, 0.023707233369350433, 0.22245065867900848, 1.2845337390899658, 0.030822549015283584, 0.2798972725868225, 1.273686170578003, 0.03878231346607208, 0.34072986245155334, 1.2638638019561767, 0.04721122607588768, 0.40223950147628784, 1.2545535564422607, 0.05573396384716034, 0.4617176651954651, 1.2452435493469238, 0.06397522240877151, 0.5164556503295898, 1.235421061515808, 0.07155966758728027, 0.5637447834014893, 1.2245734930038452, 0.07811201363801956, 0.6008763313293457, 1.212188482284546, 0.08325694501399994, 0.6251415014266968, 1.197753667831421, 0.08661912381649017, 0.6338319182395935, 1.1807563304901123, 0.08782325685024261, 0.12515060603618622, 1.3113534450531005, 0.0348307304084301, 0.16657444834709167, 1.2969183921813964, 0.04635943844914436, 0.21656878292560577, 1.2845335006713867, 0.06027340143918991, 0.27249646186828613, 1.2736860513687133, 0.07583868503570556, 0.3317205309867859, 1.2638635635375976, 0.09232141077518463, 0.39160382747650146, 1.2545535564422607, 0.10898756980895996, 0.44950929284095764, 1.2452435493469238, 0.12510327994823456, 0.502799928188324, 1.2354207038879394, 0.13993465900421142, 0.5488386750221252, 1.2245732545852661, 0.1527477353811264, 0.5849883556365967, 1.2121883630752563, 0.1628085970878601, 0.6086119413375854, 1.1977535486221313, 0.16938331723213196, 0.6170726418495178, 1.1807562112808227, 0.17173802852630615, 0.11966176331043243, 1.3113535642623901, 0.05091294273734093, 0.15926885604858398, 1.296918511390686, 0.06776473671197891, 0.2070705145597458, 1.2845337390899658, 0.08810312300920486, 0.2605453133583069, 1.273686170578003, 0.11085526645183563, 0.31717196106910705, 1.2638635635375976, 0.13494843244552612, 0.3744288980960846, 1.2545535564422607, 0.15930978953838348, 0.4297947883605957, 1.2452435493469238, 0.18286655843257904, 0.48074817657470703, 1.235420823097229, 0.20454590022563934, 0.5247677564620972, 1.2245732545852661, 0.2232751101255417, 0.5593319535255432, 1.2121883630752563, 0.23798131942749023, 0.5819195508956909, 1.1977535486221313, 0.2475917488336563, 0.5900091528892517, 1.1807563304901123, 0.25103363394737243, 0.1122271865606308, 1.311353325843811, 0.06591420620679855, 0.14937345683574676, 1.296918272972107, 0.08773128688335419, 0.19420522451400757, 1.2845335006713867, 0.11406226456165314, 0.244357630610466, 1.2736860513687133, 0.14351822435855865, 0.2974660396575928, 1.2638635635375976, 0.17471031844615936, 0.35116562247276306, 1.2545535564422607, 0.20624960958957672, 0.40309157967567444, 1.2452435493469238, 0.23674724996089935, 0.4508792459964752, 1.2354207038879394, 0.2648143172264099, 0.49216383695602417, 1.2245732545852661, 0.28906193375587463, 0.5245806574821472, 1.2121883630752563, 0.3081012964248657, 0.5457648038864136, 1.1977535486221313, 0.3205433785915375, 0.5533518195152283, 1.1807562112808227, 0.3249994218349457, 0.10299103707075119, 1.3113535642623901, 0.07969038188457489, 0.13708022236824036, 1.296918511390686, 0.10606727749109268, 0.17822235822677612, 1.2845337390899658, 0.13790147006511688, 0.22424733638763428, 1.273686170578003, 0.1735137701034546, 0.27298498153686523, 1.2638635635375976, 0.21122509241104126, 0.3222651183605194, 1.2545535564422607, 0.24935616552829742, 0.3699176609516144, 1.2452435493469238, 0.28622785210609436, 0.41377243399620056, 1.235420823097229, 0.32016098499298095, 0.4516593813896179, 1.2245732545852661, 0.3494764268398285, 0.48140835762023926, 1.212188482284546, 0.37249496579170227, 0.5008491277694702, 1.1977537870407104, 0.38753753900527954, 0.5078116655349731, 1.1807564496994018, 0.39292487502098083, 0.09209741652011871, 1.3113535642623901, 0.09209735691547394, 0.12258090823888778, 1.296918511390686, 0.12258084863424301, 0.15937136113643646, 1.2845336198806762, 0.1593713015317917, 0.2005281299352646, 1.2736860513687133, 0.2005280703306198, 0.24411068856716156, 1.2638635635375976, 0.24411062896251678, 0.28817832469940185, 1.2545534372329712, 0.2881782650947571, 0.33079054951667785, 1.2452435493469238, 0.3307904899120331, 0.3700067102909088, 1.235420823097229, 0.37000665068626404, 0.4038863182067871, 1.2245732545852661, 0.40388625860214233, 0.43048855662345886, 1.2121882438659668, 0.4304884970188141, 0.44787314534187317, 1.1977535486221313, 0.4478730857372284, 0.454099178314209, 1.1807563304901123, 0.4540991187095642, 0.07969044148921966, 1.3113534450531005, 0.10299097746610641, 0.10606733709573746, 1.2969183921813964, 0.13708016276359558, 0.13790152966976166, 1.2845335006713867, 0.17822231352329254, 0.17351384460926056, 1.2736860513687133, 0.2242472767829895, 0.21122515201568603, 1.2638635635375976, 0.27298495173454284, 0.2493561953306198, 1.2545535564422607, 0.32226505875587463, 0.28622791171073913, 1.2452435493469238, 0.3699176013469696, 0.32016101479530334, 1.235420823097229, 0.4137723743915558, 0.3494764268398285, 1.2245732545852661, 0.45165932178497314, 0.3724950850009918, 1.2121883630752563, 0.4814082980155945, 0.3875375986099243, 1.1977535486221313, 0.5008490681648254, 0.3929249048233032, 1.1807563304901123, 0.5078116059303284, 0.06591427326202392, 1.3113535642623901, 0.11222713440656662, 0.08773135393857956, 1.296918272972107, 0.14937341213226318, 0.1140623465180397, 1.2845336198806762, 0.194205179810524, 0.14351831376552582, 1.2736858129501342, 0.2443576157093048, 0.17471040785312652, 1.2638635635375976, 0.2974660098552704, 0.20624969899654388, 1.2545534372329712, 0.35116562247276306, 0.23674732446670532, 1.2452435493469238, 0.40309157967567444, 0.26481443643569946, 1.235420823097229, 0.45087930560112, 0.2890620827674866, 1.2245732545852661, 0.49216389656066894, 0.3081013858318329, 1.2121882438659668, 0.524580717086792, 0.320543497800827, 1.1977535486221313, 0.5457649827003479, 0.32499951124191284, 1.1807563304901123, 0.553351879119873, 0.0509130135178566, 1.3113534450531005, 0.11966168880462646, 0.06776481121778488, 1.2969183921813964, 0.1592687964439392, 0.08810319751501083, 1.2845335006713867, 0.207070454955101, 0.11085537075996399, 1.2736860513687133, 0.2605452537536621, 0.1349485218524933, 1.2638635635375976, 0.3171719014644623, 0.15930989384651184, 1.2545535564422607, 0.3744288384914398, 0.182866632938385, 1.2452435493469238, 0.42979469895362854, 0.2045460045337677, 1.235420823097229, 0.48074811697006225, 0.22327518463134766, 1.2245732545852661, 0.5247676968574524, 0.2379814088344574, 1.2121883630752563, 0.5593318939208984, 0.24759189784526825, 1.1977535486221313, 0.5819194912910461, 0.251033753156662, 1.1807563304901123, 0.5900090932846069, 0.03483080118894577, 1.3113534450531005, 0.12515054643154144, 0.04635951668024063, 1.2969183921813964, 0.1665743887424469, 0.060273490846157074, 1.2845337390899658, 0.216568723320961, 0.07583879679441452, 1.2736860513687133, 0.27249640226364135, 0.0923214927315712, 1.2638636827468872, 0.3317204713821411, 0.10898768156766891, 1.2545535564422607, 0.3916037678718567, 0.1251034140586853, 1.2452435493469238, 0.44950923323631286, 0.13993477821350098, 1.235421061515808, 0.5027998685836792, 0.15274788439273834, 1.2245734930038452, 0.5488386154174805, 0.16280873119831085, 1.212188482284546, 0.5849882960319519, 0.1693834811449051, 1.197753667831421, 0.6086118817329407, 0.1717381477355957, 1.1807563304901123, 0.617072582244873, 0.017811765894293785, 1.3113535642623901, 0.12854957580566406, 0.02370731718838215, 1.296918511390686, 0.17109845578670502, 0.030822638422250747, 1.2845337390899658, 0.2224505990743637, 0.03878242149949074, 1.273686170578003, 0.2798972427845001, 0.047211337834596634, 1.2638635635375976, 0.34072986245155334, 0.05573408678174019, 1.2545535564422607, 0.40223950147628784, 0.06397534906864166, 1.2452435493469238, 0.4617176651954651, 0.07155980914831161, 1.2354207038879394, 0.5164555907249451, 0.0781121626496315, 1.2245732545852661, 0.5637447834014893, 0.08325708657503128, 1.2121883630752563, 0.6008762717247009, 0.08661927282810211, 1.1977535486221313, 0.6251415610313415, 0.08782341331243515, 1.1807562112808227, 0.6338319182395935, 2.597815829119554e-8, 1.3113536834716796, 0.12971457839012146, 3.457671837736598e-8, 1.2969187498092651, 0.172649085521698, 4.4954298061838926e-8, 1.2845337390899658, 0.22446659207344055, 5.656350765548268e-8, 1.273686170578003, 0.28243395686149597, 6.885694148195398e-8, 1.2638638019561767, 0.343817800283432, 8.128723294476003e-8, 1.2545535564422607, 0.4058849513530731, 9.33069728148439e-8, 1.2452435493469238, 0.46590209007263183, 1.0436878028485807e-7, 1.235421061515808, 0.5211362242698669, 1.1392528875830976e-7, 1.2245734930038452, 0.5688538551330566, 1.2142908190071466e-7, 1.212188482284546, 0.6063219308853149, 1.2633276469387056e-7, 1.1977537870407104, 0.6308071613311768, 1.2808898475213937e-7, 1.1807564496994018, 0.6395763158798218, -0.017811741679906845, 1.3113536834716796, 0.12854957580566406, -0.02370728924870491, 1.2969187498092651, 0.1710984706878662, -0.03082260489463806, 1.2845337390899658, 0.2224505990743637, -0.03878236934542656, 1.273686170578003, 0.27989721298217773, -0.04721128195524216, 1.2638638019561767, 0.34072980284690857, -0.055734019726514816, 1.2545535564422607, 0.40223944187164306, -0.0639752745628357, 1.2452435493469238, 0.4617176055908203, -0.07155971974134445, 1.235421061515808, 0.5164555907249451, -0.07811206579208374, 1.2245734930038452, 0.5637447237968445, -0.08325699716806412, 1.212188482284546, 0.6008762717247009, -0.08661917597055435, 1.197753667831421, 0.625141441822052, -0.0878233090043068, 1.1807563304901123, 0.6338318586349487, -0.034830786287784576, 1.3113534450531005, 0.12515054643154144, -0.04635949432849884, 1.2969183921813964, 0.1665743887424469, -0.06027345731854439, 1.2845335006713867, 0.216568723320961, -0.07583873718976974, 1.2736860513687133, 0.27249640226364135, -0.09232146292924881, 1.2638635635375976, 0.3317204713821411, -0.10898762196302414, 1.2545535564422607, 0.3916037678718567, -0.12510333955287933, 1.2452435493469238, 0.44950923323631286, -0.1399347186088562, 1.2354207038879394, 0.5027998685836792, -0.15274779498577118, 1.2245732545852661, 0.5488386154174805, -0.16280865669250488, 1.2121883630752563, 0.5849882960319519, -0.16938337683677673, 1.1977535486221313, 0.6086118817329407, -0.17173807322978973, 1.1807562112808227, 0.617072582244873, -0.050912998616695404, 1.3113535642623901, 0.11966170370578766, -0.06776479631662369, 1.296918511390686, 0.1592687964439392, -0.08810318261384964, 1.2845337390899658, 0.207070454955101, -0.11085531860589981, 1.273686170578003, 0.2605452537536621, -0.1349484920501709, 1.2638635635375976, 0.3171719014644623, -0.15930984914302826, 1.2545535564422607, 0.3744288384914398, -0.18286661803722381, 1.2452435493469238, 0.4297947287559509, -0.20454595983028412, 1.235420823097229, 0.48074811697006225, -0.22327516973018646, 1.2245732545852661, 0.5247676968574524, -0.237981379032135, 1.2121883630752563, 0.5593318939208984, -0.2475918084383011, 1.1977535486221313, 0.5819194912910461, -0.2510336935520172, 1.1807563304901123, 0.5900090932846069, -0.06591426581144333, 1.311353325843811, 0.11222712695598602, -0.08773134648799896, 1.296918272972107, 0.149373397231102, -0.11406232416629791, 1.2845335006713867, 0.1942051649093628, -0.14351828396320343, 1.2736860513687133, 0.24435757100582123, -0.17471037805080414, 1.2638635635375976, 0.297465980052948, -0.2062496691942215, 1.2545535564422607, 0.3511655628681183, -0.23674730956554413, 1.2452435493469238, 0.40309152007102966, -0.2648143768310547, 1.2354207038879394, 0.45087918639183044, -0.2890619933605194, 1.2245732545852661, 0.4921637773513794, -0.3081013560295105, 1.2121883630752563, 0.5245805978775024, -0.32054343819618225, 1.1977535486221313, 0.5457647442817688, -0.32499948143959045, 1.1807562112808227, 0.5533517599105835, -0.07969044148921966, 1.3113535642623901, 0.10299097746610641, -0.10606733709573746, 1.296918511390686, 0.13708016276359558, -0.13790152966976166, 1.2845337390899658, 0.17822229862213135, -0.17351382970809936, 1.273686170578003, 0.2242472767829895, -0.21122515201568603, 1.2638635635375976, 0.27298492193222046, -0.2493562251329422, 1.2545535564422607, 0.32226505875587463, -0.28622791171073913, 1.2452435493469238, 0.3699176013469696, -0.32016104459762573, 1.235420823097229, 0.4137723743915558, -0.34947648644447326, 1.2245732545852661, 0.45165932178497314, -0.37249502539634704, 1.212188482284546, 0.4814082980155945, -0.3875375986099243, 1.1977537870407104, 0.5008490681648254, -0.3929249346256256, 1.1807564496994018, 0.5078116059303284, -0.09209741652011871, 1.3113535642623901, 0.09209735691547394, -0.12258090823888778, 1.296918511390686, 0.12258084863424301, -0.15937136113643646, 1.2845336198806762, 0.1593713015317917, -0.2005281299352646, 1.2736860513687133, 0.2005280703306198, -0.24411068856716156, 1.2638635635375976, 0.24411062896251678, -0.28817832469940185, 1.2545534372329712, 0.2881782650947571, -0.33079054951667785, 1.2452435493469238, 0.3307904899120331, -0.3700067102909088, 1.235420823097229, 0.37000665068626404, -0.4038863182067871, 1.2245732545852661, 0.40388625860214233, -0.43048855662345886, 1.2121882438659668, 0.4304884970188141, -0.44787314534187317, 1.1977535486221313, 0.4478730857372284, -0.454099178314209, 1.1807563304901123, 0.4540991187095642, -0.10299103707075119, 1.3113534450531005, 0.07969038188457489, -0.13708022236824036, 1.2969183921813964, 0.10606727749109268, -0.17822237312793732, 1.2845335006713867, 0.13790147006511688, -0.22424733638763428, 1.2736860513687133, 0.17351378500461578, -0.2729850113391876, 1.2638635635375976, 0.21122509241104126, -0.3222651183605194, 1.2545535564422607, 0.24935613572597504, -0.3699176609516144, 1.2452435493469238, 0.28622785210609436, -0.41377243399620056, 1.235420823097229, 0.32016095519065857, -0.4516593813896179, 1.2245732545852661, 0.3494763672351837, -0.48140835762023926, 1.2121883630752563, 0.37249502539634704, -0.5008491277694702, 1.1977535486221313, 0.38753753900527954, -0.5078116655349731, 1.1807563304901123, 0.39292484521865844, -0.1122271940112114, 1.3113535642623901, 0.06591421365737915, -0.14937347173690796, 1.296918272972107, 0.08773129433393478, -0.19420523941516876, 1.2845336198806762, 0.11406228691339493, -0.24435767531394958, 1.2736858129501342, 0.14351825416088104, -0.29746606945991516, 1.2638635635375976, 0.17471034824848175, -0.35116568207740783, 1.2545534372329712, 0.2062496393918991, -0.4030916392803192, 1.2452435493469238, 0.23674726486206055, -0.45087936520576477, 1.235420823097229, 0.2648143768310547, -0.4921639561653137, 1.2245732545852661, 0.2890620231628418, -0.5245807766914368, 1.2121882438659668, 0.3081013262271881, -0.5457650423049927, 1.1977535486221313, 0.32054343819618225, -0.5533519387245178, 1.1807563304901123, 0.32499945163726806, -0.11966174840927124, 1.3113534450531005, 0.05091295763850212, -0.15926885604858398, 1.2969183921813964, 0.0677647516131401, -0.2070705145597458, 1.2845335006713867, 0.08810313791036606, -0.2605453133583069, 1.2736860513687133, 0.11085531860589981, -0.31717196106910705, 1.2638635635375976, 0.1349484622478485, -0.3744288980960846, 1.2545535564422607, 0.15930983424186706, -0.4297947585582733, 1.2452435493469238, 0.18286657333374023, -0.48074817657470703, 1.235420823097229, 0.20454594492912292, -0.5247677564620972, 1.2245732545852661, 0.22327512502670288, -0.5593319535255432, 1.2121883630752563, 0.23798134922981262, -0.5819195508956909, 1.1977535486221313, 0.24759183824062347, -0.5900091528892517, 1.1807563304901123, 0.2510336935520172, -0.12515060603618622, 1.3113534450531005, 0.03483074530959129, -0.16657444834709167, 1.2969183921813964, 0.046359460800886154, -0.21656878292560577, 1.2845337390899658, 0.0602734349668026, -0.27249646186828613, 1.2736860513687133, 0.07583874464035034, -0.3317205309867859, 1.2638636827468872, 0.09232144057750702, -0.39160382747650146, 1.2545535564422607, 0.10898762941360473, -0.44950929284095764, 1.2452435493469238, 0.12510335445404053, -0.502799928188324, 1.235421061515808, 0.1399347186088562, -0.5488386750221252, 1.2245734930038452, 0.15274782478809357, -0.5849883556365967, 1.212188482284546, 0.16280867159366608, -0.6086119413375854, 1.197753667831421, 0.16938342154026031, -0.6170726418495178, 1.1807563304901123, 0.17173810303211212, -0.12854963541030884, 1.3113535642623901, 0.01781170815229416, -0.1710985153913498, 1.296918511390686, 0.023707261309027672, -0.22245065867900848, 1.2845337390899658, 0.03082258254289627, -0.2798973023891449, 1.273686170578003, 0.03878236562013626, -0.3407299220561981, 1.2638635635375976, 0.04721128195524216, -0.4022395610809326, 1.2545535564422607, 0.05573403090238571, -0.46171772480010986, 1.2452435493469238, 0.06397529691457748, -0.5164556503295898, 1.2354207038879394, 0.07155975699424743, -0.563744843006134, 1.2245732545852661, 0.07811211049556732, -0.6008763313293457, 1.2121883630752563, 0.0832570344209671, -0.6251416206359863, 1.1977535486221313, 0.08661922067403793, -0.6338319778442383, 1.1807562112808227, 0.08782336115837097, -0.12971463799476623, 1.3113536834716796, -3.134293535822508e-8, -0.17264914512634277, 1.2969187498092651, -2.2113400888201795e-8, -0.22446665167808533, 1.2845337390899658, -1.1194455140639547e-8, -0.28243401646614074, 1.273686170578003, 8.889173841453157e-10, -0.3438178598880768, 1.2638638019561767, 1.3611700211413335e-8, -0.4058850109577179, 1.2545535564422607, 2.6448955026125986e-8, -0.4659021496772766, 1.2452435493469238, 3.8875647589975415e-8, -0.5211362838745117, 1.235421061515808, 5.0366807613499986e-8, -0.5688539147377014, 1.2245734930038452, 6.039748257080646e-8, -0.6063219904899597, 1.212188482284546, 6.844263111815962e-8, -0.6308072209358215, 1.1977537870407104, 7.397728296609784e-8, -0.6395763754844665, 1.1807564496994018, 7.64764820360142e-8, -0.12854963541030884, 1.3113536834716796, -0.01781179942190647, -0.171098530292511, 1.2969187498092651, -0.023707345128059387, -0.22245065867900848, 1.2845337390899658, -0.03082266077399254, -0.2798972725868225, 1.273686170578003, -0.038782425224781036, -0.34072986245155334, 1.2638638019561767, -0.047211337834596634, -0.40223950147628784, 1.2545535564422607, -0.05573407560586929, -0.4617176651954651, 1.2452435493469238, -0.06397532671689987, -0.5164556503295898, 1.235421061515808, -0.07155977189540863, -0.5637447834014893, 1.2245734930038452, -0.07811211794614792, -0.6008763313293457, 1.212188482284546, -0.0832570493221283, -0.6251415014266968, 1.197753667831421, -0.08661922812461853, -0.6338319182395935, 1.1807563304901123, -0.08782336115837097, -0.12515060603618622, 1.3113534450531005, -0.03483084216713905, -0.16657444834709167, 1.2969183921813964, -0.04635955020785332, -0.21656878292560577, 1.2845335006713867, -0.060273513197898865, -0.27249646186828613, 1.2736860513687133, -0.07583878934383392, -0.3317205309867859, 1.2638635635375976, -0.09232151508331299, -0.39160382747650146, 1.2545535564422607, -0.10898767411708832, -0.44950929284095764, 1.2452435493469238, -0.1251033991575241, -0.502799928188324, 1.2354207038879394, -0.13993477821350098, -0.5488386750221252, 1.2245732545852661, -0.15274785459041595, -0.5849883556365967, 1.2121883630752563, -0.16280871629714966, -0.6086119413375854, 1.1977535486221313, -0.1693834364414215, -0.6170726418495178, 1.1807562112808227, -0.17173811793327331, -0.11966176331043243, 1.3113535642623901, -0.05091305449604988, -0.15926885604858398, 1.296918511390686, -0.06776485592126846, -0.2070705145597458, 1.2845337390899658, -0.08810324221849441, -0.2605453133583069, 1.273686170578003, -0.11085537075996399, -0.31717196106910705, 1.2638635635375976, -0.13494855165481567, -0.3744288980960846, 1.2545535564422607, -0.15930990874767303, -0.4297947883605957, 1.2452435493469238, -0.1828666776418686, -0.48074817657470703, 1.235420823097229, -0.2045460194349289, -0.5247677564620972, 1.2245732545852661, -0.22327522933483124, -0.5593319535255432, 1.2121883630752563, -0.23798143863677978, -0.5819195508956909, 1.1977535486221313, -0.24759186804294586, -0.5900091528892517, 1.1807563304901123, -0.251033753156662, -0.1122271865606308, 1.311353325843811, -0.0659143254160881, -0.14937345683574676, 1.296918272972107, -0.08773140609264374, -0.19420522451400757, 1.2845335006713867, -0.11406238377094269, -0.244357630610466, 1.2736860513687133, -0.1435183435678482, -0.2974660396575928, 1.2638635635375976, -0.1747104376554489, -0.35116562247276306, 1.2545535564422607, -0.20624972879886627, -0.40309157967567444, 1.2452435493469238, -0.2367473691701889, -0.4508792459964752, 1.2354207038879394, -0.26481443643569946, -0.49216383695602417, 1.2245732545852661, -0.2890620529651642, -0.5245806574821472, 1.2121883630752563, -0.3081014156341553, -0.5457648038864136, 1.1977535486221313, -0.320543497800827, -0.5533518195152283, 1.1807562112808227, -0.32499954104423523, -0.10299103707075119, 1.3113535642623901, -0.07969050109386444, -0.13708022236824036, 1.296918511390686, -0.10606739670038223, -0.17822235822677612, 1.2845337390899658, -0.13790158927440643, -0.22424733638763428, 1.273686170578003, -0.17351388931274414, -0.27298498153686523, 1.2638635635375976, -0.2112252116203308, -0.3222651183605194, 1.2545535564422607, -0.24935628473758697, -0.3699176609516144, 1.2452435493469238, -0.2862279713153839, -0.41377243399620056, 1.235420823097229, -0.3201611042022705, -0.4516593813896179, 1.2245732545852661, -0.34947654604911804, -0.48140835762023926, 1.212188482284546, -0.3724950850009918, -0.5008491277694702, 1.1977537870407104, -0.3875376582145691, -0.5078116655349731, 1.1807564496994018, -0.3929249942302704, -0.09209741652011871, 1.3113535642623901, -0.09209747612476349, -0.12258090823888778, 1.296918511390686, -0.12258096784353256, -0.15937136113643646, 1.2845336198806762, -0.15937142074108124, -0.2005281299352646, 1.2736860513687133, -0.20052818953990936, -0.24411068856716156, 1.2638635635375976, -0.24411074817180633, -0.28817832469940185, 1.2545534372329712, -0.28817838430404663, -0.33079054951667785, 1.2452435493469238, -0.33079060912132263, -0.3700067102909088, 1.235420823097229, -0.3700067698955536, -0.4038863182067871, 1.2245732545852661, -0.4038863778114319, -0.43048855662345886, 1.2121882438659668, -0.43048861622810363, -0.44787314534187317, 1.1977535486221313, -0.44787320494651794, -0.454099178314209, 1.1807563304901123, -0.45409923791885376, -0.07969044148921966, 1.3113534450531005, -0.10299109667539596, -0.10606733709573746, 1.2969183921813964, -0.13708028197288513, -0.13790152966976166, 1.2845335006713867, -0.1782224327325821, -0.17351384460926056, 1.2736860513687133, -0.22424739599227905, -0.21122515201568603, 1.2638635635375976, -0.2729850709438324, -0.2493561953306198, 1.2545535564422607, -0.3222651779651642, -0.28622791171073913, 1.2452435493469238, -0.36991772055625915, -0.32016101479530334, 1.235420823097229, -0.41377249360084533, -0.3494764268398285, 1.2245732545852661, -0.4516594409942627, -0.3724950850009918, 1.2121883630752563, -0.48140841722488403, -0.3875375986099243, 1.1977535486221313, -0.500849187374115, -0.3929249048233032, 1.1807563304901123, -0.5078117251396179, -0.06591427326202392, 1.3113535642623901, -0.11222725361585617, -0.08773135393857956, 1.296918272972107, -0.14937353134155273, -0.1140623465180397, 1.2845336198806762, -0.19420529901981354, -0.14351831376552582, 1.2736858129501342, -0.24435773491859436, -0.17471040785312652, 1.2638635635375976, -0.29746612906455993, -0.20624969899654388, 1.2545534372329712, -0.3511657416820526, -0.23674732446670532, 1.2452435493469238, -0.403091698884964, -0.26481443643569946, 1.235420823097229, -0.45087942481040954, -0.2890620827674866, 1.2245732545852661, -0.4921640157699585, -0.3081013858318329, 1.2121882438659668, -0.5245808362960815, -0.320543497800827, 1.1977535486221313, -0.5457651019096374, -0.32499951124191284, 1.1807563304901123, -0.5533519983291626, -0.0509130135178566, 1.3113534450531005, -0.11966180801391601, -0.06776481121778488, 1.2969183921813964, -0.15926891565322876, -0.08810319751501083, 1.2845335006713867, -0.20707057416439056, -0.11085537075996399, 1.2736860513687133, -0.26054537296295166, -0.1349485218524933, 1.2638635635375976, -0.31717202067375183, -0.15930989384651184, 1.2545535564422607, -0.37442895770072937, -0.182866632938385, 1.2452435493469238, -0.4297948181629181, -0.2045460045337677, 1.235420823097229, -0.4807482361793518, -0.22327518463134766, 1.2245732545852661, -0.5247678160667419, -0.2379814088344574, 1.2121883630752563, -0.559332013130188, -0.24759189784526825, 1.1977535486221313, -0.5819196105003357, -0.251033753156662, 1.1807563304901123, -0.5900092124938965, -0.03483080118894577, 1.3113534450531005, -0.125150665640831, -0.04635951668024063, 1.2969183921813964, -0.16657450795173645, -0.060273490846157074, 1.2845337390899658, -0.21656884253025055, -0.07583879679441452, 1.2736860513687133, -0.2724965214729309, -0.0923214927315712, 1.2638636827468872, -0.33172059059143066, -0.10898768156766891, 1.2545535564422607, -0.39160388708114624, -0.1251034140586853, 1.2452435493469238, -0.4495093524456024, -0.13993477821350098, 1.235421061515808, -0.5027999877929687, -0.15274788439273834, 1.2245734930038452, -0.54883873462677, -0.16280873119831085, 1.212188482284546, -0.5849884152412414, -0.1693834811449051, 1.197753667831421, -0.6086120009422302, -0.1717381477355957, 1.1807563304901123, -0.6170727014541626, -0.017811765894293785, 1.3113535642623901, -0.1285496950149536, -0.02370731718838215, 1.296918511390686, -0.17109857499599457, -0.030822638422250747, 1.2845337390899658, -0.22245071828365326, -0.03878242149949074, 1.273686170578003, -0.2798973619937897, -0.047211337834596634, 1.2638635635375976, -0.3407299816608429, -0.05573408678174019, 1.2545535564422607, -0.4022396206855774, -0.06397534906864166, 1.2452435493469238, -0.46171778440475464, -0.07155980914831161, 1.2354207038879394, -0.5164557099342346, -0.0781121626496315, 1.2245732545852661, -0.5637449026107788, -0.08325708657503128, 1.2121883630752563, -0.6008763909339905, -0.08661927282810211, 1.1977535486221313, -0.6251416802406311, -0.08782341331243515, 1.1807562112808227, -0.6338320374488831, -2.597815829119554e-8, 1.3113536834716796, -0.129714697599411, -3.457671837736598e-8, 1.2969187498092651, -0.17264920473098755, -4.4954298061838926e-8, 1.2845337390899658, -0.2244667112827301, -5.656350765548268e-8, 1.273686170578003, -0.2824340760707855, -6.885694148195398e-8, 1.2638638019561767, -0.34381791949272155, -8.128723294476003e-8, 1.2545535564422607, -0.40588507056236267, -9.33069728148439e-8, 1.2452435493469238, -0.4659022092819214, -1.0436878028485807e-7, 1.235421061515808, -0.5211363434791565, -1.1392528875830976e-7, 1.2245734930038452, -0.5688539743423462, -1.2142908190071466e-7, 1.212188482284546, -0.6063220500946045, -1.2633276469387056e-7, 1.1977537870407104, -0.6308072805404663, -1.2808898475213937e-7, 1.1807564496994018, -0.6395764350891113, 0.017811741679906845, 1.3113536834716796, -0.1285496950149536, 0.02370728924870491, 1.2969187498092651, -0.17109858989715576, 0.03082260489463806, 1.2845337390899658, -0.22245071828365326, 0.03878236934542656, 1.273686170578003, -0.2798973321914673, 0.04721128195524216, 1.2638638019561767, -0.3407299220561981, 0.055734019726514816, 1.2545535564422607, -0.4022395610809326, 0.0639752745628357, 1.2452435493469238, -0.46171772480010986, 0.07155971974134445, 1.235421061515808, -0.5164557099342346, 0.07811206579208374, 1.2245734930038452, -0.563744843006134, 0.08325699716806412, 1.212188482284546, -0.6008763909339905, 0.08661917597055435, 1.197753667831421, -0.6251415610313415, 0.0878233090043068, 1.1807563304901123, -0.6338319778442383, 0.034830786287784576, 1.3113534450531005, -0.125150665640831, 0.04635949432849884, 1.2969183921813964, -0.16657450795173645, 0.06027345731854439, 1.2845335006713867, -0.21656884253025055, 0.07583873718976974, 1.2736860513687133, -0.2724965214729309, 0.09232146292924881, 1.2638635635375976, -0.33172059059143066, 0.10898762196302414, 1.2545535564422607, -0.39160388708114624, 0.12510333955287933, 1.2452435493469238, -0.4495093524456024, 0.1399347186088562, 1.2354207038879394, -0.5027999877929687, 0.15274779498577118, 1.2245732545852661, -0.54883873462677, 0.16280865669250488, 1.2121883630752563, -0.5849884152412414, 0.16938337683677673, 1.1977535486221313, -0.6086120009422302, 0.17173807322978973, 1.1807562112808227, -0.6170727014541626, 0.050912998616695404, 1.3113535642623901, -0.11966182291507721, 0.06776479631662369, 1.296918511390686, -0.15926891565322876, 0.08810318261384964, 1.2845337390899658, -0.20707057416439056, 0.11085531860589981, 1.273686170578003, -0.26054537296295166, 0.1349484920501709, 1.2638635635375976, -0.31717202067375183, 0.15930984914302826, 1.2545535564422607, -0.37442895770072937, 0.18286661803722381, 1.2452435493469238, -0.4297948479652405, 0.20454595983028412, 1.235420823097229, -0.4807482361793518, 0.22327516973018646, 1.2245732545852661, -0.5247678160667419, 0.237981379032135, 1.2121883630752563, -0.559332013130188, 0.2475918084383011, 1.1977535486221313, -0.5819196105003357, 0.2510336935520172, 1.1807563304901123, -0.5900092124938965, 0.06591426581144333, 1.311353325843811, -0.11222724616527557, 0.08773134648799896, 1.296918272972107, -0.14937351644039154, 0.11406232416629791, 1.2845335006713867, -0.19420528411865234, 0.14351828396320343, 1.2736860513687133, -0.24435769021511078, 0.17471037805080414, 1.2638635635375976, -0.29746609926223755, 0.2062496691942215, 1.2545535564422607, -0.35116568207740783, 0.23674730956554413, 1.2452435493469238, -0.4030916392803192, 0.2648143768310547, 1.2354207038879394, -0.45087930560112, 0.2890619933605194, 1.2245732545852661, -0.49216389656066894, 0.3081013560295105, 1.2121883630752563, -0.524580717086792, 0.32054343819618225, 1.1977535486221313, -0.5457648634910583, 0.32499948143959045, 1.1807562112808227, -0.553351879119873, 0.07969044148921966, 1.3113535642623901, -0.10299109667539596, 0.10606733709573746, 1.296918511390686, -0.13708028197288513, 0.13790152966976166, 1.2845337390899658, -0.1782224178314209, 0.17351382970809936, 1.273686170578003, -0.22424739599227905, 0.21122515201568603, 1.2638635635375976, -0.27298504114151, 0.2493562251329422, 1.2545535564422607, -0.3222651779651642, 0.28622791171073913, 1.2452435493469238, -0.36991772055625915, 0.32016104459762573, 1.235420823097229, -0.41377249360084533, 0.34947648644447326, 1.2245732545852661, -0.4516594409942627, 0.37249502539634704, 1.212188482284546, -0.48140841722488403, 0.3875375986099243, 1.1977537870407104, -0.500849187374115, 0.3929249346256256, 1.1807564496994018, -0.5078117251396179, 0.09209741652011871, 1.3113535642623901, -0.09209747612476349, 0.12258090823888778, 1.296918511390686, -0.12258096784353256, 0.15937136113643646, 1.2845336198806762, -0.15937142074108124, 0.2005281299352646, 1.2736860513687133, -0.20052818953990936, 0.24411068856716156, 1.2638635635375976, -0.24411074817180633, 0.28817832469940185, 1.2545534372329712, -0.28817838430404663, 0.33079054951667785, 1.2452435493469238, -0.33079060912132263, 0.3700067102909088, 1.235420823097229, -0.3700067698955536, 0.4038863182067871, 1.2245732545852661, -0.4038863778114319, 0.43048855662345886, 1.2121882438659668, -0.43048861622810363, 0.44787314534187317, 1.1977535486221313, -0.44787320494651794, 0.454099178314209, 1.1807563304901123, -0.45409923791885376, 0.10299103707075119, 1.3113534450531005, -0.07969050109386444, 0.13708022236824036, 1.2969183921813964, -0.10606739670038223, 0.17822237312793732, 1.2845335006713867, -0.13790158927440643, 0.22424733638763428, 1.2736860513687133, -0.17351390421390533, 0.2729850113391876, 1.2638635635375976, -0.2112252116203308, 0.3222651183605194, 1.2545535564422607, -0.2493562549352646, 0.3699176609516144, 1.2452435493469238, -0.2862279713153839, 0.41377243399620056, 1.235420823097229, -0.3201610743999481, 0.4516593813896179, 1.2245732545852661, -0.34947648644447326, 0.48140835762023926, 1.2121883630752563, -0.3724951446056366, 0.5008491277694702, 1.1977535486221313, -0.3875376582145691, 0.5078116655349731, 1.1807563304901123, -0.392924964427948, 0.1122271940112114, 1.3113535642623901, -0.0659143328666687, 0.14937347173690796, 1.296918272972107, -0.08773141354322433, 0.19420523941516876, 1.2845336198806762, -0.11406240612268448, 0.24435767531394958, 1.2736858129501342, -0.1435183733701706, 0.29746606945991516, 1.2638635635375976, -0.1747104674577713, 0.35116568207740783, 1.2545534372329712, -0.20624975860118866, 0.4030916392803192, 1.2452435493469238, -0.2367473840713501, 0.45087936520576477, 1.235420823097229, -0.26481449604034424, 0.4921639561653137, 1.2245732545852661, -0.28906214237213134, 0.5245807766914368, 1.2121882438659668, -0.30810144543647766, 0.5457650423049927, 1.1977535486221313, -0.3205435574054718, 0.5533519387245178, 1.1807563304901123, -0.3249995708465576, 0.11966174840927124, 1.3113534450531005, -0.050913069397211075, 0.15926885604858398, 1.2969183921813964, -0.06776487082242966, 0.2070705145597458, 1.2845335006713867, -0.08810325711965561, 0.2605453133583069, 1.2736860513687133, -0.11085542291402817, 0.31717196106910705, 1.2638635635375976, -0.13494858145713806, 0.3744288980960846, 1.2545535564422607, -0.15930995345115662, 0.4297947585582733, 1.2452435493469238, -0.18286669254302978, 0.48074817657470703, 1.235420823097229, -0.20454606413841247, 0.5247677564620972, 1.2245732545852661, -0.22327524423599243, 0.5593319535255432, 1.2121883630752563, -0.23798146843910217, 0.5819195508956909, 1.1977535486221313, -0.24759195744991302, 0.5900091528892517, 1.1807563304901123, -0.25103381276130676, 0.12515060603618622, 1.3113534450531005, -0.03483085706830025, 0.16657444834709167, 1.2969183921813964, -0.04635957255959511, 0.21656878292560577, 1.2845337390899658, -0.06027354672551155, 0.27249646186828613, 1.2736860513687133, -0.0758388489484787, 0.3317205309867859, 1.2638636827468872, -0.09232154488563537, 0.39160382747650146, 1.2545535564422607, -0.1089877337217331, 0.44950929284095764, 1.2452435493469238, -0.12510347366333008, 0.502799928188324, 1.235421061515808, -0.13993483781814575, 0.5488386750221252, 1.2245734930038452, -0.15274794399738312, 0.5849883556365967, 1.212188482284546, -0.16280879080295563, 0.6086119413375854, 1.197753667831421, -0.16938354074954986, 0.6170726418495178, 1.1807563304901123, -0.17173819243907928, 0.12854963541030884, 1.3113535642623901, -0.01781182363629341, 0.1710985153913498, 1.296918511390686, -0.023707373067736625, 0.22245065867900848, 1.2845337390899658, -0.030822694301605224, 0.2798973023891449, 1.273686170578003, -0.038782477378845215, 0.3407299220561981, 1.2638635635375976, -0.04721139371395111, 0.4022395610809326, 1.2545535564422607, -0.055734142661094665, 0.46171772480010986, 1.2452435493469238, -0.06397540122270584, 0.5164556503295898, 1.2354207038879394, -0.0715598613023758, 0.563744843006134, 1.2245732545852661, -0.07811221480369568, 0.6008763313293457, 1.2121883630752563, -0.08325713872909546, 0.6251416206359863, 1.1977535486221313, -0.08661932498216629, 0.6338319778442383, 1.1807562112808227, -0.08782346546649933];

var pointCounts = [3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3];

var pointIndices = [0, 13, 14, 14, 1, 0, 1, 14, 15, 15, 2, 1, 2, 15, 16, 16, 3, 2, 3, 16, 17, 17, 4, 3, 4, 17, 18, 18, 5, 4, 5, 18, 19, 19, 6, 5, 6, 19, 20, 20, 7, 6, 7, 20, 21, 21, 8, 7, 8, 21, 22, 22, 9, 8, 9, 22, 23, 23, 10, 9, 10, 23, 24, 24, 11, 10, 11, 24, 25, 25, 12, 11, 13, 26, 27, 27, 14, 13, 14, 27, 28, 28, 15, 14, 15, 28, 29, 29, 16, 15, 16, 29, 30, 30, 17, 16, 17, 30, 31, 31, 18, 17, 18, 31, 32, 32, 19, 18, 19, 32, 33, 33, 20, 19, 20, 33, 34, 34, 21, 20, 21, 34, 35, 35, 22, 21, 22, 35, 36, 36, 23, 22, 23, 36, 37, 37, 24, 23, 24, 37, 38, 38, 25, 24, 26, 39, 40, 40, 27, 26, 27, 40, 41, 41, 28, 27, 28, 41, 42, 42, 29, 28, 29, 42, 43, 43, 30, 29, 30, 43, 44, 44, 31, 30, 31, 44, 45, 45, 32, 31, 32, 45, 46, 46, 33, 32, 33, 46, 47, 47, 34, 33, 34, 47, 48, 48, 35, 34, 35, 48, 49, 49, 36, 35, 36, 49, 50, 50, 37, 36, 37, 50, 51, 51, 38, 37, 39, 52, 53, 53, 40, 39, 40, 53, 54, 54, 41, 40, 41, 54, 55, 55, 42, 41, 42, 55, 56, 56, 43, 42, 43, 56, 57, 57, 44, 43, 44, 57, 58, 58, 45, 44, 45, 58, 59, 59, 46, 45, 46, 59, 60, 60, 47, 46, 47, 60, 61, 61, 48, 47, 48, 61, 62, 62, 49, 48, 49, 62, 63, 63, 50, 49, 50, 63, 64, 64, 51, 50, 52, 65, 66, 66, 53, 52, 53, 66, 67, 67, 54, 53, 54, 67, 68, 68, 55, 54, 55, 68, 69, 69, 56, 55, 56, 69, 70, 70, 57, 56, 57, 70, 71, 71, 58, 57, 58, 71, 72, 72, 59, 58, 59, 72, 73, 73, 60, 59, 60, 73, 74, 74, 61, 60, 61, 74, 75, 75, 62, 61, 62, 75, 76, 76, 63, 62, 63, 76, 77, 77, 64, 63, 65, 78, 79, 79, 66, 65, 66, 79, 80, 80, 67, 66, 67, 80, 81, 81, 68, 67, 68, 81, 82, 82, 69, 68, 69, 82, 83, 83, 70, 69, 70, 83, 84, 84, 71, 70, 71, 84, 85, 85, 72, 71, 72, 85, 86, 86, 73, 72, 73, 86, 87, 87, 74, 73, 74, 87, 88, 88, 75, 74, 75, 88, 89, 89, 76, 75, 76, 89, 90, 90, 77, 76, 78, 91, 92, 92, 79, 78, 79, 92, 93, 93, 80, 79, 80, 93, 94, 94, 81, 80, 81, 94, 95, 95, 82, 81, 82, 95, 96, 96, 83, 82, 83, 96, 97, 97, 84, 83, 84, 97, 98, 98, 85, 84, 85, 98, 99, 99, 86, 85, 86, 99, 100, 100, 87, 86, 87, 100, 101, 101, 88, 87, 88, 101, 102, 102, 89, 88, 89, 102, 103, 103, 90, 89, 91, 104, 105, 105, 92, 91, 92, 105, 106, 106, 93, 92, 93, 106, 107, 107, 94, 93, 94, 107, 108, 108, 95, 94, 95, 108, 109, 109, 96, 95, 96, 109, 110, 110, 97, 96, 97, 110, 111, 111, 98, 97, 98, 111, 112, 112, 99, 98, 99, 112, 113, 113, 100, 99, 100, 113, 114, 114, 101, 100, 101, 114, 115, 115, 102, 101, 102, 115, 116, 116, 103, 102, 104, 117, 118, 118, 105, 104, 105, 118, 119, 119, 106, 105, 106, 119, 120, 120, 107, 106, 107, 120, 121, 121, 108, 107, 108, 121, 122, 122, 109, 108, 109, 122, 123, 123, 110, 109, 110, 123, 124, 124, 111, 110, 111, 124, 125, 125, 112, 111, 112, 125, 126, 126, 113, 112, 113, 126, 127, 127, 114, 113, 114, 127, 128, 128, 115, 114, 115, 128, 129, 129, 116, 115, 117, 130, 131, 131, 118, 117, 118, 131, 132, 132, 119, 118, 119, 132, 133, 133, 120, 119, 120, 133, 134, 134, 121, 120, 121, 134, 135, 135, 122, 121, 122, 135, 136, 136, 123, 122, 123, 136, 137, 137, 124, 123, 124, 137, 138, 138, 125, 124, 125, 138, 139, 139, 126, 125, 126, 139, 140, 140, 127, 126, 127, 140, 141, 141, 128, 127, 128, 141, 142, 142, 129, 128, 130, 143, 144, 144, 131, 130, 131, 144, 145, 145, 132, 131, 132, 145, 146, 146, 133, 132, 133, 146, 147, 147, 134, 133, 134, 147, 148, 148, 135, 134, 135, 148, 149, 149, 136, 135, 136, 149, 150, 150, 137, 136, 137, 150, 151, 151, 138, 137, 138, 151, 152, 152, 139, 138, 139, 152, 153, 153, 140, 139, 140, 153, 154, 154, 141, 140, 141, 154, 155, 155, 142, 141, 143, 156, 157, 157, 144, 143, 144, 157, 158, 158, 145, 144, 145, 158, 159, 159, 146, 145, 146, 159, 160, 160, 147, 146, 147, 160, 161, 161, 148, 147, 148, 161, 162, 162, 149, 148, 149, 162, 163, 163, 150, 149, 150, 163, 164, 164, 151, 150, 151, 164, 165, 165, 152, 151, 152, 165, 166, 166, 153, 152, 153, 166, 167, 167, 154, 153, 154, 167, 168, 168, 155, 154, 156, 169, 170, 170, 157, 156, 157, 170, 171, 171, 158, 157, 158, 171, 172, 172, 159, 158, 159, 172, 173, 173, 160, 159, 160, 173, 174, 174, 161, 160, 161, 174, 175, 175, 162, 161, 162, 175, 176, 176, 163, 162, 163, 176, 177, 177, 164, 163, 164, 177, 178, 178, 165, 164, 165, 178, 179, 179, 166, 165, 166, 179, 180, 180, 167, 166, 167, 180, 181, 181, 168, 167, 169, 182, 183, 183, 170, 169, 170, 183, 184, 184, 171, 170, 171, 184, 185, 185, 172, 171, 172, 185, 186, 186, 173, 172, 173, 186, 187, 187, 174, 173, 174, 187, 188, 188, 175, 174, 175, 188, 189, 189, 176, 175, 176, 189, 190, 190, 177, 176, 177, 190, 191, 191, 178, 177, 178, 191, 192, 192, 179, 178, 179, 192, 193, 193, 180, 179, 180, 193, 194, 194, 181, 180, 182, 195, 196, 196, 183, 182, 183, 196, 197, 197, 184, 183, 184, 197, 198, 198, 185, 184, 185, 198, 199, 199, 186, 185, 186, 199, 200, 200, 187, 186, 187, 200, 201, 201, 188, 187, 188, 201, 202, 202, 189, 188, 189, 202, 203, 203, 190, 189, 190, 203, 204, 204, 191, 190, 191, 204, 205, 205, 192, 191, 192, 205, 206, 206, 193, 192, 193, 206, 207, 207, 194, 193, 195, 208, 209, 209, 196, 195, 196, 209, 210, 210, 197, 196, 197, 210, 211, 211, 198, 197, 198, 211, 212, 212, 199, 198, 199, 212, 213, 213, 200, 199, 200, 213, 214, 214, 201, 200, 201, 214, 215, 215, 202, 201, 202, 215, 216, 216, 203, 202, 203, 216, 217, 217, 204, 203, 204, 217, 218, 218, 205, 204, 205, 218, 219, 219, 206, 205, 206, 219, 220, 220, 207, 206, 208, 221, 222, 222, 209, 208, 209, 222, 223, 223, 210, 209, 210, 223, 224, 224, 211, 210, 211, 224, 225, 225, 212, 211, 212, 225, 226, 226, 213, 212, 213, 226, 227, 227, 214, 213, 214, 227, 228, 228, 215, 214, 215, 228, 229, 229, 216, 215, 216, 229, 230, 230, 217, 216, 217, 230, 231, 231, 218, 217, 218, 231, 232, 232, 219, 218, 219, 232, 233, 233, 220, 219, 221, 234, 235, 235, 222, 221, 222, 235, 236, 236, 223, 222, 223, 236, 237, 237, 224, 223, 224, 237, 238, 238, 225, 224, 225, 238, 239, 239, 226, 225, 226, 239, 240, 240, 227, 226, 227, 240, 241, 241, 228, 227, 228, 241, 242, 242, 229, 228, 229, 242, 243, 243, 230, 229, 230, 243, 244, 244, 231, 230, 231, 244, 245, 245, 232, 231, 232, 245, 246, 246, 233, 232, 234, 247, 248, 248, 235, 234, 235, 248, 249, 249, 236, 235, 236, 249, 250, 250, 237, 236, 237, 250, 251, 251, 238, 237, 238, 251, 252, 252, 239, 238, 239, 252, 253, 253, 240, 239, 240, 253, 254, 254, 241, 240, 241, 254, 255, 255, 242, 241, 242, 255, 256, 256, 243, 242, 243, 256, 257, 257, 244, 243, 244, 257, 258, 258, 245, 244, 245, 258, 259, 259, 246, 245, 247, 260, 261, 261, 248, 247, 248, 261, 262, 262, 249, 248, 249, 262, 263, 263, 250, 249, 250, 263, 264, 264, 251, 250, 251, 264, 265, 265, 252, 251, 252, 265, 266, 266, 253, 252, 253, 266, 267, 267, 254, 253, 254, 267, 268, 268, 255, 254, 255, 268, 269, 269, 256, 255, 256, 269, 270, 270, 257, 256, 257, 270, 271, 271, 258, 257, 258, 271, 272, 272, 259, 258, 260, 273, 274, 274, 261, 260, 261, 274, 275, 275, 262, 261, 262, 275, 276, 276, 263, 262, 263, 276, 277, 277, 264, 263, 264, 277, 278, 278, 265, 264, 265, 278, 279, 279, 266, 265, 266, 279, 280, 280, 267, 266, 267, 280, 281, 281, 268, 267, 268, 281, 282, 282, 269, 268, 269, 282, 283, 283, 270, 269, 270, 283, 284, 284, 271, 270, 271, 284, 285, 285, 272, 271, 273, 286, 287, 287, 274, 273, 274, 287, 288, 288, 275, 274, 275, 288, 289, 289, 276, 275, 276, 289, 290, 290, 277, 276, 277, 290, 291, 291, 278, 277, 278, 291, 292, 292, 279, 278, 279, 292, 293, 293, 280, 279, 280, 293, 294, 294, 281, 280, 281, 294, 295, 295, 282, 281, 282, 295, 296, 296, 283, 282, 283, 296, 297, 297, 284, 283, 284, 297, 298, 298, 285, 284, 286, 299, 300, 300, 287, 286, 287, 300, 301, 301, 288, 287, 288, 301, 302, 302, 289, 288, 289, 302, 303, 303, 290, 289, 290, 303, 304, 304, 291, 290, 291, 304, 305, 305, 292, 291, 292, 305, 306, 306, 293, 292, 293, 306, 307, 307, 294, 293, 294, 307, 308, 308, 295, 294, 295, 308, 309, 309, 296, 295, 296, 309, 310, 310, 297, 296, 297, 310, 311, 311, 298, 297, 299, 312, 313, 313, 300, 299, 300, 313, 314, 314, 301, 300, 301, 314, 315, 315, 302, 301, 302, 315, 316, 316, 303, 302, 303, 316, 317, 317, 304, 303, 304, 317, 318, 318, 305, 304, 305, 318, 319, 319, 306, 305, 306, 319, 320, 320, 307, 306, 307, 320, 321, 321, 308, 307, 308, 321, 322, 322, 309, 308, 309, 322, 323, 323, 310, 309, 310, 323, 324, 324, 311, 310, 312, 325, 326, 326, 313, 312, 313, 326, 327, 327, 314, 313, 314, 327, 328, 328, 315, 314, 315, 328, 329, 329, 316, 315, 316, 329, 330, 330, 317, 316, 317, 330, 331, 331, 318, 317, 318, 331, 332, 332, 319, 318, 319, 332, 333, 333, 320, 319, 320, 333, 334, 334, 321, 320, 321, 334, 335, 335, 322, 321, 322, 335, 336, 336, 323, 322, 323, 336, 337, 337, 324, 323, 325, 338, 339, 339, 326, 325, 326, 339, 340, 340, 327, 326, 327, 340, 341, 341, 328, 327, 328, 341, 342, 342, 329, 328, 329, 342, 343, 343, 330, 329, 330, 343, 344, 344, 331, 330, 331, 344, 345, 345, 332, 331, 332, 345, 346, 346, 333, 332, 333, 346, 347, 347, 334, 333, 334, 347, 348, 348, 335, 334, 335, 348, 349, 349, 336, 335, 336, 349, 350, 350, 337, 336, 338, 351, 352, 352, 339, 338, 339, 352, 353, 353, 340, 339, 340, 353, 354, 354, 341, 340, 341, 354, 355, 355, 342, 341, 342, 355, 356, 356, 343, 342, 343, 356, 357, 357, 344, 343, 344, 357, 358, 358, 345, 344, 345, 358, 359, 359, 346, 345, 346, 359, 360, 360, 347, 346, 347, 360, 361, 361, 348, 347, 348, 361, 362, 362, 349, 348, 349, 362, 363, 363, 350, 349, 351, 364, 365, 365, 352, 351, 352, 365, 366, 366, 353, 352, 353, 366, 367, 367, 354, 353, 354, 367, 368, 368, 355, 354, 355, 368, 369, 369, 356, 355, 356, 369, 370, 370, 357, 356, 357, 370, 371, 371, 358, 357, 358, 371, 372, 372, 359, 358, 359, 372, 373, 373, 360, 359, 360, 373, 374, 374, 361, 360, 361, 374, 375, 375, 362, 361, 362, 375, 376, 376, 363, 362, 364, 377, 378, 378, 365, 364, 365, 378, 379, 379, 366, 365, 366, 379, 380, 380, 367, 366, 367, 380, 381, 381, 368, 367, 368, 381, 382, 382, 369, 368, 369, 382, 383, 383, 370, 369, 370, 383, 384, 384, 371, 370, 371, 384, 385, 385, 372, 371, 372, 385, 386, 386, 373, 372, 373, 386, 387, 387, 374, 373, 374, 387, 388, 388, 375, 374, 375, 388, 389, 389, 376, 375, 377, 390, 391, 391, 378, 377, 378, 391, 392, 392, 379, 378, 379, 392, 393, 393, 380, 379, 380, 393, 394, 394, 381, 380, 381, 394, 395, 395, 382, 381, 382, 395, 396, 396, 383, 382, 383, 396, 397, 397, 384, 383, 384, 397, 398, 398, 385, 384, 385, 398, 399, 399, 386, 385, 386, 399, 400, 400, 387, 386, 387, 400, 401, 401, 388, 387, 388, 401, 402, 402, 389, 388, 390, 403, 404, 404, 391, 390, 391, 404, 405, 405, 392, 391, 392, 405, 406, 406, 393, 392, 393, 406, 407, 407, 394, 393, 394, 407, 408, 408, 395, 394, 395, 408, 409, 409, 396, 395, 396, 409, 410, 410, 397, 396, 397, 410, 411, 411, 398, 397, 398, 411, 412, 412, 399, 398, 399, 412, 413, 413, 400, 399, 400, 413, 414, 414, 401, 400, 401, 414, 415, 415, 402, 401, 403, 416, 417, 417, 404, 403, 404, 417, 418, 418, 405, 404, 405, 418, 419, 419, 406, 405, 406, 419, 420, 420, 407, 406, 407, 420, 421, 421, 408, 407, 408, 421, 422, 422, 409, 408, 409, 422, 423, 423, 410, 409, 410, 423, 424, 424, 411, 410, 411, 424, 425, 425, 412, 411, 412, 425, 426, 426, 413, 412, 413, 426, 427, 427, 414, 413, 414, 427, 428, 428, 415, 414, 416, 429, 430, 430, 417, 416, 417, 430, 431, 431, 418, 417, 418, 431, 432, 432, 419, 418, 419, 432, 433, 433, 420, 419, 420, 433, 434, 434, 421, 420, 421, 434, 435, 435, 422, 421, 422, 435, 436, 436, 423, 422, 423, 436, 437, 437, 424, 423, 424, 437, 438, 438, 425, 424, 425, 438, 439, 439, 426, 425, 426, 439, 440, 440, 427, 426, 427, 440, 441, 441, 428, 427, 429, 442, 443, 443, 430, 429, 430, 443, 444, 444, 431, 430, 431, 444, 445, 445, 432, 431, 432, 445, 446, 446, 433, 432, 433, 446, 447, 447, 434, 433, 434, 447, 448, 448, 435, 434, 435, 448, 449, 449, 436, 435, 436, 449, 450, 450, 437, 436, 437, 450, 451, 451, 438, 437, 438, 451, 452, 452, 439, 438, 439, 452, 453, 453, 440, 439, 440, 453, 454, 454, 441, 440, 442, 455, 456, 456, 443, 442, 443, 456, 457, 457, 444, 443, 444, 457, 458, 458, 445, 444, 445, 458, 459, 459, 446, 445, 446, 459, 460, 460, 447, 446, 447, 460, 461, 461, 448, 447, 448, 461, 462, 462, 449, 448, 449, 462, 463, 463, 450, 449, 450, 463, 464, 464, 451, 450, 451, 464, 465, 465, 452, 451, 452, 465, 466, 466, 453, 452, 453, 466, 467, 467, 454, 453, 455, 468, 469, 469, 456, 455, 456, 469, 470, 470, 457, 456, 457, 470, 471, 471, 458, 457, 458, 471, 472, 472, 459, 458, 459, 472, 473, 473, 460, 459, 460, 473, 474, 474, 461, 460, 461, 474, 475, 475, 462, 461, 462, 475, 476, 476, 463, 462, 463, 476, 477, 477, 464, 463, 464, 477, 478, 478, 465, 464, 465, 478, 479, 479, 466, 465, 466, 479, 480, 480, 467, 466, 468, 481, 482, 482, 469, 468, 469, 482, 483, 483, 470, 469, 470, 483, 484, 484, 471, 470, 471, 484, 485, 485, 472, 471, 472, 485, 486, 486, 473, 472, 473, 486, 487, 487, 474, 473, 474, 487, 488, 488, 475, 474, 475, 488, 489, 489, 476, 475, 476, 489, 490, 490, 477, 476, 477, 490, 491, 491, 478, 477, 478, 491, 492, 492, 479, 478, 479, 492, 493, 493, 480, 479, 481, 494, 495, 495, 482, 481, 482, 495, 496, 496, 483, 482, 483, 496, 497, 497, 484, 483, 484, 497, 498, 498, 485, 484, 485, 498, 499, 499, 486, 485, 486, 499, 500, 500, 487, 486, 487, 500, 501, 501, 488, 487, 488, 501, 502, 502, 489, 488, 489, 502, 503, 503, 490, 489, 490, 503, 504, 504, 491, 490, 491, 504, 505, 505, 492, 491, 492, 505, 506, 506, 493, 492, 494, 507, 508, 508, 495, 494, 495, 508, 509, 509, 496, 495, 496, 509, 510, 510, 497, 496, 497, 510, 511, 511, 498, 497, 498, 511, 512, 512, 499, 498, 499, 512, 513, 513, 500, 499, 500, 513, 514, 514, 501, 500, 501, 514, 515, 515, 502, 501, 502, 515, 516, 516, 503, 502, 503, 516, 517, 517, 504, 503, 504, 517, 518, 518, 505, 504, 505, 518, 519, 519, 506, 505, 507, 520, 521, 521, 508, 507, 508, 521, 522, 522, 509, 508, 509, 522, 523, 523, 510, 509, 510, 523, 524, 524, 511, 510, 511, 524, 525, 525, 512, 511, 512, 525, 526, 526, 513, 512, 513, 526, 527, 527, 514, 513, 514, 527, 528, 528, 515, 514, 515, 528, 529, 529, 516, 515, 516, 529, 530, 530, 517, 516, 517, 530, 531, 531, 518, 517, 518, 531, 532, 532, 519, 518, 520, 533, 534, 534, 521, 520, 521, 534, 535, 535, 522, 521, 522, 535, 536, 536, 523, 522, 523, 536, 537, 537, 524, 523, 524, 537, 538, 538, 525, 524, 525, 538, 539, 539, 526, 525, 526, 539, 540, 540, 527, 526, 527, 540, 541, 541, 528, 527, 528, 541, 542, 542, 529, 528, 529, 542, 543, 543, 530, 529, 530, 543, 544, 544, 531, 530, 531, 544, 545, 545, 532, 531, 533, 546, 547, 547, 534, 533, 534, 547, 548, 548, 535, 534, 535, 548, 549, 549, 536, 535, 536, 549, 550, 550, 537, 536, 537, 550, 551, 551, 538, 537, 538, 551, 552, 552, 539, 538, 539, 552, 553, 553, 540, 539, 540, 553, 554, 554, 541, 540, 541, 554, 555, 555, 542, 541, 542, 555, 556, 556, 543, 542, 543, 556, 557, 557, 544, 543, 544, 557, 558, 558, 545, 544, 546, 559, 560, 560, 547, 546, 547, 560, 561, 561, 548, 547, 548, 561, 562, 562, 549, 548, 549, 562, 563, 563, 550, 549, 550, 563, 564, 564, 551, 550, 551, 564, 565, 565, 552, 551, 552, 565, 566, 566, 553, 552, 553, 566, 567, 567, 554, 553, 554, 567, 568, 568, 555, 554, 555, 568, 569, 569, 556, 555, 556, 569, 570, 570, 557, 556, 557, 570, 571, 571, 558, 557, 559, 572, 573, 573, 560, 559, 560, 573, 574, 574, 561, 560, 561, 574, 575, 575, 562, 561, 562, 575, 576, 576, 563, 562, 563, 576, 577, 577, 564, 563, 564, 577, 578, 578, 565, 564, 565, 578, 579, 579, 566, 565, 566, 579, 580, 580, 567, 566, 567, 580, 581, 581, 568, 567, 568, 581, 582, 582, 569, 568, 569, 582, 583, 583, 570, 569, 570, 583, 584, 584, 571, 570, 572, 585, 586, 586, 573, 572, 573, 586, 587, 587, 574, 573, 574, 587, 588, 588, 575, 574, 575, 588, 589, 589, 576, 575, 576, 589, 590, 590, 577, 576, 577, 590, 591, 591, 578, 577, 578, 591, 592, 592, 579, 578, 579, 592, 593, 593, 580, 579, 580, 593, 594, 594, 581, 580, 581, 594, 595, 595, 582, 581, 582, 595, 596, 596, 583, 582, 583, 596, 597, 597, 584, 583, 585, 598, 599, 599, 586, 585, 586, 599, 600, 600, 587, 586, 587, 600, 601, 601, 588, 587, 588, 601, 602, 602, 589, 588, 589, 602, 603, 603, 590, 589, 590, 603, 604, 604, 591, 590, 591, 604, 605, 605, 592, 591, 592, 605, 606, 606, 593, 592, 593, 606, 607, 607, 594, 593, 594, 607, 608, 608, 595, 594, 595, 608, 609, 609, 596, 595, 596, 609, 610, 610, 597, 596, 598, 611, 612, 612, 599, 598, 599, 612, 613, 613, 600, 599, 600, 613, 614, 614, 601, 600, 601, 614, 615, 615, 602, 601, 602, 615, 616, 616, 603, 602, 603, 616, 617, 617, 604, 603, 604, 617, 618, 618, 605, 604, 605, 618, 619, 619, 606, 605, 606, 619, 620, 620, 607, 606, 607, 620, 621, 621, 608, 607, 608, 621, 622, 622, 609, 608, 609, 622, 623, 623, 610, 609, 611, 0, 1, 1, 612, 611, 612, 1, 2, 2, 613, 612, 613, 2, 3, 3, 614, 613, 614, 3, 4, 4, 615, 614, 615, 4, 5, 5, 616, 615, 616, 5, 6, 6, 617, 616, 617, 6, 7, 7, 618, 617, 618, 7, 8, 8, 619, 618, 619, 8, 9, 9, 620, 619, 620, 9, 10, 10, 621, 620, 621, 10, 11, 11, 622, 621, 622, 11, 12, 12, 623, 622, 12, 25, 636, 636, 624, 12, 624, 636, 637, 637, 625, 624, 625, 637, 638, 638, 626, 625, 626, 638, 639, 639, 627, 626, 627, 639, 640, 640, 628, 627, 628, 640, 641, 641, 629, 628, 629, 641, 642, 642, 630, 629, 630, 642, 643, 643, 631, 630, 631, 643, 644, 644, 632, 631, 632, 644, 645, 645, 633, 632, 633, 645, 646, 646, 634, 633, 634, 646, 647, 647, 635, 634, 25, 38, 648, 648, 636, 25, 636, 648, 649, 649, 637, 636, 637, 649, 650, 650, 638, 637, 638, 650, 651, 651, 639, 638, 639, 651, 652, 652, 640, 639, 640, 652, 653, 653, 641, 640, 641, 653, 654, 654, 642, 641, 642, 654, 655, 655, 643, 642, 643, 655, 656, 656, 644, 643, 644, 656, 657, 657, 645, 644, 645, 657, 658, 658, 646, 645, 646, 658, 659, 659, 647, 646, 38, 51, 660, 660, 648, 38, 648, 660, 661, 661, 649, 648, 649, 661, 662, 662, 650, 649, 650, 662, 663, 663, 651, 650, 651, 663, 664, 664, 652, 651, 652, 664, 665, 665, 653, 652, 653, 665, 666, 666, 654, 653, 654, 666, 667, 667, 655, 654, 655, 667, 668, 668, 656, 655, 656, 668, 669, 669, 657, 656, 657, 669, 670, 670, 658, 657, 658, 670, 671, 671, 659, 658, 51, 64, 672, 672, 660, 51, 660, 672, 673, 673, 661, 660, 661, 673, 674, 674, 662, 661, 662, 674, 675, 675, 663, 662, 663, 675, 676, 676, 664, 663, 664, 676, 677, 677, 665, 664, 665, 677, 678, 678, 666, 665, 666, 678, 679, 679, 667, 666, 667, 679, 680, 680, 668, 667, 668, 680, 681, 681, 669, 668, 669, 681, 682, 682, 670, 669, 670, 682, 683, 683, 671, 670, 64, 77, 684, 684, 672, 64, 672, 684, 685, 685, 673, 672, 673, 685, 686, 686, 674, 673, 674, 686, 687, 687, 675, 674, 675, 687, 688, 688, 676, 675, 676, 688, 689, 689, 677, 676, 677, 689, 690, 690, 678, 677, 678, 690, 691, 691, 679, 678, 679, 691, 692, 692, 680, 679, 680, 692, 693, 693, 681, 680, 681, 693, 694, 694, 682, 681, 682, 694, 695, 695, 683, 682, 77, 90, 696, 696, 684, 77, 684, 696, 697, 697, 685, 684, 685, 697, 698, 698, 686, 685, 686, 698, 699, 699, 687, 686, 687, 699, 700, 700, 688, 687, 688, 700, 701, 701, 689, 688, 689, 701, 702, 702, 690, 689, 690, 702, 703, 703, 691, 690, 691, 703, 704, 704, 692, 691, 692, 704, 705, 705, 693, 692, 693, 705, 706, 706, 694, 693, 694, 706, 707, 707, 695, 694, 90, 103, 708, 708, 696, 90, 696, 708, 709, 709, 697, 696, 697, 709, 710, 710, 698, 697, 698, 710, 711, 711, 699, 698, 699, 711, 712, 712, 700, 699, 700, 712, 713, 713, 701, 700, 701, 713, 714, 714, 702, 701, 702, 714, 715, 715, 703, 702, 703, 715, 716, 716, 704, 703, 704, 716, 717, 717, 705, 704, 705, 717, 718, 718, 706, 705, 706, 718, 719, 719, 707, 706, 103, 116, 720, 720, 708, 103, 708, 720, 721, 721, 709, 708, 709, 721, 722, 722, 710, 709, 710, 722, 723, 723, 711, 710, 711, 723, 724, 724, 712, 711, 712, 724, 725, 725, 713, 712, 713, 725, 726, 726, 714, 713, 714, 726, 727, 727, 715, 714, 715, 727, 728, 728, 716, 715, 716, 728, 729, 729, 717, 716, 717, 729, 730, 730, 718, 717, 718, 730, 731, 731, 719, 718, 116, 129, 732, 732, 720, 116, 720, 732, 733, 733, 721, 720, 721, 733, 734, 734, 722, 721, 722, 734, 735, 735, 723, 722, 723, 735, 736, 736, 724, 723, 724, 736, 737, 737, 725, 724, 725, 737, 738, 738, 726, 725, 726, 738, 739, 739, 727, 726, 727, 739, 740, 740, 728, 727, 728, 740, 741, 741, 729, 728, 729, 741, 742, 742, 730, 729, 730, 742, 743, 743, 731, 730, 129, 142, 744, 744, 732, 129, 732, 744, 745, 745, 733, 732, 733, 745, 746, 746, 734, 733, 734, 746, 747, 747, 735, 734, 735, 747, 748, 748, 736, 735, 736, 748, 749, 749, 737, 736, 737, 749, 750, 750, 738, 737, 738, 750, 751, 751, 739, 738, 739, 751, 752, 752, 740, 739, 740, 752, 753, 753, 741, 740, 741, 753, 754, 754, 742, 741, 742, 754, 755, 755, 743, 742, 142, 155, 756, 756, 744, 142, 744, 756, 757, 757, 745, 744, 745, 757, 758, 758, 746, 745, 746, 758, 759, 759, 747, 746, 747, 759, 760, 760, 748, 747, 748, 760, 761, 761, 749, 748, 749, 761, 762, 762, 750, 749, 750, 762, 763, 763, 751, 750, 751, 763, 764, 764, 752, 751, 752, 764, 765, 765, 753, 752, 753, 765, 766, 766, 754, 753, 754, 766, 767, 767, 755, 754, 155, 168, 768, 768, 756, 155, 756, 768, 769, 769, 757, 756, 757, 769, 770, 770, 758, 757, 758, 770, 771, 771, 759, 758, 759, 771, 772, 772, 760, 759, 760, 772, 773, 773, 761, 760, 761, 773, 774, 774, 762, 761, 762, 774, 775, 775, 763, 762, 763, 775, 776, 776, 764, 763, 764, 776, 777, 777, 765, 764, 765, 777, 778, 778, 766, 765, 766, 778, 779, 779, 767, 766, 168, 181, 780, 780, 768, 168, 768, 780, 781, 781, 769, 768, 769, 781, 782, 782, 770, 769, 770, 782, 783, 783, 771, 770, 771, 783, 784, 784, 772, 771, 772, 784, 785, 785, 773, 772, 773, 785, 786, 786, 774, 773, 774, 786, 787, 787, 775, 774, 775, 787, 788, 788, 776, 775, 776, 788, 789, 789, 777, 776, 777, 789, 790, 790, 778, 777, 778, 790, 791, 791, 779, 778, 181, 194, 792, 792, 780, 181, 780, 792, 793, 793, 781, 780, 781, 793, 794, 794, 782, 781, 782, 794, 795, 795, 783, 782, 783, 795, 796, 796, 784, 783, 784, 796, 797, 797, 785, 784, 785, 797, 798, 798, 786, 785, 786, 798, 799, 799, 787, 786, 787, 799, 800, 800, 788, 787, 788, 800, 801, 801, 789, 788, 789, 801, 802, 802, 790, 789, 790, 802, 803, 803, 791, 790, 194, 207, 804, 804, 792, 194, 792, 804, 805, 805, 793, 792, 793, 805, 806, 806, 794, 793, 794, 806, 807, 807, 795, 794, 795, 807, 808, 808, 796, 795, 796, 808, 809, 809, 797, 796, 797, 809, 810, 810, 798, 797, 798, 810, 811, 811, 799, 798, 799, 811, 812, 812, 800, 799, 800, 812, 813, 813, 801, 800, 801, 813, 814, 814, 802, 801, 802, 814, 815, 815, 803, 802, 207, 220, 816, 816, 804, 207, 804, 816, 817, 817, 805, 804, 805, 817, 818, 818, 806, 805, 806, 818, 819, 819, 807, 806, 807, 819, 820, 820, 808, 807, 808, 820, 821, 821, 809, 808, 809, 821, 822, 822, 810, 809, 810, 822, 823, 823, 811, 810, 811, 823, 824, 824, 812, 811, 812, 824, 825, 825, 813, 812, 813, 825, 826, 826, 814, 813, 814, 826, 827, 827, 815, 814, 220, 233, 828, 828, 816, 220, 816, 828, 829, 829, 817, 816, 817, 829, 830, 830, 818, 817, 818, 830, 831, 831, 819, 818, 819, 831, 832, 832, 820, 819, 820, 832, 833, 833, 821, 820, 821, 833, 834, 834, 822, 821, 822, 834, 835, 835, 823, 822, 823, 835, 836, 836, 824, 823, 824, 836, 837, 837, 825, 824, 825, 837, 838, 838, 826, 825, 826, 838, 839, 839, 827, 826, 233, 246, 840, 840, 828, 233, 828, 840, 841, 841, 829, 828, 829, 841, 842, 842, 830, 829, 830, 842, 843, 843, 831, 830, 831, 843, 844, 844, 832, 831, 832, 844, 845, 845, 833, 832, 833, 845, 846, 846, 834, 833, 834, 846, 847, 847, 835, 834, 835, 847, 848, 848, 836, 835, 836, 848, 849, 849, 837, 836, 837, 849, 850, 850, 838, 837, 838, 850, 851, 851, 839, 838, 246, 259, 852, 852, 840, 246, 840, 852, 853, 853, 841, 840, 841, 853, 854, 854, 842, 841, 842, 854, 855, 855, 843, 842, 843, 855, 856, 856, 844, 843, 844, 856, 857, 857, 845, 844, 845, 857, 858, 858, 846, 845, 846, 858, 859, 859, 847, 846, 847, 859, 860, 860, 848, 847, 848, 860, 861, 861, 849, 848, 849, 861, 862, 862, 850, 849, 850, 862, 863, 863, 851, 850, 259, 272, 864, 864, 852, 259, 852, 864, 865, 865, 853, 852, 853, 865, 866, 866, 854, 853, 854, 866, 867, 867, 855, 854, 855, 867, 868, 868, 856, 855, 856, 868, 869, 869, 857, 856, 857, 869, 870, 870, 858, 857, 858, 870, 871, 871, 859, 858, 859, 871, 872, 872, 860, 859, 860, 872, 873, 873, 861, 860, 861, 873, 874, 874, 862, 861, 862, 874, 875, 875, 863, 862, 272, 285, 876, 876, 864, 272, 864, 876, 877, 877, 865, 864, 865, 877, 878, 878, 866, 865, 866, 878, 879, 879, 867, 866, 867, 879, 880, 880, 868, 867, 868, 880, 881, 881, 869, 868, 869, 881, 882, 882, 870, 869, 870, 882, 883, 883, 871, 870, 871, 883, 884, 884, 872, 871, 872, 884, 885, 885, 873, 872, 873, 885, 886, 886, 874, 873, 874, 886, 887, 887, 875, 874, 285, 298, 888, 888, 876, 285, 876, 888, 889, 889, 877, 876, 877, 889, 890, 890, 878, 877, 878, 890, 891, 891, 879, 878, 879, 891, 892, 892, 880, 879, 880, 892, 893, 893, 881, 880, 881, 893, 894, 894, 882, 881, 882, 894, 895, 895, 883, 882, 883, 895, 896, 896, 884, 883, 884, 896, 897, 897, 885, 884, 885, 897, 898, 898, 886, 885, 886, 898, 899, 899, 887, 886, 298, 311, 900, 900, 888, 298, 888, 900, 901, 901, 889, 888, 889, 901, 902, 902, 890, 889, 890, 902, 903, 903, 891, 890, 891, 903, 904, 904, 892, 891, 892, 904, 905, 905, 893, 892, 893, 905, 906, 906, 894, 893, 894, 906, 907, 907, 895, 894, 895, 907, 908, 908, 896, 895, 896, 908, 909, 909, 897, 896, 897, 909, 910, 910, 898, 897, 898, 910, 911, 911, 899, 898, 311, 324, 912, 912, 900, 311, 900, 912, 913, 913, 901, 900, 901, 913, 914, 914, 902, 901, 902, 914, 915, 915, 903, 902, 903, 915, 916, 916, 904, 903, 904, 916, 917, 917, 905, 904, 905, 917, 918, 918, 906, 905, 906, 918, 919, 919, 907, 906, 907, 919, 920, 920, 908, 907, 908, 920, 921, 921, 909, 908, 909, 921, 922, 922, 910, 909, 910, 922, 923, 923, 911, 910, 324, 337, 924, 924, 912, 324, 912, 924, 925, 925, 913, 912, 913, 925, 926, 926, 914, 913, 914, 926, 927, 927, 915, 914, 915, 927, 928, 928, 916, 915, 916, 928, 929, 929, 917, 916, 917, 929, 930, 930, 918, 917, 918, 930, 931, 931, 919, 918, 919, 931, 932, 932, 920, 919, 920, 932, 933, 933, 921, 920, 921, 933, 934, 934, 922, 921, 922, 934, 935, 935, 923, 922, 337, 350, 936, 936, 924, 337, 924, 936, 937, 937, 925, 924, 925, 937, 938, 938, 926, 925, 926, 938, 939, 939, 927, 926, 927, 939, 940, 940, 928, 927, 928, 940, 941, 941, 929, 928, 929, 941, 942, 942, 930, 929, 930, 942, 943, 943, 931, 930, 931, 943, 944, 944, 932, 931, 932, 944, 945, 945, 933, 932, 933, 945, 946, 946, 934, 933, 934, 946, 947, 947, 935, 934, 350, 363, 948, 948, 936, 350, 936, 948, 949, 949, 937, 936, 937, 949, 950, 950, 938, 937, 938, 950, 951, 951, 939, 938, 939, 951, 952, 952, 940, 939, 940, 952, 953, 953, 941, 940, 941, 953, 954, 954, 942, 941, 942, 954, 955, 955, 943, 942, 943, 955, 956, 956, 944, 943, 944, 956, 957, 957, 945, 944, 945, 957, 958, 958, 946, 945, 946, 958, 959, 959, 947, 946, 363, 376, 960, 960, 948, 363, 948, 960, 961, 961, 949, 948, 949, 961, 962, 962, 950, 949, 950, 962, 963, 963, 951, 950, 951, 963, 964, 964, 952, 951, 952, 964, 965, 965, 953, 952, 953, 965, 966, 966, 954, 953, 954, 966, 967, 967, 955, 954, 955, 967, 968, 968, 956, 955, 956, 968, 969, 969, 957, 956, 957, 969, 970, 970, 958, 957, 958, 970, 971, 971, 959, 958, 376, 389, 972, 972, 960, 376, 960, 972, 973, 973, 961, 960, 961, 973, 974, 974, 962, 961, 962, 974, 975, 975, 963, 962, 963, 975, 976, 976, 964, 963, 964, 976, 977, 977, 965, 964, 965, 977, 978, 978, 966, 965, 966, 978, 979, 979, 967, 966, 967, 979, 980, 980, 968, 967, 968, 980, 981, 981, 969, 968, 969, 981, 982, 982, 970, 969, 970, 982, 983, 983, 971, 970, 389, 402, 984, 984, 972, 389, 972, 984, 985, 985, 973, 972, 973, 985, 986, 986, 974, 973, 974, 986, 987, 987, 975, 974, 975, 987, 988, 988, 976, 975, 976, 988, 989, 989, 977, 976, 977, 989, 990, 990, 978, 977, 978, 990, 991, 991, 979, 978, 979, 991, 992, 992, 980, 979, 980, 992, 993, 993, 981, 980, 981, 993, 994, 994, 982, 981, 982, 994, 995, 995, 983, 982, 402, 415, 996, 996, 984, 402, 984, 996, 997, 997, 985, 984, 985, 997, 998, 998, 986, 985, 986, 998, 999, 999, 987, 986, 987, 999, 1000, 1000, 988, 987, 988, 1000, 1001, 1001, 989, 988, 989, 1001, 1002, 1002, 990, 989, 990, 1002, 1003, 1003, 991, 990, 991, 1003, 1004, 1004, 992, 991, 992, 1004, 1005, 1005, 993, 992, 993, 1005, 1006, 1006, 994, 993, 994, 1006, 1007, 1007, 995, 994, 415, 428, 1008, 1008, 996, 415, 996, 1008, 1009, 1009, 997, 996, 997, 1009, 1010, 1010, 998, 997, 998, 1010, 1011, 1011, 999, 998, 999, 1011, 1012, 1012, 1000, 999, 1000, 1012, 1013, 1013, 1001, 1000, 1001, 1013, 1014, 1014, 1002, 1001, 1002, 1014, 1015, 1015, 1003, 1002, 1003, 1015, 1016, 1016, 1004, 1003, 1004, 1016, 1017, 1017, 1005, 1004, 1005, 1017, 1018, 1018, 1006, 1005, 1006, 1018, 1019, 1019, 1007, 1006, 428, 441, 1020, 1020, 1008, 428, 1008, 1020, 1021, 1021, 1009, 1008, 1009, 1021, 1022, 1022, 1010, 1009, 1010, 1022, 1023, 1023, 1011, 1010, 1011, 1023, 1024, 1024, 1012, 1011, 1012, 1024, 1025, 1025, 1013, 1012, 1013, 1025, 1026, 1026, 1014, 1013, 1014, 1026, 1027, 1027, 1015, 1014, 1015, 1027, 1028, 1028, 1016, 1015, 1016, 1028, 1029, 1029, 1017, 1016, 1017, 1029, 1030, 1030, 1018, 1017, 1018, 1030, 1031, 1031, 1019, 1018, 441, 454, 1032, 1032, 1020, 441, 1020, 1032, 1033, 1033, 1021, 1020, 1021, 1033, 1034, 1034, 1022, 1021, 1022, 1034, 1035, 1035, 1023, 1022, 1023, 1035, 1036, 1036, 1024, 1023, 1024, 1036, 1037, 1037, 1025, 1024, 1025, 1037, 1038, 1038, 1026, 1025, 1026, 1038, 1039, 1039, 1027, 1026, 1027, 1039, 1040, 1040, 1028, 1027, 1028, 1040, 1041, 1041, 1029, 1028, 1029, 1041, 1042, 1042, 1030, 1029, 1030, 1042, 1043, 1043, 1031, 1030, 454, 467, 1044, 1044, 1032, 454, 1032, 1044, 1045, 1045, 1033, 1032, 1033, 1045, 1046, 1046, 1034, 1033, 1034, 1046, 1047, 1047, 1035, 1034, 1035, 1047, 1048, 1048, 1036, 1035, 1036, 1048, 1049, 1049, 1037, 1036, 1037, 1049, 1050, 1050, 1038, 1037, 1038, 1050, 1051, 1051, 1039, 1038, 1039, 1051, 1052, 1052, 1040, 1039, 1040, 1052, 1053, 1053, 1041, 1040, 1041, 1053, 1054, 1054, 1042, 1041, 1042, 1054, 1055, 1055, 1043, 1042, 467, 480, 1056, 1056, 1044, 467, 1044, 1056, 1057, 1057, 1045, 1044, 1045, 1057, 1058, 1058, 1046, 1045, 1046, 1058, 1059, 1059, 1047, 1046, 1047, 1059, 1060, 1060, 1048, 1047, 1048, 1060, 1061, 1061, 1049, 1048, 1049, 1061, 1062, 1062, 1050, 1049, 1050, 1062, 1063, 1063, 1051, 1050, 1051, 1063, 1064, 1064, 1052, 1051, 1052, 1064, 1065, 1065, 1053, 1052, 1053, 1065, 1066, 1066, 1054, 1053, 1054, 1066, 1067, 1067, 1055, 1054, 480, 493, 1068, 1068, 1056, 480, 1056, 1068, 1069, 1069, 1057, 1056, 1057, 1069, 1070, 1070, 1058, 1057, 1058, 1070, 1071, 1071, 1059, 1058, 1059, 1071, 1072, 1072, 1060, 1059, 1060, 1072, 1073, 1073, 1061, 1060, 1061, 1073, 1074, 1074, 1062, 1061, 1062, 1074, 1075, 1075, 1063, 1062, 1063, 1075, 1076, 1076, 1064, 1063, 1064, 1076, 1077, 1077, 1065, 1064, 1065, 1077, 1078, 1078, 1066, 1065, 1066, 1078, 1079, 1079, 1067, 1066, 493, 506, 1080, 1080, 1068, 493, 1068, 1080, 1081, 1081, 1069, 1068, 1069, 1081, 1082, 1082, 1070, 1069, 1070, 1082, 1083, 1083, 1071, 1070, 1071, 1083, 1084, 1084, 1072, 1071, 1072, 1084, 1085, 1085, 1073, 1072, 1073, 1085, 1086, 1086, 1074, 1073, 1074, 1086, 1087, 1087, 1075, 1074, 1075, 1087, 1088, 1088, 1076, 1075, 1076, 1088, 1089, 1089, 1077, 1076, 1077, 1089, 1090, 1090, 1078, 1077, 1078, 1090, 1091, 1091, 1079, 1078, 506, 519, 1092, 1092, 1080, 506, 1080, 1092, 1093, 1093, 1081, 1080, 1081, 1093, 1094, 1094, 1082, 1081, 1082, 1094, 1095, 1095, 1083, 1082, 1083, 1095, 1096, 1096, 1084, 1083, 1084, 1096, 1097, 1097, 1085, 1084, 1085, 1097, 1098, 1098, 1086, 1085, 1086, 1098, 1099, 1099, 1087, 1086, 1087, 1099, 1100, 1100, 1088, 1087, 1088, 1100, 1101, 1101, 1089, 1088, 1089, 1101, 1102, 1102, 1090, 1089, 1090, 1102, 1103, 1103, 1091, 1090, 519, 532, 1104, 1104, 1092, 519, 1092, 1104, 1105, 1105, 1093, 1092, 1093, 1105, 1106, 1106, 1094, 1093, 1094, 1106, 1107, 1107, 1095, 1094, 1095, 1107, 1108, 1108, 1096, 1095, 1096, 1108, 1109, 1109, 1097, 1096, 1097, 1109, 1110, 1110, 1098, 1097, 1098, 1110, 1111, 1111, 1099, 1098, 1099, 1111, 1112, 1112, 1100, 1099, 1100, 1112, 1113, 1113, 1101, 1100, 1101, 1113, 1114, 1114, 1102, 1101, 1102, 1114, 1115, 1115, 1103, 1102, 532, 545, 1116, 1116, 1104, 532, 1104, 1116, 1117, 1117, 1105, 1104, 1105, 1117, 1118, 1118, 1106, 1105, 1106, 1118, 1119, 1119, 1107, 1106, 1107, 1119, 1120, 1120, 1108, 1107, 1108, 1120, 1121, 1121, 1109, 1108, 1109, 1121, 1122, 1122, 1110, 1109, 1110, 1122, 1123, 1123, 1111, 1110, 1111, 1123, 1124, 1124, 1112, 1111, 1112, 1124, 1125, 1125, 1113, 1112, 1113, 1125, 1126, 1126, 1114, 1113, 1114, 1126, 1127, 1127, 1115, 1114, 545, 558, 1128, 1128, 1116, 545, 1116, 1128, 1129, 1129, 1117, 1116, 1117, 1129, 1130, 1130, 1118, 1117, 1118, 1130, 1131, 1131, 1119, 1118, 1119, 1131, 1132, 1132, 1120, 1119, 1120, 1132, 1133, 1133, 1121, 1120, 1121, 1133, 1134, 1134, 1122, 1121, 1122, 1134, 1135, 1135, 1123, 1122, 1123, 1135, 1136, 1136, 1124, 1123, 1124, 1136, 1137, 1137, 1125, 1124, 1125, 1137, 1138, 1138, 1126, 1125, 1126, 1138, 1139, 1139, 1127, 1126, 558, 571, 1140, 1140, 1128, 558, 1128, 1140, 1141, 1141, 1129, 1128, 1129, 1141, 1142, 1142, 1130, 1129, 1130, 1142, 1143, 1143, 1131, 1130, 1131, 1143, 1144, 1144, 1132, 1131, 1132, 1144, 1145, 1145, 1133, 1132, 1133, 1145, 1146, 1146, 1134, 1133, 1134, 1146, 1147, 1147, 1135, 1134, 1135, 1147, 1148, 1148, 1136, 1135, 1136, 1148, 1149, 1149, 1137, 1136, 1137, 1149, 1150, 1150, 1138, 1137, 1138, 1150, 1151, 1151, 1139, 1138, 571, 584, 1152, 1152, 1140, 571, 1140, 1152, 1153, 1153, 1141, 1140, 1141, 1153, 1154, 1154, 1142, 1141, 1142, 1154, 1155, 1155, 1143, 1142, 1143, 1155, 1156, 1156, 1144, 1143, 1144, 1156, 1157, 1157, 1145, 1144, 1145, 1157, 1158, 1158, 1146, 1145, 1146, 1158, 1159, 1159, 1147, 1146, 1147, 1159, 1160, 1160, 1148, 1147, 1148, 1160, 1161, 1161, 1149, 1148, 1149, 1161, 1162, 1162, 1150, 1149, 1150, 1162, 1163, 1163, 1151, 1150, 584, 597, 1164, 1164, 1152, 584, 1152, 1164, 1165, 1165, 1153, 1152, 1153, 1165, 1166, 1166, 1154, 1153, 1154, 1166, 1167, 1167, 1155, 1154, 1155, 1167, 1168, 1168, 1156, 1155, 1156, 1168, 1169, 1169, 1157, 1156, 1157, 1169, 1170, 1170, 1158, 1157, 1158, 1170, 1171, 1171, 1159, 1158, 1159, 1171, 1172, 1172, 1160, 1159, 1160, 1172, 1173, 1173, 1161, 1160, 1161, 1173, 1174, 1174, 1162, 1161, 1162, 1174, 1175, 1175, 1163, 1162, 597, 610, 1176, 1176, 1164, 597, 1164, 1176, 1177, 1177, 1165, 1164, 1165, 1177, 1178, 1178, 1166, 1165, 1166, 1178, 1179, 1179, 1167, 1166, 1167, 1179, 1180, 1180, 1168, 1167, 1168, 1180, 1181, 1181, 1169, 1168, 1169, 1181, 1182, 1182, 1170, 1169, 1170, 1182, 1183, 1183, 1171, 1170, 1171, 1183, 1184, 1184, 1172, 1171, 1172, 1184, 1185, 1185, 1173, 1172, 1173, 1185, 1186, 1186, 1174, 1173, 1174, 1186, 1187, 1187, 1175, 1174, 610, 623, 1188, 1188, 1176, 610, 1176, 1188, 1189, 1189, 1177, 1176, 1177, 1189, 1190, 1190, 1178, 1177, 1178, 1190, 1191, 1191, 1179, 1178, 1179, 1191, 1192, 1192, 1180, 1179, 1180, 1192, 1193, 1193, 1181, 1180, 1181, 1193, 1194, 1194, 1182, 1181, 1182, 1194, 1195, 1195, 1183, 1182, 1183, 1195, 1196, 1196, 1184, 1183, 1184, 1196, 1197, 1197, 1185, 1184, 1185, 1197, 1198, 1198, 1186, 1185, 1186, 1198, 1199, 1199, 1187, 1186, 623, 12, 624, 624, 1188, 623, 1188, 624, 625, 625, 1189, 1188, 1189, 625, 626, 626, 1190, 1189, 1190, 626, 627, 627, 1191, 1190, 1191, 627, 628, 628, 1192, 1191, 1192, 628, 629, 629, 1193, 1192, 1193, 629, 630, 630, 1194, 1193, 1194, 630, 631, 631, 1195, 1194, 1195, 631, 632, 632, 1196, 1195, 1196, 632, 633, 633, 1197, 1196, 1197, 633, 634, 634, 1198, 1197, 1198, 634, 635, 635, 1199, 1198, 635, 647, 1212, 1212, 1200, 635, 1200, 1212, 1213, 1213, 1201, 1200, 1201, 1213, 1214, 1214, 1202, 1201, 1202, 1214, 1215, 1215, 1203, 1202, 1203, 1215, 1216, 1216, 1204, 1203, 1204, 1216, 1217, 1217, 1205, 1204, 1205, 1217, 1218, 1218, 1206, 1205, 1206, 1218, 1219, 1219, 1207, 1206, 1207, 1219, 1220, 1220, 1208, 1207, 1208, 1220, 1221, 1221, 1209, 1208, 1209, 1221, 1222, 1222, 1210, 1209, 1210, 1222, 1223, 1223, 1211, 1210, 647, 659, 1224, 1224, 1212, 647, 1212, 1224, 1225, 1225, 1213, 1212, 1213, 1225, 1226, 1226, 1214, 1213, 1214, 1226, 1227, 1227, 1215, 1214, 1215, 1227, 1228, 1228, 1216, 1215, 1216, 1228, 1229, 1229, 1217, 1216, 1217, 1229, 1230, 1230, 1218, 1217, 1218, 1230, 1231, 1231, 1219, 1218, 1219, 1231, 1232, 1232, 1220, 1219, 1220, 1232, 1233, 1233, 1221, 1220, 1221, 1233, 1234, 1234, 1222, 1221, 1222, 1234, 1235, 1235, 1223, 1222, 659, 671, 1236, 1236, 1224, 659, 1224, 1236, 1237, 1237, 1225, 1224, 1225, 1237, 1238, 1238, 1226, 1225, 1226, 1238, 1239, 1239, 1227, 1226, 1227, 1239, 1240, 1240, 1228, 1227, 1228, 1240, 1241, 1241, 1229, 1228, 1229, 1241, 1242, 1242, 1230, 1229, 1230, 1242, 1243, 1243, 1231, 1230, 1231, 1243, 1244, 1244, 1232, 1231, 1232, 1244, 1245, 1245, 1233, 1232, 1233, 1245, 1246, 1246, 1234, 1233, 1234, 1246, 1247, 1247, 1235, 1234, 671, 683, 1248, 1248, 1236, 671, 1236, 1248, 1249, 1249, 1237, 1236, 1237, 1249, 1250, 1250, 1238, 1237, 1238, 1250, 1251, 1251, 1239, 1238, 1239, 1251, 1252, 1252, 1240, 1239, 1240, 1252, 1253, 1253, 1241, 1240, 1241, 1253, 1254, 1254, 1242, 1241, 1242, 1254, 1255, 1255, 1243, 1242, 1243, 1255, 1256, 1256, 1244, 1243, 1244, 1256, 1257, 1257, 1245, 1244, 1245, 1257, 1258, 1258, 1246, 1245, 1246, 1258, 1259, 1259, 1247, 1246, 683, 695, 1260, 1260, 1248, 683, 1248, 1260, 1261, 1261, 1249, 1248, 1249, 1261, 1262, 1262, 1250, 1249, 1250, 1262, 1263, 1263, 1251, 1250, 1251, 1263, 1264, 1264, 1252, 1251, 1252, 1264, 1265, 1265, 1253, 1252, 1253, 1265, 1266, 1266, 1254, 1253, 1254, 1266, 1267, 1267, 1255, 1254, 1255, 1267, 1268, 1268, 1256, 1255, 1256, 1268, 1269, 1269, 1257, 1256, 1257, 1269, 1270, 1270, 1258, 1257, 1258, 1270, 1271, 1271, 1259, 1258, 695, 707, 1272, 1272, 1260, 695, 1260, 1272, 1273, 1273, 1261, 1260, 1261, 1273, 1274, 1274, 1262, 1261, 1262, 1274, 1275, 1275, 1263, 1262, 1263, 1275, 1276, 1276, 1264, 1263, 1264, 1276, 1277, 1277, 1265, 1264, 1265, 1277, 1278, 1278, 1266, 1265, 1266, 1278, 1279, 1279, 1267, 1266, 1267, 1279, 1280, 1280, 1268, 1267, 1268, 1280, 1281, 1281, 1269, 1268, 1269, 1281, 1282, 1282, 1270, 1269, 1270, 1282, 1283, 1283, 1271, 1270, 707, 719, 1284, 1284, 1272, 707, 1272, 1284, 1285, 1285, 1273, 1272, 1273, 1285, 1286, 1286, 1274, 1273, 1274, 1286, 1287, 1287, 1275, 1274, 1275, 1287, 1288, 1288, 1276, 1275, 1276, 1288, 1289, 1289, 1277, 1276, 1277, 1289, 1290, 1290, 1278, 1277, 1278, 1290, 1291, 1291, 1279, 1278, 1279, 1291, 1292, 1292, 1280, 1279, 1280, 1292, 1293, 1293, 1281, 1280, 1281, 1293, 1294, 1294, 1282, 1281, 1282, 1294, 1295, 1295, 1283, 1282, 719, 731, 1296, 1296, 1284, 719, 1284, 1296, 1297, 1297, 1285, 1284, 1285, 1297, 1298, 1298, 1286, 1285, 1286, 1298, 1299, 1299, 1287, 1286, 1287, 1299, 1300, 1300, 1288, 1287, 1288, 1300, 1301, 1301, 1289, 1288, 1289, 1301, 1302, 1302, 1290, 1289, 1290, 1302, 1303, 1303, 1291, 1290, 1291, 1303, 1304, 1304, 1292, 1291, 1292, 1304, 1305, 1305, 1293, 1292, 1293, 1305, 1306, 1306, 1294, 1293, 1294, 1306, 1307, 1307, 1295, 1294, 731, 743, 1308, 1308, 1296, 731, 1296, 1308, 1309, 1309, 1297, 1296, 1297, 1309, 1310, 1310, 1298, 1297, 1298, 1310, 1311, 1311, 1299, 1298, 1299, 1311, 1312, 1312, 1300, 1299, 1300, 1312, 1313, 1313, 1301, 1300, 1301, 1313, 1314, 1314, 1302, 1301, 1302, 1314, 1315, 1315, 1303, 1302, 1303, 1315, 1316, 1316, 1304, 1303, 1304, 1316, 1317, 1317, 1305, 1304, 1305, 1317, 1318, 1318, 1306, 1305, 1306, 1318, 1319, 1319, 1307, 1306, 743, 755, 1320, 1320, 1308, 743, 1308, 1320, 1321, 1321, 1309, 1308, 1309, 1321, 1322, 1322, 1310, 1309, 1310, 1322, 1323, 1323, 1311, 1310, 1311, 1323, 1324, 1324, 1312, 1311, 1312, 1324, 1325, 1325, 1313, 1312, 1313, 1325, 1326, 1326, 1314, 1313, 1314, 1326, 1327, 1327, 1315, 1314, 1315, 1327, 1328, 1328, 1316, 1315, 1316, 1328, 1329, 1329, 1317, 1316, 1317, 1329, 1330, 1330, 1318, 1317, 1318, 1330, 1331, 1331, 1319, 1318, 755, 767, 1332, 1332, 1320, 755, 1320, 1332, 1333, 1333, 1321, 1320, 1321, 1333, 1334, 1334, 1322, 1321, 1322, 1334, 1335, 1335, 1323, 1322, 1323, 1335, 1336, 1336, 1324, 1323, 1324, 1336, 1337, 1337, 1325, 1324, 1325, 1337, 1338, 1338, 1326, 1325, 1326, 1338, 1339, 1339, 1327, 1326, 1327, 1339, 1340, 1340, 1328, 1327, 1328, 1340, 1341, 1341, 1329, 1328, 1329, 1341, 1342, 1342, 1330, 1329, 1330, 1342, 1343, 1343, 1331, 1330, 767, 779, 1344, 1344, 1332, 767, 1332, 1344, 1345, 1345, 1333, 1332, 1333, 1345, 1346, 1346, 1334, 1333, 1334, 1346, 1347, 1347, 1335, 1334, 1335, 1347, 1348, 1348, 1336, 1335, 1336, 1348, 1349, 1349, 1337, 1336, 1337, 1349, 1350, 1350, 1338, 1337, 1338, 1350, 1351, 1351, 1339, 1338, 1339, 1351, 1352, 1352, 1340, 1339, 1340, 1352, 1353, 1353, 1341, 1340, 1341, 1353, 1354, 1354, 1342, 1341, 1342, 1354, 1355, 1355, 1343, 1342, 779, 791, 1356, 1356, 1344, 779, 1344, 1356, 1357, 1357, 1345, 1344, 1345, 1357, 1358, 1358, 1346, 1345, 1346, 1358, 1359, 1359, 1347, 1346, 1347, 1359, 1360, 1360, 1348, 1347, 1348, 1360, 1361, 1361, 1349, 1348, 1349, 1361, 1362, 1362, 1350, 1349, 1350, 1362, 1363, 1363, 1351, 1350, 1351, 1363, 1364, 1364, 1352, 1351, 1352, 1364, 1365, 1365, 1353, 1352, 1353, 1365, 1366, 1366, 1354, 1353, 1354, 1366, 1367, 1367, 1355, 1354, 791, 803, 1368, 1368, 1356, 791, 1356, 1368, 1369, 1369, 1357, 1356, 1357, 1369, 1370, 1370, 1358, 1357, 1358, 1370, 1371, 1371, 1359, 1358, 1359, 1371, 1372, 1372, 1360, 1359, 1360, 1372, 1373, 1373, 1361, 1360, 1361, 1373, 1374, 1374, 1362, 1361, 1362, 1374, 1375, 1375, 1363, 1362, 1363, 1375, 1376, 1376, 1364, 1363, 1364, 1376, 1377, 1377, 1365, 1364, 1365, 1377, 1378, 1378, 1366, 1365, 1366, 1378, 1379, 1379, 1367, 1366, 803, 815, 1380, 1380, 1368, 803, 1368, 1380, 1381, 1381, 1369, 1368, 1369, 1381, 1382, 1382, 1370, 1369, 1370, 1382, 1383, 1383, 1371, 1370, 1371, 1383, 1384, 1384, 1372, 1371, 1372, 1384, 1385, 1385, 1373, 1372, 1373, 1385, 1386, 1386, 1374, 1373, 1374, 1386, 1387, 1387, 1375, 1374, 1375, 1387, 1388, 1388, 1376, 1375, 1376, 1388, 1389, 1389, 1377, 1376, 1377, 1389, 1390, 1390, 1378, 1377, 1378, 1390, 1391, 1391, 1379, 1378, 815, 827, 1392, 1392, 1380, 815, 1380, 1392, 1393, 1393, 1381, 1380, 1381, 1393, 1394, 1394, 1382, 1381, 1382, 1394, 1395, 1395, 1383, 1382, 1383, 1395, 1396, 1396, 1384, 1383, 1384, 1396, 1397, 1397, 1385, 1384, 1385, 1397, 1398, 1398, 1386, 1385, 1386, 1398, 1399, 1399, 1387, 1386, 1387, 1399, 1400, 1400, 1388, 1387, 1388, 1400, 1401, 1401, 1389, 1388, 1389, 1401, 1402, 1402, 1390, 1389, 1390, 1402, 1403, 1403, 1391, 1390, 827, 839, 1404, 1404, 1392, 827, 1392, 1404, 1405, 1405, 1393, 1392, 1393, 1405, 1406, 1406, 1394, 1393, 1394, 1406, 1407, 1407, 1395, 1394, 1395, 1407, 1408, 1408, 1396, 1395, 1396, 1408, 1409, 1409, 1397, 1396, 1397, 1409, 1410, 1410, 1398, 1397, 1398, 1410, 1411, 1411, 1399, 1398, 1399, 1411, 1412, 1412, 1400, 1399, 1400, 1412, 1413, 1413, 1401, 1400, 1401, 1413, 1414, 1414, 1402, 1401, 1402, 1414, 1415, 1415, 1403, 1402, 839, 851, 1416, 1416, 1404, 839, 1404, 1416, 1417, 1417, 1405, 1404, 1405, 1417, 1418, 1418, 1406, 1405, 1406, 1418, 1419, 1419, 1407, 1406, 1407, 1419, 1420, 1420, 1408, 1407, 1408, 1420, 1421, 1421, 1409, 1408, 1409, 1421, 1422, 1422, 1410, 1409, 1410, 1422, 1423, 1423, 1411, 1410, 1411, 1423, 1424, 1424, 1412, 1411, 1412, 1424, 1425, 1425, 1413, 1412, 1413, 1425, 1426, 1426, 1414, 1413, 1414, 1426, 1427, 1427, 1415, 1414, 851, 863, 1428, 1428, 1416, 851, 1416, 1428, 1429, 1429, 1417, 1416, 1417, 1429, 1430, 1430, 1418, 1417, 1418, 1430, 1431, 1431, 1419, 1418, 1419, 1431, 1432, 1432, 1420, 1419, 1420, 1432, 1433, 1433, 1421, 1420, 1421, 1433, 1434, 1434, 1422, 1421, 1422, 1434, 1435, 1435, 1423, 1422, 1423, 1435, 1436, 1436, 1424, 1423, 1424, 1436, 1437, 1437, 1425, 1424, 1425, 1437, 1438, 1438, 1426, 1425, 1426, 1438, 1439, 1439, 1427, 1426, 863, 875, 1440, 1440, 1428, 863, 1428, 1440, 1441, 1441, 1429, 1428, 1429, 1441, 1442, 1442, 1430, 1429, 1430, 1442, 1443, 1443, 1431, 1430, 1431, 1443, 1444, 1444, 1432, 1431, 1432, 1444, 1445, 1445, 1433, 1432, 1433, 1445, 1446, 1446, 1434, 1433, 1434, 1446, 1447, 1447, 1435, 1434, 1435, 1447, 1448, 1448, 1436, 1435, 1436, 1448, 1449, 1449, 1437, 1436, 1437, 1449, 1450, 1450, 1438, 1437, 1438, 1450, 1451, 1451, 1439, 1438, 875, 887, 1452, 1452, 1440, 875, 1440, 1452, 1453, 1453, 1441, 1440, 1441, 1453, 1454, 1454, 1442, 1441, 1442, 1454, 1455, 1455, 1443, 1442, 1443, 1455, 1456, 1456, 1444, 1443, 1444, 1456, 1457, 1457, 1445, 1444, 1445, 1457, 1458, 1458, 1446, 1445, 1446, 1458, 1459, 1459, 1447, 1446, 1447, 1459, 1460, 1460, 1448, 1447, 1448, 1460, 1461, 1461, 1449, 1448, 1449, 1461, 1462, 1462, 1450, 1449, 1450, 1462, 1463, 1463, 1451, 1450, 887, 899, 1464, 1464, 1452, 887, 1452, 1464, 1465, 1465, 1453, 1452, 1453, 1465, 1466, 1466, 1454, 1453, 1454, 1466, 1467, 1467, 1455, 1454, 1455, 1467, 1468, 1468, 1456, 1455, 1456, 1468, 1469, 1469, 1457, 1456, 1457, 1469, 1470, 1470, 1458, 1457, 1458, 1470, 1471, 1471, 1459, 1458, 1459, 1471, 1472, 1472, 1460, 1459, 1460, 1472, 1473, 1473, 1461, 1460, 1461, 1473, 1474, 1474, 1462, 1461, 1462, 1474, 1475, 1475, 1463, 1462, 899, 911, 1476, 1476, 1464, 899, 1464, 1476, 1477, 1477, 1465, 1464, 1465, 1477, 1478, 1478, 1466, 1465, 1466, 1478, 1479, 1479, 1467, 1466, 1467, 1479, 1480, 1480, 1468, 1467, 1468, 1480, 1481, 1481, 1469, 1468, 1469, 1481, 1482, 1482, 1470, 1469, 1470, 1482, 1483, 1483, 1471, 1470, 1471, 1483, 1484, 1484, 1472, 1471, 1472, 1484, 1485, 1485, 1473, 1472, 1473, 1485, 1486, 1486, 1474, 1473, 1474, 1486, 1487, 1487, 1475, 1474, 911, 923, 1488, 1488, 1476, 911, 1476, 1488, 1489, 1489, 1477, 1476, 1477, 1489, 1490, 1490, 1478, 1477, 1478, 1490, 1491, 1491, 1479, 1478, 1479, 1491, 1492, 1492, 1480, 1479, 1480, 1492, 1493, 1493, 1481, 1480, 1481, 1493, 1494, 1494, 1482, 1481, 1482, 1494, 1495, 1495, 1483, 1482, 1483, 1495, 1496, 1496, 1484, 1483, 1484, 1496, 1497, 1497, 1485, 1484, 1485, 1497, 1498, 1498, 1486, 1485, 1486, 1498, 1499, 1499, 1487, 1486, 923, 935, 1500, 1500, 1488, 923, 1488, 1500, 1501, 1501, 1489, 1488, 1489, 1501, 1502, 1502, 1490, 1489, 1490, 1502, 1503, 1503, 1491, 1490, 1491, 1503, 1504, 1504, 1492, 1491, 1492, 1504, 1505, 1505, 1493, 1492, 1493, 1505, 1506, 1506, 1494, 1493, 1494, 1506, 1507, 1507, 1495, 1494, 1495, 1507, 1508, 1508, 1496, 1495, 1496, 1508, 1509, 1509, 1497, 1496, 1497, 1509, 1510, 1510, 1498, 1497, 1498, 1510, 1511, 1511, 1499, 1498, 935, 947, 1512, 1512, 1500, 935, 1500, 1512, 1513, 1513, 1501, 1500, 1501, 1513, 1514, 1514, 1502, 1501, 1502, 1514, 1515, 1515, 1503, 1502, 1503, 1515, 1516, 1516, 1504, 1503, 1504, 1516, 1517, 1517, 1505, 1504, 1505, 1517, 1518, 1518, 1506, 1505, 1506, 1518, 1519, 1519, 1507, 1506, 1507, 1519, 1520, 1520, 1508, 1507, 1508, 1520, 1521, 1521, 1509, 1508, 1509, 1521, 1522, 1522, 1510, 1509, 1510, 1522, 1523, 1523, 1511, 1510, 947, 959, 1524, 1524, 1512, 947, 1512, 1524, 1525, 1525, 1513, 1512, 1513, 1525, 1526, 1526, 1514, 1513, 1514, 1526, 1527, 1527, 1515, 1514, 1515, 1527, 1528, 1528, 1516, 1515, 1516, 1528, 1529, 1529, 1517, 1516, 1517, 1529, 1530, 1530, 1518, 1517, 1518, 1530, 1531, 1531, 1519, 1518, 1519, 1531, 1532, 1532, 1520, 1519, 1520, 1532, 1533, 1533, 1521, 1520, 1521, 1533, 1534, 1534, 1522, 1521, 1522, 1534, 1535, 1535, 1523, 1522, 959, 971, 1536, 1536, 1524, 959, 1524, 1536, 1537, 1537, 1525, 1524, 1525, 1537, 1538, 1538, 1526, 1525, 1526, 1538, 1539, 1539, 1527, 1526, 1527, 1539, 1540, 1540, 1528, 1527, 1528, 1540, 1541, 1541, 1529, 1528, 1529, 1541, 1542, 1542, 1530, 1529, 1530, 1542, 1543, 1543, 1531, 1530, 1531, 1543, 1544, 1544, 1532, 1531, 1532, 1544, 1545, 1545, 1533, 1532, 1533, 1545, 1546, 1546, 1534, 1533, 1534, 1546, 1547, 1547, 1535, 1534, 971, 983, 1548, 1548, 1536, 971, 1536, 1548, 1549, 1549, 1537, 1536, 1537, 1549, 1550, 1550, 1538, 1537, 1538, 1550, 1551, 1551, 1539, 1538, 1539, 1551, 1552, 1552, 1540, 1539, 1540, 1552, 1553, 1553, 1541, 1540, 1541, 1553, 1554, 1554, 1542, 1541, 1542, 1554, 1555, 1555, 1543, 1542, 1543, 1555, 1556, 1556, 1544, 1543, 1544, 1556, 1557, 1557, 1545, 1544, 1545, 1557, 1558, 1558, 1546, 1545, 1546, 1558, 1559, 1559, 1547, 1546, 983, 995, 1560, 1560, 1548, 983, 1548, 1560, 1561, 1561, 1549, 1548, 1549, 1561, 1562, 1562, 1550, 1549, 1550, 1562, 1563, 1563, 1551, 1550, 1551, 1563, 1564, 1564, 1552, 1551, 1552, 1564, 1565, 1565, 1553, 1552, 1553, 1565, 1566, 1566, 1554, 1553, 1554, 1566, 1567, 1567, 1555, 1554, 1555, 1567, 1568, 1568, 1556, 1555, 1556, 1568, 1569, 1569, 1557, 1556, 1557, 1569, 1570, 1570, 1558, 1557, 1558, 1570, 1571, 1571, 1559, 1558, 995, 1007, 1572, 1572, 1560, 995, 1560, 1572, 1573, 1573, 1561, 1560, 1561, 1573, 1574, 1574, 1562, 1561, 1562, 1574, 1575, 1575, 1563, 1562, 1563, 1575, 1576, 1576, 1564, 1563, 1564, 1576, 1577, 1577, 1565, 1564, 1565, 1577, 1578, 1578, 1566, 1565, 1566, 1578, 1579, 1579, 1567, 1566, 1567, 1579, 1580, 1580, 1568, 1567, 1568, 1580, 1581, 1581, 1569, 1568, 1569, 1581, 1582, 1582, 1570, 1569, 1570, 1582, 1583, 1583, 1571, 1570, 1007, 1019, 1584, 1584, 1572, 1007, 1572, 1584, 1585, 1585, 1573, 1572, 1573, 1585, 1586, 1586, 1574, 1573, 1574, 1586, 1587, 1587, 1575, 1574, 1575, 1587, 1588, 1588, 1576, 1575, 1576, 1588, 1589, 1589, 1577, 1576, 1577, 1589, 1590, 1590, 1578, 1577, 1578, 1590, 1591, 1591, 1579, 1578, 1579, 1591, 1592, 1592, 1580, 1579, 1580, 1592, 1593, 1593, 1581, 1580, 1581, 1593, 1594, 1594, 1582, 1581, 1582, 1594, 1595, 1595, 1583, 1582, 1019, 1031, 1596, 1596, 1584, 1019, 1584, 1596, 1597, 1597, 1585, 1584, 1585, 1597, 1598, 1598, 1586, 1585, 1586, 1598, 1599, 1599, 1587, 1586, 1587, 1599, 1600, 1600, 1588, 1587, 1588, 1600, 1601, 1601, 1589, 1588, 1589, 1601, 1602, 1602, 1590, 1589, 1590, 1602, 1603, 1603, 1591, 1590, 1591, 1603, 1604, 1604, 1592, 1591, 1592, 1604, 1605, 1605, 1593, 1592, 1593, 1605, 1606, 1606, 1594, 1593, 1594, 1606, 1607, 1607, 1595, 1594, 1031, 1043, 1608, 1608, 1596, 1031, 1596, 1608, 1609, 1609, 1597, 1596, 1597, 1609, 1610, 1610, 1598, 1597, 1598, 1610, 1611, 1611, 1599, 1598, 1599, 1611, 1612, 1612, 1600, 1599, 1600, 1612, 1613, 1613, 1601, 1600, 1601, 1613, 1614, 1614, 1602, 1601, 1602, 1614, 1615, 1615, 1603, 1602, 1603, 1615, 1616, 1616, 1604, 1603, 1604, 1616, 1617, 1617, 1605, 1604, 1605, 1617, 1618, 1618, 1606, 1605, 1606, 1618, 1619, 1619, 1607, 1606, 1043, 1055, 1620, 1620, 1608, 1043, 1608, 1620, 1621, 1621, 1609, 1608, 1609, 1621, 1622, 1622, 1610, 1609, 1610, 1622, 1623, 1623, 1611, 1610, 1611, 1623, 1624, 1624, 1612, 1611, 1612, 1624, 1625, 1625, 1613, 1612, 1613, 1625, 1626, 1626, 1614, 1613, 1614, 1626, 1627, 1627, 1615, 1614, 1615, 1627, 1628, 1628, 1616, 1615, 1616, 1628, 1629, 1629, 1617, 1616, 1617, 1629, 1630, 1630, 1618, 1617, 1618, 1630, 1631, 1631, 1619, 1618, 1055, 1067, 1632, 1632, 1620, 1055, 1620, 1632, 1633, 1633, 1621, 1620, 1621, 1633, 1634, 1634, 1622, 1621, 1622, 1634, 1635, 1635, 1623, 1622, 1623, 1635, 1636, 1636, 1624, 1623, 1624, 1636, 1637, 1637, 1625, 1624, 1625, 1637, 1638, 1638, 1626, 1625, 1626, 1638, 1639, 1639, 1627, 1626, 1627, 1639, 1640, 1640, 1628, 1627, 1628, 1640, 1641, 1641, 1629, 1628, 1629, 1641, 1642, 1642, 1630, 1629, 1630, 1642, 1643, 1643, 1631, 1630, 1067, 1079, 1644, 1644, 1632, 1067, 1632, 1644, 1645, 1645, 1633, 1632, 1633, 1645, 1646, 1646, 1634, 1633, 1634, 1646, 1647, 1647, 1635, 1634, 1635, 1647, 1648, 1648, 1636, 1635, 1636, 1648, 1649, 1649, 1637, 1636, 1637, 1649, 1650, 1650, 1638, 1637, 1638, 1650, 1651, 1651, 1639, 1638, 1639, 1651, 1652, 1652, 1640, 1639, 1640, 1652, 1653, 1653, 1641, 1640, 1641, 1653, 1654, 1654, 1642, 1641, 1642, 1654, 1655, 1655, 1643, 1642, 1079, 1091, 1656, 1656, 1644, 1079, 1644, 1656, 1657, 1657, 1645, 1644, 1645, 1657, 1658, 1658, 1646, 1645, 1646, 1658, 1659, 1659, 1647, 1646, 1647, 1659, 1660, 1660, 1648, 1647, 1648, 1660, 1661, 1661, 1649, 1648, 1649, 1661, 1662, 1662, 1650, 1649, 1650, 1662, 1663, 1663, 1651, 1650, 1651, 1663, 1664, 1664, 1652, 1651, 1652, 1664, 1665, 1665, 1653, 1652, 1653, 1665, 1666, 1666, 1654, 1653, 1654, 1666, 1667, 1667, 1655, 1654, 1091, 1103, 1668, 1668, 1656, 1091, 1656, 1668, 1669, 1669, 1657, 1656, 1657, 1669, 1670, 1670, 1658, 1657, 1658, 1670, 1671, 1671, 1659, 1658, 1659, 1671, 1672, 1672, 1660, 1659, 1660, 1672, 1673, 1673, 1661, 1660, 1661, 1673, 1674, 1674, 1662, 1661, 1662, 1674, 1675, 1675, 1663, 1662, 1663, 1675, 1676, 1676, 1664, 1663, 1664, 1676, 1677, 1677, 1665, 1664, 1665, 1677, 1678, 1678, 1666, 1665, 1666, 1678, 1679, 1679, 1667, 1666, 1103, 1115, 1680, 1680, 1668, 1103, 1668, 1680, 1681, 1681, 1669, 1668, 1669, 1681, 1682, 1682, 1670, 1669, 1670, 1682, 1683, 1683, 1671, 1670, 1671, 1683, 1684, 1684, 1672, 1671, 1672, 1684, 1685, 1685, 1673, 1672, 1673, 1685, 1686, 1686, 1674, 1673, 1674, 1686, 1687, 1687, 1675, 1674, 1675, 1687, 1688, 1688, 1676, 1675, 1676, 1688, 1689, 1689, 1677, 1676, 1677, 1689, 1690, 1690, 1678, 1677, 1678, 1690, 1691, 1691, 1679, 1678, 1115, 1127, 1692, 1692, 1680, 1115, 1680, 1692, 1693, 1693, 1681, 1680, 1681, 1693, 1694, 1694, 1682, 1681, 1682, 1694, 1695, 1695, 1683, 1682, 1683, 1695, 1696, 1696, 1684, 1683, 1684, 1696, 1697, 1697, 1685, 1684, 1685, 1697, 1698, 1698, 1686, 1685, 1686, 1698, 1699, 1699, 1687, 1686, 1687, 1699, 1700, 1700, 1688, 1687, 1688, 1700, 1701, 1701, 1689, 1688, 1689, 1701, 1702, 1702, 1690, 1689, 1690, 1702, 1703, 1703, 1691, 1690, 1127, 1139, 1704, 1704, 1692, 1127, 1692, 1704, 1705, 1705, 1693, 1692, 1693, 1705, 1706, 1706, 1694, 1693, 1694, 1706, 1707, 1707, 1695, 1694, 1695, 1707, 1708, 1708, 1696, 1695, 1696, 1708, 1709, 1709, 1697, 1696, 1697, 1709, 1710, 1710, 1698, 1697, 1698, 1710, 1711, 1711, 1699, 1698, 1699, 1711, 1712, 1712, 1700, 1699, 1700, 1712, 1713, 1713, 1701, 1700, 1701, 1713, 1714, 1714, 1702, 1701, 1702, 1714, 1715, 1715, 1703, 1702, 1139, 1151, 1716, 1716, 1704, 1139, 1704, 1716, 1717, 1717, 1705, 1704, 1705, 1717, 1718, 1718, 1706, 1705, 1706, 1718, 1719, 1719, 1707, 1706, 1707, 1719, 1720, 1720, 1708, 1707, 1708, 1720, 1721, 1721, 1709, 1708, 1709, 1721, 1722, 1722, 1710, 1709, 1710, 1722, 1723, 1723, 1711, 1710, 1711, 1723, 1724, 1724, 1712, 1711, 1712, 1724, 1725, 1725, 1713, 1712, 1713, 1725, 1726, 1726, 1714, 1713, 1714, 1726, 1727, 1727, 1715, 1714, 1151, 1163, 1728, 1728, 1716, 1151, 1716, 1728, 1729, 1729, 1717, 1716, 1717, 1729, 1730, 1730, 1718, 1717, 1718, 1730, 1731, 1731, 1719, 1718, 1719, 1731, 1732, 1732, 1720, 1719, 1720, 1732, 1733, 1733, 1721, 1720, 1721, 1733, 1734, 1734, 1722, 1721, 1722, 1734, 1735, 1735, 1723, 1722, 1723, 1735, 1736, 1736, 1724, 1723, 1724, 1736, 1737, 1737, 1725, 1724, 1725, 1737, 1738, 1738, 1726, 1725, 1726, 1738, 1739, 1739, 1727, 1726, 1163, 1175, 1740, 1740, 1728, 1163, 1728, 1740, 1741, 1741, 1729, 1728, 1729, 1741, 1742, 1742, 1730, 1729, 1730, 1742, 1743, 1743, 1731, 1730, 1731, 1743, 1744, 1744, 1732, 1731, 1732, 1744, 1745, 1745, 1733, 1732, 1733, 1745, 1746, 1746, 1734, 1733, 1734, 1746, 1747, 1747, 1735, 1734, 1735, 1747, 1748, 1748, 1736, 1735, 1736, 1748, 1749, 1749, 1737, 1736, 1737, 1749, 1750, 1750, 1738, 1737, 1738, 1750, 1751, 1751, 1739, 1738, 1175, 1187, 1752, 1752, 1740, 1175, 1740, 1752, 1753, 1753, 1741, 1740, 1741, 1753, 1754, 1754, 1742, 1741, 1742, 1754, 1755, 1755, 1743, 1742, 1743, 1755, 1756, 1756, 1744, 1743, 1744, 1756, 1757, 1757, 1745, 1744, 1745, 1757, 1758, 1758, 1746, 1745, 1746, 1758, 1759, 1759, 1747, 1746, 1747, 1759, 1760, 1760, 1748, 1747, 1748, 1760, 1761, 1761, 1749, 1748, 1749, 1761, 1762, 1762, 1750, 1749, 1750, 1762, 1763, 1763, 1751, 1750, 1187, 1199, 1764, 1764, 1752, 1187, 1752, 1764, 1765, 1765, 1753, 1752, 1753, 1765, 1766, 1766, 1754, 1753, 1754, 1766, 1767, 1767, 1755, 1754, 1755, 1767, 1768, 1768, 1756, 1755, 1756, 1768, 1769, 1769, 1757, 1756, 1757, 1769, 1770, 1770, 1758, 1757, 1758, 1770, 1771, 1771, 1759, 1758, 1759, 1771, 1772, 1772, 1760, 1759, 1760, 1772, 1773, 1773, 1761, 1760, 1761, 1773, 1774, 1774, 1762, 1761, 1762, 1774, 1775, 1775, 1763, 1762, 1199, 635, 1200, 1200, 1764, 1199, 1764, 1200, 1201, 1201, 1765, 1764, 1765, 1201, 1202, 1202, 1766, 1765, 1766, 1202, 1203, 1203, 1767, 1766, 1767, 1203, 1204, 1204, 1768, 1767, 1768, 1204, 1205, 1205, 1769, 1768, 1769, 1205, 1206, 1206, 1770, 1769, 1770, 1206, 1207, 1207, 1771, 1770, 1771, 1207, 1208, 1208, 1772, 1771, 1772, 1208, 1209, 1209, 1773, 1772, 1773, 1209, 1210, 1210, 1774, 1773, 1774, 1210, 1211, 1211, 1775, 1774, 1211, 1223, 1788, 1788, 1776, 1211, 1776, 1788, 1789, 1789, 1777, 1776, 1777, 1789, 1790, 1790, 1778, 1777, 1778, 1790, 1791, 1791, 1779, 1778, 1779, 1791, 1792, 1792, 1780, 1779, 1780, 1792, 1793, 1793, 1781, 1780, 1781, 1793, 1794, 1794, 1782, 1781, 1782, 1794, 1795, 1795, 1783, 1782, 1783, 1795, 1796, 1796, 1784, 1783, 1784, 1796, 1797, 1797, 1785, 1784, 1785, 1797, 1798, 1798, 1786, 1785, 1786, 1798, 1787, 1787, 1787, 1786, 1223, 1235, 1799, 1799, 1788, 1223, 1788, 1799, 1800, 1800, 1789, 1788, 1789, 1800, 1801, 1801, 1790, 1789, 1790, 1801, 1802, 1802, 1791, 1790, 1791, 1802, 1803, 1803, 1792, 1791, 1792, 1803, 1804, 1804, 1793, 1792, 1793, 1804, 1805, 1805, 1794, 1793, 1794, 1805, 1806, 1806, 1795, 1794, 1795, 1806, 1807, 1807, 1796, 1795, 1796, 1807, 1808, 1808, 1797, 1796, 1797, 1808, 1809, 1809, 1798, 1797, 1798, 1809, 1787, 1787, 1787, 1798, 1235, 1247, 1810, 1810, 1799, 1235, 1799, 1810, 1811, 1811, 1800, 1799, 1800, 1811, 1812, 1812, 1801, 1800, 1801, 1812, 1813, 1813, 1802, 1801, 1802, 1813, 1814, 1814, 1803, 1802, 1803, 1814, 1815, 1815, 1804, 1803, 1804, 1815, 1816, 1816, 1805, 1804, 1805, 1816, 1817, 1817, 1806, 1805, 1806, 1817, 1818, 1818, 1807, 1806, 1807, 1818, 1819, 1819, 1808, 1807, 1808, 1819, 1820, 1820, 1809, 1808, 1809, 1820, 1787, 1787, 1787, 1809, 1247, 1259, 1821, 1821, 1810, 1247, 1810, 1821, 1822, 1822, 1811, 1810, 1811, 1822, 1823, 1823, 1812, 1811, 1812, 1823, 1824, 1824, 1813, 1812, 1813, 1824, 1825, 1825, 1814, 1813, 1814, 1825, 1826, 1826, 1815, 1814, 1815, 1826, 1827, 1827, 1816, 1815, 1816, 1827, 1828, 1828, 1817, 1816, 1817, 1828, 1829, 1829, 1818, 1817, 1818, 1829, 1830, 1830, 1819, 1818, 1819, 1830, 1831, 1831, 1820, 1819, 1820, 1831, 1787, 1787, 1787, 1820, 1259, 1271, 1832, 1832, 1821, 1259, 1821, 1832, 1833, 1833, 1822, 1821, 1822, 1833, 1834, 1834, 1823, 1822, 1823, 1834, 1835, 1835, 1824, 1823, 1824, 1835, 1836, 1836, 1825, 1824, 1825, 1836, 1837, 1837, 1826, 1825, 1826, 1837, 1838, 1838, 1827, 1826, 1827, 1838, 1839, 1839, 1828, 1827, 1828, 1839, 1840, 1840, 1829, 1828, 1829, 1840, 1841, 1841, 1830, 1829, 1830, 1841, 1842, 1842, 1831, 1830, 1831, 1842, 1787, 1787, 1787, 1831, 1271, 1283, 1843, 1843, 1832, 1271, 1832, 1843, 1844, 1844, 1833, 1832, 1833, 1844, 1845, 1845, 1834, 1833, 1834, 1845, 1846, 1846, 1835, 1834, 1835, 1846, 1847, 1847, 1836, 1835, 1836, 1847, 1848, 1848, 1837, 1836, 1837, 1848, 1849, 1849, 1838, 1837, 1838, 1849, 1850, 1850, 1839, 1838, 1839, 1850, 1851, 1851, 1840, 1839, 1840, 1851, 1852, 1852, 1841, 1840, 1841, 1852, 1853, 1853, 1842, 1841, 1842, 1853, 1787, 1787, 1787, 1842, 1283, 1295, 1854, 1854, 1843, 1283, 1843, 1854, 1855, 1855, 1844, 1843, 1844, 1855, 1856, 1856, 1845, 1844, 1845, 1856, 1857, 1857, 1846, 1845, 1846, 1857, 1858, 1858, 1847, 1846, 1847, 1858, 1859, 1859, 1848, 1847, 1848, 1859, 1860, 1860, 1849, 1848, 1849, 1860, 1861, 1861, 1850, 1849, 1850, 1861, 1862, 1862, 1851, 1850, 1851, 1862, 1863, 1863, 1852, 1851, 1852, 1863, 1864, 1864, 1853, 1852, 1853, 1864, 1787, 1787, 1787, 1853, 1295, 1307, 1865, 1865, 1854, 1295, 1854, 1865, 1866, 1866, 1855, 1854, 1855, 1866, 1867, 1867, 1856, 1855, 1856, 1867, 1868, 1868, 1857, 1856, 1857, 1868, 1869, 1869, 1858, 1857, 1858, 1869, 1870, 1870, 1859, 1858, 1859, 1870, 1871, 1871, 1860, 1859, 1860, 1871, 1872, 1872, 1861, 1860, 1861, 1872, 1873, 1873, 1862, 1861, 1862, 1873, 1874, 1874, 1863, 1862, 1863, 1874, 1875, 1875, 1864, 1863, 1864, 1875, 1787, 1787, 1787, 1864, 1307, 1319, 1876, 1876, 1865, 1307, 1865, 1876, 1877, 1877, 1866, 1865, 1866, 1877, 1878, 1878, 1867, 1866, 1867, 1878, 1879, 1879, 1868, 1867, 1868, 1879, 1880, 1880, 1869, 1868, 1869, 1880, 1881, 1881, 1870, 1869, 1870, 1881, 1882, 1882, 1871, 1870, 1871, 1882, 1883, 1883, 1872, 1871, 1872, 1883, 1884, 1884, 1873, 1872, 1873, 1884, 1885, 1885, 1874, 1873, 1874, 1885, 1886, 1886, 1875, 1874, 1875, 1886, 1787, 1787, 1787, 1875, 1319, 1331, 1887, 1887, 1876, 1319, 1876, 1887, 1888, 1888, 1877, 1876, 1877, 1888, 1889, 1889, 1878, 1877, 1878, 1889, 1890, 1890, 1879, 1878, 1879, 1890, 1891, 1891, 1880, 1879, 1880, 1891, 1892, 1892, 1881, 1880, 1881, 1892, 1893, 1893, 1882, 1881, 1882, 1893, 1894, 1894, 1883, 1882, 1883, 1894, 1895, 1895, 1884, 1883, 1884, 1895, 1896, 1896, 1885, 1884, 1885, 1896, 1897, 1897, 1886, 1885, 1886, 1897, 1787, 1787, 1787, 1886, 1331, 1343, 1898, 1898, 1887, 1331, 1887, 1898, 1899, 1899, 1888, 1887, 1888, 1899, 1900, 1900, 1889, 1888, 1889, 1900, 1901, 1901, 1890, 1889, 1890, 1901, 1902, 1902, 1891, 1890, 1891, 1902, 1903, 1903, 1892, 1891, 1892, 1903, 1904, 1904, 1893, 1892, 1893, 1904, 1905, 1905, 1894, 1893, 1894, 1905, 1906, 1906, 1895, 1894, 1895, 1906, 1907, 1907, 1896, 1895, 1896, 1907, 1908, 1908, 1897, 1896, 1897, 1908, 1787, 1787, 1787, 1897, 1343, 1355, 1909, 1909, 1898, 1343, 1898, 1909, 1910, 1910, 1899, 1898, 1899, 1910, 1911, 1911, 1900, 1899, 1900, 1911, 1912, 1912, 1901, 1900, 1901, 1912, 1913, 1913, 1902, 1901, 1902, 1913, 1914, 1914, 1903, 1902, 1903, 1914, 1915, 1915, 1904, 1903, 1904, 1915, 1916, 1916, 1905, 1904, 1905, 1916, 1917, 1917, 1906, 1905, 1906, 1917, 1918, 1918, 1907, 1906, 1907, 1918, 1919, 1919, 1908, 1907, 1908, 1919, 1787, 1787, 1787, 1908, 1355, 1367, 1920, 1920, 1909, 1355, 1909, 1920, 1921, 1921, 1910, 1909, 1910, 1921, 1922, 1922, 1911, 1910, 1911, 1922, 1923, 1923, 1912, 1911, 1912, 1923, 1924, 1924, 1913, 1912, 1913, 1924, 1925, 1925, 1914, 1913, 1914, 1925, 1926, 1926, 1915, 1914, 1915, 1926, 1927, 1927, 1916, 1915, 1916, 1927, 1928, 1928, 1917, 1916, 1917, 1928, 1929, 1929, 1918, 1917, 1918, 1929, 1930, 1930, 1919, 1918, 1919, 1930, 1787, 1787, 1787, 1919, 1367, 1379, 1931, 1931, 1920, 1367, 1920, 1931, 1932, 1932, 1921, 1920, 1921, 1932, 1933, 1933, 1922, 1921, 1922, 1933, 1934, 1934, 1923, 1922, 1923, 1934, 1935, 1935, 1924, 1923, 1924, 1935, 1936, 1936, 1925, 1924, 1925, 1936, 1937, 1937, 1926, 1925, 1926, 1937, 1938, 1938, 1927, 1926, 1927, 1938, 1939, 1939, 1928, 1927, 1928, 1939, 1940, 1940, 1929, 1928, 1929, 1940, 1941, 1941, 1930, 1929, 1930, 1941, 1787, 1787, 1787, 1930, 1379, 1391, 1942, 1942, 1931, 1379, 1931, 1942, 1943, 1943, 1932, 1931, 1932, 1943, 1944, 1944, 1933, 1932, 1933, 1944, 1945, 1945, 1934, 1933, 1934, 1945, 1946, 1946, 1935, 1934, 1935, 1946, 1947, 1947, 1936, 1935, 1936, 1947, 1948, 1948, 1937, 1936, 1937, 1948, 1949, 1949, 1938, 1937, 1938, 1949, 1950, 1950, 1939, 1938, 1939, 1950, 1951, 1951, 1940, 1939, 1940, 1951, 1952, 1952, 1941, 1940, 1941, 1952, 1787, 1787, 1787, 1941, 1391, 1403, 1953, 1953, 1942, 1391, 1942, 1953, 1954, 1954, 1943, 1942, 1943, 1954, 1955, 1955, 1944, 1943, 1944, 1955, 1956, 1956, 1945, 1944, 1945, 1956, 1957, 1957, 1946, 1945, 1946, 1957, 1958, 1958, 1947, 1946, 1947, 1958, 1959, 1959, 1948, 1947, 1948, 1959, 1960, 1960, 1949, 1948, 1949, 1960, 1961, 1961, 1950, 1949, 1950, 1961, 1962, 1962, 1951, 1950, 1951, 1962, 1963, 1963, 1952, 1951, 1952, 1963, 1787, 1787, 1787, 1952, 1403, 1415, 1964, 1964, 1953, 1403, 1953, 1964, 1965, 1965, 1954, 1953, 1954, 1965, 1966, 1966, 1955, 1954, 1955, 1966, 1967, 1967, 1956, 1955, 1956, 1967, 1968, 1968, 1957, 1956, 1957, 1968, 1969, 1969, 1958, 1957, 1958, 1969, 1970, 1970, 1959, 1958, 1959, 1970, 1971, 1971, 1960, 1959, 1960, 1971, 1972, 1972, 1961, 1960, 1961, 1972, 1973, 1973, 1962, 1961, 1962, 1973, 1974, 1974, 1963, 1962, 1963, 1974, 1787, 1787, 1787, 1963, 1415, 1427, 1975, 1975, 1964, 1415, 1964, 1975, 1976, 1976, 1965, 1964, 1965, 1976, 1977, 1977, 1966, 1965, 1966, 1977, 1978, 1978, 1967, 1966, 1967, 1978, 1979, 1979, 1968, 1967, 1968, 1979, 1980, 1980, 1969, 1968, 1969, 1980, 1981, 1981, 1970, 1969, 1970, 1981, 1982, 1982, 1971, 1970, 1971, 1982, 1983, 1983, 1972, 1971, 1972, 1983, 1984, 1984, 1973, 1972, 1973, 1984, 1985, 1985, 1974, 1973, 1974, 1985, 1787, 1787, 1787, 1974, 1427, 1439, 1986, 1986, 1975, 1427, 1975, 1986, 1987, 1987, 1976, 1975, 1976, 1987, 1988, 1988, 1977, 1976, 1977, 1988, 1989, 1989, 1978, 1977, 1978, 1989, 1990, 1990, 1979, 1978, 1979, 1990, 1991, 1991, 1980, 1979, 1980, 1991, 1992, 1992, 1981, 1980, 1981, 1992, 1993, 1993, 1982, 1981, 1982, 1993, 1994, 1994, 1983, 1982, 1983, 1994, 1995, 1995, 1984, 1983, 1984, 1995, 1996, 1996, 1985, 1984, 1985, 1996, 1787, 1787, 1787, 1985, 1439, 1451, 1997, 1997, 1986, 1439, 1986, 1997, 1998, 1998, 1987, 1986, 1987, 1998, 1999, 1999, 1988, 1987, 1988, 1999, 2000, 2000, 1989, 1988, 1989, 2000, 2001, 2001, 1990, 1989, 1990, 2001, 2002, 2002, 1991, 1990, 1991, 2002, 2003, 2003, 1992, 1991, 1992, 2003, 2004, 2004, 1993, 1992, 1993, 2004, 2005, 2005, 1994, 1993, 1994, 2005, 2006, 2006, 1995, 1994, 1995, 2006, 2007, 2007, 1996, 1995, 1996, 2007, 1787, 1787, 1787, 1996, 1451, 1463, 2008, 2008, 1997, 1451, 1997, 2008, 2009, 2009, 1998, 1997, 1998, 2009, 2010, 2010, 1999, 1998, 1999, 2010, 2011, 2011, 2000, 1999, 2000, 2011, 2012, 2012, 2001, 2000, 2001, 2012, 2013, 2013, 2002, 2001, 2002, 2013, 2014, 2014, 2003, 2002, 2003, 2014, 2015, 2015, 2004, 2003, 2004, 2015, 2016, 2016, 2005, 2004, 2005, 2016, 2017, 2017, 2006, 2005, 2006, 2017, 2018, 2018, 2007, 2006, 2007, 2018, 1787, 1787, 1787, 2007, 1463, 1475, 2019, 2019, 2008, 1463, 2008, 2019, 2020, 2020, 2009, 2008, 2009, 2020, 2021, 2021, 2010, 2009, 2010, 2021, 2022, 2022, 2011, 2010, 2011, 2022, 2023, 2023, 2012, 2011, 2012, 2023, 2024, 2024, 2013, 2012, 2013, 2024, 2025, 2025, 2014, 2013, 2014, 2025, 2026, 2026, 2015, 2014, 2015, 2026, 2027, 2027, 2016, 2015, 2016, 2027, 2028, 2028, 2017, 2016, 2017, 2028, 2029, 2029, 2018, 2017, 2018, 2029, 1787, 1787, 1787, 2018, 1475, 1487, 2030, 2030, 2019, 1475, 2019, 2030, 2031, 2031, 2020, 2019, 2020, 2031, 2032, 2032, 2021, 2020, 2021, 2032, 2033, 2033, 2022, 2021, 2022, 2033, 2034, 2034, 2023, 2022, 2023, 2034, 2035, 2035, 2024, 2023, 2024, 2035, 2036, 2036, 2025, 2024, 2025, 2036, 2037, 2037, 2026, 2025, 2026, 2037, 2038, 2038, 2027, 2026, 2027, 2038, 2039, 2039, 2028, 2027, 2028, 2039, 2040, 2040, 2029, 2028, 2029, 2040, 1787, 1787, 1787, 2029, 1487, 1499, 2041, 2041, 2030, 1487, 2030, 2041, 2042, 2042, 2031, 2030, 2031, 2042, 2043, 2043, 2032, 2031, 2032, 2043, 2044, 2044, 2033, 2032, 2033, 2044, 2045, 2045, 2034, 2033, 2034, 2045, 2046, 2046, 2035, 2034, 2035, 2046, 2047, 2047, 2036, 2035, 2036, 2047, 2048, 2048, 2037, 2036, 2037, 2048, 2049, 2049, 2038, 2037, 2038, 2049, 2050, 2050, 2039, 2038, 2039, 2050, 2051, 2051, 2040, 2039, 2040, 2051, 1787, 1787, 1787, 2040, 1499, 1511, 2052, 2052, 2041, 1499, 2041, 2052, 2053, 2053, 2042, 2041, 2042, 2053, 2054, 2054, 2043, 2042, 2043, 2054, 2055, 2055, 2044, 2043, 2044, 2055, 2056, 2056, 2045, 2044, 2045, 2056, 2057, 2057, 2046, 2045, 2046, 2057, 2058, 2058, 2047, 2046, 2047, 2058, 2059, 2059, 2048, 2047, 2048, 2059, 2060, 2060, 2049, 2048, 2049, 2060, 2061, 2061, 2050, 2049, 2050, 2061, 2062, 2062, 2051, 2050, 2051, 2062, 1787, 1787, 1787, 2051, 1511, 1523, 2063, 2063, 2052, 1511, 2052, 2063, 2064, 2064, 2053, 2052, 2053, 2064, 2065, 2065, 2054, 2053, 2054, 2065, 2066, 2066, 2055, 2054, 2055, 2066, 2067, 2067, 2056, 2055, 2056, 2067, 2068, 2068, 2057, 2056, 2057, 2068, 2069, 2069, 2058, 2057, 2058, 2069, 2070, 2070, 2059, 2058, 2059, 2070, 2071, 2071, 2060, 2059, 2060, 2071, 2072, 2072, 2061, 2060, 2061, 2072, 2073, 2073, 2062, 2061, 2062, 2073, 1787, 1787, 1787, 2062, 1523, 1535, 2074, 2074, 2063, 1523, 2063, 2074, 2075, 2075, 2064, 2063, 2064, 2075, 2076, 2076, 2065, 2064, 2065, 2076, 2077, 2077, 2066, 2065, 2066, 2077, 2078, 2078, 2067, 2066, 2067, 2078, 2079, 2079, 2068, 2067, 2068, 2079, 2080, 2080, 2069, 2068, 2069, 2080, 2081, 2081, 2070, 2069, 2070, 2081, 2082, 2082, 2071, 2070, 2071, 2082, 2083, 2083, 2072, 2071, 2072, 2083, 2084, 2084, 2073, 2072, 2073, 2084, 1787, 1787, 1787, 2073, 1535, 1547, 2085, 2085, 2074, 1535, 2074, 2085, 2086, 2086, 2075, 2074, 2075, 2086, 2087, 2087, 2076, 2075, 2076, 2087, 2088, 2088, 2077, 2076, 2077, 2088, 2089, 2089, 2078, 2077, 2078, 2089, 2090, 2090, 2079, 2078, 2079, 2090, 2091, 2091, 2080, 2079, 2080, 2091, 2092, 2092, 2081, 2080, 2081, 2092, 2093, 2093, 2082, 2081, 2082, 2093, 2094, 2094, 2083, 2082, 2083, 2094, 2095, 2095, 2084, 2083, 2084, 2095, 1787, 1787, 1787, 2084, 1547, 1559, 2096, 2096, 2085, 1547, 2085, 2096, 2097, 2097, 2086, 2085, 2086, 2097, 2098, 2098, 2087, 2086, 2087, 2098, 2099, 2099, 2088, 2087, 2088, 2099, 2100, 2100, 2089, 2088, 2089, 2100, 2101, 2101, 2090, 2089, 2090, 2101, 2102, 2102, 2091, 2090, 2091, 2102, 2103, 2103, 2092, 2091, 2092, 2103, 2104, 2104, 2093, 2092, 2093, 2104, 2105, 2105, 2094, 2093, 2094, 2105, 2106, 2106, 2095, 2094, 2095, 2106, 1787, 1787, 1787, 2095, 1559, 1571, 2107, 2107, 2096, 1559, 2096, 2107, 2108, 2108, 2097, 2096, 2097, 2108, 2109, 2109, 2098, 2097, 2098, 2109, 2110, 2110, 2099, 2098, 2099, 2110, 2111, 2111, 2100, 2099, 2100, 2111, 2112, 2112, 2101, 2100, 2101, 2112, 2113, 2113, 2102, 2101, 2102, 2113, 2114, 2114, 2103, 2102, 2103, 2114, 2115, 2115, 2104, 2103, 2104, 2115, 2116, 2116, 2105, 2104, 2105, 2116, 2117, 2117, 2106, 2105, 2106, 2117, 1787, 1787, 1787, 2106, 1571, 1583, 2118, 2118, 2107, 1571, 2107, 2118, 2119, 2119, 2108, 2107, 2108, 2119, 2120, 2120, 2109, 2108, 2109, 2120, 2121, 2121, 2110, 2109, 2110, 2121, 2122, 2122, 2111, 2110, 2111, 2122, 2123, 2123, 2112, 2111, 2112, 2123, 2124, 2124, 2113, 2112, 2113, 2124, 2125, 2125, 2114, 2113, 2114, 2125, 2126, 2126, 2115, 2114, 2115, 2126, 2127, 2127, 2116, 2115, 2116, 2127, 2128, 2128, 2117, 2116, 2117, 2128, 1787, 1787, 1787, 2117, 1583, 1595, 2129, 2129, 2118, 1583, 2118, 2129, 2130, 2130, 2119, 2118, 2119, 2130, 2131, 2131, 2120, 2119, 2120, 2131, 2132, 2132, 2121, 2120, 2121, 2132, 2133, 2133, 2122, 2121, 2122, 2133, 2134, 2134, 2123, 2122, 2123, 2134, 2135, 2135, 2124, 2123, 2124, 2135, 2136, 2136, 2125, 2124, 2125, 2136, 2137, 2137, 2126, 2125, 2126, 2137, 2138, 2138, 2127, 2126, 2127, 2138, 2139, 2139, 2128, 2127, 2128, 2139, 1787, 1787, 1787, 2128, 1595, 1607, 2140, 2140, 2129, 1595, 2129, 2140, 2141, 2141, 2130, 2129, 2130, 2141, 2142, 2142, 2131, 2130, 2131, 2142, 2143, 2143, 2132, 2131, 2132, 2143, 2144, 2144, 2133, 2132, 2133, 2144, 2145, 2145, 2134, 2133, 2134, 2145, 2146, 2146, 2135, 2134, 2135, 2146, 2147, 2147, 2136, 2135, 2136, 2147, 2148, 2148, 2137, 2136, 2137, 2148, 2149, 2149, 2138, 2137, 2138, 2149, 2150, 2150, 2139, 2138, 2139, 2150, 1787, 1787, 1787, 2139, 1607, 1619, 2151, 2151, 2140, 1607, 2140, 2151, 2152, 2152, 2141, 2140, 2141, 2152, 2153, 2153, 2142, 2141, 2142, 2153, 2154, 2154, 2143, 2142, 2143, 2154, 2155, 2155, 2144, 2143, 2144, 2155, 2156, 2156, 2145, 2144, 2145, 2156, 2157, 2157, 2146, 2145, 2146, 2157, 2158, 2158, 2147, 2146, 2147, 2158, 2159, 2159, 2148, 2147, 2148, 2159, 2160, 2160, 2149, 2148, 2149, 2160, 2161, 2161, 2150, 2149, 2150, 2161, 1787, 1787, 1787, 2150, 1619, 1631, 2162, 2162, 2151, 1619, 2151, 2162, 2163, 2163, 2152, 2151, 2152, 2163, 2164, 2164, 2153, 2152, 2153, 2164, 2165, 2165, 2154, 2153, 2154, 2165, 2166, 2166, 2155, 2154, 2155, 2166, 2167, 2167, 2156, 2155, 2156, 2167, 2168, 2168, 2157, 2156, 2157, 2168, 2169, 2169, 2158, 2157, 2158, 2169, 2170, 2170, 2159, 2158, 2159, 2170, 2171, 2171, 2160, 2159, 2160, 2171, 2172, 2172, 2161, 2160, 2161, 2172, 1787, 1787, 1787, 2161, 1631, 1643, 2173, 2173, 2162, 1631, 2162, 2173, 2174, 2174, 2163, 2162, 2163, 2174, 2175, 2175, 2164, 2163, 2164, 2175, 2176, 2176, 2165, 2164, 2165, 2176, 2177, 2177, 2166, 2165, 2166, 2177, 2178, 2178, 2167, 2166, 2167, 2178, 2179, 2179, 2168, 2167, 2168, 2179, 2180, 2180, 2169, 2168, 2169, 2180, 2181, 2181, 2170, 2169, 2170, 2181, 2182, 2182, 2171, 2170, 2171, 2182, 2183, 2183, 2172, 2171, 2172, 2183, 1787, 1787, 1787, 2172, 1643, 1655, 2184, 2184, 2173, 1643, 2173, 2184, 2185, 2185, 2174, 2173, 2174, 2185, 2186, 2186, 2175, 2174, 2175, 2186, 2187, 2187, 2176, 2175, 2176, 2187, 2188, 2188, 2177, 2176, 2177, 2188, 2189, 2189, 2178, 2177, 2178, 2189, 2190, 2190, 2179, 2178, 2179, 2190, 2191, 2191, 2180, 2179, 2180, 2191, 2192, 2192, 2181, 2180, 2181, 2192, 2193, 2193, 2182, 2181, 2182, 2193, 2194, 2194, 2183, 2182, 2183, 2194, 1787, 1787, 1787, 2183, 1655, 1667, 2195, 2195, 2184, 1655, 2184, 2195, 2196, 2196, 2185, 2184, 2185, 2196, 2197, 2197, 2186, 2185, 2186, 2197, 2198, 2198, 2187, 2186, 2187, 2198, 2199, 2199, 2188, 2187, 2188, 2199, 2200, 2200, 2189, 2188, 2189, 2200, 2201, 2201, 2190, 2189, 2190, 2201, 2202, 2202, 2191, 2190, 2191, 2202, 2203, 2203, 2192, 2191, 2192, 2203, 2204, 2204, 2193, 2192, 2193, 2204, 2205, 2205, 2194, 2193, 2194, 2205, 1787, 1787, 1787, 2194, 1667, 1679, 2206, 2206, 2195, 1667, 2195, 2206, 2207, 2207, 2196, 2195, 2196, 2207, 2208, 2208, 2197, 2196, 2197, 2208, 2209, 2209, 2198, 2197, 2198, 2209, 2210, 2210, 2199, 2198, 2199, 2210, 2211, 2211, 2200, 2199, 2200, 2211, 2212, 2212, 2201, 2200, 2201, 2212, 2213, 2213, 2202, 2201, 2202, 2213, 2214, 2214, 2203, 2202, 2203, 2214, 2215, 2215, 2204, 2203, 2204, 2215, 2216, 2216, 2205, 2204, 2205, 2216, 1787, 1787, 1787, 2205, 1679, 1691, 2217, 2217, 2206, 1679, 2206, 2217, 2218, 2218, 2207, 2206, 2207, 2218, 2219, 2219, 2208, 2207, 2208, 2219, 2220, 2220, 2209, 2208, 2209, 2220, 2221, 2221, 2210, 2209, 2210, 2221, 2222, 2222, 2211, 2210, 2211, 2222, 2223, 2223, 2212, 2211, 2212, 2223, 2224, 2224, 2213, 2212, 2213, 2224, 2225, 2225, 2214, 2213, 2214, 2225, 2226, 2226, 2215, 2214, 2215, 2226, 2227, 2227, 2216, 2215, 2216, 2227, 1787, 1787, 1787, 2216, 1691, 1703, 2228, 2228, 2217, 1691, 2217, 2228, 2229, 2229, 2218, 2217, 2218, 2229, 2230, 2230, 2219, 2218, 2219, 2230, 2231, 2231, 2220, 2219, 2220, 2231, 2232, 2232, 2221, 2220, 2221, 2232, 2233, 2233, 2222, 2221, 2222, 2233, 2234, 2234, 2223, 2222, 2223, 2234, 2235, 2235, 2224, 2223, 2224, 2235, 2236, 2236, 2225, 2224, 2225, 2236, 2237, 2237, 2226, 2225, 2226, 2237, 2238, 2238, 2227, 2226, 2227, 2238, 1787, 1787, 1787, 2227, 1703, 1715, 2239, 2239, 2228, 1703, 2228, 2239, 2240, 2240, 2229, 2228, 2229, 2240, 2241, 2241, 2230, 2229, 2230, 2241, 2242, 2242, 2231, 2230, 2231, 2242, 2243, 2243, 2232, 2231, 2232, 2243, 2244, 2244, 2233, 2232, 2233, 2244, 2245, 2245, 2234, 2233, 2234, 2245, 2246, 2246, 2235, 2234, 2235, 2246, 2247, 2247, 2236, 2235, 2236, 2247, 2248, 2248, 2237, 2236, 2237, 2248, 2249, 2249, 2238, 2237, 2238, 2249, 1787, 1787, 1787, 2238, 1715, 1727, 2250, 2250, 2239, 1715, 2239, 2250, 2251, 2251, 2240, 2239, 2240, 2251, 2252, 2252, 2241, 2240, 2241, 2252, 2253, 2253, 2242, 2241, 2242, 2253, 2254, 2254, 2243, 2242, 2243, 2254, 2255, 2255, 2244, 2243, 2244, 2255, 2256, 2256, 2245, 2244, 2245, 2256, 2257, 2257, 2246, 2245, 2246, 2257, 2258, 2258, 2247, 2246, 2247, 2258, 2259, 2259, 2248, 2247, 2248, 2259, 2260, 2260, 2249, 2248, 2249, 2260, 1787, 1787, 1787, 2249, 1727, 1739, 2261, 2261, 2250, 1727, 2250, 2261, 2262, 2262, 2251, 2250, 2251, 2262, 2263, 2263, 2252, 2251, 2252, 2263, 2264, 2264, 2253, 2252, 2253, 2264, 2265, 2265, 2254, 2253, 2254, 2265, 2266, 2266, 2255, 2254, 2255, 2266, 2267, 2267, 2256, 2255, 2256, 2267, 2268, 2268, 2257, 2256, 2257, 2268, 2269, 2269, 2258, 2257, 2258, 2269, 2270, 2270, 2259, 2258, 2259, 2270, 2271, 2271, 2260, 2259, 2260, 2271, 1787, 1787, 1787, 2260, 1739, 1751, 2272, 2272, 2261, 1739, 2261, 2272, 2273, 2273, 2262, 2261, 2262, 2273, 2274, 2274, 2263, 2262, 2263, 2274, 2275, 2275, 2264, 2263, 2264, 2275, 2276, 2276, 2265, 2264, 2265, 2276, 2277, 2277, 2266, 2265, 2266, 2277, 2278, 2278, 2267, 2266, 2267, 2278, 2279, 2279, 2268, 2267, 2268, 2279, 2280, 2280, 2269, 2268, 2269, 2280, 2281, 2281, 2270, 2269, 2270, 2281, 2282, 2282, 2271, 2270, 2271, 2282, 1787, 1787, 1787, 2271, 1751, 1763, 2283, 2283, 2272, 1751, 2272, 2283, 2284, 2284, 2273, 2272, 2273, 2284, 2285, 2285, 2274, 2273, 2274, 2285, 2286, 2286, 2275, 2274, 2275, 2286, 2287, 2287, 2276, 2275, 2276, 2287, 2288, 2288, 2277, 2276, 2277, 2288, 2289, 2289, 2278, 2277, 2278, 2289, 2290, 2290, 2279, 2278, 2279, 2290, 2291, 2291, 2280, 2279, 2280, 2291, 2292, 2292, 2281, 2280, 2281, 2292, 2293, 2293, 2282, 2281, 2282, 2293, 1787, 1787, 1787, 2282, 1763, 1775, 2294, 2294, 2283, 1763, 2283, 2294, 2295, 2295, 2284, 2283, 2284, 2295, 2296, 2296, 2285, 2284, 2285, 2296, 2297, 2297, 2286, 2285, 2286, 2297, 2298, 2298, 2287, 2286, 2287, 2298, 2299, 2299, 2288, 2287, 2288, 2299, 2300, 2300, 2289, 2288, 2289, 2300, 2301, 2301, 2290, 2289, 2290, 2301, 2302, 2302, 2291, 2290, 2291, 2302, 2303, 2303, 2292, 2291, 2292, 2303, 2304, 2304, 2293, 2292, 2293, 2304, 1787, 1787, 1787, 2293, 1775, 1211, 1776, 1776, 2294, 1775, 2294, 1776, 1777, 1777, 2295, 2294, 2295, 1777, 1778, 1778, 2296, 2295, 2296, 1778, 1779, 1779, 2297, 2296, 2297, 1779, 1780, 1780, 2298, 2297, 2298, 1780, 1781, 1781, 2299, 2298, 2299, 1781, 1782, 1782, 2300, 2299, 2300, 1782, 1783, 1783, 2301, 2300, 2301, 1783, 1784, 1784, 2302, 2301, 2302, 1784, 1785, 1785, 2303, 2302, 2303, 1785, 1786, 1786, 2304, 2303, 2304, 1786, 1787, 1787, 1787, 2304, 2305, 2318, 2319, 2319, 2306, 2305, 2306, 2319, 2320, 2320, 2307, 2306, 2307, 2320, 2321, 2321, 2308, 2307, 2308, 2321, 2322, 2322, 2309, 2308, 2309, 2322, 2323, 2323, 2310, 2309, 2310, 2323, 2324, 2324, 2311, 2310, 2311, 2324, 2325, 2325, 2312, 2311, 2312, 2325, 2326, 2326, 2313, 2312, 2313, 2326, 2327, 2327, 2314, 2313, 2314, 2327, 2328, 2328, 2315, 2314, 2315, 2328, 2329, 2329, 2316, 2315, 2316, 2329, 2330, 2330, 2317, 2316, 2318, 2331, 2332, 2332, 2319, 2318, 2319, 2332, 2333, 2333, 2320, 2319, 2320, 2333, 2334, 2334, 2321, 2320, 2321, 2334, 2335, 2335, 2322, 2321, 2322, 2335, 2336, 2336, 2323, 2322, 2323, 2336, 2337, 2337, 2324, 2323, 2324, 2337, 2338, 2338, 2325, 2324, 2325, 2338, 2339, 2339, 2326, 2325, 2326, 2339, 2340, 2340, 2327, 2326, 2327, 2340, 2341, 2341, 2328, 2327, 2328, 2341, 2342, 2342, 2329, 2328, 2329, 2342, 2343, 2343, 2330, 2329, 2331, 2344, 2345, 2345, 2332, 2331, 2332, 2345, 2346, 2346, 2333, 2332, 2333, 2346, 2347, 2347, 2334, 2333, 2334, 2347, 2348, 2348, 2335, 2334, 2335, 2348, 2349, 2349, 2336, 2335, 2336, 2349, 2350, 2350, 2337, 2336, 2337, 2350, 2351, 2351, 2338, 2337, 2338, 2351, 2352, 2352, 2339, 2338, 2339, 2352, 2353, 2353, 2340, 2339, 2340, 2353, 2354, 2354, 2341, 2340, 2341, 2354, 2355, 2355, 2342, 2341, 2342, 2355, 2356, 2356, 2343, 2342, 2344, 2357, 2358, 2358, 2345, 2344, 2345, 2358, 2359, 2359, 2346, 2345, 2346, 2359, 2360, 2360, 2347, 2346, 2347, 2360, 2361, 2361, 2348, 2347, 2348, 2361, 2362, 2362, 2349, 2348, 2349, 2362, 2363, 2363, 2350, 2349, 2350, 2363, 2364, 2364, 2351, 2350, 2351, 2364, 2365, 2365, 2352, 2351, 2352, 2365, 2366, 2366, 2353, 2352, 2353, 2366, 2367, 2367, 2354, 2353, 2354, 2367, 2368, 2368, 2355, 2354, 2355, 2368, 2369, 2369, 2356, 2355, 2357, 2370, 2371, 2371, 2358, 2357, 2358, 2371, 2372, 2372, 2359, 2358, 2359, 2372, 2373, 2373, 2360, 2359, 2360, 2373, 2374, 2374, 2361, 2360, 2361, 2374, 2375, 2375, 2362, 2361, 2362, 2375, 2376, 2376, 2363, 2362, 2363, 2376, 2377, 2377, 2364, 2363, 2364, 2377, 2378, 2378, 2365, 2364, 2365, 2378, 2379, 2379, 2366, 2365, 2366, 2379, 2380, 2380, 2367, 2366, 2367, 2380, 2381, 2381, 2368, 2367, 2368, 2381, 2382, 2382, 2369, 2368, 2370, 2383, 2384, 2384, 2371, 2370, 2371, 2384, 2385, 2385, 2372, 2371, 2372, 2385, 2386, 2386, 2373, 2372, 2373, 2386, 2387, 2387, 2374, 2373, 2374, 2387, 2388, 2388, 2375, 2374, 2375, 2388, 2389, 2389, 2376, 2375, 2376, 2389, 2390, 2390, 2377, 2376, 2377, 2390, 2391, 2391, 2378, 2377, 2378, 2391, 2392, 2392, 2379, 2378, 2379, 2392, 2393, 2393, 2380, 2379, 2380, 2393, 2394, 2394, 2381, 2380, 2381, 2394, 2395, 2395, 2382, 2381, 2383, 2396, 2397, 2397, 2384, 2383, 2384, 2397, 2398, 2398, 2385, 2384, 2385, 2398, 2399, 2399, 2386, 2385, 2386, 2399, 2400, 2400, 2387, 2386, 2387, 2400, 2401, 2401, 2388, 2387, 2388, 2401, 2402, 2402, 2389, 2388, 2389, 2402, 2403, 2403, 2390, 2389, 2390, 2403, 2404, 2404, 2391, 2390, 2391, 2404, 2405, 2405, 2392, 2391, 2392, 2405, 2406, 2406, 2393, 2392, 2393, 2406, 2407, 2407, 2394, 2393, 2394, 2407, 2408, 2408, 2395, 2394, 2396, 2409, 2410, 2410, 2397, 2396, 2397, 2410, 2411, 2411, 2398, 2397, 2398, 2411, 2412, 2412, 2399, 2398, 2399, 2412, 2413, 2413, 2400, 2399, 2400, 2413, 2414, 2414, 2401, 2400, 2401, 2414, 2415, 2415, 2402, 2401, 2402, 2415, 2416, 2416, 2403, 2402, 2403, 2416, 2417, 2417, 2404, 2403, 2404, 2417, 2418, 2418, 2405, 2404, 2405, 2418, 2419, 2419, 2406, 2405, 2406, 2419, 2420, 2420, 2407, 2406, 2407, 2420, 2421, 2421, 2408, 2407, 2409, 2422, 2423, 2423, 2410, 2409, 2410, 2423, 2424, 2424, 2411, 2410, 2411, 2424, 2425, 2425, 2412, 2411, 2412, 2425, 2426, 2426, 2413, 2412, 2413, 2426, 2427, 2427, 2414, 2413, 2414, 2427, 2428, 2428, 2415, 2414, 2415, 2428, 2429, 2429, 2416, 2415, 2416, 2429, 2430, 2430, 2417, 2416, 2417, 2430, 2431, 2431, 2418, 2417, 2418, 2431, 2432, 2432, 2419, 2418, 2419, 2432, 2433, 2433, 2420, 2419, 2420, 2433, 2434, 2434, 2421, 2420, 2422, 2435, 2436, 2436, 2423, 2422, 2423, 2436, 2437, 2437, 2424, 2423, 2424, 2437, 2438, 2438, 2425, 2424, 2425, 2438, 2439, 2439, 2426, 2425, 2426, 2439, 2440, 2440, 2427, 2426, 2427, 2440, 2441, 2441, 2428, 2427, 2428, 2441, 2442, 2442, 2429, 2428, 2429, 2442, 2443, 2443, 2430, 2429, 2430, 2443, 2444, 2444, 2431, 2430, 2431, 2444, 2445, 2445, 2432, 2431, 2432, 2445, 2446, 2446, 2433, 2432, 2433, 2446, 2447, 2447, 2434, 2433, 2435, 2448, 2449, 2449, 2436, 2435, 2436, 2449, 2450, 2450, 2437, 2436, 2437, 2450, 2451, 2451, 2438, 2437, 2438, 2451, 2452, 2452, 2439, 2438, 2439, 2452, 2453, 2453, 2440, 2439, 2440, 2453, 2454, 2454, 2441, 2440, 2441, 2454, 2455, 2455, 2442, 2441, 2442, 2455, 2456, 2456, 2443, 2442, 2443, 2456, 2457, 2457, 2444, 2443, 2444, 2457, 2458, 2458, 2445, 2444, 2445, 2458, 2459, 2459, 2446, 2445, 2446, 2459, 2460, 2460, 2447, 2446, 2448, 2461, 2462, 2462, 2449, 2448, 2449, 2462, 2463, 2463, 2450, 2449, 2450, 2463, 2464, 2464, 2451, 2450, 2451, 2464, 2465, 2465, 2452, 2451, 2452, 2465, 2466, 2466, 2453, 2452, 2453, 2466, 2467, 2467, 2454, 2453, 2454, 2467, 2468, 2468, 2455, 2454, 2455, 2468, 2469, 2469, 2456, 2455, 2456, 2469, 2470, 2470, 2457, 2456, 2457, 2470, 2471, 2471, 2458, 2457, 2458, 2471, 2472, 2472, 2459, 2458, 2459, 2472, 2473, 2473, 2460, 2459, 2461, 2474, 2475, 2475, 2462, 2461, 2462, 2475, 2476, 2476, 2463, 2462, 2463, 2476, 2477, 2477, 2464, 2463, 2464, 2477, 2478, 2478, 2465, 2464, 2465, 2478, 2479, 2479, 2466, 2465, 2466, 2479, 2480, 2480, 2467, 2466, 2467, 2480, 2481, 2481, 2468, 2467, 2468, 2481, 2482, 2482, 2469, 2468, 2469, 2482, 2483, 2483, 2470, 2469, 2470, 2483, 2484, 2484, 2471, 2470, 2471, 2484, 2485, 2485, 2472, 2471, 2472, 2485, 2486, 2486, 2473, 2472, 2474, 2487, 2488, 2488, 2475, 2474, 2475, 2488, 2489, 2489, 2476, 2475, 2476, 2489, 2490, 2490, 2477, 2476, 2477, 2490, 2491, 2491, 2478, 2477, 2478, 2491, 2492, 2492, 2479, 2478, 2479, 2492, 2493, 2493, 2480, 2479, 2480, 2493, 2494, 2494, 2481, 2480, 2481, 2494, 2495, 2495, 2482, 2481, 2482, 2495, 2496, 2496, 2483, 2482, 2483, 2496, 2497, 2497, 2484, 2483, 2484, 2497, 2498, 2498, 2485, 2484, 2485, 2498, 2499, 2499, 2486, 2485, 2487, 2500, 2501, 2501, 2488, 2487, 2488, 2501, 2502, 2502, 2489, 2488, 2489, 2502, 2503, 2503, 2490, 2489, 2490, 2503, 2504, 2504, 2491, 2490, 2491, 2504, 2505, 2505, 2492, 2491, 2492, 2505, 2506, 2506, 2493, 2492, 2493, 2506, 2507, 2507, 2494, 2493, 2494, 2507, 2508, 2508, 2495, 2494, 2495, 2508, 2509, 2509, 2496, 2495, 2496, 2509, 2510, 2510, 2497, 2496, 2497, 2510, 2511, 2511, 2498, 2497, 2498, 2511, 2512, 2512, 2499, 2498, 2500, 2513, 2514, 2514, 2501, 2500, 2501, 2514, 2515, 2515, 2502, 2501, 2502, 2515, 2516, 2516, 2503, 2502, 2503, 2516, 2517, 2517, 2504, 2503, 2504, 2517, 2518, 2518, 2505, 2504, 2505, 2518, 2519, 2519, 2506, 2505, 2506, 2519, 2520, 2520, 2507, 2506, 2507, 2520, 2521, 2521, 2508, 2507, 2508, 2521, 2522, 2522, 2509, 2508, 2509, 2522, 2523, 2523, 2510, 2509, 2510, 2523, 2524, 2524, 2511, 2510, 2511, 2524, 2525, 2525, 2512, 2511, 2513, 2526, 2527, 2527, 2514, 2513, 2514, 2527, 2528, 2528, 2515, 2514, 2515, 2528, 2529, 2529, 2516, 2515, 2516, 2529, 2530, 2530, 2517, 2516, 2517, 2530, 2531, 2531, 2518, 2517, 2518, 2531, 2532, 2532, 2519, 2518, 2519, 2532, 2533, 2533, 2520, 2519, 2520, 2533, 2534, 2534, 2521, 2520, 2521, 2534, 2535, 2535, 2522, 2521, 2522, 2535, 2536, 2536, 2523, 2522, 2523, 2536, 2537, 2537, 2524, 2523, 2524, 2537, 2538, 2538, 2525, 2524, 2526, 2539, 2540, 2540, 2527, 2526, 2527, 2540, 2541, 2541, 2528, 2527, 2528, 2541, 2542, 2542, 2529, 2528, 2529, 2542, 2543, 2543, 2530, 2529, 2530, 2543, 2544, 2544, 2531, 2530, 2531, 2544, 2545, 2545, 2532, 2531, 2532, 2545, 2546, 2546, 2533, 2532, 2533, 2546, 2547, 2547, 2534, 2533, 2534, 2547, 2548, 2548, 2535, 2534, 2535, 2548, 2549, 2549, 2536, 2535, 2536, 2549, 2550, 2550, 2537, 2536, 2537, 2550, 2551, 2551, 2538, 2537, 2539, 2552, 2553, 2553, 2540, 2539, 2540, 2553, 2554, 2554, 2541, 2540, 2541, 2554, 2555, 2555, 2542, 2541, 2542, 2555, 2556, 2556, 2543, 2542, 2543, 2556, 2557, 2557, 2544, 2543, 2544, 2557, 2558, 2558, 2545, 2544, 2545, 2558, 2559, 2559, 2546, 2545, 2546, 2559, 2560, 2560, 2547, 2546, 2547, 2560, 2561, 2561, 2548, 2547, 2548, 2561, 2562, 2562, 2549, 2548, 2549, 2562, 2563, 2563, 2550, 2549, 2550, 2563, 2564, 2564, 2551, 2550, 2552, 2565, 2566, 2566, 2553, 2552, 2553, 2566, 2567, 2567, 2554, 2553, 2554, 2567, 2568, 2568, 2555, 2554, 2555, 2568, 2569, 2569, 2556, 2555, 2556, 2569, 2570, 2570, 2557, 2556, 2557, 2570, 2571, 2571, 2558, 2557, 2558, 2571, 2572, 2572, 2559, 2558, 2559, 2572, 2573, 2573, 2560, 2559, 2560, 2573, 2574, 2574, 2561, 2560, 2561, 2574, 2575, 2575, 2562, 2561, 2562, 2575, 2576, 2576, 2563, 2562, 2563, 2576, 2577, 2577, 2564, 2563, 2565, 2578, 2579, 2579, 2566, 2565, 2566, 2579, 2580, 2580, 2567, 2566, 2567, 2580, 2581, 2581, 2568, 2567, 2568, 2581, 2582, 2582, 2569, 2568, 2569, 2582, 2583, 2583, 2570, 2569, 2570, 2583, 2584, 2584, 2571, 2570, 2571, 2584, 2585, 2585, 2572, 2571, 2572, 2585, 2586, 2586, 2573, 2572, 2573, 2586, 2587, 2587, 2574, 2573, 2574, 2587, 2588, 2588, 2575, 2574, 2575, 2588, 2589, 2589, 2576, 2575, 2576, 2589, 2590, 2590, 2577, 2576, 2578, 2591, 2592, 2592, 2579, 2578, 2579, 2592, 2593, 2593, 2580, 2579, 2580, 2593, 2594, 2594, 2581, 2580, 2581, 2594, 2595, 2595, 2582, 2581, 2582, 2595, 2596, 2596, 2583, 2582, 2583, 2596, 2597, 2597, 2584, 2583, 2584, 2597, 2598, 2598, 2585, 2584, 2585, 2598, 2599, 2599, 2586, 2585, 2586, 2599, 2600, 2600, 2587, 2586, 2587, 2600, 2601, 2601, 2588, 2587, 2588, 2601, 2602, 2602, 2589, 2588, 2589, 2602, 2603, 2603, 2590, 2589, 2591, 2604, 2605, 2605, 2592, 2591, 2592, 2605, 2606, 2606, 2593, 2592, 2593, 2606, 2607, 2607, 2594, 2593, 2594, 2607, 2608, 2608, 2595, 2594, 2595, 2608, 2609, 2609, 2596, 2595, 2596, 2609, 2610, 2610, 2597, 2596, 2597, 2610, 2611, 2611, 2598, 2597, 2598, 2611, 2612, 2612, 2599, 2598, 2599, 2612, 2613, 2613, 2600, 2599, 2600, 2613, 2614, 2614, 2601, 2600, 2601, 2614, 2615, 2615, 2602, 2601, 2602, 2615, 2616, 2616, 2603, 2602, 2604, 2305, 2306, 2306, 2605, 2604, 2605, 2306, 2307, 2307, 2606, 2605, 2606, 2307, 2308, 2308, 2607, 2606, 2607, 2308, 2309, 2309, 2608, 2607, 2608, 2309, 2310, 2310, 2609, 2608, 2609, 2310, 2311, 2311, 2610, 2609, 2610, 2311, 2312, 2312, 2611, 2610, 2611, 2312, 2313, 2313, 2612, 2611, 2612, 2313, 2314, 2314, 2613, 2612, 2613, 2314, 2315, 2315, 2614, 2613, 2614, 2315, 2316, 2316, 2615, 2614, 2615, 2316, 2317, 2317, 2616, 2615, 2317, 2330, 2629, 2629, 2617, 2317, 2617, 2629, 2630, 2630, 2618, 2617, 2618, 2630, 2631, 2631, 2619, 2618, 2619, 2631, 2632, 2632, 2620, 2619, 2620, 2632, 2633, 2633, 2621, 2620, 2621, 2633, 2634, 2634, 2622, 2621, 2622, 2634, 2635, 2635, 2623, 2622, 2623, 2635, 2636, 2636, 2624, 2623, 2624, 2636, 2637, 2637, 2625, 2624, 2625, 2637, 2638, 2638, 2626, 2625, 2626, 2638, 2639, 2639, 2627, 2626, 2627, 2639, 2640, 2640, 2628, 2627, 2330, 2343, 2641, 2641, 2629, 2330, 2629, 2641, 2642, 2642, 2630, 2629, 2630, 2642, 2643, 2643, 2631, 2630, 2631, 2643, 2644, 2644, 2632, 2631, 2632, 2644, 2645, 2645, 2633, 2632, 2633, 2645, 2646, 2646, 2634, 2633, 2634, 2646, 2647, 2647, 2635, 2634, 2635, 2647, 2648, 2648, 2636, 2635, 2636, 2648, 2649, 2649, 2637, 2636, 2637, 2649, 2650, 2650, 2638, 2637, 2638, 2650, 2651, 2651, 2639, 2638, 2639, 2651, 2652, 2652, 2640, 2639, 2343, 2356, 2653, 2653, 2641, 2343, 2641, 2653, 2654, 2654, 2642, 2641, 2642, 2654, 2655, 2655, 2643, 2642, 2643, 2655, 2656, 2656, 2644, 2643, 2644, 2656, 2657, 2657, 2645, 2644, 2645, 2657, 2658, 2658, 2646, 2645, 2646, 2658, 2659, 2659, 2647, 2646, 2647, 2659, 2660, 2660, 2648, 2647, 2648, 2660, 2661, 2661, 2649, 2648, 2649, 2661, 2662, 2662, 2650, 2649, 2650, 2662, 2663, 2663, 2651, 2650, 2651, 2663, 2664, 2664, 2652, 2651, 2356, 2369, 2665, 2665, 2653, 2356, 2653, 2665, 2666, 2666, 2654, 2653, 2654, 2666, 2667, 2667, 2655, 2654, 2655, 2667, 2668, 2668, 2656, 2655, 2656, 2668, 2669, 2669, 2657, 2656, 2657, 2669, 2670, 2670, 2658, 2657, 2658, 2670, 2671, 2671, 2659, 2658, 2659, 2671, 2672, 2672, 2660, 2659, 2660, 2672, 2673, 2673, 2661, 2660, 2661, 2673, 2674, 2674, 2662, 2661, 2662, 2674, 2675, 2675, 2663, 2662, 2663, 2675, 2676, 2676, 2664, 2663, 2369, 2382, 2677, 2677, 2665, 2369, 2665, 2677, 2678, 2678, 2666, 2665, 2666, 2678, 2679, 2679, 2667, 2666, 2667, 2679, 2680, 2680, 2668, 2667, 2668, 2680, 2681, 2681, 2669, 2668, 2669, 2681, 2682, 2682, 2670, 2669, 2670, 2682, 2683, 2683, 2671, 2670, 2671, 2683, 2684, 2684, 2672, 2671, 2672, 2684, 2685, 2685, 2673, 2672, 2673, 2685, 2686, 2686, 2674, 2673, 2674, 2686, 2687, 2687, 2675, 2674, 2675, 2687, 2688, 2688, 2676, 2675, 2382, 2395, 2689, 2689, 2677, 2382, 2677, 2689, 2690, 2690, 2678, 2677, 2678, 2690, 2691, 2691, 2679, 2678, 2679, 2691, 2692, 2692, 2680, 2679, 2680, 2692, 2693, 2693, 2681, 2680, 2681, 2693, 2694, 2694, 2682, 2681, 2682, 2694, 2695, 2695, 2683, 2682, 2683, 2695, 2696, 2696, 2684, 2683, 2684, 2696, 2697, 2697, 2685, 2684, 2685, 2697, 2698, 2698, 2686, 2685, 2686, 2698, 2699, 2699, 2687, 2686, 2687, 2699, 2700, 2700, 2688, 2687, 2395, 2408, 2701, 2701, 2689, 2395, 2689, 2701, 2702, 2702, 2690, 2689, 2690, 2702, 2703, 2703, 2691, 2690, 2691, 2703, 2704, 2704, 2692, 2691, 2692, 2704, 2705, 2705, 2693, 2692, 2693, 2705, 2706, 2706, 2694, 2693, 2694, 2706, 2707, 2707, 2695, 2694, 2695, 2707, 2708, 2708, 2696, 2695, 2696, 2708, 2709, 2709, 2697, 2696, 2697, 2709, 2710, 2710, 2698, 2697, 2698, 2710, 2711, 2711, 2699, 2698, 2699, 2711, 2712, 2712, 2700, 2699, 2408, 2421, 2713, 2713, 2701, 2408, 2701, 2713, 2714, 2714, 2702, 2701, 2702, 2714, 2715, 2715, 2703, 2702, 2703, 2715, 2716, 2716, 2704, 2703, 2704, 2716, 2717, 2717, 2705, 2704, 2705, 2717, 2718, 2718, 2706, 2705, 2706, 2718, 2719, 2719, 2707, 2706, 2707, 2719, 2720, 2720, 2708, 2707, 2708, 2720, 2721, 2721, 2709, 2708, 2709, 2721, 2722, 2722, 2710, 2709, 2710, 2722, 2723, 2723, 2711, 2710, 2711, 2723, 2724, 2724, 2712, 2711, 2421, 2434, 2725, 2725, 2713, 2421, 2713, 2725, 2726, 2726, 2714, 2713, 2714, 2726, 2727, 2727, 2715, 2714, 2715, 2727, 2728, 2728, 2716, 2715, 2716, 2728, 2729, 2729, 2717, 2716, 2717, 2729, 2730, 2730, 2718, 2717, 2718, 2730, 2731, 2731, 2719, 2718, 2719, 2731, 2732, 2732, 2720, 2719, 2720, 2732, 2733, 2733, 2721, 2720, 2721, 2733, 2734, 2734, 2722, 2721, 2722, 2734, 2735, 2735, 2723, 2722, 2723, 2735, 2736, 2736, 2724, 2723, 2434, 2447, 2737, 2737, 2725, 2434, 2725, 2737, 2738, 2738, 2726, 2725, 2726, 2738, 2739, 2739, 2727, 2726, 2727, 2739, 2740, 2740, 2728, 2727, 2728, 2740, 2741, 2741, 2729, 2728, 2729, 2741, 2742, 2742, 2730, 2729, 2730, 2742, 2743, 2743, 2731, 2730, 2731, 2743, 2744, 2744, 2732, 2731, 2732, 2744, 2745, 2745, 2733, 2732, 2733, 2745, 2746, 2746, 2734, 2733, 2734, 2746, 2747, 2747, 2735, 2734, 2735, 2747, 2748, 2748, 2736, 2735, 2447, 2460, 2749, 2749, 2737, 2447, 2737, 2749, 2750, 2750, 2738, 2737, 2738, 2750, 2751, 2751, 2739, 2738, 2739, 2751, 2752, 2752, 2740, 2739, 2740, 2752, 2753, 2753, 2741, 2740, 2741, 2753, 2754, 2754, 2742, 2741, 2742, 2754, 2755, 2755, 2743, 2742, 2743, 2755, 2756, 2756, 2744, 2743, 2744, 2756, 2757, 2757, 2745, 2744, 2745, 2757, 2758, 2758, 2746, 2745, 2746, 2758, 2759, 2759, 2747, 2746, 2747, 2759, 2760, 2760, 2748, 2747, 2460, 2473, 2761, 2761, 2749, 2460, 2749, 2761, 2762, 2762, 2750, 2749, 2750, 2762, 2763, 2763, 2751, 2750, 2751, 2763, 2764, 2764, 2752, 2751, 2752, 2764, 2765, 2765, 2753, 2752, 2753, 2765, 2766, 2766, 2754, 2753, 2754, 2766, 2767, 2767, 2755, 2754, 2755, 2767, 2768, 2768, 2756, 2755, 2756, 2768, 2769, 2769, 2757, 2756, 2757, 2769, 2770, 2770, 2758, 2757, 2758, 2770, 2771, 2771, 2759, 2758, 2759, 2771, 2772, 2772, 2760, 2759, 2473, 2486, 2773, 2773, 2761, 2473, 2761, 2773, 2774, 2774, 2762, 2761, 2762, 2774, 2775, 2775, 2763, 2762, 2763, 2775, 2776, 2776, 2764, 2763, 2764, 2776, 2777, 2777, 2765, 2764, 2765, 2777, 2778, 2778, 2766, 2765, 2766, 2778, 2779, 2779, 2767, 2766, 2767, 2779, 2780, 2780, 2768, 2767, 2768, 2780, 2781, 2781, 2769, 2768, 2769, 2781, 2782, 2782, 2770, 2769, 2770, 2782, 2783, 2783, 2771, 2770, 2771, 2783, 2784, 2784, 2772, 2771, 2486, 2499, 2785, 2785, 2773, 2486, 2773, 2785, 2786, 2786, 2774, 2773, 2774, 2786, 2787, 2787, 2775, 2774, 2775, 2787, 2788, 2788, 2776, 2775, 2776, 2788, 2789, 2789, 2777, 2776, 2777, 2789, 2790, 2790, 2778, 2777, 2778, 2790, 2791, 2791, 2779, 2778, 2779, 2791, 2792, 2792, 2780, 2779, 2780, 2792, 2793, 2793, 2781, 2780, 2781, 2793, 2794, 2794, 2782, 2781, 2782, 2794, 2795, 2795, 2783, 2782, 2783, 2795, 2796, 2796, 2784, 2783, 2499, 2512, 2797, 2797, 2785, 2499, 2785, 2797, 2798, 2798, 2786, 2785, 2786, 2798, 2799, 2799, 2787, 2786, 2787, 2799, 2800, 2800, 2788, 2787, 2788, 2800, 2801, 2801, 2789, 2788, 2789, 2801, 2802, 2802, 2790, 2789, 2790, 2802, 2803, 2803, 2791, 2790, 2791, 2803, 2804, 2804, 2792, 2791, 2792, 2804, 2805, 2805, 2793, 2792, 2793, 2805, 2806, 2806, 2794, 2793, 2794, 2806, 2807, 2807, 2795, 2794, 2795, 2807, 2808, 2808, 2796, 2795, 2512, 2525, 2809, 2809, 2797, 2512, 2797, 2809, 2810, 2810, 2798, 2797, 2798, 2810, 2811, 2811, 2799, 2798, 2799, 2811, 2812, 2812, 2800, 2799, 2800, 2812, 2813, 2813, 2801, 2800, 2801, 2813, 2814, 2814, 2802, 2801, 2802, 2814, 2815, 2815, 2803, 2802, 2803, 2815, 2816, 2816, 2804, 2803, 2804, 2816, 2817, 2817, 2805, 2804, 2805, 2817, 2818, 2818, 2806, 2805, 2806, 2818, 2819, 2819, 2807, 2806, 2807, 2819, 2820, 2820, 2808, 2807, 2525, 2538, 2821, 2821, 2809, 2525, 2809, 2821, 2822, 2822, 2810, 2809, 2810, 2822, 2823, 2823, 2811, 2810, 2811, 2823, 2824, 2824, 2812, 2811, 2812, 2824, 2825, 2825, 2813, 2812, 2813, 2825, 2826, 2826, 2814, 2813, 2814, 2826, 2827, 2827, 2815, 2814, 2815, 2827, 2828, 2828, 2816, 2815, 2816, 2828, 2829, 2829, 2817, 2816, 2817, 2829, 2830, 2830, 2818, 2817, 2818, 2830, 2831, 2831, 2819, 2818, 2819, 2831, 2832, 2832, 2820, 2819, 2538, 2551, 2833, 2833, 2821, 2538, 2821, 2833, 2834, 2834, 2822, 2821, 2822, 2834, 2835, 2835, 2823, 2822, 2823, 2835, 2836, 2836, 2824, 2823, 2824, 2836, 2837, 2837, 2825, 2824, 2825, 2837, 2838, 2838, 2826, 2825, 2826, 2838, 2839, 2839, 2827, 2826, 2827, 2839, 2840, 2840, 2828, 2827, 2828, 2840, 2841, 2841, 2829, 2828, 2829, 2841, 2842, 2842, 2830, 2829, 2830, 2842, 2843, 2843, 2831, 2830, 2831, 2843, 2844, 2844, 2832, 2831, 2551, 2564, 2845, 2845, 2833, 2551, 2833, 2845, 2846, 2846, 2834, 2833, 2834, 2846, 2847, 2847, 2835, 2834, 2835, 2847, 2848, 2848, 2836, 2835, 2836, 2848, 2849, 2849, 2837, 2836, 2837, 2849, 2850, 2850, 2838, 2837, 2838, 2850, 2851, 2851, 2839, 2838, 2839, 2851, 2852, 2852, 2840, 2839, 2840, 2852, 2853, 2853, 2841, 2840, 2841, 2853, 2854, 2854, 2842, 2841, 2842, 2854, 2855, 2855, 2843, 2842, 2843, 2855, 2856, 2856, 2844, 2843, 2564, 2577, 2857, 2857, 2845, 2564, 2845, 2857, 2858, 2858, 2846, 2845, 2846, 2858, 2859, 2859, 2847, 2846, 2847, 2859, 2860, 2860, 2848, 2847, 2848, 2860, 2861, 2861, 2849, 2848, 2849, 2861, 2862, 2862, 2850, 2849, 2850, 2862, 2863, 2863, 2851, 2850, 2851, 2863, 2864, 2864, 2852, 2851, 2852, 2864, 2865, 2865, 2853, 2852, 2853, 2865, 2866, 2866, 2854, 2853, 2854, 2866, 2867, 2867, 2855, 2854, 2855, 2867, 2868, 2868, 2856, 2855, 2577, 2590, 2869, 2869, 2857, 2577, 2857, 2869, 2870, 2870, 2858, 2857, 2858, 2870, 2871, 2871, 2859, 2858, 2859, 2871, 2872, 2872, 2860, 2859, 2860, 2872, 2873, 2873, 2861, 2860, 2861, 2873, 2874, 2874, 2862, 2861, 2862, 2874, 2875, 2875, 2863, 2862, 2863, 2875, 2876, 2876, 2864, 2863, 2864, 2876, 2877, 2877, 2865, 2864, 2865, 2877, 2878, 2878, 2866, 2865, 2866, 2878, 2879, 2879, 2867, 2866, 2867, 2879, 2880, 2880, 2868, 2867, 2590, 2603, 2881, 2881, 2869, 2590, 2869, 2881, 2882, 2882, 2870, 2869, 2870, 2882, 2883, 2883, 2871, 2870, 2871, 2883, 2884, 2884, 2872, 2871, 2872, 2884, 2885, 2885, 2873, 2872, 2873, 2885, 2886, 2886, 2874, 2873, 2874, 2886, 2887, 2887, 2875, 2874, 2875, 2887, 2888, 2888, 2876, 2875, 2876, 2888, 2889, 2889, 2877, 2876, 2877, 2889, 2890, 2890, 2878, 2877, 2878, 2890, 2891, 2891, 2879, 2878, 2879, 2891, 2892, 2892, 2880, 2879, 2603, 2616, 2893, 2893, 2881, 2603, 2881, 2893, 2894, 2894, 2882, 2881, 2882, 2894, 2895, 2895, 2883, 2882, 2883, 2895, 2896, 2896, 2884, 2883, 2884, 2896, 2897, 2897, 2885, 2884, 2885, 2897, 2898, 2898, 2886, 2885, 2886, 2898, 2899, 2899, 2887, 2886, 2887, 2899, 2900, 2900, 2888, 2887, 2888, 2900, 2901, 2901, 2889, 2888, 2889, 2901, 2902, 2902, 2890, 2889, 2890, 2902, 2903, 2903, 2891, 2890, 2891, 2903, 2904, 2904, 2892, 2891, 2616, 2317, 2617, 2617, 2893, 2616, 2893, 2617, 2618, 2618, 2894, 2893, 2894, 2618, 2619, 2619, 2895, 2894, 2895, 2619, 2620, 2620, 2896, 2895, 2896, 2620, 2621, 2621, 2897, 2896, 2897, 2621, 2622, 2622, 2898, 2897, 2898, 2622, 2623, 2623, 2899, 2898, 2899, 2623, 2624, 2624, 2900, 2899, 2900, 2624, 2625, 2625, 2901, 2900, 2901, 2625, 2626, 2626, 2902, 2901, 2902, 2626, 2627, 2627, 2903, 2902, 2903, 2627, 2628, 2628, 2904, 2903, 2905, 2918, 2919, 2919, 2906, 2905, 2906, 2919, 2920, 2920, 2907, 2906, 2907, 2920, 2921, 2921, 2908, 2907, 2908, 2921, 2922, 2922, 2909, 2908, 2909, 2922, 2923, 2923, 2910, 2909, 2910, 2923, 2924, 2924, 2911, 2910, 2911, 2924, 2925, 2925, 2912, 2911, 2912, 2925, 2926, 2926, 2913, 2912, 2913, 2926, 2927, 2927, 2914, 2913, 2914, 2927, 2928, 2928, 2915, 2914, 2915, 2928, 2929, 2929, 2916, 2915, 2916, 2929, 2930, 2930, 2917, 2916, 2918, 2931, 2932, 2932, 2919, 2918, 2919, 2932, 2933, 2933, 2920, 2919, 2920, 2933, 2934, 2934, 2921, 2920, 2921, 2934, 2935, 2935, 2922, 2921, 2922, 2935, 2936, 2936, 2923, 2922, 2923, 2936, 2937, 2937, 2924, 2923, 2924, 2937, 2938, 2938, 2925, 2924, 2925, 2938, 2939, 2939, 2926, 2925, 2926, 2939, 2940, 2940, 2927, 2926, 2927, 2940, 2941, 2941, 2928, 2927, 2928, 2941, 2942, 2942, 2929, 2928, 2929, 2942, 2943, 2943, 2930, 2929, 2931, 2944, 2945, 2945, 2932, 2931, 2932, 2945, 2946, 2946, 2933, 2932, 2933, 2946, 2947, 2947, 2934, 2933, 2934, 2947, 2948, 2948, 2935, 2934, 2935, 2948, 2949, 2949, 2936, 2935, 2936, 2949, 2950, 2950, 2937, 2936, 2937, 2950, 2951, 2951, 2938, 2937, 2938, 2951, 2952, 2952, 2939, 2938, 2939, 2952, 2953, 2953, 2940, 2939, 2940, 2953, 2954, 2954, 2941, 2940, 2941, 2954, 2955, 2955, 2942, 2941, 2942, 2955, 2956, 2956, 2943, 2942, 2944, 2957, 2958, 2958, 2945, 2944, 2945, 2958, 2959, 2959, 2946, 2945, 2946, 2959, 2960, 2960, 2947, 2946, 2947, 2960, 2961, 2961, 2948, 2947, 2948, 2961, 2962, 2962, 2949, 2948, 2949, 2962, 2963, 2963, 2950, 2949, 2950, 2963, 2964, 2964, 2951, 2950, 2951, 2964, 2965, 2965, 2952, 2951, 2952, 2965, 2966, 2966, 2953, 2952, 2953, 2966, 2967, 2967, 2954, 2953, 2954, 2967, 2968, 2968, 2955, 2954, 2955, 2968, 2969, 2969, 2956, 2955, 2957, 2970, 2971, 2971, 2958, 2957, 2958, 2971, 2972, 2972, 2959, 2958, 2959, 2972, 2973, 2973, 2960, 2959, 2960, 2973, 2974, 2974, 2961, 2960, 2961, 2974, 2975, 2975, 2962, 2961, 2962, 2975, 2976, 2976, 2963, 2962, 2963, 2976, 2977, 2977, 2964, 2963, 2964, 2977, 2978, 2978, 2965, 2964, 2965, 2978, 2979, 2979, 2966, 2965, 2966, 2979, 2980, 2980, 2967, 2966, 2967, 2980, 2981, 2981, 2968, 2967, 2968, 2981, 2982, 2982, 2969, 2968, 2970, 2983, 2984, 2984, 2971, 2970, 2971, 2984, 2985, 2985, 2972, 2971, 2972, 2985, 2986, 2986, 2973, 2972, 2973, 2986, 2987, 2987, 2974, 2973, 2974, 2987, 2988, 2988, 2975, 2974, 2975, 2988, 2989, 2989, 2976, 2975, 2976, 2989, 2990, 2990, 2977, 2976, 2977, 2990, 2991, 2991, 2978, 2977, 2978, 2991, 2992, 2992, 2979, 2978, 2979, 2992, 2993, 2993, 2980, 2979, 2980, 2993, 2994, 2994, 2981, 2980, 2981, 2994, 2995, 2995, 2982, 2981, 2983, 2996, 2997, 2997, 2984, 2983, 2984, 2997, 2998, 2998, 2985, 2984, 2985, 2998, 2999, 2999, 2986, 2985, 2986, 2999, 3000, 3000, 2987, 2986, 2987, 3000, 3001, 3001, 2988, 2987, 2988, 3001, 3002, 3002, 2989, 2988, 2989, 3002, 3003, 3003, 2990, 2989, 2990, 3003, 3004, 3004, 2991, 2990, 2991, 3004, 3005, 3005, 2992, 2991, 2992, 3005, 3006, 3006, 2993, 2992, 2993, 3006, 3007, 3007, 2994, 2993, 2994, 3007, 3008, 3008, 2995, 2994, 2996, 3009, 3010, 3010, 2997, 2996, 2997, 3010, 3011, 3011, 2998, 2997, 2998, 3011, 3012, 3012, 2999, 2998, 2999, 3012, 3013, 3013, 3000, 2999, 3000, 3013, 3014, 3014, 3001, 3000, 3001, 3014, 3015, 3015, 3002, 3001, 3002, 3015, 3016, 3016, 3003, 3002, 3003, 3016, 3017, 3017, 3004, 3003, 3004, 3017, 3018, 3018, 3005, 3004, 3005, 3018, 3019, 3019, 3006, 3005, 3006, 3019, 3020, 3020, 3007, 3006, 3007, 3020, 3021, 3021, 3008, 3007, 3009, 3022, 3023, 3023, 3010, 3009, 3010, 3023, 3024, 3024, 3011, 3010, 3011, 3024, 3025, 3025, 3012, 3011, 3012, 3025, 3026, 3026, 3013, 3012, 3013, 3026, 3027, 3027, 3014, 3013, 3014, 3027, 3028, 3028, 3015, 3014, 3015, 3028, 3029, 3029, 3016, 3015, 3016, 3029, 3030, 3030, 3017, 3016, 3017, 3030, 3031, 3031, 3018, 3017, 3018, 3031, 3032, 3032, 3019, 3018, 3019, 3032, 3033, 3033, 3020, 3019, 3020, 3033, 3034, 3034, 3021, 3020, 3022, 3035, 3036, 3036, 3023, 3022, 3023, 3036, 3037, 3037, 3024, 3023, 3024, 3037, 3038, 3038, 3025, 3024, 3025, 3038, 3039, 3039, 3026, 3025, 3026, 3039, 3040, 3040, 3027, 3026, 3027, 3040, 3041, 3041, 3028, 3027, 3028, 3041, 3042, 3042, 3029, 3028, 3029, 3042, 3043, 3043, 3030, 3029, 3030, 3043, 3044, 3044, 3031, 3030, 3031, 3044, 3045, 3045, 3032, 3031, 3032, 3045, 3046, 3046, 3033, 3032, 3033, 3046, 3047, 3047, 3034, 3033, 3035, 3048, 3049, 3049, 3036, 3035, 3036, 3049, 3050, 3050, 3037, 3036, 3037, 3050, 3051, 3051, 3038, 3037, 3038, 3051, 3052, 3052, 3039, 3038, 3039, 3052, 3053, 3053, 3040, 3039, 3040, 3053, 3054, 3054, 3041, 3040, 3041, 3054, 3055, 3055, 3042, 3041, 3042, 3055, 3056, 3056, 3043, 3042, 3043, 3056, 3057, 3057, 3044, 3043, 3044, 3057, 3058, 3058, 3045, 3044, 3045, 3058, 3059, 3059, 3046, 3045, 3046, 3059, 3060, 3060, 3047, 3046, 3048, 3061, 3062, 3062, 3049, 3048, 3049, 3062, 3063, 3063, 3050, 3049, 3050, 3063, 3064, 3064, 3051, 3050, 3051, 3064, 3065, 3065, 3052, 3051, 3052, 3065, 3066, 3066, 3053, 3052, 3053, 3066, 3067, 3067, 3054, 3053, 3054, 3067, 3068, 3068, 3055, 3054, 3055, 3068, 3069, 3069, 3056, 3055, 3056, 3069, 3070, 3070, 3057, 3056, 3057, 3070, 3071, 3071, 3058, 3057, 3058, 3071, 3072, 3072, 3059, 3058, 3059, 3072, 3073, 3073, 3060, 3059, 3061, 3074, 3075, 3075, 3062, 3061, 3062, 3075, 3076, 3076, 3063, 3062, 3063, 3076, 3077, 3077, 3064, 3063, 3064, 3077, 3078, 3078, 3065, 3064, 3065, 3078, 3079, 3079, 3066, 3065, 3066, 3079, 3080, 3080, 3067, 3066, 3067, 3080, 3081, 3081, 3068, 3067, 3068, 3081, 3082, 3082, 3069, 3068, 3069, 3082, 3083, 3083, 3070, 3069, 3070, 3083, 3084, 3084, 3071, 3070, 3071, 3084, 3085, 3085, 3072, 3071, 3072, 3085, 3086, 3086, 3073, 3072, 3074, 3087, 3088, 3088, 3075, 3074, 3075, 3088, 3089, 3089, 3076, 3075, 3076, 3089, 3090, 3090, 3077, 3076, 3077, 3090, 3091, 3091, 3078, 3077, 3078, 3091, 3092, 3092, 3079, 3078, 3079, 3092, 3093, 3093, 3080, 3079, 3080, 3093, 3094, 3094, 3081, 3080, 3081, 3094, 3095, 3095, 3082, 3081, 3082, 3095, 3096, 3096, 3083, 3082, 3083, 3096, 3097, 3097, 3084, 3083, 3084, 3097, 3098, 3098, 3085, 3084, 3085, 3098, 3099, 3099, 3086, 3085, 3087, 3100, 3101, 3101, 3088, 3087, 3088, 3101, 3102, 3102, 3089, 3088, 3089, 3102, 3103, 3103, 3090, 3089, 3090, 3103, 3104, 3104, 3091, 3090, 3091, 3104, 3105, 3105, 3092, 3091, 3092, 3105, 3106, 3106, 3093, 3092, 3093, 3106, 3107, 3107, 3094, 3093, 3094, 3107, 3108, 3108, 3095, 3094, 3095, 3108, 3109, 3109, 3096, 3095, 3096, 3109, 3110, 3110, 3097, 3096, 3097, 3110, 3111, 3111, 3098, 3097, 3098, 3111, 3112, 3112, 3099, 3098, 3100, 3113, 3114, 3114, 3101, 3100, 3101, 3114, 3115, 3115, 3102, 3101, 3102, 3115, 3116, 3116, 3103, 3102, 3103, 3116, 3117, 3117, 3104, 3103, 3104, 3117, 3118, 3118, 3105, 3104, 3105, 3118, 3119, 3119, 3106, 3105, 3106, 3119, 3120, 3120, 3107, 3106, 3107, 3120, 3121, 3121, 3108, 3107, 3108, 3121, 3122, 3122, 3109, 3108, 3109, 3122, 3123, 3123, 3110, 3109, 3110, 3123, 3124, 3124, 3111, 3110, 3111, 3124, 3125, 3125, 3112, 3111, 3113, 3126, 3127, 3127, 3114, 3113, 3114, 3127, 3128, 3128, 3115, 3114, 3115, 3128, 3129, 3129, 3116, 3115, 3116, 3129, 3130, 3130, 3117, 3116, 3117, 3130, 3131, 3131, 3118, 3117, 3118, 3131, 3132, 3132, 3119, 3118, 3119, 3132, 3133, 3133, 3120, 3119, 3120, 3133, 3134, 3134, 3121, 3120, 3121, 3134, 3135, 3135, 3122, 3121, 3122, 3135, 3136, 3136, 3123, 3122, 3123, 3136, 3137, 3137, 3124, 3123, 3124, 3137, 3138, 3138, 3125, 3124, 3126, 3139, 3140, 3140, 3127, 3126, 3127, 3140, 3141, 3141, 3128, 3127, 3128, 3141, 3142, 3142, 3129, 3128, 3129, 3142, 3143, 3143, 3130, 3129, 3130, 3143, 3144, 3144, 3131, 3130, 3131, 3144, 3145, 3145, 3132, 3131, 3132, 3145, 3146, 3146, 3133, 3132, 3133, 3146, 3147, 3147, 3134, 3133, 3134, 3147, 3148, 3148, 3135, 3134, 3135, 3148, 3149, 3149, 3136, 3135, 3136, 3149, 3150, 3150, 3137, 3136, 3137, 3150, 3151, 3151, 3138, 3137, 3139, 3152, 3153, 3153, 3140, 3139, 3140, 3153, 3154, 3154, 3141, 3140, 3141, 3154, 3155, 3155, 3142, 3141, 3142, 3155, 3156, 3156, 3143, 3142, 3143, 3156, 3157, 3157, 3144, 3143, 3144, 3157, 3158, 3158, 3145, 3144, 3145, 3158, 3159, 3159, 3146, 3145, 3146, 3159, 3160, 3160, 3147, 3146, 3147, 3160, 3161, 3161, 3148, 3147, 3148, 3161, 3162, 3162, 3149, 3148, 3149, 3162, 3163, 3163, 3150, 3149, 3150, 3163, 3164, 3164, 3151, 3150, 3152, 3165, 3166, 3166, 3153, 3152, 3153, 3166, 3167, 3167, 3154, 3153, 3154, 3167, 3168, 3168, 3155, 3154, 3155, 3168, 3169, 3169, 3156, 3155, 3156, 3169, 3170, 3170, 3157, 3156, 3157, 3170, 3171, 3171, 3158, 3157, 3158, 3171, 3172, 3172, 3159, 3158, 3159, 3172, 3173, 3173, 3160, 3159, 3160, 3173, 3174, 3174, 3161, 3160, 3161, 3174, 3175, 3175, 3162, 3161, 3162, 3175, 3176, 3176, 3163, 3162, 3163, 3176, 3177, 3177, 3164, 3163, 3165, 3178, 3179, 3179, 3166, 3165, 3166, 3179, 3180, 3180, 3167, 3166, 3167, 3180, 3181, 3181, 3168, 3167, 3168, 3181, 3182, 3182, 3169, 3168, 3169, 3182, 3183, 3183, 3170, 3169, 3170, 3183, 3184, 3184, 3171, 3170, 3171, 3184, 3185, 3185, 3172, 3171, 3172, 3185, 3186, 3186, 3173, 3172, 3173, 3186, 3187, 3187, 3174, 3173, 3174, 3187, 3188, 3188, 3175, 3174, 3175, 3188, 3189, 3189, 3176, 3175, 3176, 3189, 3190, 3190, 3177, 3176, 3178, 3191, 3192, 3192, 3179, 3178, 3179, 3192, 3193, 3193, 3180, 3179, 3180, 3193, 3194, 3194, 3181, 3180, 3181, 3194, 3195, 3195, 3182, 3181, 3182, 3195, 3196, 3196, 3183, 3182, 3183, 3196, 3197, 3197, 3184, 3183, 3184, 3197, 3198, 3198, 3185, 3184, 3185, 3198, 3199, 3199, 3186, 3185, 3186, 3199, 3200, 3200, 3187, 3186, 3187, 3200, 3201, 3201, 3188, 3187, 3188, 3201, 3202, 3202, 3189, 3188, 3189, 3202, 3203, 3203, 3190, 3189, 3191, 3204, 3205, 3205, 3192, 3191, 3192, 3205, 3206, 3206, 3193, 3192, 3193, 3206, 3207, 3207, 3194, 3193, 3194, 3207, 3208, 3208, 3195, 3194, 3195, 3208, 3209, 3209, 3196, 3195, 3196, 3209, 3210, 3210, 3197, 3196, 3197, 3210, 3211, 3211, 3198, 3197, 3198, 3211, 3212, 3212, 3199, 3198, 3199, 3212, 3213, 3213, 3200, 3199, 3200, 3213, 3214, 3214, 3201, 3200, 3201, 3214, 3215, 3215, 3202, 3201, 3202, 3215, 3216, 3216, 3203, 3202, 3204, 2905, 2906, 2906, 3205, 3204, 3205, 2906, 2907, 2907, 3206, 3205, 3206, 2907, 2908, 2908, 3207, 3206, 3207, 2908, 2909, 2909, 3208, 3207, 3208, 2909, 2910, 2910, 3209, 3208, 3209, 2910, 2911, 2911, 3210, 3209, 3210, 2911, 2912, 2912, 3211, 3210, 3211, 2912, 2913, 2913, 3212, 3211, 3212, 2913, 2914, 2914, 3213, 3212, 3213, 2914, 2915, 2915, 3214, 3213, 3214, 2915, 2916, 2916, 3215, 3214, 3215, 2916, 2917, 2917, 3216, 3215, 2917, 2930, 3229, 3229, 3217, 2917, 3217, 3229, 3230, 3230, 3218, 3217, 3218, 3230, 3231, 3231, 3219, 3218, 3219, 3231, 3232, 3232, 3220, 3219, 3220, 3232, 3233, 3233, 3221, 3220, 3221, 3233, 3234, 3234, 3222, 3221, 3222, 3234, 3235, 3235, 3223, 3222, 3223, 3235, 3236, 3236, 3224, 3223, 3224, 3236, 3237, 3237, 3225, 3224, 3225, 3237, 3238, 3238, 3226, 3225, 3226, 3238, 3239, 3239, 3227, 3226, 3227, 3239, 3240, 3240, 3228, 3227, 2930, 2943, 3241, 3241, 3229, 2930, 3229, 3241, 3242, 3242, 3230, 3229, 3230, 3242, 3243, 3243, 3231, 3230, 3231, 3243, 3244, 3244, 3232, 3231, 3232, 3244, 3245, 3245, 3233, 3232, 3233, 3245, 3246, 3246, 3234, 3233, 3234, 3246, 3247, 3247, 3235, 3234, 3235, 3247, 3248, 3248, 3236, 3235, 3236, 3248, 3249, 3249, 3237, 3236, 3237, 3249, 3250, 3250, 3238, 3237, 3238, 3250, 3251, 3251, 3239, 3238, 3239, 3251, 3252, 3252, 3240, 3239, 2943, 2956, 3253, 3253, 3241, 2943, 3241, 3253, 3254, 3254, 3242, 3241, 3242, 3254, 3255, 3255, 3243, 3242, 3243, 3255, 3256, 3256, 3244, 3243, 3244, 3256, 3257, 3257, 3245, 3244, 3245, 3257, 3258, 3258, 3246, 3245, 3246, 3258, 3259, 3259, 3247, 3246, 3247, 3259, 3260, 3260, 3248, 3247, 3248, 3260, 3261, 3261, 3249, 3248, 3249, 3261, 3262, 3262, 3250, 3249, 3250, 3262, 3263, 3263, 3251, 3250, 3251, 3263, 3264, 3264, 3252, 3251, 2956, 2969, 3265, 3265, 3253, 2956, 3253, 3265, 3266, 3266, 3254, 3253, 3254, 3266, 3267, 3267, 3255, 3254, 3255, 3267, 3268, 3268, 3256, 3255, 3256, 3268, 3269, 3269, 3257, 3256, 3257, 3269, 3270, 3270, 3258, 3257, 3258, 3270, 3271, 3271, 3259, 3258, 3259, 3271, 3272, 3272, 3260, 3259, 3260, 3272, 3273, 3273, 3261, 3260, 3261, 3273, 3274, 3274, 3262, 3261, 3262, 3274, 3275, 3275, 3263, 3262, 3263, 3275, 3276, 3276, 3264, 3263, 2969, 2982, 3277, 3277, 3265, 2969, 3265, 3277, 3278, 3278, 3266, 3265, 3266, 3278, 3279, 3279, 3267, 3266, 3267, 3279, 3280, 3280, 3268, 3267, 3268, 3280, 3281, 3281, 3269, 3268, 3269, 3281, 3282, 3282, 3270, 3269, 3270, 3282, 3283, 3283, 3271, 3270, 3271, 3283, 3284, 3284, 3272, 3271, 3272, 3284, 3285, 3285, 3273, 3272, 3273, 3285, 3286, 3286, 3274, 3273, 3274, 3286, 3287, 3287, 3275, 3274, 3275, 3287, 3288, 3288, 3276, 3275, 2982, 2995, 3289, 3289, 3277, 2982, 3277, 3289, 3290, 3290, 3278, 3277, 3278, 3290, 3291, 3291, 3279, 3278, 3279, 3291, 3292, 3292, 3280, 3279, 3280, 3292, 3293, 3293, 3281, 3280, 3281, 3293, 3294, 3294, 3282, 3281, 3282, 3294, 3295, 3295, 3283, 3282, 3283, 3295, 3296, 3296, 3284, 3283, 3284, 3296, 3297, 3297, 3285, 3284, 3285, 3297, 3298, 3298, 3286, 3285, 3286, 3298, 3299, 3299, 3287, 3286, 3287, 3299, 3300, 3300, 3288, 3287, 2995, 3008, 3301, 3301, 3289, 2995, 3289, 3301, 3302, 3302, 3290, 3289, 3290, 3302, 3303, 3303, 3291, 3290, 3291, 3303, 3304, 3304, 3292, 3291, 3292, 3304, 3305, 3305, 3293, 3292, 3293, 3305, 3306, 3306, 3294, 3293, 3294, 3306, 3307, 3307, 3295, 3294, 3295, 3307, 3308, 3308, 3296, 3295, 3296, 3308, 3309, 3309, 3297, 3296, 3297, 3309, 3310, 3310, 3298, 3297, 3298, 3310, 3311, 3311, 3299, 3298, 3299, 3311, 3312, 3312, 3300, 3299, 3008, 3021, 3313, 3313, 3301, 3008, 3301, 3313, 3314, 3314, 3302, 3301, 3302, 3314, 3315, 3315, 3303, 3302, 3303, 3315, 3316, 3316, 3304, 3303, 3304, 3316, 3317, 3317, 3305, 3304, 3305, 3317, 3318, 3318, 3306, 3305, 3306, 3318, 3319, 3319, 3307, 3306, 3307, 3319, 3320, 3320, 3308, 3307, 3308, 3320, 3321, 3321, 3309, 3308, 3309, 3321, 3322, 3322, 3310, 3309, 3310, 3322, 3323, 3323, 3311, 3310, 3311, 3323, 3324, 3324, 3312, 3311, 3021, 3034, 3325, 3325, 3313, 3021, 3313, 3325, 3326, 3326, 3314, 3313, 3314, 3326, 3327, 3327, 3315, 3314, 3315, 3327, 3328, 3328, 3316, 3315, 3316, 3328, 3329, 3329, 3317, 3316, 3317, 3329, 3330, 3330, 3318, 3317, 3318, 3330, 3331, 3331, 3319, 3318, 3319, 3331, 3332, 3332, 3320, 3319, 3320, 3332, 3333, 3333, 3321, 3320, 3321, 3333, 3334, 3334, 3322, 3321, 3322, 3334, 3335, 3335, 3323, 3322, 3323, 3335, 3336, 3336, 3324, 3323, 3034, 3047, 3337, 3337, 3325, 3034, 3325, 3337, 3338, 3338, 3326, 3325, 3326, 3338, 3339, 3339, 3327, 3326, 3327, 3339, 3340, 3340, 3328, 3327, 3328, 3340, 3341, 3341, 3329, 3328, 3329, 3341, 3342, 3342, 3330, 3329, 3330, 3342, 3343, 3343, 3331, 3330, 3331, 3343, 3344, 3344, 3332, 3331, 3332, 3344, 3345, 3345, 3333, 3332, 3333, 3345, 3346, 3346, 3334, 3333, 3334, 3346, 3347, 3347, 3335, 3334, 3335, 3347, 3348, 3348, 3336, 3335, 3047, 3060, 3349, 3349, 3337, 3047, 3337, 3349, 3350, 3350, 3338, 3337, 3338, 3350, 3351, 3351, 3339, 3338, 3339, 3351, 3352, 3352, 3340, 3339, 3340, 3352, 3353, 3353, 3341, 3340, 3341, 3353, 3354, 3354, 3342, 3341, 3342, 3354, 3355, 3355, 3343, 3342, 3343, 3355, 3356, 3356, 3344, 3343, 3344, 3356, 3357, 3357, 3345, 3344, 3345, 3357, 3358, 3358, 3346, 3345, 3346, 3358, 3359, 3359, 3347, 3346, 3347, 3359, 3360, 3360, 3348, 3347, 3060, 3073, 3361, 3361, 3349, 3060, 3349, 3361, 3362, 3362, 3350, 3349, 3350, 3362, 3363, 3363, 3351, 3350, 3351, 3363, 3364, 3364, 3352, 3351, 3352, 3364, 3365, 3365, 3353, 3352, 3353, 3365, 3366, 3366, 3354, 3353, 3354, 3366, 3367, 3367, 3355, 3354, 3355, 3367, 3368, 3368, 3356, 3355, 3356, 3368, 3369, 3369, 3357, 3356, 3357, 3369, 3370, 3370, 3358, 3357, 3358, 3370, 3371, 3371, 3359, 3358, 3359, 3371, 3372, 3372, 3360, 3359, 3073, 3086, 3373, 3373, 3361, 3073, 3361, 3373, 3374, 3374, 3362, 3361, 3362, 3374, 3375, 3375, 3363, 3362, 3363, 3375, 3376, 3376, 3364, 3363, 3364, 3376, 3377, 3377, 3365, 3364, 3365, 3377, 3378, 3378, 3366, 3365, 3366, 3378, 3379, 3379, 3367, 3366, 3367, 3379, 3380, 3380, 3368, 3367, 3368, 3380, 3381, 3381, 3369, 3368, 3369, 3381, 3382, 3382, 3370, 3369, 3370, 3382, 3383, 3383, 3371, 3370, 3371, 3383, 3384, 3384, 3372, 3371, 3086, 3099, 3385, 3385, 3373, 3086, 3373, 3385, 3386, 3386, 3374, 3373, 3374, 3386, 3387, 3387, 3375, 3374, 3375, 3387, 3388, 3388, 3376, 3375, 3376, 3388, 3389, 3389, 3377, 3376, 3377, 3389, 3390, 3390, 3378, 3377, 3378, 3390, 3391, 3391, 3379, 3378, 3379, 3391, 3392, 3392, 3380, 3379, 3380, 3392, 3393, 3393, 3381, 3380, 3381, 3393, 3394, 3394, 3382, 3381, 3382, 3394, 3395, 3395, 3383, 3382, 3383, 3395, 3396, 3396, 3384, 3383, 3099, 3112, 3397, 3397, 3385, 3099, 3385, 3397, 3398, 3398, 3386, 3385, 3386, 3398, 3399, 3399, 3387, 3386, 3387, 3399, 3400, 3400, 3388, 3387, 3388, 3400, 3401, 3401, 3389, 3388, 3389, 3401, 3402, 3402, 3390, 3389, 3390, 3402, 3403, 3403, 3391, 3390, 3391, 3403, 3404, 3404, 3392, 3391, 3392, 3404, 3405, 3405, 3393, 3392, 3393, 3405, 3406, 3406, 3394, 3393, 3394, 3406, 3407, 3407, 3395, 3394, 3395, 3407, 3408, 3408, 3396, 3395, 3112, 3125, 3409, 3409, 3397, 3112, 3397, 3409, 3410, 3410, 3398, 3397, 3398, 3410, 3411, 3411, 3399, 3398, 3399, 3411, 3412, 3412, 3400, 3399, 3400, 3412, 3413, 3413, 3401, 3400, 3401, 3413, 3414, 3414, 3402, 3401, 3402, 3414, 3415, 3415, 3403, 3402, 3403, 3415, 3416, 3416, 3404, 3403, 3404, 3416, 3417, 3417, 3405, 3404, 3405, 3417, 3418, 3418, 3406, 3405, 3406, 3418, 3419, 3419, 3407, 3406, 3407, 3419, 3420, 3420, 3408, 3407, 3125, 3138, 3421, 3421, 3409, 3125, 3409, 3421, 3422, 3422, 3410, 3409, 3410, 3422, 3423, 3423, 3411, 3410, 3411, 3423, 3424, 3424, 3412, 3411, 3412, 3424, 3425, 3425, 3413, 3412, 3413, 3425, 3426, 3426, 3414, 3413, 3414, 3426, 3427, 3427, 3415, 3414, 3415, 3427, 3428, 3428, 3416, 3415, 3416, 3428, 3429, 3429, 3417, 3416, 3417, 3429, 3430, 3430, 3418, 3417, 3418, 3430, 3431, 3431, 3419, 3418, 3419, 3431, 3432, 3432, 3420, 3419, 3138, 3151, 3433, 3433, 3421, 3138, 3421, 3433, 3434, 3434, 3422, 3421, 3422, 3434, 3435, 3435, 3423, 3422, 3423, 3435, 3436, 3436, 3424, 3423, 3424, 3436, 3437, 3437, 3425, 3424, 3425, 3437, 3438, 3438, 3426, 3425, 3426, 3438, 3439, 3439, 3427, 3426, 3427, 3439, 3440, 3440, 3428, 3427, 3428, 3440, 3441, 3441, 3429, 3428, 3429, 3441, 3442, 3442, 3430, 3429, 3430, 3442, 3443, 3443, 3431, 3430, 3431, 3443, 3444, 3444, 3432, 3431, 3151, 3164, 3445, 3445, 3433, 3151, 3433, 3445, 3446, 3446, 3434, 3433, 3434, 3446, 3447, 3447, 3435, 3434, 3435, 3447, 3448, 3448, 3436, 3435, 3436, 3448, 3449, 3449, 3437, 3436, 3437, 3449, 3450, 3450, 3438, 3437, 3438, 3450, 3451, 3451, 3439, 3438, 3439, 3451, 3452, 3452, 3440, 3439, 3440, 3452, 3453, 3453, 3441, 3440, 3441, 3453, 3454, 3454, 3442, 3441, 3442, 3454, 3455, 3455, 3443, 3442, 3443, 3455, 3456, 3456, 3444, 3443, 3164, 3177, 3457, 3457, 3445, 3164, 3445, 3457, 3458, 3458, 3446, 3445, 3446, 3458, 3459, 3459, 3447, 3446, 3447, 3459, 3460, 3460, 3448, 3447, 3448, 3460, 3461, 3461, 3449, 3448, 3449, 3461, 3462, 3462, 3450, 3449, 3450, 3462, 3463, 3463, 3451, 3450, 3451, 3463, 3464, 3464, 3452, 3451, 3452, 3464, 3465, 3465, 3453, 3452, 3453, 3465, 3466, 3466, 3454, 3453, 3454, 3466, 3467, 3467, 3455, 3454, 3455, 3467, 3468, 3468, 3456, 3455, 3177, 3190, 3469, 3469, 3457, 3177, 3457, 3469, 3470, 3470, 3458, 3457, 3458, 3470, 3471, 3471, 3459, 3458, 3459, 3471, 3472, 3472, 3460, 3459, 3460, 3472, 3473, 3473, 3461, 3460, 3461, 3473, 3474, 3474, 3462, 3461, 3462, 3474, 3475, 3475, 3463, 3462, 3463, 3475, 3476, 3476, 3464, 3463, 3464, 3476, 3477, 3477, 3465, 3464, 3465, 3477, 3478, 3478, 3466, 3465, 3466, 3478, 3479, 3479, 3467, 3466, 3467, 3479, 3480, 3480, 3468, 3467, 3190, 3203, 3481, 3481, 3469, 3190, 3469, 3481, 3482, 3482, 3470, 3469, 3470, 3482, 3483, 3483, 3471, 3470, 3471, 3483, 3484, 3484, 3472, 3471, 3472, 3484, 3485, 3485, 3473, 3472, 3473, 3485, 3486, 3486, 3474, 3473, 3474, 3486, 3487, 3487, 3475, 3474, 3475, 3487, 3488, 3488, 3476, 3475, 3476, 3488, 3489, 3489, 3477, 3476, 3477, 3489, 3490, 3490, 3478, 3477, 3478, 3490, 3491, 3491, 3479, 3478, 3479, 3491, 3492, 3492, 3480, 3479, 3203, 3216, 3493, 3493, 3481, 3203, 3481, 3493, 3494, 3494, 3482, 3481, 3482, 3494, 3495, 3495, 3483, 3482, 3483, 3495, 3496, 3496, 3484, 3483, 3484, 3496, 3497, 3497, 3485, 3484, 3485, 3497, 3498, 3498, 3486, 3485, 3486, 3498, 3499, 3499, 3487, 3486, 3487, 3499, 3500, 3500, 3488, 3487, 3488, 3500, 3501, 3501, 3489, 3488, 3489, 3501, 3502, 3502, 3490, 3489, 3490, 3502, 3503, 3503, 3491, 3490, 3491, 3503, 3504, 3504, 3492, 3491, 3216, 2917, 3217, 3217, 3493, 3216, 3493, 3217, 3218, 3218, 3494, 3493, 3494, 3218, 3219, 3219, 3495, 3494, 3495, 3219, 3220, 3220, 3496, 3495, 3496, 3220, 3221, 3221, 3497, 3496, 3497, 3221, 3222, 3222, 3498, 3497, 3498, 3222, 3223, 3223, 3499, 3498, 3499, 3223, 3224, 3224, 3500, 3499, 3500, 3224, 3225, 3225, 3501, 3500, 3501, 3225, 3226, 3226, 3502, 3501, 3502, 3226, 3227, 3227, 3503, 3502, 3503, 3227, 3228, 3228, 3504, 3503, 3505, 3505, 3518, 3518, 3506, 3505, 3506, 3518, 3519, 3519, 3507, 3506, 3507, 3519, 3520, 3520, 3508, 3507, 3508, 3520, 3521, 3521, 3509, 3508, 3509, 3521, 3522, 3522, 3510, 3509, 3510, 3522, 3523, 3523, 3511, 3510, 3511, 3523, 3524, 3524, 3512, 3511, 3512, 3524, 3525, 3525, 3513, 3512, 3513, 3525, 3526, 3526, 3514, 3513, 3514, 3526, 3527, 3527, 3515, 3514, 3515, 3527, 3528, 3528, 3516, 3515, 3516, 3528, 3529, 3529, 3517, 3516, 3505, 3505, 3530, 3530, 3518, 3505, 3518, 3530, 3531, 3531, 3519, 3518, 3519, 3531, 3532, 3532, 3520, 3519, 3520, 3532, 3533, 3533, 3521, 3520, 3521, 3533, 3534, 3534, 3522, 3521, 3522, 3534, 3535, 3535, 3523, 3522, 3523, 3535, 3536, 3536, 3524, 3523, 3524, 3536, 3537, 3537, 3525, 3524, 3525, 3537, 3538, 3538, 3526, 3525, 3526, 3538, 3539, 3539, 3527, 3526, 3527, 3539, 3540, 3540, 3528, 3527, 3528, 3540, 3541, 3541, 3529, 3528, 3505, 3505, 3542, 3542, 3530, 3505, 3530, 3542, 3543, 3543, 3531, 3530, 3531, 3543, 3544, 3544, 3532, 3531, 3532, 3544, 3545, 3545, 3533, 3532, 3533, 3545, 3546, 3546, 3534, 3533, 3534, 3546, 3547, 3547, 3535, 3534, 3535, 3547, 3548, 3548, 3536, 3535, 3536, 3548, 3549, 3549, 3537, 3536, 3537, 3549, 3550, 3550, 3538, 3537, 3538, 3550, 3551, 3551, 3539, 3538, 3539, 3551, 3552, 3552, 3540, 3539, 3540, 3552, 3553, 3553, 3541, 3540, 3505, 3505, 3554, 3554, 3542, 3505, 3542, 3554, 3555, 3555, 3543, 3542, 3543, 3555, 3556, 3556, 3544, 3543, 3544, 3556, 3557, 3557, 3545, 3544, 3545, 3557, 3558, 3558, 3546, 3545, 3546, 3558, 3559, 3559, 3547, 3546, 3547, 3559, 3560, 3560, 3548, 3547, 3548, 3560, 3561, 3561, 3549, 3548, 3549, 3561, 3562, 3562, 3550, 3549, 3550, 3562, 3563, 3563, 3551, 3550, 3551, 3563, 3564, 3564, 3552, 3551, 3552, 3564, 3565, 3565, 3553, 3552, 3505, 3505, 3566, 3566, 3554, 3505, 3554, 3566, 3567, 3567, 3555, 3554, 3555, 3567, 3568, 3568, 3556, 3555, 3556, 3568, 3569, 3569, 3557, 3556, 3557, 3569, 3570, 3570, 3558, 3557, 3558, 3570, 3571, 3571, 3559, 3558, 3559, 3571, 3572, 3572, 3560, 3559, 3560, 3572, 3573, 3573, 3561, 3560, 3561, 3573, 3574, 3574, 3562, 3561, 3562, 3574, 3575, 3575, 3563, 3562, 3563, 3575, 3576, 3576, 3564, 3563, 3564, 3576, 3577, 3577, 3565, 3564, 3505, 3505, 3578, 3578, 3566, 3505, 3566, 3578, 3579, 3579, 3567, 3566, 3567, 3579, 3580, 3580, 3568, 3567, 3568, 3580, 3581, 3581, 3569, 3568, 3569, 3581, 3582, 3582, 3570, 3569, 3570, 3582, 3583, 3583, 3571, 3570, 3571, 3583, 3584, 3584, 3572, 3571, 3572, 3584, 3585, 3585, 3573, 3572, 3573, 3585, 3586, 3586, 3574, 3573, 3574, 3586, 3587, 3587, 3575, 3574, 3575, 3587, 3588, 3588, 3576, 3575, 3576, 3588, 3589, 3589, 3577, 3576, 3505, 3505, 3590, 3590, 3578, 3505, 3578, 3590, 3591, 3591, 3579, 3578, 3579, 3591, 3592, 3592, 3580, 3579, 3580, 3592, 3593, 3593, 3581, 3580, 3581, 3593, 3594, 3594, 3582, 3581, 3582, 3594, 3595, 3595, 3583, 3582, 3583, 3595, 3596, 3596, 3584, 3583, 3584, 3596, 3597, 3597, 3585, 3584, 3585, 3597, 3598, 3598, 3586, 3585, 3586, 3598, 3599, 3599, 3587, 3586, 3587, 3599, 3600, 3600, 3588, 3587, 3588, 3600, 3601, 3601, 3589, 3588, 3505, 3505, 3602, 3602, 3590, 3505, 3590, 3602, 3603, 3603, 3591, 3590, 3591, 3603, 3604, 3604, 3592, 3591, 3592, 3604, 3605, 3605, 3593, 3592, 3593, 3605, 3606, 3606, 3594, 3593, 3594, 3606, 3607, 3607, 3595, 3594, 3595, 3607, 3608, 3608, 3596, 3595, 3596, 3608, 3609, 3609, 3597, 3596, 3597, 3609, 3610, 3610, 3598, 3597, 3598, 3610, 3611, 3611, 3599, 3598, 3599, 3611, 3612, 3612, 3600, 3599, 3600, 3612, 3613, 3613, 3601, 3600, 3505, 3505, 3614, 3614, 3602, 3505, 3602, 3614, 3615, 3615, 3603, 3602, 3603, 3615, 3616, 3616, 3604, 3603, 3604, 3616, 3617, 3617, 3605, 3604, 3605, 3617, 3618, 3618, 3606, 3605, 3606, 3618, 3619, 3619, 3607, 3606, 3607, 3619, 3620, 3620, 3608, 3607, 3608, 3620, 3621, 3621, 3609, 3608, 3609, 3621, 3622, 3622, 3610, 3609, 3610, 3622, 3623, 3623, 3611, 3610, 3611, 3623, 3624, 3624, 3612, 3611, 3612, 3624, 3625, 3625, 3613, 3612, 3505, 3505, 3626, 3626, 3614, 3505, 3614, 3626, 3627, 3627, 3615, 3614, 3615, 3627, 3628, 3628, 3616, 3615, 3616, 3628, 3629, 3629, 3617, 3616, 3617, 3629, 3630, 3630, 3618, 3617, 3618, 3630, 3631, 3631, 3619, 3618, 3619, 3631, 3632, 3632, 3620, 3619, 3620, 3632, 3633, 3633, 3621, 3620, 3621, 3633, 3634, 3634, 3622, 3621, 3622, 3634, 3635, 3635, 3623, 3622, 3623, 3635, 3636, 3636, 3624, 3623, 3624, 3636, 3637, 3637, 3625, 3624, 3505, 3505, 3638, 3638, 3626, 3505, 3626, 3638, 3639, 3639, 3627, 3626, 3627, 3639, 3640, 3640, 3628, 3627, 3628, 3640, 3641, 3641, 3629, 3628, 3629, 3641, 3642, 3642, 3630, 3629, 3630, 3642, 3643, 3643, 3631, 3630, 3631, 3643, 3644, 3644, 3632, 3631, 3632, 3644, 3645, 3645, 3633, 3632, 3633, 3645, 3646, 3646, 3634, 3633, 3634, 3646, 3647, 3647, 3635, 3634, 3635, 3647, 3648, 3648, 3636, 3635, 3636, 3648, 3649, 3649, 3637, 3636, 3505, 3505, 3650, 3650, 3638, 3505, 3638, 3650, 3651, 3651, 3639, 3638, 3639, 3651, 3652, 3652, 3640, 3639, 3640, 3652, 3653, 3653, 3641, 3640, 3641, 3653, 3654, 3654, 3642, 3641, 3642, 3654, 3655, 3655, 3643, 3642, 3643, 3655, 3656, 3656, 3644, 3643, 3644, 3656, 3657, 3657, 3645, 3644, 3645, 3657, 3658, 3658, 3646, 3645, 3646, 3658, 3659, 3659, 3647, 3646, 3647, 3659, 3660, 3660, 3648, 3647, 3648, 3660, 3661, 3661, 3649, 3648, 3505, 3505, 3662, 3662, 3650, 3505, 3650, 3662, 3663, 3663, 3651, 3650, 3651, 3663, 3664, 3664, 3652, 3651, 3652, 3664, 3665, 3665, 3653, 3652, 3653, 3665, 3666, 3666, 3654, 3653, 3654, 3666, 3667, 3667, 3655, 3654, 3655, 3667, 3668, 3668, 3656, 3655, 3656, 3668, 3669, 3669, 3657, 3656, 3657, 3669, 3670, 3670, 3658, 3657, 3658, 3670, 3671, 3671, 3659, 3658, 3659, 3671, 3672, 3672, 3660, 3659, 3660, 3672, 3673, 3673, 3661, 3660, 3505, 3505, 3674, 3674, 3662, 3505, 3662, 3674, 3675, 3675, 3663, 3662, 3663, 3675, 3676, 3676, 3664, 3663, 3664, 3676, 3677, 3677, 3665, 3664, 3665, 3677, 3678, 3678, 3666, 3665, 3666, 3678, 3679, 3679, 3667, 3666, 3667, 3679, 3680, 3680, 3668, 3667, 3668, 3680, 3681, 3681, 3669, 3668, 3669, 3681, 3682, 3682, 3670, 3669, 3670, 3682, 3683, 3683, 3671, 3670, 3671, 3683, 3684, 3684, 3672, 3671, 3672, 3684, 3685, 3685, 3673, 3672, 3505, 3505, 3686, 3686, 3674, 3505, 3674, 3686, 3687, 3687, 3675, 3674, 3675, 3687, 3688, 3688, 3676, 3675, 3676, 3688, 3689, 3689, 3677, 3676, 3677, 3689, 3690, 3690, 3678, 3677, 3678, 3690, 3691, 3691, 3679, 3678, 3679, 3691, 3692, 3692, 3680, 3679, 3680, 3692, 3693, 3693, 3681, 3680, 3681, 3693, 3694, 3694, 3682, 3681, 3682, 3694, 3695, 3695, 3683, 3682, 3683, 3695, 3696, 3696, 3684, 3683, 3684, 3696, 3697, 3697, 3685, 3684, 3505, 3505, 3698, 3698, 3686, 3505, 3686, 3698, 3699, 3699, 3687, 3686, 3687, 3699, 3700, 3700, 3688, 3687, 3688, 3700, 3701, 3701, 3689, 3688, 3689, 3701, 3702, 3702, 3690, 3689, 3690, 3702, 3703, 3703, 3691, 3690, 3691, 3703, 3704, 3704, 3692, 3691, 3692, 3704, 3705, 3705, 3693, 3692, 3693, 3705, 3706, 3706, 3694, 3693, 3694, 3706, 3707, 3707, 3695, 3694, 3695, 3707, 3708, 3708, 3696, 3695, 3696, 3708, 3709, 3709, 3697, 3696, 3505, 3505, 3710, 3710, 3698, 3505, 3698, 3710, 3711, 3711, 3699, 3698, 3699, 3711, 3712, 3712, 3700, 3699, 3700, 3712, 3713, 3713, 3701, 3700, 3701, 3713, 3714, 3714, 3702, 3701, 3702, 3714, 3715, 3715, 3703, 3702, 3703, 3715, 3716, 3716, 3704, 3703, 3704, 3716, 3717, 3717, 3705, 3704, 3705, 3717, 3718, 3718, 3706, 3705, 3706, 3718, 3719, 3719, 3707, 3706, 3707, 3719, 3720, 3720, 3708, 3707, 3708, 3720, 3721, 3721, 3709, 3708, 3505, 3505, 3722, 3722, 3710, 3505, 3710, 3722, 3723, 3723, 3711, 3710, 3711, 3723, 3724, 3724, 3712, 3711, 3712, 3724, 3725, 3725, 3713, 3712, 3713, 3725, 3726, 3726, 3714, 3713, 3714, 3726, 3727, 3727, 3715, 3714, 3715, 3727, 3728, 3728, 3716, 3715, 3716, 3728, 3729, 3729, 3717, 3716, 3717, 3729, 3730, 3730, 3718, 3717, 3718, 3730, 3731, 3731, 3719, 3718, 3719, 3731, 3732, 3732, 3720, 3719, 3720, 3732, 3733, 3733, 3721, 3720, 3505, 3505, 3734, 3734, 3722, 3505, 3722, 3734, 3735, 3735, 3723, 3722, 3723, 3735, 3736, 3736, 3724, 3723, 3724, 3736, 3737, 3737, 3725, 3724, 3725, 3737, 3738, 3738, 3726, 3725, 3726, 3738, 3739, 3739, 3727, 3726, 3727, 3739, 3740, 3740, 3728, 3727, 3728, 3740, 3741, 3741, 3729, 3728, 3729, 3741, 3742, 3742, 3730, 3729, 3730, 3742, 3743, 3743, 3731, 3730, 3731, 3743, 3744, 3744, 3732, 3731, 3732, 3744, 3745, 3745, 3733, 3732, 3505, 3505, 3746, 3746, 3734, 3505, 3734, 3746, 3747, 3747, 3735, 3734, 3735, 3747, 3748, 3748, 3736, 3735, 3736, 3748, 3749, 3749, 3737, 3736, 3737, 3749, 3750, 3750, 3738, 3737, 3738, 3750, 3751, 3751, 3739, 3738, 3739, 3751, 3752, 3752, 3740, 3739, 3740, 3752, 3753, 3753, 3741, 3740, 3741, 3753, 3754, 3754, 3742, 3741, 3742, 3754, 3755, 3755, 3743, 3742, 3743, 3755, 3756, 3756, 3744, 3743, 3744, 3756, 3757, 3757, 3745, 3744, 3505, 3505, 3758, 3758, 3746, 3505, 3746, 3758, 3759, 3759, 3747, 3746, 3747, 3759, 3760, 3760, 3748, 3747, 3748, 3760, 3761, 3761, 3749, 3748, 3749, 3761, 3762, 3762, 3750, 3749, 3750, 3762, 3763, 3763, 3751, 3750, 3751, 3763, 3764, 3764, 3752, 3751, 3752, 3764, 3765, 3765, 3753, 3752, 3753, 3765, 3766, 3766, 3754, 3753, 3754, 3766, 3767, 3767, 3755, 3754, 3755, 3767, 3768, 3768, 3756, 3755, 3756, 3768, 3769, 3769, 3757, 3756, 3505, 3505, 3770, 3770, 3758, 3505, 3758, 3770, 3771, 3771, 3759, 3758, 3759, 3771, 3772, 3772, 3760, 3759, 3760, 3772, 3773, 3773, 3761, 3760, 3761, 3773, 3774, 3774, 3762, 3761, 3762, 3774, 3775, 3775, 3763, 3762, 3763, 3775, 3776, 3776, 3764, 3763, 3764, 3776, 3777, 3777, 3765, 3764, 3765, 3777, 3778, 3778, 3766, 3765, 3766, 3778, 3779, 3779, 3767, 3766, 3767, 3779, 3780, 3780, 3768, 3767, 3768, 3780, 3781, 3781, 3769, 3768, 3505, 3505, 3782, 3782, 3770, 3505, 3770, 3782, 3783, 3783, 3771, 3770, 3771, 3783, 3784, 3784, 3772, 3771, 3772, 3784, 3785, 3785, 3773, 3772, 3773, 3785, 3786, 3786, 3774, 3773, 3774, 3786, 3787, 3787, 3775, 3774, 3775, 3787, 3788, 3788, 3776, 3775, 3776, 3788, 3789, 3789, 3777, 3776, 3777, 3789, 3790, 3790, 3778, 3777, 3778, 3790, 3791, 3791, 3779, 3778, 3779, 3791, 3792, 3792, 3780, 3779, 3780, 3792, 3793, 3793, 3781, 3780, 3505, 3505, 3794, 3794, 3782, 3505, 3782, 3794, 3795, 3795, 3783, 3782, 3783, 3795, 3796, 3796, 3784, 3783, 3784, 3796, 3797, 3797, 3785, 3784, 3785, 3797, 3798, 3798, 3786, 3785, 3786, 3798, 3799, 3799, 3787, 3786, 3787, 3799, 3800, 3800, 3788, 3787, 3788, 3800, 3801, 3801, 3789, 3788, 3789, 3801, 3802, 3802, 3790, 3789, 3790, 3802, 3803, 3803, 3791, 3790, 3791, 3803, 3804, 3804, 3792, 3791, 3792, 3804, 3805, 3805, 3793, 3792, 3505, 3505, 3806, 3806, 3794, 3505, 3794, 3806, 3807, 3807, 3795, 3794, 3795, 3807, 3808, 3808, 3796, 3795, 3796, 3808, 3809, 3809, 3797, 3796, 3797, 3809, 3810, 3810, 3798, 3797, 3798, 3810, 3811, 3811, 3799, 3798, 3799, 3811, 3812, 3812, 3800, 3799, 3800, 3812, 3813, 3813, 3801, 3800, 3801, 3813, 3814, 3814, 3802, 3801, 3802, 3814, 3815, 3815, 3803, 3802, 3803, 3815, 3816, 3816, 3804, 3803, 3804, 3816, 3817, 3817, 3805, 3804, 3505, 3505, 3818, 3818, 3806, 3505, 3806, 3818, 3819, 3819, 3807, 3806, 3807, 3819, 3820, 3820, 3808, 3807, 3808, 3820, 3821, 3821, 3809, 3808, 3809, 3821, 3822, 3822, 3810, 3809, 3810, 3822, 3823, 3823, 3811, 3810, 3811, 3823, 3824, 3824, 3812, 3811, 3812, 3824, 3825, 3825, 3813, 3812, 3813, 3825, 3826, 3826, 3814, 3813, 3814, 3826, 3827, 3827, 3815, 3814, 3815, 3827, 3828, 3828, 3816, 3815, 3816, 3828, 3829, 3829, 3817, 3816, 3505, 3505, 3830, 3830, 3818, 3505, 3818, 3830, 3831, 3831, 3819, 3818, 3819, 3831, 3832, 3832, 3820, 3819, 3820, 3832, 3833, 3833, 3821, 3820, 3821, 3833, 3834, 3834, 3822, 3821, 3822, 3834, 3835, 3835, 3823, 3822, 3823, 3835, 3836, 3836, 3824, 3823, 3824, 3836, 3837, 3837, 3825, 3824, 3825, 3837, 3838, 3838, 3826, 3825, 3826, 3838, 3839, 3839, 3827, 3826, 3827, 3839, 3840, 3840, 3828, 3827, 3828, 3840, 3841, 3841, 3829, 3828, 3505, 3505, 3842, 3842, 3830, 3505, 3830, 3842, 3843, 3843, 3831, 3830, 3831, 3843, 3844, 3844, 3832, 3831, 3832, 3844, 3845, 3845, 3833, 3832, 3833, 3845, 3846, 3846, 3834, 3833, 3834, 3846, 3847, 3847, 3835, 3834, 3835, 3847, 3848, 3848, 3836, 3835, 3836, 3848, 3849, 3849, 3837, 3836, 3837, 3849, 3850, 3850, 3838, 3837, 3838, 3850, 3851, 3851, 3839, 3838, 3839, 3851, 3852, 3852, 3840, 3839, 3840, 3852, 3853, 3853, 3841, 3840, 3505, 3505, 3854, 3854, 3842, 3505, 3842, 3854, 3855, 3855, 3843, 3842, 3843, 3855, 3856, 3856, 3844, 3843, 3844, 3856, 3857, 3857, 3845, 3844, 3845, 3857, 3858, 3858, 3846, 3845, 3846, 3858, 3859, 3859, 3847, 3846, 3847, 3859, 3860, 3860, 3848, 3847, 3848, 3860, 3861, 3861, 3849, 3848, 3849, 3861, 3862, 3862, 3850, 3849, 3850, 3862, 3863, 3863, 3851, 3850, 3851, 3863, 3864, 3864, 3852, 3851, 3852, 3864, 3865, 3865, 3853, 3852, 3505, 3505, 3866, 3866, 3854, 3505, 3854, 3866, 3867, 3867, 3855, 3854, 3855, 3867, 3868, 3868, 3856, 3855, 3856, 3868, 3869, 3869, 3857, 3856, 3857, 3869, 3870, 3870, 3858, 3857, 3858, 3870, 3871, 3871, 3859, 3858, 3859, 3871, 3872, 3872, 3860, 3859, 3860, 3872, 3873, 3873, 3861, 3860, 3861, 3873, 3874, 3874, 3862, 3861, 3862, 3874, 3875, 3875, 3863, 3862, 3863, 3875, 3876, 3876, 3864, 3863, 3864, 3876, 3877, 3877, 3865, 3864, 3505, 3505, 3878, 3878, 3866, 3505, 3866, 3878, 3879, 3879, 3867, 3866, 3867, 3879, 3880, 3880, 3868, 3867, 3868, 3880, 3881, 3881, 3869, 3868, 3869, 3881, 3882, 3882, 3870, 3869, 3870, 3882, 3883, 3883, 3871, 3870, 3871, 3883, 3884, 3884, 3872, 3871, 3872, 3884, 3885, 3885, 3873, 3872, 3873, 3885, 3886, 3886, 3874, 3873, 3874, 3886, 3887, 3887, 3875, 3874, 3875, 3887, 3888, 3888, 3876, 3875, 3876, 3888, 3889, 3889, 3877, 3876, 3505, 3505, 3890, 3890, 3878, 3505, 3878, 3890, 3891, 3891, 3879, 3878, 3879, 3891, 3892, 3892, 3880, 3879, 3880, 3892, 3893, 3893, 3881, 3880, 3881, 3893, 3894, 3894, 3882, 3881, 3882, 3894, 3895, 3895, 3883, 3882, 3883, 3895, 3896, 3896, 3884, 3883, 3884, 3896, 3897, 3897, 3885, 3884, 3885, 3897, 3898, 3898, 3886, 3885, 3886, 3898, 3899, 3899, 3887, 3886, 3887, 3899, 3900, 3900, 3888, 3887, 3888, 3900, 3901, 3901, 3889, 3888, 3505, 3505, 3902, 3902, 3890, 3505, 3890, 3902, 3903, 3903, 3891, 3890, 3891, 3903, 3904, 3904, 3892, 3891, 3892, 3904, 3905, 3905, 3893, 3892, 3893, 3905, 3906, 3906, 3894, 3893, 3894, 3906, 3907, 3907, 3895, 3894, 3895, 3907, 3908, 3908, 3896, 3895, 3896, 3908, 3909, 3909, 3897, 3896, 3897, 3909, 3910, 3910, 3898, 3897, 3898, 3910, 3911, 3911, 3899, 3898, 3899, 3911, 3912, 3912, 3900, 3899, 3900, 3912, 3913, 3913, 3901, 3900, 3505, 3505, 3914, 3914, 3902, 3505, 3902, 3914, 3915, 3915, 3903, 3902, 3903, 3915, 3916, 3916, 3904, 3903, 3904, 3916, 3917, 3917, 3905, 3904, 3905, 3917, 3918, 3918, 3906, 3905, 3906, 3918, 3919, 3919, 3907, 3906, 3907, 3919, 3920, 3920, 3908, 3907, 3908, 3920, 3921, 3921, 3909, 3908, 3909, 3921, 3922, 3922, 3910, 3909, 3910, 3922, 3923, 3923, 3911, 3910, 3911, 3923, 3924, 3924, 3912, 3911, 3912, 3924, 3925, 3925, 3913, 3912, 3505, 3505, 3926, 3926, 3914, 3505, 3914, 3926, 3927, 3927, 3915, 3914, 3915, 3927, 3928, 3928, 3916, 3915, 3916, 3928, 3929, 3929, 3917, 3916, 3917, 3929, 3930, 3930, 3918, 3917, 3918, 3930, 3931, 3931, 3919, 3918, 3919, 3931, 3932, 3932, 3920, 3919, 3920, 3932, 3933, 3933, 3921, 3920, 3921, 3933, 3934, 3934, 3922, 3921, 3922, 3934, 3935, 3935, 3923, 3922, 3923, 3935, 3936, 3936, 3924, 3923, 3924, 3936, 3937, 3937, 3925, 3924, 3505, 3505, 3938, 3938, 3926, 3505, 3926, 3938, 3939, 3939, 3927, 3926, 3927, 3939, 3940, 3940, 3928, 3927, 3928, 3940, 3941, 3941, 3929, 3928, 3929, 3941, 3942, 3942, 3930, 3929, 3930, 3942, 3943, 3943, 3931, 3930, 3931, 3943, 3944, 3944, 3932, 3931, 3932, 3944, 3945, 3945, 3933, 3932, 3933, 3945, 3946, 3946, 3934, 3933, 3934, 3946, 3947, 3947, 3935, 3934, 3935, 3947, 3948, 3948, 3936, 3935, 3936, 3948, 3949, 3949, 3937, 3936, 3505, 3505, 3950, 3950, 3938, 3505, 3938, 3950, 3951, 3951, 3939, 3938, 3939, 3951, 3952, 3952, 3940, 3939, 3940, 3952, 3953, 3953, 3941, 3940, 3941, 3953, 3954, 3954, 3942, 3941, 3942, 3954, 3955, 3955, 3943, 3942, 3943, 3955, 3956, 3956, 3944, 3943, 3944, 3956, 3957, 3957, 3945, 3944, 3945, 3957, 3958, 3958, 3946, 3945, 3946, 3958, 3959, 3959, 3947, 3946, 3947, 3959, 3960, 3960, 3948, 3947, 3948, 3960, 3961, 3961, 3949, 3948, 3505, 3505, 3962, 3962, 3950, 3505, 3950, 3962, 3963, 3963, 3951, 3950, 3951, 3963, 3964, 3964, 3952, 3951, 3952, 3964, 3965, 3965, 3953, 3952, 3953, 3965, 3966, 3966, 3954, 3953, 3954, 3966, 3967, 3967, 3955, 3954, 3955, 3967, 3968, 3968, 3956, 3955, 3956, 3968, 3969, 3969, 3957, 3956, 3957, 3969, 3970, 3970, 3958, 3957, 3958, 3970, 3971, 3971, 3959, 3958, 3959, 3971, 3972, 3972, 3960, 3959, 3960, 3972, 3973, 3973, 3961, 3960, 3505, 3505, 3974, 3974, 3962, 3505, 3962, 3974, 3975, 3975, 3963, 3962, 3963, 3975, 3976, 3976, 3964, 3963, 3964, 3976, 3977, 3977, 3965, 3964, 3965, 3977, 3978, 3978, 3966, 3965, 3966, 3978, 3979, 3979, 3967, 3966, 3967, 3979, 3980, 3980, 3968, 3967, 3968, 3980, 3981, 3981, 3969, 3968, 3969, 3981, 3982, 3982, 3970, 3969, 3970, 3982, 3983, 3983, 3971, 3970, 3971, 3983, 3984, 3984, 3972, 3971, 3972, 3984, 3985, 3985, 3973, 3972, 3505, 3505, 3986, 3986, 3974, 3505, 3974, 3986, 3987, 3987, 3975, 3974, 3975, 3987, 3988, 3988, 3976, 3975, 3976, 3988, 3989, 3989, 3977, 3976, 3977, 3989, 3990, 3990, 3978, 3977, 3978, 3990, 3991, 3991, 3979, 3978, 3979, 3991, 3992, 3992, 3980, 3979, 3980, 3992, 3993, 3993, 3981, 3980, 3981, 3993, 3994, 3994, 3982, 3981, 3982, 3994, 3995, 3995, 3983, 3982, 3983, 3995, 3996, 3996, 3984, 3983, 3984, 3996, 3997, 3997, 3985, 3984, 3505, 3505, 3998, 3998, 3986, 3505, 3986, 3998, 3999, 3999, 3987, 3986, 3987, 3999, 4000, 4000, 3988, 3987, 3988, 4000, 4001, 4001, 3989, 3988, 3989, 4001, 4002, 4002, 3990, 3989, 3990, 4002, 4003, 4003, 3991, 3990, 3991, 4003, 4004, 4004, 3992, 3991, 3992, 4004, 4005, 4005, 3993, 3992, 3993, 4005, 4006, 4006, 3994, 3993, 3994, 4006, 4007, 4007, 3995, 3994, 3995, 4007, 4008, 4008, 3996, 3995, 3996, 4008, 4009, 4009, 3997, 3996, 3505, 3505, 4010, 4010, 3998, 3505, 3998, 4010, 4011, 4011, 3999, 3998, 3999, 4011, 4012, 4012, 4000, 3999, 4000, 4012, 4013, 4013, 4001, 4000, 4001, 4013, 4014, 4014, 4002, 4001, 4002, 4014, 4015, 4015, 4003, 4002, 4003, 4015, 4016, 4016, 4004, 4003, 4004, 4016, 4017, 4017, 4005, 4004, 4005, 4017, 4018, 4018, 4006, 4005, 4006, 4018, 4019, 4019, 4007, 4006, 4007, 4019, 4020, 4020, 4008, 4007, 4008, 4020, 4021, 4021, 4009, 4008, 3505, 3505, 4022, 4022, 4010, 3505, 4010, 4022, 4023, 4023, 4011, 4010, 4011, 4023, 4024, 4024, 4012, 4011, 4012, 4024, 4025, 4025, 4013, 4012, 4013, 4025, 4026, 4026, 4014, 4013, 4014, 4026, 4027, 4027, 4015, 4014, 4015, 4027, 4028, 4028, 4016, 4015, 4016, 4028, 4029, 4029, 4017, 4016, 4017, 4029, 4030, 4030, 4018, 4017, 4018, 4030, 4031, 4031, 4019, 4018, 4019, 4031, 4032, 4032, 4020, 4019, 4020, 4032, 4033, 4033, 4021, 4020, 3505, 3505, 4034, 4034, 4022, 3505, 4022, 4034, 4035, 4035, 4023, 4022, 4023, 4035, 4036, 4036, 4024, 4023, 4024, 4036, 4037, 4037, 4025, 4024, 4025, 4037, 4038, 4038, 4026, 4025, 4026, 4038, 4039, 4039, 4027, 4026, 4027, 4039, 4040, 4040, 4028, 4027, 4028, 4040, 4041, 4041, 4029, 4028, 4029, 4041, 4042, 4042, 4030, 4029, 4030, 4042, 4043, 4043, 4031, 4030, 4031, 4043, 4044, 4044, 4032, 4031, 4032, 4044, 4045, 4045, 4033, 4032, 3505, 3505, 4046, 4046, 4034, 3505, 4034, 4046, 4047, 4047, 4035, 4034, 4035, 4047, 4048, 4048, 4036, 4035, 4036, 4048, 4049, 4049, 4037, 4036, 4037, 4049, 4050, 4050, 4038, 4037, 4038, 4050, 4051, 4051, 4039, 4038, 4039, 4051, 4052, 4052, 4040, 4039, 4040, 4052, 4053, 4053, 4041, 4040, 4041, 4053, 4054, 4054, 4042, 4041, 4042, 4054, 4055, 4055, 4043, 4042, 4043, 4055, 4056, 4056, 4044, 4043, 4044, 4056, 4057, 4057, 4045, 4044, 3505, 3505, 4058, 4058, 4046, 3505, 4046, 4058, 4059, 4059, 4047, 4046, 4047, 4059, 4060, 4060, 4048, 4047, 4048, 4060, 4061, 4061, 4049, 4048, 4049, 4061, 4062, 4062, 4050, 4049, 4050, 4062, 4063, 4063, 4051, 4050, 4051, 4063, 4064, 4064, 4052, 4051, 4052, 4064, 4065, 4065, 4053, 4052, 4053, 4065, 4066, 4066, 4054, 4053, 4054, 4066, 4067, 4067, 4055, 4054, 4055, 4067, 4068, 4068, 4056, 4055, 4056, 4068, 4069, 4069, 4057, 4056, 3505, 3505, 4070, 4070, 4058, 3505, 4058, 4070, 4071, 4071, 4059, 4058, 4059, 4071, 4072, 4072, 4060, 4059, 4060, 4072, 4073, 4073, 4061, 4060, 4061, 4073, 4074, 4074, 4062, 4061, 4062, 4074, 4075, 4075, 4063, 4062, 4063, 4075, 4076, 4076, 4064, 4063, 4064, 4076, 4077, 4077, 4065, 4064, 4065, 4077, 4078, 4078, 4066, 4065, 4066, 4078, 4079, 4079, 4067, 4066, 4067, 4079, 4080, 4080, 4068, 4067, 4068, 4080, 4081, 4081, 4069, 4068, 3505, 3505, 3506, 3506, 4070, 3505, 4070, 3506, 3507, 3507, 4071, 4070, 4071, 3507, 3508, 3508, 4072, 4071, 4072, 3508, 3509, 3509, 4073, 4072, 4073, 3509, 3510, 3510, 4074, 4073, 4074, 3510, 3511, 3511, 4075, 4074, 4075, 3511, 3512, 3512, 4076, 4075, 4076, 3512, 3513, 3513, 4077, 4076, 4077, 3513, 3514, 3514, 4078, 4077, 4078, 3514, 3515, 3515, 4079, 4078, 4079, 3515, 3516, 3516, 4080, 4079, 4080, 3516, 3517, 3517, 4081, 4080, 3517, 3529, 4094, 4094, 4082, 3517, 4082, 4094, 4095, 4095, 4083, 4082, 4083, 4095, 4096, 4096, 4084, 4083, 4084, 4096, 4097, 4097, 4085, 4084, 4085, 4097, 4098, 4098, 4086, 4085, 4086, 4098, 4099, 4099, 4087, 4086, 4087, 4099, 4100, 4100, 4088, 4087, 4088, 4100, 4101, 4101, 4089, 4088, 4089, 4101, 4102, 4102, 4090, 4089, 4090, 4102, 4103, 4103, 4091, 4090, 4091, 4103, 4104, 4104, 4092, 4091, 4092, 4104, 4105, 4105, 4093, 4092, 3529, 3541, 4106, 4106, 4094, 3529, 4094, 4106, 4107, 4107, 4095, 4094, 4095, 4107, 4108, 4108, 4096, 4095, 4096, 4108, 4109, 4109, 4097, 4096, 4097, 4109, 4110, 4110, 4098, 4097, 4098, 4110, 4111, 4111, 4099, 4098, 4099, 4111, 4112, 4112, 4100, 4099, 4100, 4112, 4113, 4113, 4101, 4100, 4101, 4113, 4114, 4114, 4102, 4101, 4102, 4114, 4115, 4115, 4103, 4102, 4103, 4115, 4116, 4116, 4104, 4103, 4104, 4116, 4117, 4117, 4105, 4104, 3541, 3553, 4118, 4118, 4106, 3541, 4106, 4118, 4119, 4119, 4107, 4106, 4107, 4119, 4120, 4120, 4108, 4107, 4108, 4120, 4121, 4121, 4109, 4108, 4109, 4121, 4122, 4122, 4110, 4109, 4110, 4122, 4123, 4123, 4111, 4110, 4111, 4123, 4124, 4124, 4112, 4111, 4112, 4124, 4125, 4125, 4113, 4112, 4113, 4125, 4126, 4126, 4114, 4113, 4114, 4126, 4127, 4127, 4115, 4114, 4115, 4127, 4128, 4128, 4116, 4115, 4116, 4128, 4129, 4129, 4117, 4116, 3553, 3565, 4130, 4130, 4118, 3553, 4118, 4130, 4131, 4131, 4119, 4118, 4119, 4131, 4132, 4132, 4120, 4119, 4120, 4132, 4133, 4133, 4121, 4120, 4121, 4133, 4134, 4134, 4122, 4121, 4122, 4134, 4135, 4135, 4123, 4122, 4123, 4135, 4136, 4136, 4124, 4123, 4124, 4136, 4137, 4137, 4125, 4124, 4125, 4137, 4138, 4138, 4126, 4125, 4126, 4138, 4139, 4139, 4127, 4126, 4127, 4139, 4140, 4140, 4128, 4127, 4128, 4140, 4141, 4141, 4129, 4128, 3565, 3577, 4142, 4142, 4130, 3565, 4130, 4142, 4143, 4143, 4131, 4130, 4131, 4143, 4144, 4144, 4132, 4131, 4132, 4144, 4145, 4145, 4133, 4132, 4133, 4145, 4146, 4146, 4134, 4133, 4134, 4146, 4147, 4147, 4135, 4134, 4135, 4147, 4148, 4148, 4136, 4135, 4136, 4148, 4149, 4149, 4137, 4136, 4137, 4149, 4150, 4150, 4138, 4137, 4138, 4150, 4151, 4151, 4139, 4138, 4139, 4151, 4152, 4152, 4140, 4139, 4140, 4152, 4153, 4153, 4141, 4140, 3577, 3589, 4154, 4154, 4142, 3577, 4142, 4154, 4155, 4155, 4143, 4142, 4143, 4155, 4156, 4156, 4144, 4143, 4144, 4156, 4157, 4157, 4145, 4144, 4145, 4157, 4158, 4158, 4146, 4145, 4146, 4158, 4159, 4159, 4147, 4146, 4147, 4159, 4160, 4160, 4148, 4147, 4148, 4160, 4161, 4161, 4149, 4148, 4149, 4161, 4162, 4162, 4150, 4149, 4150, 4162, 4163, 4163, 4151, 4150, 4151, 4163, 4164, 4164, 4152, 4151, 4152, 4164, 4165, 4165, 4153, 4152, 3589, 3601, 4166, 4166, 4154, 3589, 4154, 4166, 4167, 4167, 4155, 4154, 4155, 4167, 4168, 4168, 4156, 4155, 4156, 4168, 4169, 4169, 4157, 4156, 4157, 4169, 4170, 4170, 4158, 4157, 4158, 4170, 4171, 4171, 4159, 4158, 4159, 4171, 4172, 4172, 4160, 4159, 4160, 4172, 4173, 4173, 4161, 4160, 4161, 4173, 4174, 4174, 4162, 4161, 4162, 4174, 4175, 4175, 4163, 4162, 4163, 4175, 4176, 4176, 4164, 4163, 4164, 4176, 4177, 4177, 4165, 4164, 3601, 3613, 4178, 4178, 4166, 3601, 4166, 4178, 4179, 4179, 4167, 4166, 4167, 4179, 4180, 4180, 4168, 4167, 4168, 4180, 4181, 4181, 4169, 4168, 4169, 4181, 4182, 4182, 4170, 4169, 4170, 4182, 4183, 4183, 4171, 4170, 4171, 4183, 4184, 4184, 4172, 4171, 4172, 4184, 4185, 4185, 4173, 4172, 4173, 4185, 4186, 4186, 4174, 4173, 4174, 4186, 4187, 4187, 4175, 4174, 4175, 4187, 4188, 4188, 4176, 4175, 4176, 4188, 4189, 4189, 4177, 4176, 3613, 3625, 4190, 4190, 4178, 3613, 4178, 4190, 4191, 4191, 4179, 4178, 4179, 4191, 4192, 4192, 4180, 4179, 4180, 4192, 4193, 4193, 4181, 4180, 4181, 4193, 4194, 4194, 4182, 4181, 4182, 4194, 4195, 4195, 4183, 4182, 4183, 4195, 4196, 4196, 4184, 4183, 4184, 4196, 4197, 4197, 4185, 4184, 4185, 4197, 4198, 4198, 4186, 4185, 4186, 4198, 4199, 4199, 4187, 4186, 4187, 4199, 4200, 4200, 4188, 4187, 4188, 4200, 4201, 4201, 4189, 4188, 3625, 3637, 4202, 4202, 4190, 3625, 4190, 4202, 4203, 4203, 4191, 4190, 4191, 4203, 4204, 4204, 4192, 4191, 4192, 4204, 4205, 4205, 4193, 4192, 4193, 4205, 4206, 4206, 4194, 4193, 4194, 4206, 4207, 4207, 4195, 4194, 4195, 4207, 4208, 4208, 4196, 4195, 4196, 4208, 4209, 4209, 4197, 4196, 4197, 4209, 4210, 4210, 4198, 4197, 4198, 4210, 4211, 4211, 4199, 4198, 4199, 4211, 4212, 4212, 4200, 4199, 4200, 4212, 4213, 4213, 4201, 4200, 3637, 3649, 4214, 4214, 4202, 3637, 4202, 4214, 4215, 4215, 4203, 4202, 4203, 4215, 4216, 4216, 4204, 4203, 4204, 4216, 4217, 4217, 4205, 4204, 4205, 4217, 4218, 4218, 4206, 4205, 4206, 4218, 4219, 4219, 4207, 4206, 4207, 4219, 4220, 4220, 4208, 4207, 4208, 4220, 4221, 4221, 4209, 4208, 4209, 4221, 4222, 4222, 4210, 4209, 4210, 4222, 4223, 4223, 4211, 4210, 4211, 4223, 4224, 4224, 4212, 4211, 4212, 4224, 4225, 4225, 4213, 4212, 3649, 3661, 4226, 4226, 4214, 3649, 4214, 4226, 4227, 4227, 4215, 4214, 4215, 4227, 4228, 4228, 4216, 4215, 4216, 4228, 4229, 4229, 4217, 4216, 4217, 4229, 4230, 4230, 4218, 4217, 4218, 4230, 4231, 4231, 4219, 4218, 4219, 4231, 4232, 4232, 4220, 4219, 4220, 4232, 4233, 4233, 4221, 4220, 4221, 4233, 4234, 4234, 4222, 4221, 4222, 4234, 4235, 4235, 4223, 4222, 4223, 4235, 4236, 4236, 4224, 4223, 4224, 4236, 4237, 4237, 4225, 4224, 3661, 3673, 4238, 4238, 4226, 3661, 4226, 4238, 4239, 4239, 4227, 4226, 4227, 4239, 4240, 4240, 4228, 4227, 4228, 4240, 4241, 4241, 4229, 4228, 4229, 4241, 4242, 4242, 4230, 4229, 4230, 4242, 4243, 4243, 4231, 4230, 4231, 4243, 4244, 4244, 4232, 4231, 4232, 4244, 4245, 4245, 4233, 4232, 4233, 4245, 4246, 4246, 4234, 4233, 4234, 4246, 4247, 4247, 4235, 4234, 4235, 4247, 4248, 4248, 4236, 4235, 4236, 4248, 4249, 4249, 4237, 4236, 3673, 3685, 4250, 4250, 4238, 3673, 4238, 4250, 4251, 4251, 4239, 4238, 4239, 4251, 4252, 4252, 4240, 4239, 4240, 4252, 4253, 4253, 4241, 4240, 4241, 4253, 4254, 4254, 4242, 4241, 4242, 4254, 4255, 4255, 4243, 4242, 4243, 4255, 4256, 4256, 4244, 4243, 4244, 4256, 4257, 4257, 4245, 4244, 4245, 4257, 4258, 4258, 4246, 4245, 4246, 4258, 4259, 4259, 4247, 4246, 4247, 4259, 4260, 4260, 4248, 4247, 4248, 4260, 4261, 4261, 4249, 4248, 3685, 3697, 4262, 4262, 4250, 3685, 4250, 4262, 4263, 4263, 4251, 4250, 4251, 4263, 4264, 4264, 4252, 4251, 4252, 4264, 4265, 4265, 4253, 4252, 4253, 4265, 4266, 4266, 4254, 4253, 4254, 4266, 4267, 4267, 4255, 4254, 4255, 4267, 4268, 4268, 4256, 4255, 4256, 4268, 4269, 4269, 4257, 4256, 4257, 4269, 4270, 4270, 4258, 4257, 4258, 4270, 4271, 4271, 4259, 4258, 4259, 4271, 4272, 4272, 4260, 4259, 4260, 4272, 4273, 4273, 4261, 4260, 3697, 3709, 4274, 4274, 4262, 3697, 4262, 4274, 4275, 4275, 4263, 4262, 4263, 4275, 4276, 4276, 4264, 4263, 4264, 4276, 4277, 4277, 4265, 4264, 4265, 4277, 4278, 4278, 4266, 4265, 4266, 4278, 4279, 4279, 4267, 4266, 4267, 4279, 4280, 4280, 4268, 4267, 4268, 4280, 4281, 4281, 4269, 4268, 4269, 4281, 4282, 4282, 4270, 4269, 4270, 4282, 4283, 4283, 4271, 4270, 4271, 4283, 4284, 4284, 4272, 4271, 4272, 4284, 4285, 4285, 4273, 4272, 3709, 3721, 4286, 4286, 4274, 3709, 4274, 4286, 4287, 4287, 4275, 4274, 4275, 4287, 4288, 4288, 4276, 4275, 4276, 4288, 4289, 4289, 4277, 4276, 4277, 4289, 4290, 4290, 4278, 4277, 4278, 4290, 4291, 4291, 4279, 4278, 4279, 4291, 4292, 4292, 4280, 4279, 4280, 4292, 4293, 4293, 4281, 4280, 4281, 4293, 4294, 4294, 4282, 4281, 4282, 4294, 4295, 4295, 4283, 4282, 4283, 4295, 4296, 4296, 4284, 4283, 4284, 4296, 4297, 4297, 4285, 4284, 3721, 3733, 4298, 4298, 4286, 3721, 4286, 4298, 4299, 4299, 4287, 4286, 4287, 4299, 4300, 4300, 4288, 4287, 4288, 4300, 4301, 4301, 4289, 4288, 4289, 4301, 4302, 4302, 4290, 4289, 4290, 4302, 4303, 4303, 4291, 4290, 4291, 4303, 4304, 4304, 4292, 4291, 4292, 4304, 4305, 4305, 4293, 4292, 4293, 4305, 4306, 4306, 4294, 4293, 4294, 4306, 4307, 4307, 4295, 4294, 4295, 4307, 4308, 4308, 4296, 4295, 4296, 4308, 4309, 4309, 4297, 4296, 3733, 3745, 4310, 4310, 4298, 3733, 4298, 4310, 4311, 4311, 4299, 4298, 4299, 4311, 4312, 4312, 4300, 4299, 4300, 4312, 4313, 4313, 4301, 4300, 4301, 4313, 4314, 4314, 4302, 4301, 4302, 4314, 4315, 4315, 4303, 4302, 4303, 4315, 4316, 4316, 4304, 4303, 4304, 4316, 4317, 4317, 4305, 4304, 4305, 4317, 4318, 4318, 4306, 4305, 4306, 4318, 4319, 4319, 4307, 4306, 4307, 4319, 4320, 4320, 4308, 4307, 4308, 4320, 4321, 4321, 4309, 4308, 3745, 3757, 4322, 4322, 4310, 3745, 4310, 4322, 4323, 4323, 4311, 4310, 4311, 4323, 4324, 4324, 4312, 4311, 4312, 4324, 4325, 4325, 4313, 4312, 4313, 4325, 4326, 4326, 4314, 4313, 4314, 4326, 4327, 4327, 4315, 4314, 4315, 4327, 4328, 4328, 4316, 4315, 4316, 4328, 4329, 4329, 4317, 4316, 4317, 4329, 4330, 4330, 4318, 4317, 4318, 4330, 4331, 4331, 4319, 4318, 4319, 4331, 4332, 4332, 4320, 4319, 4320, 4332, 4333, 4333, 4321, 4320, 3757, 3769, 4334, 4334, 4322, 3757, 4322, 4334, 4335, 4335, 4323, 4322, 4323, 4335, 4336, 4336, 4324, 4323, 4324, 4336, 4337, 4337, 4325, 4324, 4325, 4337, 4338, 4338, 4326, 4325, 4326, 4338, 4339, 4339, 4327, 4326, 4327, 4339, 4340, 4340, 4328, 4327, 4328, 4340, 4341, 4341, 4329, 4328, 4329, 4341, 4342, 4342, 4330, 4329, 4330, 4342, 4343, 4343, 4331, 4330, 4331, 4343, 4344, 4344, 4332, 4331, 4332, 4344, 4345, 4345, 4333, 4332, 3769, 3781, 4346, 4346, 4334, 3769, 4334, 4346, 4347, 4347, 4335, 4334, 4335, 4347, 4348, 4348, 4336, 4335, 4336, 4348, 4349, 4349, 4337, 4336, 4337, 4349, 4350, 4350, 4338, 4337, 4338, 4350, 4351, 4351, 4339, 4338, 4339, 4351, 4352, 4352, 4340, 4339, 4340, 4352, 4353, 4353, 4341, 4340, 4341, 4353, 4354, 4354, 4342, 4341, 4342, 4354, 4355, 4355, 4343, 4342, 4343, 4355, 4356, 4356, 4344, 4343, 4344, 4356, 4357, 4357, 4345, 4344, 3781, 3793, 4358, 4358, 4346, 3781, 4346, 4358, 4359, 4359, 4347, 4346, 4347, 4359, 4360, 4360, 4348, 4347, 4348, 4360, 4361, 4361, 4349, 4348, 4349, 4361, 4362, 4362, 4350, 4349, 4350, 4362, 4363, 4363, 4351, 4350, 4351, 4363, 4364, 4364, 4352, 4351, 4352, 4364, 4365, 4365, 4353, 4352, 4353, 4365, 4366, 4366, 4354, 4353, 4354, 4366, 4367, 4367, 4355, 4354, 4355, 4367, 4368, 4368, 4356, 4355, 4356, 4368, 4369, 4369, 4357, 4356, 3793, 3805, 4370, 4370, 4358, 3793, 4358, 4370, 4371, 4371, 4359, 4358, 4359, 4371, 4372, 4372, 4360, 4359, 4360, 4372, 4373, 4373, 4361, 4360, 4361, 4373, 4374, 4374, 4362, 4361, 4362, 4374, 4375, 4375, 4363, 4362, 4363, 4375, 4376, 4376, 4364, 4363, 4364, 4376, 4377, 4377, 4365, 4364, 4365, 4377, 4378, 4378, 4366, 4365, 4366, 4378, 4379, 4379, 4367, 4366, 4367, 4379, 4380, 4380, 4368, 4367, 4368, 4380, 4381, 4381, 4369, 4368, 3805, 3817, 4382, 4382, 4370, 3805, 4370, 4382, 4383, 4383, 4371, 4370, 4371, 4383, 4384, 4384, 4372, 4371, 4372, 4384, 4385, 4385, 4373, 4372, 4373, 4385, 4386, 4386, 4374, 4373, 4374, 4386, 4387, 4387, 4375, 4374, 4375, 4387, 4388, 4388, 4376, 4375, 4376, 4388, 4389, 4389, 4377, 4376, 4377, 4389, 4390, 4390, 4378, 4377, 4378, 4390, 4391, 4391, 4379, 4378, 4379, 4391, 4392, 4392, 4380, 4379, 4380, 4392, 4393, 4393, 4381, 4380, 3817, 3829, 4394, 4394, 4382, 3817, 4382, 4394, 4395, 4395, 4383, 4382, 4383, 4395, 4396, 4396, 4384, 4383, 4384, 4396, 4397, 4397, 4385, 4384, 4385, 4397, 4398, 4398, 4386, 4385, 4386, 4398, 4399, 4399, 4387, 4386, 4387, 4399, 4400, 4400, 4388, 4387, 4388, 4400, 4401, 4401, 4389, 4388, 4389, 4401, 4402, 4402, 4390, 4389, 4390, 4402, 4403, 4403, 4391, 4390, 4391, 4403, 4404, 4404, 4392, 4391, 4392, 4404, 4405, 4405, 4393, 4392, 3829, 3841, 4406, 4406, 4394, 3829, 4394, 4406, 4407, 4407, 4395, 4394, 4395, 4407, 4408, 4408, 4396, 4395, 4396, 4408, 4409, 4409, 4397, 4396, 4397, 4409, 4410, 4410, 4398, 4397, 4398, 4410, 4411, 4411, 4399, 4398, 4399, 4411, 4412, 4412, 4400, 4399, 4400, 4412, 4413, 4413, 4401, 4400, 4401, 4413, 4414, 4414, 4402, 4401, 4402, 4414, 4415, 4415, 4403, 4402, 4403, 4415, 4416, 4416, 4404, 4403, 4404, 4416, 4417, 4417, 4405, 4404, 3841, 3853, 4418, 4418, 4406, 3841, 4406, 4418, 4419, 4419, 4407, 4406, 4407, 4419, 4420, 4420, 4408, 4407, 4408, 4420, 4421, 4421, 4409, 4408, 4409, 4421, 4422, 4422, 4410, 4409, 4410, 4422, 4423, 4423, 4411, 4410, 4411, 4423, 4424, 4424, 4412, 4411, 4412, 4424, 4425, 4425, 4413, 4412, 4413, 4425, 4426, 4426, 4414, 4413, 4414, 4426, 4427, 4427, 4415, 4414, 4415, 4427, 4428, 4428, 4416, 4415, 4416, 4428, 4429, 4429, 4417, 4416, 3853, 3865, 4430, 4430, 4418, 3853, 4418, 4430, 4431, 4431, 4419, 4418, 4419, 4431, 4432, 4432, 4420, 4419, 4420, 4432, 4433, 4433, 4421, 4420, 4421, 4433, 4434, 4434, 4422, 4421, 4422, 4434, 4435, 4435, 4423, 4422, 4423, 4435, 4436, 4436, 4424, 4423, 4424, 4436, 4437, 4437, 4425, 4424, 4425, 4437, 4438, 4438, 4426, 4425, 4426, 4438, 4439, 4439, 4427, 4426, 4427, 4439, 4440, 4440, 4428, 4427, 4428, 4440, 4441, 4441, 4429, 4428, 3865, 3877, 4442, 4442, 4430, 3865, 4430, 4442, 4443, 4443, 4431, 4430, 4431, 4443, 4444, 4444, 4432, 4431, 4432, 4444, 4445, 4445, 4433, 4432, 4433, 4445, 4446, 4446, 4434, 4433, 4434, 4446, 4447, 4447, 4435, 4434, 4435, 4447, 4448, 4448, 4436, 4435, 4436, 4448, 4449, 4449, 4437, 4436, 4437, 4449, 4450, 4450, 4438, 4437, 4438, 4450, 4451, 4451, 4439, 4438, 4439, 4451, 4452, 4452, 4440, 4439, 4440, 4452, 4453, 4453, 4441, 4440, 3877, 3889, 4454, 4454, 4442, 3877, 4442, 4454, 4455, 4455, 4443, 4442, 4443, 4455, 4456, 4456, 4444, 4443, 4444, 4456, 4457, 4457, 4445, 4444, 4445, 4457, 4458, 4458, 4446, 4445, 4446, 4458, 4459, 4459, 4447, 4446, 4447, 4459, 4460, 4460, 4448, 4447, 4448, 4460, 4461, 4461, 4449, 4448, 4449, 4461, 4462, 4462, 4450, 4449, 4450, 4462, 4463, 4463, 4451, 4450, 4451, 4463, 4464, 4464, 4452, 4451, 4452, 4464, 4465, 4465, 4453, 4452, 3889, 3901, 4466, 4466, 4454, 3889, 4454, 4466, 4467, 4467, 4455, 4454, 4455, 4467, 4468, 4468, 4456, 4455, 4456, 4468, 4469, 4469, 4457, 4456, 4457, 4469, 4470, 4470, 4458, 4457, 4458, 4470, 4471, 4471, 4459, 4458, 4459, 4471, 4472, 4472, 4460, 4459, 4460, 4472, 4473, 4473, 4461, 4460, 4461, 4473, 4474, 4474, 4462, 4461, 4462, 4474, 4475, 4475, 4463, 4462, 4463, 4475, 4476, 4476, 4464, 4463, 4464, 4476, 4477, 4477, 4465, 4464, 3901, 3913, 4478, 4478, 4466, 3901, 4466, 4478, 4479, 4479, 4467, 4466, 4467, 4479, 4480, 4480, 4468, 4467, 4468, 4480, 4481, 4481, 4469, 4468, 4469, 4481, 4482, 4482, 4470, 4469, 4470, 4482, 4483, 4483, 4471, 4470, 4471, 4483, 4484, 4484, 4472, 4471, 4472, 4484, 4485, 4485, 4473, 4472, 4473, 4485, 4486, 4486, 4474, 4473, 4474, 4486, 4487, 4487, 4475, 4474, 4475, 4487, 4488, 4488, 4476, 4475, 4476, 4488, 4489, 4489, 4477, 4476, 3913, 3925, 4490, 4490, 4478, 3913, 4478, 4490, 4491, 4491, 4479, 4478, 4479, 4491, 4492, 4492, 4480, 4479, 4480, 4492, 4493, 4493, 4481, 4480, 4481, 4493, 4494, 4494, 4482, 4481, 4482, 4494, 4495, 4495, 4483, 4482, 4483, 4495, 4496, 4496, 4484, 4483, 4484, 4496, 4497, 4497, 4485, 4484, 4485, 4497, 4498, 4498, 4486, 4485, 4486, 4498, 4499, 4499, 4487, 4486, 4487, 4499, 4500, 4500, 4488, 4487, 4488, 4500, 4501, 4501, 4489, 4488, 3925, 3937, 4502, 4502, 4490, 3925, 4490, 4502, 4503, 4503, 4491, 4490, 4491, 4503, 4504, 4504, 4492, 4491, 4492, 4504, 4505, 4505, 4493, 4492, 4493, 4505, 4506, 4506, 4494, 4493, 4494, 4506, 4507, 4507, 4495, 4494, 4495, 4507, 4508, 4508, 4496, 4495, 4496, 4508, 4509, 4509, 4497, 4496, 4497, 4509, 4510, 4510, 4498, 4497, 4498, 4510, 4511, 4511, 4499, 4498, 4499, 4511, 4512, 4512, 4500, 4499, 4500, 4512, 4513, 4513, 4501, 4500, 3937, 3949, 4514, 4514, 4502, 3937, 4502, 4514, 4515, 4515, 4503, 4502, 4503, 4515, 4516, 4516, 4504, 4503, 4504, 4516, 4517, 4517, 4505, 4504, 4505, 4517, 4518, 4518, 4506, 4505, 4506, 4518, 4519, 4519, 4507, 4506, 4507, 4519, 4520, 4520, 4508, 4507, 4508, 4520, 4521, 4521, 4509, 4508, 4509, 4521, 4522, 4522, 4510, 4509, 4510, 4522, 4523, 4523, 4511, 4510, 4511, 4523, 4524, 4524, 4512, 4511, 4512, 4524, 4525, 4525, 4513, 4512, 3949, 3961, 4526, 4526, 4514, 3949, 4514, 4526, 4527, 4527, 4515, 4514, 4515, 4527, 4528, 4528, 4516, 4515, 4516, 4528, 4529, 4529, 4517, 4516, 4517, 4529, 4530, 4530, 4518, 4517, 4518, 4530, 4531, 4531, 4519, 4518, 4519, 4531, 4532, 4532, 4520, 4519, 4520, 4532, 4533, 4533, 4521, 4520, 4521, 4533, 4534, 4534, 4522, 4521, 4522, 4534, 4535, 4535, 4523, 4522, 4523, 4535, 4536, 4536, 4524, 4523, 4524, 4536, 4537, 4537, 4525, 4524, 3961, 3973, 4538, 4538, 4526, 3961, 4526, 4538, 4539, 4539, 4527, 4526, 4527, 4539, 4540, 4540, 4528, 4527, 4528, 4540, 4541, 4541, 4529, 4528, 4529, 4541, 4542, 4542, 4530, 4529, 4530, 4542, 4543, 4543, 4531, 4530, 4531, 4543, 4544, 4544, 4532, 4531, 4532, 4544, 4545, 4545, 4533, 4532, 4533, 4545, 4546, 4546, 4534, 4533, 4534, 4546, 4547, 4547, 4535, 4534, 4535, 4547, 4548, 4548, 4536, 4535, 4536, 4548, 4549, 4549, 4537, 4536, 3973, 3985, 4550, 4550, 4538, 3973, 4538, 4550, 4551, 4551, 4539, 4538, 4539, 4551, 4552, 4552, 4540, 4539, 4540, 4552, 4553, 4553, 4541, 4540, 4541, 4553, 4554, 4554, 4542, 4541, 4542, 4554, 4555, 4555, 4543, 4542, 4543, 4555, 4556, 4556, 4544, 4543, 4544, 4556, 4557, 4557, 4545, 4544, 4545, 4557, 4558, 4558, 4546, 4545, 4546, 4558, 4559, 4559, 4547, 4546, 4547, 4559, 4560, 4560, 4548, 4547, 4548, 4560, 4561, 4561, 4549, 4548, 3985, 3997, 4562, 4562, 4550, 3985, 4550, 4562, 4563, 4563, 4551, 4550, 4551, 4563, 4564, 4564, 4552, 4551, 4552, 4564, 4565, 4565, 4553, 4552, 4553, 4565, 4566, 4566, 4554, 4553, 4554, 4566, 4567, 4567, 4555, 4554, 4555, 4567, 4568, 4568, 4556, 4555, 4556, 4568, 4569, 4569, 4557, 4556, 4557, 4569, 4570, 4570, 4558, 4557, 4558, 4570, 4571, 4571, 4559, 4558, 4559, 4571, 4572, 4572, 4560, 4559, 4560, 4572, 4573, 4573, 4561, 4560, 3997, 4009, 4574, 4574, 4562, 3997, 4562, 4574, 4575, 4575, 4563, 4562, 4563, 4575, 4576, 4576, 4564, 4563, 4564, 4576, 4577, 4577, 4565, 4564, 4565, 4577, 4578, 4578, 4566, 4565, 4566, 4578, 4579, 4579, 4567, 4566, 4567, 4579, 4580, 4580, 4568, 4567, 4568, 4580, 4581, 4581, 4569, 4568, 4569, 4581, 4582, 4582, 4570, 4569, 4570, 4582, 4583, 4583, 4571, 4570, 4571, 4583, 4584, 4584, 4572, 4571, 4572, 4584, 4585, 4585, 4573, 4572, 4009, 4021, 4586, 4586, 4574, 4009, 4574, 4586, 4587, 4587, 4575, 4574, 4575, 4587, 4588, 4588, 4576, 4575, 4576, 4588, 4589, 4589, 4577, 4576, 4577, 4589, 4590, 4590, 4578, 4577, 4578, 4590, 4591, 4591, 4579, 4578, 4579, 4591, 4592, 4592, 4580, 4579, 4580, 4592, 4593, 4593, 4581, 4580, 4581, 4593, 4594, 4594, 4582, 4581, 4582, 4594, 4595, 4595, 4583, 4582, 4583, 4595, 4596, 4596, 4584, 4583, 4584, 4596, 4597, 4597, 4585, 4584, 4021, 4033, 4598, 4598, 4586, 4021, 4586, 4598, 4599, 4599, 4587, 4586, 4587, 4599, 4600, 4600, 4588, 4587, 4588, 4600, 4601, 4601, 4589, 4588, 4589, 4601, 4602, 4602, 4590, 4589, 4590, 4602, 4603, 4603, 4591, 4590, 4591, 4603, 4604, 4604, 4592, 4591, 4592, 4604, 4605, 4605, 4593, 4592, 4593, 4605, 4606, 4606, 4594, 4593, 4594, 4606, 4607, 4607, 4595, 4594, 4595, 4607, 4608, 4608, 4596, 4595, 4596, 4608, 4609, 4609, 4597, 4596, 4033, 4045, 4610, 4610, 4598, 4033, 4598, 4610, 4611, 4611, 4599, 4598, 4599, 4611, 4612, 4612, 4600, 4599, 4600, 4612, 4613, 4613, 4601, 4600, 4601, 4613, 4614, 4614, 4602, 4601, 4602, 4614, 4615, 4615, 4603, 4602, 4603, 4615, 4616, 4616, 4604, 4603, 4604, 4616, 4617, 4617, 4605, 4604, 4605, 4617, 4618, 4618, 4606, 4605, 4606, 4618, 4619, 4619, 4607, 4606, 4607, 4619, 4620, 4620, 4608, 4607, 4608, 4620, 4621, 4621, 4609, 4608, 4045, 4057, 4622, 4622, 4610, 4045, 4610, 4622, 4623, 4623, 4611, 4610, 4611, 4623, 4624, 4624, 4612, 4611, 4612, 4624, 4625, 4625, 4613, 4612, 4613, 4625, 4626, 4626, 4614, 4613, 4614, 4626, 4627, 4627, 4615, 4614, 4615, 4627, 4628, 4628, 4616, 4615, 4616, 4628, 4629, 4629, 4617, 4616, 4617, 4629, 4630, 4630, 4618, 4617, 4618, 4630, 4631, 4631, 4619, 4618, 4619, 4631, 4632, 4632, 4620, 4619, 4620, 4632, 4633, 4633, 4621, 4620, 4057, 4069, 4634, 4634, 4622, 4057, 4622, 4634, 4635, 4635, 4623, 4622, 4623, 4635, 4636, 4636, 4624, 4623, 4624, 4636, 4637, 4637, 4625, 4624, 4625, 4637, 4638, 4638, 4626, 4625, 4626, 4638, 4639, 4639, 4627, 4626, 4627, 4639, 4640, 4640, 4628, 4627, 4628, 4640, 4641, 4641, 4629, 4628, 4629, 4641, 4642, 4642, 4630, 4629, 4630, 4642, 4643, 4643, 4631, 4630, 4631, 4643, 4644, 4644, 4632, 4631, 4632, 4644, 4645, 4645, 4633, 4632, 4069, 4081, 4646, 4646, 4634, 4069, 4634, 4646, 4647, 4647, 4635, 4634, 4635, 4647, 4648, 4648, 4636, 4635, 4636, 4648, 4649, 4649, 4637, 4636, 4637, 4649, 4650, 4650, 4638, 4637, 4638, 4650, 4651, 4651, 4639, 4638, 4639, 4651, 4652, 4652, 4640, 4639, 4640, 4652, 4653, 4653, 4641, 4640, 4641, 4653, 4654, 4654, 4642, 4641, 4642, 4654, 4655, 4655, 4643, 4642, 4643, 4655, 4656, 4656, 4644, 4643, 4644, 4656, 4657, 4657, 4645, 4644, 4081, 3517, 4082, 4082, 4646, 4081, 4646, 4082, 4083, 4083, 4647, 4646, 4647, 4083, 4084, 4084, 4648, 4647, 4648, 4084, 4085, 4085, 4649, 4648, 4649, 4085, 4086, 4086, 4650, 4649, 4650, 4086, 4087, 4087, 4651, 4650, 4651, 4087, 4088, 4088, 4652, 4651, 4652, 4088, 4089, 4089, 4653, 4652, 4653, 4089, 4090, 4090, 4654, 4653, 4654, 4090, 4091, 4091, 4655, 4654, 4655, 4091, 4092, 4092, 4656, 4655, 4656, 4092, 4093, 4093, 4657, 4656];

var texCoords = [2, 2, 1.9166666269302368, 2, 1.9166666269302368, 1.9916666746139526, 1.9166666269302368, 1.9916666746139526, 2, 1.9916666746139526, 2, 2, 2, 1.9916666746139526, 1.9166666269302368, 1.9916666746139526, 1.9166666269302368, 1.9833333492279052, 1.9166666269302368, 1.9833333492279052, 2, 1.9833333492279052, 2, 1.9916666746139526, 2, 1.9833333492279052, 1.9166666269302368, 1.9833333492279052, 1.9166666269302368, 1.975000023841858, 1.9166666269302368, 1.975000023841858, 2, 1.975000023841858, 2, 1.9833333492279052, 2, 1.975000023841858, 1.9166666269302368, 1.975000023841858, 1.9166666269302368, 1.9666666984558105, 1.9166666269302368, 1.9666666984558105, 2, 1.9666666984558105, 2, 1.975000023841858, 2, 1.9666666984558105, 1.9166666269302368, 1.9666666984558105, 1.9166666269302368, 1.9583333730697631, 1.9166666269302368, 1.9583333730697631, 2, 1.9583333730697631, 2, 1.9666666984558105, 2, 1.9583333730697631, 1.9166666269302368, 1.9583333730697631, 1.9166666269302368, 1.9500000476837158, 1.9166666269302368, 1.9500000476837158, 2, 1.9500000476837158, 2, 1.9583333730697631, 2, 1.9500000476837158, 1.9166666269302368, 1.9500000476837158, 1.9166666269302368, 1.9416667222976684, 1.9166666269302368, 1.9416667222976684, 2, 1.9416667222976684, 2, 1.9500000476837158, 2, 1.9416667222976684, 1.9166666269302368, 1.9416667222976684, 1.9166666269302368, 1.933333396911621, 1.9166666269302368, 1.933333396911621, 2, 1.933333396911621, 2, 1.9416667222976684, 2, 1.933333396911621, 1.9166666269302368, 1.933333396911621, 1.9166666269302368, 1.9250000715255737, 1.9166666269302368, 1.9250000715255737, 2, 1.9250000715255737, 2, 1.933333396911621, 2, 1.9250000715255737, 1.9166666269302368, 1.9250000715255737, 1.9166666269302368, 1.9166667461395263, 1.9166666269302368, 1.9166667461395263, 2, 1.9166667461395263, 2, 1.9250000715255737, 2, 1.9166667461395263, 1.9166666269302368, 1.9166667461395263, 1.9166666269302368, 1.908333420753479, 1.9166666269302368, 1.908333420753479, 2, 1.908333420753479, 2, 1.9166667461395263, 2, 1.908333420753479, 1.9166666269302368, 1.908333420753479, 1.9166666269302368, 1.9000000953674316, 1.9166666269302368, 1.9000000953674316, 2, 1.9000000953674316, 2, 1.908333420753479, 1.9166666269302368, 2, 1.8333332538604736, 2, 1.8333332538604736, 1.9916666746139526, 1.8333332538604736, 1.9916666746139526, 1.9166666269302368, 1.9916666746139526, 1.9166666269302368, 2, 1.9166666269302368, 1.9916666746139526, 1.8333332538604736, 1.9916666746139526, 1.8333332538604736, 1.9833333492279052, 1.8333332538604736, 1.9833333492279052, 1.9166666269302368, 1.9833333492279052, 1.9166666269302368, 1.9916666746139526, 1.9166666269302368, 1.9833333492279052, 1.8333332538604736, 1.9833333492279052, 1.8333332538604736, 1.975000023841858, 1.8333332538604736, 1.975000023841858, 1.9166666269302368, 1.975000023841858, 1.9166666269302368, 1.9833333492279052, 1.9166666269302368, 1.975000023841858, 1.8333332538604736, 1.975000023841858, 1.8333332538604736, 1.9666666984558105, 1.8333332538604736, 1.9666666984558105, 1.9166666269302368, 1.9666666984558105, 1.9166666269302368, 1.975000023841858, 1.9166666269302368, 1.9666666984558105, 1.8333332538604736, 1.9666666984558105, 1.8333332538604736, 1.9583333730697631, 1.8333332538604736, 1.9583333730697631, 1.9166666269302368, 1.9583333730697631, 1.9166666269302368, 1.9666666984558105, 1.9166666269302368, 1.9583333730697631, 1.8333332538604736, 1.9583333730697631, 1.8333332538604736, 1.9500000476837158, 1.8333332538604736, 1.9500000476837158, 1.9166666269302368, 1.9500000476837158, 1.9166666269302368, 1.9583333730697631, 1.9166666269302368, 1.9500000476837158, 1.8333332538604736, 1.9500000476837158, 1.8333332538604736, 1.9416667222976684, 1.8333332538604736, 1.9416667222976684, 1.9166666269302368, 1.9416667222976684, 1.9166666269302368, 1.9500000476837158, 1.9166666269302368, 1.9416667222976684, 1.8333332538604736, 1.9416667222976684, 1.8333332538604736, 1.933333396911621, 1.8333332538604736, 1.933333396911621, 1.9166666269302368, 1.933333396911621, 1.9166666269302368, 1.9416667222976684, 1.9166666269302368, 1.933333396911621, 1.8333332538604736, 1.933333396911621, 1.8333332538604736, 1.9250000715255737, 1.8333332538604736, 1.9250000715255737, 1.9166666269302368, 1.9250000715255737, 1.9166666269302368, 1.933333396911621, 1.9166666269302368, 1.9250000715255737, 1.8333332538604736, 1.9250000715255737, 1.8333332538604736, 1.9166667461395263, 1.8333332538604736, 1.9166667461395263, 1.9166666269302368, 1.9166667461395263, 1.9166666269302368, 1.9250000715255737, 1.9166666269302368, 1.9166667461395263, 1.8333332538604736, 1.9166667461395263, 1.8333332538604736, 1.908333420753479, 1.8333332538604736, 1.908333420753479, 1.9166666269302368, 1.908333420753479, 1.9166666269302368, 1.9166667461395263, 1.9166666269302368, 1.908333420753479, 1.8333332538604736, 1.908333420753479, 1.8333332538604736, 1.9000000953674316, 1.8333332538604736, 1.9000000953674316, 1.9166666269302368, 1.9000000953674316, 1.9166666269302368, 1.908333420753479, 1.8333332538604736, 2, 1.7499998807907104, 2, 1.7499998807907104, 1.9916666746139526, 1.7499998807907104, 1.9916666746139526, 1.8333332538604736, 1.9916666746139526, 1.8333332538604736, 2, 1.8333332538604736, 1.9916666746139526, 1.7499998807907104, 1.9916666746139526, 1.7499998807907104, 1.9833333492279052, 1.7499998807907104, 1.9833333492279052, 1.8333332538604736, 1.9833333492279052, 1.8333332538604736, 1.9916666746139526, 1.8333332538604736, 1.9833333492279052, 1.7499998807907104, 1.9833333492279052, 1.7499998807907104, 1.975000023841858, 1.7499998807907104, 1.975000023841858, 1.8333332538604736, 1.975000023841858, 1.8333332538604736, 1.9833333492279052, 1.8333332538604736, 1.975000023841858, 1.7499998807907104, 1.975000023841858, 1.7499998807907104, 1.9666666984558105, 1.7499998807907104, 1.9666666984558105, 1.8333332538604736, 1.9666666984558105, 1.8333332538604736, 1.975000023841858, 1.8333332538604736, 1.9666666984558105, 1.7499998807907104, 1.9666666984558105, 1.7499998807907104, 1.9583333730697631, 1.7499998807907104, 1.9583333730697631, 1.8333332538604736, 1.9583333730697631, 1.8333332538604736, 1.9666666984558105, 1.8333332538604736, 1.9583333730697631, 1.7499998807907104, 1.9583333730697631, 1.7499998807907104, 1.9500000476837158, 1.7499998807907104, 1.9500000476837158, 1.8333332538604736, 1.9500000476837158, 1.8333332538604736, 1.9583333730697631, 1.8333332538604736, 1.9500000476837158, 1.7499998807907104, 1.9500000476837158, 1.7499998807907104, 1.9416667222976684, 1.7499998807907104, 1.9416667222976684, 1.8333332538604736, 1.9416667222976684, 1.8333332538604736, 1.9500000476837158, 1.8333332538604736, 1.9416667222976684, 1.7499998807907104, 1.9416667222976684, 1.7499998807907104, 1.933333396911621, 1.7499998807907104, 1.933333396911621, 1.8333332538604736, 1.933333396911621, 1.8333332538604736, 1.9416667222976684, 1.8333332538604736, 1.933333396911621, 1.7499998807907104, 1.933333396911621, 1.7499998807907104, 1.9250000715255737, 1.7499998807907104, 1.9250000715255737, 1.8333332538604736, 1.9250000715255737, 1.8333332538604736, 1.933333396911621, 1.8333332538604736, 1.9250000715255737, 1.7499998807907104, 1.9250000715255737, 1.7499998807907104, 1.9166667461395263, 1.7499998807907104, 1.9166667461395263, 1.8333332538604736, 1.9166667461395263, 1.8333332538604736, 1.9250000715255737, 1.8333332538604736, 1.9166667461395263, 1.7499998807907104, 1.9166667461395263, 1.7499998807907104, 1.908333420753479, 1.7499998807907104, 1.908333420753479, 1.8333332538604736, 1.908333420753479, 1.8333332538604736, 1.9166667461395263, 1.8333332538604736, 1.908333420753479, 1.7499998807907104, 1.908333420753479, 1.7499998807907104, 1.9000000953674316, 1.7499998807907104, 1.9000000953674316, 1.8333332538604736, 1.9000000953674316, 1.8333332538604736, 1.908333420753479, 1.7499998807907104, 2, 1.6666665077209472, 2, 1.6666665077209472, 1.9916666746139526, 1.6666665077209472, 1.9916666746139526, 1.7499998807907104, 1.9916666746139526, 1.7499998807907104, 2, 1.7499998807907104, 1.9916666746139526, 1.6666665077209472, 1.9916666746139526, 1.6666665077209472, 1.9833333492279052, 1.6666665077209472, 1.9833333492279052, 1.7499998807907104, 1.9833333492279052, 1.7499998807907104, 1.9916666746139526, 1.7499998807907104, 1.9833333492279052, 1.6666665077209472, 1.9833333492279052, 1.6666665077209472, 1.975000023841858, 1.6666665077209472, 1.975000023841858, 1.7499998807907104, 1.975000023841858, 1.7499998807907104, 1.9833333492279052, 1.7499998807907104, 1.975000023841858, 1.6666665077209472, 1.975000023841858, 1.6666665077209472, 1.9666666984558105, 1.6666665077209472, 1.9666666984558105, 1.7499998807907104, 1.9666666984558105, 1.7499998807907104, 1.975000023841858, 1.7499998807907104, 1.9666666984558105, 1.6666665077209472, 1.9666666984558105, 1.6666665077209472, 1.9583333730697631, 1.6666665077209472, 1.9583333730697631, 1.7499998807907104, 1.9583333730697631, 1.7499998807907104, 1.9666666984558105, 1.7499998807907104, 1.9583333730697631, 1.6666665077209472, 1.9583333730697631, 1.6666665077209472, 1.9500000476837158, 1.6666665077209472, 1.9500000476837158, 1.7499998807907104, 1.9500000476837158, 1.7499998807907104, 1.9583333730697631, 1.7499998807907104, 1.9500000476837158, 1.6666665077209472, 1.9500000476837158, 1.6666665077209472, 1.9416667222976684, 1.6666665077209472, 1.9416667222976684, 1.7499998807907104, 1.9416667222976684, 1.7499998807907104, 1.9500000476837158, 1.7499998807907104, 1.9416667222976684, 1.6666665077209472, 1.9416667222976684, 1.6666665077209472, 1.933333396911621, 1.6666665077209472, 1.933333396911621, 1.7499998807907104, 1.933333396911621, 1.7499998807907104, 1.9416667222976684, 1.7499998807907104, 1.933333396911621, 1.6666665077209472, 1.933333396911621, 1.6666665077209472, 1.9250000715255737, 1.6666665077209472, 1.9250000715255737, 1.7499998807907104, 1.9250000715255737, 1.7499998807907104, 1.933333396911621, 1.7499998807907104, 1.9250000715255737, 1.6666665077209472, 1.9250000715255737, 1.6666665077209472, 1.9166667461395263, 1.6666665077209472, 1.9166667461395263, 1.7499998807907104, 1.9166667461395263, 1.7499998807907104, 1.9250000715255737, 1.7499998807907104, 1.9166667461395263, 1.6666665077209472, 1.9166667461395263, 1.6666665077209472, 1.908333420753479, 1.6666665077209472, 1.908333420753479, 1.7499998807907104, 1.908333420753479, 1.7499998807907104, 1.9166667461395263, 1.7499998807907104, 1.908333420753479, 1.6666665077209472, 1.908333420753479, 1.6666665077209472, 1.9000000953674316, 1.6666665077209472, 1.9000000953674316, 1.7499998807907104, 1.9000000953674316, 1.7499998807907104, 1.908333420753479, 1.6666665077209472, 2, 1.583333134651184, 2, 1.583333134651184, 1.9916666746139526, 1.583333134651184, 1.9916666746139526, 1.6666665077209472, 1.9916666746139526, 1.6666665077209472, 2, 1.6666665077209472, 1.9916666746139526, 1.583333134651184, 1.9916666746139526, 1.583333134651184, 1.9833333492279052, 1.583333134651184, 1.9833333492279052, 1.6666665077209472, 1.9833333492279052, 1.6666665077209472, 1.9916666746139526, 1.6666665077209472, 1.9833333492279052, 1.583333134651184, 1.9833333492279052, 1.583333134651184, 1.975000023841858, 1.583333134651184, 1.975000023841858, 1.6666665077209472, 1.975000023841858, 1.6666665077209472, 1.9833333492279052, 1.6666665077209472, 1.975000023841858, 1.583333134651184, 1.975000023841858, 1.583333134651184, 1.9666666984558105, 1.583333134651184, 1.9666666984558105, 1.6666665077209472, 1.9666666984558105, 1.6666665077209472, 1.975000023841858, 1.6666665077209472, 1.9666666984558105, 1.583333134651184, 1.9666666984558105, 1.583333134651184, 1.9583333730697631, 1.583333134651184, 1.9583333730697631, 1.6666665077209472, 1.9583333730697631, 1.6666665077209472, 1.9666666984558105, 1.6666665077209472, 1.9583333730697631, 1.583333134651184, 1.9583333730697631, 1.583333134651184, 1.9500000476837158, 1.583333134651184, 1.9500000476837158, 1.6666665077209472, 1.9500000476837158, 1.6666665077209472, 1.9583333730697631, 1.6666665077209472, 1.9500000476837158, 1.583333134651184, 1.9500000476837158, 1.583333134651184, 1.9416667222976684, 1.583333134651184, 1.9416667222976684, 1.6666665077209472, 1.9416667222976684, 1.6666665077209472, 1.9500000476837158, 1.6666665077209472, 1.9416667222976684, 1.583333134651184, 1.9416667222976684, 1.583333134651184, 1.933333396911621, 1.583333134651184, 1.933333396911621, 1.6666665077209472, 1.933333396911621, 1.6666665077209472, 1.9416667222976684, 1.6666665077209472, 1.933333396911621, 1.583333134651184, 1.933333396911621, 1.583333134651184, 1.9250000715255737, 1.583333134651184, 1.9250000715255737, 1.6666665077209472, 1.9250000715255737, 1.6666665077209472, 1.933333396911621, 1.6666665077209472, 1.9250000715255737, 1.583333134651184, 1.9250000715255737, 1.583333134651184, 1.9166667461395263, 1.583333134651184, 1.9166667461395263, 1.6666665077209472, 1.9166667461395263, 1.6666665077209472, 1.9250000715255737, 1.6666665077209472, 1.9166667461395263, 1.583333134651184, 1.9166667461395263, 1.583333134651184, 1.908333420753479, 1.583333134651184, 1.908333420753479, 1.6666665077209472, 1.908333420753479, 1.6666665077209472, 1.9166667461395263, 1.6666665077209472, 1.908333420753479, 1.583333134651184, 1.908333420753479, 1.583333134651184, 1.9000000953674316, 1.583333134651184, 1.9000000953674316, 1.6666665077209472, 1.9000000953674316, 1.6666665077209472, 1.908333420753479, 1.583333134651184, 2, 1.499999761581421, 2, 1.499999761581421, 1.9916666746139526, 1.499999761581421, 1.9916666746139526, 1.583333134651184, 1.9916666746139526, 1.583333134651184, 2, 1.583333134651184, 1.9916666746139526, 1.499999761581421, 1.9916666746139526, 1.499999761581421, 1.9833333492279052, 1.499999761581421, 1.9833333492279052, 1.583333134651184, 1.9833333492279052, 1.583333134651184, 1.9916666746139526, 1.583333134651184, 1.9833333492279052, 1.499999761581421, 1.9833333492279052, 1.499999761581421, 1.975000023841858, 1.499999761581421, 1.975000023841858, 1.583333134651184, 1.975000023841858, 1.583333134651184, 1.9833333492279052, 1.583333134651184, 1.975000023841858, 1.499999761581421, 1.975000023841858, 1.499999761581421, 1.9666666984558105, 1.499999761581421, 1.9666666984558105, 1.583333134651184, 1.9666666984558105, 1.583333134651184, 1.975000023841858, 1.583333134651184, 1.9666666984558105, 1.499999761581421, 1.9666666984558105, 1.499999761581421, 1.9583333730697631, 1.499999761581421, 1.9583333730697631, 1.583333134651184, 1.9583333730697631, 1.583333134651184, 1.9666666984558105, 1.583333134651184, 1.9583333730697631, 1.499999761581421, 1.9583333730697631, 1.499999761581421, 1.9500000476837158, 1.499999761581421, 1.9500000476837158, 1.583333134651184, 1.9500000476837158, 1.583333134651184, 1.9583333730697631, 1.583333134651184, 1.9500000476837158, 1.499999761581421, 1.9500000476837158, 1.499999761581421, 1.9416667222976684, 1.499999761581421, 1.9416667222976684, 1.583333134651184, 1.9416667222976684, 1.583333134651184, 1.9500000476837158, 1.583333134651184, 1.9416667222976684, 1.499999761581421, 1.9416667222976684, 1.499999761581421, 1.933333396911621, 1.499999761581421, 1.933333396911621, 1.583333134651184, 1.933333396911621, 1.583333134651184, 1.9416667222976684, 1.583333134651184, 1.933333396911621, 1.499999761581421, 1.933333396911621, 1.499999761581421, 1.9250000715255737, 1.499999761581421, 1.9250000715255737, 1.583333134651184, 1.9250000715255737, 1.583333134651184, 1.933333396911621, 1.583333134651184, 1.9250000715255737, 1.499999761581421, 1.9250000715255737, 1.499999761581421, 1.9166667461395263, 1.499999761581421, 1.9166667461395263, 1.583333134651184, 1.9166667461395263, 1.583333134651184, 1.9250000715255737, 1.583333134651184, 1.9166667461395263, 1.499999761581421, 1.9166667461395263, 1.499999761581421, 1.908333420753479, 1.499999761581421, 1.908333420753479, 1.583333134651184, 1.908333420753479, 1.583333134651184, 1.9166667461395263, 1.583333134651184, 1.908333420753479, 1.499999761581421, 1.908333420753479, 1.499999761581421, 1.9000000953674316, 1.499999761581421, 1.9000000953674316, 1.583333134651184, 1.9000000953674316, 1.583333134651184, 1.908333420753479, 1.499999761581421, 2, 1.4166663885116577, 2, 1.4166663885116577, 1.9916666746139526, 1.4166663885116577, 1.9916666746139526, 1.499999761581421, 1.9916666746139526, 1.499999761581421, 2, 1.499999761581421, 1.9916666746139526, 1.4166663885116577, 1.9916666746139526, 1.4166663885116577, 1.9833333492279052, 1.4166663885116577, 1.9833333492279052, 1.499999761581421, 1.9833333492279052, 1.499999761581421, 1.9916666746139526, 1.499999761581421, 1.9833333492279052, 1.4166663885116577, 1.9833333492279052, 1.4166663885116577, 1.975000023841858, 1.4166663885116577, 1.975000023841858, 1.499999761581421, 1.975000023841858, 1.499999761581421, 1.9833333492279052, 1.499999761581421, 1.975000023841858, 1.4166663885116577, 1.975000023841858, 1.4166663885116577, 1.9666666984558105, 1.4166663885116577, 1.9666666984558105, 1.499999761581421, 1.9666666984558105, 1.499999761581421, 1.975000023841858, 1.499999761581421, 1.9666666984558105, 1.4166663885116577, 1.9666666984558105, 1.4166663885116577, 1.9583333730697631, 1.4166663885116577, 1.9583333730697631, 1.499999761581421, 1.9583333730697631, 1.499999761581421, 1.9666666984558105, 1.499999761581421, 1.9583333730697631, 1.4166663885116577, 1.9583333730697631, 1.4166663885116577, 1.9500000476837158, 1.4166663885116577, 1.9500000476837158, 1.499999761581421, 1.9500000476837158, 1.499999761581421, 1.9583333730697631, 1.499999761581421, 1.9500000476837158, 1.4166663885116577, 1.9500000476837158, 1.4166663885116577, 1.9416667222976684, 1.4166663885116577, 1.9416667222976684, 1.499999761581421, 1.9416667222976684, 1.499999761581421, 1.9500000476837158, 1.499999761581421, 1.9416667222976684, 1.4166663885116577, 1.9416667222976684, 1.4166663885116577, 1.933333396911621, 1.4166663885116577, 1.933333396911621, 1.499999761581421, 1.933333396911621, 1.499999761581421, 1.9416667222976684, 1.499999761581421, 1.933333396911621, 1.4166663885116577, 1.933333396911621, 1.4166663885116577, 1.9250000715255737, 1.4166663885116577, 1.9250000715255737, 1.499999761581421, 1.9250000715255737, 1.499999761581421, 1.933333396911621, 1.499999761581421, 1.9250000715255737, 1.4166663885116577, 1.9250000715255737, 1.4166663885116577, 1.9166667461395263, 1.4166663885116577, 1.9166667461395263, 1.499999761581421, 1.9166667461395263, 1.499999761581421, 1.9250000715255737, 1.499999761581421, 1.9166667461395263, 1.4166663885116577, 1.9166667461395263, 1.4166663885116577, 1.908333420753479, 1.4166663885116577, 1.908333420753479, 1.499999761581421, 1.908333420753479, 1.499999761581421, 1.9166667461395263, 1.499999761581421, 1.908333420753479, 1.4166663885116577, 1.908333420753479, 1.4166663885116577, 1.9000000953674316, 1.4166663885116577, 1.9000000953674316, 1.499999761581421, 1.9000000953674316, 1.499999761581421, 1.908333420753479, 1.4166663885116577, 2, 1.3333330154418945, 2, 1.3333330154418945, 1.9916666746139526, 1.3333330154418945, 1.9916666746139526, 1.4166663885116577, 1.9916666746139526, 1.4166663885116577, 2, 1.4166663885116577, 1.9916666746139526, 1.3333330154418945, 1.9916666746139526, 1.3333330154418945, 1.9833333492279052, 1.3333330154418945, 1.9833333492279052, 1.4166663885116577, 1.9833333492279052, 1.4166663885116577, 1.9916666746139526, 1.4166663885116577, 1.9833333492279052, 1.3333330154418945, 1.9833333492279052, 1.3333330154418945, 1.975000023841858, 1.3333330154418945, 1.975000023841858, 1.4166663885116577, 1.975000023841858, 1.4166663885116577, 1.9833333492279052, 1.4166663885116577, 1.975000023841858, 1.3333330154418945, 1.975000023841858, 1.3333330154418945, 1.9666666984558105, 1.3333330154418945, 1.9666666984558105, 1.4166663885116577, 1.9666666984558105, 1.4166663885116577, 1.975000023841858, 1.4166663885116577, 1.9666666984558105, 1.3333330154418945, 1.9666666984558105, 1.3333330154418945, 1.9583333730697631, 1.3333330154418945, 1.9583333730697631, 1.4166663885116577, 1.9583333730697631, 1.4166663885116577, 1.9666666984558105, 1.4166663885116577, 1.9583333730697631, 1.3333330154418945, 1.9583333730697631, 1.3333330154418945, 1.9500000476837158, 1.3333330154418945, 1.9500000476837158, 1.4166663885116577, 1.9500000476837158, 1.4166663885116577, 1.9583333730697631, 1.4166663885116577, 1.9500000476837158, 1.3333330154418945, 1.9500000476837158, 1.3333330154418945, 1.9416667222976684, 1.3333330154418945, 1.9416667222976684, 1.4166663885116577, 1.9416667222976684, 1.4166663885116577, 1.9500000476837158, 1.4166663885116577, 1.9416667222976684, 1.3333330154418945, 1.9416667222976684, 1.3333330154418945, 1.933333396911621, 1.3333330154418945, 1.933333396911621, 1.4166663885116577, 1.933333396911621, 1.4166663885116577, 1.9416667222976684, 1.4166663885116577, 1.933333396911621, 1.3333330154418945, 1.933333396911621, 1.3333330154418945, 1.9250000715255737, 1.3333330154418945, 1.9250000715255737, 1.4166663885116577, 1.9250000715255737, 1.4166663885116577, 1.933333396911621, 1.4166663885116577, 1.9250000715255737, 1.3333330154418945, 1.9250000715255737, 1.3333330154418945, 1.9166667461395263, 1.3333330154418945, 1.9166667461395263, 1.4166663885116577, 1.9166667461395263, 1.4166663885116577, 1.9250000715255737, 1.4166663885116577, 1.9166667461395263, 1.3333330154418945, 1.9166667461395263, 1.3333330154418945, 1.908333420753479, 1.3333330154418945, 1.908333420753479, 1.4166663885116577, 1.908333420753479, 1.4166663885116577, 1.9166667461395263, 1.4166663885116577, 1.908333420753479, 1.3333330154418945, 1.908333420753479, 1.3333330154418945, 1.9000000953674316, 1.3333330154418945, 1.9000000953674316, 1.4166663885116577, 1.9000000953674316, 1.4166663885116577, 1.908333420753479, 1.3333330154418945, 2, 1.2499996423721313, 2, 1.2499996423721313, 1.9916666746139526, 1.2499996423721313, 1.9916666746139526, 1.3333330154418945, 1.9916666746139526, 1.3333330154418945, 2, 1.3333330154418945, 1.9916666746139526, 1.2499996423721313, 1.9916666746139526, 1.2499996423721313, 1.9833333492279052, 1.2499996423721313, 1.9833333492279052, 1.3333330154418945, 1.9833333492279052, 1.3333330154418945, 1.9916666746139526, 1.3333330154418945, 1.9833333492279052, 1.2499996423721313, 1.9833333492279052, 1.2499996423721313, 1.975000023841858, 1.2499996423721313, 1.975000023841858, 1.3333330154418945, 1.975000023841858, 1.3333330154418945, 1.9833333492279052, 1.3333330154418945, 1.975000023841858, 1.2499996423721313, 1.975000023841858, 1.2499996423721313, 1.9666666984558105, 1.2499996423721313, 1.9666666984558105, 1.3333330154418945, 1.9666666984558105, 1.3333330154418945, 1.975000023841858, 1.3333330154418945, 1.9666666984558105, 1.2499996423721313, 1.9666666984558105, 1.2499996423721313, 1.9583333730697631, 1.2499996423721313, 1.9583333730697631, 1.3333330154418945, 1.9583333730697631, 1.3333330154418945, 1.9666666984558105, 1.3333330154418945, 1.9583333730697631, 1.2499996423721313, 1.9583333730697631, 1.2499996423721313, 1.9500000476837158, 1.2499996423721313, 1.9500000476837158, 1.3333330154418945, 1.9500000476837158, 1.3333330154418945, 1.9583333730697631, 1.3333330154418945, 1.9500000476837158, 1.2499996423721313, 1.9500000476837158, 1.2499996423721313, 1.9416667222976684, 1.2499996423721313, 1.9416667222976684, 1.3333330154418945, 1.9416667222976684, 1.3333330154418945, 1.9500000476837158, 1.3333330154418945, 1.9416667222976684, 1.2499996423721313, 1.9416667222976684, 1.2499996423721313, 1.933333396911621, 1.2499996423721313, 1.933333396911621, 1.3333330154418945, 1.933333396911621, 1.3333330154418945, 1.9416667222976684, 1.3333330154418945, 1.933333396911621, 1.2499996423721313, 1.933333396911621, 1.2499996423721313, 1.9250000715255737, 1.2499996423721313, 1.9250000715255737, 1.3333330154418945, 1.9250000715255737, 1.3333330154418945, 1.933333396911621, 1.3333330154418945, 1.9250000715255737, 1.2499996423721313, 1.9250000715255737, 1.2499996423721313, 1.9166667461395263, 1.2499996423721313, 1.9166667461395263, 1.3333330154418945, 1.9166667461395263, 1.3333330154418945, 1.9250000715255737, 1.3333330154418945, 1.9166667461395263, 1.2499996423721313, 1.9166667461395263, 1.2499996423721313, 1.908333420753479, 1.2499996423721313, 1.908333420753479, 1.3333330154418945, 1.908333420753479, 1.3333330154418945, 1.9166667461395263, 1.3333330154418945, 1.908333420753479, 1.2499996423721313, 1.908333420753479, 1.2499996423721313, 1.9000000953674316, 1.2499996423721313, 1.9000000953674316, 1.3333330154418945, 1.9000000953674316, 1.3333330154418945, 1.908333420753479, 1.2499996423721313, 2, 1.1666662693023681, 2, 1.1666662693023681, 1.9916666746139526, 1.1666662693023681, 1.9916666746139526, 1.2499996423721313, 1.9916666746139526, 1.2499996423721313, 2, 1.2499996423721313, 1.9916666746139526, 1.1666662693023681, 1.9916666746139526, 1.1666662693023681, 1.9833333492279052, 1.1666662693023681, 1.9833333492279052, 1.2499996423721313, 1.9833333492279052, 1.2499996423721313, 1.9916666746139526, 1.2499996423721313, 1.9833333492279052, 1.1666662693023681, 1.9833333492279052, 1.1666662693023681, 1.975000023841858, 1.1666662693023681, 1.975000023841858, 1.2499996423721313, 1.975000023841858, 1.2499996423721313, 1.9833333492279052, 1.2499996423721313, 1.975000023841858, 1.1666662693023681, 1.975000023841858, 1.1666662693023681, 1.9666666984558105, 1.1666662693023681, 1.9666666984558105, 1.2499996423721313, 1.9666666984558105, 1.2499996423721313, 1.975000023841858, 1.2499996423721313, 1.9666666984558105, 1.1666662693023681, 1.9666666984558105, 1.1666662693023681, 1.9583333730697631, 1.1666662693023681, 1.9583333730697631, 1.2499996423721313, 1.9583333730697631, 1.2499996423721313, 1.9666666984558105, 1.2499996423721313, 1.9583333730697631, 1.1666662693023681, 1.9583333730697631, 1.1666662693023681, 1.9500000476837158, 1.1666662693023681, 1.9500000476837158, 1.2499996423721313, 1.9500000476837158, 1.2499996423721313, 1.9583333730697631, 1.2499996423721313, 1.9500000476837158, 1.1666662693023681, 1.9500000476837158, 1.1666662693023681, 1.9416667222976684, 1.1666662693023681, 1.9416667222976684, 1.2499996423721313, 1.9416667222976684, 1.2499996423721313, 1.9500000476837158, 1.2499996423721313, 1.9416667222976684, 1.1666662693023681, 1.9416667222976684, 1.1666662693023681, 1.933333396911621, 1.1666662693023681, 1.933333396911621, 1.2499996423721313, 1.933333396911621, 1.2499996423721313, 1.9416667222976684, 1.2499996423721313, 1.933333396911621, 1.1666662693023681, 1.933333396911621, 1.1666662693023681, 1.9250000715255737, 1.1666662693023681, 1.9250000715255737, 1.2499996423721313, 1.9250000715255737, 1.2499996423721313, 1.933333396911621, 1.2499996423721313, 1.9250000715255737, 1.1666662693023681, 1.9250000715255737, 1.1666662693023681, 1.9166667461395263, 1.1666662693023681, 1.9166667461395263, 1.2499996423721313, 1.9166667461395263, 1.2499996423721313, 1.9250000715255737, 1.2499996423721313, 1.9166667461395263, 1.1666662693023681, 1.9166667461395263, 1.1666662693023681, 1.908333420753479, 1.1666662693023681, 1.908333420753479, 1.2499996423721313, 1.908333420753479, 1.2499996423721313, 1.9166667461395263, 1.2499996423721313, 1.908333420753479, 1.1666662693023681, 1.908333420753479, 1.1666662693023681, 1.9000000953674316, 1.1666662693023681, 1.9000000953674316, 1.2499996423721313, 1.9000000953674316, 1.2499996423721313, 1.908333420753479, 1.1666662693023681, 2, 1.083332896232605, 2, 1.083332896232605, 1.9916666746139526, 1.083332896232605, 1.9916666746139526, 1.1666662693023681, 1.9916666746139526, 1.1666662693023681, 2, 1.1666662693023681, 1.9916666746139526, 1.083332896232605, 1.9916666746139526, 1.083332896232605, 1.9833333492279052, 1.083332896232605, 1.9833333492279052, 1.1666662693023681, 1.9833333492279052, 1.1666662693023681, 1.9916666746139526, 1.1666662693023681, 1.9833333492279052, 1.083332896232605, 1.9833333492279052, 1.083332896232605, 1.975000023841858, 1.083332896232605, 1.975000023841858, 1.1666662693023681, 1.975000023841858, 1.1666662693023681, 1.9833333492279052, 1.1666662693023681, 1.975000023841858, 1.083332896232605, 1.975000023841858, 1.083332896232605, 1.9666666984558105, 1.083332896232605, 1.9666666984558105, 1.1666662693023681, 1.9666666984558105, 1.1666662693023681, 1.975000023841858, 1.1666662693023681, 1.9666666984558105, 1.083332896232605, 1.9666666984558105, 1.083332896232605, 1.9583333730697631, 1.083332896232605, 1.9583333730697631, 1.1666662693023681, 1.9583333730697631, 1.1666662693023681, 1.9666666984558105, 1.1666662693023681, 1.9583333730697631, 1.083332896232605, 1.9583333730697631, 1.083332896232605, 1.9500000476837158, 1.083332896232605, 1.9500000476837158, 1.1666662693023681, 1.9500000476837158, 1.1666662693023681, 1.9583333730697631, 1.1666662693023681, 1.9500000476837158, 1.083332896232605, 1.9500000476837158, 1.083332896232605, 1.9416667222976684, 1.083332896232605, 1.9416667222976684, 1.1666662693023681, 1.9416667222976684, 1.1666662693023681, 1.9500000476837158, 1.1666662693023681, 1.9416667222976684, 1.083332896232605, 1.9416667222976684, 1.083332896232605, 1.933333396911621, 1.083332896232605, 1.933333396911621, 1.1666662693023681, 1.933333396911621, 1.1666662693023681, 1.9416667222976684, 1.1666662693023681, 1.933333396911621, 1.083332896232605, 1.933333396911621, 1.083332896232605, 1.9250000715255737, 1.083332896232605, 1.9250000715255737, 1.1666662693023681, 1.9250000715255737, 1.1666662693023681, 1.933333396911621, 1.1666662693023681, 1.9250000715255737, 1.083332896232605, 1.9250000715255737, 1.083332896232605, 1.9166667461395263, 1.083332896232605, 1.9166667461395263, 1.1666662693023681, 1.9166667461395263, 1.1666662693023681, 1.9250000715255737, 1.1666662693023681, 1.9166667461395263, 1.083332896232605, 1.9166667461395263, 1.083332896232605, 1.908333420753479, 1.083332896232605, 1.908333420753479, 1.1666662693023681, 1.908333420753479, 1.1666662693023681, 1.9166667461395263, 1.1666662693023681, 1.908333420753479, 1.083332896232605, 1.908333420753479, 1.083332896232605, 1.9000000953674316, 1.083332896232605, 1.9000000953674316, 1.1666662693023681, 1.9000000953674316, 1.1666662693023681, 1.908333420753479, 1.083332896232605, 2, 0.9999995827674866, 2, 0.9999995827674866, 1.9916666746139526, 0.9999995827674866, 1.9916666746139526, 1.083332896232605, 1.9916666746139526, 1.083332896232605, 2, 1.083332896232605, 1.9916666746139526, 0.9999995827674866, 1.9916666746139526, 0.9999995827674866, 1.9833333492279052, 0.9999995827674866, 1.9833333492279052, 1.083332896232605, 1.9833333492279052, 1.083332896232605, 1.9916666746139526, 1.083332896232605, 1.9833333492279052, 0.9999995827674866, 1.9833333492279052, 0.9999995827674866, 1.975000023841858, 0.9999995827674866, 1.975000023841858, 1.083332896232605, 1.975000023841858, 1.083332896232605, 1.9833333492279052, 1.083332896232605, 1.975000023841858, 0.9999995827674866, 1.975000023841858, 0.9999995827674866, 1.9666666984558105, 0.9999995827674866, 1.9666666984558105, 1.083332896232605, 1.9666666984558105, 1.083332896232605, 1.975000023841858, 1.083332896232605, 1.9666666984558105, 0.9999995827674866, 1.9666666984558105, 0.9999995827674866, 1.9583333730697631, 0.9999995827674866, 1.9583333730697631, 1.083332896232605, 1.9583333730697631, 1.083332896232605, 1.9666666984558105, 1.083332896232605, 1.9583333730697631, 0.9999995827674866, 1.9583333730697631, 0.9999995827674866, 1.9500000476837158, 0.9999995827674866, 1.9500000476837158, 1.083332896232605, 1.9500000476837158, 1.083332896232605, 1.9583333730697631, 1.083332896232605, 1.9500000476837158, 0.9999995827674866, 1.9500000476837158, 0.9999995827674866, 1.9416667222976684, 0.9999995827674866, 1.9416667222976684, 1.083332896232605, 1.9416667222976684, 1.083332896232605, 1.9500000476837158, 1.083332896232605, 1.9416667222976684, 0.9999995827674866, 1.9416667222976684, 0.9999995827674866, 1.933333396911621, 0.9999995827674866, 1.933333396911621, 1.083332896232605, 1.933333396911621, 1.083332896232605, 1.9416667222976684, 1.083332896232605, 1.933333396911621, 0.9999995827674866, 1.933333396911621, 0.9999995827674866, 1.9250000715255737, 0.9999995827674866, 1.9250000715255737, 1.083332896232605, 1.9250000715255737, 1.083332896232605, 1.933333396911621, 1.083332896232605, 1.9250000715255737, 0.9999995827674866, 1.9250000715255737, 0.9999995827674866, 1.9166667461395263, 0.9999995827674866, 1.9166667461395263, 1.083332896232605, 1.9166667461395263, 1.083332896232605, 1.9250000715255737, 1.083332896232605, 1.9166667461395263, 0.9999995827674866, 1.9166667461395263, 0.9999995827674866, 1.908333420753479, 0.9999995827674866, 1.908333420753479, 1.083332896232605, 1.908333420753479, 1.083332896232605, 1.9166667461395263, 1.083332896232605, 1.908333420753479, 0.9999995827674866, 1.908333420753479, 0.9999995827674866, 1.9000000953674316, 0.9999995827674866, 1.9000000953674316, 1.083332896232605, 1.9000000953674316, 1.083332896232605, 1.908333420753479, 1, 2, 0.9166666865348816, 2, 0.9166666865348816, 1.9916666746139526, 0.9166666865348816, 1.9916666746139526, 1, 1.9916666746139526, 1, 2, 1, 1.9916666746139526, 0.9166666865348816, 1.9916666746139526, 0.9166666865348816, 1.9833333492279052, 0.9166666865348816, 1.9833333492279052, 1, 1.9833333492279052, 1, 1.9916666746139526, 1, 1.9833333492279052, 0.9166666865348816, 1.9833333492279052, 0.9166666865348816, 1.975000023841858, 0.9166666865348816, 1.975000023841858, 1, 1.975000023841858, 1, 1.9833333492279052, 1, 1.975000023841858, 0.9166666865348816, 1.975000023841858, 0.9166666865348816, 1.9666666984558105, 0.9166666865348816, 1.9666666984558105, 1, 1.9666666984558105, 1, 1.975000023841858, 1, 1.9666666984558105, 0.9166666865348816, 1.9666666984558105, 0.9166666865348816, 1.9583333730697631, 0.9166666865348816, 1.9583333730697631, 1, 1.9583333730697631, 1, 1.9666666984558105, 1, 1.9583333730697631, 0.9166666865348816, 1.9583333730697631, 0.9166666865348816, 1.9500000476837158, 0.9166666865348816, 1.9500000476837158, 1, 1.9500000476837158, 1, 1.9583333730697631, 1, 1.9500000476837158, 0.9166666865348816, 1.9500000476837158, 0.9166666865348816, 1.9416667222976684, 0.9166666865348816, 1.9416667222976684, 1, 1.9416667222976684, 1, 1.9500000476837158, 1, 1.9416667222976684, 0.9166666865348816, 1.9416667222976684, 0.9166666865348816, 1.933333396911621, 0.9166666865348816, 1.933333396911621, 1, 1.933333396911621, 1, 1.9416667222976684, 1, 1.933333396911621, 0.9166666865348816, 1.933333396911621, 0.9166666865348816, 1.9250000715255737, 0.9166666865348816, 1.9250000715255737, 1, 1.9250000715255737, 1, 1.933333396911621, 1, 1.9250000715255737, 0.9166666865348816, 1.9250000715255737, 0.9166666865348816, 1.9166667461395263, 0.9166666865348816, 1.9166667461395263, 1, 1.9166667461395263, 1, 1.9250000715255737, 1, 1.9166667461395263, 0.9166666865348816, 1.9166667461395263, 0.9166666865348816, 1.908333420753479, 0.9166666865348816, 1.908333420753479, 1, 1.908333420753479, 1, 1.9166667461395263, 1, 1.908333420753479, 0.9166666865348816, 1.908333420753479, 0.9166666865348816, 1.9000000953674316, 0.9166666865348816, 1.9000000953674316, 1, 1.9000000953674316, 1, 1.908333420753479, 0.9166666865348816, 2, 0.8333333730697632, 2, 0.8333333730697632, 1.9916666746139526, 0.8333333730697632, 1.9916666746139526, 0.9166666865348816, 1.9916666746139526, 0.9166666865348816, 2, 0.9166666865348816, 1.9916666746139526, 0.8333333730697632, 1.9916666746139526, 0.8333333730697632, 1.9833333492279052, 0.8333333730697632, 1.9833333492279052, 0.9166666865348816, 1.9833333492279052, 0.9166666865348816, 1.9916666746139526, 0.9166666865348816, 1.9833333492279052, 0.8333333730697632, 1.9833333492279052, 0.8333333730697632, 1.975000023841858, 0.8333333730697632, 1.975000023841858, 0.9166666865348816, 1.975000023841858, 0.9166666865348816, 1.9833333492279052, 0.9166666865348816, 1.975000023841858, 0.8333333730697632, 1.975000023841858, 0.8333333730697632, 1.9666666984558105, 0.8333333730697632, 1.9666666984558105, 0.9166666865348816, 1.9666666984558105, 0.9166666865348816, 1.975000023841858, 0.9166666865348816, 1.9666666984558105, 0.8333333730697632, 1.9666666984558105, 0.8333333730697632, 1.9583333730697631, 0.8333333730697632, 1.9583333730697631, 0.9166666865348816, 1.9583333730697631, 0.9166666865348816, 1.9666666984558105, 0.9166666865348816, 1.9583333730697631, 0.8333333730697632, 1.9583333730697631, 0.8333333730697632, 1.9500000476837158, 0.8333333730697632, 1.9500000476837158, 0.9166666865348816, 1.9500000476837158, 0.9166666865348816, 1.9583333730697631, 0.9166666865348816, 1.9500000476837158, 0.8333333730697632, 1.9500000476837158, 0.8333333730697632, 1.9416667222976684, 0.8333333730697632, 1.9416667222976684, 0.9166666865348816, 1.9416667222976684, 0.9166666865348816, 1.9500000476837158, 0.9166666865348816, 1.9416667222976684, 0.8333333730697632, 1.9416667222976684, 0.8333333730697632, 1.933333396911621, 0.8333333730697632, 1.933333396911621, 0.9166666865348816, 1.933333396911621, 0.9166666865348816, 1.9416667222976684, 0.9166666865348816, 1.933333396911621, 0.8333333730697632, 1.933333396911621, 0.8333333730697632, 1.9250000715255737, 0.8333333730697632, 1.9250000715255737, 0.9166666865348816, 1.9250000715255737, 0.9166666865348816, 1.933333396911621, 0.9166666865348816, 1.9250000715255737, 0.8333333730697632, 1.9250000715255737, 0.8333333730697632, 1.9166667461395263, 0.8333333730697632, 1.9166667461395263, 0.9166666865348816, 1.9166667461395263, 0.9166666865348816, 1.9250000715255737, 0.9166666865348816, 1.9166667461395263, 0.8333333730697632, 1.9166667461395263, 0.8333333730697632, 1.908333420753479, 0.8333333730697632, 1.908333420753479, 0.9166666865348816, 1.908333420753479, 0.9166666865348816, 1.9166667461395263, 0.9166666865348816, 1.908333420753479, 0.8333333730697632, 1.908333420753479, 0.8333333730697632, 1.9000000953674316, 0.8333333730697632, 1.9000000953674316, 0.9166666865348816, 1.9000000953674316, 0.9166666865348816, 1.908333420753479, 0.8333333730697632, 2, 0.7500000596046448, 2, 0.7500000596046448, 1.9916666746139526, 0.7500000596046448, 1.9916666746139526, 0.8333333730697632, 1.9916666746139526, 0.8333333730697632, 2, 0.8333333730697632, 1.9916666746139526, 0.7500000596046448, 1.9916666746139526, 0.7500000596046448, 1.9833333492279052, 0.7500000596046448, 1.9833333492279052, 0.8333333730697632, 1.9833333492279052, 0.8333333730697632, 1.9916666746139526, 0.8333333730697632, 1.9833333492279052, 0.7500000596046448, 1.9833333492279052, 0.7500000596046448, 1.975000023841858, 0.7500000596046448, 1.975000023841858, 0.8333333730697632, 1.975000023841858, 0.8333333730697632, 1.9833333492279052, 0.8333333730697632, 1.975000023841858, 0.7500000596046448, 1.975000023841858, 0.7500000596046448, 1.9666666984558105, 0.7500000596046448, 1.9666666984558105, 0.8333333730697632, 1.9666666984558105, 0.8333333730697632, 1.975000023841858, 0.8333333730697632, 1.9666666984558105, 0.7500000596046448, 1.9666666984558105, 0.7500000596046448, 1.9583333730697631, 0.7500000596046448, 1.9583333730697631, 0.8333333730697632, 1.9583333730697631, 0.8333333730697632, 1.9666666984558105, 0.8333333730697632, 1.9583333730697631, 0.7500000596046448, 1.9583333730697631, 0.7500000596046448, 1.9500000476837158, 0.7500000596046448, 1.9500000476837158, 0.8333333730697632, 1.9500000476837158, 0.8333333730697632, 1.9583333730697631, 0.8333333730697632, 1.9500000476837158, 0.7500000596046448, 1.9500000476837158, 0.7500000596046448, 1.9416667222976684, 0.7500000596046448, 1.9416667222976684, 0.8333333730697632, 1.9416667222976684, 0.8333333730697632, 1.9500000476837158, 0.8333333730697632, 1.9416667222976684, 0.7500000596046448, 1.9416667222976684, 0.7500000596046448, 1.933333396911621, 0.7500000596046448, 1.933333396911621, 0.8333333730697632, 1.933333396911621, 0.8333333730697632, 1.9416667222976684, 0.8333333730697632, 1.933333396911621, 0.7500000596046448, 1.933333396911621, 0.7500000596046448, 1.9250000715255737, 0.7500000596046448, 1.9250000715255737, 0.8333333730697632, 1.9250000715255737, 0.8333333730697632, 1.933333396911621, 0.8333333730697632, 1.9250000715255737, 0.7500000596046448, 1.9250000715255737, 0.7500000596046448, 1.9166667461395263, 0.7500000596046448, 1.9166667461395263, 0.8333333730697632, 1.9166667461395263, 0.8333333730697632, 1.9250000715255737, 0.8333333730697632, 1.9166667461395263, 0.7500000596046448, 1.9166667461395263, 0.7500000596046448, 1.908333420753479, 0.7500000596046448, 1.908333420753479, 0.8333333730697632, 1.908333420753479, 0.8333333730697632, 1.9166667461395263, 0.8333333730697632, 1.908333420753479, 0.7500000596046448, 1.908333420753479, 0.7500000596046448, 1.9000000953674316, 0.7500000596046448, 1.9000000953674316, 0.8333333730697632, 1.9000000953674316, 0.8333333730697632, 1.908333420753479, 0.7500000596046448, 2, 0.6666667461395264, 2, 0.6666667461395264, 1.9916666746139526, 0.6666667461395264, 1.9916666746139526, 0.7500000596046448, 1.9916666746139526, 0.7500000596046448, 2, 0.7500000596046448, 1.9916666746139526, 0.6666667461395264, 1.9916666746139526, 0.6666667461395264, 1.9833333492279052, 0.6666667461395264, 1.9833333492279052, 0.7500000596046448, 1.9833333492279052, 0.7500000596046448, 1.9916666746139526, 0.7500000596046448, 1.9833333492279052, 0.6666667461395264, 1.9833333492279052, 0.6666667461395264, 1.975000023841858, 0.6666667461395264, 1.975000023841858, 0.7500000596046448, 1.975000023841858, 0.7500000596046448, 1.9833333492279052, 0.7500000596046448, 1.975000023841858, 0.6666667461395264, 1.975000023841858, 0.6666667461395264, 1.9666666984558105, 0.6666667461395264, 1.9666666984558105, 0.7500000596046448, 1.9666666984558105, 0.7500000596046448, 1.975000023841858, 0.7500000596046448, 1.9666666984558105, 0.6666667461395264, 1.9666666984558105, 0.6666667461395264, 1.9583333730697631, 0.6666667461395264, 1.9583333730697631, 0.7500000596046448, 1.9583333730697631, 0.7500000596046448, 1.9666666984558105, 0.7500000596046448, 1.9583333730697631, 0.6666667461395264, 1.9583333730697631, 0.6666667461395264, 1.9500000476837158, 0.6666667461395264, 1.9500000476837158, 0.7500000596046448, 1.9500000476837158, 0.7500000596046448, 1.9583333730697631, 0.7500000596046448, 1.9500000476837158, 0.6666667461395264, 1.9500000476837158, 0.6666667461395264, 1.9416667222976684, 0.6666667461395264, 1.9416667222976684, 0.7500000596046448, 1.9416667222976684, 0.7500000596046448, 1.9500000476837158, 0.7500000596046448, 1.9416667222976684, 0.6666667461395264, 1.9416667222976684, 0.6666667461395264, 1.933333396911621, 0.6666667461395264, 1.933333396911621, 0.7500000596046448, 1.933333396911621, 0.7500000596046448, 1.9416667222976684, 0.7500000596046448, 1.933333396911621, 0.6666667461395264, 1.933333396911621, 0.6666667461395264, 1.9250000715255737, 0.6666667461395264, 1.9250000715255737, 0.7500000596046448, 1.9250000715255737, 0.7500000596046448, 1.933333396911621, 0.7500000596046448, 1.9250000715255737, 0.6666667461395264, 1.9250000715255737, 0.6666667461395264, 1.9166667461395263, 0.6666667461395264, 1.9166667461395263, 0.7500000596046448, 1.9166667461395263, 0.7500000596046448, 1.9250000715255737, 0.7500000596046448, 1.9166667461395263, 0.6666667461395264, 1.9166667461395263, 0.6666667461395264, 1.908333420753479, 0.6666667461395264, 1.908333420753479, 0.7500000596046448, 1.908333420753479, 0.7500000596046448, 1.9166667461395263, 0.7500000596046448, 1.908333420753479, 0.6666667461395264, 1.908333420753479, 0.6666667461395264, 1.9000000953674316, 0.6666667461395264, 1.9000000953674316, 0.7500000596046448, 1.9000000953674316, 0.7500000596046448, 1.908333420753479, 0.6666667461395264, 2, 0.583333432674408, 2, 0.583333432674408, 1.9916666746139526, 0.583333432674408, 1.9916666746139526, 0.6666667461395264, 1.9916666746139526, 0.6666667461395264, 2, 0.6666667461395264, 1.9916666746139526, 0.583333432674408, 1.9916666746139526, 0.583333432674408, 1.9833333492279052, 0.583333432674408, 1.9833333492279052, 0.6666667461395264, 1.9833333492279052, 0.6666667461395264, 1.9916666746139526, 0.6666667461395264, 1.9833333492279052, 0.583333432674408, 1.9833333492279052, 0.583333432674408, 1.975000023841858, 0.583333432674408, 1.975000023841858, 0.6666667461395264, 1.975000023841858, 0.6666667461395264, 1.9833333492279052, 0.6666667461395264, 1.975000023841858, 0.583333432674408, 1.975000023841858, 0.583333432674408, 1.9666666984558105, 0.583333432674408, 1.9666666984558105, 0.6666667461395264, 1.9666666984558105, 0.6666667461395264, 1.975000023841858, 0.6666667461395264, 1.9666666984558105, 0.583333432674408, 1.9666666984558105, 0.583333432674408, 1.9583333730697631, 0.583333432674408, 1.9583333730697631, 0.6666667461395264, 1.9583333730697631, 0.6666667461395264, 1.9666666984558105, 0.6666667461395264, 1.9583333730697631, 0.583333432674408, 1.9583333730697631, 0.583333432674408, 1.9500000476837158, 0.583333432674408, 1.9500000476837158, 0.6666667461395264, 1.9500000476837158, 0.6666667461395264, 1.9583333730697631, 0.6666667461395264, 1.9500000476837158, 0.583333432674408, 1.9500000476837158, 0.583333432674408, 1.9416667222976684, 0.583333432674408, 1.9416667222976684, 0.6666667461395264, 1.9416667222976684, 0.6666667461395264, 1.9500000476837158, 0.6666667461395264, 1.9416667222976684, 0.583333432674408, 1.9416667222976684, 0.583333432674408, 1.933333396911621, 0.583333432674408, 1.933333396911621, 0.6666667461395264, 1.933333396911621, 0.6666667461395264, 1.9416667222976684, 0.6666667461395264, 1.933333396911621, 0.583333432674408, 1.933333396911621, 0.583333432674408, 1.9250000715255737, 0.583333432674408, 1.9250000715255737, 0.6666667461395264, 1.9250000715255737, 0.6666667461395264, 1.933333396911621, 0.6666667461395264, 1.9250000715255737, 0.583333432674408, 1.9250000715255737, 0.583333432674408, 1.9166667461395263, 0.583333432674408, 1.9166667461395263, 0.6666667461395264, 1.9166667461395263, 0.6666667461395264, 1.9250000715255737, 0.6666667461395264, 1.9166667461395263, 0.583333432674408, 1.9166667461395263, 0.583333432674408, 1.908333420753479, 0.583333432674408, 1.908333420753479, 0.6666667461395264, 1.908333420753479, 0.6666667461395264, 1.9166667461395263, 0.6666667461395264, 1.908333420753479, 0.583333432674408, 1.908333420753479, 0.583333432674408, 1.9000000953674316, 0.583333432674408, 1.9000000953674316, 0.6666667461395264, 1.9000000953674316, 0.6666667461395264, 1.908333420753479, 0.583333432674408, 2, 0.5000001192092895, 2, 0.5000001192092895, 1.9916666746139526, 0.5000001192092895, 1.9916666746139526, 0.583333432674408, 1.9916666746139526, 0.583333432674408, 2, 0.583333432674408, 1.9916666746139526, 0.5000001192092895, 1.9916666746139526, 0.5000001192092895, 1.9833333492279052, 0.5000001192092895, 1.9833333492279052, 0.583333432674408, 1.9833333492279052, 0.583333432674408, 1.9916666746139526, 0.583333432674408, 1.9833333492279052, 0.5000001192092895, 1.9833333492279052, 0.5000001192092895, 1.975000023841858, 0.5000001192092895, 1.975000023841858, 0.583333432674408, 1.975000023841858, 0.583333432674408, 1.9833333492279052, 0.583333432674408, 1.975000023841858, 0.5000001192092895, 1.975000023841858, 0.5000001192092895, 1.9666666984558105, 0.5000001192092895, 1.9666666984558105, 0.583333432674408, 1.9666666984558105, 0.583333432674408, 1.975000023841858, 0.583333432674408, 1.9666666984558105, 0.5000001192092895, 1.9666666984558105, 0.5000001192092895, 1.9583333730697631, 0.5000001192092895, 1.9583333730697631, 0.583333432674408, 1.9583333730697631, 0.583333432674408, 1.9666666984558105, 0.583333432674408, 1.9583333730697631, 0.5000001192092895, 1.9583333730697631, 0.5000001192092895, 1.9500000476837158, 0.5000001192092895, 1.9500000476837158, 0.583333432674408, 1.9500000476837158, 0.583333432674408, 1.9583333730697631, 0.583333432674408, 1.9500000476837158, 0.5000001192092895, 1.9500000476837158, 0.5000001192092895, 1.9416667222976684, 0.5000001192092895, 1.9416667222976684, 0.583333432674408, 1.9416667222976684, 0.583333432674408, 1.9500000476837158, 0.583333432674408, 1.9416667222976684, 0.5000001192092895, 1.9416667222976684, 0.5000001192092895, 1.933333396911621, 0.5000001192092895, 1.933333396911621, 0.583333432674408, 1.933333396911621, 0.583333432674408, 1.9416667222976684, 0.583333432674408, 1.933333396911621, 0.5000001192092895, 1.933333396911621, 0.5000001192092895, 1.9250000715255737, 0.5000001192092895, 1.9250000715255737, 0.583333432674408, 1.9250000715255737, 0.583333432674408, 1.933333396911621, 0.583333432674408, 1.9250000715255737, 0.5000001192092895, 1.9250000715255737, 0.5000001192092895, 1.9166667461395263, 0.5000001192092895, 1.9166667461395263, 0.583333432674408, 1.9166667461395263, 0.583333432674408, 1.9250000715255737, 0.583333432674408, 1.9166667461395263, 0.5000001192092895, 1.9166667461395263, 0.5000001192092895, 1.908333420753479, 0.5000001192092895, 1.908333420753479, 0.583333432674408, 1.908333420753479, 0.583333432674408, 1.9166667461395263, 0.583333432674408, 1.908333420753479, 0.5000001192092895, 1.908333420753479, 0.5000001192092895, 1.9000000953674316, 0.5000001192092895, 1.9000000953674316, 0.583333432674408, 1.9000000953674316, 0.583333432674408, 1.908333420753479, 0.5000001192092895, 2, 0.41666677594184875, 2, 0.41666677594184875, 1.9916666746139526, 0.41666677594184875, 1.9916666746139526, 0.5000001192092895, 1.9916666746139526, 0.5000001192092895, 2, 0.5000001192092895, 1.9916666746139526, 0.41666677594184875, 1.9916666746139526, 0.41666677594184875, 1.9833333492279052, 0.41666677594184875, 1.9833333492279052, 0.5000001192092895, 1.9833333492279052, 0.5000001192092895, 1.9916666746139526, 0.5000001192092895, 1.9833333492279052, 0.41666677594184875, 1.9833333492279052, 0.41666677594184875, 1.975000023841858, 0.41666677594184875, 1.975000023841858, 0.5000001192092895, 1.975000023841858, 0.5000001192092895, 1.9833333492279052, 0.5000001192092895, 1.975000023841858, 0.41666677594184875, 1.975000023841858, 0.41666677594184875, 1.9666666984558105, 0.41666677594184875, 1.9666666984558105, 0.5000001192092895, 1.9666666984558105, 0.5000001192092895, 1.975000023841858, 0.5000001192092895, 1.9666666984558105, 0.41666677594184875, 1.9666666984558105, 0.41666677594184875, 1.9583333730697631, 0.41666677594184875, 1.9583333730697631, 0.5000001192092895, 1.9583333730697631, 0.5000001192092895, 1.9666666984558105, 0.5000001192092895, 1.9583333730697631, 0.41666677594184875, 1.9583333730697631, 0.41666677594184875, 1.9500000476837158, 0.41666677594184875, 1.9500000476837158, 0.5000001192092895, 1.9500000476837158, 0.5000001192092895, 1.9583333730697631, 0.5000001192092895, 1.9500000476837158, 0.41666677594184875, 1.9500000476837158, 0.41666677594184875, 1.9416667222976684, 0.41666677594184875, 1.9416667222976684, 0.5000001192092895, 1.9416667222976684, 0.5000001192092895, 1.9500000476837158, 0.5000001192092895, 1.9416667222976684, 0.41666677594184875, 1.9416667222976684, 0.41666677594184875, 1.933333396911621, 0.41666677594184875, 1.933333396911621, 0.5000001192092895, 1.933333396911621, 0.5000001192092895, 1.9416667222976684, 0.5000001192092895, 1.933333396911621, 0.41666677594184875, 1.933333396911621, 0.41666677594184875, 1.9250000715255737, 0.41666677594184875, 1.9250000715255737, 0.5000001192092895, 1.9250000715255737, 0.5000001192092895, 1.933333396911621, 0.5000001192092895, 1.9250000715255737, 0.41666677594184875, 1.9250000715255737, 0.41666677594184875, 1.9166667461395263, 0.41666677594184875, 1.9166667461395263, 0.5000001192092895, 1.9166667461395263, 0.5000001192092895, 1.9250000715255737, 0.5000001192092895, 1.9166667461395263, 0.41666677594184875, 1.9166667461395263, 0.41666677594184875, 1.908333420753479, 0.41666677594184875, 1.908333420753479, 0.5000001192092895, 1.908333420753479, 0.5000001192092895, 1.9166667461395263, 0.5000001192092895, 1.908333420753479, 0.41666677594184875, 1.908333420753479, 0.41666677594184875, 1.9000000953674316, 0.41666677594184875, 1.9000000953674316, 0.5000001192092895, 1.9000000953674316, 0.5000001192092895, 1.908333420753479, 0.41666677594184875, 2, 0.33333343267440796, 2, 0.33333343267440796, 1.9916666746139526, 0.33333343267440796, 1.9916666746139526, 0.41666677594184875, 1.9916666746139526, 0.41666677594184875, 2, 0.41666677594184875, 1.9916666746139526, 0.33333343267440796, 1.9916666746139526, 0.33333343267440796, 1.9833333492279052, 0.33333343267440796, 1.9833333492279052, 0.41666677594184875, 1.9833333492279052, 0.41666677594184875, 1.9916666746139526, 0.41666677594184875, 1.9833333492279052, 0.33333343267440796, 1.9833333492279052, 0.33333343267440796, 1.975000023841858, 0.33333343267440796, 1.975000023841858, 0.41666677594184875, 1.975000023841858, 0.41666677594184875, 1.9833333492279052, 0.41666677594184875, 1.975000023841858, 0.33333343267440796, 1.975000023841858, 0.33333343267440796, 1.9666666984558105, 0.33333343267440796, 1.9666666984558105, 0.41666677594184875, 1.9666666984558105, 0.41666677594184875, 1.975000023841858, 0.41666677594184875, 1.9666666984558105, 0.33333343267440796, 1.9666666984558105, 0.33333343267440796, 1.9583333730697631, 0.33333343267440796, 1.9583333730697631, 0.41666677594184875, 1.9583333730697631, 0.41666677594184875, 1.9666666984558105, 0.41666677594184875, 1.9583333730697631, 0.33333343267440796, 1.9583333730697631, 0.33333343267440796, 1.9500000476837158, 0.33333343267440796, 1.9500000476837158, 0.41666677594184875, 1.9500000476837158, 0.41666677594184875, 1.9583333730697631, 0.41666677594184875, 1.9500000476837158, 0.33333343267440796, 1.9500000476837158, 0.33333343267440796, 1.9416667222976684, 0.33333343267440796, 1.9416667222976684, 0.41666677594184875, 1.9416667222976684, 0.41666677594184875, 1.9500000476837158, 0.41666677594184875, 1.9416667222976684, 0.33333343267440796, 1.9416667222976684, 0.33333343267440796, 1.933333396911621, 0.33333343267440796, 1.933333396911621, 0.41666677594184875, 1.933333396911621, 0.41666677594184875, 1.9416667222976684, 0.41666677594184875, 1.933333396911621, 0.33333343267440796, 1.933333396911621, 0.33333343267440796, 1.9250000715255737, 0.33333343267440796, 1.9250000715255737, 0.41666677594184875, 1.9250000715255737, 0.41666677594184875, 1.933333396911621, 0.41666677594184875, 1.9250000715255737, 0.33333343267440796, 1.9250000715255737, 0.33333343267440796, 1.9166667461395263, 0.33333343267440796, 1.9166667461395263, 0.41666677594184875, 1.9166667461395263, 0.41666677594184875, 1.9250000715255737, 0.41666677594184875, 1.9166667461395263, 0.33333343267440796, 1.9166667461395263, 0.33333343267440796, 1.908333420753479, 0.33333343267440796, 1.908333420753479, 0.41666677594184875, 1.908333420753479, 0.41666677594184875, 1.9166667461395263, 0.41666677594184875, 1.908333420753479, 0.33333343267440796, 1.908333420753479, 0.33333343267440796, 1.9000000953674316, 0.33333343267440796, 1.9000000953674316, 0.41666677594184875, 1.9000000953674316, 0.41666677594184875, 1.908333420753479, 0.33333343267440796, 2, 0.25000008940696716, 2, 0.25000008940696716, 1.9916666746139526, 0.25000008940696716, 1.9916666746139526, 0.33333343267440796, 1.9916666746139526, 0.33333343267440796, 2, 0.33333343267440796, 1.9916666746139526, 0.25000008940696716, 1.9916666746139526, 0.25000008940696716, 1.9833333492279052, 0.25000008940696716, 1.9833333492279052, 0.33333343267440796, 1.9833333492279052, 0.33333343267440796, 1.9916666746139526, 0.33333343267440796, 1.9833333492279052, 0.25000008940696716, 1.9833333492279052, 0.25000008940696716, 1.975000023841858, 0.25000008940696716, 1.975000023841858, 0.33333343267440796, 1.975000023841858, 0.33333343267440796, 1.9833333492279052, 0.33333343267440796, 1.975000023841858, 0.25000008940696716, 1.975000023841858, 0.25000008940696716, 1.9666666984558105, 0.25000008940696716, 1.9666666984558105, 0.33333343267440796, 1.9666666984558105, 0.33333343267440796, 1.975000023841858, 0.33333343267440796, 1.9666666984558105, 0.25000008940696716, 1.9666666984558105, 0.25000008940696716, 1.9583333730697631, 0.25000008940696716, 1.9583333730697631, 0.33333343267440796, 1.9583333730697631, 0.33333343267440796, 1.9666666984558105, 0.33333343267440796, 1.9583333730697631, 0.25000008940696716, 1.9583333730697631, 0.25000008940696716, 1.9500000476837158, 0.25000008940696716, 1.9500000476837158, 0.33333343267440796, 1.9500000476837158, 0.33333343267440796, 1.9583333730697631, 0.33333343267440796, 1.9500000476837158, 0.25000008940696716, 1.9500000476837158, 0.25000008940696716, 1.9416667222976684, 0.25000008940696716, 1.9416667222976684, 0.33333343267440796, 1.9416667222976684, 0.33333343267440796, 1.9500000476837158, 0.33333343267440796, 1.9416667222976684, 0.25000008940696716, 1.9416667222976684, 0.25000008940696716, 1.933333396911621, 0.25000008940696716, 1.933333396911621, 0.33333343267440796, 1.933333396911621, 0.33333343267440796, 1.9416667222976684, 0.33333343267440796, 1.933333396911621, 0.25000008940696716, 1.933333396911621, 0.25000008940696716, 1.9250000715255737, 0.25000008940696716, 1.9250000715255737, 0.33333343267440796, 1.9250000715255737, 0.33333343267440796, 1.933333396911621, 0.33333343267440796, 1.9250000715255737, 0.25000008940696716, 1.9250000715255737, 0.25000008940696716, 1.9166667461395263, 0.25000008940696716, 1.9166667461395263, 0.33333343267440796, 1.9166667461395263, 0.33333343267440796, 1.9250000715255737, 0.33333343267440796, 1.9166667461395263, 0.25000008940696716, 1.9166667461395263, 0.25000008940696716, 1.908333420753479, 0.25000008940696716, 1.908333420753479, 0.33333343267440796, 1.908333420753479, 0.33333343267440796, 1.9166667461395263, 0.33333343267440796, 1.908333420753479, 0.25000008940696716, 1.908333420753479, 0.25000008940696716, 1.9000000953674316, 0.25000008940696716, 1.9000000953674316, 0.33333343267440796, 1.9000000953674316, 0.33333343267440796, 1.908333420753479, 0.25000008940696716, 2, 0.16666674613952637, 2, 0.16666674613952637, 1.9916666746139526, 0.16666674613952637, 1.9916666746139526, 0.25000008940696716, 1.9916666746139526, 0.25000008940696716, 2, 0.25000008940696716, 1.9916666746139526, 0.16666674613952637, 1.9916666746139526, 0.16666674613952637, 1.9833333492279052, 0.16666674613952637, 1.9833333492279052, 0.25000008940696716, 1.9833333492279052, 0.25000008940696716, 1.9916666746139526, 0.25000008940696716, 1.9833333492279052, 0.16666674613952637, 1.9833333492279052, 0.16666674613952637, 1.975000023841858, 0.16666674613952637, 1.975000023841858, 0.25000008940696716, 1.975000023841858, 0.25000008940696716, 1.9833333492279052, 0.25000008940696716, 1.975000023841858, 0.16666674613952637, 1.975000023841858, 0.16666674613952637, 1.9666666984558105, 0.16666674613952637, 1.9666666984558105, 0.25000008940696716, 1.9666666984558105, 0.25000008940696716, 1.975000023841858, 0.25000008940696716, 1.9666666984558105, 0.16666674613952637, 1.9666666984558105, 0.16666674613952637, 1.9583333730697631, 0.16666674613952637, 1.9583333730697631, 0.25000008940696716, 1.9583333730697631, 0.25000008940696716, 1.9666666984558105, 0.25000008940696716, 1.9583333730697631, 0.16666674613952637, 1.9583333730697631, 0.16666674613952637, 1.9500000476837158, 0.16666674613952637, 1.9500000476837158, 0.25000008940696716, 1.9500000476837158, 0.25000008940696716, 1.9583333730697631, 0.25000008940696716, 1.9500000476837158, 0.16666674613952637, 1.9500000476837158, 0.16666674613952637, 1.9416667222976684, 0.16666674613952637, 1.9416667222976684, 0.25000008940696716, 1.9416667222976684, 0.25000008940696716, 1.9500000476837158, 0.25000008940696716, 1.9416667222976684, 0.16666674613952637, 1.9416667222976684, 0.16666674613952637, 1.933333396911621, 0.16666674613952637, 1.933333396911621, 0.25000008940696716, 1.933333396911621, 0.25000008940696716, 1.9416667222976684, 0.25000008940696716, 1.933333396911621, 0.16666674613952637, 1.933333396911621, 0.16666674613952637, 1.9250000715255737, 0.16666674613952637, 1.9250000715255737, 0.25000008940696716, 1.9250000715255737, 0.25000008940696716, 1.933333396911621, 0.25000008940696716, 1.9250000715255737, 0.16666674613952637, 1.9250000715255737, 0.16666674613952637, 1.9166667461395263, 0.16666674613952637, 1.9166667461395263, 0.25000008940696716, 1.9166667461395263, 0.25000008940696716, 1.9250000715255737, 0.25000008940696716, 1.9166667461395263, 0.16666674613952637, 1.9166667461395263, 0.16666674613952637, 1.908333420753479, 0.16666674613952637, 1.908333420753479, 0.25000008940696716, 1.908333420753479, 0.25000008940696716, 1.9166667461395263, 0.25000008940696716, 1.908333420753479, 0.16666674613952637, 1.908333420753479, 0.16666674613952637, 1.9000000953674316, 0.16666674613952637, 1.9000000953674316, 0.25000008940696716, 1.9000000953674316, 0.25000008940696716, 1.908333420753479, 0.16666674613952637, 2, 0.08333341032266617, 2, 0.08333341032266617, 1.9916666746139526, 0.08333341032266617, 1.9916666746139526, 0.16666674613952637, 1.9916666746139526, 0.16666674613952637, 2, 0.16666674613952637, 1.9916666746139526, 0.08333341032266617, 1.9916666746139526, 0.08333341032266617, 1.9833333492279052, 0.08333341032266617, 1.9833333492279052, 0.16666674613952637, 1.9833333492279052, 0.16666674613952637, 1.9916666746139526, 0.16666674613952637, 1.9833333492279052, 0.08333341032266617, 1.9833333492279052, 0.08333341032266617, 1.975000023841858, 0.08333341032266617, 1.975000023841858, 0.16666674613952637, 1.975000023841858, 0.16666674613952637, 1.9833333492279052, 0.16666674613952637, 1.975000023841858, 0.08333341032266617, 1.975000023841858, 0.08333341032266617, 1.9666666984558105, 0.08333341032266617, 1.9666666984558105, 0.16666674613952637, 1.9666666984558105, 0.16666674613952637, 1.975000023841858, 0.16666674613952637, 1.9666666984558105, 0.08333341032266617, 1.9666666984558105, 0.08333341032266617, 1.9583333730697631, 0.08333341032266617, 1.9583333730697631, 0.16666674613952637, 1.9583333730697631, 0.16666674613952637, 1.9666666984558105, 0.16666674613952637, 1.9583333730697631, 0.08333341032266617, 1.9583333730697631, 0.08333341032266617, 1.9500000476837158, 0.08333341032266617, 1.9500000476837158, 0.16666674613952637, 1.9500000476837158, 0.16666674613952637, 1.9583333730697631, 0.16666674613952637, 1.9500000476837158, 0.08333341032266617, 1.9500000476837158, 0.08333341032266617, 1.9416667222976684, 0.08333341032266617, 1.9416667222976684, 0.16666674613952637, 1.9416667222976684, 0.16666674613952637, 1.9500000476837158, 0.16666674613952637, 1.9416667222976684, 0.08333341032266617, 1.9416667222976684, 0.08333341032266617, 1.933333396911621, 0.08333341032266617, 1.933333396911621, 0.16666674613952637, 1.933333396911621, 0.16666674613952637, 1.9416667222976684, 0.16666674613952637, 1.933333396911621, 0.08333341032266617, 1.933333396911621, 0.08333341032266617, 1.9250000715255737, 0.08333341032266617, 1.9250000715255737, 0.16666674613952637, 1.9250000715255737, 0.16666674613952637, 1.933333396911621, 0.16666674613952637, 1.9250000715255737, 0.08333341032266617, 1.9250000715255737, 0.08333341032266617, 1.9166667461395263, 0.08333341032266617, 1.9166667461395263, 0.16666674613952637, 1.9166667461395263, 0.16666674613952637, 1.9250000715255737, 0.16666674613952637, 1.9166667461395263, 0.08333341032266617, 1.9166667461395263, 0.08333341032266617, 1.908333420753479, 0.08333341032266617, 1.908333420753479, 0.16666674613952637, 1.908333420753479, 0.16666674613952637, 1.9166667461395263, 0.16666674613952637, 1.908333420753479, 0.08333341032266617, 1.908333420753479, 0.08333341032266617, 1.9000000953674316, 0.08333341032266617, 1.9000000953674316, 0.16666674613952637, 1.9000000953674316, 0.16666674613952637, 1.908333420753479, 0.08333341032266617, 2, 7.450580596923828e-8, 2, 7.450580596923828e-8, 1.9916666746139526, 7.450580596923828e-8, 1.9916666746139526, 0.08333341032266617, 1.9916666746139526, 0.08333341032266617, 2, 0.08333341032266617, 1.9916666746139526, 7.450580596923828e-8, 1.9916666746139526, 7.450580596923828e-8, 1.9833333492279052, 7.450580596923828e-8, 1.9833333492279052, 0.08333341032266617, 1.9833333492279052, 0.08333341032266617, 1.9916666746139526, 0.08333341032266617, 1.9833333492279052, 7.450580596923828e-8, 1.9833333492279052, 7.450580596923828e-8, 1.975000023841858, 7.450580596923828e-8, 1.975000023841858, 0.08333341032266617, 1.975000023841858, 0.08333341032266617, 1.9833333492279052, 0.08333341032266617, 1.975000023841858, 7.450580596923828e-8, 1.975000023841858, 7.450580596923828e-8, 1.9666666984558105, 7.450580596923828e-8, 1.9666666984558105, 0.08333341032266617, 1.9666666984558105, 0.08333341032266617, 1.975000023841858, 0.08333341032266617, 1.9666666984558105, 7.450580596923828e-8, 1.9666666984558105, 7.450580596923828e-8, 1.9583333730697631, 7.450580596923828e-8, 1.9583333730697631, 0.08333341032266617, 1.9583333730697631, 0.08333341032266617, 1.9666666984558105, 0.08333341032266617, 1.9583333730697631, 7.450580596923828e-8, 1.9583333730697631, 7.450580596923828e-8, 1.9500000476837158, 7.450580596923828e-8, 1.9500000476837158, 0.08333341032266617, 1.9500000476837158, 0.08333341032266617, 1.9583333730697631, 0.08333341032266617, 1.9500000476837158, 7.450580596923828e-8, 1.9500000476837158, 7.450580596923828e-8, 1.9416667222976684, 7.450580596923828e-8, 1.9416667222976684, 0.08333341032266617, 1.9416667222976684, 0.08333341032266617, 1.9500000476837158, 0.08333341032266617, 1.9416667222976684, 7.450580596923828e-8, 1.9416667222976684, 7.450580596923828e-8, 1.933333396911621, 7.450580596923828e-8, 1.933333396911621, 0.08333341032266617, 1.933333396911621, 0.08333341032266617, 1.9416667222976684, 0.08333341032266617, 1.933333396911621, 7.450580596923828e-8, 1.933333396911621, 7.450580596923828e-8, 1.9250000715255737, 7.450580596923828e-8, 1.9250000715255737, 0.08333341032266617, 1.9250000715255737, 0.08333341032266617, 1.933333396911621, 0.08333341032266617, 1.9250000715255737, 7.450580596923828e-8, 1.9250000715255737, 7.450580596923828e-8, 1.9166667461395263, 7.450580596923828e-8, 1.9166667461395263, 0.08333341032266617, 1.9166667461395263, 0.08333341032266617, 1.9250000715255737, 0.08333341032266617, 1.9166667461395263, 7.450580596923828e-8, 1.9166667461395263, 7.450580596923828e-8, 1.908333420753479, 7.450580596923828e-8, 1.908333420753479, 0.08333341032266617, 1.908333420753479, 0.08333341032266617, 1.9166667461395263, 0.08333341032266617, 1.908333420753479, 7.450580596923828e-8, 1.908333420753479, 7.450580596923828e-8, 1.9000000953674316, 7.450580596923828e-8, 1.9000000953674316, 0.08333341032266617, 1.9000000953674316, 0.08333341032266617, 1.908333420753479, 2, 2, 1.9166666269302368, 2, 1.9166666269302368, 1.9916666746139526, 1.9166666269302368, 1.9916666746139526, 2, 1.9916666746139526, 2, 2, 2, 1.9916666746139526, 1.9166666269302368, 1.9916666746139526, 1.9166666269302368, 1.9833333492279052, 1.9166666269302368, 1.9833333492279052, 2, 1.9833333492279052, 2, 1.9916666746139526, 2, 1.9833333492279052, 1.9166666269302368, 1.9833333492279052, 1.9166666269302368, 1.975000023841858, 1.9166666269302368, 1.975000023841858, 2, 1.975000023841858, 2, 1.9833333492279052, 2, 1.975000023841858, 1.9166666269302368, 1.975000023841858, 1.9166666269302368, 1.9666666984558105, 1.9166666269302368, 1.9666666984558105, 2, 1.9666666984558105, 2, 1.975000023841858, 2, 1.9666666984558105, 1.9166666269302368, 1.9666666984558105, 1.9166666269302368, 1.9583333730697631, 1.9166666269302368, 1.9583333730697631, 2, 1.9583333730697631, 2, 1.9666666984558105, 2, 1.9583333730697631, 1.9166666269302368, 1.9583333730697631, 1.9166666269302368, 1.9500000476837158, 1.9166666269302368, 1.9500000476837158, 2, 1.9500000476837158, 2, 1.9583333730697631, 2, 1.9500000476837158, 1.9166666269302368, 1.9500000476837158, 1.9166666269302368, 1.9416667222976684, 1.9166666269302368, 1.9416667222976684, 2, 1.9416667222976684, 2, 1.9500000476837158, 2, 1.9416667222976684, 1.9166666269302368, 1.9416667222976684, 1.9166666269302368, 1.933333396911621, 1.9166666269302368, 1.933333396911621, 2, 1.933333396911621, 2, 1.9416667222976684, 2, 1.933333396911621, 1.9166666269302368, 1.933333396911621, 1.9166666269302368, 1.9250000715255737, 1.9166666269302368, 1.9250000715255737, 2, 1.9250000715255737, 2, 1.933333396911621, 2, 1.9250000715255737, 1.9166666269302368, 1.9250000715255737, 1.9166666269302368, 1.9166667461395263, 1.9166666269302368, 1.9166667461395263, 2, 1.9166667461395263, 2, 1.9250000715255737, 2, 1.9166667461395263, 1.9166666269302368, 1.9166667461395263, 1.9166666269302368, 1.908333420753479, 1.9166666269302368, 1.908333420753479, 2, 1.908333420753479, 2, 1.9166667461395263, 2, 1.908333420753479, 1.9166666269302368, 1.908333420753479, 1.9166666269302368, 1.9000000953674316, 1.9166666269302368, 1.9000000953674316, 2, 1.9000000953674316, 2, 1.908333420753479, 1.9166666269302368, 2, 1.8333332538604736, 2, 1.8333332538604736, 1.9916666746139526, 1.8333332538604736, 1.9916666746139526, 1.9166666269302368, 1.9916666746139526, 1.9166666269302368, 2, 1.9166666269302368, 1.9916666746139526, 1.8333332538604736, 1.9916666746139526, 1.8333332538604736, 1.9833333492279052, 1.8333332538604736, 1.9833333492279052, 1.9166666269302368, 1.9833333492279052, 1.9166666269302368, 1.9916666746139526, 1.9166666269302368, 1.9833333492279052, 1.8333332538604736, 1.9833333492279052, 1.8333332538604736, 1.975000023841858, 1.8333332538604736, 1.975000023841858, 1.9166666269302368, 1.975000023841858, 1.9166666269302368, 1.9833333492279052, 1.9166666269302368, 1.975000023841858, 1.8333332538604736, 1.975000023841858, 1.8333332538604736, 1.9666666984558105, 1.8333332538604736, 1.9666666984558105, 1.9166666269302368, 1.9666666984558105, 1.9166666269302368, 1.975000023841858, 1.9166666269302368, 1.9666666984558105, 1.8333332538604736, 1.9666666984558105, 1.8333332538604736, 1.9583333730697631, 1.8333332538604736, 1.9583333730697631, 1.9166666269302368, 1.9583333730697631, 1.9166666269302368, 1.9666666984558105, 1.9166666269302368, 1.9583333730697631, 1.8333332538604736, 1.9583333730697631, 1.8333332538604736, 1.9500000476837158, 1.8333332538604736, 1.9500000476837158, 1.9166666269302368, 1.9500000476837158, 1.9166666269302368, 1.9583333730697631, 1.9166666269302368, 1.9500000476837158, 1.8333332538604736, 1.9500000476837158, 1.8333332538604736, 1.9416667222976684, 1.8333332538604736, 1.9416667222976684, 1.9166666269302368, 1.9416667222976684, 1.9166666269302368, 1.9500000476837158, 1.9166666269302368, 1.9416667222976684, 1.8333332538604736, 1.9416667222976684, 1.8333332538604736, 1.933333396911621, 1.8333332538604736, 1.933333396911621, 1.9166666269302368, 1.933333396911621, 1.9166666269302368, 1.9416667222976684, 1.9166666269302368, 1.933333396911621, 1.8333332538604736, 1.933333396911621, 1.8333332538604736, 1.9250000715255737, 1.8333332538604736, 1.9250000715255737, 1.9166666269302368, 1.9250000715255737, 1.9166666269302368, 1.933333396911621, 1.9166666269302368, 1.9250000715255737, 1.8333332538604736, 1.9250000715255737, 1.8333332538604736, 1.9166667461395263, 1.8333332538604736, 1.9166667461395263, 1.9166666269302368, 1.9166667461395263, 1.9166666269302368, 1.9250000715255737, 1.9166666269302368, 1.9166667461395263, 1.8333332538604736, 1.9166667461395263, 1.8333332538604736, 1.908333420753479, 1.8333332538604736, 1.908333420753479, 1.9166666269302368, 1.908333420753479, 1.9166666269302368, 1.9166667461395263, 1.9166666269302368, 1.908333420753479, 1.8333332538604736, 1.908333420753479, 1.8333332538604736, 1.9000000953674316, 1.8333332538604736, 1.9000000953674316, 1.9166666269302368, 1.9000000953674316, 1.9166666269302368, 1.908333420753479, 1.8333332538604736, 2, 1.7499998807907104, 2, 1.7499998807907104, 1.9916666746139526, 1.7499998807907104, 1.9916666746139526, 1.8333332538604736, 1.9916666746139526, 1.8333332538604736, 2, 1.8333332538604736, 1.9916666746139526, 1.7499998807907104, 1.9916666746139526, 1.7499998807907104, 1.9833333492279052, 1.7499998807907104, 1.9833333492279052, 1.8333332538604736, 1.9833333492279052, 1.8333332538604736, 1.9916666746139526, 1.8333332538604736, 1.9833333492279052, 1.7499998807907104, 1.9833333492279052, 1.7499998807907104, 1.975000023841858, 1.7499998807907104, 1.975000023841858, 1.8333332538604736, 1.975000023841858, 1.8333332538604736, 1.9833333492279052, 1.8333332538604736, 1.975000023841858, 1.7499998807907104, 1.975000023841858, 1.7499998807907104, 1.9666666984558105, 1.7499998807907104, 1.9666666984558105, 1.8333332538604736, 1.9666666984558105, 1.8333332538604736, 1.975000023841858, 1.8333332538604736, 1.9666666984558105, 1.7499998807907104, 1.9666666984558105, 1.7499998807907104, 1.9583333730697631, 1.7499998807907104, 1.9583333730697631, 1.8333332538604736, 1.9583333730697631, 1.8333332538604736, 1.9666666984558105, 1.8333332538604736, 1.9583333730697631, 1.7499998807907104, 1.9583333730697631, 1.7499998807907104, 1.9500000476837158, 1.7499998807907104, 1.9500000476837158, 1.8333332538604736, 1.9500000476837158, 1.8333332538604736, 1.9583333730697631, 1.8333332538604736, 1.9500000476837158, 1.7499998807907104, 1.9500000476837158, 1.7499998807907104, 1.9416667222976684, 1.7499998807907104, 1.9416667222976684, 1.8333332538604736, 1.9416667222976684, 1.8333332538604736, 1.9500000476837158, 1.8333332538604736, 1.9416667222976684, 1.7499998807907104, 1.9416667222976684, 1.7499998807907104, 1.933333396911621, 1.7499998807907104, 1.933333396911621, 1.8333332538604736, 1.933333396911621, 1.8333332538604736, 1.9416667222976684, 1.8333332538604736, 1.933333396911621, 1.7499998807907104, 1.933333396911621, 1.7499998807907104, 1.9250000715255737, 1.7499998807907104, 1.9250000715255737, 1.8333332538604736, 1.9250000715255737, 1.8333332538604736, 1.933333396911621, 1.8333332538604736, 1.9250000715255737, 1.7499998807907104, 1.9250000715255737, 1.7499998807907104, 1.9166667461395263, 1.7499998807907104, 1.9166667461395263, 1.8333332538604736, 1.9166667461395263, 1.8333332538604736, 1.9250000715255737, 1.8333332538604736, 1.9166667461395263, 1.7499998807907104, 1.9166667461395263, 1.7499998807907104, 1.908333420753479, 1.7499998807907104, 1.908333420753479, 1.8333332538604736, 1.908333420753479, 1.8333332538604736, 1.9166667461395263, 1.8333332538604736, 1.908333420753479, 1.7499998807907104, 1.908333420753479, 1.7499998807907104, 1.9000000953674316, 1.7499998807907104, 1.9000000953674316, 1.8333332538604736, 1.9000000953674316, 1.8333332538604736, 1.908333420753479, 1.7499998807907104, 2, 1.6666665077209472, 2, 1.6666665077209472, 1.9916666746139526, 1.6666665077209472, 1.9916666746139526, 1.7499998807907104, 1.9916666746139526, 1.7499998807907104, 2, 1.7499998807907104, 1.9916666746139526, 1.6666665077209472, 1.9916666746139526, 1.6666665077209472, 1.9833333492279052, 1.6666665077209472, 1.9833333492279052, 1.7499998807907104, 1.9833333492279052, 1.7499998807907104, 1.9916666746139526, 1.7499998807907104, 1.9833333492279052, 1.6666665077209472, 1.9833333492279052, 1.6666665077209472, 1.975000023841858, 1.6666665077209472, 1.975000023841858, 1.7499998807907104, 1.975000023841858, 1.7499998807907104, 1.9833333492279052, 1.7499998807907104, 1.975000023841858, 1.6666665077209472, 1.975000023841858, 1.6666665077209472, 1.9666666984558105, 1.6666665077209472, 1.9666666984558105, 1.7499998807907104, 1.9666666984558105, 1.7499998807907104, 1.975000023841858, 1.7499998807907104, 1.9666666984558105, 1.6666665077209472, 1.9666666984558105, 1.6666665077209472, 1.9583333730697631, 1.6666665077209472, 1.9583333730697631, 1.7499998807907104, 1.9583333730697631, 1.7499998807907104, 1.9666666984558105, 1.7499998807907104, 1.9583333730697631, 1.6666665077209472, 1.9583333730697631, 1.6666665077209472, 1.9500000476837158, 1.6666665077209472, 1.9500000476837158, 1.7499998807907104, 1.9500000476837158, 1.7499998807907104, 1.9583333730697631, 1.7499998807907104, 1.9500000476837158, 1.6666665077209472, 1.9500000476837158, 1.6666665077209472, 1.9416667222976684, 1.6666665077209472, 1.9416667222976684, 1.7499998807907104, 1.9416667222976684, 1.7499998807907104, 1.9500000476837158, 1.7499998807907104, 1.9416667222976684, 1.6666665077209472, 1.9416667222976684, 1.6666665077209472, 1.933333396911621, 1.6666665077209472, 1.933333396911621, 1.7499998807907104, 1.933333396911621, 1.7499998807907104, 1.9416667222976684, 1.7499998807907104, 1.933333396911621, 1.6666665077209472, 1.933333396911621, 1.6666665077209472, 1.9250000715255737, 1.6666665077209472, 1.9250000715255737, 1.7499998807907104, 1.9250000715255737, 1.7499998807907104, 1.933333396911621, 1.7499998807907104, 1.9250000715255737, 1.6666665077209472, 1.9250000715255737, 1.6666665077209472, 1.9166667461395263, 1.6666665077209472, 1.9166667461395263, 1.7499998807907104, 1.9166667461395263, 1.7499998807907104, 1.9250000715255737, 1.7499998807907104, 1.9166667461395263, 1.6666665077209472, 1.9166667461395263, 1.6666665077209472, 1.908333420753479, 1.6666665077209472, 1.908333420753479, 1.7499998807907104, 1.908333420753479, 1.7499998807907104, 1.9166667461395263, 1.7499998807907104, 1.908333420753479, 1.6666665077209472, 1.908333420753479, 1.6666665077209472, 1.9000000953674316, 1.6666665077209472, 1.9000000953674316, 1.7499998807907104, 1.9000000953674316, 1.7499998807907104, 1.908333420753479, 1.6666665077209472, 2, 1.583333134651184, 2, 1.583333134651184, 1.9916666746139526, 1.583333134651184, 1.9916666746139526, 1.6666665077209472, 1.9916666746139526, 1.6666665077209472, 2, 1.6666665077209472, 1.9916666746139526, 1.583333134651184, 1.9916666746139526, 1.583333134651184, 1.9833333492279052, 1.583333134651184, 1.9833333492279052, 1.6666665077209472, 1.9833333492279052, 1.6666665077209472, 1.9916666746139526, 1.6666665077209472, 1.9833333492279052, 1.583333134651184, 1.9833333492279052, 1.583333134651184, 1.975000023841858, 1.583333134651184, 1.975000023841858, 1.6666665077209472, 1.975000023841858, 1.6666665077209472, 1.9833333492279052, 1.6666665077209472, 1.975000023841858, 1.583333134651184, 1.975000023841858, 1.583333134651184, 1.9666666984558105, 1.583333134651184, 1.9666666984558105, 1.6666665077209472, 1.9666666984558105, 1.6666665077209472, 1.975000023841858, 1.6666665077209472, 1.9666666984558105, 1.583333134651184, 1.9666666984558105, 1.583333134651184, 1.9583333730697631, 1.583333134651184, 1.9583333730697631, 1.6666665077209472, 1.9583333730697631, 1.6666665077209472, 1.9666666984558105, 1.6666665077209472, 1.9583333730697631, 1.583333134651184, 1.9583333730697631, 1.583333134651184, 1.9500000476837158, 1.583333134651184, 1.9500000476837158, 1.6666665077209472, 1.9500000476837158, 1.6666665077209472, 1.9583333730697631, 1.6666665077209472, 1.9500000476837158, 1.583333134651184, 1.9500000476837158, 1.583333134651184, 1.9416667222976684, 1.583333134651184, 1.9416667222976684, 1.6666665077209472, 1.9416667222976684, 1.6666665077209472, 1.9500000476837158, 1.6666665077209472, 1.9416667222976684, 1.583333134651184, 1.9416667222976684, 1.583333134651184, 1.933333396911621, 1.583333134651184, 1.933333396911621, 1.6666665077209472, 1.933333396911621, 1.6666665077209472, 1.9416667222976684, 1.6666665077209472, 1.933333396911621, 1.583333134651184, 1.933333396911621, 1.583333134651184, 1.9250000715255737, 1.583333134651184, 1.9250000715255737, 1.6666665077209472, 1.9250000715255737, 1.6666665077209472, 1.933333396911621, 1.6666665077209472, 1.9250000715255737, 1.583333134651184, 1.9250000715255737, 1.583333134651184, 1.9166667461395263, 1.583333134651184, 1.9166667461395263, 1.6666665077209472, 1.9166667461395263, 1.6666665077209472, 1.9250000715255737, 1.6666665077209472, 1.9166667461395263, 1.583333134651184, 1.9166667461395263, 1.583333134651184, 1.908333420753479, 1.583333134651184, 1.908333420753479, 1.6666665077209472, 1.908333420753479, 1.6666665077209472, 1.9166667461395263, 1.6666665077209472, 1.908333420753479, 1.583333134651184, 1.908333420753479, 1.583333134651184, 1.9000000953674316, 1.583333134651184, 1.9000000953674316, 1.6666665077209472, 1.9000000953674316, 1.6666665077209472, 1.908333420753479, 1.583333134651184, 2, 1.499999761581421, 2, 1.499999761581421, 1.9916666746139526, 1.499999761581421, 1.9916666746139526, 1.583333134651184, 1.9916666746139526, 1.583333134651184, 2, 1.583333134651184, 1.9916666746139526, 1.499999761581421, 1.9916666746139526, 1.499999761581421, 1.9833333492279052, 1.499999761581421, 1.9833333492279052, 1.583333134651184, 1.9833333492279052, 1.583333134651184, 1.9916666746139526, 1.583333134651184, 1.9833333492279052, 1.499999761581421, 1.9833333492279052, 1.499999761581421, 1.975000023841858, 1.499999761581421, 1.975000023841858, 1.583333134651184, 1.975000023841858, 1.583333134651184, 1.9833333492279052, 1.583333134651184, 1.975000023841858, 1.499999761581421, 1.975000023841858, 1.499999761581421, 1.9666666984558105, 1.499999761581421, 1.9666666984558105, 1.583333134651184, 1.9666666984558105, 1.583333134651184, 1.975000023841858, 1.583333134651184, 1.9666666984558105, 1.499999761581421, 1.9666666984558105, 1.499999761581421, 1.9583333730697631, 1.499999761581421, 1.9583333730697631, 1.583333134651184, 1.9583333730697631, 1.583333134651184, 1.9666666984558105, 1.583333134651184, 1.9583333730697631, 1.499999761581421, 1.9583333730697631, 1.499999761581421, 1.9500000476837158, 1.499999761581421, 1.9500000476837158, 1.583333134651184, 1.9500000476837158, 1.583333134651184, 1.9583333730697631, 1.583333134651184, 1.9500000476837158, 1.499999761581421, 1.9500000476837158, 1.499999761581421, 1.9416667222976684, 1.499999761581421, 1.9416667222976684, 1.583333134651184, 1.9416667222976684, 1.583333134651184, 1.9500000476837158, 1.583333134651184, 1.9416667222976684, 1.499999761581421, 1.9416667222976684, 1.499999761581421, 1.933333396911621, 1.499999761581421, 1.933333396911621, 1.583333134651184, 1.933333396911621, 1.583333134651184, 1.9416667222976684, 1.583333134651184, 1.933333396911621, 1.499999761581421, 1.933333396911621, 1.499999761581421, 1.9250000715255737, 1.499999761581421, 1.9250000715255737, 1.583333134651184, 1.9250000715255737, 1.583333134651184, 1.933333396911621, 1.583333134651184, 1.9250000715255737, 1.499999761581421, 1.9250000715255737, 1.499999761581421, 1.9166667461395263, 1.499999761581421, 1.9166667461395263, 1.583333134651184, 1.9166667461395263, 1.583333134651184, 1.9250000715255737, 1.583333134651184, 1.9166667461395263, 1.499999761581421, 1.9166667461395263, 1.499999761581421, 1.908333420753479, 1.499999761581421, 1.908333420753479, 1.583333134651184, 1.908333420753479, 1.583333134651184, 1.9166667461395263, 1.583333134651184, 1.908333420753479, 1.499999761581421, 1.908333420753479, 1.499999761581421, 1.9000000953674316, 1.499999761581421, 1.9000000953674316, 1.583333134651184, 1.9000000953674316, 1.583333134651184, 1.908333420753479, 1.499999761581421, 2, 1.4166663885116577, 2, 1.4166663885116577, 1.9916666746139526, 1.4166663885116577, 1.9916666746139526, 1.499999761581421, 1.9916666746139526, 1.499999761581421, 2, 1.499999761581421, 1.9916666746139526, 1.4166663885116577, 1.9916666746139526, 1.4166663885116577, 1.9833333492279052, 1.4166663885116577, 1.9833333492279052, 1.499999761581421, 1.9833333492279052, 1.499999761581421, 1.9916666746139526, 1.499999761581421, 1.9833333492279052, 1.4166663885116577, 1.9833333492279052, 1.4166663885116577, 1.975000023841858, 1.4166663885116577, 1.975000023841858, 1.499999761581421, 1.975000023841858, 1.499999761581421, 1.9833333492279052, 1.499999761581421, 1.975000023841858, 1.4166663885116577, 1.975000023841858, 1.4166663885116577, 1.9666666984558105, 1.4166663885116577, 1.9666666984558105, 1.499999761581421, 1.9666666984558105, 1.499999761581421, 1.975000023841858, 1.499999761581421, 1.9666666984558105, 1.4166663885116577, 1.9666666984558105, 1.4166663885116577, 1.9583333730697631, 1.4166663885116577, 1.9583333730697631, 1.499999761581421, 1.9583333730697631, 1.499999761581421, 1.9666666984558105, 1.499999761581421, 1.9583333730697631, 1.4166663885116577, 1.9583333730697631, 1.4166663885116577, 1.9500000476837158, 1.4166663885116577, 1.9500000476837158, 1.499999761581421, 1.9500000476837158, 1.499999761581421, 1.9583333730697631, 1.499999761581421, 1.9500000476837158, 1.4166663885116577, 1.9500000476837158, 1.4166663885116577, 1.9416667222976684, 1.4166663885116577, 1.9416667222976684, 1.499999761581421, 1.9416667222976684, 1.499999761581421, 1.9500000476837158, 1.499999761581421, 1.9416667222976684, 1.4166663885116577, 1.9416667222976684, 1.4166663885116577, 1.933333396911621, 1.4166663885116577, 1.933333396911621, 1.499999761581421, 1.933333396911621, 1.499999761581421, 1.9416667222976684, 1.499999761581421, 1.933333396911621, 1.4166663885116577, 1.933333396911621, 1.4166663885116577, 1.9250000715255737, 1.4166663885116577, 1.9250000715255737, 1.499999761581421, 1.9250000715255737, 1.499999761581421, 1.933333396911621, 1.499999761581421, 1.9250000715255737, 1.4166663885116577, 1.9250000715255737, 1.4166663885116577, 1.9166667461395263, 1.4166663885116577, 1.9166667461395263, 1.499999761581421, 1.9166667461395263, 1.499999761581421, 1.9250000715255737, 1.499999761581421, 1.9166667461395263, 1.4166663885116577, 1.9166667461395263, 1.4166663885116577, 1.908333420753479, 1.4166663885116577, 1.908333420753479, 1.499999761581421, 1.908333420753479, 1.499999761581421, 1.9166667461395263, 1.499999761581421, 1.908333420753479, 1.4166663885116577, 1.908333420753479, 1.4166663885116577, 1.9000000953674316, 1.4166663885116577, 1.9000000953674316, 1.499999761581421, 1.9000000953674316, 1.499999761581421, 1.908333420753479, 1.4166663885116577, 2, 1.3333330154418945, 2, 1.3333330154418945, 1.9916666746139526, 1.3333330154418945, 1.9916666746139526, 1.4166663885116577, 1.9916666746139526, 1.4166663885116577, 2, 1.4166663885116577, 1.9916666746139526, 1.3333330154418945, 1.9916666746139526, 1.3333330154418945, 1.9833333492279052, 1.3333330154418945, 1.9833333492279052, 1.4166663885116577, 1.9833333492279052, 1.4166663885116577, 1.9916666746139526, 1.4166663885116577, 1.9833333492279052, 1.3333330154418945, 1.9833333492279052, 1.3333330154418945, 1.975000023841858, 1.3333330154418945, 1.975000023841858, 1.4166663885116577, 1.975000023841858, 1.4166663885116577, 1.9833333492279052, 1.4166663885116577, 1.975000023841858, 1.3333330154418945, 1.975000023841858, 1.3333330154418945, 1.9666666984558105, 1.3333330154418945, 1.9666666984558105, 1.4166663885116577, 1.9666666984558105, 1.4166663885116577, 1.975000023841858, 1.4166663885116577, 1.9666666984558105, 1.3333330154418945, 1.9666666984558105, 1.3333330154418945, 1.9583333730697631, 1.3333330154418945, 1.9583333730697631, 1.4166663885116577, 1.9583333730697631, 1.4166663885116577, 1.9666666984558105, 1.4166663885116577, 1.9583333730697631, 1.3333330154418945, 1.9583333730697631, 1.3333330154418945, 1.9500000476837158, 1.3333330154418945, 1.9500000476837158, 1.4166663885116577, 1.9500000476837158, 1.4166663885116577, 1.9583333730697631, 1.4166663885116577, 1.9500000476837158, 1.3333330154418945, 1.9500000476837158, 1.3333330154418945, 1.9416667222976684, 1.3333330154418945, 1.9416667222976684, 1.4166663885116577, 1.9416667222976684, 1.4166663885116577, 1.9500000476837158, 1.4166663885116577, 1.9416667222976684, 1.3333330154418945, 1.9416667222976684, 1.3333330154418945, 1.933333396911621, 1.3333330154418945, 1.933333396911621, 1.4166663885116577, 1.933333396911621, 1.4166663885116577, 1.9416667222976684, 1.4166663885116577, 1.933333396911621, 1.3333330154418945, 1.933333396911621, 1.3333330154418945, 1.9250000715255737, 1.3333330154418945, 1.9250000715255737, 1.4166663885116577, 1.9250000715255737, 1.4166663885116577, 1.933333396911621, 1.4166663885116577, 1.9250000715255737, 1.3333330154418945, 1.9250000715255737, 1.3333330154418945, 1.9166667461395263, 1.3333330154418945, 1.9166667461395263, 1.4166663885116577, 1.9166667461395263, 1.4166663885116577, 1.9250000715255737, 1.4166663885116577, 1.9166667461395263, 1.3333330154418945, 1.9166667461395263, 1.3333330154418945, 1.908333420753479, 1.3333330154418945, 1.908333420753479, 1.4166663885116577, 1.908333420753479, 1.4166663885116577, 1.9166667461395263, 1.4166663885116577, 1.908333420753479, 1.3333330154418945, 1.908333420753479, 1.3333330154418945, 1.9000000953674316, 1.3333330154418945, 1.9000000953674316, 1.4166663885116577, 1.9000000953674316, 1.4166663885116577, 1.908333420753479, 1.3333330154418945, 2, 1.2499996423721313, 2, 1.2499996423721313, 1.9916666746139526, 1.2499996423721313, 1.9916666746139526, 1.3333330154418945, 1.9916666746139526, 1.3333330154418945, 2, 1.3333330154418945, 1.9916666746139526, 1.2499996423721313, 1.9916666746139526, 1.2499996423721313, 1.9833333492279052, 1.2499996423721313, 1.9833333492279052, 1.3333330154418945, 1.9833333492279052, 1.3333330154418945, 1.9916666746139526, 1.3333330154418945, 1.9833333492279052, 1.2499996423721313, 1.9833333492279052, 1.2499996423721313, 1.975000023841858, 1.2499996423721313, 1.975000023841858, 1.3333330154418945, 1.975000023841858, 1.3333330154418945, 1.9833333492279052, 1.3333330154418945, 1.975000023841858, 1.2499996423721313, 1.975000023841858, 1.2499996423721313, 1.9666666984558105, 1.2499996423721313, 1.9666666984558105, 1.3333330154418945, 1.9666666984558105, 1.3333330154418945, 1.975000023841858, 1.3333330154418945, 1.9666666984558105, 1.2499996423721313, 1.9666666984558105, 1.2499996423721313, 1.9583333730697631, 1.2499996423721313, 1.9583333730697631, 1.3333330154418945, 1.9583333730697631, 1.3333330154418945, 1.9666666984558105, 1.3333330154418945, 1.9583333730697631, 1.2499996423721313, 1.9583333730697631, 1.2499996423721313, 1.9500000476837158, 1.2499996423721313, 1.9500000476837158, 1.3333330154418945, 1.9500000476837158, 1.3333330154418945, 1.9583333730697631, 1.3333330154418945, 1.9500000476837158, 1.2499996423721313, 1.9500000476837158, 1.2499996423721313, 1.9416667222976684, 1.2499996423721313, 1.9416667222976684, 1.3333330154418945, 1.9416667222976684, 1.3333330154418945, 1.9500000476837158, 1.3333330154418945, 1.9416667222976684, 1.2499996423721313, 1.9416667222976684, 1.2499996423721313, 1.933333396911621, 1.2499996423721313, 1.933333396911621, 1.3333330154418945, 1.933333396911621, 1.3333330154418945, 1.9416667222976684, 1.3333330154418945, 1.933333396911621, 1.2499996423721313, 1.933333396911621, 1.2499996423721313, 1.9250000715255737, 1.2499996423721313, 1.9250000715255737, 1.3333330154418945, 1.9250000715255737, 1.3333330154418945, 1.933333396911621, 1.3333330154418945, 1.9250000715255737, 1.2499996423721313, 1.9250000715255737, 1.2499996423721313, 1.9166667461395263, 1.2499996423721313, 1.9166667461395263, 1.3333330154418945, 1.9166667461395263, 1.3333330154418945, 1.9250000715255737, 1.3333330154418945, 1.9166667461395263, 1.2499996423721313, 1.9166667461395263, 1.2499996423721313, 1.908333420753479, 1.2499996423721313, 1.908333420753479, 1.3333330154418945, 1.908333420753479, 1.3333330154418945, 1.9166667461395263, 1.3333330154418945, 1.908333420753479, 1.2499996423721313, 1.908333420753479, 1.2499996423721313, 1.9000000953674316, 1.2499996423721313, 1.9000000953674316, 1.3333330154418945, 1.9000000953674316, 1.3333330154418945, 1.908333420753479, 1.2499996423721313, 2, 1.1666662693023681, 2, 1.1666662693023681, 1.9916666746139526, 1.1666662693023681, 1.9916666746139526, 1.2499996423721313, 1.9916666746139526, 1.2499996423721313, 2, 1.2499996423721313, 1.9916666746139526, 1.1666662693023681, 1.9916666746139526, 1.1666662693023681, 1.9833333492279052, 1.1666662693023681, 1.9833333492279052, 1.2499996423721313, 1.9833333492279052, 1.2499996423721313, 1.9916666746139526, 1.2499996423721313, 1.9833333492279052, 1.1666662693023681, 1.9833333492279052, 1.1666662693023681, 1.975000023841858, 1.1666662693023681, 1.975000023841858, 1.2499996423721313, 1.975000023841858, 1.2499996423721313, 1.9833333492279052, 1.2499996423721313, 1.975000023841858, 1.1666662693023681, 1.975000023841858, 1.1666662693023681, 1.9666666984558105, 1.1666662693023681, 1.9666666984558105, 1.2499996423721313, 1.9666666984558105, 1.2499996423721313, 1.975000023841858, 1.2499996423721313, 1.9666666984558105, 1.1666662693023681, 1.9666666984558105, 1.1666662693023681, 1.9583333730697631, 1.1666662693023681, 1.9583333730697631, 1.2499996423721313, 1.9583333730697631, 1.2499996423721313, 1.9666666984558105, 1.2499996423721313, 1.9583333730697631, 1.1666662693023681, 1.9583333730697631, 1.1666662693023681, 1.9500000476837158, 1.1666662693023681, 1.9500000476837158, 1.2499996423721313, 1.9500000476837158, 1.2499996423721313, 1.9583333730697631, 1.2499996423721313, 1.9500000476837158, 1.1666662693023681, 1.9500000476837158, 1.1666662693023681, 1.9416667222976684, 1.1666662693023681, 1.9416667222976684, 1.2499996423721313, 1.9416667222976684, 1.2499996423721313, 1.9500000476837158, 1.2499996423721313, 1.9416667222976684, 1.1666662693023681, 1.9416667222976684, 1.1666662693023681, 1.933333396911621, 1.1666662693023681, 1.933333396911621, 1.2499996423721313, 1.933333396911621, 1.2499996423721313, 1.9416667222976684, 1.2499996423721313, 1.933333396911621, 1.1666662693023681, 1.933333396911621, 1.1666662693023681, 1.9250000715255737, 1.1666662693023681, 1.9250000715255737, 1.2499996423721313, 1.9250000715255737, 1.2499996423721313, 1.933333396911621, 1.2499996423721313, 1.9250000715255737, 1.1666662693023681, 1.9250000715255737, 1.1666662693023681, 1.9166667461395263, 1.1666662693023681, 1.9166667461395263, 1.2499996423721313, 1.9166667461395263, 1.2499996423721313, 1.9250000715255737, 1.2499996423721313, 1.9166667461395263, 1.1666662693023681, 1.9166667461395263, 1.1666662693023681, 1.908333420753479, 1.1666662693023681, 1.908333420753479, 1.2499996423721313, 1.908333420753479, 1.2499996423721313, 1.9166667461395263, 1.2499996423721313, 1.908333420753479, 1.1666662693023681, 1.908333420753479, 1.1666662693023681, 1.9000000953674316, 1.1666662693023681, 1.9000000953674316, 1.2499996423721313, 1.9000000953674316, 1.2499996423721313, 1.908333420753479, 1.1666662693023681, 2, 1.083332896232605, 2, 1.083332896232605, 1.9916666746139526, 1.083332896232605, 1.9916666746139526, 1.1666662693023681, 1.9916666746139526, 1.1666662693023681, 2, 1.1666662693023681, 1.9916666746139526, 1.083332896232605, 1.9916666746139526, 1.083332896232605, 1.9833333492279052, 1.083332896232605, 1.9833333492279052, 1.1666662693023681, 1.9833333492279052, 1.1666662693023681, 1.9916666746139526, 1.1666662693023681, 1.9833333492279052, 1.083332896232605, 1.9833333492279052, 1.083332896232605, 1.975000023841858, 1.083332896232605, 1.975000023841858, 1.1666662693023681, 1.975000023841858, 1.1666662693023681, 1.9833333492279052, 1.1666662693023681, 1.975000023841858, 1.083332896232605, 1.975000023841858, 1.083332896232605, 1.9666666984558105, 1.083332896232605, 1.9666666984558105, 1.1666662693023681, 1.9666666984558105, 1.1666662693023681, 1.975000023841858, 1.1666662693023681, 1.9666666984558105, 1.083332896232605, 1.9666666984558105, 1.083332896232605, 1.9583333730697631, 1.083332896232605, 1.9583333730697631, 1.1666662693023681, 1.9583333730697631, 1.1666662693023681, 1.9666666984558105, 1.1666662693023681, 1.9583333730697631, 1.083332896232605, 1.9583333730697631, 1.083332896232605, 1.9500000476837158, 1.083332896232605, 1.9500000476837158, 1.1666662693023681, 1.9500000476837158, 1.1666662693023681, 1.9583333730697631, 1.1666662693023681, 1.9500000476837158, 1.083332896232605, 1.9500000476837158, 1.083332896232605, 1.9416667222976684, 1.083332896232605, 1.9416667222976684, 1.1666662693023681, 1.9416667222976684, 1.1666662693023681, 1.9500000476837158, 1.1666662693023681, 1.9416667222976684, 1.083332896232605, 1.9416667222976684, 1.083332896232605, 1.933333396911621, 1.083332896232605, 1.933333396911621, 1.1666662693023681, 1.933333396911621, 1.1666662693023681, 1.9416667222976684, 1.1666662693023681, 1.933333396911621, 1.083332896232605, 1.933333396911621, 1.083332896232605, 1.9250000715255737, 1.083332896232605, 1.9250000715255737, 1.1666662693023681, 1.9250000715255737, 1.1666662693023681, 1.933333396911621, 1.1666662693023681, 1.9250000715255737, 1.083332896232605, 1.9250000715255737, 1.083332896232605, 1.9166667461395263, 1.083332896232605, 1.9166667461395263, 1.1666662693023681, 1.9166667461395263, 1.1666662693023681, 1.9250000715255737, 1.1666662693023681, 1.9166667461395263, 1.083332896232605, 1.9166667461395263, 1.083332896232605, 1.908333420753479, 1.083332896232605, 1.908333420753479, 1.1666662693023681, 1.908333420753479, 1.1666662693023681, 1.9166667461395263, 1.1666662693023681, 1.908333420753479, 1.083332896232605, 1.908333420753479, 1.083332896232605, 1.9000000953674316, 1.083332896232605, 1.9000000953674316, 1.1666662693023681, 1.9000000953674316, 1.1666662693023681, 1.908333420753479, 1.083332896232605, 2, 0.9999995827674866, 2, 0.9999995827674866, 1.9916666746139526, 0.9999995827674866, 1.9916666746139526, 1.083332896232605, 1.9916666746139526, 1.083332896232605, 2, 1.083332896232605, 1.9916666746139526, 0.9999995827674866, 1.9916666746139526, 0.9999995827674866, 1.9833333492279052, 0.9999995827674866, 1.9833333492279052, 1.083332896232605, 1.9833333492279052, 1.083332896232605, 1.9916666746139526, 1.083332896232605, 1.9833333492279052, 0.9999995827674866, 1.9833333492279052, 0.9999995827674866, 1.975000023841858, 0.9999995827674866, 1.975000023841858, 1.083332896232605, 1.975000023841858, 1.083332896232605, 1.9833333492279052, 1.083332896232605, 1.975000023841858, 0.9999995827674866, 1.975000023841858, 0.9999995827674866, 1.9666666984558105, 0.9999995827674866, 1.9666666984558105, 1.083332896232605, 1.9666666984558105, 1.083332896232605, 1.975000023841858, 1.083332896232605, 1.9666666984558105, 0.9999995827674866, 1.9666666984558105, 0.9999995827674866, 1.9583333730697631, 0.9999995827674866, 1.9583333730697631, 1.083332896232605, 1.9583333730697631, 1.083332896232605, 1.9666666984558105, 1.083332896232605, 1.9583333730697631, 0.9999995827674866, 1.9583333730697631, 0.9999995827674866, 1.9500000476837158, 0.9999995827674866, 1.9500000476837158, 1.083332896232605, 1.9500000476837158, 1.083332896232605, 1.9583333730697631, 1.083332896232605, 1.9500000476837158, 0.9999995827674866, 1.9500000476837158, 0.9999995827674866, 1.9416667222976684, 0.9999995827674866, 1.9416667222976684, 1.083332896232605, 1.9416667222976684, 1.083332896232605, 1.9500000476837158, 1.083332896232605, 1.9416667222976684, 0.9999995827674866, 1.9416667222976684, 0.9999995827674866, 1.933333396911621, 0.9999995827674866, 1.933333396911621, 1.083332896232605, 1.933333396911621, 1.083332896232605, 1.9416667222976684, 1.083332896232605, 1.933333396911621, 0.9999995827674866, 1.933333396911621, 0.9999995827674866, 1.9250000715255737, 0.9999995827674866, 1.9250000715255737, 1.083332896232605, 1.9250000715255737, 1.083332896232605, 1.933333396911621, 1.083332896232605, 1.9250000715255737, 0.9999995827674866, 1.9250000715255737, 0.9999995827674866, 1.9166667461395263, 0.9999995827674866, 1.9166667461395263, 1.083332896232605, 1.9166667461395263, 1.083332896232605, 1.9250000715255737, 1.083332896232605, 1.9166667461395263, 0.9999995827674866, 1.9166667461395263, 0.9999995827674866, 1.908333420753479, 0.9999995827674866, 1.908333420753479, 1.083332896232605, 1.908333420753479, 1.083332896232605, 1.9166667461395263, 1.083332896232605, 1.908333420753479, 0.9999995827674866, 1.908333420753479, 0.9999995827674866, 1.9000000953674316, 0.9999995827674866, 1.9000000953674316, 1.083332896232605, 1.9000000953674316, 1.083332896232605, 1.908333420753479, 1, 2, 0.9166666865348816, 2, 0.9166666865348816, 1.9916666746139526, 0.9166666865348816, 1.9916666746139526, 1, 1.9916666746139526, 1, 2, 1, 1.9916666746139526, 0.9166666865348816, 1.9916666746139526, 0.9166666865348816, 1.9833333492279052, 0.9166666865348816, 1.9833333492279052, 1, 1.9833333492279052, 1, 1.9916666746139526, 1, 1.9833333492279052, 0.9166666865348816, 1.9833333492279052, 0.9166666865348816, 1.975000023841858, 0.9166666865348816, 1.975000023841858, 1, 1.975000023841858, 1, 1.9833333492279052, 1, 1.975000023841858, 0.9166666865348816, 1.975000023841858, 0.9166666865348816, 1.9666666984558105, 0.9166666865348816, 1.9666666984558105, 1, 1.9666666984558105, 1, 1.975000023841858, 1, 1.9666666984558105, 0.9166666865348816, 1.9666666984558105, 0.9166666865348816, 1.9583333730697631, 0.9166666865348816, 1.9583333730697631, 1, 1.9583333730697631, 1, 1.9666666984558105, 1, 1.9583333730697631, 0.9166666865348816, 1.9583333730697631, 0.9166666865348816, 1.9500000476837158, 0.9166666865348816, 1.9500000476837158, 1, 1.9500000476837158, 1, 1.9583333730697631, 1, 1.9500000476837158, 0.9166666865348816, 1.9500000476837158, 0.9166666865348816, 1.9416667222976684, 0.9166666865348816, 1.9416667222976684, 1, 1.9416667222976684, 1, 1.9500000476837158, 1, 1.9416667222976684, 0.9166666865348816, 1.9416667222976684, 0.9166666865348816, 1.933333396911621, 0.9166666865348816, 1.933333396911621, 1, 1.933333396911621, 1, 1.9416667222976684, 1, 1.933333396911621, 0.9166666865348816, 1.933333396911621, 0.9166666865348816, 1.9250000715255737, 0.9166666865348816, 1.9250000715255737, 1, 1.9250000715255737, 1, 1.933333396911621, 1, 1.9250000715255737, 0.9166666865348816, 1.9250000715255737, 0.9166666865348816, 1.9166667461395263, 0.9166666865348816, 1.9166667461395263, 1, 1.9166667461395263, 1, 1.9250000715255737, 1, 1.9166667461395263, 0.9166666865348816, 1.9166667461395263, 0.9166666865348816, 1.908333420753479, 0.9166666865348816, 1.908333420753479, 1, 1.908333420753479, 1, 1.9166667461395263, 1, 1.908333420753479, 0.9166666865348816, 1.908333420753479, 0.9166666865348816, 1.9000000953674316, 0.9166666865348816, 1.9000000953674316, 1, 1.9000000953674316, 1, 1.908333420753479, 0.9166666865348816, 2, 0.8333333730697632, 2, 0.8333333730697632, 1.9916666746139526, 0.8333333730697632, 1.9916666746139526, 0.9166666865348816, 1.9916666746139526, 0.9166666865348816, 2, 0.9166666865348816, 1.9916666746139526, 0.8333333730697632, 1.9916666746139526, 0.8333333730697632, 1.9833333492279052, 0.8333333730697632, 1.9833333492279052, 0.9166666865348816, 1.9833333492279052, 0.9166666865348816, 1.9916666746139526, 0.9166666865348816, 1.9833333492279052, 0.8333333730697632, 1.9833333492279052, 0.8333333730697632, 1.975000023841858, 0.8333333730697632, 1.975000023841858, 0.9166666865348816, 1.975000023841858, 0.9166666865348816, 1.9833333492279052, 0.9166666865348816, 1.975000023841858, 0.8333333730697632, 1.975000023841858, 0.8333333730697632, 1.9666666984558105, 0.8333333730697632, 1.9666666984558105, 0.9166666865348816, 1.9666666984558105, 0.9166666865348816, 1.975000023841858, 0.9166666865348816, 1.9666666984558105, 0.8333333730697632, 1.9666666984558105, 0.8333333730697632, 1.9583333730697631, 0.8333333730697632, 1.9583333730697631, 0.9166666865348816, 1.9583333730697631, 0.9166666865348816, 1.9666666984558105, 0.9166666865348816, 1.9583333730697631, 0.8333333730697632, 1.9583333730697631, 0.8333333730697632, 1.9500000476837158, 0.8333333730697632, 1.9500000476837158, 0.9166666865348816, 1.9500000476837158, 0.9166666865348816, 1.9583333730697631, 0.9166666865348816, 1.9500000476837158, 0.8333333730697632, 1.9500000476837158, 0.8333333730697632, 1.9416667222976684, 0.8333333730697632, 1.9416667222976684, 0.9166666865348816, 1.9416667222976684, 0.9166666865348816, 1.9500000476837158, 0.9166666865348816, 1.9416667222976684, 0.8333333730697632, 1.9416667222976684, 0.8333333730697632, 1.933333396911621, 0.8333333730697632, 1.933333396911621, 0.9166666865348816, 1.933333396911621, 0.9166666865348816, 1.9416667222976684, 0.9166666865348816, 1.933333396911621, 0.8333333730697632, 1.933333396911621, 0.8333333730697632, 1.9250000715255737, 0.8333333730697632, 1.9250000715255737, 0.9166666865348816, 1.9250000715255737, 0.9166666865348816, 1.933333396911621, 0.9166666865348816, 1.9250000715255737, 0.8333333730697632, 1.9250000715255737, 0.8333333730697632, 1.9166667461395263, 0.8333333730697632, 1.9166667461395263, 0.9166666865348816, 1.9166667461395263, 0.9166666865348816, 1.9250000715255737, 0.9166666865348816, 1.9166667461395263, 0.8333333730697632, 1.9166667461395263, 0.8333333730697632, 1.908333420753479, 0.8333333730697632, 1.908333420753479, 0.9166666865348816, 1.908333420753479, 0.9166666865348816, 1.9166667461395263, 0.9166666865348816, 1.908333420753479, 0.8333333730697632, 1.908333420753479, 0.8333333730697632, 1.9000000953674316, 0.8333333730697632, 1.9000000953674316, 0.9166666865348816, 1.9000000953674316, 0.9166666865348816, 1.908333420753479, 0.8333333730697632, 2, 0.7500000596046448, 2, 0.7500000596046448, 1.9916666746139526, 0.7500000596046448, 1.9916666746139526, 0.8333333730697632, 1.9916666746139526, 0.8333333730697632, 2, 0.8333333730697632, 1.9916666746139526, 0.7500000596046448, 1.9916666746139526, 0.7500000596046448, 1.9833333492279052, 0.7500000596046448, 1.9833333492279052, 0.8333333730697632, 1.9833333492279052, 0.8333333730697632, 1.9916666746139526, 0.8333333730697632, 1.9833333492279052, 0.7500000596046448, 1.9833333492279052, 0.7500000596046448, 1.975000023841858, 0.7500000596046448, 1.975000023841858, 0.8333333730697632, 1.975000023841858, 0.8333333730697632, 1.9833333492279052, 0.8333333730697632, 1.975000023841858, 0.7500000596046448, 1.975000023841858, 0.7500000596046448, 1.9666666984558105, 0.7500000596046448, 1.9666666984558105, 0.8333333730697632, 1.9666666984558105, 0.8333333730697632, 1.975000023841858, 0.8333333730697632, 1.9666666984558105, 0.7500000596046448, 1.9666666984558105, 0.7500000596046448, 1.9583333730697631, 0.7500000596046448, 1.9583333730697631, 0.8333333730697632, 1.9583333730697631, 0.8333333730697632, 1.9666666984558105, 0.8333333730697632, 1.9583333730697631, 0.7500000596046448, 1.9583333730697631, 0.7500000596046448, 1.9500000476837158, 0.7500000596046448, 1.9500000476837158, 0.8333333730697632, 1.9500000476837158, 0.8333333730697632, 1.9583333730697631, 0.8333333730697632, 1.9500000476837158, 0.7500000596046448, 1.9500000476837158, 0.7500000596046448, 1.9416667222976684, 0.7500000596046448, 1.9416667222976684, 0.8333333730697632, 1.9416667222976684, 0.8333333730697632, 1.9500000476837158, 0.8333333730697632, 1.9416667222976684, 0.7500000596046448, 1.9416667222976684, 0.7500000596046448, 1.933333396911621, 0.7500000596046448, 1.933333396911621, 0.8333333730697632, 1.933333396911621, 0.8333333730697632, 1.9416667222976684, 0.8333333730697632, 1.933333396911621, 0.7500000596046448, 1.933333396911621, 0.7500000596046448, 1.9250000715255737, 0.7500000596046448, 1.9250000715255737, 0.8333333730697632, 1.9250000715255737, 0.8333333730697632, 1.933333396911621, 0.8333333730697632, 1.9250000715255737, 0.7500000596046448, 1.9250000715255737, 0.7500000596046448, 1.9166667461395263, 0.7500000596046448, 1.9166667461395263, 0.8333333730697632, 1.9166667461395263, 0.8333333730697632, 1.9250000715255737, 0.8333333730697632, 1.9166667461395263, 0.7500000596046448, 1.9166667461395263, 0.7500000596046448, 1.908333420753479, 0.7500000596046448, 1.908333420753479, 0.8333333730697632, 1.908333420753479, 0.8333333730697632, 1.9166667461395263, 0.8333333730697632, 1.908333420753479, 0.7500000596046448, 1.908333420753479, 0.7500000596046448, 1.9000000953674316, 0.7500000596046448, 1.9000000953674316, 0.8333333730697632, 1.9000000953674316, 0.8333333730697632, 1.908333420753479, 0.7500000596046448, 2, 0.6666667461395264, 2, 0.6666667461395264, 1.9916666746139526, 0.6666667461395264, 1.9916666746139526, 0.7500000596046448, 1.9916666746139526, 0.7500000596046448, 2, 0.7500000596046448, 1.9916666746139526, 0.6666667461395264, 1.9916666746139526, 0.6666667461395264, 1.9833333492279052, 0.6666667461395264, 1.9833333492279052, 0.7500000596046448, 1.9833333492279052, 0.7500000596046448, 1.9916666746139526, 0.7500000596046448, 1.9833333492279052, 0.6666667461395264, 1.9833333492279052, 0.6666667461395264, 1.975000023841858, 0.6666667461395264, 1.975000023841858, 0.7500000596046448, 1.975000023841858, 0.7500000596046448, 1.9833333492279052, 0.7500000596046448, 1.975000023841858, 0.6666667461395264, 1.975000023841858, 0.6666667461395264, 1.9666666984558105, 0.6666667461395264, 1.9666666984558105, 0.7500000596046448, 1.9666666984558105, 0.7500000596046448, 1.975000023841858, 0.7500000596046448, 1.9666666984558105, 0.6666667461395264, 1.9666666984558105, 0.6666667461395264, 1.9583333730697631, 0.6666667461395264, 1.9583333730697631, 0.7500000596046448, 1.9583333730697631, 0.7500000596046448, 1.9666666984558105, 0.7500000596046448, 1.9583333730697631, 0.6666667461395264, 1.9583333730697631, 0.6666667461395264, 1.9500000476837158, 0.6666667461395264, 1.9500000476837158, 0.7500000596046448, 1.9500000476837158, 0.7500000596046448, 1.9583333730697631, 0.7500000596046448, 1.9500000476837158, 0.6666667461395264, 1.9500000476837158, 0.6666667461395264, 1.9416667222976684, 0.6666667461395264, 1.9416667222976684, 0.7500000596046448, 1.9416667222976684, 0.7500000596046448, 1.9500000476837158, 0.7500000596046448, 1.9416667222976684, 0.6666667461395264, 1.9416667222976684, 0.6666667461395264, 1.933333396911621, 0.6666667461395264, 1.933333396911621, 0.7500000596046448, 1.933333396911621, 0.7500000596046448, 1.9416667222976684, 0.7500000596046448, 1.933333396911621, 0.6666667461395264, 1.933333396911621, 0.6666667461395264, 1.9250000715255737, 0.6666667461395264, 1.9250000715255737, 0.7500000596046448, 1.9250000715255737, 0.7500000596046448, 1.933333396911621, 0.7500000596046448, 1.9250000715255737, 0.6666667461395264, 1.9250000715255737, 0.6666667461395264, 1.9166667461395263, 0.6666667461395264, 1.9166667461395263, 0.7500000596046448, 1.9166667461395263, 0.7500000596046448, 1.9250000715255737, 0.7500000596046448, 1.9166667461395263, 0.6666667461395264, 1.9166667461395263, 0.6666667461395264, 1.908333420753479, 0.6666667461395264, 1.908333420753479, 0.7500000596046448, 1.908333420753479, 0.7500000596046448, 1.9166667461395263, 0.7500000596046448, 1.908333420753479, 0.6666667461395264, 1.908333420753479, 0.6666667461395264, 1.9000000953674316, 0.6666667461395264, 1.9000000953674316, 0.7500000596046448, 1.9000000953674316, 0.7500000596046448, 1.908333420753479, 0.6666667461395264, 2, 0.583333432674408, 2, 0.583333432674408, 1.9916666746139526, 0.583333432674408, 1.9916666746139526, 0.6666667461395264, 1.9916666746139526, 0.6666667461395264, 2, 0.6666667461395264, 1.9916666746139526, 0.583333432674408, 1.9916666746139526, 0.583333432674408, 1.9833333492279052, 0.583333432674408, 1.9833333492279052, 0.6666667461395264, 1.9833333492279052, 0.6666667461395264, 1.9916666746139526, 0.6666667461395264, 1.9833333492279052, 0.583333432674408, 1.9833333492279052, 0.583333432674408, 1.975000023841858, 0.583333432674408, 1.975000023841858, 0.6666667461395264, 1.975000023841858, 0.6666667461395264, 1.9833333492279052, 0.6666667461395264, 1.975000023841858, 0.583333432674408, 1.975000023841858, 0.583333432674408, 1.9666666984558105, 0.583333432674408, 1.9666666984558105, 0.6666667461395264, 1.9666666984558105, 0.6666667461395264, 1.975000023841858, 0.6666667461395264, 1.9666666984558105, 0.583333432674408, 1.9666666984558105, 0.583333432674408, 1.9583333730697631, 0.583333432674408, 1.9583333730697631, 0.6666667461395264, 1.9583333730697631, 0.6666667461395264, 1.9666666984558105, 0.6666667461395264, 1.9583333730697631, 0.583333432674408, 1.9583333730697631, 0.583333432674408, 1.9500000476837158, 0.583333432674408, 1.9500000476837158, 0.6666667461395264, 1.9500000476837158, 0.6666667461395264, 1.9583333730697631, 0.6666667461395264, 1.9500000476837158, 0.583333432674408, 1.9500000476837158, 0.583333432674408, 1.9416667222976684, 0.583333432674408, 1.9416667222976684, 0.6666667461395264, 1.9416667222976684, 0.6666667461395264, 1.9500000476837158, 0.6666667461395264, 1.9416667222976684, 0.583333432674408, 1.9416667222976684, 0.583333432674408, 1.933333396911621, 0.583333432674408, 1.933333396911621, 0.6666667461395264, 1.933333396911621, 0.6666667461395264, 1.9416667222976684, 0.6666667461395264, 1.933333396911621, 0.583333432674408, 1.933333396911621, 0.583333432674408, 1.9250000715255737, 0.583333432674408, 1.9250000715255737, 0.6666667461395264, 1.9250000715255737, 0.6666667461395264, 1.933333396911621, 0.6666667461395264, 1.9250000715255737, 0.583333432674408, 1.9250000715255737, 0.583333432674408, 1.9166667461395263, 0.583333432674408, 1.9166667461395263, 0.6666667461395264, 1.9166667461395263, 0.6666667461395264, 1.9250000715255737, 0.6666667461395264, 1.9166667461395263, 0.583333432674408, 1.9166667461395263, 0.583333432674408, 1.908333420753479, 0.583333432674408, 1.908333420753479, 0.6666667461395264, 1.908333420753479, 0.6666667461395264, 1.9166667461395263, 0.6666667461395264, 1.908333420753479, 0.583333432674408, 1.908333420753479, 0.583333432674408, 1.9000000953674316, 0.583333432674408, 1.9000000953674316, 0.6666667461395264, 1.9000000953674316, 0.6666667461395264, 1.908333420753479, 0.583333432674408, 2, 0.5000001192092895, 2, 0.5000001192092895, 1.9916666746139526, 0.5000001192092895, 1.9916666746139526, 0.583333432674408, 1.9916666746139526, 0.583333432674408, 2, 0.583333432674408, 1.9916666746139526, 0.5000001192092895, 1.9916666746139526, 0.5000001192092895, 1.9833333492279052, 0.5000001192092895, 1.9833333492279052, 0.583333432674408, 1.9833333492279052, 0.583333432674408, 1.9916666746139526, 0.583333432674408, 1.9833333492279052, 0.5000001192092895, 1.9833333492279052, 0.5000001192092895, 1.975000023841858, 0.5000001192092895, 1.975000023841858, 0.583333432674408, 1.975000023841858, 0.583333432674408, 1.9833333492279052, 0.583333432674408, 1.975000023841858, 0.5000001192092895, 1.975000023841858, 0.5000001192092895, 1.9666666984558105, 0.5000001192092895, 1.9666666984558105, 0.583333432674408, 1.9666666984558105, 0.583333432674408, 1.975000023841858, 0.583333432674408, 1.9666666984558105, 0.5000001192092895, 1.9666666984558105, 0.5000001192092895, 1.9583333730697631, 0.5000001192092895, 1.9583333730697631, 0.583333432674408, 1.9583333730697631, 0.583333432674408, 1.9666666984558105, 0.583333432674408, 1.9583333730697631, 0.5000001192092895, 1.9583333730697631, 0.5000001192092895, 1.9500000476837158, 0.5000001192092895, 1.9500000476837158, 0.583333432674408, 1.9500000476837158, 0.583333432674408, 1.9583333730697631, 0.583333432674408, 1.9500000476837158, 0.5000001192092895, 1.9500000476837158, 0.5000001192092895, 1.9416667222976684, 0.5000001192092895, 1.9416667222976684, 0.583333432674408, 1.9416667222976684, 0.583333432674408, 1.9500000476837158, 0.583333432674408, 1.9416667222976684, 0.5000001192092895, 1.9416667222976684, 0.5000001192092895, 1.933333396911621, 0.5000001192092895, 1.933333396911621, 0.583333432674408, 1.933333396911621, 0.583333432674408, 1.9416667222976684, 0.583333432674408, 1.933333396911621, 0.5000001192092895, 1.933333396911621, 0.5000001192092895, 1.9250000715255737, 0.5000001192092895, 1.9250000715255737, 0.583333432674408, 1.9250000715255737, 0.583333432674408, 1.933333396911621, 0.583333432674408, 1.9250000715255737, 0.5000001192092895, 1.9250000715255737, 0.5000001192092895, 1.9166667461395263, 0.5000001192092895, 1.9166667461395263, 0.583333432674408, 1.9166667461395263, 0.583333432674408, 1.9250000715255737, 0.583333432674408, 1.9166667461395263, 0.5000001192092895, 1.9166667461395263, 0.5000001192092895, 1.908333420753479, 0.5000001192092895, 1.908333420753479, 0.583333432674408, 1.908333420753479, 0.583333432674408, 1.9166667461395263, 0.583333432674408, 1.908333420753479, 0.5000001192092895, 1.908333420753479, 0.5000001192092895, 1.9000000953674316, 0.5000001192092895, 1.9000000953674316, 0.583333432674408, 1.9000000953674316, 0.583333432674408, 1.908333420753479, 0.5000001192092895, 2, 0.41666677594184875, 2, 0.41666677594184875, 1.9916666746139526, 0.41666677594184875, 1.9916666746139526, 0.5000001192092895, 1.9916666746139526, 0.5000001192092895, 2, 0.5000001192092895, 1.9916666746139526, 0.41666677594184875, 1.9916666746139526, 0.41666677594184875, 1.9833333492279052, 0.41666677594184875, 1.9833333492279052, 0.5000001192092895, 1.9833333492279052, 0.5000001192092895, 1.9916666746139526, 0.5000001192092895, 1.9833333492279052, 0.41666677594184875, 1.9833333492279052, 0.41666677594184875, 1.975000023841858, 0.41666677594184875, 1.975000023841858, 0.5000001192092895, 1.975000023841858, 0.5000001192092895, 1.9833333492279052, 0.5000001192092895, 1.975000023841858, 0.41666677594184875, 1.975000023841858, 0.41666677594184875, 1.9666666984558105, 0.41666677594184875, 1.9666666984558105, 0.5000001192092895, 1.9666666984558105, 0.5000001192092895, 1.975000023841858, 0.5000001192092895, 1.9666666984558105, 0.41666677594184875, 1.9666666984558105, 0.41666677594184875, 1.9583333730697631, 0.41666677594184875, 1.9583333730697631, 0.5000001192092895, 1.9583333730697631, 0.5000001192092895, 1.9666666984558105, 0.5000001192092895, 1.9583333730697631, 0.41666677594184875, 1.9583333730697631, 0.41666677594184875, 1.9500000476837158, 0.41666677594184875, 1.9500000476837158, 0.5000001192092895, 1.9500000476837158, 0.5000001192092895, 1.9583333730697631, 0.5000001192092895, 1.9500000476837158, 0.41666677594184875, 1.9500000476837158, 0.41666677594184875, 1.9416667222976684, 0.41666677594184875, 1.9416667222976684, 0.5000001192092895, 1.9416667222976684, 0.5000001192092895, 1.9500000476837158, 0.5000001192092895, 1.9416667222976684, 0.41666677594184875, 1.9416667222976684, 0.41666677594184875, 1.933333396911621, 0.41666677594184875, 1.933333396911621, 0.5000001192092895, 1.933333396911621, 0.5000001192092895, 1.9416667222976684, 0.5000001192092895, 1.933333396911621, 0.41666677594184875, 1.933333396911621, 0.41666677594184875, 1.9250000715255737, 0.41666677594184875, 1.9250000715255737, 0.5000001192092895, 1.9250000715255737, 0.5000001192092895, 1.933333396911621, 0.5000001192092895, 1.9250000715255737, 0.41666677594184875, 1.9250000715255737, 0.41666677594184875, 1.9166667461395263, 0.41666677594184875, 1.9166667461395263, 0.5000001192092895, 1.9166667461395263, 0.5000001192092895, 1.9250000715255737, 0.5000001192092895, 1.9166667461395263, 0.41666677594184875, 1.9166667461395263, 0.41666677594184875, 1.908333420753479, 0.41666677594184875, 1.908333420753479, 0.5000001192092895, 1.908333420753479, 0.5000001192092895, 1.9166667461395263, 0.5000001192092895, 1.908333420753479, 0.41666677594184875, 1.908333420753479, 0.41666677594184875, 1.9000000953674316, 0.41666677594184875, 1.9000000953674316, 0.5000001192092895, 1.9000000953674316, 0.5000001192092895, 1.908333420753479, 0.41666677594184875, 2, 0.33333343267440796, 2, 0.33333343267440796, 1.9916666746139526, 0.33333343267440796, 1.9916666746139526, 0.41666677594184875, 1.9916666746139526, 0.41666677594184875, 2, 0.41666677594184875, 1.9916666746139526, 0.33333343267440796, 1.9916666746139526, 0.33333343267440796, 1.9833333492279052, 0.33333343267440796, 1.9833333492279052, 0.41666677594184875, 1.9833333492279052, 0.41666677594184875, 1.9916666746139526, 0.41666677594184875, 1.9833333492279052, 0.33333343267440796, 1.9833333492279052, 0.33333343267440796, 1.975000023841858, 0.33333343267440796, 1.975000023841858, 0.41666677594184875, 1.975000023841858, 0.41666677594184875, 1.9833333492279052, 0.41666677594184875, 1.975000023841858, 0.33333343267440796, 1.975000023841858, 0.33333343267440796, 1.9666666984558105, 0.33333343267440796, 1.9666666984558105, 0.41666677594184875, 1.9666666984558105, 0.41666677594184875, 1.975000023841858, 0.41666677594184875, 1.9666666984558105, 0.33333343267440796, 1.9666666984558105, 0.33333343267440796, 1.9583333730697631, 0.33333343267440796, 1.9583333730697631, 0.41666677594184875, 1.9583333730697631, 0.41666677594184875, 1.9666666984558105, 0.41666677594184875, 1.9583333730697631, 0.33333343267440796, 1.9583333730697631, 0.33333343267440796, 1.9500000476837158, 0.33333343267440796, 1.9500000476837158, 0.41666677594184875, 1.9500000476837158, 0.41666677594184875, 1.9583333730697631, 0.41666677594184875, 1.9500000476837158, 0.33333343267440796, 1.9500000476837158, 0.33333343267440796, 1.9416667222976684, 0.33333343267440796, 1.9416667222976684, 0.41666677594184875, 1.9416667222976684, 0.41666677594184875, 1.9500000476837158, 0.41666677594184875, 1.9416667222976684, 0.33333343267440796, 1.9416667222976684, 0.33333343267440796, 1.933333396911621, 0.33333343267440796, 1.933333396911621, 0.41666677594184875, 1.933333396911621, 0.41666677594184875, 1.9416667222976684, 0.41666677594184875, 1.933333396911621, 0.33333343267440796, 1.933333396911621, 0.33333343267440796, 1.9250000715255737, 0.33333343267440796, 1.9250000715255737, 0.41666677594184875, 1.9250000715255737, 0.41666677594184875, 1.933333396911621, 0.41666677594184875, 1.9250000715255737, 0.33333343267440796, 1.9250000715255737, 0.33333343267440796, 1.9166667461395263, 0.33333343267440796, 1.9166667461395263, 0.41666677594184875, 1.9166667461395263, 0.41666677594184875, 1.9250000715255737, 0.41666677594184875, 1.9166667461395263, 0.33333343267440796, 1.9166667461395263, 0.33333343267440796, 1.908333420753479, 0.33333343267440796, 1.908333420753479, 0.41666677594184875, 1.908333420753479, 0.41666677594184875, 1.9166667461395263, 0.41666677594184875, 1.908333420753479, 0.33333343267440796, 1.908333420753479, 0.33333343267440796, 1.9000000953674316, 0.33333343267440796, 1.9000000953674316, 0.41666677594184875, 1.9000000953674316, 0.41666677594184875, 1.908333420753479, 0.33333343267440796, 2, 0.25000008940696716, 2, 0.25000008940696716, 1.9916666746139526, 0.25000008940696716, 1.9916666746139526, 0.33333343267440796, 1.9916666746139526, 0.33333343267440796, 2, 0.33333343267440796, 1.9916666746139526, 0.25000008940696716, 1.9916666746139526, 0.25000008940696716, 1.9833333492279052, 0.25000008940696716, 1.9833333492279052, 0.33333343267440796, 1.9833333492279052, 0.33333343267440796, 1.9916666746139526, 0.33333343267440796, 1.9833333492279052, 0.25000008940696716, 1.9833333492279052, 0.25000008940696716, 1.975000023841858, 0.25000008940696716, 1.975000023841858, 0.33333343267440796, 1.975000023841858, 0.33333343267440796, 1.9833333492279052, 0.33333343267440796, 1.975000023841858, 0.25000008940696716, 1.975000023841858, 0.25000008940696716, 1.9666666984558105, 0.25000008940696716, 1.9666666984558105, 0.33333343267440796, 1.9666666984558105, 0.33333343267440796, 1.975000023841858, 0.33333343267440796, 1.9666666984558105, 0.25000008940696716, 1.9666666984558105, 0.25000008940696716, 1.9583333730697631, 0.25000008940696716, 1.9583333730697631, 0.33333343267440796, 1.9583333730697631, 0.33333343267440796, 1.9666666984558105, 0.33333343267440796, 1.9583333730697631, 0.25000008940696716, 1.9583333730697631, 0.25000008940696716, 1.9500000476837158, 0.25000008940696716, 1.9500000476837158, 0.33333343267440796, 1.9500000476837158, 0.33333343267440796, 1.9583333730697631, 0.33333343267440796, 1.9500000476837158, 0.25000008940696716, 1.9500000476837158, 0.25000008940696716, 1.9416667222976684, 0.25000008940696716, 1.9416667222976684, 0.33333343267440796, 1.9416667222976684, 0.33333343267440796, 1.9500000476837158, 0.33333343267440796, 1.9416667222976684, 0.25000008940696716, 1.9416667222976684, 0.25000008940696716, 1.933333396911621, 0.25000008940696716, 1.933333396911621, 0.33333343267440796, 1.933333396911621, 0.33333343267440796, 1.9416667222976684, 0.33333343267440796, 1.933333396911621, 0.25000008940696716, 1.933333396911621, 0.25000008940696716, 1.9250000715255737, 0.25000008940696716, 1.9250000715255737, 0.33333343267440796, 1.9250000715255737, 0.33333343267440796, 1.933333396911621, 0.33333343267440796, 1.9250000715255737, 0.25000008940696716, 1.9250000715255737, 0.25000008940696716, 1.9166667461395263, 0.25000008940696716, 1.9166667461395263, 0.33333343267440796, 1.9166667461395263, 0.33333343267440796, 1.9250000715255737, 0.33333343267440796, 1.9166667461395263, 0.25000008940696716, 1.9166667461395263, 0.25000008940696716, 1.908333420753479, 0.25000008940696716, 1.908333420753479, 0.33333343267440796, 1.908333420753479, 0.33333343267440796, 1.9166667461395263, 0.33333343267440796, 1.908333420753479, 0.25000008940696716, 1.908333420753479, 0.25000008940696716, 1.9000000953674316, 0.25000008940696716, 1.9000000953674316, 0.33333343267440796, 1.9000000953674316, 0.33333343267440796, 1.908333420753479, 0.25000008940696716, 2, 0.16666674613952637, 2, 0.16666674613952637, 1.9916666746139526, 0.16666674613952637, 1.9916666746139526, 0.25000008940696716, 1.9916666746139526, 0.25000008940696716, 2, 0.25000008940696716, 1.9916666746139526, 0.16666674613952637, 1.9916666746139526, 0.16666674613952637, 1.9833333492279052, 0.16666674613952637, 1.9833333492279052, 0.25000008940696716, 1.9833333492279052, 0.25000008940696716, 1.9916666746139526, 0.25000008940696716, 1.9833333492279052, 0.16666674613952637, 1.9833333492279052, 0.16666674613952637, 1.975000023841858, 0.16666674613952637, 1.975000023841858, 0.25000008940696716, 1.975000023841858, 0.25000008940696716, 1.9833333492279052, 0.25000008940696716, 1.975000023841858, 0.16666674613952637, 1.975000023841858, 0.16666674613952637, 1.9666666984558105, 0.16666674613952637, 1.9666666984558105, 0.25000008940696716, 1.9666666984558105, 0.25000008940696716, 1.975000023841858, 0.25000008940696716, 1.9666666984558105, 0.16666674613952637, 1.9666666984558105, 0.16666674613952637, 1.9583333730697631, 0.16666674613952637, 1.9583333730697631, 0.25000008940696716, 1.9583333730697631, 0.25000008940696716, 1.9666666984558105, 0.25000008940696716, 1.9583333730697631, 0.16666674613952637, 1.9583333730697631, 0.16666674613952637, 1.9500000476837158, 0.16666674613952637, 1.9500000476837158, 0.25000008940696716, 1.9500000476837158, 0.25000008940696716, 1.9583333730697631, 0.25000008940696716, 1.9500000476837158, 0.16666674613952637, 1.9500000476837158, 0.16666674613952637, 1.9416667222976684, 0.16666674613952637, 1.9416667222976684, 0.25000008940696716, 1.9416667222976684, 0.25000008940696716, 1.9500000476837158, 0.25000008940696716, 1.9416667222976684, 0.16666674613952637, 1.9416667222976684, 0.16666674613952637, 1.933333396911621, 0.16666674613952637, 1.933333396911621, 0.25000008940696716, 1.933333396911621, 0.25000008940696716, 1.9416667222976684, 0.25000008940696716, 1.933333396911621, 0.16666674613952637, 1.933333396911621, 0.16666674613952637, 1.9250000715255737, 0.16666674613952637, 1.9250000715255737, 0.25000008940696716, 1.9250000715255737, 0.25000008940696716, 1.933333396911621, 0.25000008940696716, 1.9250000715255737, 0.16666674613952637, 1.9250000715255737, 0.16666674613952637, 1.9166667461395263, 0.16666674613952637, 1.9166667461395263, 0.25000008940696716, 1.9166667461395263, 0.25000008940696716, 1.9250000715255737, 0.25000008940696716, 1.9166667461395263, 0.16666674613952637, 1.9166667461395263, 0.16666674613952637, 1.908333420753479, 0.16666674613952637, 1.908333420753479, 0.25000008940696716, 1.908333420753479, 0.25000008940696716, 1.9166667461395263, 0.25000008940696716, 1.908333420753479, 0.16666674613952637, 1.908333420753479, 0.16666674613952637, 1.9000000953674316, 0.16666674613952637, 1.9000000953674316, 0.25000008940696716, 1.9000000953674316, 0.25000008940696716, 1.908333420753479, 0.16666674613952637, 2, 0.08333341032266617, 2, 0.08333341032266617, 1.9916666746139526, 0.08333341032266617, 1.9916666746139526, 0.16666674613952637, 1.9916666746139526, 0.16666674613952637, 2, 0.16666674613952637, 1.9916666746139526, 0.08333341032266617, 1.9916666746139526, 0.08333341032266617, 1.9833333492279052, 0.08333341032266617, 1.9833333492279052, 0.16666674613952637, 1.9833333492279052, 0.16666674613952637, 1.9916666746139526, 0.16666674613952637, 1.9833333492279052, 0.08333341032266617, 1.9833333492279052, 0.08333341032266617, 1.975000023841858, 0.08333341032266617, 1.975000023841858, 0.16666674613952637, 1.975000023841858, 0.16666674613952637, 1.9833333492279052, 0.16666674613952637, 1.975000023841858, 0.08333341032266617, 1.975000023841858, 0.08333341032266617, 1.9666666984558105, 0.08333341032266617, 1.9666666984558105, 0.16666674613952637, 1.9666666984558105, 0.16666674613952637, 1.975000023841858, 0.16666674613952637, 1.9666666984558105, 0.08333341032266617, 1.9666666984558105, 0.08333341032266617, 1.9583333730697631, 0.08333341032266617, 1.9583333730697631, 0.16666674613952637, 1.9583333730697631, 0.16666674613952637, 1.9666666984558105, 0.16666674613952637, 1.9583333730697631, 0.08333341032266617, 1.9583333730697631, 0.08333341032266617, 1.9500000476837158, 0.08333341032266617, 1.9500000476837158, 0.16666674613952637, 1.9500000476837158, 0.16666674613952637, 1.9583333730697631, 0.16666674613952637, 1.9500000476837158, 0.08333341032266617, 1.9500000476837158, 0.08333341032266617, 1.9416667222976684, 0.08333341032266617, 1.9416667222976684, 0.16666674613952637, 1.9416667222976684, 0.16666674613952637, 1.9500000476837158, 0.16666674613952637, 1.9416667222976684, 0.08333341032266617, 1.9416667222976684, 0.08333341032266617, 1.933333396911621, 0.08333341032266617, 1.933333396911621, 0.16666674613952637, 1.933333396911621, 0.16666674613952637, 1.9416667222976684, 0.16666674613952637, 1.933333396911621, 0.08333341032266617, 1.933333396911621, 0.08333341032266617, 1.9250000715255737, 0.08333341032266617, 1.9250000715255737, 0.16666674613952637, 1.9250000715255737, 0.16666674613952637, 1.933333396911621, 0.16666674613952637, 1.9250000715255737, 0.08333341032266617, 1.9250000715255737, 0.08333341032266617, 1.9166667461395263, 0.08333341032266617, 1.9166667461395263, 0.16666674613952637, 1.9166667461395263, 0.16666674613952637, 1.9250000715255737, 0.16666674613952637, 1.9166667461395263, 0.08333341032266617, 1.9166667461395263, 0.08333341032266617, 1.908333420753479, 0.08333341032266617, 1.908333420753479, 0.16666674613952637, 1.908333420753479, 0.16666674613952637, 1.9166667461395263, 0.16666674613952637, 1.908333420753479, 0.08333341032266617, 1.908333420753479, 0.08333341032266617, 1.9000000953674316, 0.08333341032266617, 1.9000000953674316, 0.16666674613952637, 1.9000000953674316, 0.16666674613952637, 1.908333420753479, 0.08333341032266617, 2, 7.450580596923828e-8, 2, 7.450580596923828e-8, 1.9916666746139526, 7.450580596923828e-8, 1.9916666746139526, 0.08333341032266617, 1.9916666746139526, 0.08333341032266617, 2, 0.08333341032266617, 1.9916666746139526, 7.450580596923828e-8, 1.9916666746139526, 7.450580596923828e-8, 1.9833333492279052, 7.450580596923828e-8, 1.9833333492279052, 0.08333341032266617, 1.9833333492279052, 0.08333341032266617, 1.9916666746139526, 0.08333341032266617, 1.9833333492279052, 7.450580596923828e-8, 1.9833333492279052, 7.450580596923828e-8, 1.975000023841858, 7.450580596923828e-8, 1.975000023841858, 0.08333341032266617, 1.975000023841858, 0.08333341032266617, 1.9833333492279052, 0.08333341032266617, 1.975000023841858, 7.450580596923828e-8, 1.975000023841858, 7.450580596923828e-8, 1.9666666984558105, 7.450580596923828e-8, 1.9666666984558105, 0.08333341032266617, 1.9666666984558105, 0.08333341032266617, 1.975000023841858, 0.08333341032266617, 1.9666666984558105, 7.450580596923828e-8, 1.9666666984558105, 7.450580596923828e-8, 1.9583333730697631, 7.450580596923828e-8, 1.9583333730697631, 0.08333341032266617, 1.9583333730697631, 0.08333341032266617, 1.9666666984558105, 0.08333341032266617, 1.9583333730697631, 7.450580596923828e-8, 1.9583333730697631, 7.450580596923828e-8, 1.9500000476837158, 7.450580596923828e-8, 1.9500000476837158, 0.08333341032266617, 1.9500000476837158, 0.08333341032266617, 1.9583333730697631, 0.08333341032266617, 1.9500000476837158, 7.450580596923828e-8, 1.9500000476837158, 7.450580596923828e-8, 1.9416667222976684, 7.450580596923828e-8, 1.9416667222976684, 0.08333341032266617, 1.9416667222976684, 0.08333341032266617, 1.9500000476837158, 0.08333341032266617, 1.9416667222976684, 7.450580596923828e-8, 1.9416667222976684, 7.450580596923828e-8, 1.933333396911621, 7.450580596923828e-8, 1.933333396911621, 0.08333341032266617, 1.933333396911621, 0.08333341032266617, 1.9416667222976684, 0.08333341032266617, 1.933333396911621, 7.450580596923828e-8, 1.933333396911621, 7.450580596923828e-8, 1.9250000715255737, 7.450580596923828e-8, 1.9250000715255737, 0.08333341032266617, 1.9250000715255737, 0.08333341032266617, 1.933333396911621, 0.08333341032266617, 1.9250000715255737, 7.450580596923828e-8, 1.9250000715255737, 7.450580596923828e-8, 1.9166667461395263, 7.450580596923828e-8, 1.9166667461395263, 0.08333341032266617, 1.9166667461395263, 0.08333341032266617, 1.9250000715255737, 0.08333341032266617, 1.9166667461395263, 7.450580596923828e-8, 1.9166667461395263, 7.450580596923828e-8, 1.908333420753479, 7.450580596923828e-8, 1.908333420753479, 0.08333341032266617, 1.908333420753479, 0.08333341032266617, 1.9166667461395263, 0.08333341032266617, 1.908333420753479, 7.450580596923828e-8, 1.908333420753479, 7.450580596923828e-8, 1.9000000953674316, 7.450580596923828e-8, 1.9000000953674316, 0.08333341032266617, 1.9000000953674316, 0.08333341032266617, 1.908333420753479, 2, 1.899999976158142, 1.9166666269302368, 1.899999976158142, 1.9166666269302368, 1.8249999284744262, 1.9166666269302368, 1.8249999284744262, 2, 1.8249999284744262, 2, 1.899999976158142, 2, 1.8249999284744262, 1.9166666269302368, 1.8249999284744262, 1.9166666269302368, 1.7499998807907104, 1.9166666269302368, 1.7499998807907104, 2, 1.7499998807907104, 2, 1.8249999284744262, 2, 1.7499998807907104, 1.9166666269302368, 1.7499998807907104, 1.9166666269302368, 1.6749998331069946, 1.9166666269302368, 1.6749998331069946, 2, 1.6749998331069946, 2, 1.7499998807907104, 2, 1.6749998331069946, 1.9166666269302368, 1.6749998331069946, 1.9166666269302368, 1.5999997854232788, 1.9166666269302368, 1.5999997854232788, 2, 1.5999997854232788, 2, 1.6749998331069946, 2, 1.5999997854232788, 1.9166666269302368, 1.5999997854232788, 1.9166666269302368, 1.524999737739563, 1.9166666269302368, 1.524999737739563, 2, 1.524999737739563, 2, 1.5999997854232788, 2, 1.524999737739563, 1.9166666269302368, 1.524999737739563, 1.9166666269302368, 1.4499996900558471, 1.9166666269302368, 1.4499996900558471, 2, 1.4499996900558471, 2, 1.524999737739563, 2, 1.4499996900558471, 1.9166666269302368, 1.4499996900558471, 1.9166666269302368, 1.3749996423721313, 1.9166666269302368, 1.3749996423721313, 2, 1.3749996423721313, 2, 1.4499996900558471, 2, 1.3749996423721313, 1.9166666269302368, 1.3749996423721313, 1.9166666269302368, 1.2999995946884155, 1.9166666269302368, 1.2999995946884155, 2, 1.2999995946884155, 2, 1.3749996423721313, 2, 1.2999995946884155, 1.9166666269302368, 1.2999995946884155, 1.9166666269302368, 1.2249995470046997, 1.9166666269302368, 1.2249995470046997, 2, 1.2249995470046997, 2, 1.2999995946884155, 2, 1.2249995470046997, 1.9166666269302368, 1.2249995470046997, 1.9166666269302368, 1.1499994993209838, 1.9166666269302368, 1.1499994993209838, 2, 1.1499994993209838, 2, 1.2249995470046997, 2, 1.1499994993209838, 1.9166666269302368, 1.1499994993209838, 1.9166666269302368, 1.074999451637268, 1.9166666269302368, 1.074999451637268, 2, 1.074999451637268, 2, 1.1499994993209838, 2, 1.074999451637268, 1.9166666269302368, 1.074999451637268, 1.9166666269302368, 0.999999463558197, 1.9166666269302368, 0.999999463558197, 2, 0.999999463558197, 2, 1.074999451637268, 1.9166666269302368, 1.899999976158142, 1.8333332538604736, 1.899999976158142, 1.8333332538604736, 1.8249999284744262, 1.8333332538604736, 1.8249999284744262, 1.9166666269302368, 1.8249999284744262, 1.9166666269302368, 1.899999976158142, 1.9166666269302368, 1.8249999284744262, 1.8333332538604736, 1.8249999284744262, 1.8333332538604736, 1.7499998807907104, 1.8333332538604736, 1.7499998807907104, 1.9166666269302368, 1.7499998807907104, 1.9166666269302368, 1.8249999284744262, 1.9166666269302368, 1.7499998807907104, 1.8333332538604736, 1.7499998807907104, 1.8333332538604736, 1.6749998331069946, 1.8333332538604736, 1.6749998331069946, 1.9166666269302368, 1.6749998331069946, 1.9166666269302368, 1.7499998807907104, 1.9166666269302368, 1.6749998331069946, 1.8333332538604736, 1.6749998331069946, 1.8333332538604736, 1.5999997854232788, 1.8333332538604736, 1.5999997854232788, 1.9166666269302368, 1.5999997854232788, 1.9166666269302368, 1.6749998331069946, 1.9166666269302368, 1.5999997854232788, 1.8333332538604736, 1.5999997854232788, 1.8333332538604736, 1.524999737739563, 1.8333332538604736, 1.524999737739563, 1.9166666269302368, 1.524999737739563, 1.9166666269302368, 1.5999997854232788, 1.9166666269302368, 1.524999737739563, 1.8333332538604736, 1.524999737739563, 1.8333332538604736, 1.4499996900558471, 1.8333332538604736, 1.4499996900558471, 1.9166666269302368, 1.4499996900558471, 1.9166666269302368, 1.524999737739563, 1.9166666269302368, 1.4499996900558471, 1.8333332538604736, 1.4499996900558471, 1.8333332538604736, 1.3749996423721313, 1.8333332538604736, 1.3749996423721313, 1.9166666269302368, 1.3749996423721313, 1.9166666269302368, 1.4499996900558471, 1.9166666269302368, 1.3749996423721313, 1.8333332538604736, 1.3749996423721313, 1.8333332538604736, 1.2999995946884155, 1.8333332538604736, 1.2999995946884155, 1.9166666269302368, 1.2999995946884155, 1.9166666269302368, 1.3749996423721313, 1.9166666269302368, 1.2999995946884155, 1.8333332538604736, 1.2999995946884155, 1.8333332538604736, 1.2249995470046997, 1.8333332538604736, 1.2249995470046997, 1.9166666269302368, 1.2249995470046997, 1.9166666269302368, 1.2999995946884155, 1.9166666269302368, 1.2249995470046997, 1.8333332538604736, 1.2249995470046997, 1.8333332538604736, 1.1499994993209838, 1.8333332538604736, 1.1499994993209838, 1.9166666269302368, 1.1499994993209838, 1.9166666269302368, 1.2249995470046997, 1.9166666269302368, 1.1499994993209838, 1.8333332538604736, 1.1499994993209838, 1.8333332538604736, 1.074999451637268, 1.8333332538604736, 1.074999451637268, 1.9166666269302368, 1.074999451637268, 1.9166666269302368, 1.1499994993209838, 1.9166666269302368, 1.074999451637268, 1.8333332538604736, 1.074999451637268, 1.8333332538604736, 0.999999463558197, 1.8333332538604736, 0.999999463558197, 1.9166666269302368, 0.999999463558197, 1.9166666269302368, 1.074999451637268, 1.8333332538604736, 1.899999976158142, 1.7499998807907104, 1.899999976158142, 1.7499998807907104, 1.8249999284744262, 1.7499998807907104, 1.8249999284744262, 1.8333332538604736, 1.8249999284744262, 1.8333332538604736, 1.899999976158142, 1.8333332538604736, 1.8249999284744262, 1.7499998807907104, 1.8249999284744262, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.8333332538604736, 1.7499998807907104, 1.8333332538604736, 1.8249999284744262, 1.8333332538604736, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.6749998331069946, 1.7499998807907104, 1.6749998331069946, 1.8333332538604736, 1.6749998331069946, 1.8333332538604736, 1.7499998807907104, 1.8333332538604736, 1.6749998331069946, 1.7499998807907104, 1.6749998331069946, 1.7499998807907104, 1.5999997854232788, 1.7499998807907104, 1.5999997854232788, 1.8333332538604736, 1.5999997854232788, 1.8333332538604736, 1.6749998331069946, 1.8333332538604736, 1.5999997854232788, 1.7499998807907104, 1.5999997854232788, 1.7499998807907104, 1.524999737739563, 1.7499998807907104, 1.524999737739563, 1.8333332538604736, 1.524999737739563, 1.8333332538604736, 1.5999997854232788, 1.8333332538604736, 1.524999737739563, 1.7499998807907104, 1.524999737739563, 1.7499998807907104, 1.4499996900558471, 1.7499998807907104, 1.4499996900558471, 1.8333332538604736, 1.4499996900558471, 1.8333332538604736, 1.524999737739563, 1.8333332538604736, 1.4499996900558471, 1.7499998807907104, 1.4499996900558471, 1.7499998807907104, 1.3749996423721313, 1.7499998807907104, 1.3749996423721313, 1.8333332538604736, 1.3749996423721313, 1.8333332538604736, 1.4499996900558471, 1.8333332538604736, 1.3749996423721313, 1.7499998807907104, 1.3749996423721313, 1.7499998807907104, 1.2999995946884155, 1.7499998807907104, 1.2999995946884155, 1.8333332538604736, 1.2999995946884155, 1.8333332538604736, 1.3749996423721313, 1.8333332538604736, 1.2999995946884155, 1.7499998807907104, 1.2999995946884155, 1.7499998807907104, 1.2249995470046997, 1.7499998807907104, 1.2249995470046997, 1.8333332538604736, 1.2249995470046997, 1.8333332538604736, 1.2999995946884155, 1.8333332538604736, 1.2249995470046997, 1.7499998807907104, 1.2249995470046997, 1.7499998807907104, 1.1499994993209838, 1.7499998807907104, 1.1499994993209838, 1.8333332538604736, 1.1499994993209838, 1.8333332538604736, 1.2249995470046997, 1.8333332538604736, 1.1499994993209838, 1.7499998807907104, 1.1499994993209838, 1.7499998807907104, 1.074999451637268, 1.7499998807907104, 1.074999451637268, 1.8333332538604736, 1.074999451637268, 1.8333332538604736, 1.1499994993209838, 1.8333332538604736, 1.074999451637268, 1.7499998807907104, 1.074999451637268, 1.7499998807907104, 0.999999463558197, 1.7499998807907104, 0.999999463558197, 1.8333332538604736, 0.999999463558197, 1.8333332538604736, 1.074999451637268, 1.7499998807907104, 1.899999976158142, 1.6666665077209472, 1.899999976158142, 1.6666665077209472, 1.8249999284744262, 1.6666665077209472, 1.8249999284744262, 1.7499998807907104, 1.8249999284744262, 1.7499998807907104, 1.899999976158142, 1.7499998807907104, 1.8249999284744262, 1.6666665077209472, 1.8249999284744262, 1.6666665077209472, 1.7499998807907104, 1.6666665077209472, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.8249999284744262, 1.7499998807907104, 1.7499998807907104, 1.6666665077209472, 1.7499998807907104, 1.6666665077209472, 1.6749998331069946, 1.6666665077209472, 1.6749998331069946, 1.7499998807907104, 1.6749998331069946, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.6749998331069946, 1.6666665077209472, 1.6749998331069946, 1.6666665077209472, 1.5999997854232788, 1.6666665077209472, 1.5999997854232788, 1.7499998807907104, 1.5999997854232788, 1.7499998807907104, 1.6749998331069946, 1.7499998807907104, 1.5999997854232788, 1.6666665077209472, 1.5999997854232788, 1.6666665077209472, 1.524999737739563, 1.6666665077209472, 1.524999737739563, 1.7499998807907104, 1.524999737739563, 1.7499998807907104, 1.5999997854232788, 1.7499998807907104, 1.524999737739563, 1.6666665077209472, 1.524999737739563, 1.6666665077209472, 1.4499996900558471, 1.6666665077209472, 1.4499996900558471, 1.7499998807907104, 1.4499996900558471, 1.7499998807907104, 1.524999737739563, 1.7499998807907104, 1.4499996900558471, 1.6666665077209472, 1.4499996900558471, 1.6666665077209472, 1.3749996423721313, 1.6666665077209472, 1.3749996423721313, 1.7499998807907104, 1.3749996423721313, 1.7499998807907104, 1.4499996900558471, 1.7499998807907104, 1.3749996423721313, 1.6666665077209472, 1.3749996423721313, 1.6666665077209472, 1.2999995946884155, 1.6666665077209472, 1.2999995946884155, 1.7499998807907104, 1.2999995946884155, 1.7499998807907104, 1.3749996423721313, 1.7499998807907104, 1.2999995946884155, 1.6666665077209472, 1.2999995946884155, 1.6666665077209472, 1.2249995470046997, 1.6666665077209472, 1.2249995470046997, 1.7499998807907104, 1.2249995470046997, 1.7499998807907104, 1.2999995946884155, 1.7499998807907104, 1.2249995470046997, 1.6666665077209472, 1.2249995470046997, 1.6666665077209472, 1.1499994993209838, 1.6666665077209472, 1.1499994993209838, 1.7499998807907104, 1.1499994993209838, 1.7499998807907104, 1.2249995470046997, 1.7499998807907104, 1.1499994993209838, 1.6666665077209472, 1.1499994993209838, 1.6666665077209472, 1.074999451637268, 1.6666665077209472, 1.074999451637268, 1.7499998807907104, 1.074999451637268, 1.7499998807907104, 1.1499994993209838, 1.7499998807907104, 1.074999451637268, 1.6666665077209472, 1.074999451637268, 1.6666665077209472, 0.999999463558197, 1.6666665077209472, 0.999999463558197, 1.7499998807907104, 0.999999463558197, 1.7499998807907104, 1.074999451637268, 1.6666665077209472, 1.899999976158142, 1.583333134651184, 1.899999976158142, 1.583333134651184, 1.8249999284744262, 1.583333134651184, 1.8249999284744262, 1.6666665077209472, 1.8249999284744262, 1.6666665077209472, 1.899999976158142, 1.6666665077209472, 1.8249999284744262, 1.583333134651184, 1.8249999284744262, 1.583333134651184, 1.7499998807907104, 1.583333134651184, 1.7499998807907104, 1.6666665077209472, 1.7499998807907104, 1.6666665077209472, 1.8249999284744262, 1.6666665077209472, 1.7499998807907104, 1.583333134651184, 1.7499998807907104, 1.583333134651184, 1.6749998331069946, 1.583333134651184, 1.6749998331069946, 1.6666665077209472, 1.6749998331069946, 1.6666665077209472, 1.7499998807907104, 1.6666665077209472, 1.6749998331069946, 1.583333134651184, 1.6749998331069946, 1.583333134651184, 1.5999997854232788, 1.583333134651184, 1.5999997854232788, 1.6666665077209472, 1.5999997854232788, 1.6666665077209472, 1.6749998331069946, 1.6666665077209472, 1.5999997854232788, 1.583333134651184, 1.5999997854232788, 1.583333134651184, 1.524999737739563, 1.583333134651184, 1.524999737739563, 1.6666665077209472, 1.524999737739563, 1.6666665077209472, 1.5999997854232788, 1.6666665077209472, 1.524999737739563, 1.583333134651184, 1.524999737739563, 1.583333134651184, 1.4499996900558471, 1.583333134651184, 1.4499996900558471, 1.6666665077209472, 1.4499996900558471, 1.6666665077209472, 1.524999737739563, 1.6666665077209472, 1.4499996900558471, 1.583333134651184, 1.4499996900558471, 1.583333134651184, 1.3749996423721313, 1.583333134651184, 1.3749996423721313, 1.6666665077209472, 1.3749996423721313, 1.6666665077209472, 1.4499996900558471, 1.6666665077209472, 1.3749996423721313, 1.583333134651184, 1.3749996423721313, 1.583333134651184, 1.2999995946884155, 1.583333134651184, 1.2999995946884155, 1.6666665077209472, 1.2999995946884155, 1.6666665077209472, 1.3749996423721313, 1.6666665077209472, 1.2999995946884155, 1.583333134651184, 1.2999995946884155, 1.583333134651184, 1.2249995470046997, 1.583333134651184, 1.2249995470046997, 1.6666665077209472, 1.2249995470046997, 1.6666665077209472, 1.2999995946884155, 1.6666665077209472, 1.2249995470046997, 1.583333134651184, 1.2249995470046997, 1.583333134651184, 1.1499994993209838, 1.583333134651184, 1.1499994993209838, 1.6666665077209472, 1.1499994993209838, 1.6666665077209472, 1.2249995470046997, 1.6666665077209472, 1.1499994993209838, 1.583333134651184, 1.1499994993209838, 1.583333134651184, 1.074999451637268, 1.583333134651184, 1.074999451637268, 1.6666665077209472, 1.074999451637268, 1.6666665077209472, 1.1499994993209838, 1.6666665077209472, 1.074999451637268, 1.583333134651184, 1.074999451637268, 1.583333134651184, 0.999999463558197, 1.583333134651184, 0.999999463558197, 1.6666665077209472, 0.999999463558197, 1.6666665077209472, 1.074999451637268, 1.583333134651184, 1.899999976158142, 1.499999761581421, 1.899999976158142, 1.499999761581421, 1.8249999284744262, 1.499999761581421, 1.8249999284744262, 1.583333134651184, 1.8249999284744262, 1.583333134651184, 1.899999976158142, 1.583333134651184, 1.8249999284744262, 1.499999761581421, 1.8249999284744262, 1.499999761581421, 1.7499998807907104, 1.499999761581421, 1.7499998807907104, 1.583333134651184, 1.7499998807907104, 1.583333134651184, 1.8249999284744262, 1.583333134651184, 1.7499998807907104, 1.499999761581421, 1.7499998807907104, 1.499999761581421, 1.6749998331069946, 1.499999761581421, 1.6749998331069946, 1.583333134651184, 1.6749998331069946, 1.583333134651184, 1.7499998807907104, 1.583333134651184, 1.6749998331069946, 1.499999761581421, 1.6749998331069946, 1.499999761581421, 1.5999997854232788, 1.499999761581421, 1.5999997854232788, 1.583333134651184, 1.5999997854232788, 1.583333134651184, 1.6749998331069946, 1.583333134651184, 1.5999997854232788, 1.499999761581421, 1.5999997854232788, 1.499999761581421, 1.524999737739563, 1.499999761581421, 1.524999737739563, 1.583333134651184, 1.524999737739563, 1.583333134651184, 1.5999997854232788, 1.583333134651184, 1.524999737739563, 1.499999761581421, 1.524999737739563, 1.499999761581421, 1.4499996900558471, 1.499999761581421, 1.4499996900558471, 1.583333134651184, 1.4499996900558471, 1.583333134651184, 1.524999737739563, 1.583333134651184, 1.4499996900558471, 1.499999761581421, 1.4499996900558471, 1.499999761581421, 1.3749996423721313, 1.499999761581421, 1.3749996423721313, 1.583333134651184, 1.3749996423721313, 1.583333134651184, 1.4499996900558471, 1.583333134651184, 1.3749996423721313, 1.499999761581421, 1.3749996423721313, 1.499999761581421, 1.2999995946884155, 1.499999761581421, 1.2999995946884155, 1.583333134651184, 1.2999995946884155, 1.583333134651184, 1.3749996423721313, 1.583333134651184, 1.2999995946884155, 1.499999761581421, 1.2999995946884155, 1.499999761581421, 1.2249995470046997, 1.499999761581421, 1.2249995470046997, 1.583333134651184, 1.2249995470046997, 1.583333134651184, 1.2999995946884155, 1.583333134651184, 1.2249995470046997, 1.499999761581421, 1.2249995470046997, 1.499999761581421, 1.1499994993209838, 1.499999761581421, 1.1499994993209838, 1.583333134651184, 1.1499994993209838, 1.583333134651184, 1.2249995470046997, 1.583333134651184, 1.1499994993209838, 1.499999761581421, 1.1499994993209838, 1.499999761581421, 1.074999451637268, 1.499999761581421, 1.074999451637268, 1.583333134651184, 1.074999451637268, 1.583333134651184, 1.1499994993209838, 1.583333134651184, 1.074999451637268, 1.499999761581421, 1.074999451637268, 1.499999761581421, 0.999999463558197, 1.499999761581421, 0.999999463558197, 1.583333134651184, 0.999999463558197, 1.583333134651184, 1.074999451637268, 1.499999761581421, 1.899999976158142, 1.4166663885116577, 1.899999976158142, 1.4166663885116577, 1.8249999284744262, 1.4166663885116577, 1.8249999284744262, 1.499999761581421, 1.8249999284744262, 1.499999761581421, 1.899999976158142, 1.499999761581421, 1.8249999284744262, 1.4166663885116577, 1.8249999284744262, 1.4166663885116577, 1.7499998807907104, 1.4166663885116577, 1.7499998807907104, 1.499999761581421, 1.7499998807907104, 1.499999761581421, 1.8249999284744262, 1.499999761581421, 1.7499998807907104, 1.4166663885116577, 1.7499998807907104, 1.4166663885116577, 1.6749998331069946, 1.4166663885116577, 1.6749998331069946, 1.499999761581421, 1.6749998331069946, 1.499999761581421, 1.7499998807907104, 1.499999761581421, 1.6749998331069946, 1.4166663885116577, 1.6749998331069946, 1.4166663885116577, 1.5999997854232788, 1.4166663885116577, 1.5999997854232788, 1.499999761581421, 1.5999997854232788, 1.499999761581421, 1.6749998331069946, 1.499999761581421, 1.5999997854232788, 1.4166663885116577, 1.5999997854232788, 1.4166663885116577, 1.524999737739563, 1.4166663885116577, 1.524999737739563, 1.499999761581421, 1.524999737739563, 1.499999761581421, 1.5999997854232788, 1.499999761581421, 1.524999737739563, 1.4166663885116577, 1.524999737739563, 1.4166663885116577, 1.4499996900558471, 1.4166663885116577, 1.4499996900558471, 1.499999761581421, 1.4499996900558471, 1.499999761581421, 1.524999737739563, 1.499999761581421, 1.4499996900558471, 1.4166663885116577, 1.4499996900558471, 1.4166663885116577, 1.3749996423721313, 1.4166663885116577, 1.3749996423721313, 1.499999761581421, 1.3749996423721313, 1.499999761581421, 1.4499996900558471, 1.499999761581421, 1.3749996423721313, 1.4166663885116577, 1.3749996423721313, 1.4166663885116577, 1.2999995946884155, 1.4166663885116577, 1.2999995946884155, 1.499999761581421, 1.2999995946884155, 1.499999761581421, 1.3749996423721313, 1.499999761581421, 1.2999995946884155, 1.4166663885116577, 1.2999995946884155, 1.4166663885116577, 1.2249995470046997, 1.4166663885116577, 1.2249995470046997, 1.499999761581421, 1.2249995470046997, 1.499999761581421, 1.2999995946884155, 1.499999761581421, 1.2249995470046997, 1.4166663885116577, 1.2249995470046997, 1.4166663885116577, 1.1499994993209838, 1.4166663885116577, 1.1499994993209838, 1.499999761581421, 1.1499994993209838, 1.499999761581421, 1.2249995470046997, 1.499999761581421, 1.1499994993209838, 1.4166663885116577, 1.1499994993209838, 1.4166663885116577, 1.074999451637268, 1.4166663885116577, 1.074999451637268, 1.499999761581421, 1.074999451637268, 1.499999761581421, 1.1499994993209838, 1.499999761581421, 1.074999451637268, 1.4166663885116577, 1.074999451637268, 1.4166663885116577, 0.999999463558197, 1.4166663885116577, 0.999999463558197, 1.499999761581421, 0.999999463558197, 1.499999761581421, 1.074999451637268, 1.4166663885116577, 1.899999976158142, 1.3333330154418945, 1.899999976158142, 1.3333330154418945, 1.8249999284744262, 1.3333330154418945, 1.8249999284744262, 1.4166663885116577, 1.8249999284744262, 1.4166663885116577, 1.899999976158142, 1.4166663885116577, 1.8249999284744262, 1.3333330154418945, 1.8249999284744262, 1.3333330154418945, 1.7499998807907104, 1.3333330154418945, 1.7499998807907104, 1.4166663885116577, 1.7499998807907104, 1.4166663885116577, 1.8249999284744262, 1.4166663885116577, 1.7499998807907104, 1.3333330154418945, 1.7499998807907104, 1.3333330154418945, 1.6749998331069946, 1.3333330154418945, 1.6749998331069946, 1.4166663885116577, 1.6749998331069946, 1.4166663885116577, 1.7499998807907104, 1.4166663885116577, 1.6749998331069946, 1.3333330154418945, 1.6749998331069946, 1.3333330154418945, 1.5999997854232788, 1.3333330154418945, 1.5999997854232788, 1.4166663885116577, 1.5999997854232788, 1.4166663885116577, 1.6749998331069946, 1.4166663885116577, 1.5999997854232788, 1.3333330154418945, 1.5999997854232788, 1.3333330154418945, 1.524999737739563, 1.3333330154418945, 1.524999737739563, 1.4166663885116577, 1.524999737739563, 1.4166663885116577, 1.5999997854232788, 1.4166663885116577, 1.524999737739563, 1.3333330154418945, 1.524999737739563, 1.3333330154418945, 1.4499996900558471, 1.3333330154418945, 1.4499996900558471, 1.4166663885116577, 1.4499996900558471, 1.4166663885116577, 1.524999737739563, 1.4166663885116577, 1.4499996900558471, 1.3333330154418945, 1.4499996900558471, 1.3333330154418945, 1.3749996423721313, 1.3333330154418945, 1.3749996423721313, 1.4166663885116577, 1.3749996423721313, 1.4166663885116577, 1.4499996900558471, 1.4166663885116577, 1.3749996423721313, 1.3333330154418945, 1.3749996423721313, 1.3333330154418945, 1.2999995946884155, 1.3333330154418945, 1.2999995946884155, 1.4166663885116577, 1.2999995946884155, 1.4166663885116577, 1.3749996423721313, 1.4166663885116577, 1.2999995946884155, 1.3333330154418945, 1.2999995946884155, 1.3333330154418945, 1.2249995470046997, 1.3333330154418945, 1.2249995470046997, 1.4166663885116577, 1.2249995470046997, 1.4166663885116577, 1.2999995946884155, 1.4166663885116577, 1.2249995470046997, 1.3333330154418945, 1.2249995470046997, 1.3333330154418945, 1.1499994993209838, 1.3333330154418945, 1.1499994993209838, 1.4166663885116577, 1.1499994993209838, 1.4166663885116577, 1.2249995470046997, 1.4166663885116577, 1.1499994993209838, 1.3333330154418945, 1.1499994993209838, 1.3333330154418945, 1.074999451637268, 1.3333330154418945, 1.074999451637268, 1.4166663885116577, 1.074999451637268, 1.4166663885116577, 1.1499994993209838, 1.4166663885116577, 1.074999451637268, 1.3333330154418945, 1.074999451637268, 1.3333330154418945, 0.999999463558197, 1.3333330154418945, 0.999999463558197, 1.4166663885116577, 0.999999463558197, 1.4166663885116577, 1.074999451637268, 1.3333330154418945, 1.899999976158142, 1.2499996423721313, 1.899999976158142, 1.2499996423721313, 1.8249999284744262, 1.2499996423721313, 1.8249999284744262, 1.3333330154418945, 1.8249999284744262, 1.3333330154418945, 1.899999976158142, 1.3333330154418945, 1.8249999284744262, 1.2499996423721313, 1.8249999284744262, 1.2499996423721313, 1.7499998807907104, 1.2499996423721313, 1.7499998807907104, 1.3333330154418945, 1.7499998807907104, 1.3333330154418945, 1.8249999284744262, 1.3333330154418945, 1.7499998807907104, 1.2499996423721313, 1.7499998807907104, 1.2499996423721313, 1.6749998331069946, 1.2499996423721313, 1.6749998331069946, 1.3333330154418945, 1.6749998331069946, 1.3333330154418945, 1.7499998807907104, 1.3333330154418945, 1.6749998331069946, 1.2499996423721313, 1.6749998331069946, 1.2499996423721313, 1.5999997854232788, 1.2499996423721313, 1.5999997854232788, 1.3333330154418945, 1.5999997854232788, 1.3333330154418945, 1.6749998331069946, 1.3333330154418945, 1.5999997854232788, 1.2499996423721313, 1.5999997854232788, 1.2499996423721313, 1.524999737739563, 1.2499996423721313, 1.524999737739563, 1.3333330154418945, 1.524999737739563, 1.3333330154418945, 1.5999997854232788, 1.3333330154418945, 1.524999737739563, 1.2499996423721313, 1.524999737739563, 1.2499996423721313, 1.4499996900558471, 1.2499996423721313, 1.4499996900558471, 1.3333330154418945, 1.4499996900558471, 1.3333330154418945, 1.524999737739563, 1.3333330154418945, 1.4499996900558471, 1.2499996423721313, 1.4499996900558471, 1.2499996423721313, 1.3749996423721313, 1.2499996423721313, 1.3749996423721313, 1.3333330154418945, 1.3749996423721313, 1.3333330154418945, 1.4499996900558471, 1.3333330154418945, 1.3749996423721313, 1.2499996423721313, 1.3749996423721313, 1.2499996423721313, 1.2999995946884155, 1.2499996423721313, 1.2999995946884155, 1.3333330154418945, 1.2999995946884155, 1.3333330154418945, 1.3749996423721313, 1.3333330154418945, 1.2999995946884155, 1.2499996423721313, 1.2999995946884155, 1.2499996423721313, 1.2249995470046997, 1.2499996423721313, 1.2249995470046997, 1.3333330154418945, 1.2249995470046997, 1.3333330154418945, 1.2999995946884155, 1.3333330154418945, 1.2249995470046997, 1.2499996423721313, 1.2249995470046997, 1.2499996423721313, 1.1499994993209838, 1.2499996423721313, 1.1499994993209838, 1.3333330154418945, 1.1499994993209838, 1.3333330154418945, 1.2249995470046997, 1.3333330154418945, 1.1499994993209838, 1.2499996423721313, 1.1499994993209838, 1.2499996423721313, 1.074999451637268, 1.2499996423721313, 1.074999451637268, 1.3333330154418945, 1.074999451637268, 1.3333330154418945, 1.1499994993209838, 1.3333330154418945, 1.074999451637268, 1.2499996423721313, 1.074999451637268, 1.2499996423721313, 0.999999463558197, 1.2499996423721313, 0.999999463558197, 1.3333330154418945, 0.999999463558197, 1.3333330154418945, 1.074999451637268, 1.2499996423721313, 1.899999976158142, 1.1666662693023681, 1.899999976158142, 1.1666662693023681, 1.8249999284744262, 1.1666662693023681, 1.8249999284744262, 1.2499996423721313, 1.8249999284744262, 1.2499996423721313, 1.899999976158142, 1.2499996423721313, 1.8249999284744262, 1.1666662693023681, 1.8249999284744262, 1.1666662693023681, 1.7499998807907104, 1.1666662693023681, 1.7499998807907104, 1.2499996423721313, 1.7499998807907104, 1.2499996423721313, 1.8249999284744262, 1.2499996423721313, 1.7499998807907104, 1.1666662693023681, 1.7499998807907104, 1.1666662693023681, 1.6749998331069946, 1.1666662693023681, 1.6749998331069946, 1.2499996423721313, 1.6749998331069946, 1.2499996423721313, 1.7499998807907104, 1.2499996423721313, 1.6749998331069946, 1.1666662693023681, 1.6749998331069946, 1.1666662693023681, 1.5999997854232788, 1.1666662693023681, 1.5999997854232788, 1.2499996423721313, 1.5999997854232788, 1.2499996423721313, 1.6749998331069946, 1.2499996423721313, 1.5999997854232788, 1.1666662693023681, 1.5999997854232788, 1.1666662693023681, 1.524999737739563, 1.1666662693023681, 1.524999737739563, 1.2499996423721313, 1.524999737739563, 1.2499996423721313, 1.5999997854232788, 1.2499996423721313, 1.524999737739563, 1.1666662693023681, 1.524999737739563, 1.1666662693023681, 1.4499996900558471, 1.1666662693023681, 1.4499996900558471, 1.2499996423721313, 1.4499996900558471, 1.2499996423721313, 1.524999737739563, 1.2499996423721313, 1.4499996900558471, 1.1666662693023681, 1.4499996900558471, 1.1666662693023681, 1.3749996423721313, 1.1666662693023681, 1.3749996423721313, 1.2499996423721313, 1.3749996423721313, 1.2499996423721313, 1.4499996900558471, 1.2499996423721313, 1.3749996423721313, 1.1666662693023681, 1.3749996423721313, 1.1666662693023681, 1.2999995946884155, 1.1666662693023681, 1.2999995946884155, 1.2499996423721313, 1.2999995946884155, 1.2499996423721313, 1.3749996423721313, 1.2499996423721313, 1.2999995946884155, 1.1666662693023681, 1.2999995946884155, 1.1666662693023681, 1.2249995470046997, 1.1666662693023681, 1.2249995470046997, 1.2499996423721313, 1.2249995470046997, 1.2499996423721313, 1.2999995946884155, 1.2499996423721313, 1.2249995470046997, 1.1666662693023681, 1.2249995470046997, 1.1666662693023681, 1.1499994993209838, 1.1666662693023681, 1.1499994993209838, 1.2499996423721313, 1.1499994993209838, 1.2499996423721313, 1.2249995470046997, 1.2499996423721313, 1.1499994993209838, 1.1666662693023681, 1.1499994993209838, 1.1666662693023681, 1.074999451637268, 1.1666662693023681, 1.074999451637268, 1.2499996423721313, 1.074999451637268, 1.2499996423721313, 1.1499994993209838, 1.2499996423721313, 1.074999451637268, 1.1666662693023681, 1.074999451637268, 1.1666662693023681, 0.999999463558197, 1.1666662693023681, 0.999999463558197, 1.2499996423721313, 0.999999463558197, 1.2499996423721313, 1.074999451637268, 1.1666662693023681, 1.899999976158142, 1.083332896232605, 1.899999976158142, 1.083332896232605, 1.8249999284744262, 1.083332896232605, 1.8249999284744262, 1.1666662693023681, 1.8249999284744262, 1.1666662693023681, 1.899999976158142, 1.1666662693023681, 1.8249999284744262, 1.083332896232605, 1.8249999284744262, 1.083332896232605, 1.7499998807907104, 1.083332896232605, 1.7499998807907104, 1.1666662693023681, 1.7499998807907104, 1.1666662693023681, 1.8249999284744262, 1.1666662693023681, 1.7499998807907104, 1.083332896232605, 1.7499998807907104, 1.083332896232605, 1.6749998331069946, 1.083332896232605, 1.6749998331069946, 1.1666662693023681, 1.6749998331069946, 1.1666662693023681, 1.7499998807907104, 1.1666662693023681, 1.6749998331069946, 1.083332896232605, 1.6749998331069946, 1.083332896232605, 1.5999997854232788, 1.083332896232605, 1.5999997854232788, 1.1666662693023681, 1.5999997854232788, 1.1666662693023681, 1.6749998331069946, 1.1666662693023681, 1.5999997854232788, 1.083332896232605, 1.5999997854232788, 1.083332896232605, 1.524999737739563, 1.083332896232605, 1.524999737739563, 1.1666662693023681, 1.524999737739563, 1.1666662693023681, 1.5999997854232788, 1.1666662693023681, 1.524999737739563, 1.083332896232605, 1.524999737739563, 1.083332896232605, 1.4499996900558471, 1.083332896232605, 1.4499996900558471, 1.1666662693023681, 1.4499996900558471, 1.1666662693023681, 1.524999737739563, 1.1666662693023681, 1.4499996900558471, 1.083332896232605, 1.4499996900558471, 1.083332896232605, 1.3749996423721313, 1.083332896232605, 1.3749996423721313, 1.1666662693023681, 1.3749996423721313, 1.1666662693023681, 1.4499996900558471, 1.1666662693023681, 1.3749996423721313, 1.083332896232605, 1.3749996423721313, 1.083332896232605, 1.2999995946884155, 1.083332896232605, 1.2999995946884155, 1.1666662693023681, 1.2999995946884155, 1.1666662693023681, 1.3749996423721313, 1.1666662693023681, 1.2999995946884155, 1.083332896232605, 1.2999995946884155, 1.083332896232605, 1.2249995470046997, 1.083332896232605, 1.2249995470046997, 1.1666662693023681, 1.2249995470046997, 1.1666662693023681, 1.2999995946884155, 1.1666662693023681, 1.2249995470046997, 1.083332896232605, 1.2249995470046997, 1.083332896232605, 1.1499994993209838, 1.083332896232605, 1.1499994993209838, 1.1666662693023681, 1.1499994993209838, 1.1666662693023681, 1.2249995470046997, 1.1666662693023681, 1.1499994993209838, 1.083332896232605, 1.1499994993209838, 1.083332896232605, 1.074999451637268, 1.083332896232605, 1.074999451637268, 1.1666662693023681, 1.074999451637268, 1.1666662693023681, 1.1499994993209838, 1.1666662693023681, 1.074999451637268, 1.083332896232605, 1.074999451637268, 1.083332896232605, 0.999999463558197, 1.083332896232605, 0.999999463558197, 1.1666662693023681, 0.999999463558197, 1.1666662693023681, 1.074999451637268, 1.083332896232605, 1.899999976158142, 0.9999995827674866, 1.899999976158142, 0.9999995827674866, 1.8249999284744262, 0.9999995827674866, 1.8249999284744262, 1.083332896232605, 1.8249999284744262, 1.083332896232605, 1.899999976158142, 1.083332896232605, 1.8249999284744262, 0.9999995827674866, 1.8249999284744262, 0.9999995827674866, 1.7499998807907104, 0.9999995827674866, 1.7499998807907104, 1.083332896232605, 1.7499998807907104, 1.083332896232605, 1.8249999284744262, 1.083332896232605, 1.7499998807907104, 0.9999995827674866, 1.7499998807907104, 0.9999995827674866, 1.6749998331069946, 0.9999995827674866, 1.6749998331069946, 1.083332896232605, 1.6749998331069946, 1.083332896232605, 1.7499998807907104, 1.083332896232605, 1.6749998331069946, 0.9999995827674866, 1.6749998331069946, 0.9999995827674866, 1.5999997854232788, 0.9999995827674866, 1.5999997854232788, 1.083332896232605, 1.5999997854232788, 1.083332896232605, 1.6749998331069946, 1.083332896232605, 1.5999997854232788, 0.9999995827674866, 1.5999997854232788, 0.9999995827674866, 1.524999737739563, 0.9999995827674866, 1.524999737739563, 1.083332896232605, 1.524999737739563, 1.083332896232605, 1.5999997854232788, 1.083332896232605, 1.524999737739563, 0.9999995827674866, 1.524999737739563, 0.9999995827674866, 1.4499996900558471, 0.9999995827674866, 1.4499996900558471, 1.083332896232605, 1.4499996900558471, 1.083332896232605, 1.524999737739563, 1.083332896232605, 1.4499996900558471, 0.9999995827674866, 1.4499996900558471, 0.9999995827674866, 1.3749996423721313, 0.9999995827674866, 1.3749996423721313, 1.083332896232605, 1.3749996423721313, 1.083332896232605, 1.4499996900558471, 1.083332896232605, 1.3749996423721313, 0.9999995827674866, 1.3749996423721313, 0.9999995827674866, 1.2999995946884155, 0.9999995827674866, 1.2999995946884155, 1.083332896232605, 1.2999995946884155, 1.083332896232605, 1.3749996423721313, 1.083332896232605, 1.2999995946884155, 0.9999995827674866, 1.2999995946884155, 0.9999995827674866, 1.2249995470046997, 0.9999995827674866, 1.2249995470046997, 1.083332896232605, 1.2249995470046997, 1.083332896232605, 1.2999995946884155, 1.083332896232605, 1.2249995470046997, 0.9999995827674866, 1.2249995470046997, 0.9999995827674866, 1.1499994993209838, 0.9999995827674866, 1.1499994993209838, 1.083332896232605, 1.1499994993209838, 1.083332896232605, 1.2249995470046997, 1.083332896232605, 1.1499994993209838, 0.9999995827674866, 1.1499994993209838, 0.9999995827674866, 1.074999451637268, 0.9999995827674866, 1.074999451637268, 1.083332896232605, 1.074999451637268, 1.083332896232605, 1.1499994993209838, 1.083332896232605, 1.074999451637268, 0.9999995827674866, 1.074999451637268, 0.9999995827674866, 0.999999463558197, 0.9999995827674866, 0.999999463558197, 1.083332896232605, 0.999999463558197, 1.083332896232605, 1.074999451637268, 1, 1.899999976158142, 0.9166666865348816, 1.899999976158142, 0.9166666865348816, 1.8249999284744262, 0.9166666865348816, 1.8249999284744262, 1, 1.8249999284744262, 1, 1.899999976158142, 1, 1.8249999284744262, 0.9166666865348816, 1.8249999284744262, 0.9166666865348816, 1.7499998807907104, 0.9166666865348816, 1.7499998807907104, 1, 1.7499998807907104, 1, 1.8249999284744262, 1, 1.7499998807907104, 0.9166666865348816, 1.7499998807907104, 0.9166666865348816, 1.6749998331069946, 0.9166666865348816, 1.6749998331069946, 1, 1.6749998331069946, 1, 1.7499998807907104, 1, 1.6749998331069946, 0.9166666865348816, 1.6749998331069946, 0.9166666865348816, 1.5999997854232788, 0.9166666865348816, 1.5999997854232788, 1, 1.5999997854232788, 1, 1.6749998331069946, 1, 1.5999997854232788, 0.9166666865348816, 1.5999997854232788, 0.9166666865348816, 1.524999737739563, 0.9166666865348816, 1.524999737739563, 1, 1.524999737739563, 1, 1.5999997854232788, 1, 1.524999737739563, 0.9166666865348816, 1.524999737739563, 0.9166666865348816, 1.4499996900558471, 0.9166666865348816, 1.4499996900558471, 1, 1.4499996900558471, 1, 1.524999737739563, 1, 1.4499996900558471, 0.9166666865348816, 1.4499996900558471, 0.9166666865348816, 1.3749996423721313, 0.9166666865348816, 1.3749996423721313, 1, 1.3749996423721313, 1, 1.4499996900558471, 1, 1.3749996423721313, 0.9166666865348816, 1.3749996423721313, 0.9166666865348816, 1.2999995946884155, 0.9166666865348816, 1.2999995946884155, 1, 1.2999995946884155, 1, 1.3749996423721313, 1, 1.2999995946884155, 0.9166666865348816, 1.2999995946884155, 0.9166666865348816, 1.2249995470046997, 0.9166666865348816, 1.2249995470046997, 1, 1.2249995470046997, 1, 1.2999995946884155, 1, 1.2249995470046997, 0.9166666865348816, 1.2249995470046997, 0.9166666865348816, 1.1499994993209838, 0.9166666865348816, 1.1499994993209838, 1, 1.1499994993209838, 1, 1.2249995470046997, 1, 1.1499994993209838, 0.9166666865348816, 1.1499994993209838, 0.9166666865348816, 1.074999451637268, 0.9166666865348816, 1.074999451637268, 1, 1.074999451637268, 1, 1.1499994993209838, 1, 1.074999451637268, 0.9166666865348816, 1.074999451637268, 0.9166666865348816, 0.999999463558197, 0.9166666865348816, 0.999999463558197, 1, 0.999999463558197, 1, 1.074999451637268, 0.9166666865348816, 1.899999976158142, 0.8333333730697632, 1.899999976158142, 0.8333333730697632, 1.8249999284744262, 0.8333333730697632, 1.8249999284744262, 0.9166666865348816, 1.8249999284744262, 0.9166666865348816, 1.899999976158142, 0.9166666865348816, 1.8249999284744262, 0.8333333730697632, 1.8249999284744262, 0.8333333730697632, 1.7499998807907104, 0.8333333730697632, 1.7499998807907104, 0.9166666865348816, 1.7499998807907104, 0.9166666865348816, 1.8249999284744262, 0.9166666865348816, 1.7499998807907104, 0.8333333730697632, 1.7499998807907104, 0.8333333730697632, 1.6749998331069946, 0.8333333730697632, 1.6749998331069946, 0.9166666865348816, 1.6749998331069946, 0.9166666865348816, 1.7499998807907104, 0.9166666865348816, 1.6749998331069946, 0.8333333730697632, 1.6749998331069946, 0.8333333730697632, 1.5999997854232788, 0.8333333730697632, 1.5999997854232788, 0.9166666865348816, 1.5999997854232788, 0.9166666865348816, 1.6749998331069946, 0.9166666865348816, 1.5999997854232788, 0.8333333730697632, 1.5999997854232788, 0.8333333730697632, 1.524999737739563, 0.8333333730697632, 1.524999737739563, 0.9166666865348816, 1.524999737739563, 0.9166666865348816, 1.5999997854232788, 0.9166666865348816, 1.524999737739563, 0.8333333730697632, 1.524999737739563, 0.8333333730697632, 1.4499996900558471, 0.8333333730697632, 1.4499996900558471, 0.9166666865348816, 1.4499996900558471, 0.9166666865348816, 1.524999737739563, 0.9166666865348816, 1.4499996900558471, 0.8333333730697632, 1.4499996900558471, 0.8333333730697632, 1.3749996423721313, 0.8333333730697632, 1.3749996423721313, 0.9166666865348816, 1.3749996423721313, 0.9166666865348816, 1.4499996900558471, 0.9166666865348816, 1.3749996423721313, 0.8333333730697632, 1.3749996423721313, 0.8333333730697632, 1.2999995946884155, 0.8333333730697632, 1.2999995946884155, 0.9166666865348816, 1.2999995946884155, 0.9166666865348816, 1.3749996423721313, 0.9166666865348816, 1.2999995946884155, 0.8333333730697632, 1.2999995946884155, 0.8333333730697632, 1.2249995470046997, 0.8333333730697632, 1.2249995470046997, 0.9166666865348816, 1.2249995470046997, 0.9166666865348816, 1.2999995946884155, 0.9166666865348816, 1.2249995470046997, 0.8333333730697632, 1.2249995470046997, 0.8333333730697632, 1.1499994993209838, 0.8333333730697632, 1.1499994993209838, 0.9166666865348816, 1.1499994993209838, 0.9166666865348816, 1.2249995470046997, 0.9166666865348816, 1.1499994993209838, 0.8333333730697632, 1.1499994993209838, 0.8333333730697632, 1.074999451637268, 0.8333333730697632, 1.074999451637268, 0.9166666865348816, 1.074999451637268, 0.9166666865348816, 1.1499994993209838, 0.9166666865348816, 1.074999451637268, 0.8333333730697632, 1.074999451637268, 0.8333333730697632, 0.999999463558197, 0.8333333730697632, 0.999999463558197, 0.9166666865348816, 0.999999463558197, 0.9166666865348816, 1.074999451637268, 0.8333333730697632, 1.899999976158142, 0.7500000596046448, 1.899999976158142, 0.7500000596046448, 1.8249999284744262, 0.7500000596046448, 1.8249999284744262, 0.8333333730697632, 1.8249999284744262, 0.8333333730697632, 1.899999976158142, 0.8333333730697632, 1.8249999284744262, 0.7500000596046448, 1.8249999284744262, 0.7500000596046448, 1.7499998807907104, 0.7500000596046448, 1.7499998807907104, 0.8333333730697632, 1.7499998807907104, 0.8333333730697632, 1.8249999284744262, 0.8333333730697632, 1.7499998807907104, 0.7500000596046448, 1.7499998807907104, 0.7500000596046448, 1.6749998331069946, 0.7500000596046448, 1.6749998331069946, 0.8333333730697632, 1.6749998331069946, 0.8333333730697632, 1.7499998807907104, 0.8333333730697632, 1.6749998331069946, 0.7500000596046448, 1.6749998331069946, 0.7500000596046448, 1.5999997854232788, 0.7500000596046448, 1.5999997854232788, 0.8333333730697632, 1.5999997854232788, 0.8333333730697632, 1.6749998331069946, 0.8333333730697632, 1.5999997854232788, 0.7500000596046448, 1.5999997854232788, 0.7500000596046448, 1.524999737739563, 0.7500000596046448, 1.524999737739563, 0.8333333730697632, 1.524999737739563, 0.8333333730697632, 1.5999997854232788, 0.8333333730697632, 1.524999737739563, 0.7500000596046448, 1.524999737739563, 0.7500000596046448, 1.4499996900558471, 0.7500000596046448, 1.4499996900558471, 0.8333333730697632, 1.4499996900558471, 0.8333333730697632, 1.524999737739563, 0.8333333730697632, 1.4499996900558471, 0.7500000596046448, 1.4499996900558471, 0.7500000596046448, 1.3749996423721313, 0.7500000596046448, 1.3749996423721313, 0.8333333730697632, 1.3749996423721313, 0.8333333730697632, 1.4499996900558471, 0.8333333730697632, 1.3749996423721313, 0.7500000596046448, 1.3749996423721313, 0.7500000596046448, 1.2999995946884155, 0.7500000596046448, 1.2999995946884155, 0.8333333730697632, 1.2999995946884155, 0.8333333730697632, 1.3749996423721313, 0.8333333730697632, 1.2999995946884155, 0.7500000596046448, 1.2999995946884155, 0.7500000596046448, 1.2249995470046997, 0.7500000596046448, 1.2249995470046997, 0.8333333730697632, 1.2249995470046997, 0.8333333730697632, 1.2999995946884155, 0.8333333730697632, 1.2249995470046997, 0.7500000596046448, 1.2249995470046997, 0.7500000596046448, 1.1499994993209838, 0.7500000596046448, 1.1499994993209838, 0.8333333730697632, 1.1499994993209838, 0.8333333730697632, 1.2249995470046997, 0.8333333730697632, 1.1499994993209838, 0.7500000596046448, 1.1499994993209838, 0.7500000596046448, 1.074999451637268, 0.7500000596046448, 1.074999451637268, 0.8333333730697632, 1.074999451637268, 0.8333333730697632, 1.1499994993209838, 0.8333333730697632, 1.074999451637268, 0.7500000596046448, 1.074999451637268, 0.7500000596046448, 0.999999463558197, 0.7500000596046448, 0.999999463558197, 0.8333333730697632, 0.999999463558197, 0.8333333730697632, 1.074999451637268, 0.7500000596046448, 1.899999976158142, 0.6666667461395264, 1.899999976158142, 0.6666667461395264, 1.8249999284744262, 0.6666667461395264, 1.8249999284744262, 0.7500000596046448, 1.8249999284744262, 0.7500000596046448, 1.899999976158142, 0.7500000596046448, 1.8249999284744262, 0.6666667461395264, 1.8249999284744262, 0.6666667461395264, 1.7499998807907104, 0.6666667461395264, 1.7499998807907104, 0.7500000596046448, 1.7499998807907104, 0.7500000596046448, 1.8249999284744262, 0.7500000596046448, 1.7499998807907104, 0.6666667461395264, 1.7499998807907104, 0.6666667461395264, 1.6749998331069946, 0.6666667461395264, 1.6749998331069946, 0.7500000596046448, 1.6749998331069946, 0.7500000596046448, 1.7499998807907104, 0.7500000596046448, 1.6749998331069946, 0.6666667461395264, 1.6749998331069946, 0.6666667461395264, 1.5999997854232788, 0.6666667461395264, 1.5999997854232788, 0.7500000596046448, 1.5999997854232788, 0.7500000596046448, 1.6749998331069946, 0.7500000596046448, 1.5999997854232788, 0.6666667461395264, 1.5999997854232788, 0.6666667461395264, 1.524999737739563, 0.6666667461395264, 1.524999737739563, 0.7500000596046448, 1.524999737739563, 0.7500000596046448, 1.5999997854232788, 0.7500000596046448, 1.524999737739563, 0.6666667461395264, 1.524999737739563, 0.6666667461395264, 1.4499996900558471, 0.6666667461395264, 1.4499996900558471, 0.7500000596046448, 1.4499996900558471, 0.7500000596046448, 1.524999737739563, 0.7500000596046448, 1.4499996900558471, 0.6666667461395264, 1.4499996900558471, 0.6666667461395264, 1.3749996423721313, 0.6666667461395264, 1.3749996423721313, 0.7500000596046448, 1.3749996423721313, 0.7500000596046448, 1.4499996900558471, 0.7500000596046448, 1.3749996423721313, 0.6666667461395264, 1.3749996423721313, 0.6666667461395264, 1.2999995946884155, 0.6666667461395264, 1.2999995946884155, 0.7500000596046448, 1.2999995946884155, 0.7500000596046448, 1.3749996423721313, 0.7500000596046448, 1.2999995946884155, 0.6666667461395264, 1.2999995946884155, 0.6666667461395264, 1.2249995470046997, 0.6666667461395264, 1.2249995470046997, 0.7500000596046448, 1.2249995470046997, 0.7500000596046448, 1.2999995946884155, 0.7500000596046448, 1.2249995470046997, 0.6666667461395264, 1.2249995470046997, 0.6666667461395264, 1.1499994993209838, 0.6666667461395264, 1.1499994993209838, 0.7500000596046448, 1.1499994993209838, 0.7500000596046448, 1.2249995470046997, 0.7500000596046448, 1.1499994993209838, 0.6666667461395264, 1.1499994993209838, 0.6666667461395264, 1.074999451637268, 0.6666667461395264, 1.074999451637268, 0.7500000596046448, 1.074999451637268, 0.7500000596046448, 1.1499994993209838, 0.7500000596046448, 1.074999451637268, 0.6666667461395264, 1.074999451637268, 0.6666667461395264, 0.999999463558197, 0.6666667461395264, 0.999999463558197, 0.7500000596046448, 0.999999463558197, 0.7500000596046448, 1.074999451637268, 0.6666667461395264, 1.899999976158142, 0.583333432674408, 1.899999976158142, 0.583333432674408, 1.8249999284744262, 0.583333432674408, 1.8249999284744262, 0.6666667461395264, 1.8249999284744262, 0.6666667461395264, 1.899999976158142, 0.6666667461395264, 1.8249999284744262, 0.583333432674408, 1.8249999284744262, 0.583333432674408, 1.7499998807907104, 0.583333432674408, 1.7499998807907104, 0.6666667461395264, 1.7499998807907104, 0.6666667461395264, 1.8249999284744262, 0.6666667461395264, 1.7499998807907104, 0.583333432674408, 1.7499998807907104, 0.583333432674408, 1.6749998331069946, 0.583333432674408, 1.6749998331069946, 0.6666667461395264, 1.6749998331069946, 0.6666667461395264, 1.7499998807907104, 0.6666667461395264, 1.6749998331069946, 0.583333432674408, 1.6749998331069946, 0.583333432674408, 1.5999997854232788, 0.583333432674408, 1.5999997854232788, 0.6666667461395264, 1.5999997854232788, 0.6666667461395264, 1.6749998331069946, 0.6666667461395264, 1.5999997854232788, 0.583333432674408, 1.5999997854232788, 0.583333432674408, 1.524999737739563, 0.583333432674408, 1.524999737739563, 0.6666667461395264, 1.524999737739563, 0.6666667461395264, 1.5999997854232788, 0.6666667461395264, 1.524999737739563, 0.583333432674408, 1.524999737739563, 0.583333432674408, 1.4499996900558471, 0.583333432674408, 1.4499996900558471, 0.6666667461395264, 1.4499996900558471, 0.6666667461395264, 1.524999737739563, 0.6666667461395264, 1.4499996900558471, 0.583333432674408, 1.4499996900558471, 0.583333432674408, 1.3749996423721313, 0.583333432674408, 1.3749996423721313, 0.6666667461395264, 1.3749996423721313, 0.6666667461395264, 1.4499996900558471, 0.6666667461395264, 1.3749996423721313, 0.583333432674408, 1.3749996423721313, 0.583333432674408, 1.2999995946884155, 0.583333432674408, 1.2999995946884155, 0.6666667461395264, 1.2999995946884155, 0.6666667461395264, 1.3749996423721313, 0.6666667461395264, 1.2999995946884155, 0.583333432674408, 1.2999995946884155, 0.583333432674408, 1.2249995470046997, 0.583333432674408, 1.2249995470046997, 0.6666667461395264, 1.2249995470046997, 0.6666667461395264, 1.2999995946884155, 0.6666667461395264, 1.2249995470046997, 0.583333432674408, 1.2249995470046997, 0.583333432674408, 1.1499994993209838, 0.583333432674408, 1.1499994993209838, 0.6666667461395264, 1.1499994993209838, 0.6666667461395264, 1.2249995470046997, 0.6666667461395264, 1.1499994993209838, 0.583333432674408, 1.1499994993209838, 0.583333432674408, 1.074999451637268, 0.583333432674408, 1.074999451637268, 0.6666667461395264, 1.074999451637268, 0.6666667461395264, 1.1499994993209838, 0.6666667461395264, 1.074999451637268, 0.583333432674408, 1.074999451637268, 0.583333432674408, 0.999999463558197, 0.583333432674408, 0.999999463558197, 0.6666667461395264, 0.999999463558197, 0.6666667461395264, 1.074999451637268, 0.583333432674408, 1.899999976158142, 0.5000001192092895, 1.899999976158142, 0.5000001192092895, 1.8249999284744262, 0.5000001192092895, 1.8249999284744262, 0.583333432674408, 1.8249999284744262, 0.583333432674408, 1.899999976158142, 0.583333432674408, 1.8249999284744262, 0.5000001192092895, 1.8249999284744262, 0.5000001192092895, 1.7499998807907104, 0.5000001192092895, 1.7499998807907104, 0.583333432674408, 1.7499998807907104, 0.583333432674408, 1.8249999284744262, 0.583333432674408, 1.7499998807907104, 0.5000001192092895, 1.7499998807907104, 0.5000001192092895, 1.6749998331069946, 0.5000001192092895, 1.6749998331069946, 0.583333432674408, 1.6749998331069946, 0.583333432674408, 1.7499998807907104, 0.583333432674408, 1.6749998331069946, 0.5000001192092895, 1.6749998331069946, 0.5000001192092895, 1.5999997854232788, 0.5000001192092895, 1.5999997854232788, 0.583333432674408, 1.5999997854232788, 0.583333432674408, 1.6749998331069946, 0.583333432674408, 1.5999997854232788, 0.5000001192092895, 1.5999997854232788, 0.5000001192092895, 1.524999737739563, 0.5000001192092895, 1.524999737739563, 0.583333432674408, 1.524999737739563, 0.583333432674408, 1.5999997854232788, 0.583333432674408, 1.524999737739563, 0.5000001192092895, 1.524999737739563, 0.5000001192092895, 1.4499996900558471, 0.5000001192092895, 1.4499996900558471, 0.583333432674408, 1.4499996900558471, 0.583333432674408, 1.524999737739563, 0.583333432674408, 1.4499996900558471, 0.5000001192092895, 1.4499996900558471, 0.5000001192092895, 1.3749996423721313, 0.5000001192092895, 1.3749996423721313, 0.583333432674408, 1.3749996423721313, 0.583333432674408, 1.4499996900558471, 0.583333432674408, 1.3749996423721313, 0.5000001192092895, 1.3749996423721313, 0.5000001192092895, 1.2999995946884155, 0.5000001192092895, 1.2999995946884155, 0.583333432674408, 1.2999995946884155, 0.583333432674408, 1.3749996423721313, 0.583333432674408, 1.2999995946884155, 0.5000001192092895, 1.2999995946884155, 0.5000001192092895, 1.2249995470046997, 0.5000001192092895, 1.2249995470046997, 0.583333432674408, 1.2249995470046997, 0.583333432674408, 1.2999995946884155, 0.583333432674408, 1.2249995470046997, 0.5000001192092895, 1.2249995470046997, 0.5000001192092895, 1.1499994993209838, 0.5000001192092895, 1.1499994993209838, 0.583333432674408, 1.1499994993209838, 0.583333432674408, 1.2249995470046997, 0.583333432674408, 1.1499994993209838, 0.5000001192092895, 1.1499994993209838, 0.5000001192092895, 1.074999451637268, 0.5000001192092895, 1.074999451637268, 0.583333432674408, 1.074999451637268, 0.583333432674408, 1.1499994993209838, 0.583333432674408, 1.074999451637268, 0.5000001192092895, 1.074999451637268, 0.5000001192092895, 0.999999463558197, 0.5000001192092895, 0.999999463558197, 0.583333432674408, 0.999999463558197, 0.583333432674408, 1.074999451637268, 0.5000001192092895, 1.899999976158142, 0.41666677594184875, 1.899999976158142, 0.41666677594184875, 1.8249999284744262, 0.41666677594184875, 1.8249999284744262, 0.5000001192092895, 1.8249999284744262, 0.5000001192092895, 1.899999976158142, 0.5000001192092895, 1.8249999284744262, 0.41666677594184875, 1.8249999284744262, 0.41666677594184875, 1.7499998807907104, 0.41666677594184875, 1.7499998807907104, 0.5000001192092895, 1.7499998807907104, 0.5000001192092895, 1.8249999284744262, 0.5000001192092895, 1.7499998807907104, 0.41666677594184875, 1.7499998807907104, 0.41666677594184875, 1.6749998331069946, 0.41666677594184875, 1.6749998331069946, 0.5000001192092895, 1.6749998331069946, 0.5000001192092895, 1.7499998807907104, 0.5000001192092895, 1.6749998331069946, 0.41666677594184875, 1.6749998331069946, 0.41666677594184875, 1.5999997854232788, 0.41666677594184875, 1.5999997854232788, 0.5000001192092895, 1.5999997854232788, 0.5000001192092895, 1.6749998331069946, 0.5000001192092895, 1.5999997854232788, 0.41666677594184875, 1.5999997854232788, 0.41666677594184875, 1.524999737739563, 0.41666677594184875, 1.524999737739563, 0.5000001192092895, 1.524999737739563, 0.5000001192092895, 1.5999997854232788, 0.5000001192092895, 1.524999737739563, 0.41666677594184875, 1.524999737739563, 0.41666677594184875, 1.4499996900558471, 0.41666677594184875, 1.4499996900558471, 0.5000001192092895, 1.4499996900558471, 0.5000001192092895, 1.524999737739563, 0.5000001192092895, 1.4499996900558471, 0.41666677594184875, 1.4499996900558471, 0.41666677594184875, 1.3749996423721313, 0.41666677594184875, 1.3749996423721313, 0.5000001192092895, 1.3749996423721313, 0.5000001192092895, 1.4499996900558471, 0.5000001192092895, 1.3749996423721313, 0.41666677594184875, 1.3749996423721313, 0.41666677594184875, 1.2999995946884155, 0.41666677594184875, 1.2999995946884155, 0.5000001192092895, 1.2999995946884155, 0.5000001192092895, 1.3749996423721313, 0.5000001192092895, 1.2999995946884155, 0.41666677594184875, 1.2999995946884155, 0.41666677594184875, 1.2249995470046997, 0.41666677594184875, 1.2249995470046997, 0.5000001192092895, 1.2249995470046997, 0.5000001192092895, 1.2999995946884155, 0.5000001192092895, 1.2249995470046997, 0.41666677594184875, 1.2249995470046997, 0.41666677594184875, 1.1499994993209838, 0.41666677594184875, 1.1499994993209838, 0.5000001192092895, 1.1499994993209838, 0.5000001192092895, 1.2249995470046997, 0.5000001192092895, 1.1499994993209838, 0.41666677594184875, 1.1499994993209838, 0.41666677594184875, 1.074999451637268, 0.41666677594184875, 1.074999451637268, 0.5000001192092895, 1.074999451637268, 0.5000001192092895, 1.1499994993209838, 0.5000001192092895, 1.074999451637268, 0.41666677594184875, 1.074999451637268, 0.41666677594184875, 0.999999463558197, 0.41666677594184875, 0.999999463558197, 0.5000001192092895, 0.999999463558197, 0.5000001192092895, 1.074999451637268, 0.41666677594184875, 1.899999976158142, 0.33333343267440796, 1.899999976158142, 0.33333343267440796, 1.8249999284744262, 0.33333343267440796, 1.8249999284744262, 0.41666677594184875, 1.8249999284744262, 0.41666677594184875, 1.899999976158142, 0.41666677594184875, 1.8249999284744262, 0.33333343267440796, 1.8249999284744262, 0.33333343267440796, 1.7499998807907104, 0.33333343267440796, 1.7499998807907104, 0.41666677594184875, 1.7499998807907104, 0.41666677594184875, 1.8249999284744262, 0.41666677594184875, 1.7499998807907104, 0.33333343267440796, 1.7499998807907104, 0.33333343267440796, 1.6749998331069946, 0.33333343267440796, 1.6749998331069946, 0.41666677594184875, 1.6749998331069946, 0.41666677594184875, 1.7499998807907104, 0.41666677594184875, 1.6749998331069946, 0.33333343267440796, 1.6749998331069946, 0.33333343267440796, 1.5999997854232788, 0.33333343267440796, 1.5999997854232788, 0.41666677594184875, 1.5999997854232788, 0.41666677594184875, 1.6749998331069946, 0.41666677594184875, 1.5999997854232788, 0.33333343267440796, 1.5999997854232788, 0.33333343267440796, 1.524999737739563, 0.33333343267440796, 1.524999737739563, 0.41666677594184875, 1.524999737739563, 0.41666677594184875, 1.5999997854232788, 0.41666677594184875, 1.524999737739563, 0.33333343267440796, 1.524999737739563, 0.33333343267440796, 1.4499996900558471, 0.33333343267440796, 1.4499996900558471, 0.41666677594184875, 1.4499996900558471, 0.41666677594184875, 1.524999737739563, 0.41666677594184875, 1.4499996900558471, 0.33333343267440796, 1.4499996900558471, 0.33333343267440796, 1.3749996423721313, 0.33333343267440796, 1.3749996423721313, 0.41666677594184875, 1.3749996423721313, 0.41666677594184875, 1.4499996900558471, 0.41666677594184875, 1.3749996423721313, 0.33333343267440796, 1.3749996423721313, 0.33333343267440796, 1.2999995946884155, 0.33333343267440796, 1.2999995946884155, 0.41666677594184875, 1.2999995946884155, 0.41666677594184875, 1.3749996423721313, 0.41666677594184875, 1.2999995946884155, 0.33333343267440796, 1.2999995946884155, 0.33333343267440796, 1.2249995470046997, 0.33333343267440796, 1.2249995470046997, 0.41666677594184875, 1.2249995470046997, 0.41666677594184875, 1.2999995946884155, 0.41666677594184875, 1.2249995470046997, 0.33333343267440796, 1.2249995470046997, 0.33333343267440796, 1.1499994993209838, 0.33333343267440796, 1.1499994993209838, 0.41666677594184875, 1.1499994993209838, 0.41666677594184875, 1.2249995470046997, 0.41666677594184875, 1.1499994993209838, 0.33333343267440796, 1.1499994993209838, 0.33333343267440796, 1.074999451637268, 0.33333343267440796, 1.074999451637268, 0.41666677594184875, 1.074999451637268, 0.41666677594184875, 1.1499994993209838, 0.41666677594184875, 1.074999451637268, 0.33333343267440796, 1.074999451637268, 0.33333343267440796, 0.999999463558197, 0.33333343267440796, 0.999999463558197, 0.41666677594184875, 0.999999463558197, 0.41666677594184875, 1.074999451637268, 0.33333343267440796, 1.899999976158142, 0.25000008940696716, 1.899999976158142, 0.25000008940696716, 1.8249999284744262, 0.25000008940696716, 1.8249999284744262, 0.33333343267440796, 1.8249999284744262, 0.33333343267440796, 1.899999976158142, 0.33333343267440796, 1.8249999284744262, 0.25000008940696716, 1.8249999284744262, 0.25000008940696716, 1.7499998807907104, 0.25000008940696716, 1.7499998807907104, 0.33333343267440796, 1.7499998807907104, 0.33333343267440796, 1.8249999284744262, 0.33333343267440796, 1.7499998807907104, 0.25000008940696716, 1.7499998807907104, 0.25000008940696716, 1.6749998331069946, 0.25000008940696716, 1.6749998331069946, 0.33333343267440796, 1.6749998331069946, 0.33333343267440796, 1.7499998807907104, 0.33333343267440796, 1.6749998331069946, 0.25000008940696716, 1.6749998331069946, 0.25000008940696716, 1.5999997854232788, 0.25000008940696716, 1.5999997854232788, 0.33333343267440796, 1.5999997854232788, 0.33333343267440796, 1.6749998331069946, 0.33333343267440796, 1.5999997854232788, 0.25000008940696716, 1.5999997854232788, 0.25000008940696716, 1.524999737739563, 0.25000008940696716, 1.524999737739563, 0.33333343267440796, 1.524999737739563, 0.33333343267440796, 1.5999997854232788, 0.33333343267440796, 1.524999737739563, 0.25000008940696716, 1.524999737739563, 0.25000008940696716, 1.4499996900558471, 0.25000008940696716, 1.4499996900558471, 0.33333343267440796, 1.4499996900558471, 0.33333343267440796, 1.524999737739563, 0.33333343267440796, 1.4499996900558471, 0.25000008940696716, 1.4499996900558471, 0.25000008940696716, 1.3749996423721313, 0.25000008940696716, 1.3749996423721313, 0.33333343267440796, 1.3749996423721313, 0.33333343267440796, 1.4499996900558471, 0.33333343267440796, 1.3749996423721313, 0.25000008940696716, 1.3749996423721313, 0.25000008940696716, 1.2999995946884155, 0.25000008940696716, 1.2999995946884155, 0.33333343267440796, 1.2999995946884155, 0.33333343267440796, 1.3749996423721313, 0.33333343267440796, 1.2999995946884155, 0.25000008940696716, 1.2999995946884155, 0.25000008940696716, 1.2249995470046997, 0.25000008940696716, 1.2249995470046997, 0.33333343267440796, 1.2249995470046997, 0.33333343267440796, 1.2999995946884155, 0.33333343267440796, 1.2249995470046997, 0.25000008940696716, 1.2249995470046997, 0.25000008940696716, 1.1499994993209838, 0.25000008940696716, 1.1499994993209838, 0.33333343267440796, 1.1499994993209838, 0.33333343267440796, 1.2249995470046997, 0.33333343267440796, 1.1499994993209838, 0.25000008940696716, 1.1499994993209838, 0.25000008940696716, 1.074999451637268, 0.25000008940696716, 1.074999451637268, 0.33333343267440796, 1.074999451637268, 0.33333343267440796, 1.1499994993209838, 0.33333343267440796, 1.074999451637268, 0.25000008940696716, 1.074999451637268, 0.25000008940696716, 0.999999463558197, 0.25000008940696716, 0.999999463558197, 0.33333343267440796, 0.999999463558197, 0.33333343267440796, 1.074999451637268, 0.25000008940696716, 1.899999976158142, 0.16666674613952637, 1.899999976158142, 0.16666674613952637, 1.8249999284744262, 0.16666674613952637, 1.8249999284744262, 0.25000008940696716, 1.8249999284744262, 0.25000008940696716, 1.899999976158142, 0.25000008940696716, 1.8249999284744262, 0.16666674613952637, 1.8249999284744262, 0.16666674613952637, 1.7499998807907104, 0.16666674613952637, 1.7499998807907104, 0.25000008940696716, 1.7499998807907104, 0.25000008940696716, 1.8249999284744262, 0.25000008940696716, 1.7499998807907104, 0.16666674613952637, 1.7499998807907104, 0.16666674613952637, 1.6749998331069946, 0.16666674613952637, 1.6749998331069946, 0.25000008940696716, 1.6749998331069946, 0.25000008940696716, 1.7499998807907104, 0.25000008940696716, 1.6749998331069946, 0.16666674613952637, 1.6749998331069946, 0.16666674613952637, 1.5999997854232788, 0.16666674613952637, 1.5999997854232788, 0.25000008940696716, 1.5999997854232788, 0.25000008940696716, 1.6749998331069946, 0.25000008940696716, 1.5999997854232788, 0.16666674613952637, 1.5999997854232788, 0.16666674613952637, 1.524999737739563, 0.16666674613952637, 1.524999737739563, 0.25000008940696716, 1.524999737739563, 0.25000008940696716, 1.5999997854232788, 0.25000008940696716, 1.524999737739563, 0.16666674613952637, 1.524999737739563, 0.16666674613952637, 1.4499996900558471, 0.16666674613952637, 1.4499996900558471, 0.25000008940696716, 1.4499996900558471, 0.25000008940696716, 1.524999737739563, 0.25000008940696716, 1.4499996900558471, 0.16666674613952637, 1.4499996900558471, 0.16666674613952637, 1.3749996423721313, 0.16666674613952637, 1.3749996423721313, 0.25000008940696716, 1.3749996423721313, 0.25000008940696716, 1.4499996900558471, 0.25000008940696716, 1.3749996423721313, 0.16666674613952637, 1.3749996423721313, 0.16666674613952637, 1.2999995946884155, 0.16666674613952637, 1.2999995946884155, 0.25000008940696716, 1.2999995946884155, 0.25000008940696716, 1.3749996423721313, 0.25000008940696716, 1.2999995946884155, 0.16666674613952637, 1.2999995946884155, 0.16666674613952637, 1.2249995470046997, 0.16666674613952637, 1.2249995470046997, 0.25000008940696716, 1.2249995470046997, 0.25000008940696716, 1.2999995946884155, 0.25000008940696716, 1.2249995470046997, 0.16666674613952637, 1.2249995470046997, 0.16666674613952637, 1.1499994993209838, 0.16666674613952637, 1.1499994993209838, 0.25000008940696716, 1.1499994993209838, 0.25000008940696716, 1.2249995470046997, 0.25000008940696716, 1.1499994993209838, 0.16666674613952637, 1.1499994993209838, 0.16666674613952637, 1.074999451637268, 0.16666674613952637, 1.074999451637268, 0.25000008940696716, 1.074999451637268, 0.25000008940696716, 1.1499994993209838, 0.25000008940696716, 1.074999451637268, 0.16666674613952637, 1.074999451637268, 0.16666674613952637, 0.999999463558197, 0.16666674613952637, 0.999999463558197, 0.25000008940696716, 0.999999463558197, 0.25000008940696716, 1.074999451637268, 0.16666674613952637, 1.899999976158142, 0.08333341032266617, 1.899999976158142, 0.08333341032266617, 1.8249999284744262, 0.08333341032266617, 1.8249999284744262, 0.16666674613952637, 1.8249999284744262, 0.16666674613952637, 1.899999976158142, 0.16666674613952637, 1.8249999284744262, 0.08333341032266617, 1.8249999284744262, 0.08333341032266617, 1.7499998807907104, 0.08333341032266617, 1.7499998807907104, 0.16666674613952637, 1.7499998807907104, 0.16666674613952637, 1.8249999284744262, 0.16666674613952637, 1.7499998807907104, 0.08333341032266617, 1.7499998807907104, 0.08333341032266617, 1.6749998331069946, 0.08333341032266617, 1.6749998331069946, 0.16666674613952637, 1.6749998331069946, 0.16666674613952637, 1.7499998807907104, 0.16666674613952637, 1.6749998331069946, 0.08333341032266617, 1.6749998331069946, 0.08333341032266617, 1.5999997854232788, 0.08333341032266617, 1.5999997854232788, 0.16666674613952637, 1.5999997854232788, 0.16666674613952637, 1.6749998331069946, 0.16666674613952637, 1.5999997854232788, 0.08333341032266617, 1.5999997854232788, 0.08333341032266617, 1.524999737739563, 0.08333341032266617, 1.524999737739563, 0.16666674613952637, 1.524999737739563, 0.16666674613952637, 1.5999997854232788, 0.16666674613952637, 1.524999737739563, 0.08333341032266617, 1.524999737739563, 0.08333341032266617, 1.4499996900558471, 0.08333341032266617, 1.4499996900558471, 0.16666674613952637, 1.4499996900558471, 0.16666674613952637, 1.524999737739563, 0.16666674613952637, 1.4499996900558471, 0.08333341032266617, 1.4499996900558471, 0.08333341032266617, 1.3749996423721313, 0.08333341032266617, 1.3749996423721313, 0.16666674613952637, 1.3749996423721313, 0.16666674613952637, 1.4499996900558471, 0.16666674613952637, 1.3749996423721313, 0.08333341032266617, 1.3749996423721313, 0.08333341032266617, 1.2999995946884155, 0.08333341032266617, 1.2999995946884155, 0.16666674613952637, 1.2999995946884155, 0.16666674613952637, 1.3749996423721313, 0.16666674613952637, 1.2999995946884155, 0.08333341032266617, 1.2999995946884155, 0.08333341032266617, 1.2249995470046997, 0.08333341032266617, 1.2249995470046997, 0.16666674613952637, 1.2249995470046997, 0.16666674613952637, 1.2999995946884155, 0.16666674613952637, 1.2249995470046997, 0.08333341032266617, 1.2249995470046997, 0.08333341032266617, 1.1499994993209838, 0.08333341032266617, 1.1499994993209838, 0.16666674613952637, 1.1499994993209838, 0.16666674613952637, 1.2249995470046997, 0.16666674613952637, 1.1499994993209838, 0.08333341032266617, 1.1499994993209838, 0.08333341032266617, 1.074999451637268, 0.08333341032266617, 1.074999451637268, 0.16666674613952637, 1.074999451637268, 0.16666674613952637, 1.1499994993209838, 0.16666674613952637, 1.074999451637268, 0.08333341032266617, 1.074999451637268, 0.08333341032266617, 0.999999463558197, 0.08333341032266617, 0.999999463558197, 0.16666674613952637, 0.999999463558197, 0.16666674613952637, 1.074999451637268, 0.08333341032266617, 1.899999976158142, 7.450580596923828e-8, 1.899999976158142, 7.450580596923828e-8, 1.8249999284744262, 7.450580596923828e-8, 1.8249999284744262, 0.08333341032266617, 1.8249999284744262, 0.08333341032266617, 1.899999976158142, 0.08333341032266617, 1.8249999284744262, 7.450580596923828e-8, 1.8249999284744262, 7.450580596923828e-8, 1.7499998807907104, 7.450580596923828e-8, 1.7499998807907104, 0.08333341032266617, 1.7499998807907104, 0.08333341032266617, 1.8249999284744262, 0.08333341032266617, 1.7499998807907104, 7.450580596923828e-8, 1.7499998807907104, 7.450580596923828e-8, 1.6749998331069946, 7.450580596923828e-8, 1.6749998331069946, 0.08333341032266617, 1.6749998331069946, 0.08333341032266617, 1.7499998807907104, 0.08333341032266617, 1.6749998331069946, 7.450580596923828e-8, 1.6749998331069946, 7.450580596923828e-8, 1.5999997854232788, 7.450580596923828e-8, 1.5999997854232788, 0.08333341032266617, 1.5999997854232788, 0.08333341032266617, 1.6749998331069946, 0.08333341032266617, 1.5999997854232788, 7.450580596923828e-8, 1.5999997854232788, 7.450580596923828e-8, 1.524999737739563, 7.450580596923828e-8, 1.524999737739563, 0.08333341032266617, 1.524999737739563, 0.08333341032266617, 1.5999997854232788, 0.08333341032266617, 1.524999737739563, 7.450580596923828e-8, 1.524999737739563, 7.450580596923828e-8, 1.4499996900558471, 7.450580596923828e-8, 1.4499996900558471, 0.08333341032266617, 1.4499996900558471, 0.08333341032266617, 1.524999737739563, 0.08333341032266617, 1.4499996900558471, 7.450580596923828e-8, 1.4499996900558471, 7.450580596923828e-8, 1.3749996423721313, 7.450580596923828e-8, 1.3749996423721313, 0.08333341032266617, 1.3749996423721313, 0.08333341032266617, 1.4499996900558471, 0.08333341032266617, 1.3749996423721313, 7.450580596923828e-8, 1.3749996423721313, 7.450580596923828e-8, 1.2999995946884155, 7.450580596923828e-8, 1.2999995946884155, 0.08333341032266617, 1.2999995946884155, 0.08333341032266617, 1.3749996423721313, 0.08333341032266617, 1.2999995946884155, 7.450580596923828e-8, 1.2999995946884155, 7.450580596923828e-8, 1.2249995470046997, 7.450580596923828e-8, 1.2249995470046997, 0.08333341032266617, 1.2249995470046997, 0.08333341032266617, 1.2999995946884155, 0.08333341032266617, 1.2249995470046997, 7.450580596923828e-8, 1.2249995470046997, 7.450580596923828e-8, 1.1499994993209838, 7.450580596923828e-8, 1.1499994993209838, 0.08333341032266617, 1.1499994993209838, 0.08333341032266617, 1.2249995470046997, 0.08333341032266617, 1.1499994993209838, 7.450580596923828e-8, 1.1499994993209838, 7.450580596923828e-8, 1.074999451637268, 7.450580596923828e-8, 1.074999451637268, 0.08333341032266617, 1.074999451637268, 0.08333341032266617, 1.1499994993209838, 0.08333341032266617, 1.074999451637268, 7.450580596923828e-8, 1.074999451637268, 7.450580596923828e-8, 0.999999463558197, 7.450580596923828e-8, 0.999999463558197, 0.08333341032266617, 0.999999463558197, 0.08333341032266617, 1.074999451637268, 2, 1.899999976158142, 1.9166666269302368, 1.899999976158142, 1.9166666269302368, 1.8249999284744262, 1.9166666269302368, 1.8249999284744262, 2, 1.8249999284744262, 2, 1.899999976158142, 2, 1.8249999284744262, 1.9166666269302368, 1.8249999284744262, 1.9166666269302368, 1.7499998807907104, 1.9166666269302368, 1.7499998807907104, 2, 1.7499998807907104, 2, 1.8249999284744262, 2, 1.7499998807907104, 1.9166666269302368, 1.7499998807907104, 1.9166666269302368, 1.6749998331069946, 1.9166666269302368, 1.6749998331069946, 2, 1.6749998331069946, 2, 1.7499998807907104, 2, 1.6749998331069946, 1.9166666269302368, 1.6749998331069946, 1.9166666269302368, 1.5999997854232788, 1.9166666269302368, 1.5999997854232788, 2, 1.5999997854232788, 2, 1.6749998331069946, 2, 1.5999997854232788, 1.9166666269302368, 1.5999997854232788, 1.9166666269302368, 1.524999737739563, 1.9166666269302368, 1.524999737739563, 2, 1.524999737739563, 2, 1.5999997854232788, 2, 1.524999737739563, 1.9166666269302368, 1.524999737739563, 1.9166666269302368, 1.4499996900558471, 1.9166666269302368, 1.4499996900558471, 2, 1.4499996900558471, 2, 1.524999737739563, 2, 1.4499996900558471, 1.9166666269302368, 1.4499996900558471, 1.9166666269302368, 1.3749996423721313, 1.9166666269302368, 1.3749996423721313, 2, 1.3749996423721313, 2, 1.4499996900558471, 2, 1.3749996423721313, 1.9166666269302368, 1.3749996423721313, 1.9166666269302368, 1.2999995946884155, 1.9166666269302368, 1.2999995946884155, 2, 1.2999995946884155, 2, 1.3749996423721313, 2, 1.2999995946884155, 1.9166666269302368, 1.2999995946884155, 1.9166666269302368, 1.2249995470046997, 1.9166666269302368, 1.2249995470046997, 2, 1.2249995470046997, 2, 1.2999995946884155, 2, 1.2249995470046997, 1.9166666269302368, 1.2249995470046997, 1.9166666269302368, 1.1499994993209838, 1.9166666269302368, 1.1499994993209838, 2, 1.1499994993209838, 2, 1.2249995470046997, 2, 1.1499994993209838, 1.9166666269302368, 1.1499994993209838, 1.9166666269302368, 1.074999451637268, 1.9166666269302368, 1.074999451637268, 2, 1.074999451637268, 2, 1.1499994993209838, 2, 1.074999451637268, 1.9166666269302368, 1.074999451637268, 1.9166666269302368, 0.999999463558197, 1.9166666269302368, 0.999999463558197, 2, 0.999999463558197, 2, 1.074999451637268, 1.9166666269302368, 1.899999976158142, 1.8333332538604736, 1.899999976158142, 1.8333332538604736, 1.8249999284744262, 1.8333332538604736, 1.8249999284744262, 1.9166666269302368, 1.8249999284744262, 1.9166666269302368, 1.899999976158142, 1.9166666269302368, 1.8249999284744262, 1.8333332538604736, 1.8249999284744262, 1.8333332538604736, 1.7499998807907104, 1.8333332538604736, 1.7499998807907104, 1.9166666269302368, 1.7499998807907104, 1.9166666269302368, 1.8249999284744262, 1.9166666269302368, 1.7499998807907104, 1.8333332538604736, 1.7499998807907104, 1.8333332538604736, 1.6749998331069946, 1.8333332538604736, 1.6749998331069946, 1.9166666269302368, 1.6749998331069946, 1.9166666269302368, 1.7499998807907104, 1.9166666269302368, 1.6749998331069946, 1.8333332538604736, 1.6749998331069946, 1.8333332538604736, 1.5999997854232788, 1.8333332538604736, 1.5999997854232788, 1.9166666269302368, 1.5999997854232788, 1.9166666269302368, 1.6749998331069946, 1.9166666269302368, 1.5999997854232788, 1.8333332538604736, 1.5999997854232788, 1.8333332538604736, 1.524999737739563, 1.8333332538604736, 1.524999737739563, 1.9166666269302368, 1.524999737739563, 1.9166666269302368, 1.5999997854232788, 1.9166666269302368, 1.524999737739563, 1.8333332538604736, 1.524999737739563, 1.8333332538604736, 1.4499996900558471, 1.8333332538604736, 1.4499996900558471, 1.9166666269302368, 1.4499996900558471, 1.9166666269302368, 1.524999737739563, 1.9166666269302368, 1.4499996900558471, 1.8333332538604736, 1.4499996900558471, 1.8333332538604736, 1.3749996423721313, 1.8333332538604736, 1.3749996423721313, 1.9166666269302368, 1.3749996423721313, 1.9166666269302368, 1.4499996900558471, 1.9166666269302368, 1.3749996423721313, 1.8333332538604736, 1.3749996423721313, 1.8333332538604736, 1.2999995946884155, 1.8333332538604736, 1.2999995946884155, 1.9166666269302368, 1.2999995946884155, 1.9166666269302368, 1.3749996423721313, 1.9166666269302368, 1.2999995946884155, 1.8333332538604736, 1.2999995946884155, 1.8333332538604736, 1.2249995470046997, 1.8333332538604736, 1.2249995470046997, 1.9166666269302368, 1.2249995470046997, 1.9166666269302368, 1.2999995946884155, 1.9166666269302368, 1.2249995470046997, 1.8333332538604736, 1.2249995470046997, 1.8333332538604736, 1.1499994993209838, 1.8333332538604736, 1.1499994993209838, 1.9166666269302368, 1.1499994993209838, 1.9166666269302368, 1.2249995470046997, 1.9166666269302368, 1.1499994993209838, 1.8333332538604736, 1.1499994993209838, 1.8333332538604736, 1.074999451637268, 1.8333332538604736, 1.074999451637268, 1.9166666269302368, 1.074999451637268, 1.9166666269302368, 1.1499994993209838, 1.9166666269302368, 1.074999451637268, 1.8333332538604736, 1.074999451637268, 1.8333332538604736, 0.999999463558197, 1.8333332538604736, 0.999999463558197, 1.9166666269302368, 0.999999463558197, 1.9166666269302368, 1.074999451637268, 1.8333332538604736, 1.899999976158142, 1.7499998807907104, 1.899999976158142, 1.7499998807907104, 1.8249999284744262, 1.7499998807907104, 1.8249999284744262, 1.8333332538604736, 1.8249999284744262, 1.8333332538604736, 1.899999976158142, 1.8333332538604736, 1.8249999284744262, 1.7499998807907104, 1.8249999284744262, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.8333332538604736, 1.7499998807907104, 1.8333332538604736, 1.8249999284744262, 1.8333332538604736, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.6749998331069946, 1.7499998807907104, 1.6749998331069946, 1.8333332538604736, 1.6749998331069946, 1.8333332538604736, 1.7499998807907104, 1.8333332538604736, 1.6749998331069946, 1.7499998807907104, 1.6749998331069946, 1.7499998807907104, 1.5999997854232788, 1.7499998807907104, 1.5999997854232788, 1.8333332538604736, 1.5999997854232788, 1.8333332538604736, 1.6749998331069946, 1.8333332538604736, 1.5999997854232788, 1.7499998807907104, 1.5999997854232788, 1.7499998807907104, 1.524999737739563, 1.7499998807907104, 1.524999737739563, 1.8333332538604736, 1.524999737739563, 1.8333332538604736, 1.5999997854232788, 1.8333332538604736, 1.524999737739563, 1.7499998807907104, 1.524999737739563, 1.7499998807907104, 1.4499996900558471, 1.7499998807907104, 1.4499996900558471, 1.8333332538604736, 1.4499996900558471, 1.8333332538604736, 1.524999737739563, 1.8333332538604736, 1.4499996900558471, 1.7499998807907104, 1.4499996900558471, 1.7499998807907104, 1.3749996423721313, 1.7499998807907104, 1.3749996423721313, 1.8333332538604736, 1.3749996423721313, 1.8333332538604736, 1.4499996900558471, 1.8333332538604736, 1.3749996423721313, 1.7499998807907104, 1.3749996423721313, 1.7499998807907104, 1.2999995946884155, 1.7499998807907104, 1.2999995946884155, 1.8333332538604736, 1.2999995946884155, 1.8333332538604736, 1.3749996423721313, 1.8333332538604736, 1.2999995946884155, 1.7499998807907104, 1.2999995946884155, 1.7499998807907104, 1.2249995470046997, 1.7499998807907104, 1.2249995470046997, 1.8333332538604736, 1.2249995470046997, 1.8333332538604736, 1.2999995946884155, 1.8333332538604736, 1.2249995470046997, 1.7499998807907104, 1.2249995470046997, 1.7499998807907104, 1.1499994993209838, 1.7499998807907104, 1.1499994993209838, 1.8333332538604736, 1.1499994993209838, 1.8333332538604736, 1.2249995470046997, 1.8333332538604736, 1.1499994993209838, 1.7499998807907104, 1.1499994993209838, 1.7499998807907104, 1.074999451637268, 1.7499998807907104, 1.074999451637268, 1.8333332538604736, 1.074999451637268, 1.8333332538604736, 1.1499994993209838, 1.8333332538604736, 1.074999451637268, 1.7499998807907104, 1.074999451637268, 1.7499998807907104, 0.999999463558197, 1.7499998807907104, 0.999999463558197, 1.8333332538604736, 0.999999463558197, 1.8333332538604736, 1.074999451637268, 1.7499998807907104, 1.899999976158142, 1.6666665077209472, 1.899999976158142, 1.6666665077209472, 1.8249999284744262, 1.6666665077209472, 1.8249999284744262, 1.7499998807907104, 1.8249999284744262, 1.7499998807907104, 1.899999976158142, 1.7499998807907104, 1.8249999284744262, 1.6666665077209472, 1.8249999284744262, 1.6666665077209472, 1.7499998807907104, 1.6666665077209472, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.8249999284744262, 1.7499998807907104, 1.7499998807907104, 1.6666665077209472, 1.7499998807907104, 1.6666665077209472, 1.6749998331069946, 1.6666665077209472, 1.6749998331069946, 1.7499998807907104, 1.6749998331069946, 1.7499998807907104, 1.7499998807907104, 1.7499998807907104, 1.6749998331069946, 1.6666665077209472, 1.6749998331069946, 1.6666665077209472, 1.5999997854232788, 1.6666665077209472, 1.5999997854232788, 1.7499998807907104, 1.5999997854232788, 1.7499998807907104, 1.6749998331069946, 1.7499998807907104, 1.5999997854232788, 1.6666665077209472, 1.5999997854232788, 1.6666665077209472, 1.524999737739563, 1.6666665077209472, 1.524999737739563, 1.7499998807907104, 1.524999737739563, 1.7499998807907104, 1.5999997854232788, 1.7499998807907104, 1.524999737739563, 1.6666665077209472, 1.524999737739563, 1.6666665077209472, 1.4499996900558471, 1.6666665077209472, 1.4499996900558471, 1.7499998807907104, 1.4499996900558471, 1.7499998807907104, 1.524999737739563, 1.7499998807907104, 1.4499996900558471, 1.6666665077209472, 1.4499996900558471, 1.6666665077209472, 1.3749996423721313, 1.6666665077209472, 1.3749996423721313, 1.7499998807907104, 1.3749996423721313, 1.7499998807907104, 1.4499996900558471, 1.7499998807907104, 1.3749996423721313, 1.6666665077209472, 1.3749996423721313, 1.6666665077209472, 1.2999995946884155, 1.6666665077209472, 1.2999995946884155, 1.7499998807907104, 1.2999995946884155, 1.7499998807907104, 1.3749996423721313, 1.7499998807907104, 1.2999995946884155, 1.6666665077209472, 1.2999995946884155, 1.6666665077209472, 1.2249995470046997, 1.6666665077209472, 1.2249995470046997, 1.7499998807907104, 1.2249995470046997, 1.7499998807907104, 1.2999995946884155, 1.7499998807907104, 1.2249995470046997, 1.6666665077209472, 1.2249995470046997, 1.6666665077209472, 1.1499994993209838, 1.6666665077209472, 1.1499994993209838, 1.7499998807907104, 1.1499994993209838, 1.7499998807907104, 1.2249995470046997, 1.7499998807907104, 1.1499994993209838, 1.6666665077209472, 1.1499994993209838, 1.6666665077209472, 1.074999451637268, 1.6666665077209472, 1.074999451637268, 1.7499998807907104, 1.074999451637268, 1.7499998807907104, 1.1499994993209838, 1.7499998807907104, 1.074999451637268, 1.6666665077209472, 1.074999451637268, 1.6666665077209472, 0.999999463558197, 1.6666665077209472, 0.999999463558197, 1.7499998807907104, 0.999999463558197, 1.7499998807907104, 1.074999451637268, 1.6666665077209472, 1.899999976158142, 1.583333134651184, 1.899999976158142, 1.583333134651184, 1.8249999284744262, 1.583333134651184, 1.8249999284744262, 1.6666665077209472, 1.8249999284744262, 1.6666665077209472, 1.899999976158142, 1.6666665077209472, 1.8249999284744262, 1.583333134651184, 1.8249999284744262, 1.583333134651184, 1.7499998807907104, 1.583333134651184, 1.7499998807907104, 1.6666665077209472, 1.7499998807907104, 1.6666665077209472, 1.8249999284744262, 1.6666665077209472, 1.7499998807907104, 1.583333134651184, 1.7499998807907104, 1.583333134651184, 1.6749998331069946, 1.583333134651184, 1.6749998331069946, 1.6666665077209472, 1.6749998331069946, 1.6666665077209472, 1.7499998807907104, 1.6666665077209472, 1.6749998331069946, 1.583333134651184, 1.6749998331069946, 1.583333134651184, 1.5999997854232788, 1.583333134651184, 1.5999997854232788, 1.6666665077209472, 1.5999997854232788, 1.6666665077209472, 1.6749998331069946, 1.6666665077209472, 1.5999997854232788, 1.583333134651184, 1.5999997854232788, 1.583333134651184, 1.524999737739563, 1.583333134651184, 1.524999737739563, 1.6666665077209472, 1.524999737739563, 1.6666665077209472, 1.5999997854232788, 1.6666665077209472, 1.524999737739563, 1.583333134651184, 1.524999737739563, 1.583333134651184, 1.4499996900558471, 1.583333134651184, 1.4499996900558471, 1.6666665077209472, 1.4499996900558471, 1.6666665077209472, 1.524999737739563, 1.6666665077209472, 1.4499996900558471, 1.583333134651184, 1.4499996900558471, 1.583333134651184, 1.3749996423721313, 1.583333134651184, 1.3749996423721313, 1.6666665077209472, 1.3749996423721313, 1.6666665077209472, 1.4499996900558471, 1.6666665077209472, 1.3749996423721313, 1.583333134651184, 1.3749996423721313, 1.583333134651184, 1.2999995946884155, 1.583333134651184, 1.2999995946884155, 1.6666665077209472, 1.2999995946884155, 1.6666665077209472, 1.3749996423721313, 1.6666665077209472, 1.2999995946884155, 1.583333134651184, 1.2999995946884155, 1.583333134651184, 1.2249995470046997, 1.583333134651184, 1.2249995470046997, 1.6666665077209472, 1.2249995470046997, 1.6666665077209472, 1.2999995946884155, 1.6666665077209472, 1.2249995470046997, 1.583333134651184, 1.2249995470046997, 1.583333134651184, 1.1499994993209838, 1.583333134651184, 1.1499994993209838, 1.6666665077209472, 1.1499994993209838, 1.6666665077209472, 1.2249995470046997, 1.6666665077209472, 1.1499994993209838, 1.583333134651184, 1.1499994993209838, 1.583333134651184, 1.074999451637268, 1.583333134651184, 1.074999451637268, 1.6666665077209472, 1.074999451637268, 1.6666665077209472, 1.1499994993209838, 1.6666665077209472, 1.074999451637268, 1.583333134651184, 1.074999451637268, 1.583333134651184, 0.999999463558197, 1.583333134651184, 0.999999463558197, 1.6666665077209472, 0.999999463558197, 1.6666665077209472, 1.074999451637268, 1.583333134651184, 1.899999976158142, 1.499999761581421, 1.899999976158142, 1.499999761581421, 1.8249999284744262, 1.499999761581421, 1.8249999284744262, 1.583333134651184, 1.8249999284744262, 1.583333134651184, 1.899999976158142, 1.583333134651184, 1.8249999284744262, 1.499999761581421, 1.8249999284744262, 1.499999761581421, 1.7499998807907104, 1.499999761581421, 1.7499998807907104, 1.583333134651184, 1.7499998807907104, 1.583333134651184, 1.8249999284744262, 1.583333134651184, 1.7499998807907104, 1.499999761581421, 1.7499998807907104, 1.499999761581421, 1.6749998331069946, 1.499999761581421, 1.6749998331069946, 1.583333134651184, 1.6749998331069946, 1.583333134651184, 1.7499998807907104, 1.583333134651184, 1.6749998331069946, 1.499999761581421, 1.6749998331069946, 1.499999761581421, 1.5999997854232788, 1.499999761581421, 1.5999997854232788, 1.583333134651184, 1.5999997854232788, 1.583333134651184, 1.6749998331069946, 1.583333134651184, 1.5999997854232788, 1.499999761581421, 1.5999997854232788, 1.499999761581421, 1.524999737739563, 1.499999761581421, 1.524999737739563, 1.583333134651184, 1.524999737739563, 1.583333134651184, 1.5999997854232788, 1.583333134651184, 1.524999737739563, 1.499999761581421, 1.524999737739563, 1.499999761581421, 1.4499996900558471, 1.499999761581421, 1.4499996900558471, 1.583333134651184, 1.4499996900558471, 1.583333134651184, 1.524999737739563, 1.583333134651184, 1.4499996900558471, 1.499999761581421, 1.4499996900558471, 1.499999761581421, 1.3749996423721313, 1.499999761581421, 1.3749996423721313, 1.583333134651184, 1.3749996423721313, 1.583333134651184, 1.4499996900558471, 1.583333134651184, 1.3749996423721313, 1.499999761581421, 1.3749996423721313, 1.499999761581421, 1.2999995946884155, 1.499999761581421, 1.2999995946884155, 1.583333134651184, 1.2999995946884155, 1.583333134651184, 1.3749996423721313, 1.583333134651184, 1.2999995946884155, 1.499999761581421, 1.2999995946884155, 1.499999761581421, 1.2249995470046997, 1.499999761581421, 1.2249995470046997, 1.583333134651184, 1.2249995470046997, 1.583333134651184, 1.2999995946884155, 1.583333134651184, 1.2249995470046997, 1.499999761581421, 1.2249995470046997, 1.499999761581421, 1.1499994993209838, 1.499999761581421, 1.1499994993209838, 1.583333134651184, 1.1499994993209838, 1.583333134651184, 1.2249995470046997, 1.583333134651184, 1.1499994993209838, 1.499999761581421, 1.1499994993209838, 1.499999761581421, 1.074999451637268, 1.499999761581421, 1.074999451637268, 1.583333134651184, 1.074999451637268, 1.583333134651184, 1.1499994993209838, 1.583333134651184, 1.074999451637268, 1.499999761581421, 1.074999451637268, 1.499999761581421, 0.999999463558197, 1.499999761581421, 0.999999463558197, 1.583333134651184, 0.999999463558197, 1.583333134651184, 1.074999451637268, 1.499999761581421, 1.899999976158142, 1.4166663885116577, 1.899999976158142, 1.4166663885116577, 1.8249999284744262, 1.4166663885116577, 1.8249999284744262, 1.499999761581421, 1.8249999284744262, 1.499999761581421, 1.899999976158142, 1.499999761581421, 1.8249999284744262, 1.4166663885116577, 1.8249999284744262, 1.4166663885116577, 1.7499998807907104, 1.4166663885116577, 1.7499998807907104, 1.499999761581421, 1.7499998807907104, 1.499999761581421, 1.8249999284744262, 1.499999761581421, 1.7499998807907104, 1.4166663885116577, 1.7499998807907104, 1.4166663885116577, 1.6749998331069946, 1.4166663885116577, 1.6749998331069946, 1.499999761581421, 1.6749998331069946, 1.499999761581421, 1.7499998807907104, 1.499999761581421, 1.6749998331069946, 1.4166663885116577, 1.6749998331069946, 1.4166663885116577, 1.5999997854232788, 1.4166663885116577, 1.5999997854232788, 1.499999761581421, 1.5999997854232788, 1.499999761581421, 1.6749998331069946, 1.499999761581421, 1.5999997854232788, 1.4166663885116577, 1.5999997854232788, 1.4166663885116577, 1.524999737739563, 1.4166663885116577, 1.524999737739563, 1.499999761581421, 1.524999737739563, 1.499999761581421, 1.5999997854232788, 1.499999761581421, 1.524999737739563, 1.4166663885116577, 1.524999737739563, 1.4166663885116577, 1.4499996900558471, 1.4166663885116577, 1.4499996900558471, 1.499999761581421, 1.4499996900558471, 1.499999761581421, 1.524999737739563, 1.499999761581421, 1.4499996900558471, 1.4166663885116577, 1.4499996900558471, 1.4166663885116577, 1.3749996423721313, 1.4166663885116577, 1.3749996423721313, 1.499999761581421, 1.3749996423721313, 1.499999761581421, 1.4499996900558471, 1.499999761581421, 1.3749996423721313, 1.4166663885116577, 1.3749996423721313, 1.4166663885116577, 1.2999995946884155, 1.4166663885116577, 1.2999995946884155, 1.499999761581421, 1.2999995946884155, 1.499999761581421, 1.3749996423721313, 1.499999761581421, 1.2999995946884155, 1.4166663885116577, 1.2999995946884155, 1.4166663885116577, 1.2249995470046997, 1.4166663885116577, 1.2249995470046997, 1.499999761581421, 1.2249995470046997, 1.499999761581421, 1.2999995946884155, 1.499999761581421, 1.2249995470046997, 1.4166663885116577, 1.2249995470046997, 1.4166663885116577, 1.1499994993209838, 1.4166663885116577, 1.1499994993209838, 1.499999761581421, 1.1499994993209838, 1.499999761581421, 1.2249995470046997, 1.499999761581421, 1.1499994993209838, 1.4166663885116577, 1.1499994993209838, 1.4166663885116577, 1.074999451637268, 1.4166663885116577, 1.074999451637268, 1.499999761581421, 1.074999451637268, 1.499999761581421, 1.1499994993209838, 1.499999761581421, 1.074999451637268, 1.4166663885116577, 1.074999451637268, 1.4166663885116577, 0.999999463558197, 1.4166663885116577, 0.999999463558197, 1.499999761581421, 0.999999463558197, 1.499999761581421, 1.074999451637268, 1.4166663885116577, 1.899999976158142, 1.3333330154418945, 1.899999976158142, 1.3333330154418945, 1.8249999284744262, 1.3333330154418945, 1.8249999284744262, 1.4166663885116577, 1.8249999284744262, 1.4166663885116577, 1.899999976158142, 1.4166663885116577, 1.8249999284744262, 1.3333330154418945, 1.8249999284744262, 1.3333330154418945, 1.7499998807907104, 1.3333330154418945, 1.7499998807907104, 1.4166663885116577, 1.7499998807907104, 1.4166663885116577, 1.8249999284744262, 1.4166663885116577, 1.7499998807907104, 1.3333330154418945, 1.7499998807907104, 1.3333330154418945, 1.6749998331069946, 1.3333330154418945, 1.6749998331069946, 1.4166663885116577, 1.6749998331069946, 1.4166663885116577, 1.7499998807907104, 1.4166663885116577, 1.6749998331069946, 1.3333330154418945, 1.6749998331069946, 1.3333330154418945, 1.5999997854232788, 1.3333330154418945, 1.5999997854232788, 1.4166663885116577, 1.5999997854232788, 1.4166663885116577, 1.6749998331069946, 1.4166663885116577, 1.5999997854232788, 1.3333330154418945, 1.5999997854232788, 1.3333330154418945, 1.524999737739563, 1.3333330154418945, 1.524999737739563, 1.4166663885116577, 1.524999737739563, 1.4166663885116577, 1.5999997854232788, 1.4166663885116577, 1.524999737739563, 1.3333330154418945, 1.524999737739563, 1.3333330154418945, 1.4499996900558471, 1.3333330154418945, 1.4499996900558471, 1.4166663885116577, 1.4499996900558471, 1.4166663885116577, 1.524999737739563, 1.4166663885116577, 1.4499996900558471, 1.3333330154418945, 1.4499996900558471, 1.3333330154418945, 1.3749996423721313, 1.3333330154418945, 1.3749996423721313, 1.4166663885116577, 1.3749996423721313, 1.4166663885116577, 1.4499996900558471, 1.4166663885116577, 1.3749996423721313, 1.3333330154418945, 1.3749996423721313, 1.3333330154418945, 1.2999995946884155, 1.3333330154418945, 1.2999995946884155, 1.4166663885116577, 1.2999995946884155, 1.4166663885116577, 1.3749996423721313, 1.4166663885116577, 1.2999995946884155, 1.3333330154418945, 1.2999995946884155, 1.3333330154418945, 1.2249995470046997, 1.3333330154418945, 1.2249995470046997, 1.4166663885116577, 1.2249995470046997, 1.4166663885116577, 1.2999995946884155, 1.4166663885116577, 1.2249995470046997, 1.3333330154418945, 1.2249995470046997, 1.3333330154418945, 1.1499994993209838, 1.3333330154418945, 1.1499994993209838, 1.4166663885116577, 1.1499994993209838, 1.4166663885116577, 1.2249995470046997, 1.4166663885116577, 1.1499994993209838, 1.3333330154418945, 1.1499994993209838, 1.3333330154418945, 1.074999451637268, 1.3333330154418945, 1.074999451637268, 1.4166663885116577, 1.074999451637268, 1.4166663885116577, 1.1499994993209838, 1.4166663885116577, 1.074999451637268, 1.3333330154418945, 1.074999451637268, 1.3333330154418945, 0.999999463558197, 1.3333330154418945, 0.999999463558197, 1.4166663885116577, 0.999999463558197, 1.4166663885116577, 1.074999451637268, 1.3333330154418945, 1.899999976158142, 1.2499996423721313, 1.899999976158142, 1.2499996423721313, 1.8249999284744262, 1.2499996423721313, 1.8249999284744262, 1.3333330154418945, 1.8249999284744262, 1.3333330154418945, 1.899999976158142, 1.3333330154418945, 1.8249999284744262, 1.2499996423721313, 1.8249999284744262, 1.2499996423721313, 1.7499998807907104, 1.2499996423721313, 1.7499998807907104, 1.3333330154418945, 1.7499998807907104, 1.3333330154418945, 1.8249999284744262, 1.3333330154418945, 1.7499998807907104, 1.2499996423721313, 1.7499998807907104, 1.2499996423721313, 1.6749998331069946, 1.2499996423721313, 1.6749998331069946, 1.3333330154418945, 1.6749998331069946, 1.3333330154418945, 1.7499998807907104, 1.3333330154418945, 1.6749998331069946, 1.2499996423721313, 1.6749998331069946, 1.2499996423721313, 1.5999997854232788, 1.2499996423721313, 1.5999997854232788, 1.3333330154418945, 1.5999997854232788, 1.3333330154418945, 1.6749998331069946, 1.3333330154418945, 1.5999997854232788, 1.2499996423721313, 1.5999997854232788, 1.2499996423721313, 1.524999737739563, 1.2499996423721313, 1.524999737739563, 1.3333330154418945, 1.524999737739563, 1.3333330154418945, 1.5999997854232788, 1.3333330154418945, 1.524999737739563, 1.2499996423721313, 1.524999737739563, 1.2499996423721313, 1.4499996900558471, 1.2499996423721313, 1.4499996900558471, 1.3333330154418945, 1.4499996900558471, 1.3333330154418945, 1.524999737739563, 1.3333330154418945, 1.4499996900558471, 1.2499996423721313, 1.4499996900558471, 1.2499996423721313, 1.3749996423721313, 1.2499996423721313, 1.3749996423721313, 1.3333330154418945, 1.3749996423721313, 1.3333330154418945, 1.4499996900558471, 1.3333330154418945, 1.3749996423721313, 1.2499996423721313, 1.3749996423721313, 1.2499996423721313, 1.2999995946884155, 1.2499996423721313, 1.2999995946884155, 1.3333330154418945, 1.2999995946884155, 1.3333330154418945, 1.3749996423721313, 1.3333330154418945, 1.2999995946884155, 1.2499996423721313, 1.2999995946884155, 1.2499996423721313, 1.2249995470046997, 1.2499996423721313, 1.2249995470046997, 1.3333330154418945, 1.2249995470046997, 1.3333330154418945, 1.2999995946884155, 1.3333330154418945, 1.2249995470046997, 1.2499996423721313, 1.2249995470046997, 1.2499996423721313, 1.1499994993209838, 1.2499996423721313, 1.1499994993209838, 1.3333330154418945, 1.1499994993209838, 1.3333330154418945, 1.2249995470046997, 1.3333330154418945, 1.1499994993209838, 1.2499996423721313, 1.1499994993209838, 1.2499996423721313, 1.074999451637268, 1.2499996423721313, 1.074999451637268, 1.3333330154418945, 1.074999451637268, 1.3333330154418945, 1.1499994993209838, 1.3333330154418945, 1.074999451637268, 1.2499996423721313, 1.074999451637268, 1.2499996423721313, 0.999999463558197, 1.2499996423721313, 0.999999463558197, 1.3333330154418945, 0.999999463558197, 1.3333330154418945, 1.074999451637268, 1.2499996423721313, 1.899999976158142, 1.1666662693023681, 1.899999976158142, 1.1666662693023681, 1.8249999284744262, 1.1666662693023681, 1.8249999284744262, 1.2499996423721313, 1.8249999284744262, 1.2499996423721313, 1.899999976158142, 1.2499996423721313, 1.8249999284744262, 1.1666662693023681, 1.8249999284744262, 1.1666662693023681, 1.7499998807907104, 1.1666662693023681, 1.7499998807907104, 1.2499996423721313, 1.7499998807907104, 1.2499996423721313, 1.8249999284744262, 1.2499996423721313, 1.7499998807907104, 1.1666662693023681, 1.7499998807907104, 1.1666662693023681, 1.6749998331069946, 1.1666662693023681, 1.6749998331069946, 1.2499996423721313, 1.6749998331069946, 1.2499996423721313, 1.7499998807907104, 1.2499996423721313, 1.6749998331069946, 1.1666662693023681, 1.6749998331069946, 1.1666662693023681, 1.5999997854232788, 1.1666662693023681, 1.5999997854232788, 1.2499996423721313, 1.5999997854232788, 1.2499996423721313, 1.6749998331069946, 1.2499996423721313, 1.5999997854232788, 1.1666662693023681, 1.5999997854232788, 1.1666662693023681, 1.524999737739563, 1.1666662693023681, 1.524999737739563, 1.2499996423721313, 1.524999737739563, 1.2499996423721313, 1.5999997854232788, 1.2499996423721313, 1.524999737739563, 1.1666662693023681, 1.524999737739563, 1.1666662693023681, 1.4499996900558471, 1.1666662693023681, 1.4499996900558471, 1.2499996423721313, 1.4499996900558471, 1.2499996423721313, 1.524999737739563, 1.2499996423721313, 1.4499996900558471, 1.1666662693023681, 1.4499996900558471, 1.1666662693023681, 1.3749996423721313, 1.1666662693023681, 1.3749996423721313, 1.2499996423721313, 1.3749996423721313, 1.2499996423721313, 1.4499996900558471, 1.2499996423721313, 1.3749996423721313, 1.1666662693023681, 1.3749996423721313, 1.1666662693023681, 1.2999995946884155, 1.1666662693023681, 1.2999995946884155, 1.2499996423721313, 1.2999995946884155, 1.2499996423721313, 1.3749996423721313, 1.2499996423721313, 1.2999995946884155, 1.1666662693023681, 1.2999995946884155, 1.1666662693023681, 1.2249995470046997, 1.1666662693023681, 1.2249995470046997, 1.2499996423721313, 1.2249995470046997, 1.2499996423721313, 1.2999995946884155, 1.2499996423721313, 1.2249995470046997, 1.1666662693023681, 1.2249995470046997, 1.1666662693023681, 1.1499994993209838, 1.1666662693023681, 1.1499994993209838, 1.2499996423721313, 1.1499994993209838, 1.2499996423721313, 1.2249995470046997, 1.2499996423721313, 1.1499994993209838, 1.1666662693023681, 1.1499994993209838, 1.1666662693023681, 1.074999451637268, 1.1666662693023681, 1.074999451637268, 1.2499996423721313, 1.074999451637268, 1.2499996423721313, 1.1499994993209838, 1.2499996423721313, 1.074999451637268, 1.1666662693023681, 1.074999451637268, 1.1666662693023681, 0.999999463558197, 1.1666662693023681, 0.999999463558197, 1.2499996423721313, 0.999999463558197, 1.2499996423721313, 1.074999451637268, 1.1666662693023681, 1.899999976158142, 1.083332896232605, 1.899999976158142, 1.083332896232605, 1.8249999284744262, 1.083332896232605, 1.8249999284744262, 1.1666662693023681, 1.8249999284744262, 1.1666662693023681, 1.899999976158142, 1.1666662693023681, 1.8249999284744262, 1.083332896232605, 1.8249999284744262, 1.083332896232605, 1.7499998807907104, 1.083332896232605, 1.7499998807907104, 1.1666662693023681, 1.7499998807907104, 1.1666662693023681, 1.8249999284744262, 1.1666662693023681, 1.7499998807907104, 1.083332896232605, 1.7499998807907104, 1.083332896232605, 1.6749998331069946, 1.083332896232605, 1.6749998331069946, 1.1666662693023681, 1.6749998331069946, 1.1666662693023681, 1.7499998807907104, 1.1666662693023681, 1.6749998331069946, 1.083332896232605, 1.6749998331069946, 1.083332896232605, 1.5999997854232788, 1.083332896232605, 1.5999997854232788, 1.1666662693023681, 1.5999997854232788, 1.1666662693023681, 1.6749998331069946, 1.1666662693023681, 1.5999997854232788, 1.083332896232605, 1.5999997854232788, 1.083332896232605, 1.524999737739563, 1.083332896232605, 1.524999737739563, 1.1666662693023681, 1.524999737739563, 1.1666662693023681, 1.5999997854232788, 1.1666662693023681, 1.524999737739563, 1.083332896232605, 1.524999737739563, 1.083332896232605, 1.4499996900558471, 1.083332896232605, 1.4499996900558471, 1.1666662693023681, 1.4499996900558471, 1.1666662693023681, 1.524999737739563, 1.1666662693023681, 1.4499996900558471, 1.083332896232605, 1.4499996900558471, 1.083332896232605, 1.3749996423721313, 1.083332896232605, 1.3749996423721313, 1.1666662693023681, 1.3749996423721313, 1.1666662693023681, 1.4499996900558471, 1.1666662693023681, 1.3749996423721313, 1.083332896232605, 1.3749996423721313, 1.083332896232605, 1.2999995946884155, 1.083332896232605, 1.2999995946884155, 1.1666662693023681, 1.2999995946884155, 1.1666662693023681, 1.3749996423721313, 1.1666662693023681, 1.2999995946884155, 1.083332896232605, 1.2999995946884155, 1.083332896232605, 1.2249995470046997, 1.083332896232605, 1.2249995470046997, 1.1666662693023681, 1.2249995470046997, 1.1666662693023681, 1.2999995946884155, 1.1666662693023681, 1.2249995470046997, 1.083332896232605, 1.2249995470046997, 1.083332896232605, 1.1499994993209838, 1.083332896232605, 1.1499994993209838, 1.1666662693023681, 1.1499994993209838, 1.1666662693023681, 1.2249995470046997, 1.1666662693023681, 1.1499994993209838, 1.083332896232605, 1.1499994993209838, 1.083332896232605, 1.074999451637268, 1.083332896232605, 1.074999451637268, 1.1666662693023681, 1.074999451637268, 1.1666662693023681, 1.1499994993209838, 1.1666662693023681, 1.074999451637268, 1.083332896232605, 1.074999451637268, 1.083332896232605, 0.999999463558197, 1.083332896232605, 0.999999463558197, 1.1666662693023681, 0.999999463558197, 1.1666662693023681, 1.074999451637268, 1.083332896232605, 1.899999976158142, 0.9999995827674866, 1.899999976158142, 0.9999995827674866, 1.8249999284744262, 0.9999995827674866, 1.8249999284744262, 1.083332896232605, 1.8249999284744262, 1.083332896232605, 1.899999976158142, 1.083332896232605, 1.8249999284744262, 0.9999995827674866, 1.8249999284744262, 0.9999995827674866, 1.7499998807907104, 0.9999995827674866, 1.7499998807907104, 1.083332896232605, 1.7499998807907104, 1.083332896232605, 1.8249999284744262, 1.083332896232605, 1.7499998807907104, 0.9999995827674866, 1.7499998807907104, 0.9999995827674866, 1.6749998331069946, 0.9999995827674866, 1.6749998331069946, 1.083332896232605, 1.6749998331069946, 1.083332896232605, 1.7499998807907104, 1.083332896232605, 1.6749998331069946, 0.9999995827674866, 1.6749998331069946, 0.9999995827674866, 1.5999997854232788, 0.9999995827674866, 1.5999997854232788, 1.083332896232605, 1.5999997854232788, 1.083332896232605, 1.6749998331069946, 1.083332896232605, 1.5999997854232788, 0.9999995827674866, 1.5999997854232788, 0.9999995827674866, 1.524999737739563, 0.9999995827674866, 1.524999737739563, 1.083332896232605, 1.524999737739563, 1.083332896232605, 1.5999997854232788, 1.083332896232605, 1.524999737739563, 0.9999995827674866, 1.524999737739563, 0.9999995827674866, 1.4499996900558471, 0.9999995827674866, 1.4499996900558471, 1.083332896232605, 1.4499996900558471, 1.083332896232605, 1.524999737739563, 1.083332896232605, 1.4499996900558471, 0.9999995827674866, 1.4499996900558471, 0.9999995827674866, 1.3749996423721313, 0.9999995827674866, 1.3749996423721313, 1.083332896232605, 1.3749996423721313, 1.083332896232605, 1.4499996900558471, 1.083332896232605, 1.3749996423721313, 0.9999995827674866, 1.3749996423721313, 0.9999995827674866, 1.2999995946884155, 0.9999995827674866, 1.2999995946884155, 1.083332896232605, 1.2999995946884155, 1.083332896232605, 1.3749996423721313, 1.083332896232605, 1.2999995946884155, 0.9999995827674866, 1.2999995946884155, 0.9999995827674866, 1.2249995470046997, 0.9999995827674866, 1.2249995470046997, 1.083332896232605, 1.2249995470046997, 1.083332896232605, 1.2999995946884155, 1.083332896232605, 1.2249995470046997, 0.9999995827674866, 1.2249995470046997, 0.9999995827674866, 1.1499994993209838, 0.9999995827674866, 1.1499994993209838, 1.083332896232605, 1.1499994993209838, 1.083332896232605, 1.2249995470046997, 1.083332896232605, 1.1499994993209838, 0.9999995827674866, 1.1499994993209838, 0.9999995827674866, 1.074999451637268, 0.9999995827674866, 1.074999451637268, 1.083332896232605, 1.074999451637268, 1.083332896232605, 1.1499994993209838, 1.083332896232605, 1.074999451637268, 0.9999995827674866, 1.074999451637268, 0.9999995827674866, 0.999999463558197, 0.9999995827674866, 0.999999463558197, 1.083332896232605, 0.999999463558197, 1.083332896232605, 1.074999451637268, 1, 1.899999976158142, 0.9166666865348816, 1.899999976158142, 0.9166666865348816, 1.8249999284744262, 0.9166666865348816, 1.8249999284744262, 1, 1.8249999284744262, 1, 1.899999976158142, 1, 1.8249999284744262, 0.9166666865348816, 1.8249999284744262, 0.9166666865348816, 1.7499998807907104, 0.9166666865348816, 1.7499998807907104, 1, 1.7499998807907104, 1, 1.8249999284744262, 1, 1.7499998807907104, 0.9166666865348816, 1.7499998807907104, 0.9166666865348816, 1.6749998331069946, 0.9166666865348816, 1.6749998331069946, 1, 1.6749998331069946, 1, 1.7499998807907104, 1, 1.6749998331069946, 0.9166666865348816, 1.6749998331069946, 0.9166666865348816, 1.5999997854232788, 0.9166666865348816, 1.5999997854232788, 1, 1.5999997854232788, 1, 1.6749998331069946, 1, 1.5999997854232788, 0.9166666865348816, 1.5999997854232788, 0.9166666865348816, 1.524999737739563, 0.9166666865348816, 1.524999737739563, 1, 1.524999737739563, 1, 1.5999997854232788, 1, 1.524999737739563, 0.9166666865348816, 1.524999737739563, 0.9166666865348816, 1.4499996900558471, 0.9166666865348816, 1.4499996900558471, 1, 1.4499996900558471, 1, 1.524999737739563, 1, 1.4499996900558471, 0.9166666865348816, 1.4499996900558471, 0.9166666865348816, 1.3749996423721313, 0.9166666865348816, 1.3749996423721313, 1, 1.3749996423721313, 1, 1.4499996900558471, 1, 1.3749996423721313, 0.9166666865348816, 1.3749996423721313, 0.9166666865348816, 1.2999995946884155, 0.9166666865348816, 1.2999995946884155, 1, 1.2999995946884155, 1, 1.3749996423721313, 1, 1.2999995946884155, 0.9166666865348816, 1.2999995946884155, 0.9166666865348816, 1.2249995470046997, 0.9166666865348816, 1.2249995470046997, 1, 1.2249995470046997, 1, 1.2999995946884155, 1, 1.2249995470046997, 0.9166666865348816, 1.2249995470046997, 0.9166666865348816, 1.1499994993209838, 0.9166666865348816, 1.1499994993209838, 1, 1.1499994993209838, 1, 1.2249995470046997, 1, 1.1499994993209838, 0.9166666865348816, 1.1499994993209838, 0.9166666865348816, 1.074999451637268, 0.9166666865348816, 1.074999451637268, 1, 1.074999451637268, 1, 1.1499994993209838, 1, 1.074999451637268, 0.9166666865348816, 1.074999451637268, 0.9166666865348816, 0.999999463558197, 0.9166666865348816, 0.999999463558197, 1, 0.999999463558197, 1, 1.074999451637268, 0.9166666865348816, 1.899999976158142, 0.8333333730697632, 1.899999976158142, 0.8333333730697632, 1.8249999284744262, 0.8333333730697632, 1.8249999284744262, 0.9166666865348816, 1.8249999284744262, 0.9166666865348816, 1.899999976158142, 0.9166666865348816, 1.8249999284744262, 0.8333333730697632, 1.8249999284744262, 0.8333333730697632, 1.7499998807907104, 0.8333333730697632, 1.7499998807907104, 0.9166666865348816, 1.7499998807907104, 0.9166666865348816, 1.8249999284744262, 0.9166666865348816, 1.7499998807907104, 0.8333333730697632, 1.7499998807907104, 0.8333333730697632, 1.6749998331069946, 0.8333333730697632, 1.6749998331069946, 0.9166666865348816, 1.6749998331069946, 0.9166666865348816, 1.7499998807907104, 0.9166666865348816, 1.6749998331069946, 0.8333333730697632, 1.6749998331069946, 0.8333333730697632, 1.5999997854232788, 0.8333333730697632, 1.5999997854232788, 0.9166666865348816, 1.5999997854232788, 0.9166666865348816, 1.6749998331069946, 0.9166666865348816, 1.5999997854232788, 0.8333333730697632, 1.5999997854232788, 0.8333333730697632, 1.524999737739563, 0.8333333730697632, 1.524999737739563, 0.9166666865348816, 1.524999737739563, 0.9166666865348816, 1.5999997854232788, 0.9166666865348816, 1.524999737739563, 0.8333333730697632, 1.524999737739563, 0.8333333730697632, 1.4499996900558471, 0.8333333730697632, 1.4499996900558471, 0.9166666865348816, 1.4499996900558471, 0.9166666865348816, 1.524999737739563, 0.9166666865348816, 1.4499996900558471, 0.8333333730697632, 1.4499996900558471, 0.8333333730697632, 1.3749996423721313, 0.8333333730697632, 1.3749996423721313, 0.9166666865348816, 1.3749996423721313, 0.9166666865348816, 1.4499996900558471, 0.9166666865348816, 1.3749996423721313, 0.8333333730697632, 1.3749996423721313, 0.8333333730697632, 1.2999995946884155, 0.8333333730697632, 1.2999995946884155, 0.9166666865348816, 1.2999995946884155, 0.9166666865348816, 1.3749996423721313, 0.9166666865348816, 1.2999995946884155, 0.8333333730697632, 1.2999995946884155, 0.8333333730697632, 1.2249995470046997, 0.8333333730697632, 1.2249995470046997, 0.9166666865348816, 1.2249995470046997, 0.9166666865348816, 1.2999995946884155, 0.9166666865348816, 1.2249995470046997, 0.8333333730697632, 1.2249995470046997, 0.8333333730697632, 1.1499994993209838, 0.8333333730697632, 1.1499994993209838, 0.9166666865348816, 1.1499994993209838, 0.9166666865348816, 1.2249995470046997, 0.9166666865348816, 1.1499994993209838, 0.8333333730697632, 1.1499994993209838, 0.8333333730697632, 1.074999451637268, 0.8333333730697632, 1.074999451637268, 0.9166666865348816, 1.074999451637268, 0.9166666865348816, 1.1499994993209838, 0.9166666865348816, 1.074999451637268, 0.8333333730697632, 1.074999451637268, 0.8333333730697632, 0.999999463558197, 0.8333333730697632, 0.999999463558197, 0.9166666865348816, 0.999999463558197, 0.9166666865348816, 1.074999451637268, 0.8333333730697632, 1.899999976158142, 0.7500000596046448, 1.899999976158142, 0.7500000596046448, 1.8249999284744262, 0.7500000596046448, 1.8249999284744262, 0.8333333730697632, 1.8249999284744262, 0.8333333730697632, 1.899999976158142, 0.8333333730697632, 1.8249999284744262, 0.7500000596046448, 1.8249999284744262, 0.7500000596046448, 1.7499998807907104, 0.7500000596046448, 1.7499998807907104, 0.8333333730697632, 1.7499998807907104, 0.8333333730697632, 1.8249999284744262, 0.8333333730697632, 1.7499998807907104, 0.7500000596046448, 1.7499998807907104, 0.7500000596046448, 1.6749998331069946, 0.7500000596046448, 1.6749998331069946, 0.8333333730697632, 1.6749998331069946, 0.8333333730697632, 1.7499998807907104, 0.8333333730697632, 1.6749998331069946, 0.7500000596046448, 1.6749998331069946, 0.7500000596046448, 1.5999997854232788, 0.7500000596046448, 1.5999997854232788, 0.8333333730697632, 1.5999997854232788, 0.8333333730697632, 1.6749998331069946, 0.8333333730697632, 1.5999997854232788, 0.7500000596046448, 1.5999997854232788, 0.7500000596046448, 1.524999737739563, 0.7500000596046448, 1.524999737739563, 0.8333333730697632, 1.524999737739563, 0.8333333730697632, 1.5999997854232788, 0.8333333730697632, 1.524999737739563, 0.7500000596046448, 1.524999737739563, 0.7500000596046448, 1.4499996900558471, 0.7500000596046448, 1.4499996900558471, 0.8333333730697632, 1.4499996900558471, 0.8333333730697632, 1.524999737739563, 0.8333333730697632, 1.4499996900558471, 0.7500000596046448, 1.4499996900558471, 0.7500000596046448, 1.3749996423721313, 0.7500000596046448, 1.3749996423721313, 0.8333333730697632, 1.3749996423721313, 0.8333333730697632, 1.4499996900558471, 0.8333333730697632, 1.3749996423721313, 0.7500000596046448, 1.3749996423721313, 0.7500000596046448, 1.2999995946884155, 0.7500000596046448, 1.2999995946884155, 0.8333333730697632, 1.2999995946884155, 0.8333333730697632, 1.3749996423721313, 0.8333333730697632, 1.2999995946884155, 0.7500000596046448, 1.2999995946884155, 0.7500000596046448, 1.2249995470046997, 0.7500000596046448, 1.2249995470046997, 0.8333333730697632, 1.2249995470046997, 0.8333333730697632, 1.2999995946884155, 0.8333333730697632, 1.2249995470046997, 0.7500000596046448, 1.2249995470046997, 0.7500000596046448, 1.1499994993209838, 0.7500000596046448, 1.1499994993209838, 0.8333333730697632, 1.1499994993209838, 0.8333333730697632, 1.2249995470046997, 0.8333333730697632, 1.1499994993209838, 0.7500000596046448, 1.1499994993209838, 0.7500000596046448, 1.074999451637268, 0.7500000596046448, 1.074999451637268, 0.8333333730697632, 1.074999451637268, 0.8333333730697632, 1.1499994993209838, 0.8333333730697632, 1.074999451637268, 0.7500000596046448, 1.074999451637268, 0.7500000596046448, 0.999999463558197, 0.7500000596046448, 0.999999463558197, 0.8333333730697632, 0.999999463558197, 0.8333333730697632, 1.074999451637268, 0.7500000596046448, 1.899999976158142, 0.6666667461395264, 1.899999976158142, 0.6666667461395264, 1.8249999284744262, 0.6666667461395264, 1.8249999284744262, 0.7500000596046448, 1.8249999284744262, 0.7500000596046448, 1.899999976158142, 0.7500000596046448, 1.8249999284744262, 0.6666667461395264, 1.8249999284744262, 0.6666667461395264, 1.7499998807907104, 0.6666667461395264, 1.7499998807907104, 0.7500000596046448, 1.7499998807907104, 0.7500000596046448, 1.8249999284744262, 0.7500000596046448, 1.7499998807907104, 0.6666667461395264, 1.7499998807907104, 0.6666667461395264, 1.6749998331069946, 0.6666667461395264, 1.6749998331069946, 0.7500000596046448, 1.6749998331069946, 0.7500000596046448, 1.7499998807907104, 0.7500000596046448, 1.6749998331069946, 0.6666667461395264, 1.6749998331069946, 0.6666667461395264, 1.5999997854232788, 0.6666667461395264, 1.5999997854232788, 0.7500000596046448, 1.5999997854232788, 0.7500000596046448, 1.6749998331069946, 0.7500000596046448, 1.5999997854232788, 0.6666667461395264, 1.5999997854232788, 0.6666667461395264, 1.524999737739563, 0.6666667461395264, 1.524999737739563, 0.7500000596046448, 1.524999737739563, 0.7500000596046448, 1.5999997854232788, 0.7500000596046448, 1.524999737739563, 0.6666667461395264, 1.524999737739563, 0.6666667461395264, 1.4499996900558471, 0.6666667461395264, 1.4499996900558471, 0.7500000596046448, 1.4499996900558471, 0.7500000596046448, 1.524999737739563, 0.7500000596046448, 1.4499996900558471, 0.6666667461395264, 1.4499996900558471, 0.6666667461395264, 1.3749996423721313, 0.6666667461395264, 1.3749996423721313, 0.7500000596046448, 1.3749996423721313, 0.7500000596046448, 1.4499996900558471, 0.7500000596046448, 1.3749996423721313, 0.6666667461395264, 1.3749996423721313, 0.6666667461395264, 1.2999995946884155, 0.6666667461395264, 1.2999995946884155, 0.7500000596046448, 1.2999995946884155, 0.7500000596046448, 1.3749996423721313, 0.7500000596046448, 1.2999995946884155, 0.6666667461395264, 1.2999995946884155, 0.6666667461395264, 1.2249995470046997, 0.6666667461395264, 1.2249995470046997, 0.7500000596046448, 1.2249995470046997, 0.7500000596046448, 1.2999995946884155, 0.7500000596046448, 1.2249995470046997, 0.6666667461395264, 1.2249995470046997, 0.6666667461395264, 1.1499994993209838, 0.6666667461395264, 1.1499994993209838, 0.7500000596046448, 1.1499994993209838, 0.7500000596046448, 1.2249995470046997, 0.7500000596046448, 1.1499994993209838, 0.6666667461395264, 1.1499994993209838, 0.6666667461395264, 1.074999451637268, 0.6666667461395264, 1.074999451637268, 0.7500000596046448, 1.074999451637268, 0.7500000596046448, 1.1499994993209838, 0.7500000596046448, 1.074999451637268, 0.6666667461395264, 1.074999451637268, 0.6666667461395264, 0.999999463558197, 0.6666667461395264, 0.999999463558197, 0.7500000596046448, 0.999999463558197, 0.7500000596046448, 1.074999451637268, 0.6666667461395264, 1.899999976158142, 0.583333432674408, 1.899999976158142, 0.583333432674408, 1.8249999284744262, 0.583333432674408, 1.8249999284744262, 0.6666667461395264, 1.8249999284744262, 0.6666667461395264, 1.899999976158142, 0.6666667461395264, 1.8249999284744262, 0.583333432674408, 1.8249999284744262, 0.583333432674408, 1.7499998807907104, 0.583333432674408, 1.7499998807907104, 0.6666667461395264, 1.7499998807907104, 0.6666667461395264, 1.8249999284744262, 0.6666667461395264, 1.7499998807907104, 0.583333432674408, 1.7499998807907104, 0.583333432674408, 1.6749998331069946, 0.583333432674408, 1.6749998331069946, 0.6666667461395264, 1.6749998331069946, 0.6666667461395264, 1.7499998807907104, 0.6666667461395264, 1.6749998331069946, 0.583333432674408, 1.6749998331069946, 0.583333432674408, 1.5999997854232788, 0.583333432674408, 1.5999997854232788, 0.6666667461395264, 1.5999997854232788, 0.6666667461395264, 1.6749998331069946, 0.6666667461395264, 1.5999997854232788, 0.583333432674408, 1.5999997854232788, 0.583333432674408, 1.524999737739563, 0.583333432674408, 1.524999737739563, 0.6666667461395264, 1.524999737739563, 0.6666667461395264, 1.5999997854232788, 0.6666667461395264, 1.524999737739563, 0.583333432674408, 1.524999737739563, 0.583333432674408, 1.4499996900558471, 0.583333432674408, 1.4499996900558471, 0.6666667461395264, 1.4499996900558471, 0.6666667461395264, 1.524999737739563, 0.6666667461395264, 1.4499996900558471, 0.583333432674408, 1.4499996900558471, 0.583333432674408, 1.3749996423721313, 0.583333432674408, 1.3749996423721313, 0.6666667461395264, 1.3749996423721313, 0.6666667461395264, 1.4499996900558471, 0.6666667461395264, 1.3749996423721313, 0.583333432674408, 1.3749996423721313, 0.583333432674408, 1.2999995946884155, 0.583333432674408, 1.2999995946884155, 0.6666667461395264, 1.2999995946884155, 0.6666667461395264, 1.3749996423721313, 0.6666667461395264, 1.2999995946884155, 0.583333432674408, 1.2999995946884155, 0.583333432674408, 1.2249995470046997, 0.583333432674408, 1.2249995470046997, 0.6666667461395264, 1.2249995470046997, 0.6666667461395264, 1.2999995946884155, 0.6666667461395264, 1.2249995470046997, 0.583333432674408, 1.2249995470046997, 0.583333432674408, 1.1499994993209838, 0.583333432674408, 1.1499994993209838, 0.6666667461395264, 1.1499994993209838, 0.6666667461395264, 1.2249995470046997, 0.6666667461395264, 1.1499994993209838, 0.583333432674408, 1.1499994993209838, 0.583333432674408, 1.074999451637268, 0.583333432674408, 1.074999451637268, 0.6666667461395264, 1.074999451637268, 0.6666667461395264, 1.1499994993209838, 0.6666667461395264, 1.074999451637268, 0.583333432674408, 1.074999451637268, 0.583333432674408, 0.999999463558197, 0.583333432674408, 0.999999463558197, 0.6666667461395264, 0.999999463558197, 0.6666667461395264, 1.074999451637268, 0.583333432674408, 1.899999976158142, 0.5000001192092895, 1.899999976158142, 0.5000001192092895, 1.8249999284744262, 0.5000001192092895, 1.8249999284744262, 0.583333432674408, 1.8249999284744262, 0.583333432674408, 1.899999976158142, 0.583333432674408, 1.8249999284744262, 0.5000001192092895, 1.8249999284744262, 0.5000001192092895, 1.7499998807907104, 0.5000001192092895, 1.7499998807907104, 0.583333432674408, 1.7499998807907104, 0.583333432674408, 1.8249999284744262, 0.583333432674408, 1.7499998807907104, 0.5000001192092895, 1.7499998807907104, 0.5000001192092895, 1.6749998331069946, 0.5000001192092895, 1.6749998331069946, 0.583333432674408, 1.6749998331069946, 0.583333432674408, 1.7499998807907104, 0.583333432674408, 1.6749998331069946, 0.5000001192092895, 1.6749998331069946, 0.5000001192092895, 1.5999997854232788, 0.5000001192092895, 1.5999997854232788, 0.583333432674408, 1.5999997854232788, 0.583333432674408, 1.6749998331069946, 0.583333432674408, 1.5999997854232788, 0.5000001192092895, 1.5999997854232788, 0.5000001192092895, 1.524999737739563, 0.5000001192092895, 1.524999737739563, 0.583333432674408, 1.524999737739563, 0.583333432674408, 1.5999997854232788, 0.583333432674408, 1.524999737739563, 0.5000001192092895, 1.524999737739563, 0.5000001192092895, 1.4499996900558471, 0.5000001192092895, 1.4499996900558471, 0.583333432674408, 1.4499996900558471, 0.583333432674408, 1.524999737739563, 0.583333432674408, 1.4499996900558471, 0.5000001192092895, 1.4499996900558471, 0.5000001192092895, 1.3749996423721313, 0.5000001192092895, 1.3749996423721313, 0.583333432674408, 1.3749996423721313, 0.583333432674408, 1.4499996900558471, 0.583333432674408, 1.3749996423721313, 0.5000001192092895, 1.3749996423721313, 0.5000001192092895, 1.2999995946884155, 0.5000001192092895, 1.2999995946884155, 0.583333432674408, 1.2999995946884155, 0.583333432674408, 1.3749996423721313, 0.583333432674408, 1.2999995946884155, 0.5000001192092895, 1.2999995946884155, 0.5000001192092895, 1.2249995470046997, 0.5000001192092895, 1.2249995470046997, 0.583333432674408, 1.2249995470046997, 0.583333432674408, 1.2999995946884155, 0.583333432674408, 1.2249995470046997, 0.5000001192092895, 1.2249995470046997, 0.5000001192092895, 1.1499994993209838, 0.5000001192092895, 1.1499994993209838, 0.583333432674408, 1.1499994993209838, 0.583333432674408, 1.2249995470046997, 0.583333432674408, 1.1499994993209838, 0.5000001192092895, 1.1499994993209838, 0.5000001192092895, 1.074999451637268, 0.5000001192092895, 1.074999451637268, 0.583333432674408, 1.074999451637268, 0.583333432674408, 1.1499994993209838, 0.583333432674408, 1.074999451637268, 0.5000001192092895, 1.074999451637268, 0.5000001192092895, 0.999999463558197, 0.5000001192092895, 0.999999463558197, 0.583333432674408, 0.999999463558197, 0.583333432674408, 1.074999451637268, 0.5000001192092895, 1.899999976158142, 0.41666677594184875, 1.899999976158142, 0.41666677594184875, 1.8249999284744262, 0.41666677594184875, 1.8249999284744262, 0.5000001192092895, 1.8249999284744262, 0.5000001192092895, 1.899999976158142, 0.5000001192092895, 1.8249999284744262, 0.41666677594184875, 1.8249999284744262, 0.41666677594184875, 1.7499998807907104, 0.41666677594184875, 1.7499998807907104, 0.5000001192092895, 1.7499998807907104, 0.5000001192092895, 1.8249999284744262, 0.5000001192092895, 1.7499998807907104, 0.41666677594184875, 1.7499998807907104, 0.41666677594184875, 1.6749998331069946, 0.41666677594184875, 1.6749998331069946, 0.5000001192092895, 1.6749998331069946, 0.5000001192092895, 1.7499998807907104, 0.5000001192092895, 1.6749998331069946, 0.41666677594184875, 1.6749998331069946, 0.41666677594184875, 1.5999997854232788, 0.41666677594184875, 1.5999997854232788, 0.5000001192092895, 1.5999997854232788, 0.5000001192092895, 1.6749998331069946, 0.5000001192092895, 1.5999997854232788, 0.41666677594184875, 1.5999997854232788, 0.41666677594184875, 1.524999737739563, 0.41666677594184875, 1.524999737739563, 0.5000001192092895, 1.524999737739563, 0.5000001192092895, 1.5999997854232788, 0.5000001192092895, 1.524999737739563, 0.41666677594184875, 1.524999737739563, 0.41666677594184875, 1.4499996900558471, 0.41666677594184875, 1.4499996900558471, 0.5000001192092895, 1.4499996900558471, 0.5000001192092895, 1.524999737739563, 0.5000001192092895, 1.4499996900558471, 0.41666677594184875, 1.4499996900558471, 0.41666677594184875, 1.3749996423721313, 0.41666677594184875, 1.3749996423721313, 0.5000001192092895, 1.3749996423721313, 0.5000001192092895, 1.4499996900558471, 0.5000001192092895, 1.3749996423721313, 0.41666677594184875, 1.3749996423721313, 0.41666677594184875, 1.2999995946884155, 0.41666677594184875, 1.2999995946884155, 0.5000001192092895, 1.2999995946884155, 0.5000001192092895, 1.3749996423721313, 0.5000001192092895, 1.2999995946884155, 0.41666677594184875, 1.2999995946884155, 0.41666677594184875, 1.2249995470046997, 0.41666677594184875, 1.2249995470046997, 0.5000001192092895, 1.2249995470046997, 0.5000001192092895, 1.2999995946884155, 0.5000001192092895, 1.2249995470046997, 0.41666677594184875, 1.2249995470046997, 0.41666677594184875, 1.1499994993209838, 0.41666677594184875, 1.1499994993209838, 0.5000001192092895, 1.1499994993209838, 0.5000001192092895, 1.2249995470046997, 0.5000001192092895, 1.1499994993209838, 0.41666677594184875, 1.1499994993209838, 0.41666677594184875, 1.074999451637268, 0.41666677594184875, 1.074999451637268, 0.5000001192092895, 1.074999451637268, 0.5000001192092895, 1.1499994993209838, 0.5000001192092895, 1.074999451637268, 0.41666677594184875, 1.074999451637268, 0.41666677594184875, 0.999999463558197, 0.41666677594184875, 0.999999463558197, 0.5000001192092895, 0.999999463558197, 0.5000001192092895, 1.074999451637268, 0.41666677594184875, 1.899999976158142, 0.33333343267440796, 1.899999976158142, 0.33333343267440796, 1.8249999284744262, 0.33333343267440796, 1.8249999284744262, 0.41666677594184875, 1.8249999284744262, 0.41666677594184875, 1.899999976158142, 0.41666677594184875, 1.8249999284744262, 0.33333343267440796, 1.8249999284744262, 0.33333343267440796, 1.7499998807907104, 0.33333343267440796, 1.7499998807907104, 0.41666677594184875, 1.7499998807907104, 0.41666677594184875, 1.8249999284744262, 0.41666677594184875, 1.7499998807907104, 0.33333343267440796, 1.7499998807907104, 0.33333343267440796, 1.6749998331069946, 0.33333343267440796, 1.6749998331069946, 0.41666677594184875, 1.6749998331069946, 0.41666677594184875, 1.7499998807907104, 0.41666677594184875, 1.6749998331069946, 0.33333343267440796, 1.6749998331069946, 0.33333343267440796, 1.5999997854232788, 0.33333343267440796, 1.5999997854232788, 0.41666677594184875, 1.5999997854232788, 0.41666677594184875, 1.6749998331069946, 0.41666677594184875, 1.5999997854232788, 0.33333343267440796, 1.5999997854232788, 0.33333343267440796, 1.524999737739563, 0.33333343267440796, 1.524999737739563, 0.41666677594184875, 1.524999737739563, 0.41666677594184875, 1.5999997854232788, 0.41666677594184875, 1.524999737739563, 0.33333343267440796, 1.524999737739563, 0.33333343267440796, 1.4499996900558471, 0.33333343267440796, 1.4499996900558471, 0.41666677594184875, 1.4499996900558471, 0.41666677594184875, 1.524999737739563, 0.41666677594184875, 1.4499996900558471, 0.33333343267440796, 1.4499996900558471, 0.33333343267440796, 1.3749996423721313, 0.33333343267440796, 1.3749996423721313, 0.41666677594184875, 1.3749996423721313, 0.41666677594184875, 1.4499996900558471, 0.41666677594184875, 1.3749996423721313, 0.33333343267440796, 1.3749996423721313, 0.33333343267440796, 1.2999995946884155, 0.33333343267440796, 1.2999995946884155, 0.41666677594184875, 1.2999995946884155, 0.41666677594184875, 1.3749996423721313, 0.41666677594184875, 1.2999995946884155, 0.33333343267440796, 1.2999995946884155, 0.33333343267440796, 1.2249995470046997, 0.33333343267440796, 1.2249995470046997, 0.41666677594184875, 1.2249995470046997, 0.41666677594184875, 1.2999995946884155, 0.41666677594184875, 1.2249995470046997, 0.33333343267440796, 1.2249995470046997, 0.33333343267440796, 1.1499994993209838, 0.33333343267440796, 1.1499994993209838, 0.41666677594184875, 1.1499994993209838, 0.41666677594184875, 1.2249995470046997, 0.41666677594184875, 1.1499994993209838, 0.33333343267440796, 1.1499994993209838, 0.33333343267440796, 1.074999451637268, 0.33333343267440796, 1.074999451637268, 0.41666677594184875, 1.074999451637268, 0.41666677594184875, 1.1499994993209838, 0.41666677594184875, 1.074999451637268, 0.33333343267440796, 1.074999451637268, 0.33333343267440796, 0.999999463558197, 0.33333343267440796, 0.999999463558197, 0.41666677594184875, 0.999999463558197, 0.41666677594184875, 1.074999451637268, 0.33333343267440796, 1.899999976158142, 0.25000008940696716, 1.899999976158142, 0.25000008940696716, 1.8249999284744262, 0.25000008940696716, 1.8249999284744262, 0.33333343267440796, 1.8249999284744262, 0.33333343267440796, 1.899999976158142, 0.33333343267440796, 1.8249999284744262, 0.25000008940696716, 1.8249999284744262, 0.25000008940696716, 1.7499998807907104, 0.25000008940696716, 1.7499998807907104, 0.33333343267440796, 1.7499998807907104, 0.33333343267440796, 1.8249999284744262, 0.33333343267440796, 1.7499998807907104, 0.25000008940696716, 1.7499998807907104, 0.25000008940696716, 1.6749998331069946, 0.25000008940696716, 1.6749998331069946, 0.33333343267440796, 1.6749998331069946, 0.33333343267440796, 1.7499998807907104, 0.33333343267440796, 1.6749998331069946, 0.25000008940696716, 1.6749998331069946, 0.25000008940696716, 1.5999997854232788, 0.25000008940696716, 1.5999997854232788, 0.33333343267440796, 1.5999997854232788, 0.33333343267440796, 1.6749998331069946, 0.33333343267440796, 1.5999997854232788, 0.25000008940696716, 1.5999997854232788, 0.25000008940696716, 1.524999737739563, 0.25000008940696716, 1.524999737739563, 0.33333343267440796, 1.524999737739563, 0.33333343267440796, 1.5999997854232788, 0.33333343267440796, 1.524999737739563, 0.25000008940696716, 1.524999737739563, 0.25000008940696716, 1.4499996900558471, 0.25000008940696716, 1.4499996900558471, 0.33333343267440796, 1.4499996900558471, 0.33333343267440796, 1.524999737739563, 0.33333343267440796, 1.4499996900558471, 0.25000008940696716, 1.4499996900558471, 0.25000008940696716, 1.3749996423721313, 0.25000008940696716, 1.3749996423721313, 0.33333343267440796, 1.3749996423721313, 0.33333343267440796, 1.4499996900558471, 0.33333343267440796, 1.3749996423721313, 0.25000008940696716, 1.3749996423721313, 0.25000008940696716, 1.2999995946884155, 0.25000008940696716, 1.2999995946884155, 0.33333343267440796, 1.2999995946884155, 0.33333343267440796, 1.3749996423721313, 0.33333343267440796, 1.2999995946884155, 0.25000008940696716, 1.2999995946884155, 0.25000008940696716, 1.2249995470046997, 0.25000008940696716, 1.2249995470046997, 0.33333343267440796, 1.2249995470046997, 0.33333343267440796, 1.2999995946884155, 0.33333343267440796, 1.2249995470046997, 0.25000008940696716, 1.2249995470046997, 0.25000008940696716, 1.1499994993209838, 0.25000008940696716, 1.1499994993209838, 0.33333343267440796, 1.1499994993209838, 0.33333343267440796, 1.2249995470046997, 0.33333343267440796, 1.1499994993209838, 0.25000008940696716, 1.1499994993209838, 0.25000008940696716, 1.074999451637268, 0.25000008940696716, 1.074999451637268, 0.33333343267440796, 1.074999451637268, 0.33333343267440796, 1.1499994993209838, 0.33333343267440796, 1.074999451637268, 0.25000008940696716, 1.074999451637268, 0.25000008940696716, 0.999999463558197, 0.25000008940696716, 0.999999463558197, 0.33333343267440796, 0.999999463558197, 0.33333343267440796, 1.074999451637268, 0.25000008940696716, 1.899999976158142, 0.16666674613952637, 1.899999976158142, 0.16666674613952637, 1.8249999284744262, 0.16666674613952637, 1.8249999284744262, 0.25000008940696716, 1.8249999284744262, 0.25000008940696716, 1.899999976158142, 0.25000008940696716, 1.8249999284744262, 0.16666674613952637, 1.8249999284744262, 0.16666674613952637, 1.7499998807907104, 0.16666674613952637, 1.7499998807907104, 0.25000008940696716, 1.7499998807907104, 0.25000008940696716, 1.8249999284744262, 0.25000008940696716, 1.7499998807907104, 0.16666674613952637, 1.7499998807907104, 0.16666674613952637, 1.6749998331069946, 0.16666674613952637, 1.6749998331069946, 0.25000008940696716, 1.6749998331069946, 0.25000008940696716, 1.7499998807907104, 0.25000008940696716, 1.6749998331069946, 0.16666674613952637, 1.6749998331069946, 0.16666674613952637, 1.5999997854232788, 0.16666674613952637, 1.5999997854232788, 0.25000008940696716, 1.5999997854232788, 0.25000008940696716, 1.6749998331069946, 0.25000008940696716, 1.5999997854232788, 0.16666674613952637, 1.5999997854232788, 0.16666674613952637, 1.524999737739563, 0.16666674613952637, 1.524999737739563, 0.25000008940696716, 1.524999737739563, 0.25000008940696716, 1.5999997854232788, 0.25000008940696716, 1.524999737739563, 0.16666674613952637, 1.524999737739563, 0.16666674613952637, 1.4499996900558471, 0.16666674613952637, 1.4499996900558471, 0.25000008940696716, 1.4499996900558471, 0.25000008940696716, 1.524999737739563, 0.25000008940696716, 1.4499996900558471, 0.16666674613952637, 1.4499996900558471, 0.16666674613952637, 1.3749996423721313, 0.16666674613952637, 1.3749996423721313, 0.25000008940696716, 1.3749996423721313, 0.25000008940696716, 1.4499996900558471, 0.25000008940696716, 1.3749996423721313, 0.16666674613952637, 1.3749996423721313, 0.16666674613952637, 1.2999995946884155, 0.16666674613952637, 1.2999995946884155, 0.25000008940696716, 1.2999995946884155, 0.25000008940696716, 1.3749996423721313, 0.25000008940696716, 1.2999995946884155, 0.16666674613952637, 1.2999995946884155, 0.16666674613952637, 1.2249995470046997, 0.16666674613952637, 1.2249995470046997, 0.25000008940696716, 1.2249995470046997, 0.25000008940696716, 1.2999995946884155, 0.25000008940696716, 1.2249995470046997, 0.16666674613952637, 1.2249995470046997, 0.16666674613952637, 1.1499994993209838, 0.16666674613952637, 1.1499994993209838, 0.25000008940696716, 1.1499994993209838, 0.25000008940696716, 1.2249995470046997, 0.25000008940696716, 1.1499994993209838, 0.16666674613952637, 1.1499994993209838, 0.16666674613952637, 1.074999451637268, 0.16666674613952637, 1.074999451637268, 0.25000008940696716, 1.074999451637268, 0.25000008940696716, 1.1499994993209838, 0.25000008940696716, 1.074999451637268, 0.16666674613952637, 1.074999451637268, 0.16666674613952637, 0.999999463558197, 0.16666674613952637, 0.999999463558197, 0.25000008940696716, 0.999999463558197, 0.25000008940696716, 1.074999451637268, 0.16666674613952637, 1.899999976158142, 0.08333341032266617, 1.899999976158142, 0.08333341032266617, 1.8249999284744262, 0.08333341032266617, 1.8249999284744262, 0.16666674613952637, 1.8249999284744262, 0.16666674613952637, 1.899999976158142, 0.16666674613952637, 1.8249999284744262, 0.08333341032266617, 1.8249999284744262, 0.08333341032266617, 1.7499998807907104, 0.08333341032266617, 1.7499998807907104, 0.16666674613952637, 1.7499998807907104, 0.16666674613952637, 1.8249999284744262, 0.16666674613952637, 1.7499998807907104, 0.08333341032266617, 1.7499998807907104, 0.08333341032266617, 1.6749998331069946, 0.08333341032266617, 1.6749998331069946, 0.16666674613952637, 1.6749998331069946, 0.16666674613952637, 1.7499998807907104, 0.16666674613952637, 1.6749998331069946, 0.08333341032266617, 1.6749998331069946, 0.08333341032266617, 1.5999997854232788, 0.08333341032266617, 1.5999997854232788, 0.16666674613952637, 1.5999997854232788, 0.16666674613952637, 1.6749998331069946, 0.16666674613952637, 1.5999997854232788, 0.08333341032266617, 1.5999997854232788, 0.08333341032266617, 1.524999737739563, 0.08333341032266617, 1.524999737739563, 0.16666674613952637, 1.524999737739563, 0.16666674613952637, 1.5999997854232788, 0.16666674613952637, 1.524999737739563, 0.08333341032266617, 1.524999737739563, 0.08333341032266617, 1.4499996900558471, 0.08333341032266617, 1.4499996900558471, 0.16666674613952637, 1.4499996900558471, 0.16666674613952637, 1.524999737739563, 0.16666674613952637, 1.4499996900558471, 0.08333341032266617, 1.4499996900558471, 0.08333341032266617, 1.3749996423721313, 0.08333341032266617, 1.3749996423721313, 0.16666674613952637, 1.3749996423721313, 0.16666674613952637, 1.4499996900558471, 0.16666674613952637, 1.3749996423721313, 0.08333341032266617, 1.3749996423721313, 0.08333341032266617, 1.2999995946884155, 0.08333341032266617, 1.2999995946884155, 0.16666674613952637, 1.2999995946884155, 0.16666674613952637, 1.3749996423721313, 0.16666674613952637, 1.2999995946884155, 0.08333341032266617, 1.2999995946884155, 0.08333341032266617, 1.2249995470046997, 0.08333341032266617, 1.2249995470046997, 0.16666674613952637, 1.2249995470046997, 0.16666674613952637, 1.2999995946884155, 0.16666674613952637, 1.2249995470046997, 0.08333341032266617, 1.2249995470046997, 0.08333341032266617, 1.1499994993209838, 0.08333341032266617, 1.1499994993209838, 0.16666674613952637, 1.1499994993209838, 0.16666674613952637, 1.2249995470046997, 0.16666674613952637, 1.1499994993209838, 0.08333341032266617, 1.1499994993209838, 0.08333341032266617, 1.074999451637268, 0.08333341032266617, 1.074999451637268, 0.16666674613952637, 1.074999451637268, 0.16666674613952637, 1.1499994993209838, 0.16666674613952637, 1.074999451637268, 0.08333341032266617, 1.074999451637268, 0.08333341032266617, 0.999999463558197, 0.08333341032266617, 0.999999463558197, 0.16666674613952637, 0.999999463558197, 0.16666674613952637, 1.074999451637268, 0.08333341032266617, 1.899999976158142, 7.450580596923828e-8, 1.899999976158142, 7.450580596923828e-8, 1.8249999284744262, 7.450580596923828e-8, 1.8249999284744262, 0.08333341032266617, 1.8249999284744262, 0.08333341032266617, 1.899999976158142, 0.08333341032266617, 1.8249999284744262, 7.450580596923828e-8, 1.8249999284744262, 7.450580596923828e-8, 1.7499998807907104, 7.450580596923828e-8, 1.7499998807907104, 0.08333341032266617, 1.7499998807907104, 0.08333341032266617, 1.8249999284744262, 0.08333341032266617, 1.7499998807907104, 7.450580596923828e-8, 1.7499998807907104, 7.450580596923828e-8, 1.6749998331069946, 7.450580596923828e-8, 1.6749998331069946, 0.08333341032266617, 1.6749998331069946, 0.08333341032266617, 1.7499998807907104, 0.08333341032266617, 1.6749998331069946, 7.450580596923828e-8, 1.6749998331069946, 7.450580596923828e-8, 1.5999997854232788, 7.450580596923828e-8, 1.5999997854232788, 0.08333341032266617, 1.5999997854232788, 0.08333341032266617, 1.6749998331069946, 0.08333341032266617, 1.5999997854232788, 7.450580596923828e-8, 1.5999997854232788, 7.450580596923828e-8, 1.524999737739563, 7.450580596923828e-8, 1.524999737739563, 0.08333341032266617, 1.524999737739563, 0.08333341032266617, 1.5999997854232788, 0.08333341032266617, 1.524999737739563, 7.450580596923828e-8, 1.524999737739563, 7.450580596923828e-8, 1.4499996900558471, 7.450580596923828e-8, 1.4499996900558471, 0.08333341032266617, 1.4499996900558471, 0.08333341032266617, 1.524999737739563, 0.08333341032266617, 1.4499996900558471, 7.450580596923828e-8, 1.4499996900558471, 7.450580596923828e-8, 1.3749996423721313, 7.450580596923828e-8, 1.3749996423721313, 0.08333341032266617, 1.3749996423721313, 0.08333341032266617, 1.4499996900558471, 0.08333341032266617, 1.3749996423721313, 7.450580596923828e-8, 1.3749996423721313, 7.450580596923828e-8, 1.2999995946884155, 7.450580596923828e-8, 1.2999995946884155, 0.08333341032266617, 1.2999995946884155, 0.08333341032266617, 1.3749996423721313, 0.08333341032266617, 1.2999995946884155, 7.450580596923828e-8, 1.2999995946884155, 7.450580596923828e-8, 1.2249995470046997, 7.450580596923828e-8, 1.2249995470046997, 0.08333341032266617, 1.2249995470046997, 0.08333341032266617, 1.2999995946884155, 0.08333341032266617, 1.2249995470046997, 7.450580596923828e-8, 1.2249995470046997, 7.450580596923828e-8, 1.1499994993209838, 7.450580596923828e-8, 1.1499994993209838, 0.08333341032266617, 1.1499994993209838, 0.08333341032266617, 1.2249995470046997, 0.08333341032266617, 1.1499994993209838, 7.450580596923828e-8, 1.1499994993209838, 7.450580596923828e-8, 1.074999451637268, 7.450580596923828e-8, 1.074999451637268, 0.08333341032266617, 1.074999451637268, 0.08333341032266617, 1.1499994993209838, 0.08333341032266617, 1.074999451637268, 7.450580596923828e-8, 1.074999451637268, 7.450580596923828e-8, 0.999999463558197, 7.450580596923828e-8, 0.999999463558197, 0.08333341032266617, 0.999999463558197, 0.08333341032266617, 1.074999451637268, 2, 1, 1.9166666269302368, 1, 1.9166666269302368, 0.949999988079071, 1.9166666269302368, 0.949999988079071, 2, 0.949999988079071, 2, 1, 2, 0.949999988079071, 1.9166666269302368, 0.949999988079071, 1.9166666269302368, 0.8999999761581421, 1.9166666269302368, 0.8999999761581421, 2, 0.8999999761581421, 2, 0.949999988079071, 2, 0.8999999761581421, 1.9166666269302368, 0.8999999761581421, 1.9166666269302368, 0.8499999642372131, 1.9166666269302368, 0.8499999642372131, 2, 0.8499999642372131, 2, 0.8999999761581421, 2, 0.8499999642372131, 1.9166666269302368, 0.8499999642372131, 1.9166666269302368, 0.7999999523162842, 1.9166666269302368, 0.7999999523162842, 2, 0.7999999523162842, 2, 0.8499999642372131, 2, 0.7999999523162842, 1.9166666269302368, 0.7999999523162842, 1.9166666269302368, 0.7499999403953552, 1.9166666269302368, 0.7499999403953552, 2, 0.7499999403953552, 2, 0.7999999523162842, 2, 0.7499999403953552, 1.9166666269302368, 0.7499999403953552, 1.9166666269302368, 0.6999999284744263, 1.9166666269302368, 0.6999999284744263, 2, 0.6999999284744263, 2, 0.7499999403953552, 2, 0.6999999284744263, 1.9166666269302368, 0.6999999284744263, 1.9166666269302368, 0.6499999165534973, 1.9166666269302368, 0.6499999165534973, 2, 0.6499999165534973, 2, 0.6999999284744263, 2, 0.6499999165534973, 1.9166666269302368, 0.6499999165534973, 1.9166666269302368, 0.5999999046325684, 1.9166666269302368, 0.5999999046325684, 2, 0.5999999046325684, 2, 0.6499999165534973, 2, 0.5999999046325684, 1.9166666269302368, 0.5999999046325684, 1.9166666269302368, 0.5499998927116394, 1.9166666269302368, 0.5499998927116394, 2, 0.5499998927116394, 2, 0.5999999046325684, 2, 0.5499998927116394, 1.9166666269302368, 0.5499998927116394, 1.9166666269302368, 0.49999988079071045, 1.9166666269302368, 0.49999988079071045, 2, 0.49999988079071045, 2, 0.5499998927116394, 2, 0.49999988079071045, 1.9166666269302368, 0.49999988079071045, 1.9166666269302368, 0.4499998688697815, 1.9166666269302368, 0.4499998688697815, 2, 0.4499998688697815, 2, 0.49999988079071045, 2, 0.4499998688697815, 1.9166666269302368, 0.4499998688697815, 1.9166666269302368, 0.39999985694885254, 1.9166666269302368, 0.39999985694885254, 2, 0.39999985694885254, 2, 0.4499998688697815, 1.9166666269302368, 1, 1.8333332538604736, 1, 1.8333332538604736, 0.949999988079071, 1.8333332538604736, 0.949999988079071, 1.9166666269302368, 0.949999988079071, 1.9166666269302368, 1, 1.9166666269302368, 0.949999988079071, 1.8333332538604736, 0.949999988079071, 1.8333332538604736, 0.8999999761581421, 1.8333332538604736, 0.8999999761581421, 1.9166666269302368, 0.8999999761581421, 1.9166666269302368, 0.949999988079071, 1.9166666269302368, 0.8999999761581421, 1.8333332538604736, 0.8999999761581421, 1.8333332538604736, 0.8499999642372131, 1.8333332538604736, 0.8499999642372131, 1.9166666269302368, 0.8499999642372131, 1.9166666269302368, 0.8999999761581421, 1.9166666269302368, 0.8499999642372131, 1.8333332538604736, 0.8499999642372131, 1.8333332538604736, 0.7999999523162842, 1.8333332538604736, 0.7999999523162842, 1.9166666269302368, 0.7999999523162842, 1.9166666269302368, 0.8499999642372131, 1.9166666269302368, 0.7999999523162842, 1.8333332538604736, 0.7999999523162842, 1.8333332538604736, 0.7499999403953552, 1.8333332538604736, 0.7499999403953552, 1.9166666269302368, 0.7499999403953552, 1.9166666269302368, 0.7999999523162842, 1.9166666269302368, 0.7499999403953552, 1.8333332538604736, 0.7499999403953552, 1.8333332538604736, 0.6999999284744263, 1.8333332538604736, 0.6999999284744263, 1.9166666269302368, 0.6999999284744263, 1.9166666269302368, 0.7499999403953552, 1.9166666269302368, 0.6999999284744263, 1.8333332538604736, 0.6999999284744263, 1.8333332538604736, 0.6499999165534973, 1.8333332538604736, 0.6499999165534973, 1.9166666269302368, 0.6499999165534973, 1.9166666269302368, 0.6999999284744263, 1.9166666269302368, 0.6499999165534973, 1.8333332538604736, 0.6499999165534973, 1.8333332538604736, 0.5999999046325684, 1.8333332538604736, 0.5999999046325684, 1.9166666269302368, 0.5999999046325684, 1.9166666269302368, 0.6499999165534973, 1.9166666269302368, 0.5999999046325684, 1.8333332538604736, 0.5999999046325684, 1.8333332538604736, 0.5499998927116394, 1.8333332538604736, 0.5499998927116394, 1.9166666269302368, 0.5499998927116394, 1.9166666269302368, 0.5999999046325684, 1.9166666269302368, 0.5499998927116394, 1.8333332538604736, 0.5499998927116394, 1.8333332538604736, 0.49999988079071045, 1.8333332538604736, 0.49999988079071045, 1.9166666269302368, 0.49999988079071045, 1.9166666269302368, 0.5499998927116394, 1.9166666269302368, 0.49999988079071045, 1.8333332538604736, 0.49999988079071045, 1.8333332538604736, 0.4499998688697815, 1.8333332538604736, 0.4499998688697815, 1.9166666269302368, 0.4499998688697815, 1.9166666269302368, 0.49999988079071045, 1.9166666269302368, 0.4499998688697815, 1.8333332538604736, 0.4499998688697815, 1.8333332538604736, 0.39999985694885254, 1.8333332538604736, 0.39999985694885254, 1.9166666269302368, 0.39999985694885254, 1.9166666269302368, 0.4499998688697815, 1.8333332538604736, 1, 1.7499998807907104, 1, 1.7499998807907104, 0.949999988079071, 1.7499998807907104, 0.949999988079071, 1.8333332538604736, 0.949999988079071, 1.8333332538604736, 1, 1.8333332538604736, 0.949999988079071, 1.7499998807907104, 0.949999988079071, 1.7499998807907104, 0.8999999761581421, 1.7499998807907104, 0.8999999761581421, 1.8333332538604736, 0.8999999761581421, 1.8333332538604736, 0.949999988079071, 1.8333332538604736, 0.8999999761581421, 1.7499998807907104, 0.8999999761581421, 1.7499998807907104, 0.8499999642372131, 1.7499998807907104, 0.8499999642372131, 1.8333332538604736, 0.8499999642372131, 1.8333332538604736, 0.8999999761581421, 1.8333332538604736, 0.8499999642372131, 1.7499998807907104, 0.8499999642372131, 1.7499998807907104, 0.7999999523162842, 1.7499998807907104, 0.7999999523162842, 1.8333332538604736, 0.7999999523162842, 1.8333332538604736, 0.8499999642372131, 1.8333332538604736, 0.7999999523162842, 1.7499998807907104, 0.7999999523162842, 1.7499998807907104, 0.7499999403953552, 1.7499998807907104, 0.7499999403953552, 1.8333332538604736, 0.7499999403953552, 1.8333332538604736, 0.7999999523162842, 1.8333332538604736, 0.7499999403953552, 1.7499998807907104, 0.7499999403953552, 1.7499998807907104, 0.6999999284744263, 1.7499998807907104, 0.6999999284744263, 1.8333332538604736, 0.6999999284744263, 1.8333332538604736, 0.7499999403953552, 1.8333332538604736, 0.6999999284744263, 1.7499998807907104, 0.6999999284744263, 1.7499998807907104, 0.6499999165534973, 1.7499998807907104, 0.6499999165534973, 1.8333332538604736, 0.6499999165534973, 1.8333332538604736, 0.6999999284744263, 1.8333332538604736, 0.6499999165534973, 1.7499998807907104, 0.6499999165534973, 1.7499998807907104, 0.5999999046325684, 1.7499998807907104, 0.5999999046325684, 1.8333332538604736, 0.5999999046325684, 1.8333332538604736, 0.6499999165534973, 1.8333332538604736, 0.5999999046325684, 1.7499998807907104, 0.5999999046325684, 1.7499998807907104, 0.5499998927116394, 1.7499998807907104, 0.5499998927116394, 1.8333332538604736, 0.5499998927116394, 1.8333332538604736, 0.5999999046325684, 1.8333332538604736, 0.5499998927116394, 1.7499998807907104, 0.5499998927116394, 1.7499998807907104, 0.49999988079071045, 1.7499998807907104, 0.49999988079071045, 1.8333332538604736, 0.49999988079071045, 1.8333332538604736, 0.5499998927116394, 1.8333332538604736, 0.49999988079071045, 1.7499998807907104, 0.49999988079071045, 1.7499998807907104, 0.4499998688697815, 1.7499998807907104, 0.4499998688697815, 1.8333332538604736, 0.4499998688697815, 1.8333332538604736, 0.49999988079071045, 1.8333332538604736, 0.4499998688697815, 1.7499998807907104, 0.4499998688697815, 1.7499998807907104, 0.39999985694885254, 1.7499998807907104, 0.39999985694885254, 1.8333332538604736, 0.39999985694885254, 1.8333332538604736, 0.4499998688697815, 1.7499998807907104, 1, 1.6666665077209472, 1, 1.6666665077209472, 0.949999988079071, 1.6666665077209472, 0.949999988079071, 1.7499998807907104, 0.949999988079071, 1.7499998807907104, 1, 1.7499998807907104, 0.949999988079071, 1.6666665077209472, 0.949999988079071, 1.6666665077209472, 0.8999999761581421, 1.6666665077209472, 0.8999999761581421, 1.7499998807907104, 0.8999999761581421, 1.7499998807907104, 0.949999988079071, 1.7499998807907104, 0.8999999761581421, 1.6666665077209472, 0.8999999761581421, 1.6666665077209472, 0.8499999642372131, 1.6666665077209472, 0.8499999642372131, 1.7499998807907104, 0.8499999642372131, 1.7499998807907104, 0.8999999761581421, 1.7499998807907104, 0.8499999642372131, 1.6666665077209472, 0.8499999642372131, 1.6666665077209472, 0.7999999523162842, 1.6666665077209472, 0.7999999523162842, 1.7499998807907104, 0.7999999523162842, 1.7499998807907104, 0.8499999642372131, 1.7499998807907104, 0.7999999523162842, 1.6666665077209472, 0.7999999523162842, 1.6666665077209472, 0.7499999403953552, 1.6666665077209472, 0.7499999403953552, 1.7499998807907104, 0.7499999403953552, 1.7499998807907104, 0.7999999523162842, 1.7499998807907104, 0.7499999403953552, 1.6666665077209472, 0.7499999403953552, 1.6666665077209472, 0.6999999284744263, 1.6666665077209472, 0.6999999284744263, 1.7499998807907104, 0.6999999284744263, 1.7499998807907104, 0.7499999403953552, 1.7499998807907104, 0.6999999284744263, 1.6666665077209472, 0.6999999284744263, 1.6666665077209472, 0.6499999165534973, 1.6666665077209472, 0.6499999165534973, 1.7499998807907104, 0.6499999165534973, 1.7499998807907104, 0.6999999284744263, 1.7499998807907104, 0.6499999165534973, 1.6666665077209472, 0.6499999165534973, 1.6666665077209472, 0.5999999046325684, 1.6666665077209472, 0.5999999046325684, 1.7499998807907104, 0.5999999046325684, 1.7499998807907104, 0.6499999165534973, 1.7499998807907104, 0.5999999046325684, 1.6666665077209472, 0.5999999046325684, 1.6666665077209472, 0.5499998927116394, 1.6666665077209472, 0.5499998927116394, 1.7499998807907104, 0.5499998927116394, 1.7499998807907104, 0.5999999046325684, 1.7499998807907104, 0.5499998927116394, 1.6666665077209472, 0.5499998927116394, 1.6666665077209472, 0.49999988079071045, 1.6666665077209472, 0.49999988079071045, 1.7499998807907104, 0.49999988079071045, 1.7499998807907104, 0.5499998927116394, 1.7499998807907104, 0.49999988079071045, 1.6666665077209472, 0.49999988079071045, 1.6666665077209472, 0.4499998688697815, 1.6666665077209472, 0.4499998688697815, 1.7499998807907104, 0.4499998688697815, 1.7499998807907104, 0.49999988079071045, 1.7499998807907104, 0.4499998688697815, 1.6666665077209472, 0.4499998688697815, 1.6666665077209472, 0.39999985694885254, 1.6666665077209472, 0.39999985694885254, 1.7499998807907104, 0.39999985694885254, 1.7499998807907104, 0.4499998688697815, 1.6666665077209472, 1, 1.583333134651184, 1, 1.583333134651184, 0.949999988079071, 1.583333134651184, 0.949999988079071, 1.6666665077209472, 0.949999988079071, 1.6666665077209472, 1, 1.6666665077209472, 0.949999988079071, 1.583333134651184, 0.949999988079071, 1.583333134651184, 0.8999999761581421, 1.583333134651184, 0.8999999761581421, 1.6666665077209472, 0.8999999761581421, 1.6666665077209472, 0.949999988079071, 1.6666665077209472, 0.8999999761581421, 1.583333134651184, 0.8999999761581421, 1.583333134651184, 0.8499999642372131, 1.583333134651184, 0.8499999642372131, 1.6666665077209472, 0.8499999642372131, 1.6666665077209472, 0.8999999761581421, 1.6666665077209472, 0.8499999642372131, 1.583333134651184, 0.8499999642372131, 1.583333134651184, 0.7999999523162842, 1.583333134651184, 0.7999999523162842, 1.6666665077209472, 0.7999999523162842, 1.6666665077209472, 0.8499999642372131, 1.6666665077209472, 0.7999999523162842, 1.583333134651184, 0.7999999523162842, 1.583333134651184, 0.7499999403953552, 1.583333134651184, 0.7499999403953552, 1.6666665077209472, 0.7499999403953552, 1.6666665077209472, 0.7999999523162842, 1.6666665077209472, 0.7499999403953552, 1.583333134651184, 0.7499999403953552, 1.583333134651184, 0.6999999284744263, 1.583333134651184, 0.6999999284744263, 1.6666665077209472, 0.6999999284744263, 1.6666665077209472, 0.7499999403953552, 1.6666665077209472, 0.6999999284744263, 1.583333134651184, 0.6999999284744263, 1.583333134651184, 0.6499999165534973, 1.583333134651184, 0.6499999165534973, 1.6666665077209472, 0.6499999165534973, 1.6666665077209472, 0.6999999284744263, 1.6666665077209472, 0.6499999165534973, 1.583333134651184, 0.6499999165534973, 1.583333134651184, 0.5999999046325684, 1.583333134651184, 0.5999999046325684, 1.6666665077209472, 0.5999999046325684, 1.6666665077209472, 0.6499999165534973, 1.6666665077209472, 0.5999999046325684, 1.583333134651184, 0.5999999046325684, 1.583333134651184, 0.5499998927116394, 1.583333134651184, 0.5499998927116394, 1.6666665077209472, 0.5499998927116394, 1.6666665077209472, 0.5999999046325684, 1.6666665077209472, 0.5499998927116394, 1.583333134651184, 0.5499998927116394, 1.583333134651184, 0.49999988079071045, 1.583333134651184, 0.49999988079071045, 1.6666665077209472, 0.49999988079071045, 1.6666665077209472, 0.5499998927116394, 1.6666665077209472, 0.49999988079071045, 1.583333134651184, 0.49999988079071045, 1.583333134651184, 0.4499998688697815, 1.583333134651184, 0.4499998688697815, 1.6666665077209472, 0.4499998688697815, 1.6666665077209472, 0.49999988079071045, 1.6666665077209472, 0.4499998688697815, 1.583333134651184, 0.4499998688697815, 1.583333134651184, 0.39999985694885254, 1.583333134651184, 0.39999985694885254, 1.6666665077209472, 0.39999985694885254, 1.6666665077209472, 0.4499998688697815, 1.583333134651184, 1, 1.499999761581421, 1, 1.499999761581421, 0.949999988079071, 1.499999761581421, 0.949999988079071, 1.583333134651184, 0.949999988079071, 1.583333134651184, 1, 1.583333134651184, 0.949999988079071, 1.499999761581421, 0.949999988079071, 1.499999761581421, 0.8999999761581421, 1.499999761581421, 0.8999999761581421, 1.583333134651184, 0.8999999761581421, 1.583333134651184, 0.949999988079071, 1.583333134651184, 0.8999999761581421, 1.499999761581421, 0.8999999761581421, 1.499999761581421, 0.8499999642372131, 1.499999761581421, 0.8499999642372131, 1.583333134651184, 0.8499999642372131, 1.583333134651184, 0.8999999761581421, 1.583333134651184, 0.8499999642372131, 1.499999761581421, 0.8499999642372131, 1.499999761581421, 0.7999999523162842, 1.499999761581421, 0.7999999523162842, 1.583333134651184, 0.7999999523162842, 1.583333134651184, 0.8499999642372131, 1.583333134651184, 0.7999999523162842, 1.499999761581421, 0.7999999523162842, 1.499999761581421, 0.7499999403953552, 1.499999761581421, 0.7499999403953552, 1.583333134651184, 0.7499999403953552, 1.583333134651184, 0.7999999523162842, 1.583333134651184, 0.7499999403953552, 1.499999761581421, 0.7499999403953552, 1.499999761581421, 0.6999999284744263, 1.499999761581421, 0.6999999284744263, 1.583333134651184, 0.6999999284744263, 1.583333134651184, 0.7499999403953552, 1.583333134651184, 0.6999999284744263, 1.499999761581421, 0.6999999284744263, 1.499999761581421, 0.6499999165534973, 1.499999761581421, 0.6499999165534973, 1.583333134651184, 0.6499999165534973, 1.583333134651184, 0.6999999284744263, 1.583333134651184, 0.6499999165534973, 1.499999761581421, 0.6499999165534973, 1.499999761581421, 0.5999999046325684, 1.499999761581421, 0.5999999046325684, 1.583333134651184, 0.5999999046325684, 1.583333134651184, 0.6499999165534973, 1.583333134651184, 0.5999999046325684, 1.499999761581421, 0.5999999046325684, 1.499999761581421, 0.5499998927116394, 1.499999761581421, 0.5499998927116394, 1.583333134651184, 0.5499998927116394, 1.583333134651184, 0.5999999046325684, 1.583333134651184, 0.5499998927116394, 1.499999761581421, 0.5499998927116394, 1.499999761581421, 0.49999988079071045, 1.499999761581421, 0.49999988079071045, 1.583333134651184, 0.49999988079071045, 1.583333134651184, 0.5499998927116394, 1.583333134651184, 0.49999988079071045, 1.499999761581421, 0.49999988079071045, 1.499999761581421, 0.4499998688697815, 1.499999761581421, 0.4499998688697815, 1.583333134651184, 0.4499998688697815, 1.583333134651184, 0.49999988079071045, 1.583333134651184, 0.4499998688697815, 1.499999761581421, 0.4499998688697815, 1.499999761581421, 0.39999985694885254, 1.499999761581421, 0.39999985694885254, 1.583333134651184, 0.39999985694885254, 1.583333134651184, 0.4499998688697815, 1.499999761581421, 1, 1.4166663885116577, 1, 1.4166663885116577, 0.949999988079071, 1.4166663885116577, 0.949999988079071, 1.499999761581421, 0.949999988079071, 1.499999761581421, 1, 1.499999761581421, 0.949999988079071, 1.4166663885116577, 0.949999988079071, 1.4166663885116577, 0.8999999761581421, 1.4166663885116577, 0.8999999761581421, 1.499999761581421, 0.8999999761581421, 1.499999761581421, 0.949999988079071, 1.499999761581421, 0.8999999761581421, 1.4166663885116577, 0.8999999761581421, 1.4166663885116577, 0.8499999642372131, 1.4166663885116577, 0.8499999642372131, 1.499999761581421, 0.8499999642372131, 1.499999761581421, 0.8999999761581421, 1.499999761581421, 0.8499999642372131, 1.4166663885116577, 0.8499999642372131, 1.4166663885116577, 0.7999999523162842, 1.4166663885116577, 0.7999999523162842, 1.499999761581421, 0.7999999523162842, 1.499999761581421, 0.8499999642372131, 1.499999761581421, 0.7999999523162842, 1.4166663885116577, 0.7999999523162842, 1.4166663885116577, 0.7499999403953552, 1.4166663885116577, 0.7499999403953552, 1.499999761581421, 0.7499999403953552, 1.499999761581421, 0.7999999523162842, 1.499999761581421, 0.7499999403953552, 1.4166663885116577, 0.7499999403953552, 1.4166663885116577, 0.6999999284744263, 1.4166663885116577, 0.6999999284744263, 1.499999761581421, 0.6999999284744263, 1.499999761581421, 0.7499999403953552, 1.499999761581421, 0.6999999284744263, 1.4166663885116577, 0.6999999284744263, 1.4166663885116577, 0.6499999165534973, 1.4166663885116577, 0.6499999165534973, 1.499999761581421, 0.6499999165534973, 1.499999761581421, 0.6999999284744263, 1.499999761581421, 0.6499999165534973, 1.4166663885116577, 0.6499999165534973, 1.4166663885116577, 0.5999999046325684, 1.4166663885116577, 0.5999999046325684, 1.499999761581421, 0.5999999046325684, 1.499999761581421, 0.6499999165534973, 1.499999761581421, 0.5999999046325684, 1.4166663885116577, 0.5999999046325684, 1.4166663885116577, 0.5499998927116394, 1.4166663885116577, 0.5499998927116394, 1.499999761581421, 0.5499998927116394, 1.499999761581421, 0.5999999046325684, 1.499999761581421, 0.5499998927116394, 1.4166663885116577, 0.5499998927116394, 1.4166663885116577, 0.49999988079071045, 1.4166663885116577, 0.49999988079071045, 1.499999761581421, 0.49999988079071045, 1.499999761581421, 0.5499998927116394, 1.499999761581421, 0.49999988079071045, 1.4166663885116577, 0.49999988079071045, 1.4166663885116577, 0.4499998688697815, 1.4166663885116577, 0.4499998688697815, 1.499999761581421, 0.4499998688697815, 1.499999761581421, 0.49999988079071045, 1.499999761581421, 0.4499998688697815, 1.4166663885116577, 0.4499998688697815, 1.4166663885116577, 0.39999985694885254, 1.4166663885116577, 0.39999985694885254, 1.499999761581421, 0.39999985694885254, 1.499999761581421, 0.4499998688697815, 1.4166663885116577, 1, 1.3333330154418945, 1, 1.3333330154418945, 0.949999988079071, 1.3333330154418945, 0.949999988079071, 1.4166663885116577, 0.949999988079071, 1.4166663885116577, 1, 1.4166663885116577, 0.949999988079071, 1.3333330154418945, 0.949999988079071, 1.3333330154418945, 0.8999999761581421, 1.3333330154418945, 0.8999999761581421, 1.4166663885116577, 0.8999999761581421, 1.4166663885116577, 0.949999988079071, 1.4166663885116577, 0.8999999761581421, 1.3333330154418945, 0.8999999761581421, 1.3333330154418945, 0.8499999642372131, 1.3333330154418945, 0.8499999642372131, 1.4166663885116577, 0.8499999642372131, 1.4166663885116577, 0.8999999761581421, 1.4166663885116577, 0.8499999642372131, 1.3333330154418945, 0.8499999642372131, 1.3333330154418945, 0.7999999523162842, 1.3333330154418945, 0.7999999523162842, 1.4166663885116577, 0.7999999523162842, 1.4166663885116577, 0.8499999642372131, 1.4166663885116577, 0.7999999523162842, 1.3333330154418945, 0.7999999523162842, 1.3333330154418945, 0.7499999403953552, 1.3333330154418945, 0.7499999403953552, 1.4166663885116577, 0.7499999403953552, 1.4166663885116577, 0.7999999523162842, 1.4166663885116577, 0.7499999403953552, 1.3333330154418945, 0.7499999403953552, 1.3333330154418945, 0.6999999284744263, 1.3333330154418945, 0.6999999284744263, 1.4166663885116577, 0.6999999284744263, 1.4166663885116577, 0.7499999403953552, 1.4166663885116577, 0.6999999284744263, 1.3333330154418945, 0.6999999284744263, 1.3333330154418945, 0.6499999165534973, 1.3333330154418945, 0.6499999165534973, 1.4166663885116577, 0.6499999165534973, 1.4166663885116577, 0.6999999284744263, 1.4166663885116577, 0.6499999165534973, 1.3333330154418945, 0.6499999165534973, 1.3333330154418945, 0.5999999046325684, 1.3333330154418945, 0.5999999046325684, 1.4166663885116577, 0.5999999046325684, 1.4166663885116577, 0.6499999165534973, 1.4166663885116577, 0.5999999046325684, 1.3333330154418945, 0.5999999046325684, 1.3333330154418945, 0.5499998927116394, 1.3333330154418945, 0.5499998927116394, 1.4166663885116577, 0.5499998927116394, 1.4166663885116577, 0.5999999046325684, 1.4166663885116577, 0.5499998927116394, 1.3333330154418945, 0.5499998927116394, 1.3333330154418945, 0.49999988079071045, 1.3333330154418945, 0.49999988079071045, 1.4166663885116577, 0.49999988079071045, 1.4166663885116577, 0.5499998927116394, 1.4166663885116577, 0.49999988079071045, 1.3333330154418945, 0.49999988079071045, 1.3333330154418945, 0.4499998688697815, 1.3333330154418945, 0.4499998688697815, 1.4166663885116577, 0.4499998688697815, 1.4166663885116577, 0.49999988079071045, 1.4166663885116577, 0.4499998688697815, 1.3333330154418945, 0.4499998688697815, 1.3333330154418945, 0.39999985694885254, 1.3333330154418945, 0.39999985694885254, 1.4166663885116577, 0.39999985694885254, 1.4166663885116577, 0.4499998688697815, 1.3333330154418945, 1, 1.2499996423721313, 1, 1.2499996423721313, 0.949999988079071, 1.2499996423721313, 0.949999988079071, 1.3333330154418945, 0.949999988079071, 1.3333330154418945, 1, 1.3333330154418945, 0.949999988079071, 1.2499996423721313, 0.949999988079071, 1.2499996423721313, 0.8999999761581421, 1.2499996423721313, 0.8999999761581421, 1.3333330154418945, 0.8999999761581421, 1.3333330154418945, 0.949999988079071, 1.3333330154418945, 0.8999999761581421, 1.2499996423721313, 0.8999999761581421, 1.2499996423721313, 0.8499999642372131, 1.2499996423721313, 0.8499999642372131, 1.3333330154418945, 0.8499999642372131, 1.3333330154418945, 0.8999999761581421, 1.3333330154418945, 0.8499999642372131, 1.2499996423721313, 0.8499999642372131, 1.2499996423721313, 0.7999999523162842, 1.2499996423721313, 0.7999999523162842, 1.3333330154418945, 0.7999999523162842, 1.3333330154418945, 0.8499999642372131, 1.3333330154418945, 0.7999999523162842, 1.2499996423721313, 0.7999999523162842, 1.2499996423721313, 0.7499999403953552, 1.2499996423721313, 0.7499999403953552, 1.3333330154418945, 0.7499999403953552, 1.3333330154418945, 0.7999999523162842, 1.3333330154418945, 0.7499999403953552, 1.2499996423721313, 0.7499999403953552, 1.2499996423721313, 0.6999999284744263, 1.2499996423721313, 0.6999999284744263, 1.3333330154418945, 0.6999999284744263, 1.3333330154418945, 0.7499999403953552, 1.3333330154418945, 0.6999999284744263, 1.2499996423721313, 0.6999999284744263, 1.2499996423721313, 0.6499999165534973, 1.2499996423721313, 0.6499999165534973, 1.3333330154418945, 0.6499999165534973, 1.3333330154418945, 0.6999999284744263, 1.3333330154418945, 0.6499999165534973, 1.2499996423721313, 0.6499999165534973, 1.2499996423721313, 0.5999999046325684, 1.2499996423721313, 0.5999999046325684, 1.3333330154418945, 0.5999999046325684, 1.3333330154418945, 0.6499999165534973, 1.3333330154418945, 0.5999999046325684, 1.2499996423721313, 0.5999999046325684, 1.2499996423721313, 0.5499998927116394, 1.2499996423721313, 0.5499998927116394, 1.3333330154418945, 0.5499998927116394, 1.3333330154418945, 0.5999999046325684, 1.3333330154418945, 0.5499998927116394, 1.2499996423721313, 0.5499998927116394, 1.2499996423721313, 0.49999988079071045, 1.2499996423721313, 0.49999988079071045, 1.3333330154418945, 0.49999988079071045, 1.3333330154418945, 0.5499998927116394, 1.3333330154418945, 0.49999988079071045, 1.2499996423721313, 0.49999988079071045, 1.2499996423721313, 0.4499998688697815, 1.2499996423721313, 0.4499998688697815, 1.3333330154418945, 0.4499998688697815, 1.3333330154418945, 0.49999988079071045, 1.3333330154418945, 0.4499998688697815, 1.2499996423721313, 0.4499998688697815, 1.2499996423721313, 0.39999985694885254, 1.2499996423721313, 0.39999985694885254, 1.3333330154418945, 0.39999985694885254, 1.3333330154418945, 0.4499998688697815, 1.2499996423721313, 1, 1.1666662693023681, 1, 1.1666662693023681, 0.949999988079071, 1.1666662693023681, 0.949999988079071, 1.2499996423721313, 0.949999988079071, 1.2499996423721313, 1, 1.2499996423721313, 0.949999988079071, 1.1666662693023681, 0.949999988079071, 1.1666662693023681, 0.8999999761581421, 1.1666662693023681, 0.8999999761581421, 1.2499996423721313, 0.8999999761581421, 1.2499996423721313, 0.949999988079071, 1.2499996423721313, 0.8999999761581421, 1.1666662693023681, 0.8999999761581421, 1.1666662693023681, 0.8499999642372131, 1.1666662693023681, 0.8499999642372131, 1.2499996423721313, 0.8499999642372131, 1.2499996423721313, 0.8999999761581421, 1.2499996423721313, 0.8499999642372131, 1.1666662693023681, 0.8499999642372131, 1.1666662693023681, 0.7999999523162842, 1.1666662693023681, 0.7999999523162842, 1.2499996423721313, 0.7999999523162842, 1.2499996423721313, 0.8499999642372131, 1.2499996423721313, 0.7999999523162842, 1.1666662693023681, 0.7999999523162842, 1.1666662693023681, 0.7499999403953552, 1.1666662693023681, 0.7499999403953552, 1.2499996423721313, 0.7499999403953552, 1.2499996423721313, 0.7999999523162842, 1.2499996423721313, 0.7499999403953552, 1.1666662693023681, 0.7499999403953552, 1.1666662693023681, 0.6999999284744263, 1.1666662693023681, 0.6999999284744263, 1.2499996423721313, 0.6999999284744263, 1.2499996423721313, 0.7499999403953552, 1.2499996423721313, 0.6999999284744263, 1.1666662693023681, 0.6999999284744263, 1.1666662693023681, 0.6499999165534973, 1.1666662693023681, 0.6499999165534973, 1.2499996423721313, 0.6499999165534973, 1.2499996423721313, 0.6999999284744263, 1.2499996423721313, 0.6499999165534973, 1.1666662693023681, 0.6499999165534973, 1.1666662693023681, 0.5999999046325684, 1.1666662693023681, 0.5999999046325684, 1.2499996423721313, 0.5999999046325684, 1.2499996423721313, 0.6499999165534973, 1.2499996423721313, 0.5999999046325684, 1.1666662693023681, 0.5999999046325684, 1.1666662693023681, 0.5499998927116394, 1.1666662693023681, 0.5499998927116394, 1.2499996423721313, 0.5499998927116394, 1.2499996423721313, 0.5999999046325684, 1.2499996423721313, 0.5499998927116394, 1.1666662693023681, 0.5499998927116394, 1.1666662693023681, 0.49999988079071045, 1.1666662693023681, 0.49999988079071045, 1.2499996423721313, 0.49999988079071045, 1.2499996423721313, 0.5499998927116394, 1.2499996423721313, 0.49999988079071045, 1.1666662693023681, 0.49999988079071045, 1.1666662693023681, 0.4499998688697815, 1.1666662693023681, 0.4499998688697815, 1.2499996423721313, 0.4499998688697815, 1.2499996423721313, 0.49999988079071045, 1.2499996423721313, 0.4499998688697815, 1.1666662693023681, 0.4499998688697815, 1.1666662693023681, 0.39999985694885254, 1.1666662693023681, 0.39999985694885254, 1.2499996423721313, 0.39999985694885254, 1.2499996423721313, 0.4499998688697815, 1.1666662693023681, 1, 1.083332896232605, 1, 1.083332896232605, 0.949999988079071, 1.083332896232605, 0.949999988079071, 1.1666662693023681, 0.949999988079071, 1.1666662693023681, 1, 1.1666662693023681, 0.949999988079071, 1.083332896232605, 0.949999988079071, 1.083332896232605, 0.8999999761581421, 1.083332896232605, 0.8999999761581421, 1.1666662693023681, 0.8999999761581421, 1.1666662693023681, 0.949999988079071, 1.1666662693023681, 0.8999999761581421, 1.083332896232605, 0.8999999761581421, 1.083332896232605, 0.8499999642372131, 1.083332896232605, 0.8499999642372131, 1.1666662693023681, 0.8499999642372131, 1.1666662693023681, 0.8999999761581421, 1.1666662693023681, 0.8499999642372131, 1.083332896232605, 0.8499999642372131, 1.083332896232605, 0.7999999523162842, 1.083332896232605, 0.7999999523162842, 1.1666662693023681, 0.7999999523162842, 1.1666662693023681, 0.8499999642372131, 1.1666662693023681, 0.7999999523162842, 1.083332896232605, 0.7999999523162842, 1.083332896232605, 0.7499999403953552, 1.083332896232605, 0.7499999403953552, 1.1666662693023681, 0.7499999403953552, 1.1666662693023681, 0.7999999523162842, 1.1666662693023681, 0.7499999403953552, 1.083332896232605, 0.7499999403953552, 1.083332896232605, 0.6999999284744263, 1.083332896232605, 0.6999999284744263, 1.1666662693023681, 0.6999999284744263, 1.1666662693023681, 0.7499999403953552, 1.1666662693023681, 0.6999999284744263, 1.083332896232605, 0.6999999284744263, 1.083332896232605, 0.6499999165534973, 1.083332896232605, 0.6499999165534973, 1.1666662693023681, 0.6499999165534973, 1.1666662693023681, 0.6999999284744263, 1.1666662693023681, 0.6499999165534973, 1.083332896232605, 0.6499999165534973, 1.083332896232605, 0.5999999046325684, 1.083332896232605, 0.5999999046325684, 1.1666662693023681, 0.5999999046325684, 1.1666662693023681, 0.6499999165534973, 1.1666662693023681, 0.5999999046325684, 1.083332896232605, 0.5999999046325684, 1.083332896232605, 0.5499998927116394, 1.083332896232605, 0.5499998927116394, 1.1666662693023681, 0.5499998927116394, 1.1666662693023681, 0.5999999046325684, 1.1666662693023681, 0.5499998927116394, 1.083332896232605, 0.5499998927116394, 1.083332896232605, 0.49999988079071045, 1.083332896232605, 0.49999988079071045, 1.1666662693023681, 0.49999988079071045, 1.1666662693023681, 0.5499998927116394, 1.1666662693023681, 0.49999988079071045, 1.083332896232605, 0.49999988079071045, 1.083332896232605, 0.4499998688697815, 1.083332896232605, 0.4499998688697815, 1.1666662693023681, 0.4499998688697815, 1.1666662693023681, 0.49999988079071045, 1.1666662693023681, 0.4499998688697815, 1.083332896232605, 0.4499998688697815, 1.083332896232605, 0.39999985694885254, 1.083332896232605, 0.39999985694885254, 1.1666662693023681, 0.39999985694885254, 1.1666662693023681, 0.4499998688697815, 1.083332896232605, 1, 0.9999995827674866, 1, 0.9999995827674866, 0.949999988079071, 0.9999995827674866, 0.949999988079071, 1.083332896232605, 0.949999988079071, 1.083332896232605, 1, 1.083332896232605, 0.949999988079071, 0.9999995827674866, 0.949999988079071, 0.9999995827674866, 0.8999999761581421, 0.9999995827674866, 0.8999999761581421, 1.083332896232605, 0.8999999761581421, 1.083332896232605, 0.949999988079071, 1.083332896232605, 0.8999999761581421, 0.9999995827674866, 0.8999999761581421, 0.9999995827674866, 0.8499999642372131, 0.9999995827674866, 0.8499999642372131, 1.083332896232605, 0.8499999642372131, 1.083332896232605, 0.8999999761581421, 1.083332896232605, 0.8499999642372131, 0.9999995827674866, 0.8499999642372131, 0.9999995827674866, 0.7999999523162842, 0.9999995827674866, 0.7999999523162842, 1.083332896232605, 0.7999999523162842, 1.083332896232605, 0.8499999642372131, 1.083332896232605, 0.7999999523162842, 0.9999995827674866, 0.7999999523162842, 0.9999995827674866, 0.7499999403953552, 0.9999995827674866, 0.7499999403953552, 1.083332896232605, 0.7499999403953552, 1.083332896232605, 0.7999999523162842, 1.083332896232605, 0.7499999403953552, 0.9999995827674866, 0.7499999403953552, 0.9999995827674866, 0.6999999284744263, 0.9999995827674866, 0.6999999284744263, 1.083332896232605, 0.6999999284744263, 1.083332896232605, 0.7499999403953552, 1.083332896232605, 0.6999999284744263, 0.9999995827674866, 0.6999999284744263, 0.9999995827674866, 0.6499999165534973, 0.9999995827674866, 0.6499999165534973, 1.083332896232605, 0.6499999165534973, 1.083332896232605, 0.6999999284744263, 1.083332896232605, 0.6499999165534973, 0.9999995827674866, 0.6499999165534973, 0.9999995827674866, 0.5999999046325684, 0.9999995827674866, 0.5999999046325684, 1.083332896232605, 0.5999999046325684, 1.083332896232605, 0.6499999165534973, 1.083332896232605, 0.5999999046325684, 0.9999995827674866, 0.5999999046325684, 0.9999995827674866, 0.5499998927116394, 0.9999995827674866, 0.5499998927116394, 1.083332896232605, 0.5499998927116394, 1.083332896232605, 0.5999999046325684, 1.083332896232605, 0.5499998927116394, 0.9999995827674866, 0.5499998927116394, 0.9999995827674866, 0.49999988079071045, 0.9999995827674866, 0.49999988079071045, 1.083332896232605, 0.49999988079071045, 1.083332896232605, 0.5499998927116394, 1.083332896232605, 0.49999988079071045, 0.9999995827674866, 0.49999988079071045, 0.9999995827674866, 0.4499998688697815, 0.9999995827674866, 0.4499998688697815, 1.083332896232605, 0.4499998688697815, 1.083332896232605, 0.49999988079071045, 1.083332896232605, 0.4499998688697815, 0.9999995827674866, 0.4499998688697815, 0.9999995827674866, 0.39999985694885254, 0.9999995827674866, 0.39999985694885254, 1.083332896232605, 0.39999985694885254, 1.083332896232605, 0.4499998688697815, 1, 1, 0.9166666865348816, 1, 0.9166666865348816, 0.949999988079071, 0.9166666865348816, 0.949999988079071, 1, 0.949999988079071, 1, 1, 1, 0.949999988079071, 0.9166666865348816, 0.949999988079071, 0.9166666865348816, 0.8999999761581421, 0.9166666865348816, 0.8999999761581421, 1, 0.8999999761581421, 1, 0.949999988079071, 1, 0.8999999761581421, 0.9166666865348816, 0.8999999761581421, 0.9166666865348816, 0.8499999642372131, 0.9166666865348816, 0.8499999642372131, 1, 0.8499999642372131, 1, 0.8999999761581421, 1, 0.8499999642372131, 0.9166666865348816, 0.8499999642372131, 0.9166666865348816, 0.7999999523162842, 0.9166666865348816, 0.7999999523162842, 1, 0.7999999523162842, 1, 0.8499999642372131, 1, 0.7999999523162842, 0.9166666865348816, 0.7999999523162842, 0.9166666865348816, 0.7499999403953552, 0.9166666865348816, 0.7499999403953552, 1, 0.7499999403953552, 1, 0.7999999523162842, 1, 0.7499999403953552, 0.9166666865348816, 0.7499999403953552, 0.9166666865348816, 0.6999999284744263, 0.9166666865348816, 0.6999999284744263, 1, 0.6999999284744263, 1, 0.7499999403953552, 1, 0.6999999284744263, 0.9166666865348816, 0.6999999284744263, 0.9166666865348816, 0.6499999165534973, 0.9166666865348816, 0.6499999165534973, 1, 0.6499999165534973, 1, 0.6999999284744263, 1, 0.6499999165534973, 0.9166666865348816, 0.6499999165534973, 0.9166666865348816, 0.5999999046325684, 0.9166666865348816, 0.5999999046325684, 1, 0.5999999046325684, 1, 0.6499999165534973, 1, 0.5999999046325684, 0.9166666865348816, 0.5999999046325684, 0.9166666865348816, 0.5499998927116394, 0.9166666865348816, 0.5499998927116394, 1, 0.5499998927116394, 1, 0.5999999046325684, 1, 0.5499998927116394, 0.9166666865348816, 0.5499998927116394, 0.9166666865348816, 0.49999988079071045, 0.9166666865348816, 0.49999988079071045, 1, 0.49999988079071045, 1, 0.5499998927116394, 1, 0.49999988079071045, 0.9166666865348816, 0.49999988079071045, 0.9166666865348816, 0.4499998688697815, 0.9166666865348816, 0.4499998688697815, 1, 0.4499998688697815, 1, 0.49999988079071045, 1, 0.4499998688697815, 0.9166666865348816, 0.4499998688697815, 0.9166666865348816, 0.39999985694885254, 0.9166666865348816, 0.39999985694885254, 1, 0.39999985694885254, 1, 0.4499998688697815, 0.9166666865348816, 1, 0.8333333730697632, 1, 0.8333333730697632, 0.949999988079071, 0.8333333730697632, 0.949999988079071, 0.9166666865348816, 0.949999988079071, 0.9166666865348816, 1, 0.9166666865348816, 0.949999988079071, 0.8333333730697632, 0.949999988079071, 0.8333333730697632, 0.8999999761581421, 0.8333333730697632, 0.8999999761581421, 0.9166666865348816, 0.8999999761581421, 0.9166666865348816, 0.949999988079071, 0.9166666865348816, 0.8999999761581421, 0.8333333730697632, 0.8999999761581421, 0.8333333730697632, 0.8499999642372131, 0.8333333730697632, 0.8499999642372131, 0.9166666865348816, 0.8499999642372131, 0.9166666865348816, 0.8999999761581421, 0.9166666865348816, 0.8499999642372131, 0.8333333730697632, 0.8499999642372131, 0.8333333730697632, 0.7999999523162842, 0.8333333730697632, 0.7999999523162842, 0.9166666865348816, 0.7999999523162842, 0.9166666865348816, 0.8499999642372131, 0.9166666865348816, 0.7999999523162842, 0.8333333730697632, 0.7999999523162842, 0.8333333730697632, 0.7499999403953552, 0.8333333730697632, 0.7499999403953552, 0.9166666865348816, 0.7499999403953552, 0.9166666865348816, 0.7999999523162842, 0.9166666865348816, 0.7499999403953552, 0.8333333730697632, 0.7499999403953552, 0.8333333730697632, 0.6999999284744263, 0.8333333730697632, 0.6999999284744263, 0.9166666865348816, 0.6999999284744263, 0.9166666865348816, 0.7499999403953552, 0.9166666865348816, 0.6999999284744263, 0.8333333730697632, 0.6999999284744263, 0.8333333730697632, 0.6499999165534973, 0.8333333730697632, 0.6499999165534973, 0.9166666865348816, 0.6499999165534973, 0.9166666865348816, 0.6999999284744263, 0.9166666865348816, 0.6499999165534973, 0.8333333730697632, 0.6499999165534973, 0.8333333730697632, 0.5999999046325684, 0.8333333730697632, 0.5999999046325684, 0.9166666865348816, 0.5999999046325684, 0.9166666865348816, 0.6499999165534973, 0.9166666865348816, 0.5999999046325684, 0.8333333730697632, 0.5999999046325684, 0.8333333730697632, 0.5499998927116394, 0.8333333730697632, 0.5499998927116394, 0.9166666865348816, 0.5499998927116394, 0.9166666865348816, 0.5999999046325684, 0.9166666865348816, 0.5499998927116394, 0.8333333730697632, 0.5499998927116394, 0.8333333730697632, 0.49999988079071045, 0.8333333730697632, 0.49999988079071045, 0.9166666865348816, 0.49999988079071045, 0.9166666865348816, 0.5499998927116394, 0.9166666865348816, 0.49999988079071045, 0.8333333730697632, 0.49999988079071045, 0.8333333730697632, 0.4499998688697815, 0.8333333730697632, 0.4499998688697815, 0.9166666865348816, 0.4499998688697815, 0.9166666865348816, 0.49999988079071045, 0.9166666865348816, 0.4499998688697815, 0.8333333730697632, 0.4499998688697815, 0.8333333730697632, 0.39999985694885254, 0.8333333730697632, 0.39999985694885254, 0.9166666865348816, 0.39999985694885254, 0.9166666865348816, 0.4499998688697815, 0.8333333730697632, 1, 0.7500000596046448, 1, 0.7500000596046448, 0.949999988079071, 0.7500000596046448, 0.949999988079071, 0.8333333730697632, 0.949999988079071, 0.8333333730697632, 1, 0.8333333730697632, 0.949999988079071, 0.7500000596046448, 0.949999988079071, 0.7500000596046448, 0.8999999761581421, 0.7500000596046448, 0.8999999761581421, 0.8333333730697632, 0.8999999761581421, 0.8333333730697632, 0.949999988079071, 0.8333333730697632, 0.8999999761581421, 0.7500000596046448, 0.8999999761581421, 0.7500000596046448, 0.8499999642372131, 0.7500000596046448, 0.8499999642372131, 0.8333333730697632, 0.8499999642372131, 0.8333333730697632, 0.8999999761581421, 0.8333333730697632, 0.8499999642372131, 0.7500000596046448, 0.8499999642372131, 0.7500000596046448, 0.7999999523162842, 0.7500000596046448, 0.7999999523162842, 0.8333333730697632, 0.7999999523162842, 0.8333333730697632, 0.8499999642372131, 0.8333333730697632, 0.7999999523162842, 0.7500000596046448, 0.7999999523162842, 0.7500000596046448, 0.7499999403953552, 0.7500000596046448, 0.7499999403953552, 0.8333333730697632, 0.7499999403953552, 0.8333333730697632, 0.7999999523162842, 0.8333333730697632, 0.7499999403953552, 0.7500000596046448, 0.7499999403953552, 0.7500000596046448, 0.6999999284744263, 0.7500000596046448, 0.6999999284744263, 0.8333333730697632, 0.6999999284744263, 0.8333333730697632, 0.7499999403953552, 0.8333333730697632, 0.6999999284744263, 0.7500000596046448, 0.6999999284744263, 0.7500000596046448, 0.6499999165534973, 0.7500000596046448, 0.6499999165534973, 0.8333333730697632, 0.6499999165534973, 0.8333333730697632, 0.6999999284744263, 0.8333333730697632, 0.6499999165534973, 0.7500000596046448, 0.6499999165534973, 0.7500000596046448, 0.5999999046325684, 0.7500000596046448, 0.5999999046325684, 0.8333333730697632, 0.5999999046325684, 0.8333333730697632, 0.6499999165534973, 0.8333333730697632, 0.5999999046325684, 0.7500000596046448, 0.5999999046325684, 0.7500000596046448, 0.5499998927116394, 0.7500000596046448, 0.5499998927116394, 0.8333333730697632, 0.5499998927116394, 0.8333333730697632, 0.5999999046325684, 0.8333333730697632, 0.5499998927116394, 0.7500000596046448, 0.5499998927116394, 0.7500000596046448, 0.49999988079071045, 0.7500000596046448, 0.49999988079071045, 0.8333333730697632, 0.49999988079071045, 0.8333333730697632, 0.5499998927116394, 0.8333333730697632, 0.49999988079071045, 0.7500000596046448, 0.49999988079071045, 0.7500000596046448, 0.4499998688697815, 0.7500000596046448, 0.4499998688697815, 0.8333333730697632, 0.4499998688697815, 0.8333333730697632, 0.49999988079071045, 0.8333333730697632, 0.4499998688697815, 0.7500000596046448, 0.4499998688697815, 0.7500000596046448, 0.39999985694885254, 0.7500000596046448, 0.39999985694885254, 0.8333333730697632, 0.39999985694885254, 0.8333333730697632, 0.4499998688697815, 0.7500000596046448, 1, 0.6666667461395264, 1, 0.6666667461395264, 0.949999988079071, 0.6666667461395264, 0.949999988079071, 0.7500000596046448, 0.949999988079071, 0.7500000596046448, 1, 0.7500000596046448, 0.949999988079071, 0.6666667461395264, 0.949999988079071, 0.6666667461395264, 0.8999999761581421, 0.6666667461395264, 0.8999999761581421, 0.7500000596046448, 0.8999999761581421, 0.7500000596046448, 0.949999988079071, 0.7500000596046448, 0.8999999761581421, 0.6666667461395264, 0.8999999761581421, 0.6666667461395264, 0.8499999642372131, 0.6666667461395264, 0.8499999642372131, 0.7500000596046448, 0.8499999642372131, 0.7500000596046448, 0.8999999761581421, 0.7500000596046448, 0.8499999642372131, 0.6666667461395264, 0.8499999642372131, 0.6666667461395264, 0.7999999523162842, 0.6666667461395264, 0.7999999523162842, 0.7500000596046448, 0.7999999523162842, 0.7500000596046448, 0.8499999642372131, 0.7500000596046448, 0.7999999523162842, 0.6666667461395264, 0.7999999523162842, 0.6666667461395264, 0.7499999403953552, 0.6666667461395264, 0.7499999403953552, 0.7500000596046448, 0.7499999403953552, 0.7500000596046448, 0.7999999523162842, 0.7500000596046448, 0.7499999403953552, 0.6666667461395264, 0.7499999403953552, 0.6666667461395264, 0.6999999284744263, 0.6666667461395264, 0.6999999284744263, 0.7500000596046448, 0.6999999284744263, 0.7500000596046448, 0.7499999403953552, 0.7500000596046448, 0.6999999284744263, 0.6666667461395264, 0.6999999284744263, 0.6666667461395264, 0.6499999165534973, 0.6666667461395264, 0.6499999165534973, 0.7500000596046448, 0.6499999165534973, 0.7500000596046448, 0.6999999284744263, 0.7500000596046448, 0.6499999165534973, 0.6666667461395264, 0.6499999165534973, 0.6666667461395264, 0.5999999046325684, 0.6666667461395264, 0.5999999046325684, 0.7500000596046448, 0.5999999046325684, 0.7500000596046448, 0.6499999165534973, 0.7500000596046448, 0.5999999046325684, 0.6666667461395264, 0.5999999046325684, 0.6666667461395264, 0.5499998927116394, 0.6666667461395264, 0.5499998927116394, 0.7500000596046448, 0.5499998927116394, 0.7500000596046448, 0.5999999046325684, 0.7500000596046448, 0.5499998927116394, 0.6666667461395264, 0.5499998927116394, 0.6666667461395264, 0.49999988079071045, 0.6666667461395264, 0.49999988079071045, 0.7500000596046448, 0.49999988079071045, 0.7500000596046448, 0.5499998927116394, 0.7500000596046448, 0.49999988079071045, 0.6666667461395264, 0.49999988079071045, 0.6666667461395264, 0.4499998688697815, 0.6666667461395264, 0.4499998688697815, 0.7500000596046448, 0.4499998688697815, 0.7500000596046448, 0.49999988079071045, 0.7500000596046448, 0.4499998688697815, 0.6666667461395264, 0.4499998688697815, 0.6666667461395264, 0.39999985694885254, 0.6666667461395264, 0.39999985694885254, 0.7500000596046448, 0.39999985694885254, 0.7500000596046448, 0.4499998688697815, 0.6666667461395264, 1, 0.583333432674408, 1, 0.583333432674408, 0.949999988079071, 0.583333432674408, 0.949999988079071, 0.6666667461395264, 0.949999988079071, 0.6666667461395264, 1, 0.6666667461395264, 0.949999988079071, 0.583333432674408, 0.949999988079071, 0.583333432674408, 0.8999999761581421, 0.583333432674408, 0.8999999761581421, 0.6666667461395264, 0.8999999761581421, 0.6666667461395264, 0.949999988079071, 0.6666667461395264, 0.8999999761581421, 0.583333432674408, 0.8999999761581421, 0.583333432674408, 0.8499999642372131, 0.583333432674408, 0.8499999642372131, 0.6666667461395264, 0.8499999642372131, 0.6666667461395264, 0.8999999761581421, 0.6666667461395264, 0.8499999642372131, 0.583333432674408, 0.8499999642372131, 0.583333432674408, 0.7999999523162842, 0.583333432674408, 0.7999999523162842, 0.6666667461395264, 0.7999999523162842, 0.6666667461395264, 0.8499999642372131, 0.6666667461395264, 0.7999999523162842, 0.583333432674408, 0.7999999523162842, 0.583333432674408, 0.7499999403953552, 0.583333432674408, 0.7499999403953552, 0.6666667461395264, 0.7499999403953552, 0.6666667461395264, 0.7999999523162842, 0.6666667461395264, 0.7499999403953552, 0.583333432674408, 0.7499999403953552, 0.583333432674408, 0.6999999284744263, 0.583333432674408, 0.6999999284744263, 0.6666667461395264, 0.6999999284744263, 0.6666667461395264, 0.7499999403953552, 0.6666667461395264, 0.6999999284744263, 0.583333432674408, 0.6999999284744263, 0.583333432674408, 0.6499999165534973, 0.583333432674408, 0.6499999165534973, 0.6666667461395264, 0.6499999165534973, 0.6666667461395264, 0.6999999284744263, 0.6666667461395264, 0.6499999165534973, 0.583333432674408, 0.6499999165534973, 0.583333432674408, 0.5999999046325684, 0.583333432674408, 0.5999999046325684, 0.6666667461395264, 0.5999999046325684, 0.6666667461395264, 0.6499999165534973, 0.6666667461395264, 0.5999999046325684, 0.583333432674408, 0.5999999046325684, 0.583333432674408, 0.5499998927116394, 0.583333432674408, 0.5499998927116394, 0.6666667461395264, 0.5499998927116394, 0.6666667461395264, 0.5999999046325684, 0.6666667461395264, 0.5499998927116394, 0.583333432674408, 0.5499998927116394, 0.583333432674408, 0.49999988079071045, 0.583333432674408, 0.49999988079071045, 0.6666667461395264, 0.49999988079071045, 0.6666667461395264, 0.5499998927116394, 0.6666667461395264, 0.49999988079071045, 0.583333432674408, 0.49999988079071045, 0.583333432674408, 0.4499998688697815, 0.583333432674408, 0.4499998688697815, 0.6666667461395264, 0.4499998688697815, 0.6666667461395264, 0.49999988079071045, 0.6666667461395264, 0.4499998688697815, 0.583333432674408, 0.4499998688697815, 0.583333432674408, 0.39999985694885254, 0.583333432674408, 0.39999985694885254, 0.6666667461395264, 0.39999985694885254, 0.6666667461395264, 0.4499998688697815, 0.583333432674408, 1, 0.5000001192092895, 1, 0.5000001192092895, 0.949999988079071, 0.5000001192092895, 0.949999988079071, 0.583333432674408, 0.949999988079071, 0.583333432674408, 1, 0.583333432674408, 0.949999988079071, 0.5000001192092895, 0.949999988079071, 0.5000001192092895, 0.8999999761581421, 0.5000001192092895, 0.8999999761581421, 0.583333432674408, 0.8999999761581421, 0.583333432674408, 0.949999988079071, 0.583333432674408, 0.8999999761581421, 0.5000001192092895, 0.8999999761581421, 0.5000001192092895, 0.8499999642372131, 0.5000001192092895, 0.8499999642372131, 0.583333432674408, 0.8499999642372131, 0.583333432674408, 0.8999999761581421, 0.583333432674408, 0.8499999642372131, 0.5000001192092895, 0.8499999642372131, 0.5000001192092895, 0.7999999523162842, 0.5000001192092895, 0.7999999523162842, 0.583333432674408, 0.7999999523162842, 0.583333432674408, 0.8499999642372131, 0.583333432674408, 0.7999999523162842, 0.5000001192092895, 0.7999999523162842, 0.5000001192092895, 0.7499999403953552, 0.5000001192092895, 0.7499999403953552, 0.583333432674408, 0.7499999403953552, 0.583333432674408, 0.7999999523162842, 0.583333432674408, 0.7499999403953552, 0.5000001192092895, 0.7499999403953552, 0.5000001192092895, 0.6999999284744263, 0.5000001192092895, 0.6999999284744263, 0.583333432674408, 0.6999999284744263, 0.583333432674408, 0.7499999403953552, 0.583333432674408, 0.6999999284744263, 0.5000001192092895, 0.6999999284744263, 0.5000001192092895, 0.6499999165534973, 0.5000001192092895, 0.6499999165534973, 0.583333432674408, 0.6499999165534973, 0.583333432674408, 0.6999999284744263, 0.583333432674408, 0.6499999165534973, 0.5000001192092895, 0.6499999165534973, 0.5000001192092895, 0.5999999046325684, 0.5000001192092895, 0.5999999046325684, 0.583333432674408, 0.5999999046325684, 0.583333432674408, 0.6499999165534973, 0.583333432674408, 0.5999999046325684, 0.5000001192092895, 0.5999999046325684, 0.5000001192092895, 0.5499998927116394, 0.5000001192092895, 0.5499998927116394, 0.583333432674408, 0.5499998927116394, 0.583333432674408, 0.5999999046325684, 0.583333432674408, 0.5499998927116394, 0.5000001192092895, 0.5499998927116394, 0.5000001192092895, 0.49999988079071045, 0.5000001192092895, 0.49999988079071045, 0.583333432674408, 0.49999988079071045, 0.583333432674408, 0.5499998927116394, 0.583333432674408, 0.49999988079071045, 0.5000001192092895, 0.49999988079071045, 0.5000001192092895, 0.4499998688697815, 0.5000001192092895, 0.4499998688697815, 0.583333432674408, 0.4499998688697815, 0.583333432674408, 0.49999988079071045, 0.583333432674408, 0.4499998688697815, 0.5000001192092895, 0.4499998688697815, 0.5000001192092895, 0.39999985694885254, 0.5000001192092895, 0.39999985694885254, 0.583333432674408, 0.39999985694885254, 0.583333432674408, 0.4499998688697815, 0.5000001192092895, 1, 0.41666677594184875, 1, 0.41666677594184875, 0.949999988079071, 0.41666677594184875, 0.949999988079071, 0.5000001192092895, 0.949999988079071, 0.5000001192092895, 1, 0.5000001192092895, 0.949999988079071, 0.41666677594184875, 0.949999988079071, 0.41666677594184875, 0.8999999761581421, 0.41666677594184875, 0.8999999761581421, 0.5000001192092895, 0.8999999761581421, 0.5000001192092895, 0.949999988079071, 0.5000001192092895, 0.8999999761581421, 0.41666677594184875, 0.8999999761581421, 0.41666677594184875, 0.8499999642372131, 0.41666677594184875, 0.8499999642372131, 0.5000001192092895, 0.8499999642372131, 0.5000001192092895, 0.8999999761581421, 0.5000001192092895, 0.8499999642372131, 0.41666677594184875, 0.8499999642372131, 0.41666677594184875, 0.7999999523162842, 0.41666677594184875, 0.7999999523162842, 0.5000001192092895, 0.7999999523162842, 0.5000001192092895, 0.8499999642372131, 0.5000001192092895, 0.7999999523162842, 0.41666677594184875, 0.7999999523162842, 0.41666677594184875, 0.7499999403953552, 0.41666677594184875, 0.7499999403953552, 0.5000001192092895, 0.7499999403953552, 0.5000001192092895, 0.7999999523162842, 0.5000001192092895, 0.7499999403953552, 0.41666677594184875, 0.7499999403953552, 0.41666677594184875, 0.6999999284744263, 0.41666677594184875, 0.6999999284744263, 0.5000001192092895, 0.6999999284744263, 0.5000001192092895, 0.7499999403953552, 0.5000001192092895, 0.6999999284744263, 0.41666677594184875, 0.6999999284744263, 0.41666677594184875, 0.6499999165534973, 0.41666677594184875, 0.6499999165534973, 0.5000001192092895, 0.6499999165534973, 0.5000001192092895, 0.6999999284744263, 0.5000001192092895, 0.6499999165534973, 0.41666677594184875, 0.6499999165534973, 0.41666677594184875, 0.5999999046325684, 0.41666677594184875, 0.5999999046325684, 0.5000001192092895, 0.5999999046325684, 0.5000001192092895, 0.6499999165534973, 0.5000001192092895, 0.5999999046325684, 0.41666677594184875, 0.5999999046325684, 0.41666677594184875, 0.5499998927116394, 0.41666677594184875, 0.5499998927116394, 0.5000001192092895, 0.5499998927116394, 0.5000001192092895, 0.5999999046325684, 0.5000001192092895, 0.5499998927116394, 0.41666677594184875, 0.5499998927116394, 0.41666677594184875, 0.49999988079071045, 0.41666677594184875, 0.49999988079071045, 0.5000001192092895, 0.49999988079071045, 0.5000001192092895, 0.5499998927116394, 0.5000001192092895, 0.49999988079071045, 0.41666677594184875, 0.49999988079071045, 0.41666677594184875, 0.4499998688697815, 0.41666677594184875, 0.4499998688697815, 0.5000001192092895, 0.4499998688697815, 0.5000001192092895, 0.49999988079071045, 0.5000001192092895, 0.4499998688697815, 0.41666677594184875, 0.4499998688697815, 0.41666677594184875, 0.39999985694885254, 0.41666677594184875, 0.39999985694885254, 0.5000001192092895, 0.39999985694885254, 0.5000001192092895, 0.4499998688697815, 0.41666677594184875, 1, 0.33333343267440796, 1, 0.33333343267440796, 0.949999988079071, 0.33333343267440796, 0.949999988079071, 0.41666677594184875, 0.949999988079071, 0.41666677594184875, 1, 0.41666677594184875, 0.949999988079071, 0.33333343267440796, 0.949999988079071, 0.33333343267440796, 0.8999999761581421, 0.33333343267440796, 0.8999999761581421, 0.41666677594184875, 0.8999999761581421, 0.41666677594184875, 0.949999988079071, 0.41666677594184875, 0.8999999761581421, 0.33333343267440796, 0.8999999761581421, 0.33333343267440796, 0.8499999642372131, 0.33333343267440796, 0.8499999642372131, 0.41666677594184875, 0.8499999642372131, 0.41666677594184875, 0.8999999761581421, 0.41666677594184875, 0.8499999642372131, 0.33333343267440796, 0.8499999642372131, 0.33333343267440796, 0.7999999523162842, 0.33333343267440796, 0.7999999523162842, 0.41666677594184875, 0.7999999523162842, 0.41666677594184875, 0.8499999642372131, 0.41666677594184875, 0.7999999523162842, 0.33333343267440796, 0.7999999523162842, 0.33333343267440796, 0.7499999403953552, 0.33333343267440796, 0.7499999403953552, 0.41666677594184875, 0.7499999403953552, 0.41666677594184875, 0.7999999523162842, 0.41666677594184875, 0.7499999403953552, 0.33333343267440796, 0.7499999403953552, 0.33333343267440796, 0.6999999284744263, 0.33333343267440796, 0.6999999284744263, 0.41666677594184875, 0.6999999284744263, 0.41666677594184875, 0.7499999403953552, 0.41666677594184875, 0.6999999284744263, 0.33333343267440796, 0.6999999284744263, 0.33333343267440796, 0.6499999165534973, 0.33333343267440796, 0.6499999165534973, 0.41666677594184875, 0.6499999165534973, 0.41666677594184875, 0.6999999284744263, 0.41666677594184875, 0.6499999165534973, 0.33333343267440796, 0.6499999165534973, 0.33333343267440796, 0.5999999046325684, 0.33333343267440796, 0.5999999046325684, 0.41666677594184875, 0.5999999046325684, 0.41666677594184875, 0.6499999165534973, 0.41666677594184875, 0.5999999046325684, 0.33333343267440796, 0.5999999046325684, 0.33333343267440796, 0.5499998927116394, 0.33333343267440796, 0.5499998927116394, 0.41666677594184875, 0.5499998927116394, 0.41666677594184875, 0.5999999046325684, 0.41666677594184875, 0.5499998927116394, 0.33333343267440796, 0.5499998927116394, 0.33333343267440796, 0.49999988079071045, 0.33333343267440796, 0.49999988079071045, 0.41666677594184875, 0.49999988079071045, 0.41666677594184875, 0.5499998927116394, 0.41666677594184875, 0.49999988079071045, 0.33333343267440796, 0.49999988079071045, 0.33333343267440796, 0.4499998688697815, 0.33333343267440796, 0.4499998688697815, 0.41666677594184875, 0.4499998688697815, 0.41666677594184875, 0.49999988079071045, 0.41666677594184875, 0.4499998688697815, 0.33333343267440796, 0.4499998688697815, 0.33333343267440796, 0.39999985694885254, 0.33333343267440796, 0.39999985694885254, 0.41666677594184875, 0.39999985694885254, 0.41666677594184875, 0.4499998688697815, 0.33333343267440796, 1, 0.25000008940696716, 1, 0.25000008940696716, 0.949999988079071, 0.25000008940696716, 0.949999988079071, 0.33333343267440796, 0.949999988079071, 0.33333343267440796, 1, 0.33333343267440796, 0.949999988079071, 0.25000008940696716, 0.949999988079071, 0.25000008940696716, 0.8999999761581421, 0.25000008940696716, 0.8999999761581421, 0.33333343267440796, 0.8999999761581421, 0.33333343267440796, 0.949999988079071, 0.33333343267440796, 0.8999999761581421, 0.25000008940696716, 0.8999999761581421, 0.25000008940696716, 0.8499999642372131, 0.25000008940696716, 0.8499999642372131, 0.33333343267440796, 0.8499999642372131, 0.33333343267440796, 0.8999999761581421, 0.33333343267440796, 0.8499999642372131, 0.25000008940696716, 0.8499999642372131, 0.25000008940696716, 0.7999999523162842, 0.25000008940696716, 0.7999999523162842, 0.33333343267440796, 0.7999999523162842, 0.33333343267440796, 0.8499999642372131, 0.33333343267440796, 0.7999999523162842, 0.25000008940696716, 0.7999999523162842, 0.25000008940696716, 0.7499999403953552, 0.25000008940696716, 0.7499999403953552, 0.33333343267440796, 0.7499999403953552, 0.33333343267440796, 0.7999999523162842, 0.33333343267440796, 0.7499999403953552, 0.25000008940696716, 0.7499999403953552, 0.25000008940696716, 0.6999999284744263, 0.25000008940696716, 0.6999999284744263, 0.33333343267440796, 0.6999999284744263, 0.33333343267440796, 0.7499999403953552, 0.33333343267440796, 0.6999999284744263, 0.25000008940696716, 0.6999999284744263, 0.25000008940696716, 0.6499999165534973, 0.25000008940696716, 0.6499999165534973, 0.33333343267440796, 0.6499999165534973, 0.33333343267440796, 0.6999999284744263, 0.33333343267440796, 0.6499999165534973, 0.25000008940696716, 0.6499999165534973, 0.25000008940696716, 0.5999999046325684, 0.25000008940696716, 0.5999999046325684, 0.33333343267440796, 0.5999999046325684, 0.33333343267440796, 0.6499999165534973, 0.33333343267440796, 0.5999999046325684, 0.25000008940696716, 0.5999999046325684, 0.25000008940696716, 0.5499998927116394, 0.25000008940696716, 0.5499998927116394, 0.33333343267440796, 0.5499998927116394, 0.33333343267440796, 0.5999999046325684, 0.33333343267440796, 0.5499998927116394, 0.25000008940696716, 0.5499998927116394, 0.25000008940696716, 0.49999988079071045, 0.25000008940696716, 0.49999988079071045, 0.33333343267440796, 0.49999988079071045, 0.33333343267440796, 0.5499998927116394, 0.33333343267440796, 0.49999988079071045, 0.25000008940696716, 0.49999988079071045, 0.25000008940696716, 0.4499998688697815, 0.25000008940696716, 0.4499998688697815, 0.33333343267440796, 0.4499998688697815, 0.33333343267440796, 0.49999988079071045, 0.33333343267440796, 0.4499998688697815, 0.25000008940696716, 0.4499998688697815, 0.25000008940696716, 0.39999985694885254, 0.25000008940696716, 0.39999985694885254, 0.33333343267440796, 0.39999985694885254, 0.33333343267440796, 0.4499998688697815, 0.25000008940696716, 1, 0.16666674613952637, 1, 0.16666674613952637, 0.949999988079071, 0.16666674613952637, 0.949999988079071, 0.25000008940696716, 0.949999988079071, 0.25000008940696716, 1, 0.25000008940696716, 0.949999988079071, 0.16666674613952637, 0.949999988079071, 0.16666674613952637, 0.8999999761581421, 0.16666674613952637, 0.8999999761581421, 0.25000008940696716, 0.8999999761581421, 0.25000008940696716, 0.949999988079071, 0.25000008940696716, 0.8999999761581421, 0.16666674613952637, 0.8999999761581421, 0.16666674613952637, 0.8499999642372131, 0.16666674613952637, 0.8499999642372131, 0.25000008940696716, 0.8499999642372131, 0.25000008940696716, 0.8999999761581421, 0.25000008940696716, 0.8499999642372131, 0.16666674613952637, 0.8499999642372131, 0.16666674613952637, 0.7999999523162842, 0.16666674613952637, 0.7999999523162842, 0.25000008940696716, 0.7999999523162842, 0.25000008940696716, 0.8499999642372131, 0.25000008940696716, 0.7999999523162842, 0.16666674613952637, 0.7999999523162842, 0.16666674613952637, 0.7499999403953552, 0.16666674613952637, 0.7499999403953552, 0.25000008940696716, 0.7499999403953552, 0.25000008940696716, 0.7999999523162842, 0.25000008940696716, 0.7499999403953552, 0.16666674613952637, 0.7499999403953552, 0.16666674613952637, 0.6999999284744263, 0.16666674613952637, 0.6999999284744263, 0.25000008940696716, 0.6999999284744263, 0.25000008940696716, 0.7499999403953552, 0.25000008940696716, 0.6999999284744263, 0.16666674613952637, 0.6999999284744263, 0.16666674613952637, 0.6499999165534973, 0.16666674613952637, 0.6499999165534973, 0.25000008940696716, 0.6499999165534973, 0.25000008940696716, 0.6999999284744263, 0.25000008940696716, 0.6499999165534973, 0.16666674613952637, 0.6499999165534973, 0.16666674613952637, 0.5999999046325684, 0.16666674613952637, 0.5999999046325684, 0.25000008940696716, 0.5999999046325684, 0.25000008940696716, 0.6499999165534973, 0.25000008940696716, 0.5999999046325684, 0.16666674613952637, 0.5999999046325684, 0.16666674613952637, 0.5499998927116394, 0.16666674613952637, 0.5499998927116394, 0.25000008940696716, 0.5499998927116394, 0.25000008940696716, 0.5999999046325684, 0.25000008940696716, 0.5499998927116394, 0.16666674613952637, 0.5499998927116394, 0.16666674613952637, 0.49999988079071045, 0.16666674613952637, 0.49999988079071045, 0.25000008940696716, 0.49999988079071045, 0.25000008940696716, 0.5499998927116394, 0.25000008940696716, 0.49999988079071045, 0.16666674613952637, 0.49999988079071045, 0.16666674613952637, 0.4499998688697815, 0.16666674613952637, 0.4499998688697815, 0.25000008940696716, 0.4499998688697815, 0.25000008940696716, 0.49999988079071045, 0.25000008940696716, 0.4499998688697815, 0.16666674613952637, 0.4499998688697815, 0.16666674613952637, 0.39999985694885254, 0.16666674613952637, 0.39999985694885254, 0.25000008940696716, 0.39999985694885254, 0.25000008940696716, 0.4499998688697815, 0.16666674613952637, 1, 0.08333341032266617, 1, 0.08333341032266617, 0.949999988079071, 0.08333341032266617, 0.949999988079071, 0.16666674613952637, 0.949999988079071, 0.16666674613952637, 1, 0.16666674613952637, 0.949999988079071, 0.08333341032266617, 0.949999988079071, 0.08333341032266617, 0.8999999761581421, 0.08333341032266617, 0.8999999761581421, 0.16666674613952637, 0.8999999761581421, 0.16666674613952637, 0.949999988079071, 0.16666674613952637, 0.8999999761581421, 0.08333341032266617, 0.8999999761581421, 0.08333341032266617, 0.8499999642372131, 0.08333341032266617, 0.8499999642372131, 0.16666674613952637, 0.8499999642372131, 0.16666674613952637, 0.8999999761581421, 0.16666674613952637, 0.8499999642372131, 0.08333341032266617, 0.8499999642372131, 0.08333341032266617, 0.7999999523162842, 0.08333341032266617, 0.7999999523162842, 0.16666674613952637, 0.7999999523162842, 0.16666674613952637, 0.8499999642372131, 0.16666674613952637, 0.7999999523162842, 0.08333341032266617, 0.7999999523162842, 0.08333341032266617, 0.7499999403953552, 0.08333341032266617, 0.7499999403953552, 0.16666674613952637, 0.7499999403953552, 0.16666674613952637, 0.7999999523162842, 0.16666674613952637, 0.7499999403953552, 0.08333341032266617, 0.7499999403953552, 0.08333341032266617, 0.6999999284744263, 0.08333341032266617, 0.6999999284744263, 0.16666674613952637, 0.6999999284744263, 0.16666674613952637, 0.7499999403953552, 0.16666674613952637, 0.6999999284744263, 0.08333341032266617, 0.6999999284744263, 0.08333341032266617, 0.6499999165534973, 0.08333341032266617, 0.6499999165534973, 0.16666674613952637, 0.6499999165534973, 0.16666674613952637, 0.6999999284744263, 0.16666674613952637, 0.6499999165534973, 0.08333341032266617, 0.6499999165534973, 0.08333341032266617, 0.5999999046325684, 0.08333341032266617, 0.5999999046325684, 0.16666674613952637, 0.5999999046325684, 0.16666674613952637, 0.6499999165534973, 0.16666674613952637, 0.5999999046325684, 0.08333341032266617, 0.5999999046325684, 0.08333341032266617, 0.5499998927116394, 0.08333341032266617, 0.5499998927116394, 0.16666674613952637, 0.5499998927116394, 0.16666674613952637, 0.5999999046325684, 0.16666674613952637, 0.5499998927116394, 0.08333341032266617, 0.5499998927116394, 0.08333341032266617, 0.49999988079071045, 0.08333341032266617, 0.49999988079071045, 0.16666674613952637, 0.49999988079071045, 0.16666674613952637, 0.5499998927116394, 0.16666674613952637, 0.49999988079071045, 0.08333341032266617, 0.49999988079071045, 0.08333341032266617, 0.4499998688697815, 0.08333341032266617, 0.4499998688697815, 0.16666674613952637, 0.4499998688697815, 0.16666674613952637, 0.49999988079071045, 0.16666674613952637, 0.4499998688697815, 0.08333341032266617, 0.4499998688697815, 0.08333341032266617, 0.39999985694885254, 0.08333341032266617, 0.39999985694885254, 0.16666674613952637, 0.39999985694885254, 0.16666674613952637, 0.4499998688697815, 0.08333341032266617, 1, 7.450580596923828e-8, 1, 7.450580596923828e-8, 0.949999988079071, 7.450580596923828e-8, 0.949999988079071, 0.08333341032266617, 0.949999988079071, 0.08333341032266617, 1, 0.08333341032266617, 0.949999988079071, 7.450580596923828e-8, 0.949999988079071, 7.450580596923828e-8, 0.8999999761581421, 7.450580596923828e-8, 0.8999999761581421, 0.08333341032266617, 0.8999999761581421, 0.08333341032266617, 0.949999988079071, 0.08333341032266617, 0.8999999761581421, 7.450580596923828e-8, 0.8999999761581421, 7.450580596923828e-8, 0.8499999642372131, 7.450580596923828e-8, 0.8499999642372131, 0.08333341032266617, 0.8499999642372131, 0.08333341032266617, 0.8999999761581421, 0.08333341032266617, 0.8499999642372131, 7.450580596923828e-8, 0.8499999642372131, 7.450580596923828e-8, 0.7999999523162842, 7.450580596923828e-8, 0.7999999523162842, 0.08333341032266617, 0.7999999523162842, 0.08333341032266617, 0.8499999642372131, 0.08333341032266617, 0.7999999523162842, 7.450580596923828e-8, 0.7999999523162842, 7.450580596923828e-8, 0.7499999403953552, 7.450580596923828e-8, 0.7499999403953552, 0.08333341032266617, 0.7499999403953552, 0.08333341032266617, 0.7999999523162842, 0.08333341032266617, 0.7499999403953552, 7.450580596923828e-8, 0.7499999403953552, 7.450580596923828e-8, 0.6999999284744263, 7.450580596923828e-8, 0.6999999284744263, 0.08333341032266617, 0.6999999284744263, 0.08333341032266617, 0.7499999403953552, 0.08333341032266617, 0.6999999284744263, 7.450580596923828e-8, 0.6999999284744263, 7.450580596923828e-8, 0.6499999165534973, 7.450580596923828e-8, 0.6499999165534973, 0.08333341032266617, 0.6499999165534973, 0.08333341032266617, 0.6999999284744263, 0.08333341032266617, 0.6499999165534973, 7.450580596923828e-8, 0.6499999165534973, 7.450580596923828e-8, 0.5999999046325684, 7.450580596923828e-8, 0.5999999046325684, 0.08333341032266617, 0.5999999046325684, 0.08333341032266617, 0.6499999165534973, 0.08333341032266617, 0.5999999046325684, 7.450580596923828e-8, 0.5999999046325684, 7.450580596923828e-8, 0.5499998927116394, 7.450580596923828e-8, 0.5499998927116394, 0.08333341032266617, 0.5499998927116394, 0.08333341032266617, 0.5999999046325684, 0.08333341032266617, 0.5499998927116394, 7.450580596923828e-8, 0.5499998927116394, 7.450580596923828e-8, 0.49999988079071045, 7.450580596923828e-8, 0.49999988079071045, 0.08333341032266617, 0.49999988079071045, 0.08333341032266617, 0.5499998927116394, 0.08333341032266617, 0.49999988079071045, 7.450580596923828e-8, 0.49999988079071045, 7.450580596923828e-8, 0.4499998688697815, 7.450580596923828e-8, 0.4499998688697815, 0.08333341032266617, 0.4499998688697815, 0.08333341032266617, 0.49999988079071045, 0.08333341032266617, 0.4499998688697815, 7.450580596923828e-8, 0.4499998688697815, 7.450580596923828e-8, 0.39999985694885254, 7.450580596923828e-8, 0.39999985694885254, 0.08333341032266617, 0.39999985694885254, 0.08333341032266617, 0.4499998688697815, 2, 1, 1.9166666269302368, 1, 1.9166666269302368, 0.949999988079071, 1.9166666269302368, 0.949999988079071, 2, 0.949999988079071, 2, 1, 2, 0.949999988079071, 1.9166666269302368, 0.949999988079071, 1.9166666269302368, 0.8999999761581421, 1.9166666269302368, 0.8999999761581421, 2, 0.8999999761581421, 2, 0.949999988079071, 2, 0.8999999761581421, 1.9166666269302368, 0.8999999761581421, 1.9166666269302368, 0.8499999642372131, 1.9166666269302368, 0.8499999642372131, 2, 0.8499999642372131, 2, 0.8999999761581421, 2, 0.8499999642372131, 1.9166666269302368, 0.8499999642372131, 1.9166666269302368, 0.7999999523162842, 1.9166666269302368, 0.7999999523162842, 2, 0.7999999523162842, 2, 0.8499999642372131, 2, 0.7999999523162842, 1.9166666269302368, 0.7999999523162842, 1.9166666269302368, 0.7499999403953552, 1.9166666269302368, 0.7499999403953552, 2, 0.7499999403953552, 2, 0.7999999523162842, 2, 0.7499999403953552, 1.9166666269302368, 0.7499999403953552, 1.9166666269302368, 0.6999999284744263, 1.9166666269302368, 0.6999999284744263, 2, 0.6999999284744263, 2, 0.7499999403953552, 2, 0.6999999284744263, 1.9166666269302368, 0.6999999284744263, 1.9166666269302368, 0.6499999165534973, 1.9166666269302368, 0.6499999165534973, 2, 0.6499999165534973, 2, 0.6999999284744263, 2, 0.6499999165534973, 1.9166666269302368, 0.6499999165534973, 1.9166666269302368, 0.5999999046325684, 1.9166666269302368, 0.5999999046325684, 2, 0.5999999046325684, 2, 0.6499999165534973, 2, 0.5999999046325684, 1.9166666269302368, 0.5999999046325684, 1.9166666269302368, 0.5499998927116394, 1.9166666269302368, 0.5499998927116394, 2, 0.5499998927116394, 2, 0.5999999046325684, 2, 0.5499998927116394, 1.9166666269302368, 0.5499998927116394, 1.9166666269302368, 0.49999988079071045, 1.9166666269302368, 0.49999988079071045, 2, 0.49999988079071045, 2, 0.5499998927116394, 2, 0.49999988079071045, 1.9166666269302368, 0.49999988079071045, 1.9166666269302368, 0.4499998688697815, 1.9166666269302368, 0.4499998688697815, 2, 0.4499998688697815, 2, 0.49999988079071045, 2, 0.4499998688697815, 1.9166666269302368, 0.4499998688697815, 1.9166666269302368, 0.39999985694885254, 1.9166666269302368, 0.39999985694885254, 2, 0.39999985694885254, 2, 0.4499998688697815, 1.9166666269302368, 1, 1.8333332538604736, 1, 1.8333332538604736, 0.949999988079071, 1.8333332538604736, 0.949999988079071, 1.9166666269302368, 0.949999988079071, 1.9166666269302368, 1, 1.9166666269302368, 0.949999988079071, 1.8333332538604736, 0.949999988079071, 1.8333332538604736, 0.8999999761581421, 1.8333332538604736, 0.8999999761581421, 1.9166666269302368, 0.8999999761581421, 1.9166666269302368, 0.949999988079071, 1.9166666269302368, 0.8999999761581421, 1.8333332538604736, 0.8999999761581421, 1.8333332538604736, 0.8499999642372131, 1.8333332538604736, 0.8499999642372131, 1.9166666269302368, 0.8499999642372131, 1.9166666269302368, 0.8999999761581421, 1.9166666269302368, 0.8499999642372131, 1.8333332538604736, 0.8499999642372131, 1.8333332538604736, 0.7999999523162842, 1.8333332538604736, 0.7999999523162842, 1.9166666269302368, 0.7999999523162842, 1.9166666269302368, 0.8499999642372131, 1.9166666269302368, 0.7999999523162842, 1.8333332538604736, 0.7999999523162842, 1.8333332538604736, 0.7499999403953552, 1.8333332538604736, 0.7499999403953552, 1.9166666269302368, 0.7499999403953552, 1.9166666269302368, 0.7999999523162842, 1.9166666269302368, 0.7499999403953552, 1.8333332538604736, 0.7499999403953552, 1.8333332538604736, 0.6999999284744263, 1.8333332538604736, 0.6999999284744263, 1.9166666269302368, 0.6999999284744263, 1.9166666269302368, 0.7499999403953552, 1.9166666269302368, 0.6999999284744263, 1.8333332538604736, 0.6999999284744263, 1.8333332538604736, 0.6499999165534973, 1.8333332538604736, 0.6499999165534973, 1.9166666269302368, 0.6499999165534973, 1.9166666269302368, 0.6999999284744263, 1.9166666269302368, 0.6499999165534973, 1.8333332538604736, 0.6499999165534973, 1.8333332538604736, 0.5999999046325684, 1.8333332538604736, 0.5999999046325684, 1.9166666269302368, 0.5999999046325684, 1.9166666269302368, 0.6499999165534973, 1.9166666269302368, 0.5999999046325684, 1.8333332538604736, 0.5999999046325684, 1.8333332538604736, 0.5499998927116394, 1.8333332538604736, 0.5499998927116394, 1.9166666269302368, 0.5499998927116394, 1.9166666269302368, 0.5999999046325684, 1.9166666269302368, 0.5499998927116394, 1.8333332538604736, 0.5499998927116394, 1.8333332538604736, 0.49999988079071045, 1.8333332538604736, 0.49999988079071045, 1.9166666269302368, 0.49999988079071045, 1.9166666269302368, 0.5499998927116394, 1.9166666269302368, 0.49999988079071045, 1.8333332538604736, 0.49999988079071045, 1.8333332538604736, 0.4499998688697815, 1.8333332538604736, 0.4499998688697815, 1.9166666269302368, 0.4499998688697815, 1.9166666269302368, 0.49999988079071045, 1.9166666269302368, 0.4499998688697815, 1.8333332538604736, 0.4499998688697815, 1.8333332538604736, 0.39999985694885254, 1.8333332538604736, 0.39999985694885254, 1.9166666269302368, 0.39999985694885254, 1.9166666269302368, 0.4499998688697815, 1.8333332538604736, 1, 1.7499998807907104, 1, 1.7499998807907104, 0.949999988079071, 1.7499998807907104, 0.949999988079071, 1.8333332538604736, 0.949999988079071, 1.8333332538604736, 1, 1.8333332538604736, 0.949999988079071, 1.7499998807907104, 0.949999988079071, 1.7499998807907104, 0.8999999761581421, 1.7499998807907104, 0.8999999761581421, 1.8333332538604736, 0.8999999761581421, 1.8333332538604736, 0.949999988079071, 1.8333332538604736, 0.8999999761581421, 1.7499998807907104, 0.8999999761581421, 1.7499998807907104, 0.8499999642372131, 1.7499998807907104, 0.8499999642372131, 1.8333332538604736, 0.8499999642372131, 1.8333332538604736, 0.8999999761581421, 1.8333332538604736, 0.8499999642372131, 1.7499998807907104, 0.8499999642372131, 1.7499998807907104, 0.7999999523162842, 1.7499998807907104, 0.7999999523162842, 1.8333332538604736, 0.7999999523162842, 1.8333332538604736, 0.8499999642372131, 1.8333332538604736, 0.7999999523162842, 1.7499998807907104, 0.7999999523162842, 1.7499998807907104, 0.7499999403953552, 1.7499998807907104, 0.7499999403953552, 1.8333332538604736, 0.7499999403953552, 1.8333332538604736, 0.7999999523162842, 1.8333332538604736, 0.7499999403953552, 1.7499998807907104, 0.7499999403953552, 1.7499998807907104, 0.6999999284744263, 1.7499998807907104, 0.6999999284744263, 1.8333332538604736, 0.6999999284744263, 1.8333332538604736, 0.7499999403953552, 1.8333332538604736, 0.6999999284744263, 1.7499998807907104, 0.6999999284744263, 1.7499998807907104, 0.6499999165534973, 1.7499998807907104, 0.6499999165534973, 1.8333332538604736, 0.6499999165534973, 1.8333332538604736, 0.6999999284744263, 1.8333332538604736, 0.6499999165534973, 1.7499998807907104, 0.6499999165534973, 1.7499998807907104, 0.5999999046325684, 1.7499998807907104, 0.5999999046325684, 1.8333332538604736, 0.5999999046325684, 1.8333332538604736, 0.6499999165534973, 1.8333332538604736, 0.5999999046325684, 1.7499998807907104, 0.5999999046325684, 1.7499998807907104, 0.5499998927116394, 1.7499998807907104, 0.5499998927116394, 1.8333332538604736, 0.5499998927116394, 1.8333332538604736, 0.5999999046325684, 1.8333332538604736, 0.5499998927116394, 1.7499998807907104, 0.5499998927116394, 1.7499998807907104, 0.49999988079071045, 1.7499998807907104, 0.49999988079071045, 1.8333332538604736, 0.49999988079071045, 1.8333332538604736, 0.5499998927116394, 1.8333332538604736, 0.49999988079071045, 1.7499998807907104, 0.49999988079071045, 1.7499998807907104, 0.4499998688697815, 1.7499998807907104, 0.4499998688697815, 1.8333332538604736, 0.4499998688697815, 1.8333332538604736, 0.49999988079071045, 1.8333332538604736, 0.4499998688697815, 1.7499998807907104, 0.4499998688697815, 1.7499998807907104, 0.39999985694885254, 1.7499998807907104, 0.39999985694885254, 1.8333332538604736, 0.39999985694885254, 1.8333332538604736, 0.4499998688697815, 1.7499998807907104, 1, 1.6666665077209472, 1, 1.6666665077209472, 0.949999988079071, 1.6666665077209472, 0.949999988079071, 1.7499998807907104, 0.949999988079071, 1.7499998807907104, 1, 1.7499998807907104, 0.949999988079071, 1.6666665077209472, 0.949999988079071, 1.6666665077209472, 0.8999999761581421, 1.6666665077209472, 0.8999999761581421, 1.7499998807907104, 0.8999999761581421, 1.7499998807907104, 0.949999988079071, 1.7499998807907104, 0.8999999761581421, 1.6666665077209472, 0.8999999761581421, 1.6666665077209472, 0.8499999642372131, 1.6666665077209472, 0.8499999642372131, 1.7499998807907104, 0.8499999642372131, 1.7499998807907104, 0.8999999761581421, 1.7499998807907104, 0.8499999642372131, 1.6666665077209472, 0.8499999642372131, 1.6666665077209472, 0.7999999523162842, 1.6666665077209472, 0.7999999523162842, 1.7499998807907104, 0.7999999523162842, 1.7499998807907104, 0.8499999642372131, 1.7499998807907104, 0.7999999523162842, 1.6666665077209472, 0.7999999523162842, 1.6666665077209472, 0.7499999403953552, 1.6666665077209472, 0.7499999403953552, 1.7499998807907104, 0.7499999403953552, 1.7499998807907104, 0.7999999523162842, 1.7499998807907104, 0.7499999403953552, 1.6666665077209472, 0.7499999403953552, 1.6666665077209472, 0.6999999284744263, 1.6666665077209472, 0.6999999284744263, 1.7499998807907104, 0.6999999284744263, 1.7499998807907104, 0.7499999403953552, 1.7499998807907104, 0.6999999284744263, 1.6666665077209472, 0.6999999284744263, 1.6666665077209472, 0.6499999165534973, 1.6666665077209472, 0.6499999165534973, 1.7499998807907104, 0.6499999165534973, 1.7499998807907104, 0.6999999284744263, 1.7499998807907104, 0.6499999165534973, 1.6666665077209472, 0.6499999165534973, 1.6666665077209472, 0.5999999046325684, 1.6666665077209472, 0.5999999046325684, 1.7499998807907104, 0.5999999046325684, 1.7499998807907104, 0.6499999165534973, 1.7499998807907104, 0.5999999046325684, 1.6666665077209472, 0.5999999046325684, 1.6666665077209472, 0.5499998927116394, 1.6666665077209472, 0.5499998927116394, 1.7499998807907104, 0.5499998927116394, 1.7499998807907104, 0.5999999046325684, 1.7499998807907104, 0.5499998927116394, 1.6666665077209472, 0.5499998927116394, 1.6666665077209472, 0.49999988079071045, 1.6666665077209472, 0.49999988079071045, 1.7499998807907104, 0.49999988079071045, 1.7499998807907104, 0.5499998927116394, 1.7499998807907104, 0.49999988079071045, 1.6666665077209472, 0.49999988079071045, 1.6666665077209472, 0.4499998688697815, 1.6666665077209472, 0.4499998688697815, 1.7499998807907104, 0.4499998688697815, 1.7499998807907104, 0.49999988079071045, 1.7499998807907104, 0.4499998688697815, 1.6666665077209472, 0.4499998688697815, 1.6666665077209472, 0.39999985694885254, 1.6666665077209472, 0.39999985694885254, 1.7499998807907104, 0.39999985694885254, 1.7499998807907104, 0.4499998688697815, 1.6666665077209472, 1, 1.583333134651184, 1, 1.583333134651184, 0.949999988079071, 1.583333134651184, 0.949999988079071, 1.6666665077209472, 0.949999988079071, 1.6666665077209472, 1, 1.6666665077209472, 0.949999988079071, 1.583333134651184, 0.949999988079071, 1.583333134651184, 0.8999999761581421, 1.583333134651184, 0.8999999761581421, 1.6666665077209472, 0.8999999761581421, 1.6666665077209472, 0.949999988079071, 1.6666665077209472, 0.8999999761581421, 1.583333134651184, 0.8999999761581421, 1.583333134651184, 0.8499999642372131, 1.583333134651184, 0.8499999642372131, 1.6666665077209472, 0.8499999642372131, 1.6666665077209472, 0.8999999761581421, 1.6666665077209472, 0.8499999642372131, 1.583333134651184, 0.8499999642372131, 1.583333134651184, 0.7999999523162842, 1.583333134651184, 0.7999999523162842, 1.6666665077209472, 0.7999999523162842, 1.6666665077209472, 0.8499999642372131, 1.6666665077209472, 0.7999999523162842, 1.583333134651184, 0.7999999523162842, 1.583333134651184, 0.7499999403953552, 1.583333134651184, 0.7499999403953552, 1.6666665077209472, 0.7499999403953552, 1.6666665077209472, 0.7999999523162842, 1.6666665077209472, 0.7499999403953552, 1.583333134651184, 0.7499999403953552, 1.583333134651184, 0.6999999284744263, 1.583333134651184, 0.6999999284744263, 1.6666665077209472, 0.6999999284744263, 1.6666665077209472, 0.7499999403953552, 1.6666665077209472, 0.6999999284744263, 1.583333134651184, 0.6999999284744263, 1.583333134651184, 0.6499999165534973, 1.583333134651184, 0.6499999165534973, 1.6666665077209472, 0.6499999165534973, 1.6666665077209472, 0.6999999284744263, 1.6666665077209472, 0.6499999165534973, 1.583333134651184, 0.6499999165534973, 1.583333134651184, 0.5999999046325684, 1.583333134651184, 0.5999999046325684, 1.6666665077209472, 0.5999999046325684, 1.6666665077209472, 0.6499999165534973, 1.6666665077209472, 0.5999999046325684, 1.583333134651184, 0.5999999046325684, 1.583333134651184, 0.5499998927116394, 1.583333134651184, 0.5499998927116394, 1.6666665077209472, 0.5499998927116394, 1.6666665077209472, 0.5999999046325684, 1.6666665077209472, 0.5499998927116394, 1.583333134651184, 0.5499998927116394, 1.583333134651184, 0.49999988079071045, 1.583333134651184, 0.49999988079071045, 1.6666665077209472, 0.49999988079071045, 1.6666665077209472, 0.5499998927116394, 1.6666665077209472, 0.49999988079071045, 1.583333134651184, 0.49999988079071045, 1.583333134651184, 0.4499998688697815, 1.583333134651184, 0.4499998688697815, 1.6666665077209472, 0.4499998688697815, 1.6666665077209472, 0.49999988079071045, 1.6666665077209472, 0.4499998688697815, 1.583333134651184, 0.4499998688697815, 1.583333134651184, 0.39999985694885254, 1.583333134651184, 0.39999985694885254, 1.6666665077209472, 0.39999985694885254, 1.6666665077209472, 0.4499998688697815, 1.583333134651184, 1, 1.499999761581421, 1, 1.499999761581421, 0.949999988079071, 1.499999761581421, 0.949999988079071, 1.583333134651184, 0.949999988079071, 1.583333134651184, 1, 1.583333134651184, 0.949999988079071, 1.499999761581421, 0.949999988079071, 1.499999761581421, 0.8999999761581421, 1.499999761581421, 0.8999999761581421, 1.583333134651184, 0.8999999761581421, 1.583333134651184, 0.949999988079071, 1.583333134651184, 0.8999999761581421, 1.499999761581421, 0.8999999761581421, 1.499999761581421, 0.8499999642372131, 1.499999761581421, 0.8499999642372131, 1.583333134651184, 0.8499999642372131, 1.583333134651184, 0.8999999761581421, 1.583333134651184, 0.8499999642372131, 1.499999761581421, 0.8499999642372131, 1.499999761581421, 0.7999999523162842, 1.499999761581421, 0.7999999523162842, 1.583333134651184, 0.7999999523162842, 1.583333134651184, 0.8499999642372131, 1.583333134651184, 0.7999999523162842, 1.499999761581421, 0.7999999523162842, 1.499999761581421, 0.7499999403953552, 1.499999761581421, 0.7499999403953552, 1.583333134651184, 0.7499999403953552, 1.583333134651184, 0.7999999523162842, 1.583333134651184, 0.7499999403953552, 1.499999761581421, 0.7499999403953552, 1.499999761581421, 0.6999999284744263, 1.499999761581421, 0.6999999284744263, 1.583333134651184, 0.6999999284744263, 1.583333134651184, 0.7499999403953552, 1.583333134651184, 0.6999999284744263, 1.499999761581421, 0.6999999284744263, 1.499999761581421, 0.6499999165534973, 1.499999761581421, 0.6499999165534973, 1.583333134651184, 0.6499999165534973, 1.583333134651184, 0.6999999284744263, 1.583333134651184, 0.6499999165534973, 1.499999761581421, 0.6499999165534973, 1.499999761581421, 0.5999999046325684, 1.499999761581421, 0.5999999046325684, 1.583333134651184, 0.5999999046325684, 1.583333134651184, 0.6499999165534973, 1.583333134651184, 0.5999999046325684, 1.499999761581421, 0.5999999046325684, 1.499999761581421, 0.5499998927116394, 1.499999761581421, 0.5499998927116394, 1.583333134651184, 0.5499998927116394, 1.583333134651184, 0.5999999046325684, 1.583333134651184, 0.5499998927116394, 1.499999761581421, 0.5499998927116394, 1.499999761581421, 0.49999988079071045, 1.499999761581421, 0.49999988079071045, 1.583333134651184, 0.49999988079071045, 1.583333134651184, 0.5499998927116394, 1.583333134651184, 0.49999988079071045, 1.499999761581421, 0.49999988079071045, 1.499999761581421, 0.4499998688697815, 1.499999761581421, 0.4499998688697815, 1.583333134651184, 0.4499998688697815, 1.583333134651184, 0.49999988079071045, 1.583333134651184, 0.4499998688697815, 1.499999761581421, 0.4499998688697815, 1.499999761581421, 0.39999985694885254, 1.499999761581421, 0.39999985694885254, 1.583333134651184, 0.39999985694885254, 1.583333134651184, 0.4499998688697815, 1.499999761581421, 1, 1.4166663885116577, 1, 1.4166663885116577, 0.949999988079071, 1.4166663885116577, 0.949999988079071, 1.499999761581421, 0.949999988079071, 1.499999761581421, 1, 1.499999761581421, 0.949999988079071, 1.4166663885116577, 0.949999988079071, 1.4166663885116577, 0.8999999761581421, 1.4166663885116577, 0.8999999761581421, 1.499999761581421, 0.8999999761581421, 1.499999761581421, 0.949999988079071, 1.499999761581421, 0.8999999761581421, 1.4166663885116577, 0.8999999761581421, 1.4166663885116577, 0.8499999642372131, 1.4166663885116577, 0.8499999642372131, 1.499999761581421, 0.8499999642372131, 1.499999761581421, 0.8999999761581421, 1.499999761581421, 0.8499999642372131, 1.4166663885116577, 0.8499999642372131, 1.4166663885116577, 0.7999999523162842, 1.4166663885116577, 0.7999999523162842, 1.499999761581421, 0.7999999523162842, 1.499999761581421, 0.8499999642372131, 1.499999761581421, 0.7999999523162842, 1.4166663885116577, 0.7999999523162842, 1.4166663885116577, 0.7499999403953552, 1.4166663885116577, 0.7499999403953552, 1.499999761581421, 0.7499999403953552, 1.499999761581421, 0.7999999523162842, 1.499999761581421, 0.7499999403953552, 1.4166663885116577, 0.7499999403953552, 1.4166663885116577, 0.6999999284744263, 1.4166663885116577, 0.6999999284744263, 1.499999761581421, 0.6999999284744263, 1.499999761581421, 0.7499999403953552, 1.499999761581421, 0.6999999284744263, 1.4166663885116577, 0.6999999284744263, 1.4166663885116577, 0.6499999165534973, 1.4166663885116577, 0.6499999165534973, 1.499999761581421, 0.6499999165534973, 1.499999761581421, 0.6999999284744263, 1.499999761581421, 0.6499999165534973, 1.4166663885116577, 0.6499999165534973, 1.4166663885116577, 0.5999999046325684, 1.4166663885116577, 0.5999999046325684, 1.499999761581421, 0.5999999046325684, 1.499999761581421, 0.6499999165534973, 1.499999761581421, 0.5999999046325684, 1.4166663885116577, 0.5999999046325684, 1.4166663885116577, 0.5499998927116394, 1.4166663885116577, 0.5499998927116394, 1.499999761581421, 0.5499998927116394, 1.499999761581421, 0.5999999046325684, 1.499999761581421, 0.5499998927116394, 1.4166663885116577, 0.5499998927116394, 1.4166663885116577, 0.49999988079071045, 1.4166663885116577, 0.49999988079071045, 1.499999761581421, 0.49999988079071045, 1.499999761581421, 0.5499998927116394, 1.499999761581421, 0.49999988079071045, 1.4166663885116577, 0.49999988079071045, 1.4166663885116577, 0.4499998688697815, 1.4166663885116577, 0.4499998688697815, 1.499999761581421, 0.4499998688697815, 1.499999761581421, 0.49999988079071045, 1.499999761581421, 0.4499998688697815, 1.4166663885116577, 0.4499998688697815, 1.4166663885116577, 0.39999985694885254, 1.4166663885116577, 0.39999985694885254, 1.499999761581421, 0.39999985694885254, 1.499999761581421, 0.4499998688697815, 1.4166663885116577, 1, 1.3333330154418945, 1, 1.3333330154418945, 0.949999988079071, 1.3333330154418945, 0.949999988079071, 1.4166663885116577, 0.949999988079071, 1.4166663885116577, 1, 1.4166663885116577, 0.949999988079071, 1.3333330154418945, 0.949999988079071, 1.3333330154418945, 0.8999999761581421, 1.3333330154418945, 0.8999999761581421, 1.4166663885116577, 0.8999999761581421, 1.4166663885116577, 0.949999988079071, 1.4166663885116577, 0.8999999761581421, 1.3333330154418945, 0.8999999761581421, 1.3333330154418945, 0.8499999642372131, 1.3333330154418945, 0.8499999642372131, 1.4166663885116577, 0.8499999642372131, 1.4166663885116577, 0.8999999761581421, 1.4166663885116577, 0.8499999642372131, 1.3333330154418945, 0.8499999642372131, 1.3333330154418945, 0.7999999523162842, 1.3333330154418945, 0.7999999523162842, 1.4166663885116577, 0.7999999523162842, 1.4166663885116577, 0.8499999642372131, 1.4166663885116577, 0.7999999523162842, 1.3333330154418945, 0.7999999523162842, 1.3333330154418945, 0.7499999403953552, 1.3333330154418945, 0.7499999403953552, 1.4166663885116577, 0.7499999403953552, 1.4166663885116577, 0.7999999523162842, 1.4166663885116577, 0.7499999403953552, 1.3333330154418945, 0.7499999403953552, 1.3333330154418945, 0.6999999284744263, 1.3333330154418945, 0.6999999284744263, 1.4166663885116577, 0.6999999284744263, 1.4166663885116577, 0.7499999403953552, 1.4166663885116577, 0.6999999284744263, 1.3333330154418945, 0.6999999284744263, 1.3333330154418945, 0.6499999165534973, 1.3333330154418945, 0.6499999165534973, 1.4166663885116577, 0.6499999165534973, 1.4166663885116577, 0.6999999284744263, 1.4166663885116577, 0.6499999165534973, 1.3333330154418945, 0.6499999165534973, 1.3333330154418945, 0.5999999046325684, 1.3333330154418945, 0.5999999046325684, 1.4166663885116577, 0.5999999046325684, 1.4166663885116577, 0.6499999165534973, 1.4166663885116577, 0.5999999046325684, 1.3333330154418945, 0.5999999046325684, 1.3333330154418945, 0.5499998927116394, 1.3333330154418945, 0.5499998927116394, 1.4166663885116577, 0.5499998927116394, 1.4166663885116577, 0.5999999046325684, 1.4166663885116577, 0.5499998927116394, 1.3333330154418945, 0.5499998927116394, 1.3333330154418945, 0.49999988079071045, 1.3333330154418945, 0.49999988079071045, 1.4166663885116577, 0.49999988079071045, 1.4166663885116577, 0.5499998927116394, 1.4166663885116577, 0.49999988079071045, 1.3333330154418945, 0.49999988079071045, 1.3333330154418945, 0.4499998688697815, 1.3333330154418945, 0.4499998688697815, 1.4166663885116577, 0.4499998688697815, 1.4166663885116577, 0.49999988079071045, 1.4166663885116577, 0.4499998688697815, 1.3333330154418945, 0.4499998688697815, 1.3333330154418945, 0.39999985694885254, 1.3333330154418945, 0.39999985694885254, 1.4166663885116577, 0.39999985694885254, 1.4166663885116577, 0.4499998688697815, 1.3333330154418945, 1, 1.2499996423721313, 1, 1.2499996423721313, 0.949999988079071, 1.2499996423721313, 0.949999988079071, 1.3333330154418945, 0.949999988079071, 1.3333330154418945, 1, 1.3333330154418945, 0.949999988079071, 1.2499996423721313, 0.949999988079071, 1.2499996423721313, 0.8999999761581421, 1.2499996423721313, 0.8999999761581421, 1.3333330154418945, 0.8999999761581421, 1.3333330154418945, 0.949999988079071, 1.3333330154418945, 0.8999999761581421, 1.2499996423721313, 0.8999999761581421, 1.2499996423721313, 0.8499999642372131, 1.2499996423721313, 0.8499999642372131, 1.3333330154418945, 0.8499999642372131, 1.3333330154418945, 0.8999999761581421, 1.3333330154418945, 0.8499999642372131, 1.2499996423721313, 0.8499999642372131, 1.2499996423721313, 0.7999999523162842, 1.2499996423721313, 0.7999999523162842, 1.3333330154418945, 0.7999999523162842, 1.3333330154418945, 0.8499999642372131, 1.3333330154418945, 0.7999999523162842, 1.2499996423721313, 0.7999999523162842, 1.2499996423721313, 0.7499999403953552, 1.2499996423721313, 0.7499999403953552, 1.3333330154418945, 0.7499999403953552, 1.3333330154418945, 0.7999999523162842, 1.3333330154418945, 0.7499999403953552, 1.2499996423721313, 0.7499999403953552, 1.2499996423721313, 0.6999999284744263, 1.2499996423721313, 0.6999999284744263, 1.3333330154418945, 0.6999999284744263, 1.3333330154418945, 0.7499999403953552, 1.3333330154418945, 0.6999999284744263, 1.2499996423721313, 0.6999999284744263, 1.2499996423721313, 0.6499999165534973, 1.2499996423721313, 0.6499999165534973, 1.3333330154418945, 0.6499999165534973, 1.3333330154418945, 0.6999999284744263, 1.3333330154418945, 0.6499999165534973, 1.2499996423721313, 0.6499999165534973, 1.2499996423721313, 0.5999999046325684, 1.2499996423721313, 0.5999999046325684, 1.3333330154418945, 0.5999999046325684, 1.3333330154418945, 0.6499999165534973, 1.3333330154418945, 0.5999999046325684, 1.2499996423721313, 0.5999999046325684, 1.2499996423721313, 0.5499998927116394, 1.2499996423721313, 0.5499998927116394, 1.3333330154418945, 0.5499998927116394, 1.3333330154418945, 0.5999999046325684, 1.3333330154418945, 0.5499998927116394, 1.2499996423721313, 0.5499998927116394, 1.2499996423721313, 0.49999988079071045, 1.2499996423721313, 0.49999988079071045, 1.3333330154418945, 0.49999988079071045, 1.3333330154418945, 0.5499998927116394, 1.3333330154418945, 0.49999988079071045, 1.2499996423721313, 0.49999988079071045, 1.2499996423721313, 0.4499998688697815, 1.2499996423721313, 0.4499998688697815, 1.3333330154418945, 0.4499998688697815, 1.3333330154418945, 0.49999988079071045, 1.3333330154418945, 0.4499998688697815, 1.2499996423721313, 0.4499998688697815, 1.2499996423721313, 0.39999985694885254, 1.2499996423721313, 0.39999985694885254, 1.3333330154418945, 0.39999985694885254, 1.3333330154418945, 0.4499998688697815, 1.2499996423721313, 1, 1.1666662693023681, 1, 1.1666662693023681, 0.949999988079071, 1.1666662693023681, 0.949999988079071, 1.2499996423721313, 0.949999988079071, 1.2499996423721313, 1, 1.2499996423721313, 0.949999988079071, 1.1666662693023681, 0.949999988079071, 1.1666662693023681, 0.8999999761581421, 1.1666662693023681, 0.8999999761581421, 1.2499996423721313, 0.8999999761581421, 1.2499996423721313, 0.949999988079071, 1.2499996423721313, 0.8999999761581421, 1.1666662693023681, 0.8999999761581421, 1.1666662693023681, 0.8499999642372131, 1.1666662693023681, 0.8499999642372131, 1.2499996423721313, 0.8499999642372131, 1.2499996423721313, 0.8999999761581421, 1.2499996423721313, 0.8499999642372131, 1.1666662693023681, 0.8499999642372131, 1.1666662693023681, 0.7999999523162842, 1.1666662693023681, 0.7999999523162842, 1.2499996423721313, 0.7999999523162842, 1.2499996423721313, 0.8499999642372131, 1.2499996423721313, 0.7999999523162842, 1.1666662693023681, 0.7999999523162842, 1.1666662693023681, 0.7499999403953552, 1.1666662693023681, 0.7499999403953552, 1.2499996423721313, 0.7499999403953552, 1.2499996423721313, 0.7999999523162842, 1.2499996423721313, 0.7499999403953552, 1.1666662693023681, 0.7499999403953552, 1.1666662693023681, 0.6999999284744263, 1.1666662693023681, 0.6999999284744263, 1.2499996423721313, 0.6999999284744263, 1.2499996423721313, 0.7499999403953552, 1.2499996423721313, 0.6999999284744263, 1.1666662693023681, 0.6999999284744263, 1.1666662693023681, 0.6499999165534973, 1.1666662693023681, 0.6499999165534973, 1.2499996423721313, 0.6499999165534973, 1.2499996423721313, 0.6999999284744263, 1.2499996423721313, 0.6499999165534973, 1.1666662693023681, 0.6499999165534973, 1.1666662693023681, 0.5999999046325684, 1.1666662693023681, 0.5999999046325684, 1.2499996423721313, 0.5999999046325684, 1.2499996423721313, 0.6499999165534973, 1.2499996423721313, 0.5999999046325684, 1.1666662693023681, 0.5999999046325684, 1.1666662693023681, 0.5499998927116394, 1.1666662693023681, 0.5499998927116394, 1.2499996423721313, 0.5499998927116394, 1.2499996423721313, 0.5999999046325684, 1.2499996423721313, 0.5499998927116394, 1.1666662693023681, 0.5499998927116394, 1.1666662693023681, 0.49999988079071045, 1.1666662693023681, 0.49999988079071045, 1.2499996423721313, 0.49999988079071045, 1.2499996423721313, 0.5499998927116394, 1.2499996423721313, 0.49999988079071045, 1.1666662693023681, 0.49999988079071045, 1.1666662693023681, 0.4499998688697815, 1.1666662693023681, 0.4499998688697815, 1.2499996423721313, 0.4499998688697815, 1.2499996423721313, 0.49999988079071045, 1.2499996423721313, 0.4499998688697815, 1.1666662693023681, 0.4499998688697815, 1.1666662693023681, 0.39999985694885254, 1.1666662693023681, 0.39999985694885254, 1.2499996423721313, 0.39999985694885254, 1.2499996423721313, 0.4499998688697815, 1.1666662693023681, 1, 1.083332896232605, 1, 1.083332896232605, 0.949999988079071, 1.083332896232605, 0.949999988079071, 1.1666662693023681, 0.949999988079071, 1.1666662693023681, 1, 1.1666662693023681, 0.949999988079071, 1.083332896232605, 0.949999988079071, 1.083332896232605, 0.8999999761581421, 1.083332896232605, 0.8999999761581421, 1.1666662693023681, 0.8999999761581421, 1.1666662693023681, 0.949999988079071, 1.1666662693023681, 0.8999999761581421, 1.083332896232605, 0.8999999761581421, 1.083332896232605, 0.8499999642372131, 1.083332896232605, 0.8499999642372131, 1.1666662693023681, 0.8499999642372131, 1.1666662693023681, 0.8999999761581421, 1.1666662693023681, 0.8499999642372131, 1.083332896232605, 0.8499999642372131, 1.083332896232605, 0.7999999523162842, 1.083332896232605, 0.7999999523162842, 1.1666662693023681, 0.7999999523162842, 1.1666662693023681, 0.8499999642372131, 1.1666662693023681, 0.7999999523162842, 1.083332896232605, 0.7999999523162842, 1.083332896232605, 0.7499999403953552, 1.083332896232605, 0.7499999403953552, 1.1666662693023681, 0.7499999403953552, 1.1666662693023681, 0.7999999523162842, 1.1666662693023681, 0.7499999403953552, 1.083332896232605, 0.7499999403953552, 1.083332896232605, 0.6999999284744263, 1.083332896232605, 0.6999999284744263, 1.1666662693023681, 0.6999999284744263, 1.1666662693023681, 0.7499999403953552, 1.1666662693023681, 0.6999999284744263, 1.083332896232605, 0.6999999284744263, 1.083332896232605, 0.6499999165534973, 1.083332896232605, 0.6499999165534973, 1.1666662693023681, 0.6499999165534973, 1.1666662693023681, 0.6999999284744263, 1.1666662693023681, 0.6499999165534973, 1.083332896232605, 0.6499999165534973, 1.083332896232605, 0.5999999046325684, 1.083332896232605, 0.5999999046325684, 1.1666662693023681, 0.5999999046325684, 1.1666662693023681, 0.6499999165534973, 1.1666662693023681, 0.5999999046325684, 1.083332896232605, 0.5999999046325684, 1.083332896232605, 0.5499998927116394, 1.083332896232605, 0.5499998927116394, 1.1666662693023681, 0.5499998927116394, 1.1666662693023681, 0.5999999046325684, 1.1666662693023681, 0.5499998927116394, 1.083332896232605, 0.5499998927116394, 1.083332896232605, 0.49999988079071045, 1.083332896232605, 0.49999988079071045, 1.1666662693023681, 0.49999988079071045, 1.1666662693023681, 0.5499998927116394, 1.1666662693023681, 0.49999988079071045, 1.083332896232605, 0.49999988079071045, 1.083332896232605, 0.4499998688697815, 1.083332896232605, 0.4499998688697815, 1.1666662693023681, 0.4499998688697815, 1.1666662693023681, 0.49999988079071045, 1.1666662693023681, 0.4499998688697815, 1.083332896232605, 0.4499998688697815, 1.083332896232605, 0.39999985694885254, 1.083332896232605, 0.39999985694885254, 1.1666662693023681, 0.39999985694885254, 1.1666662693023681, 0.4499998688697815, 1.083332896232605, 1, 0.9999995827674866, 1, 0.9999995827674866, 0.949999988079071, 0.9999995827674866, 0.949999988079071, 1.083332896232605, 0.949999988079071, 1.083332896232605, 1, 1.083332896232605, 0.949999988079071, 0.9999995827674866, 0.949999988079071, 0.9999995827674866, 0.8999999761581421, 0.9999995827674866, 0.8999999761581421, 1.083332896232605, 0.8999999761581421, 1.083332896232605, 0.949999988079071, 1.083332896232605, 0.8999999761581421, 0.9999995827674866, 0.8999999761581421, 0.9999995827674866, 0.8499999642372131, 0.9999995827674866, 0.8499999642372131, 1.083332896232605, 0.8499999642372131, 1.083332896232605, 0.8999999761581421, 1.083332896232605, 0.8499999642372131, 0.9999995827674866, 0.8499999642372131, 0.9999995827674866, 0.7999999523162842, 0.9999995827674866, 0.7999999523162842, 1.083332896232605, 0.7999999523162842, 1.083332896232605, 0.8499999642372131, 1.083332896232605, 0.7999999523162842, 0.9999995827674866, 0.7999999523162842, 0.9999995827674866, 0.7499999403953552, 0.9999995827674866, 0.7499999403953552, 1.083332896232605, 0.7499999403953552, 1.083332896232605, 0.7999999523162842, 1.083332896232605, 0.7499999403953552, 0.9999995827674866, 0.7499999403953552, 0.9999995827674866, 0.6999999284744263, 0.9999995827674866, 0.6999999284744263, 1.083332896232605, 0.6999999284744263, 1.083332896232605, 0.7499999403953552, 1.083332896232605, 0.6999999284744263, 0.9999995827674866, 0.6999999284744263, 0.9999995827674866, 0.6499999165534973, 0.9999995827674866, 0.6499999165534973, 1.083332896232605, 0.6499999165534973, 1.083332896232605, 0.6999999284744263, 1.083332896232605, 0.6499999165534973, 0.9999995827674866, 0.6499999165534973, 0.9999995827674866, 0.5999999046325684, 0.9999995827674866, 0.5999999046325684, 1.083332896232605, 0.5999999046325684, 1.083332896232605, 0.6499999165534973, 1.083332896232605, 0.5999999046325684, 0.9999995827674866, 0.5999999046325684, 0.9999995827674866, 0.5499998927116394, 0.9999995827674866, 0.5499998927116394, 1.083332896232605, 0.5499998927116394, 1.083332896232605, 0.5999999046325684, 1.083332896232605, 0.5499998927116394, 0.9999995827674866, 0.5499998927116394, 0.9999995827674866, 0.49999988079071045, 0.9999995827674866, 0.49999988079071045, 1.083332896232605, 0.49999988079071045, 1.083332896232605, 0.5499998927116394, 1.083332896232605, 0.49999988079071045, 0.9999995827674866, 0.49999988079071045, 0.9999995827674866, 0.4499998688697815, 0.9999995827674866, 0.4499998688697815, 1.083332896232605, 0.4499998688697815, 1.083332896232605, 0.49999988079071045, 1.083332896232605, 0.4499998688697815, 0.9999995827674866, 0.4499998688697815, 0.9999995827674866, 0.39999985694885254, 0.9999995827674866, 0.39999985694885254, 1.083332896232605, 0.39999985694885254, 1.083332896232605, 0.4499998688697815, 1, 1, 0.9166666865348816, 1, 0.9166666865348816, 0.949999988079071, 0.9166666865348816, 0.949999988079071, 1, 0.949999988079071, 1, 1, 1, 0.949999988079071, 0.9166666865348816, 0.949999988079071, 0.9166666865348816, 0.8999999761581421, 0.9166666865348816, 0.8999999761581421, 1, 0.8999999761581421, 1, 0.949999988079071, 1, 0.8999999761581421, 0.9166666865348816, 0.8999999761581421, 0.9166666865348816, 0.8499999642372131, 0.9166666865348816, 0.8499999642372131, 1, 0.8499999642372131, 1, 0.8999999761581421, 1, 0.8499999642372131, 0.9166666865348816, 0.8499999642372131, 0.9166666865348816, 0.7999999523162842, 0.9166666865348816, 0.7999999523162842, 1, 0.7999999523162842, 1, 0.8499999642372131, 1, 0.7999999523162842, 0.9166666865348816, 0.7999999523162842, 0.9166666865348816, 0.7499999403953552, 0.9166666865348816, 0.7499999403953552, 1, 0.7499999403953552, 1, 0.7999999523162842, 1, 0.7499999403953552, 0.9166666865348816, 0.7499999403953552, 0.9166666865348816, 0.6999999284744263, 0.9166666865348816, 0.6999999284744263, 1, 0.6999999284744263, 1, 0.7499999403953552, 1, 0.6999999284744263, 0.9166666865348816, 0.6999999284744263, 0.9166666865348816, 0.6499999165534973, 0.9166666865348816, 0.6499999165534973, 1, 0.6499999165534973, 1, 0.6999999284744263, 1, 0.6499999165534973, 0.9166666865348816, 0.6499999165534973, 0.9166666865348816, 0.5999999046325684, 0.9166666865348816, 0.5999999046325684, 1, 0.5999999046325684, 1, 0.6499999165534973, 1, 0.5999999046325684, 0.9166666865348816, 0.5999999046325684, 0.9166666865348816, 0.5499998927116394, 0.9166666865348816, 0.5499998927116394, 1, 0.5499998927116394, 1, 0.5999999046325684, 1, 0.5499998927116394, 0.9166666865348816, 0.5499998927116394, 0.9166666865348816, 0.49999988079071045, 0.9166666865348816, 0.49999988079071045, 1, 0.49999988079071045, 1, 0.5499998927116394, 1, 0.49999988079071045, 0.9166666865348816, 0.49999988079071045, 0.9166666865348816, 0.4499998688697815, 0.9166666865348816, 0.4499998688697815, 1, 0.4499998688697815, 1, 0.49999988079071045, 1, 0.4499998688697815, 0.9166666865348816, 0.4499998688697815, 0.9166666865348816, 0.39999985694885254, 0.9166666865348816, 0.39999985694885254, 1, 0.39999985694885254, 1, 0.4499998688697815, 0.9166666865348816, 1, 0.8333333730697632, 1, 0.8333333730697632, 0.949999988079071, 0.8333333730697632, 0.949999988079071, 0.9166666865348816, 0.949999988079071, 0.9166666865348816, 1, 0.9166666865348816, 0.949999988079071, 0.8333333730697632, 0.949999988079071, 0.8333333730697632, 0.8999999761581421, 0.8333333730697632, 0.8999999761581421, 0.9166666865348816, 0.8999999761581421, 0.9166666865348816, 0.949999988079071, 0.9166666865348816, 0.8999999761581421, 0.8333333730697632, 0.8999999761581421, 0.8333333730697632, 0.8499999642372131, 0.8333333730697632, 0.8499999642372131, 0.9166666865348816, 0.8499999642372131, 0.9166666865348816, 0.8999999761581421, 0.9166666865348816, 0.8499999642372131, 0.8333333730697632, 0.8499999642372131, 0.8333333730697632, 0.7999999523162842, 0.8333333730697632, 0.7999999523162842, 0.9166666865348816, 0.7999999523162842, 0.9166666865348816, 0.8499999642372131, 0.9166666865348816, 0.7999999523162842, 0.8333333730697632, 0.7999999523162842, 0.8333333730697632, 0.7499999403953552, 0.8333333730697632, 0.7499999403953552, 0.9166666865348816, 0.7499999403953552, 0.9166666865348816, 0.7999999523162842, 0.9166666865348816, 0.7499999403953552, 0.8333333730697632, 0.7499999403953552, 0.8333333730697632, 0.6999999284744263, 0.8333333730697632, 0.6999999284744263, 0.9166666865348816, 0.6999999284744263, 0.9166666865348816, 0.7499999403953552, 0.9166666865348816, 0.6999999284744263, 0.8333333730697632, 0.6999999284744263, 0.8333333730697632, 0.6499999165534973, 0.8333333730697632, 0.6499999165534973, 0.9166666865348816, 0.6499999165534973, 0.9166666865348816, 0.6999999284744263, 0.9166666865348816, 0.6499999165534973, 0.8333333730697632, 0.6499999165534973, 0.8333333730697632, 0.5999999046325684, 0.8333333730697632, 0.5999999046325684, 0.9166666865348816, 0.5999999046325684, 0.9166666865348816, 0.6499999165534973, 0.9166666865348816, 0.5999999046325684, 0.8333333730697632, 0.5999999046325684, 0.8333333730697632, 0.5499998927116394, 0.8333333730697632, 0.5499998927116394, 0.9166666865348816, 0.5499998927116394, 0.9166666865348816, 0.5999999046325684, 0.9166666865348816, 0.5499998927116394, 0.8333333730697632, 0.5499998927116394, 0.8333333730697632, 0.49999988079071045, 0.8333333730697632, 0.49999988079071045, 0.9166666865348816, 0.49999988079071045, 0.9166666865348816, 0.5499998927116394, 0.9166666865348816, 0.49999988079071045, 0.8333333730697632, 0.49999988079071045, 0.8333333730697632, 0.4499998688697815, 0.8333333730697632, 0.4499998688697815, 0.9166666865348816, 0.4499998688697815, 0.9166666865348816, 0.49999988079071045, 0.9166666865348816, 0.4499998688697815, 0.8333333730697632, 0.4499998688697815, 0.8333333730697632, 0.39999985694885254, 0.8333333730697632, 0.39999985694885254, 0.9166666865348816, 0.39999985694885254, 0.9166666865348816, 0.4499998688697815, 0.8333333730697632, 1, 0.7500000596046448, 1, 0.7500000596046448, 0.949999988079071, 0.7500000596046448, 0.949999988079071, 0.8333333730697632, 0.949999988079071, 0.8333333730697632, 1, 0.8333333730697632, 0.949999988079071, 0.7500000596046448, 0.949999988079071, 0.7500000596046448, 0.8999999761581421, 0.7500000596046448, 0.8999999761581421, 0.8333333730697632, 0.8999999761581421, 0.8333333730697632, 0.949999988079071, 0.8333333730697632, 0.8999999761581421, 0.7500000596046448, 0.8999999761581421, 0.7500000596046448, 0.8499999642372131, 0.7500000596046448, 0.8499999642372131, 0.8333333730697632, 0.8499999642372131, 0.8333333730697632, 0.8999999761581421, 0.8333333730697632, 0.8499999642372131, 0.7500000596046448, 0.8499999642372131, 0.7500000596046448, 0.7999999523162842, 0.7500000596046448, 0.7999999523162842, 0.8333333730697632, 0.7999999523162842, 0.8333333730697632, 0.8499999642372131, 0.8333333730697632, 0.7999999523162842, 0.7500000596046448, 0.7999999523162842, 0.7500000596046448, 0.7499999403953552, 0.7500000596046448, 0.7499999403953552, 0.8333333730697632, 0.7499999403953552, 0.8333333730697632, 0.7999999523162842, 0.8333333730697632, 0.7499999403953552, 0.7500000596046448, 0.7499999403953552, 0.7500000596046448, 0.6999999284744263, 0.7500000596046448, 0.6999999284744263, 0.8333333730697632, 0.6999999284744263, 0.8333333730697632, 0.7499999403953552, 0.8333333730697632, 0.6999999284744263, 0.7500000596046448, 0.6999999284744263, 0.7500000596046448, 0.6499999165534973, 0.7500000596046448, 0.6499999165534973, 0.8333333730697632, 0.6499999165534973, 0.8333333730697632, 0.6999999284744263, 0.8333333730697632, 0.6499999165534973, 0.7500000596046448, 0.6499999165534973, 0.7500000596046448, 0.5999999046325684, 0.7500000596046448, 0.5999999046325684, 0.8333333730697632, 0.5999999046325684, 0.8333333730697632, 0.6499999165534973, 0.8333333730697632, 0.5999999046325684, 0.7500000596046448, 0.5999999046325684, 0.7500000596046448, 0.5499998927116394, 0.7500000596046448, 0.5499998927116394, 0.8333333730697632, 0.5499998927116394, 0.8333333730697632, 0.5999999046325684, 0.8333333730697632, 0.5499998927116394, 0.7500000596046448, 0.5499998927116394, 0.7500000596046448, 0.49999988079071045, 0.7500000596046448, 0.49999988079071045, 0.8333333730697632, 0.49999988079071045, 0.8333333730697632, 0.5499998927116394, 0.8333333730697632, 0.49999988079071045, 0.7500000596046448, 0.49999988079071045, 0.7500000596046448, 0.4499998688697815, 0.7500000596046448, 0.4499998688697815, 0.8333333730697632, 0.4499998688697815, 0.8333333730697632, 0.49999988079071045, 0.8333333730697632, 0.4499998688697815, 0.7500000596046448, 0.4499998688697815, 0.7500000596046448, 0.39999985694885254, 0.7500000596046448, 0.39999985694885254, 0.8333333730697632, 0.39999985694885254, 0.8333333730697632, 0.4499998688697815, 0.7500000596046448, 1, 0.6666667461395264, 1, 0.6666667461395264, 0.949999988079071, 0.6666667461395264, 0.949999988079071, 0.7500000596046448, 0.949999988079071, 0.7500000596046448, 1, 0.7500000596046448, 0.949999988079071, 0.6666667461395264, 0.949999988079071, 0.6666667461395264, 0.8999999761581421, 0.6666667461395264, 0.8999999761581421, 0.7500000596046448, 0.8999999761581421, 0.7500000596046448, 0.949999988079071, 0.7500000596046448, 0.8999999761581421, 0.6666667461395264, 0.8999999761581421, 0.6666667461395264, 0.8499999642372131, 0.6666667461395264, 0.8499999642372131, 0.7500000596046448, 0.8499999642372131, 0.7500000596046448, 0.8999999761581421, 0.7500000596046448, 0.8499999642372131, 0.6666667461395264, 0.8499999642372131, 0.6666667461395264, 0.7999999523162842, 0.6666667461395264, 0.7999999523162842, 0.7500000596046448, 0.7999999523162842, 0.7500000596046448, 0.8499999642372131, 0.7500000596046448, 0.7999999523162842, 0.6666667461395264, 0.7999999523162842, 0.6666667461395264, 0.7499999403953552, 0.6666667461395264, 0.7499999403953552, 0.7500000596046448, 0.7499999403953552, 0.7500000596046448, 0.7999999523162842, 0.7500000596046448, 0.7499999403953552, 0.6666667461395264, 0.7499999403953552, 0.6666667461395264, 0.6999999284744263, 0.6666667461395264, 0.6999999284744263, 0.7500000596046448, 0.6999999284744263, 0.7500000596046448, 0.7499999403953552, 0.7500000596046448, 0.6999999284744263, 0.6666667461395264, 0.6999999284744263, 0.6666667461395264, 0.6499999165534973, 0.6666667461395264, 0.6499999165534973, 0.7500000596046448, 0.6499999165534973, 0.7500000596046448, 0.6999999284744263, 0.7500000596046448, 0.6499999165534973, 0.6666667461395264, 0.6499999165534973, 0.6666667461395264, 0.5999999046325684, 0.6666667461395264, 0.5999999046325684, 0.7500000596046448, 0.5999999046325684, 0.7500000596046448, 0.6499999165534973, 0.7500000596046448, 0.5999999046325684, 0.6666667461395264, 0.5999999046325684, 0.6666667461395264, 0.5499998927116394, 0.6666667461395264, 0.5499998927116394, 0.7500000596046448, 0.5499998927116394, 0.7500000596046448, 0.5999999046325684, 0.7500000596046448, 0.5499998927116394, 0.6666667461395264, 0.5499998927116394, 0.6666667461395264, 0.49999988079071045, 0.6666667461395264, 0.49999988079071045, 0.7500000596046448, 0.49999988079071045, 0.7500000596046448, 0.5499998927116394, 0.7500000596046448, 0.49999988079071045, 0.6666667461395264, 0.49999988079071045, 0.6666667461395264, 0.4499998688697815, 0.6666667461395264, 0.4499998688697815, 0.7500000596046448, 0.4499998688697815, 0.7500000596046448, 0.49999988079071045, 0.7500000596046448, 0.4499998688697815, 0.6666667461395264, 0.4499998688697815, 0.6666667461395264, 0.39999985694885254, 0.6666667461395264, 0.39999985694885254, 0.7500000596046448, 0.39999985694885254, 0.7500000596046448, 0.4499998688697815, 0.6666667461395264, 1, 0.583333432674408, 1, 0.583333432674408, 0.949999988079071, 0.583333432674408, 0.949999988079071, 0.6666667461395264, 0.949999988079071, 0.6666667461395264, 1, 0.6666667461395264, 0.949999988079071, 0.583333432674408, 0.949999988079071, 0.583333432674408, 0.8999999761581421, 0.583333432674408, 0.8999999761581421, 0.6666667461395264, 0.8999999761581421, 0.6666667461395264, 0.949999988079071, 0.6666667461395264, 0.8999999761581421, 0.583333432674408, 0.8999999761581421, 0.583333432674408, 0.8499999642372131, 0.583333432674408, 0.8499999642372131, 0.6666667461395264, 0.8499999642372131, 0.6666667461395264, 0.8999999761581421, 0.6666667461395264, 0.8499999642372131, 0.583333432674408, 0.8499999642372131, 0.583333432674408, 0.7999999523162842, 0.583333432674408, 0.7999999523162842, 0.6666667461395264, 0.7999999523162842, 0.6666667461395264, 0.8499999642372131, 0.6666667461395264, 0.7999999523162842, 0.583333432674408, 0.7999999523162842, 0.583333432674408, 0.7499999403953552, 0.583333432674408, 0.7499999403953552, 0.6666667461395264, 0.7499999403953552, 0.6666667461395264, 0.7999999523162842, 0.6666667461395264, 0.7499999403953552, 0.583333432674408, 0.7499999403953552, 0.583333432674408, 0.6999999284744263, 0.583333432674408, 0.6999999284744263, 0.6666667461395264, 0.6999999284744263, 0.6666667461395264, 0.7499999403953552, 0.6666667461395264, 0.6999999284744263, 0.583333432674408, 0.6999999284744263, 0.583333432674408, 0.6499999165534973, 0.583333432674408, 0.6499999165534973, 0.6666667461395264, 0.6499999165534973, 0.6666667461395264, 0.6999999284744263, 0.6666667461395264, 0.6499999165534973, 0.583333432674408, 0.6499999165534973, 0.583333432674408, 0.5999999046325684, 0.583333432674408, 0.5999999046325684, 0.6666667461395264, 0.5999999046325684, 0.6666667461395264, 0.6499999165534973, 0.6666667461395264, 0.5999999046325684, 0.583333432674408, 0.5999999046325684, 0.583333432674408, 0.5499998927116394, 0.583333432674408, 0.5499998927116394, 0.6666667461395264, 0.5499998927116394, 0.6666667461395264, 0.5999999046325684, 0.6666667461395264, 0.5499998927116394, 0.583333432674408, 0.5499998927116394, 0.583333432674408, 0.49999988079071045, 0.583333432674408, 0.49999988079071045, 0.6666667461395264, 0.49999988079071045, 0.6666667461395264, 0.5499998927116394, 0.6666667461395264, 0.49999988079071045, 0.583333432674408, 0.49999988079071045, 0.583333432674408, 0.4499998688697815, 0.583333432674408, 0.4499998688697815, 0.6666667461395264, 0.4499998688697815, 0.6666667461395264, 0.49999988079071045, 0.6666667461395264, 0.4499998688697815, 0.583333432674408, 0.4499998688697815, 0.583333432674408, 0.39999985694885254, 0.583333432674408, 0.39999985694885254, 0.6666667461395264, 0.39999985694885254, 0.6666667461395264, 0.4499998688697815, 0.583333432674408, 1, 0.5000001192092895, 1, 0.5000001192092895, 0.949999988079071, 0.5000001192092895, 0.949999988079071, 0.583333432674408, 0.949999988079071, 0.583333432674408, 1, 0.583333432674408, 0.949999988079071, 0.5000001192092895, 0.949999988079071, 0.5000001192092895, 0.8999999761581421, 0.5000001192092895, 0.8999999761581421, 0.583333432674408, 0.8999999761581421, 0.583333432674408, 0.949999988079071, 0.583333432674408, 0.8999999761581421, 0.5000001192092895, 0.8999999761581421, 0.5000001192092895, 0.8499999642372131, 0.5000001192092895, 0.8499999642372131, 0.583333432674408, 0.8499999642372131, 0.583333432674408, 0.8999999761581421, 0.583333432674408, 0.8499999642372131, 0.5000001192092895, 0.8499999642372131, 0.5000001192092895, 0.7999999523162842, 0.5000001192092895, 0.7999999523162842, 0.583333432674408, 0.7999999523162842, 0.583333432674408, 0.8499999642372131, 0.583333432674408, 0.7999999523162842, 0.5000001192092895, 0.7999999523162842, 0.5000001192092895, 0.7499999403953552, 0.5000001192092895, 0.7499999403953552, 0.583333432674408, 0.7499999403953552, 0.583333432674408, 0.7999999523162842, 0.583333432674408, 0.7499999403953552, 0.5000001192092895, 0.7499999403953552, 0.5000001192092895, 0.6999999284744263, 0.5000001192092895, 0.6999999284744263, 0.583333432674408, 0.6999999284744263, 0.583333432674408, 0.7499999403953552, 0.583333432674408, 0.6999999284744263, 0.5000001192092895, 0.6999999284744263, 0.5000001192092895, 0.6499999165534973, 0.5000001192092895, 0.6499999165534973, 0.583333432674408, 0.6499999165534973, 0.583333432674408, 0.6999999284744263, 0.583333432674408, 0.6499999165534973, 0.5000001192092895, 0.6499999165534973, 0.5000001192092895, 0.5999999046325684, 0.5000001192092895, 0.5999999046325684, 0.583333432674408, 0.5999999046325684, 0.583333432674408, 0.6499999165534973, 0.583333432674408, 0.5999999046325684, 0.5000001192092895, 0.5999999046325684, 0.5000001192092895, 0.5499998927116394, 0.5000001192092895, 0.5499998927116394, 0.583333432674408, 0.5499998927116394, 0.583333432674408, 0.5999999046325684, 0.583333432674408, 0.5499998927116394, 0.5000001192092895, 0.5499998927116394, 0.5000001192092895, 0.49999988079071045, 0.5000001192092895, 0.49999988079071045, 0.583333432674408, 0.49999988079071045, 0.583333432674408, 0.5499998927116394, 0.583333432674408, 0.49999988079071045, 0.5000001192092895, 0.49999988079071045, 0.5000001192092895, 0.4499998688697815, 0.5000001192092895, 0.4499998688697815, 0.583333432674408, 0.4499998688697815, 0.583333432674408, 0.49999988079071045, 0.583333432674408, 0.4499998688697815, 0.5000001192092895, 0.4499998688697815, 0.5000001192092895, 0.39999985694885254, 0.5000001192092895, 0.39999985694885254, 0.583333432674408, 0.39999985694885254, 0.583333432674408, 0.4499998688697815, 0.5000001192092895, 1, 0.41666677594184875, 1, 0.41666677594184875, 0.949999988079071, 0.41666677594184875, 0.949999988079071, 0.5000001192092895, 0.949999988079071, 0.5000001192092895, 1, 0.5000001192092895, 0.949999988079071, 0.41666677594184875, 0.949999988079071, 0.41666677594184875, 0.8999999761581421, 0.41666677594184875, 0.8999999761581421, 0.5000001192092895, 0.8999999761581421, 0.5000001192092895, 0.949999988079071, 0.5000001192092895, 0.8999999761581421, 0.41666677594184875, 0.8999999761581421, 0.41666677594184875, 0.8499999642372131, 0.41666677594184875, 0.8499999642372131, 0.5000001192092895, 0.8499999642372131, 0.5000001192092895, 0.8999999761581421, 0.5000001192092895, 0.8499999642372131, 0.41666677594184875, 0.8499999642372131, 0.41666677594184875, 0.7999999523162842, 0.41666677594184875, 0.7999999523162842, 0.5000001192092895, 0.7999999523162842, 0.5000001192092895, 0.8499999642372131, 0.5000001192092895, 0.7999999523162842, 0.41666677594184875, 0.7999999523162842, 0.41666677594184875, 0.7499999403953552, 0.41666677594184875, 0.7499999403953552, 0.5000001192092895, 0.7499999403953552, 0.5000001192092895, 0.7999999523162842, 0.5000001192092895, 0.7499999403953552, 0.41666677594184875, 0.7499999403953552, 0.41666677594184875, 0.6999999284744263, 0.41666677594184875, 0.6999999284744263, 0.5000001192092895, 0.6999999284744263, 0.5000001192092895, 0.7499999403953552, 0.5000001192092895, 0.6999999284744263, 0.41666677594184875, 0.6999999284744263, 0.41666677594184875, 0.6499999165534973, 0.41666677594184875, 0.6499999165534973, 0.5000001192092895, 0.6499999165534973, 0.5000001192092895, 0.6999999284744263, 0.5000001192092895, 0.6499999165534973, 0.41666677594184875, 0.6499999165534973, 0.41666677594184875, 0.5999999046325684, 0.41666677594184875, 0.5999999046325684, 0.5000001192092895, 0.5999999046325684, 0.5000001192092895, 0.6499999165534973, 0.5000001192092895, 0.5999999046325684, 0.41666677594184875, 0.5999999046325684, 0.41666677594184875, 0.5499998927116394, 0.41666677594184875, 0.5499998927116394, 0.5000001192092895, 0.5499998927116394, 0.5000001192092895, 0.5999999046325684, 0.5000001192092895, 0.5499998927116394, 0.41666677594184875, 0.5499998927116394, 0.41666677594184875, 0.49999988079071045, 0.41666677594184875, 0.49999988079071045, 0.5000001192092895, 0.49999988079071045, 0.5000001192092895, 0.5499998927116394, 0.5000001192092895, 0.49999988079071045, 0.41666677594184875, 0.49999988079071045, 0.41666677594184875, 0.4499998688697815, 0.41666677594184875, 0.4499998688697815, 0.5000001192092895, 0.4499998688697815, 0.5000001192092895, 0.49999988079071045, 0.5000001192092895, 0.4499998688697815, 0.41666677594184875, 0.4499998688697815, 0.41666677594184875, 0.39999985694885254, 0.41666677594184875, 0.39999985694885254, 0.5000001192092895, 0.39999985694885254, 0.5000001192092895, 0.4499998688697815, 0.41666677594184875, 1, 0.33333343267440796, 1, 0.33333343267440796, 0.949999988079071, 0.33333343267440796, 0.949999988079071, 0.41666677594184875, 0.949999988079071, 0.41666677594184875, 1, 0.41666677594184875, 0.949999988079071, 0.33333343267440796, 0.949999988079071, 0.33333343267440796, 0.8999999761581421, 0.33333343267440796, 0.8999999761581421, 0.41666677594184875, 0.8999999761581421, 0.41666677594184875, 0.949999988079071, 0.41666677594184875, 0.8999999761581421, 0.33333343267440796, 0.8999999761581421, 0.33333343267440796, 0.8499999642372131, 0.33333343267440796, 0.8499999642372131, 0.41666677594184875, 0.8499999642372131, 0.41666677594184875, 0.8999999761581421, 0.41666677594184875, 0.8499999642372131, 0.33333343267440796, 0.8499999642372131, 0.33333343267440796, 0.7999999523162842, 0.33333343267440796, 0.7999999523162842, 0.41666677594184875, 0.7999999523162842, 0.41666677594184875, 0.8499999642372131, 0.41666677594184875, 0.7999999523162842, 0.33333343267440796, 0.7999999523162842, 0.33333343267440796, 0.7499999403953552, 0.33333343267440796, 0.7499999403953552, 0.41666677594184875, 0.7499999403953552, 0.41666677594184875, 0.7999999523162842, 0.41666677594184875, 0.7499999403953552, 0.33333343267440796, 0.7499999403953552, 0.33333343267440796, 0.6999999284744263, 0.33333343267440796, 0.6999999284744263, 0.41666677594184875, 0.6999999284744263, 0.41666677594184875, 0.7499999403953552, 0.41666677594184875, 0.6999999284744263, 0.33333343267440796, 0.6999999284744263, 0.33333343267440796, 0.6499999165534973, 0.33333343267440796, 0.6499999165534973, 0.41666677594184875, 0.6499999165534973, 0.41666677594184875, 0.6999999284744263, 0.41666677594184875, 0.6499999165534973, 0.33333343267440796, 0.6499999165534973, 0.33333343267440796, 0.5999999046325684, 0.33333343267440796, 0.5999999046325684, 0.41666677594184875, 0.5999999046325684, 0.41666677594184875, 0.6499999165534973, 0.41666677594184875, 0.5999999046325684, 0.33333343267440796, 0.5999999046325684, 0.33333343267440796, 0.5499998927116394, 0.33333343267440796, 0.5499998927116394, 0.41666677594184875, 0.5499998927116394, 0.41666677594184875, 0.5999999046325684, 0.41666677594184875, 0.5499998927116394, 0.33333343267440796, 0.5499998927116394, 0.33333343267440796, 0.49999988079071045, 0.33333343267440796, 0.49999988079071045, 0.41666677594184875, 0.49999988079071045, 0.41666677594184875, 0.5499998927116394, 0.41666677594184875, 0.49999988079071045, 0.33333343267440796, 0.49999988079071045, 0.33333343267440796, 0.4499998688697815, 0.33333343267440796, 0.4499998688697815, 0.41666677594184875, 0.4499998688697815, 0.41666677594184875, 0.49999988079071045, 0.41666677594184875, 0.4499998688697815, 0.33333343267440796, 0.4499998688697815, 0.33333343267440796, 0.39999985694885254, 0.33333343267440796, 0.39999985694885254, 0.41666677594184875, 0.39999985694885254, 0.41666677594184875, 0.4499998688697815, 0.33333343267440796, 1, 0.25000008940696716, 1, 0.25000008940696716, 0.949999988079071, 0.25000008940696716, 0.949999988079071, 0.33333343267440796, 0.949999988079071, 0.33333343267440796, 1, 0.33333343267440796, 0.949999988079071, 0.25000008940696716, 0.949999988079071, 0.25000008940696716, 0.8999999761581421, 0.25000008940696716, 0.8999999761581421, 0.33333343267440796, 0.8999999761581421, 0.33333343267440796, 0.949999988079071, 0.33333343267440796, 0.8999999761581421, 0.25000008940696716, 0.8999999761581421, 0.25000008940696716, 0.8499999642372131, 0.25000008940696716, 0.8499999642372131, 0.33333343267440796, 0.8499999642372131, 0.33333343267440796, 0.8999999761581421, 0.33333343267440796, 0.8499999642372131, 0.25000008940696716, 0.8499999642372131, 0.25000008940696716, 0.7999999523162842, 0.25000008940696716, 0.7999999523162842, 0.33333343267440796, 0.7999999523162842, 0.33333343267440796, 0.8499999642372131, 0.33333343267440796, 0.7999999523162842, 0.25000008940696716, 0.7999999523162842, 0.25000008940696716, 0.7499999403953552, 0.25000008940696716, 0.7499999403953552, 0.33333343267440796, 0.7499999403953552, 0.33333343267440796, 0.7999999523162842, 0.33333343267440796, 0.7499999403953552, 0.25000008940696716, 0.7499999403953552, 0.25000008940696716, 0.6999999284744263, 0.25000008940696716, 0.6999999284744263, 0.33333343267440796, 0.6999999284744263, 0.33333343267440796, 0.7499999403953552, 0.33333343267440796, 0.6999999284744263, 0.25000008940696716, 0.6999999284744263, 0.25000008940696716, 0.6499999165534973, 0.25000008940696716, 0.6499999165534973, 0.33333343267440796, 0.6499999165534973, 0.33333343267440796, 0.6999999284744263, 0.33333343267440796, 0.6499999165534973, 0.25000008940696716, 0.6499999165534973, 0.25000008940696716, 0.5999999046325684, 0.25000008940696716, 0.5999999046325684, 0.33333343267440796, 0.5999999046325684, 0.33333343267440796, 0.6499999165534973, 0.33333343267440796, 0.5999999046325684, 0.25000008940696716, 0.5999999046325684, 0.25000008940696716, 0.5499998927116394, 0.25000008940696716, 0.5499998927116394, 0.33333343267440796, 0.5499998927116394, 0.33333343267440796, 0.5999999046325684, 0.33333343267440796, 0.5499998927116394, 0.25000008940696716, 0.5499998927116394, 0.25000008940696716, 0.49999988079071045, 0.25000008940696716, 0.49999988079071045, 0.33333343267440796, 0.49999988079071045, 0.33333343267440796, 0.5499998927116394, 0.33333343267440796, 0.49999988079071045, 0.25000008940696716, 0.49999988079071045, 0.25000008940696716, 0.4499998688697815, 0.25000008940696716, 0.4499998688697815, 0.33333343267440796, 0.4499998688697815, 0.33333343267440796, 0.49999988079071045, 0.33333343267440796, 0.4499998688697815, 0.25000008940696716, 0.4499998688697815, 0.25000008940696716, 0.39999985694885254, 0.25000008940696716, 0.39999985694885254, 0.33333343267440796, 0.39999985694885254, 0.33333343267440796, 0.4499998688697815, 0.25000008940696716, 1, 0.16666674613952637, 1, 0.16666674613952637, 0.949999988079071, 0.16666674613952637, 0.949999988079071, 0.25000008940696716, 0.949999988079071, 0.25000008940696716, 1, 0.25000008940696716, 0.949999988079071, 0.16666674613952637, 0.949999988079071, 0.16666674613952637, 0.8999999761581421, 0.16666674613952637, 0.8999999761581421, 0.25000008940696716, 0.8999999761581421, 0.25000008940696716, 0.949999988079071, 0.25000008940696716, 0.8999999761581421, 0.16666674613952637, 0.8999999761581421, 0.16666674613952637, 0.8499999642372131, 0.16666674613952637, 0.8499999642372131, 0.25000008940696716, 0.8499999642372131, 0.25000008940696716, 0.8999999761581421, 0.25000008940696716, 0.8499999642372131, 0.16666674613952637, 0.8499999642372131, 0.16666674613952637, 0.7999999523162842, 0.16666674613952637, 0.7999999523162842, 0.25000008940696716, 0.7999999523162842, 0.25000008940696716, 0.8499999642372131, 0.25000008940696716, 0.7999999523162842, 0.16666674613952637, 0.7999999523162842, 0.16666674613952637, 0.7499999403953552, 0.16666674613952637, 0.7499999403953552, 0.25000008940696716, 0.7499999403953552, 0.25000008940696716, 0.7999999523162842, 0.25000008940696716, 0.7499999403953552, 0.16666674613952637, 0.7499999403953552, 0.16666674613952637, 0.6999999284744263, 0.16666674613952637, 0.6999999284744263, 0.25000008940696716, 0.6999999284744263, 0.25000008940696716, 0.7499999403953552, 0.25000008940696716, 0.6999999284744263, 0.16666674613952637, 0.6999999284744263, 0.16666674613952637, 0.6499999165534973, 0.16666674613952637, 0.6499999165534973, 0.25000008940696716, 0.6499999165534973, 0.25000008940696716, 0.6999999284744263, 0.25000008940696716, 0.6499999165534973, 0.16666674613952637, 0.6499999165534973, 0.16666674613952637, 0.5999999046325684, 0.16666674613952637, 0.5999999046325684, 0.25000008940696716, 0.5999999046325684, 0.25000008940696716, 0.6499999165534973, 0.25000008940696716, 0.5999999046325684, 0.16666674613952637, 0.5999999046325684, 0.16666674613952637, 0.5499998927116394, 0.16666674613952637, 0.5499998927116394, 0.25000008940696716, 0.5499998927116394, 0.25000008940696716, 0.5999999046325684, 0.25000008940696716, 0.5499998927116394, 0.16666674613952637, 0.5499998927116394, 0.16666674613952637, 0.49999988079071045, 0.16666674613952637, 0.49999988079071045, 0.25000008940696716, 0.49999988079071045, 0.25000008940696716, 0.5499998927116394, 0.25000008940696716, 0.49999988079071045, 0.16666674613952637, 0.49999988079071045, 0.16666674613952637, 0.4499998688697815, 0.16666674613952637, 0.4499998688697815, 0.25000008940696716, 0.4499998688697815, 0.25000008940696716, 0.49999988079071045, 0.25000008940696716, 0.4499998688697815, 0.16666674613952637, 0.4499998688697815, 0.16666674613952637, 0.39999985694885254, 0.16666674613952637, 0.39999985694885254, 0.25000008940696716, 0.39999985694885254, 0.25000008940696716, 0.4499998688697815, 0.16666674613952637, 1, 0.08333341032266617, 1, 0.08333341032266617, 0.949999988079071, 0.08333341032266617, 0.949999988079071, 0.16666674613952637, 0.949999988079071, 0.16666674613952637, 1, 0.16666674613952637, 0.949999988079071, 0.08333341032266617, 0.949999988079071, 0.08333341032266617, 0.8999999761581421, 0.08333341032266617, 0.8999999761581421, 0.16666674613952637, 0.8999999761581421, 0.16666674613952637, 0.949999988079071, 0.16666674613952637, 0.8999999761581421, 0.08333341032266617, 0.8999999761581421, 0.08333341032266617, 0.8499999642372131, 0.08333341032266617, 0.8499999642372131, 0.16666674613952637, 0.8499999642372131, 0.16666674613952637, 0.8999999761581421, 0.16666674613952637, 0.8499999642372131, 0.08333341032266617, 0.8499999642372131, 0.08333341032266617, 0.7999999523162842, 0.08333341032266617, 0.7999999523162842, 0.16666674613952637, 0.7999999523162842, 0.16666674613952637, 0.8499999642372131, 0.16666674613952637, 0.7999999523162842, 0.08333341032266617, 0.7999999523162842, 0.08333341032266617, 0.7499999403953552, 0.08333341032266617, 0.7499999403953552, 0.16666674613952637, 0.7499999403953552, 0.16666674613952637, 0.7999999523162842, 0.16666674613952637, 0.7499999403953552, 0.08333341032266617, 0.7499999403953552, 0.08333341032266617, 0.6999999284744263, 0.08333341032266617, 0.6999999284744263, 0.16666674613952637, 0.6999999284744263, 0.16666674613952637, 0.7499999403953552, 0.16666674613952637, 0.6999999284744263, 0.08333341032266617, 0.6999999284744263, 0.08333341032266617, 0.6499999165534973, 0.08333341032266617, 0.6499999165534973, 0.16666674613952637, 0.6499999165534973, 0.16666674613952637, 0.6999999284744263, 0.16666674613952637, 0.6499999165534973, 0.08333341032266617, 0.6499999165534973, 0.08333341032266617, 0.5999999046325684, 0.08333341032266617, 0.5999999046325684, 0.16666674613952637, 0.5999999046325684, 0.16666674613952637, 0.6499999165534973, 0.16666674613952637, 0.5999999046325684, 0.08333341032266617, 0.5999999046325684, 0.08333341032266617, 0.5499998927116394, 0.08333341032266617, 0.5499998927116394, 0.16666674613952637, 0.5499998927116394, 0.16666674613952637, 0.5999999046325684, 0.16666674613952637, 0.5499998927116394, 0.08333341032266617, 0.5499998927116394, 0.08333341032266617, 0.49999988079071045, 0.08333341032266617, 0.49999988079071045, 0.16666674613952637, 0.49999988079071045, 0.16666674613952637, 0.5499998927116394, 0.16666674613952637, 0.49999988079071045, 0.08333341032266617, 0.49999988079071045, 0.08333341032266617, 0.4499998688697815, 0.08333341032266617, 0.4499998688697815, 0.16666674613952637, 0.4499998688697815, 0.16666674613952637, 0.49999988079071045, 0.16666674613952637, 0.4499998688697815, 0.08333341032266617, 0.4499998688697815, 0.08333341032266617, 0.39999985694885254, 0.08333341032266617, 0.39999985694885254, 0.16666674613952637, 0.39999985694885254, 0.16666674613952637, 0.4499998688697815, 0.08333341032266617, 1, 7.450580596923828e-8, 1, 7.450580596923828e-8, 0.949999988079071, 7.450580596923828e-8, 0.949999988079071, 0.08333341032266617, 0.949999988079071, 0.08333341032266617, 1, 0.08333341032266617, 0.949999988079071, 7.450580596923828e-8, 0.949999988079071, 7.450580596923828e-8, 0.8999999761581421, 7.450580596923828e-8, 0.8999999761581421, 0.08333341032266617, 0.8999999761581421, 0.08333341032266617, 0.949999988079071, 0.08333341032266617, 0.8999999761581421, 7.450580596923828e-8, 0.8999999761581421, 7.450580596923828e-8, 0.8499999642372131, 7.450580596923828e-8, 0.8499999642372131, 0.08333341032266617, 0.8499999642372131, 0.08333341032266617, 0.8999999761581421, 0.08333341032266617, 0.8499999642372131, 7.450580596923828e-8, 0.8499999642372131, 7.450580596923828e-8, 0.7999999523162842, 7.450580596923828e-8, 0.7999999523162842, 0.08333341032266617, 0.7999999523162842, 0.08333341032266617, 0.8499999642372131, 0.08333341032266617, 0.7999999523162842, 7.450580596923828e-8, 0.7999999523162842, 7.450580596923828e-8, 0.7499999403953552, 7.450580596923828e-8, 0.7499999403953552, 0.08333341032266617, 0.7499999403953552, 0.08333341032266617, 0.7999999523162842, 0.08333341032266617, 0.7499999403953552, 7.450580596923828e-8, 0.7499999403953552, 7.450580596923828e-8, 0.6999999284744263, 7.450580596923828e-8, 0.6999999284744263, 0.08333341032266617, 0.6999999284744263, 0.08333341032266617, 0.7499999403953552, 0.08333341032266617, 0.6999999284744263, 7.450580596923828e-8, 0.6999999284744263, 7.450580596923828e-8, 0.6499999165534973, 7.450580596923828e-8, 0.6499999165534973, 0.08333341032266617, 0.6499999165534973, 0.08333341032266617, 0.6999999284744263, 0.08333341032266617, 0.6499999165534973, 7.450580596923828e-8, 0.6499999165534973, 7.450580596923828e-8, 0.5999999046325684, 7.450580596923828e-8, 0.5999999046325684, 0.08333341032266617, 0.5999999046325684, 0.08333341032266617, 0.6499999165534973, 0.08333341032266617, 0.5999999046325684, 7.450580596923828e-8, 0.5999999046325684, 7.450580596923828e-8, 0.5499998927116394, 7.450580596923828e-8, 0.5499998927116394, 0.08333341032266617, 0.5499998927116394, 0.08333341032266617, 0.5999999046325684, 0.08333341032266617, 0.5499998927116394, 7.450580596923828e-8, 0.5499998927116394, 7.450580596923828e-8, 0.49999988079071045, 7.450580596923828e-8, 0.49999988079071045, 0.08333341032266617, 0.49999988079071045, 0.08333341032266617, 0.5499998927116394, 0.08333341032266617, 0.49999988079071045, 7.450580596923828e-8, 0.49999988079071045, 7.450580596923828e-8, 0.4499998688697815, 7.450580596923828e-8, 0.4499998688697815, 0.08333341032266617, 0.4499998688697815, 0.08333341032266617, 0.49999988079071045, 0.08333341032266617, 0.4499998688697815, 7.450580596923828e-8, 0.4499998688697815, 7.450580596923828e-8, 0.39999985694885254, 7.450580596923828e-8, 0.39999985694885254, 0.08333341032266617, 0.39999985694885254, 0.08333341032266617, 0.4499998688697815, 2, 0.4000000059604645, 1.9166666269302368, 0.4000000059604645, 1.9166666269302368, 0.36666667461395263, 1.9166666269302368, 0.36666667461395263, 2, 0.36666667461395263, 2, 0.4000000059604645, 2, 0.36666667461395263, 1.9166666269302368, 0.36666667461395263, 1.9166666269302368, 0.3333333432674408, 1.9166666269302368, 0.3333333432674408, 2, 0.3333333432674408, 2, 0.36666667461395263, 2, 0.3333333432674408, 1.9166666269302368, 0.3333333432674408, 1.9166666269302368, 0.30000001192092895, 1.9166666269302368, 0.30000001192092895, 2, 0.30000001192092895, 2, 0.3333333432674408, 2, 0.30000001192092895, 1.9166666269302368, 0.30000001192092895, 1.9166666269302368, 0.2666666805744171, 1.9166666269302368, 0.2666666805744171, 2, 0.2666666805744171, 2, 0.30000001192092895, 2, 0.2666666805744171, 1.9166666269302368, 0.2666666805744171, 1.9166666269302368, 0.23333334922790527, 1.9166666269302368, 0.23333334922790527, 2, 0.23333334922790527, 2, 0.2666666805744171, 2, 0.23333334922790527, 1.9166666269302368, 0.23333334922790527, 1.9166666269302368, 0.20000001788139343, 1.9166666269302368, 0.20000001788139343, 2, 0.20000001788139343, 2, 0.23333334922790527, 2, 0.20000001788139343, 1.9166666269302368, 0.20000001788139343, 1.9166666269302368, 0.1666666865348816, 1.9166666269302368, 0.1666666865348816, 2, 0.1666666865348816, 2, 0.20000001788139343, 2, 0.1666666865348816, 1.9166666269302368, 0.1666666865348816, 1.9166666269302368, 0.13333335518836975, 1.9166666269302368, 0.13333335518836975, 2, 0.13333335518836975, 2, 0.1666666865348816, 2, 0.13333335518836975, 1.9166666269302368, 0.13333335518836975, 1.9166666269302368, 0.10000002384185791, 1.9166666269302368, 0.10000002384185791, 2, 0.10000002384185791, 2, 0.13333335518836975, 2, 0.10000002384185791, 1.9166666269302368, 0.10000002384185791, 1.9166666269302368, 0.06666669249534607, 1.9166666269302368, 0.06666669249534607, 2, 0.06666669249534607, 2, 0.10000002384185791, 2, 0.06666669249534607, 1.9166666269302368, 0.06666669249534607, 1.9166666269302368, 0.03333335742354393, 1.9166666269302368, 0.03333335742354393, 2, 0.03333335742354393, 2, 0.06666669249534607, 2, 0.03333335742354393, 1.9166666269302368, 0.03333335742354393, 1.9166666269302368, 2.2351741790771484e-8, 1.9166666269302368, 2.2351741790771484e-8, 2, 2.2351741790771484e-8, 2, 0.03333335742354393, 1.9166666269302368, 0.4000000059604645, 1.8333332538604736, 0.4000000059604645, 1.8333332538604736, 0.36666667461395263, 1.8333332538604736, 0.36666667461395263, 1.9166666269302368, 0.36666667461395263, 1.9166666269302368, 0.4000000059604645, 1.9166666269302368, 0.36666667461395263, 1.8333332538604736, 0.36666667461395263, 1.8333332538604736, 0.3333333432674408, 1.8333332538604736, 0.3333333432674408, 1.9166666269302368, 0.3333333432674408, 1.9166666269302368, 0.36666667461395263, 1.9166666269302368, 0.3333333432674408, 1.8333332538604736, 0.3333333432674408, 1.8333332538604736, 0.30000001192092895, 1.8333332538604736, 0.30000001192092895, 1.9166666269302368, 0.30000001192092895, 1.9166666269302368, 0.3333333432674408, 1.9166666269302368, 0.30000001192092895, 1.8333332538604736, 0.30000001192092895, 1.8333332538604736, 0.2666666805744171, 1.8333332538604736, 0.2666666805744171, 1.9166666269302368, 0.2666666805744171, 1.9166666269302368, 0.30000001192092895, 1.9166666269302368, 0.2666666805744171, 1.8333332538604736, 0.2666666805744171, 1.8333332538604736, 0.23333334922790527, 1.8333332538604736, 0.23333334922790527, 1.9166666269302368, 0.23333334922790527, 1.9166666269302368, 0.2666666805744171, 1.9166666269302368, 0.23333334922790527, 1.8333332538604736, 0.23333334922790527, 1.8333332538604736, 0.20000001788139343, 1.8333332538604736, 0.20000001788139343, 1.9166666269302368, 0.20000001788139343, 1.9166666269302368, 0.23333334922790527, 1.9166666269302368, 0.20000001788139343, 1.8333332538604736, 0.20000001788139343, 1.8333332538604736, 0.1666666865348816, 1.8333332538604736, 0.1666666865348816, 1.9166666269302368, 0.1666666865348816, 1.9166666269302368, 0.20000001788139343, 1.9166666269302368, 0.1666666865348816, 1.8333332538604736, 0.1666666865348816, 1.8333332538604736, 0.13333335518836975, 1.8333332538604736, 0.13333335518836975, 1.9166666269302368, 0.13333335518836975, 1.9166666269302368, 0.1666666865348816, 1.9166666269302368, 0.13333335518836975, 1.8333332538604736, 0.13333335518836975, 1.8333332538604736, 0.10000002384185791, 1.8333332538604736, 0.10000002384185791, 1.9166666269302368, 0.10000002384185791, 1.9166666269302368, 0.13333335518836975, 1.9166666269302368, 0.10000002384185791, 1.8333332538604736, 0.10000002384185791, 1.8333332538604736, 0.06666669249534607, 1.8333332538604736, 0.06666669249534607, 1.9166666269302368, 0.06666669249534607, 1.9166666269302368, 0.10000002384185791, 1.9166666269302368, 0.06666669249534607, 1.8333332538604736, 0.06666669249534607, 1.8333332538604736, 0.03333335742354393, 1.8333332538604736, 0.03333335742354393, 1.9166666269302368, 0.03333335742354393, 1.9166666269302368, 0.06666669249534607, 1.9166666269302368, 0.03333335742354393, 1.8333332538604736, 0.03333335742354393, 1.8333332538604736, 2.2351741790771484e-8, 1.8333332538604736, 2.2351741790771484e-8, 1.9166666269302368, 2.2351741790771484e-8, 1.9166666269302368, 0.03333335742354393, 1.8333332538604736, 0.4000000059604645, 1.7499998807907104, 0.4000000059604645, 1.7499998807907104, 0.36666667461395263, 1.7499998807907104, 0.36666667461395263, 1.8333332538604736, 0.36666667461395263, 1.8333332538604736, 0.4000000059604645, 1.8333332538604736, 0.36666667461395263, 1.7499998807907104, 0.36666667461395263, 1.7499998807907104, 0.3333333432674408, 1.7499998807907104, 0.3333333432674408, 1.8333332538604736, 0.3333333432674408, 1.8333332538604736, 0.36666667461395263, 1.8333332538604736, 0.3333333432674408, 1.7499998807907104, 0.3333333432674408, 1.7499998807907104, 0.30000001192092895, 1.7499998807907104, 0.30000001192092895, 1.8333332538604736, 0.30000001192092895, 1.8333332538604736, 0.3333333432674408, 1.8333332538604736, 0.30000001192092895, 1.7499998807907104, 0.30000001192092895, 1.7499998807907104, 0.2666666805744171, 1.7499998807907104, 0.2666666805744171, 1.8333332538604736, 0.2666666805744171, 1.8333332538604736, 0.30000001192092895, 1.8333332538604736, 0.2666666805744171, 1.7499998807907104, 0.2666666805744171, 1.7499998807907104, 0.23333334922790527, 1.7499998807907104, 0.23333334922790527, 1.8333332538604736, 0.23333334922790527, 1.8333332538604736, 0.2666666805744171, 1.8333332538604736, 0.23333334922790527, 1.7499998807907104, 0.23333334922790527, 1.7499998807907104, 0.20000001788139343, 1.7499998807907104, 0.20000001788139343, 1.8333332538604736, 0.20000001788139343, 1.8333332538604736, 0.23333334922790527, 1.8333332538604736, 0.20000001788139343, 1.7499998807907104, 0.20000001788139343, 1.7499998807907104, 0.1666666865348816, 1.7499998807907104, 0.1666666865348816, 1.8333332538604736, 0.1666666865348816, 1.8333332538604736, 0.20000001788139343, 1.8333332538604736, 0.1666666865348816, 1.7499998807907104, 0.1666666865348816, 1.7499998807907104, 0.13333335518836975, 1.7499998807907104, 0.13333335518836975, 1.8333332538604736, 0.13333335518836975, 1.8333332538604736, 0.1666666865348816, 1.8333332538604736, 0.13333335518836975, 1.7499998807907104, 0.13333335518836975, 1.7499998807907104, 0.10000002384185791, 1.7499998807907104, 0.10000002384185791, 1.8333332538604736, 0.10000002384185791, 1.8333332538604736, 0.13333335518836975, 1.8333332538604736, 0.10000002384185791, 1.7499998807907104, 0.10000002384185791, 1.7499998807907104, 0.06666669249534607, 1.7499998807907104, 0.06666669249534607, 1.8333332538604736, 0.06666669249534607, 1.8333332538604736, 0.10000002384185791, 1.8333332538604736, 0.06666669249534607, 1.7499998807907104, 0.06666669249534607, 1.7499998807907104, 0.03333335742354393, 1.7499998807907104, 0.03333335742354393, 1.8333332538604736, 0.03333335742354393, 1.8333332538604736, 0.06666669249534607, 1.8333332538604736, 0.03333335742354393, 1.7499998807907104, 0.03333335742354393, 1.7499998807907104, 2.2351741790771484e-8, 1.7499998807907104, 2.2351741790771484e-8, 1.8333332538604736, 2.2351741790771484e-8, 1.8333332538604736, 0.03333335742354393, 1.7499998807907104, 0.4000000059604645, 1.6666665077209472, 0.4000000059604645, 1.6666665077209472, 0.36666667461395263, 1.6666665077209472, 0.36666667461395263, 1.7499998807907104, 0.36666667461395263, 1.7499998807907104, 0.4000000059604645, 1.7499998807907104, 0.36666667461395263, 1.6666665077209472, 0.36666667461395263, 1.6666665077209472, 0.3333333432674408, 1.6666665077209472, 0.3333333432674408, 1.7499998807907104, 0.3333333432674408, 1.7499998807907104, 0.36666667461395263, 1.7499998807907104, 0.3333333432674408, 1.6666665077209472, 0.3333333432674408, 1.6666665077209472, 0.30000001192092895, 1.6666665077209472, 0.30000001192092895, 1.7499998807907104, 0.30000001192092895, 1.7499998807907104, 0.3333333432674408, 1.7499998807907104, 0.30000001192092895, 1.6666665077209472, 0.30000001192092895, 1.6666665077209472, 0.2666666805744171, 1.6666665077209472, 0.2666666805744171, 1.7499998807907104, 0.2666666805744171, 1.7499998807907104, 0.30000001192092895, 1.7499998807907104, 0.2666666805744171, 1.6666665077209472, 0.2666666805744171, 1.6666665077209472, 0.23333334922790527, 1.6666665077209472, 0.23333334922790527, 1.7499998807907104, 0.23333334922790527, 1.7499998807907104, 0.2666666805744171, 1.7499998807907104, 0.23333334922790527, 1.6666665077209472, 0.23333334922790527, 1.6666665077209472, 0.20000001788139343, 1.6666665077209472, 0.20000001788139343, 1.7499998807907104, 0.20000001788139343, 1.7499998807907104, 0.23333334922790527, 1.7499998807907104, 0.20000001788139343, 1.6666665077209472, 0.20000001788139343, 1.6666665077209472, 0.1666666865348816, 1.6666665077209472, 0.1666666865348816, 1.7499998807907104, 0.1666666865348816, 1.7499998807907104, 0.20000001788139343, 1.7499998807907104, 0.1666666865348816, 1.6666665077209472, 0.1666666865348816, 1.6666665077209472, 0.13333335518836975, 1.6666665077209472, 0.13333335518836975, 1.7499998807907104, 0.13333335518836975, 1.7499998807907104, 0.1666666865348816, 1.7499998807907104, 0.13333335518836975, 1.6666665077209472, 0.13333335518836975, 1.6666665077209472, 0.10000002384185791, 1.6666665077209472, 0.10000002384185791, 1.7499998807907104, 0.10000002384185791, 1.7499998807907104, 0.13333335518836975, 1.7499998807907104, 0.10000002384185791, 1.6666665077209472, 0.10000002384185791, 1.6666665077209472, 0.06666669249534607, 1.6666665077209472, 0.06666669249534607, 1.7499998807907104, 0.06666669249534607, 1.7499998807907104, 0.10000002384185791, 1.7499998807907104, 0.06666669249534607, 1.6666665077209472, 0.06666669249534607, 1.6666665077209472, 0.03333335742354393, 1.6666665077209472, 0.03333335742354393, 1.7499998807907104, 0.03333335742354393, 1.7499998807907104, 0.06666669249534607, 1.7499998807907104, 0.03333335742354393, 1.6666665077209472, 0.03333335742354393, 1.6666665077209472, 2.2351741790771484e-8, 1.6666665077209472, 2.2351741790771484e-8, 1.7499998807907104, 2.2351741790771484e-8, 1.7499998807907104, 0.03333335742354393, 1.6666665077209472, 0.4000000059604645, 1.583333134651184, 0.4000000059604645, 1.583333134651184, 0.36666667461395263, 1.583333134651184, 0.36666667461395263, 1.6666665077209472, 0.36666667461395263, 1.6666665077209472, 0.4000000059604645, 1.6666665077209472, 0.36666667461395263, 1.583333134651184, 0.36666667461395263, 1.583333134651184, 0.3333333432674408, 1.583333134651184, 0.3333333432674408, 1.6666665077209472, 0.3333333432674408, 1.6666665077209472, 0.36666667461395263, 1.6666665077209472, 0.3333333432674408, 1.583333134651184, 0.3333333432674408, 1.583333134651184, 0.30000001192092895, 1.583333134651184, 0.30000001192092895, 1.6666665077209472, 0.30000001192092895, 1.6666665077209472, 0.3333333432674408, 1.6666665077209472, 0.30000001192092895, 1.583333134651184, 0.30000001192092895, 1.583333134651184, 0.2666666805744171, 1.583333134651184, 0.2666666805744171, 1.6666665077209472, 0.2666666805744171, 1.6666665077209472, 0.30000001192092895, 1.6666665077209472, 0.2666666805744171, 1.583333134651184, 0.2666666805744171, 1.583333134651184, 0.23333334922790527, 1.583333134651184, 0.23333334922790527, 1.6666665077209472, 0.23333334922790527, 1.6666665077209472, 0.2666666805744171, 1.6666665077209472, 0.23333334922790527, 1.583333134651184, 0.23333334922790527, 1.583333134651184, 0.20000001788139343, 1.583333134651184, 0.20000001788139343, 1.6666665077209472, 0.20000001788139343, 1.6666665077209472, 0.23333334922790527, 1.6666665077209472, 0.20000001788139343, 1.583333134651184, 0.20000001788139343, 1.583333134651184, 0.1666666865348816, 1.583333134651184, 0.1666666865348816, 1.6666665077209472, 0.1666666865348816, 1.6666665077209472, 0.20000001788139343, 1.6666665077209472, 0.1666666865348816, 1.583333134651184, 0.1666666865348816, 1.583333134651184, 0.13333335518836975, 1.583333134651184, 0.13333335518836975, 1.6666665077209472, 0.13333335518836975, 1.6666665077209472, 0.1666666865348816, 1.6666665077209472, 0.13333335518836975, 1.583333134651184, 0.13333335518836975, 1.583333134651184, 0.10000002384185791, 1.583333134651184, 0.10000002384185791, 1.6666665077209472, 0.10000002384185791, 1.6666665077209472, 0.13333335518836975, 1.6666665077209472, 0.10000002384185791, 1.583333134651184, 0.10000002384185791, 1.583333134651184, 0.06666669249534607, 1.583333134651184, 0.06666669249534607, 1.6666665077209472, 0.06666669249534607, 1.6666665077209472, 0.10000002384185791, 1.6666665077209472, 0.06666669249534607, 1.583333134651184, 0.06666669249534607, 1.583333134651184, 0.03333335742354393, 1.583333134651184, 0.03333335742354393, 1.6666665077209472, 0.03333335742354393, 1.6666665077209472, 0.06666669249534607, 1.6666665077209472, 0.03333335742354393, 1.583333134651184, 0.03333335742354393, 1.583333134651184, 2.2351741790771484e-8, 1.583333134651184, 2.2351741790771484e-8, 1.6666665077209472, 2.2351741790771484e-8, 1.6666665077209472, 0.03333335742354393, 1.583333134651184, 0.4000000059604645, 1.499999761581421, 0.4000000059604645, 1.499999761581421, 0.36666667461395263, 1.499999761581421, 0.36666667461395263, 1.583333134651184, 0.36666667461395263, 1.583333134651184, 0.4000000059604645, 1.583333134651184, 0.36666667461395263, 1.499999761581421, 0.36666667461395263, 1.499999761581421, 0.3333333432674408, 1.499999761581421, 0.3333333432674408, 1.583333134651184, 0.3333333432674408, 1.583333134651184, 0.36666667461395263, 1.583333134651184, 0.3333333432674408, 1.499999761581421, 0.3333333432674408, 1.499999761581421, 0.30000001192092895, 1.499999761581421, 0.30000001192092895, 1.583333134651184, 0.30000001192092895, 1.583333134651184, 0.3333333432674408, 1.583333134651184, 0.30000001192092895, 1.499999761581421, 0.30000001192092895, 1.499999761581421, 0.2666666805744171, 1.499999761581421, 0.2666666805744171, 1.583333134651184, 0.2666666805744171, 1.583333134651184, 0.30000001192092895, 1.583333134651184, 0.2666666805744171, 1.499999761581421, 0.2666666805744171, 1.499999761581421, 0.23333334922790527, 1.499999761581421, 0.23333334922790527, 1.583333134651184, 0.23333334922790527, 1.583333134651184, 0.2666666805744171, 1.583333134651184, 0.23333334922790527, 1.499999761581421, 0.23333334922790527, 1.499999761581421, 0.20000001788139343, 1.499999761581421, 0.20000001788139343, 1.583333134651184, 0.20000001788139343, 1.583333134651184, 0.23333334922790527, 1.583333134651184, 0.20000001788139343, 1.499999761581421, 0.20000001788139343, 1.499999761581421, 0.1666666865348816, 1.499999761581421, 0.1666666865348816, 1.583333134651184, 0.1666666865348816, 1.583333134651184, 0.20000001788139343, 1.583333134651184, 0.1666666865348816, 1.499999761581421, 0.1666666865348816, 1.499999761581421, 0.13333335518836975, 1.499999761581421, 0.13333335518836975, 1.583333134651184, 0.13333335518836975, 1.583333134651184, 0.1666666865348816, 1.583333134651184, 0.13333335518836975, 1.499999761581421, 0.13333335518836975, 1.499999761581421, 0.10000002384185791, 1.499999761581421, 0.10000002384185791, 1.583333134651184, 0.10000002384185791, 1.583333134651184, 0.13333335518836975, 1.583333134651184, 0.10000002384185791, 1.499999761581421, 0.10000002384185791, 1.499999761581421, 0.06666669249534607, 1.499999761581421, 0.06666669249534607, 1.583333134651184, 0.06666669249534607, 1.583333134651184, 0.10000002384185791, 1.583333134651184, 0.06666669249534607, 1.499999761581421, 0.06666669249534607, 1.499999761581421, 0.03333335742354393, 1.499999761581421, 0.03333335742354393, 1.583333134651184, 0.03333335742354393, 1.583333134651184, 0.06666669249534607, 1.583333134651184, 0.03333335742354393, 1.499999761581421, 0.03333335742354393, 1.499999761581421, 2.2351741790771484e-8, 1.499999761581421, 2.2351741790771484e-8, 1.583333134651184, 2.2351741790771484e-8, 1.583333134651184, 0.03333335742354393, 1.499999761581421, 0.4000000059604645, 1.4166663885116577, 0.4000000059604645, 1.4166663885116577, 0.36666667461395263, 1.4166663885116577, 0.36666667461395263, 1.499999761581421, 0.36666667461395263, 1.499999761581421, 0.4000000059604645, 1.499999761581421, 0.36666667461395263, 1.4166663885116577, 0.36666667461395263, 1.4166663885116577, 0.3333333432674408, 1.4166663885116577, 0.3333333432674408, 1.499999761581421, 0.3333333432674408, 1.499999761581421, 0.36666667461395263, 1.499999761581421, 0.3333333432674408, 1.4166663885116577, 0.3333333432674408, 1.4166663885116577, 0.30000001192092895, 1.4166663885116577, 0.30000001192092895, 1.499999761581421, 0.30000001192092895, 1.499999761581421, 0.3333333432674408, 1.499999761581421, 0.30000001192092895, 1.4166663885116577, 0.30000001192092895, 1.4166663885116577, 0.2666666805744171, 1.4166663885116577, 0.2666666805744171, 1.499999761581421, 0.2666666805744171, 1.499999761581421, 0.30000001192092895, 1.499999761581421, 0.2666666805744171, 1.4166663885116577, 0.2666666805744171, 1.4166663885116577, 0.23333334922790527, 1.4166663885116577, 0.23333334922790527, 1.499999761581421, 0.23333334922790527, 1.499999761581421, 0.2666666805744171, 1.499999761581421, 0.23333334922790527, 1.4166663885116577, 0.23333334922790527, 1.4166663885116577, 0.20000001788139343, 1.4166663885116577, 0.20000001788139343, 1.499999761581421, 0.20000001788139343, 1.499999761581421, 0.23333334922790527, 1.499999761581421, 0.20000001788139343, 1.4166663885116577, 0.20000001788139343, 1.4166663885116577, 0.1666666865348816, 1.4166663885116577, 0.1666666865348816, 1.499999761581421, 0.1666666865348816, 1.499999761581421, 0.20000001788139343, 1.499999761581421, 0.1666666865348816, 1.4166663885116577, 0.1666666865348816, 1.4166663885116577, 0.13333335518836975, 1.4166663885116577, 0.13333335518836975, 1.499999761581421, 0.13333335518836975, 1.499999761581421, 0.1666666865348816, 1.499999761581421, 0.13333335518836975, 1.4166663885116577, 0.13333335518836975, 1.4166663885116577, 0.10000002384185791, 1.4166663885116577, 0.10000002384185791, 1.499999761581421, 0.10000002384185791, 1.499999761581421, 0.13333335518836975, 1.499999761581421, 0.10000002384185791, 1.4166663885116577, 0.10000002384185791, 1.4166663885116577, 0.06666669249534607, 1.4166663885116577, 0.06666669249534607, 1.499999761581421, 0.06666669249534607, 1.499999761581421, 0.10000002384185791, 1.499999761581421, 0.06666669249534607, 1.4166663885116577, 0.06666669249534607, 1.4166663885116577, 0.03333335742354393, 1.4166663885116577, 0.03333335742354393, 1.499999761581421, 0.03333335742354393, 1.499999761581421, 0.06666669249534607, 1.499999761581421, 0.03333335742354393, 1.4166663885116577, 0.03333335742354393, 1.4166663885116577, 2.2351741790771484e-8, 1.4166663885116577, 2.2351741790771484e-8, 1.499999761581421, 2.2351741790771484e-8, 1.499999761581421, 0.03333335742354393, 1.4166663885116577, 0.4000000059604645, 1.3333330154418945, 0.4000000059604645, 1.3333330154418945, 0.36666667461395263, 1.3333330154418945, 0.36666667461395263, 1.4166663885116577, 0.36666667461395263, 1.4166663885116577, 0.4000000059604645, 1.4166663885116577, 0.36666667461395263, 1.3333330154418945, 0.36666667461395263, 1.3333330154418945, 0.3333333432674408, 1.3333330154418945, 0.3333333432674408, 1.4166663885116577, 0.3333333432674408, 1.4166663885116577, 0.36666667461395263, 1.4166663885116577, 0.3333333432674408, 1.3333330154418945, 0.3333333432674408, 1.3333330154418945, 0.30000001192092895, 1.3333330154418945, 0.30000001192092895, 1.4166663885116577, 0.30000001192092895, 1.4166663885116577, 0.3333333432674408, 1.4166663885116577, 0.30000001192092895, 1.3333330154418945, 0.30000001192092895, 1.3333330154418945, 0.2666666805744171, 1.3333330154418945, 0.2666666805744171, 1.4166663885116577, 0.2666666805744171, 1.4166663885116577, 0.30000001192092895, 1.4166663885116577, 0.2666666805744171, 1.3333330154418945, 0.2666666805744171, 1.3333330154418945, 0.23333334922790527, 1.3333330154418945, 0.23333334922790527, 1.4166663885116577, 0.23333334922790527, 1.4166663885116577, 0.2666666805744171, 1.4166663885116577, 0.23333334922790527, 1.3333330154418945, 0.23333334922790527, 1.3333330154418945, 0.20000001788139343, 1.3333330154418945, 0.20000001788139343, 1.4166663885116577, 0.20000001788139343, 1.4166663885116577, 0.23333334922790527, 1.4166663885116577, 0.20000001788139343, 1.3333330154418945, 0.20000001788139343, 1.3333330154418945, 0.1666666865348816, 1.3333330154418945, 0.1666666865348816, 1.4166663885116577, 0.1666666865348816, 1.4166663885116577, 0.20000001788139343, 1.4166663885116577, 0.1666666865348816, 1.3333330154418945, 0.1666666865348816, 1.3333330154418945, 0.13333335518836975, 1.3333330154418945, 0.13333335518836975, 1.4166663885116577, 0.13333335518836975, 1.4166663885116577, 0.1666666865348816, 1.4166663885116577, 0.13333335518836975, 1.3333330154418945, 0.13333335518836975, 1.3333330154418945, 0.10000002384185791, 1.3333330154418945, 0.10000002384185791, 1.4166663885116577, 0.10000002384185791, 1.4166663885116577, 0.13333335518836975, 1.4166663885116577, 0.10000002384185791, 1.3333330154418945, 0.10000002384185791, 1.3333330154418945, 0.06666669249534607, 1.3333330154418945, 0.06666669249534607, 1.4166663885116577, 0.06666669249534607, 1.4166663885116577, 0.10000002384185791, 1.4166663885116577, 0.06666669249534607, 1.3333330154418945, 0.06666669249534607, 1.3333330154418945, 0.03333335742354393, 1.3333330154418945, 0.03333335742354393, 1.4166663885116577, 0.03333335742354393, 1.4166663885116577, 0.06666669249534607, 1.4166663885116577, 0.03333335742354393, 1.3333330154418945, 0.03333335742354393, 1.3333330154418945, 2.2351741790771484e-8, 1.3333330154418945, 2.2351741790771484e-8, 1.4166663885116577, 2.2351741790771484e-8, 1.4166663885116577, 0.03333335742354393, 1.3333330154418945, 0.4000000059604645, 1.2499996423721313, 0.4000000059604645, 1.2499996423721313, 0.36666667461395263, 1.2499996423721313, 0.36666667461395263, 1.3333330154418945, 0.36666667461395263, 1.3333330154418945, 0.4000000059604645, 1.3333330154418945, 0.36666667461395263, 1.2499996423721313, 0.36666667461395263, 1.2499996423721313, 0.3333333432674408, 1.2499996423721313, 0.3333333432674408, 1.3333330154418945, 0.3333333432674408, 1.3333330154418945, 0.36666667461395263, 1.3333330154418945, 0.3333333432674408, 1.2499996423721313, 0.3333333432674408, 1.2499996423721313, 0.30000001192092895, 1.2499996423721313, 0.30000001192092895, 1.3333330154418945, 0.30000001192092895, 1.3333330154418945, 0.3333333432674408, 1.3333330154418945, 0.30000001192092895, 1.2499996423721313, 0.30000001192092895, 1.2499996423721313, 0.2666666805744171, 1.2499996423721313, 0.2666666805744171, 1.3333330154418945, 0.2666666805744171, 1.3333330154418945, 0.30000001192092895, 1.3333330154418945, 0.2666666805744171, 1.2499996423721313, 0.2666666805744171, 1.2499996423721313, 0.23333334922790527, 1.2499996423721313, 0.23333334922790527, 1.3333330154418945, 0.23333334922790527, 1.3333330154418945, 0.2666666805744171, 1.3333330154418945, 0.23333334922790527, 1.2499996423721313, 0.23333334922790527, 1.2499996423721313, 0.20000001788139343, 1.2499996423721313, 0.20000001788139343, 1.3333330154418945, 0.20000001788139343, 1.3333330154418945, 0.23333334922790527, 1.3333330154418945, 0.20000001788139343, 1.2499996423721313, 0.20000001788139343, 1.2499996423721313, 0.1666666865348816, 1.2499996423721313, 0.1666666865348816, 1.3333330154418945, 0.1666666865348816, 1.3333330154418945, 0.20000001788139343, 1.3333330154418945, 0.1666666865348816, 1.2499996423721313, 0.1666666865348816, 1.2499996423721313, 0.13333335518836975, 1.2499996423721313, 0.13333335518836975, 1.3333330154418945, 0.13333335518836975, 1.3333330154418945, 0.1666666865348816, 1.3333330154418945, 0.13333335518836975, 1.2499996423721313, 0.13333335518836975, 1.2499996423721313, 0.10000002384185791, 1.2499996423721313, 0.10000002384185791, 1.3333330154418945, 0.10000002384185791, 1.3333330154418945, 0.13333335518836975, 1.3333330154418945, 0.10000002384185791, 1.2499996423721313, 0.10000002384185791, 1.2499996423721313, 0.06666669249534607, 1.2499996423721313, 0.06666669249534607, 1.3333330154418945, 0.06666669249534607, 1.3333330154418945, 0.10000002384185791, 1.3333330154418945, 0.06666669249534607, 1.2499996423721313, 0.06666669249534607, 1.2499996423721313, 0.03333335742354393, 1.2499996423721313, 0.03333335742354393, 1.3333330154418945, 0.03333335742354393, 1.3333330154418945, 0.06666669249534607, 1.3333330154418945, 0.03333335742354393, 1.2499996423721313, 0.03333335742354393, 1.2499996423721313, 2.2351741790771484e-8, 1.2499996423721313, 2.2351741790771484e-8, 1.3333330154418945, 2.2351741790771484e-8, 1.3333330154418945, 0.03333335742354393, 1.2499996423721313, 0.4000000059604645, 1.1666662693023681, 0.4000000059604645, 1.1666662693023681, 0.36666667461395263, 1.1666662693023681, 0.36666667461395263, 1.2499996423721313, 0.36666667461395263, 1.2499996423721313, 0.4000000059604645, 1.2499996423721313, 0.36666667461395263, 1.1666662693023681, 0.36666667461395263, 1.1666662693023681, 0.3333333432674408, 1.1666662693023681, 0.3333333432674408, 1.2499996423721313, 0.3333333432674408, 1.2499996423721313, 0.36666667461395263, 1.2499996423721313, 0.3333333432674408, 1.1666662693023681, 0.3333333432674408, 1.1666662693023681, 0.30000001192092895, 1.1666662693023681, 0.30000001192092895, 1.2499996423721313, 0.30000001192092895, 1.2499996423721313, 0.3333333432674408, 1.2499996423721313, 0.30000001192092895, 1.1666662693023681, 0.30000001192092895, 1.1666662693023681, 0.2666666805744171, 1.1666662693023681, 0.2666666805744171, 1.2499996423721313, 0.2666666805744171, 1.2499996423721313, 0.30000001192092895, 1.2499996423721313, 0.2666666805744171, 1.1666662693023681, 0.2666666805744171, 1.1666662693023681, 0.23333334922790527, 1.1666662693023681, 0.23333334922790527, 1.2499996423721313, 0.23333334922790527, 1.2499996423721313, 0.2666666805744171, 1.2499996423721313, 0.23333334922790527, 1.1666662693023681, 0.23333334922790527, 1.1666662693023681, 0.20000001788139343, 1.1666662693023681, 0.20000001788139343, 1.2499996423721313, 0.20000001788139343, 1.2499996423721313, 0.23333334922790527, 1.2499996423721313, 0.20000001788139343, 1.1666662693023681, 0.20000001788139343, 1.1666662693023681, 0.1666666865348816, 1.1666662693023681, 0.1666666865348816, 1.2499996423721313, 0.1666666865348816, 1.2499996423721313, 0.20000001788139343, 1.2499996423721313, 0.1666666865348816, 1.1666662693023681, 0.1666666865348816, 1.1666662693023681, 0.13333335518836975, 1.1666662693023681, 0.13333335518836975, 1.2499996423721313, 0.13333335518836975, 1.2499996423721313, 0.1666666865348816, 1.2499996423721313, 0.13333335518836975, 1.1666662693023681, 0.13333335518836975, 1.1666662693023681, 0.10000002384185791, 1.1666662693023681, 0.10000002384185791, 1.2499996423721313, 0.10000002384185791, 1.2499996423721313, 0.13333335518836975, 1.2499996423721313, 0.10000002384185791, 1.1666662693023681, 0.10000002384185791, 1.1666662693023681, 0.06666669249534607, 1.1666662693023681, 0.06666669249534607, 1.2499996423721313, 0.06666669249534607, 1.2499996423721313, 0.10000002384185791, 1.2499996423721313, 0.06666669249534607, 1.1666662693023681, 0.06666669249534607, 1.1666662693023681, 0.03333335742354393, 1.1666662693023681, 0.03333335742354393, 1.2499996423721313, 0.03333335742354393, 1.2499996423721313, 0.06666669249534607, 1.2499996423721313, 0.03333335742354393, 1.1666662693023681, 0.03333335742354393, 1.1666662693023681, 2.2351741790771484e-8, 1.1666662693023681, 2.2351741790771484e-8, 1.2499996423721313, 2.2351741790771484e-8, 1.2499996423721313, 0.03333335742354393, 1.1666662693023681, 0.4000000059604645, 1.083332896232605, 0.4000000059604645, 1.083332896232605, 0.36666667461395263, 1.083332896232605, 0.36666667461395263, 1.1666662693023681, 0.36666667461395263, 1.1666662693023681, 0.4000000059604645, 1.1666662693023681, 0.36666667461395263, 1.083332896232605, 0.36666667461395263, 1.083332896232605, 0.3333333432674408, 1.083332896232605, 0.3333333432674408, 1.1666662693023681, 0.3333333432674408, 1.1666662693023681, 0.36666667461395263, 1.1666662693023681, 0.3333333432674408, 1.083332896232605, 0.3333333432674408, 1.083332896232605, 0.30000001192092895, 1.083332896232605, 0.30000001192092895, 1.1666662693023681, 0.30000001192092895, 1.1666662693023681, 0.3333333432674408, 1.1666662693023681, 0.30000001192092895, 1.083332896232605, 0.30000001192092895, 1.083332896232605, 0.2666666805744171, 1.083332896232605, 0.2666666805744171, 1.1666662693023681, 0.2666666805744171, 1.1666662693023681, 0.30000001192092895, 1.1666662693023681, 0.2666666805744171, 1.083332896232605, 0.2666666805744171, 1.083332896232605, 0.23333334922790527, 1.083332896232605, 0.23333334922790527, 1.1666662693023681, 0.23333334922790527, 1.1666662693023681, 0.2666666805744171, 1.1666662693023681, 0.23333334922790527, 1.083332896232605, 0.23333334922790527, 1.083332896232605, 0.20000001788139343, 1.083332896232605, 0.20000001788139343, 1.1666662693023681, 0.20000001788139343, 1.1666662693023681, 0.23333334922790527, 1.1666662693023681, 0.20000001788139343, 1.083332896232605, 0.20000001788139343, 1.083332896232605, 0.1666666865348816, 1.083332896232605, 0.1666666865348816, 1.1666662693023681, 0.1666666865348816, 1.1666662693023681, 0.20000001788139343, 1.1666662693023681, 0.1666666865348816, 1.083332896232605, 0.1666666865348816, 1.083332896232605, 0.13333335518836975, 1.083332896232605, 0.13333335518836975, 1.1666662693023681, 0.13333335518836975, 1.1666662693023681, 0.1666666865348816, 1.1666662693023681, 0.13333335518836975, 1.083332896232605, 0.13333335518836975, 1.083332896232605, 0.10000002384185791, 1.083332896232605, 0.10000002384185791, 1.1666662693023681, 0.10000002384185791, 1.1666662693023681, 0.13333335518836975, 1.1666662693023681, 0.10000002384185791, 1.083332896232605, 0.10000002384185791, 1.083332896232605, 0.06666669249534607, 1.083332896232605, 0.06666669249534607, 1.1666662693023681, 0.06666669249534607, 1.1666662693023681, 0.10000002384185791, 1.1666662693023681, 0.06666669249534607, 1.083332896232605, 0.06666669249534607, 1.083332896232605, 0.03333335742354393, 1.083332896232605, 0.03333335742354393, 1.1666662693023681, 0.03333335742354393, 1.1666662693023681, 0.06666669249534607, 1.1666662693023681, 0.03333335742354393, 1.083332896232605, 0.03333335742354393, 1.083332896232605, 2.2351741790771484e-8, 1.083332896232605, 2.2351741790771484e-8, 1.1666662693023681, 2.2351741790771484e-8, 1.1666662693023681, 0.03333335742354393, 1.083332896232605, 0.4000000059604645, 0.9999995827674866, 0.4000000059604645, 0.9999995827674866, 0.36666667461395263, 0.9999995827674866, 0.36666667461395263, 1.083332896232605, 0.36666667461395263, 1.083332896232605, 0.4000000059604645, 1.083332896232605, 0.36666667461395263, 0.9999995827674866, 0.36666667461395263, 0.9999995827674866, 0.3333333432674408, 0.9999995827674866, 0.3333333432674408, 1.083332896232605, 0.3333333432674408, 1.083332896232605, 0.36666667461395263, 1.083332896232605, 0.3333333432674408, 0.9999995827674866, 0.3333333432674408, 0.9999995827674866, 0.30000001192092895, 0.9999995827674866, 0.30000001192092895, 1.083332896232605, 0.30000001192092895, 1.083332896232605, 0.3333333432674408, 1.083332896232605, 0.30000001192092895, 0.9999995827674866, 0.30000001192092895, 0.9999995827674866, 0.2666666805744171, 0.9999995827674866, 0.2666666805744171, 1.083332896232605, 0.2666666805744171, 1.083332896232605, 0.30000001192092895, 1.083332896232605, 0.2666666805744171, 0.9999995827674866, 0.2666666805744171, 0.9999995827674866, 0.23333334922790527, 0.9999995827674866, 0.23333334922790527, 1.083332896232605, 0.23333334922790527, 1.083332896232605, 0.2666666805744171, 1.083332896232605, 0.23333334922790527, 0.9999995827674866, 0.23333334922790527, 0.9999995827674866, 0.20000001788139343, 0.9999995827674866, 0.20000001788139343, 1.083332896232605, 0.20000001788139343, 1.083332896232605, 0.23333334922790527, 1.083332896232605, 0.20000001788139343, 0.9999995827674866, 0.20000001788139343, 0.9999995827674866, 0.1666666865348816, 0.9999995827674866, 0.1666666865348816, 1.083332896232605, 0.1666666865348816, 1.083332896232605, 0.20000001788139343, 1.083332896232605, 0.1666666865348816, 0.9999995827674866, 0.1666666865348816, 0.9999995827674866, 0.13333335518836975, 0.9999995827674866, 0.13333335518836975, 1.083332896232605, 0.13333335518836975, 1.083332896232605, 0.1666666865348816, 1.083332896232605, 0.13333335518836975, 0.9999995827674866, 0.13333335518836975, 0.9999995827674866, 0.10000002384185791, 0.9999995827674866, 0.10000002384185791, 1.083332896232605, 0.10000002384185791, 1.083332896232605, 0.13333335518836975, 1.083332896232605, 0.10000002384185791, 0.9999995827674866, 0.10000002384185791, 0.9999995827674866, 0.06666669249534607, 0.9999995827674866, 0.06666669249534607, 1.083332896232605, 0.06666669249534607, 1.083332896232605, 0.10000002384185791, 1.083332896232605, 0.06666669249534607, 0.9999995827674866, 0.06666669249534607, 0.9999995827674866, 0.03333335742354393, 0.9999995827674866, 0.03333335742354393, 1.083332896232605, 0.03333335742354393, 1.083332896232605, 0.06666669249534607, 1.083332896232605, 0.03333335742354393, 0.9999995827674866, 0.03333335742354393, 0.9999995827674866, 2.2351741790771484e-8, 0.9999995827674866, 2.2351741790771484e-8, 1.083332896232605, 2.2351741790771484e-8, 1.083332896232605, 0.03333335742354393, 1, 0.4000000059604645, 0.9166666865348816, 0.4000000059604645, 0.9166666865348816, 0.36666667461395263, 0.9166666865348816, 0.36666667461395263, 1, 0.36666667461395263, 1, 0.4000000059604645, 1, 0.36666667461395263, 0.9166666865348816, 0.36666667461395263, 0.9166666865348816, 0.3333333432674408, 0.9166666865348816, 0.3333333432674408, 1, 0.3333333432674408, 1, 0.36666667461395263, 1, 0.3333333432674408, 0.9166666865348816, 0.3333333432674408, 0.9166666865348816, 0.30000001192092895, 0.9166666865348816, 0.30000001192092895, 1, 0.30000001192092895, 1, 0.3333333432674408, 1, 0.30000001192092895, 0.9166666865348816, 0.30000001192092895, 0.9166666865348816, 0.2666666805744171, 0.9166666865348816, 0.2666666805744171, 1, 0.2666666805744171, 1, 0.30000001192092895, 1, 0.2666666805744171, 0.9166666865348816, 0.2666666805744171, 0.9166666865348816, 0.23333334922790527, 0.9166666865348816, 0.23333334922790527, 1, 0.23333334922790527, 1, 0.2666666805744171, 1, 0.23333334922790527, 0.9166666865348816, 0.23333334922790527, 0.9166666865348816, 0.20000001788139343, 0.9166666865348816, 0.20000001788139343, 1, 0.20000001788139343, 1, 0.23333334922790527, 1, 0.20000001788139343, 0.9166666865348816, 0.20000001788139343, 0.9166666865348816, 0.1666666865348816, 0.9166666865348816, 0.1666666865348816, 1, 0.1666666865348816, 1, 0.20000001788139343, 1, 0.1666666865348816, 0.9166666865348816, 0.1666666865348816, 0.9166666865348816, 0.13333335518836975, 0.9166666865348816, 0.13333335518836975, 1, 0.13333335518836975, 1, 0.1666666865348816, 1, 0.13333335518836975, 0.9166666865348816, 0.13333335518836975, 0.9166666865348816, 0.10000002384185791, 0.9166666865348816, 0.10000002384185791, 1, 0.10000002384185791, 1, 0.13333335518836975, 1, 0.10000002384185791, 0.9166666865348816, 0.10000002384185791, 0.9166666865348816, 0.06666669249534607, 0.9166666865348816, 0.06666669249534607, 1, 0.06666669249534607, 1, 0.10000002384185791, 1, 0.06666669249534607, 0.9166666865348816, 0.06666669249534607, 0.9166666865348816, 0.03333335742354393, 0.9166666865348816, 0.03333335742354393, 1, 0.03333335742354393, 1, 0.06666669249534607, 1, 0.03333335742354393, 0.9166666865348816, 0.03333335742354393, 0.9166666865348816, 2.2351741790771484e-8, 0.9166666865348816, 2.2351741790771484e-8, 1, 2.2351741790771484e-8, 1, 0.03333335742354393, 0.9166666865348816, 0.4000000059604645, 0.8333333730697632, 0.4000000059604645, 0.8333333730697632, 0.36666667461395263, 0.8333333730697632, 0.36666667461395263, 0.9166666865348816, 0.36666667461395263, 0.9166666865348816, 0.4000000059604645, 0.9166666865348816, 0.36666667461395263, 0.8333333730697632, 0.36666667461395263, 0.8333333730697632, 0.3333333432674408, 0.8333333730697632, 0.3333333432674408, 0.9166666865348816, 0.3333333432674408, 0.9166666865348816, 0.36666667461395263, 0.9166666865348816, 0.3333333432674408, 0.8333333730697632, 0.3333333432674408, 0.8333333730697632, 0.30000001192092895, 0.8333333730697632, 0.30000001192092895, 0.9166666865348816, 0.30000001192092895, 0.9166666865348816, 0.3333333432674408, 0.9166666865348816, 0.30000001192092895, 0.8333333730697632, 0.30000001192092895, 0.8333333730697632, 0.2666666805744171, 0.8333333730697632, 0.2666666805744171, 0.9166666865348816, 0.2666666805744171, 0.9166666865348816, 0.30000001192092895, 0.9166666865348816, 0.2666666805744171, 0.8333333730697632, 0.2666666805744171, 0.8333333730697632, 0.23333334922790527, 0.8333333730697632, 0.23333334922790527, 0.9166666865348816, 0.23333334922790527, 0.9166666865348816, 0.2666666805744171, 0.9166666865348816, 0.23333334922790527, 0.8333333730697632, 0.23333334922790527, 0.8333333730697632, 0.20000001788139343, 0.8333333730697632, 0.20000001788139343, 0.9166666865348816, 0.20000001788139343, 0.9166666865348816, 0.23333334922790527, 0.9166666865348816, 0.20000001788139343, 0.8333333730697632, 0.20000001788139343, 0.8333333730697632, 0.1666666865348816, 0.8333333730697632, 0.1666666865348816, 0.9166666865348816, 0.1666666865348816, 0.9166666865348816, 0.20000001788139343, 0.9166666865348816, 0.1666666865348816, 0.8333333730697632, 0.1666666865348816, 0.8333333730697632, 0.13333335518836975, 0.8333333730697632, 0.13333335518836975, 0.9166666865348816, 0.13333335518836975, 0.9166666865348816, 0.1666666865348816, 0.9166666865348816, 0.13333335518836975, 0.8333333730697632, 0.13333335518836975, 0.8333333730697632, 0.10000002384185791, 0.8333333730697632, 0.10000002384185791, 0.9166666865348816, 0.10000002384185791, 0.9166666865348816, 0.13333335518836975, 0.9166666865348816, 0.10000002384185791, 0.8333333730697632, 0.10000002384185791, 0.8333333730697632, 0.06666669249534607, 0.8333333730697632, 0.06666669249534607, 0.9166666865348816, 0.06666669249534607, 0.9166666865348816, 0.10000002384185791, 0.9166666865348816, 0.06666669249534607, 0.8333333730697632, 0.06666669249534607, 0.8333333730697632, 0.03333335742354393, 0.8333333730697632, 0.03333335742354393, 0.9166666865348816, 0.03333335742354393, 0.9166666865348816, 0.06666669249534607, 0.9166666865348816, 0.03333335742354393, 0.8333333730697632, 0.03333335742354393, 0.8333333730697632, 2.2351741790771484e-8, 0.8333333730697632, 2.2351741790771484e-8, 0.9166666865348816, 2.2351741790771484e-8, 0.9166666865348816, 0.03333335742354393, 0.8333333730697632, 0.4000000059604645, 0.7500000596046448, 0.4000000059604645, 0.7500000596046448, 0.36666667461395263, 0.7500000596046448, 0.36666667461395263, 0.8333333730697632, 0.36666667461395263, 0.8333333730697632, 0.4000000059604645, 0.8333333730697632, 0.36666667461395263, 0.7500000596046448, 0.36666667461395263, 0.7500000596046448, 0.3333333432674408, 0.7500000596046448, 0.3333333432674408, 0.8333333730697632, 0.3333333432674408, 0.8333333730697632, 0.36666667461395263, 0.8333333730697632, 0.3333333432674408, 0.7500000596046448, 0.3333333432674408, 0.7500000596046448, 0.30000001192092895, 0.7500000596046448, 0.30000001192092895, 0.8333333730697632, 0.30000001192092895, 0.8333333730697632, 0.3333333432674408, 0.8333333730697632, 0.30000001192092895, 0.7500000596046448, 0.30000001192092895, 0.7500000596046448, 0.2666666805744171, 0.7500000596046448, 0.2666666805744171, 0.8333333730697632, 0.2666666805744171, 0.8333333730697632, 0.30000001192092895, 0.8333333730697632, 0.2666666805744171, 0.7500000596046448, 0.2666666805744171, 0.7500000596046448, 0.23333334922790527, 0.7500000596046448, 0.23333334922790527, 0.8333333730697632, 0.23333334922790527, 0.8333333730697632, 0.2666666805744171, 0.8333333730697632, 0.23333334922790527, 0.7500000596046448, 0.23333334922790527, 0.7500000596046448, 0.20000001788139343, 0.7500000596046448, 0.20000001788139343, 0.8333333730697632, 0.20000001788139343, 0.8333333730697632, 0.23333334922790527, 0.8333333730697632, 0.20000001788139343, 0.7500000596046448, 0.20000001788139343, 0.7500000596046448, 0.1666666865348816, 0.7500000596046448, 0.1666666865348816, 0.8333333730697632, 0.1666666865348816, 0.8333333730697632, 0.20000001788139343, 0.8333333730697632, 0.1666666865348816, 0.7500000596046448, 0.1666666865348816, 0.7500000596046448, 0.13333335518836975, 0.7500000596046448, 0.13333335518836975, 0.8333333730697632, 0.13333335518836975, 0.8333333730697632, 0.1666666865348816, 0.8333333730697632, 0.13333335518836975, 0.7500000596046448, 0.13333335518836975, 0.7500000596046448, 0.10000002384185791, 0.7500000596046448, 0.10000002384185791, 0.8333333730697632, 0.10000002384185791, 0.8333333730697632, 0.13333335518836975, 0.8333333730697632, 0.10000002384185791, 0.7500000596046448, 0.10000002384185791, 0.7500000596046448, 0.06666669249534607, 0.7500000596046448, 0.06666669249534607, 0.8333333730697632, 0.06666669249534607, 0.8333333730697632, 0.10000002384185791, 0.8333333730697632, 0.06666669249534607, 0.7500000596046448, 0.06666669249534607, 0.7500000596046448, 0.03333335742354393, 0.7500000596046448, 0.03333335742354393, 0.8333333730697632, 0.03333335742354393, 0.8333333730697632, 0.06666669249534607, 0.8333333730697632, 0.03333335742354393, 0.7500000596046448, 0.03333335742354393, 0.7500000596046448, 2.2351741790771484e-8, 0.7500000596046448, 2.2351741790771484e-8, 0.8333333730697632, 2.2351741790771484e-8, 0.8333333730697632, 0.03333335742354393, 0.7500000596046448, 0.4000000059604645, 0.6666667461395264, 0.4000000059604645, 0.6666667461395264, 0.36666667461395263, 0.6666667461395264, 0.36666667461395263, 0.7500000596046448, 0.36666667461395263, 0.7500000596046448, 0.4000000059604645, 0.7500000596046448, 0.36666667461395263, 0.6666667461395264, 0.36666667461395263, 0.6666667461395264, 0.3333333432674408, 0.6666667461395264, 0.3333333432674408, 0.7500000596046448, 0.3333333432674408, 0.7500000596046448, 0.36666667461395263, 0.7500000596046448, 0.3333333432674408, 0.6666667461395264, 0.3333333432674408, 0.6666667461395264, 0.30000001192092895, 0.6666667461395264, 0.30000001192092895, 0.7500000596046448, 0.30000001192092895, 0.7500000596046448, 0.3333333432674408, 0.7500000596046448, 0.30000001192092895, 0.6666667461395264, 0.30000001192092895, 0.6666667461395264, 0.2666666805744171, 0.6666667461395264, 0.2666666805744171, 0.7500000596046448, 0.2666666805744171, 0.7500000596046448, 0.30000001192092895, 0.7500000596046448, 0.2666666805744171, 0.6666667461395264, 0.2666666805744171, 0.6666667461395264, 0.23333334922790527, 0.6666667461395264, 0.23333334922790527, 0.7500000596046448, 0.23333334922790527, 0.7500000596046448, 0.2666666805744171, 0.7500000596046448, 0.23333334922790527, 0.6666667461395264, 0.23333334922790527, 0.6666667461395264, 0.20000001788139343, 0.6666667461395264, 0.20000001788139343, 0.7500000596046448, 0.20000001788139343, 0.7500000596046448, 0.23333334922790527, 0.7500000596046448, 0.20000001788139343, 0.6666667461395264, 0.20000001788139343, 0.6666667461395264, 0.1666666865348816, 0.6666667461395264, 0.1666666865348816, 0.7500000596046448, 0.1666666865348816, 0.7500000596046448, 0.20000001788139343, 0.7500000596046448, 0.1666666865348816, 0.6666667461395264, 0.1666666865348816, 0.6666667461395264, 0.13333335518836975, 0.6666667461395264, 0.13333335518836975, 0.7500000596046448, 0.13333335518836975, 0.7500000596046448, 0.1666666865348816, 0.7500000596046448, 0.13333335518836975, 0.6666667461395264, 0.13333335518836975, 0.6666667461395264, 0.10000002384185791, 0.6666667461395264, 0.10000002384185791, 0.7500000596046448, 0.10000002384185791, 0.7500000596046448, 0.13333335518836975, 0.7500000596046448, 0.10000002384185791, 0.6666667461395264, 0.10000002384185791, 0.6666667461395264, 0.06666669249534607, 0.6666667461395264, 0.06666669249534607, 0.7500000596046448, 0.06666669249534607, 0.7500000596046448, 0.10000002384185791, 0.7500000596046448, 0.06666669249534607, 0.6666667461395264, 0.06666669249534607, 0.6666667461395264, 0.03333335742354393, 0.6666667461395264, 0.03333335742354393, 0.7500000596046448, 0.03333335742354393, 0.7500000596046448, 0.06666669249534607, 0.7500000596046448, 0.03333335742354393, 0.6666667461395264, 0.03333335742354393, 0.6666667461395264, 2.2351741790771484e-8, 0.6666667461395264, 2.2351741790771484e-8, 0.7500000596046448, 2.2351741790771484e-8, 0.7500000596046448, 0.03333335742354393, 0.6666667461395264, 0.4000000059604645, 0.583333432674408, 0.4000000059604645, 0.583333432674408, 0.36666667461395263, 0.583333432674408, 0.36666667461395263, 0.6666667461395264, 0.36666667461395263, 0.6666667461395264, 0.4000000059604645, 0.6666667461395264, 0.36666667461395263, 0.583333432674408, 0.36666667461395263, 0.583333432674408, 0.3333333432674408, 0.583333432674408, 0.3333333432674408, 0.6666667461395264, 0.3333333432674408, 0.6666667461395264, 0.36666667461395263, 0.6666667461395264, 0.3333333432674408, 0.583333432674408, 0.3333333432674408, 0.583333432674408, 0.30000001192092895, 0.583333432674408, 0.30000001192092895, 0.6666667461395264, 0.30000001192092895, 0.6666667461395264, 0.3333333432674408, 0.6666667461395264, 0.30000001192092895, 0.583333432674408, 0.30000001192092895, 0.583333432674408, 0.2666666805744171, 0.583333432674408, 0.2666666805744171, 0.6666667461395264, 0.2666666805744171, 0.6666667461395264, 0.30000001192092895, 0.6666667461395264, 0.2666666805744171, 0.583333432674408, 0.2666666805744171, 0.583333432674408, 0.23333334922790527, 0.583333432674408, 0.23333334922790527, 0.6666667461395264, 0.23333334922790527, 0.6666667461395264, 0.2666666805744171, 0.6666667461395264, 0.23333334922790527, 0.583333432674408, 0.23333334922790527, 0.583333432674408, 0.20000001788139343, 0.583333432674408, 0.20000001788139343, 0.6666667461395264, 0.20000001788139343, 0.6666667461395264, 0.23333334922790527, 0.6666667461395264, 0.20000001788139343, 0.583333432674408, 0.20000001788139343, 0.583333432674408, 0.1666666865348816, 0.583333432674408, 0.1666666865348816, 0.6666667461395264, 0.1666666865348816, 0.6666667461395264, 0.20000001788139343, 0.6666667461395264, 0.1666666865348816, 0.583333432674408, 0.1666666865348816, 0.583333432674408, 0.13333335518836975, 0.583333432674408, 0.13333335518836975, 0.6666667461395264, 0.13333335518836975, 0.6666667461395264, 0.1666666865348816, 0.6666667461395264, 0.13333335518836975, 0.583333432674408, 0.13333335518836975, 0.583333432674408, 0.10000002384185791, 0.583333432674408, 0.10000002384185791, 0.6666667461395264, 0.10000002384185791, 0.6666667461395264, 0.13333335518836975, 0.6666667461395264, 0.10000002384185791, 0.583333432674408, 0.10000002384185791, 0.583333432674408, 0.06666669249534607, 0.583333432674408, 0.06666669249534607, 0.6666667461395264, 0.06666669249534607, 0.6666667461395264, 0.10000002384185791, 0.6666667461395264, 0.06666669249534607, 0.583333432674408, 0.06666669249534607, 0.583333432674408, 0.03333335742354393, 0.583333432674408, 0.03333335742354393, 0.6666667461395264, 0.03333335742354393, 0.6666667461395264, 0.06666669249534607, 0.6666667461395264, 0.03333335742354393, 0.583333432674408, 0.03333335742354393, 0.583333432674408, 2.2351741790771484e-8, 0.583333432674408, 2.2351741790771484e-8, 0.6666667461395264, 2.2351741790771484e-8, 0.6666667461395264, 0.03333335742354393, 0.583333432674408, 0.4000000059604645, 0.5000001192092895, 0.4000000059604645, 0.5000001192092895, 0.36666667461395263, 0.5000001192092895, 0.36666667461395263, 0.583333432674408, 0.36666667461395263, 0.583333432674408, 0.4000000059604645, 0.583333432674408, 0.36666667461395263, 0.5000001192092895, 0.36666667461395263, 0.5000001192092895, 0.3333333432674408, 0.5000001192092895, 0.3333333432674408, 0.583333432674408, 0.3333333432674408, 0.583333432674408, 0.36666667461395263, 0.583333432674408, 0.3333333432674408, 0.5000001192092895, 0.3333333432674408, 0.5000001192092895, 0.30000001192092895, 0.5000001192092895, 0.30000001192092895, 0.583333432674408, 0.30000001192092895, 0.583333432674408, 0.3333333432674408, 0.583333432674408, 0.30000001192092895, 0.5000001192092895, 0.30000001192092895, 0.5000001192092895, 0.2666666805744171, 0.5000001192092895, 0.2666666805744171, 0.583333432674408, 0.2666666805744171, 0.583333432674408, 0.30000001192092895, 0.583333432674408, 0.2666666805744171, 0.5000001192092895, 0.2666666805744171, 0.5000001192092895, 0.23333334922790527, 0.5000001192092895, 0.23333334922790527, 0.583333432674408, 0.23333334922790527, 0.583333432674408, 0.2666666805744171, 0.583333432674408, 0.23333334922790527, 0.5000001192092895, 0.23333334922790527, 0.5000001192092895, 0.20000001788139343, 0.5000001192092895, 0.20000001788139343, 0.583333432674408, 0.20000001788139343, 0.583333432674408, 0.23333334922790527, 0.583333432674408, 0.20000001788139343, 0.5000001192092895, 0.20000001788139343, 0.5000001192092895, 0.1666666865348816, 0.5000001192092895, 0.1666666865348816, 0.583333432674408, 0.1666666865348816, 0.583333432674408, 0.20000001788139343, 0.583333432674408, 0.1666666865348816, 0.5000001192092895, 0.1666666865348816, 0.5000001192092895, 0.13333335518836975, 0.5000001192092895, 0.13333335518836975, 0.583333432674408, 0.13333335518836975, 0.583333432674408, 0.1666666865348816, 0.583333432674408, 0.13333335518836975, 0.5000001192092895, 0.13333335518836975, 0.5000001192092895, 0.10000002384185791, 0.5000001192092895, 0.10000002384185791, 0.583333432674408, 0.10000002384185791, 0.583333432674408, 0.13333335518836975, 0.583333432674408, 0.10000002384185791, 0.5000001192092895, 0.10000002384185791, 0.5000001192092895, 0.06666669249534607, 0.5000001192092895, 0.06666669249534607, 0.583333432674408, 0.06666669249534607, 0.583333432674408, 0.10000002384185791, 0.583333432674408, 0.06666669249534607, 0.5000001192092895, 0.06666669249534607, 0.5000001192092895, 0.03333335742354393, 0.5000001192092895, 0.03333335742354393, 0.583333432674408, 0.03333335742354393, 0.583333432674408, 0.06666669249534607, 0.583333432674408, 0.03333335742354393, 0.5000001192092895, 0.03333335742354393, 0.5000001192092895, 2.2351741790771484e-8, 0.5000001192092895, 2.2351741790771484e-8, 0.583333432674408, 2.2351741790771484e-8, 0.583333432674408, 0.03333335742354393, 0.5000001192092895, 0.4000000059604645, 0.41666677594184875, 0.4000000059604645, 0.41666677594184875, 0.36666667461395263, 0.41666677594184875, 0.36666667461395263, 0.5000001192092895, 0.36666667461395263, 0.5000001192092895, 0.4000000059604645, 0.5000001192092895, 0.36666667461395263, 0.41666677594184875, 0.36666667461395263, 0.41666677594184875, 0.3333333432674408, 0.41666677594184875, 0.3333333432674408, 0.5000001192092895, 0.3333333432674408, 0.5000001192092895, 0.36666667461395263, 0.5000001192092895, 0.3333333432674408, 0.41666677594184875, 0.3333333432674408, 0.41666677594184875, 0.30000001192092895, 0.41666677594184875, 0.30000001192092895, 0.5000001192092895, 0.30000001192092895, 0.5000001192092895, 0.3333333432674408, 0.5000001192092895, 0.30000001192092895, 0.41666677594184875, 0.30000001192092895, 0.41666677594184875, 0.2666666805744171, 0.41666677594184875, 0.2666666805744171, 0.5000001192092895, 0.2666666805744171, 0.5000001192092895, 0.30000001192092895, 0.5000001192092895, 0.2666666805744171, 0.41666677594184875, 0.2666666805744171, 0.41666677594184875, 0.23333334922790527, 0.41666677594184875, 0.23333334922790527, 0.5000001192092895, 0.23333334922790527, 0.5000001192092895, 0.2666666805744171, 0.5000001192092895, 0.23333334922790527, 0.41666677594184875, 0.23333334922790527, 0.41666677594184875, 0.20000001788139343, 0.41666677594184875, 0.20000001788139343, 0.5000001192092895, 0.20000001788139343, 0.5000001192092895, 0.23333334922790527, 0.5000001192092895, 0.20000001788139343, 0.41666677594184875, 0.20000001788139343, 0.41666677594184875, 0.1666666865348816, 0.41666677594184875, 0.1666666865348816, 0.5000001192092895, 0.1666666865348816, 0.5000001192092895, 0.20000001788139343, 0.5000001192092895, 0.1666666865348816, 0.41666677594184875, 0.1666666865348816, 0.41666677594184875, 0.13333335518836975, 0.41666677594184875, 0.13333335518836975, 0.5000001192092895, 0.13333335518836975, 0.5000001192092895, 0.1666666865348816, 0.5000001192092895, 0.13333335518836975, 0.41666677594184875, 0.13333335518836975, 0.41666677594184875, 0.10000002384185791, 0.41666677594184875, 0.10000002384185791, 0.5000001192092895, 0.10000002384185791, 0.5000001192092895, 0.13333335518836975, 0.5000001192092895, 0.10000002384185791, 0.41666677594184875, 0.10000002384185791, 0.41666677594184875, 0.06666669249534607, 0.41666677594184875, 0.06666669249534607, 0.5000001192092895, 0.06666669249534607, 0.5000001192092895, 0.10000002384185791, 0.5000001192092895, 0.06666669249534607, 0.41666677594184875, 0.06666669249534607, 0.41666677594184875, 0.03333335742354393, 0.41666677594184875, 0.03333335742354393, 0.5000001192092895, 0.03333335742354393, 0.5000001192092895, 0.06666669249534607, 0.5000001192092895, 0.03333335742354393, 0.41666677594184875, 0.03333335742354393, 0.41666677594184875, 2.2351741790771484e-8, 0.41666677594184875, 2.2351741790771484e-8, 0.5000001192092895, 2.2351741790771484e-8, 0.5000001192092895, 0.03333335742354393, 0.41666677594184875, 0.4000000059604645, 0.33333343267440796, 0.4000000059604645, 0.33333343267440796, 0.36666667461395263, 0.33333343267440796, 0.36666667461395263, 0.41666677594184875, 0.36666667461395263, 0.41666677594184875, 0.4000000059604645, 0.41666677594184875, 0.36666667461395263, 0.33333343267440796, 0.36666667461395263, 0.33333343267440796, 0.3333333432674408, 0.33333343267440796, 0.3333333432674408, 0.41666677594184875, 0.3333333432674408, 0.41666677594184875, 0.36666667461395263, 0.41666677594184875, 0.3333333432674408, 0.33333343267440796, 0.3333333432674408, 0.33333343267440796, 0.30000001192092895, 0.33333343267440796, 0.30000001192092895, 0.41666677594184875, 0.30000001192092895, 0.41666677594184875, 0.3333333432674408, 0.41666677594184875, 0.30000001192092895, 0.33333343267440796, 0.30000001192092895, 0.33333343267440796, 0.2666666805744171, 0.33333343267440796, 0.2666666805744171, 0.41666677594184875, 0.2666666805744171, 0.41666677594184875, 0.30000001192092895, 0.41666677594184875, 0.2666666805744171, 0.33333343267440796, 0.2666666805744171, 0.33333343267440796, 0.23333334922790527, 0.33333343267440796, 0.23333334922790527, 0.41666677594184875, 0.23333334922790527, 0.41666677594184875, 0.2666666805744171, 0.41666677594184875, 0.23333334922790527, 0.33333343267440796, 0.23333334922790527, 0.33333343267440796, 0.20000001788139343, 0.33333343267440796, 0.20000001788139343, 0.41666677594184875, 0.20000001788139343, 0.41666677594184875, 0.23333334922790527, 0.41666677594184875, 0.20000001788139343, 0.33333343267440796, 0.20000001788139343, 0.33333343267440796, 0.1666666865348816, 0.33333343267440796, 0.1666666865348816, 0.41666677594184875, 0.1666666865348816, 0.41666677594184875, 0.20000001788139343, 0.41666677594184875, 0.1666666865348816, 0.33333343267440796, 0.1666666865348816, 0.33333343267440796, 0.13333335518836975, 0.33333343267440796, 0.13333335518836975, 0.41666677594184875, 0.13333335518836975, 0.41666677594184875, 0.1666666865348816, 0.41666677594184875, 0.13333335518836975, 0.33333343267440796, 0.13333335518836975, 0.33333343267440796, 0.10000002384185791, 0.33333343267440796, 0.10000002384185791, 0.41666677594184875, 0.10000002384185791, 0.41666677594184875, 0.13333335518836975, 0.41666677594184875, 0.10000002384185791, 0.33333343267440796, 0.10000002384185791, 0.33333343267440796, 0.06666669249534607, 0.33333343267440796, 0.06666669249534607, 0.41666677594184875, 0.06666669249534607, 0.41666677594184875, 0.10000002384185791, 0.41666677594184875, 0.06666669249534607, 0.33333343267440796, 0.06666669249534607, 0.33333343267440796, 0.03333335742354393, 0.33333343267440796, 0.03333335742354393, 0.41666677594184875, 0.03333335742354393, 0.41666677594184875, 0.06666669249534607, 0.41666677594184875, 0.03333335742354393, 0.33333343267440796, 0.03333335742354393, 0.33333343267440796, 2.2351741790771484e-8, 0.33333343267440796, 2.2351741790771484e-8, 0.41666677594184875, 2.2351741790771484e-8, 0.41666677594184875, 0.03333335742354393, 0.33333343267440796, 0.4000000059604645, 0.25000008940696716, 0.4000000059604645, 0.25000008940696716, 0.36666667461395263, 0.25000008940696716, 0.36666667461395263, 0.33333343267440796, 0.36666667461395263, 0.33333343267440796, 0.4000000059604645, 0.33333343267440796, 0.36666667461395263, 0.25000008940696716, 0.36666667461395263, 0.25000008940696716, 0.3333333432674408, 0.25000008940696716, 0.3333333432674408, 0.33333343267440796, 0.3333333432674408, 0.33333343267440796, 0.36666667461395263, 0.33333343267440796, 0.3333333432674408, 0.25000008940696716, 0.3333333432674408, 0.25000008940696716, 0.30000001192092895, 0.25000008940696716, 0.30000001192092895, 0.33333343267440796, 0.30000001192092895, 0.33333343267440796, 0.3333333432674408, 0.33333343267440796, 0.30000001192092895, 0.25000008940696716, 0.30000001192092895, 0.25000008940696716, 0.2666666805744171, 0.25000008940696716, 0.2666666805744171, 0.33333343267440796, 0.2666666805744171, 0.33333343267440796, 0.30000001192092895, 0.33333343267440796, 0.2666666805744171, 0.25000008940696716, 0.2666666805744171, 0.25000008940696716, 0.23333334922790527, 0.25000008940696716, 0.23333334922790527, 0.33333343267440796, 0.23333334922790527, 0.33333343267440796, 0.2666666805744171, 0.33333343267440796, 0.23333334922790527, 0.25000008940696716, 0.23333334922790527, 0.25000008940696716, 0.20000001788139343, 0.25000008940696716, 0.20000001788139343, 0.33333343267440796, 0.20000001788139343, 0.33333343267440796, 0.23333334922790527, 0.33333343267440796, 0.20000001788139343, 0.25000008940696716, 0.20000001788139343, 0.25000008940696716, 0.1666666865348816, 0.25000008940696716, 0.1666666865348816, 0.33333343267440796, 0.1666666865348816, 0.33333343267440796, 0.20000001788139343, 0.33333343267440796, 0.1666666865348816, 0.25000008940696716, 0.1666666865348816, 0.25000008940696716, 0.13333335518836975, 0.25000008940696716, 0.13333335518836975, 0.33333343267440796, 0.13333335518836975, 0.33333343267440796, 0.1666666865348816, 0.33333343267440796, 0.13333335518836975, 0.25000008940696716, 0.13333335518836975, 0.25000008940696716, 0.10000002384185791, 0.25000008940696716, 0.10000002384185791, 0.33333343267440796, 0.10000002384185791, 0.33333343267440796, 0.13333335518836975, 0.33333343267440796, 0.10000002384185791, 0.25000008940696716, 0.10000002384185791, 0.25000008940696716, 0.06666669249534607, 0.25000008940696716, 0.06666669249534607, 0.33333343267440796, 0.06666669249534607, 0.33333343267440796, 0.10000002384185791, 0.33333343267440796, 0.06666669249534607, 0.25000008940696716, 0.06666669249534607, 0.25000008940696716, 0.03333335742354393, 0.25000008940696716, 0.03333335742354393, 0.33333343267440796, 0.03333335742354393, 0.33333343267440796, 0.06666669249534607, 0.33333343267440796, 0.03333335742354393, 0.25000008940696716, 0.03333335742354393, 0.25000008940696716, 2.2351741790771484e-8, 0.25000008940696716, 2.2351741790771484e-8, 0.33333343267440796, 2.2351741790771484e-8, 0.33333343267440796, 0.03333335742354393, 0.25000008940696716, 0.4000000059604645, 0.16666674613952637, 0.4000000059604645, 0.16666674613952637, 0.36666667461395263, 0.16666674613952637, 0.36666667461395263, 0.25000008940696716, 0.36666667461395263, 0.25000008940696716, 0.4000000059604645, 0.25000008940696716, 0.36666667461395263, 0.16666674613952637, 0.36666667461395263, 0.16666674613952637, 0.3333333432674408, 0.16666674613952637, 0.3333333432674408, 0.25000008940696716, 0.3333333432674408, 0.25000008940696716, 0.36666667461395263, 0.25000008940696716, 0.3333333432674408, 0.16666674613952637, 0.3333333432674408, 0.16666674613952637, 0.30000001192092895, 0.16666674613952637, 0.30000001192092895, 0.25000008940696716, 0.30000001192092895, 0.25000008940696716, 0.3333333432674408, 0.25000008940696716, 0.30000001192092895, 0.16666674613952637, 0.30000001192092895, 0.16666674613952637, 0.2666666805744171, 0.16666674613952637, 0.2666666805744171, 0.25000008940696716, 0.2666666805744171, 0.25000008940696716, 0.30000001192092895, 0.25000008940696716, 0.2666666805744171, 0.16666674613952637, 0.2666666805744171, 0.16666674613952637, 0.23333334922790527, 0.16666674613952637, 0.23333334922790527, 0.25000008940696716, 0.23333334922790527, 0.25000008940696716, 0.2666666805744171, 0.25000008940696716, 0.23333334922790527, 0.16666674613952637, 0.23333334922790527, 0.16666674613952637, 0.20000001788139343, 0.16666674613952637, 0.20000001788139343, 0.25000008940696716, 0.20000001788139343, 0.25000008940696716, 0.23333334922790527, 0.25000008940696716, 0.20000001788139343, 0.16666674613952637, 0.20000001788139343, 0.16666674613952637, 0.1666666865348816, 0.16666674613952637, 0.1666666865348816, 0.25000008940696716, 0.1666666865348816, 0.25000008940696716, 0.20000001788139343, 0.25000008940696716, 0.1666666865348816, 0.16666674613952637, 0.1666666865348816, 0.16666674613952637, 0.13333335518836975, 0.16666674613952637, 0.13333335518836975, 0.25000008940696716, 0.13333335518836975, 0.25000008940696716, 0.1666666865348816, 0.25000008940696716, 0.13333335518836975, 0.16666674613952637, 0.13333335518836975, 0.16666674613952637, 0.10000002384185791, 0.16666674613952637, 0.10000002384185791, 0.25000008940696716, 0.10000002384185791, 0.25000008940696716, 0.13333335518836975, 0.25000008940696716, 0.10000002384185791, 0.16666674613952637, 0.10000002384185791, 0.16666674613952637, 0.06666669249534607, 0.16666674613952637, 0.06666669249534607, 0.25000008940696716, 0.06666669249534607, 0.25000008940696716, 0.10000002384185791, 0.25000008940696716, 0.06666669249534607, 0.16666674613952637, 0.06666669249534607, 0.16666674613952637, 0.03333335742354393, 0.16666674613952637, 0.03333335742354393, 0.25000008940696716, 0.03333335742354393, 0.25000008940696716, 0.06666669249534607, 0.25000008940696716, 0.03333335742354393, 0.16666674613952637, 0.03333335742354393, 0.16666674613952637, 2.2351741790771484e-8, 0.16666674613952637, 2.2351741790771484e-8, 0.25000008940696716, 2.2351741790771484e-8, 0.25000008940696716, 0.03333335742354393, 0.16666674613952637, 0.4000000059604645, 0.08333341032266617, 0.4000000059604645, 0.08333341032266617, 0.36666667461395263, 0.08333341032266617, 0.36666667461395263, 0.16666674613952637, 0.36666667461395263, 0.16666674613952637, 0.4000000059604645, 0.16666674613952637, 0.36666667461395263, 0.08333341032266617, 0.36666667461395263, 0.08333341032266617, 0.3333333432674408, 0.08333341032266617, 0.3333333432674408, 0.16666674613952637, 0.3333333432674408, 0.16666674613952637, 0.36666667461395263, 0.16666674613952637, 0.3333333432674408, 0.08333341032266617, 0.3333333432674408, 0.08333341032266617, 0.30000001192092895, 0.08333341032266617, 0.30000001192092895, 0.16666674613952637, 0.30000001192092895, 0.16666674613952637, 0.3333333432674408, 0.16666674613952637, 0.30000001192092895, 0.08333341032266617, 0.30000001192092895, 0.08333341032266617, 0.2666666805744171, 0.08333341032266617, 0.2666666805744171, 0.16666674613952637, 0.2666666805744171, 0.16666674613952637, 0.30000001192092895, 0.16666674613952637, 0.2666666805744171, 0.08333341032266617, 0.2666666805744171, 0.08333341032266617, 0.23333334922790527, 0.08333341032266617, 0.23333334922790527, 0.16666674613952637, 0.23333334922790527, 0.16666674613952637, 0.2666666805744171, 0.16666674613952637, 0.23333334922790527, 0.08333341032266617, 0.23333334922790527, 0.08333341032266617, 0.20000001788139343, 0.08333341032266617, 0.20000001788139343, 0.16666674613952637, 0.20000001788139343, 0.16666674613952637, 0.23333334922790527, 0.16666674613952637, 0.20000001788139343, 0.08333341032266617, 0.20000001788139343, 0.08333341032266617, 0.1666666865348816, 0.08333341032266617, 0.1666666865348816, 0.16666674613952637, 0.1666666865348816, 0.16666674613952637, 0.20000001788139343, 0.16666674613952637, 0.1666666865348816, 0.08333341032266617, 0.1666666865348816, 0.08333341032266617, 0.13333335518836975, 0.08333341032266617, 0.13333335518836975, 0.16666674613952637, 0.13333335518836975, 0.16666674613952637, 0.1666666865348816, 0.16666674613952637, 0.13333335518836975, 0.08333341032266617, 0.13333335518836975, 0.08333341032266617, 0.10000002384185791, 0.08333341032266617, 0.10000002384185791, 0.16666674613952637, 0.10000002384185791, 0.16666674613952637, 0.13333335518836975, 0.16666674613952637, 0.10000002384185791, 0.08333341032266617, 0.10000002384185791, 0.08333341032266617, 0.06666669249534607, 0.08333341032266617, 0.06666669249534607, 0.16666674613952637, 0.06666669249534607, 0.16666674613952637, 0.10000002384185791, 0.16666674613952637, 0.06666669249534607, 0.08333341032266617, 0.06666669249534607, 0.08333341032266617, 0.03333335742354393, 0.08333341032266617, 0.03333335742354393, 0.16666674613952637, 0.03333335742354393, 0.16666674613952637, 0.06666669249534607, 0.16666674613952637, 0.03333335742354393, 0.08333341032266617, 0.03333335742354393, 0.08333341032266617, 2.2351741790771484e-8, 0.08333341032266617, 2.2351741790771484e-8, 0.16666674613952637, 2.2351741790771484e-8, 0.16666674613952637, 0.03333335742354393, 0.08333341032266617, 0.4000000059604645, 7.450580596923828e-8, 0.4000000059604645, 7.450580596923828e-8, 0.36666667461395263, 7.450580596923828e-8, 0.36666667461395263, 0.08333341032266617, 0.36666667461395263, 0.08333341032266617, 0.4000000059604645, 0.08333341032266617, 0.36666667461395263, 7.450580596923828e-8, 0.36666667461395263, 7.450580596923828e-8, 0.3333333432674408, 7.450580596923828e-8, 0.3333333432674408, 0.08333341032266617, 0.3333333432674408, 0.08333341032266617, 0.36666667461395263, 0.08333341032266617, 0.3333333432674408, 7.450580596923828e-8, 0.3333333432674408, 7.450580596923828e-8, 0.30000001192092895, 7.450580596923828e-8, 0.30000001192092895, 0.08333341032266617, 0.30000001192092895, 0.08333341032266617, 0.3333333432674408, 0.08333341032266617, 0.30000001192092895, 7.450580596923828e-8, 0.30000001192092895, 7.450580596923828e-8, 0.2666666805744171, 7.450580596923828e-8, 0.2666666805744171, 0.08333341032266617, 0.2666666805744171, 0.08333341032266617, 0.30000001192092895, 0.08333341032266617, 0.2666666805744171, 7.450580596923828e-8, 0.2666666805744171, 7.450580596923828e-8, 0.23333334922790527, 7.450580596923828e-8, 0.23333334922790527, 0.08333341032266617, 0.23333334922790527, 0.08333341032266617, 0.2666666805744171, 0.08333341032266617, 0.23333334922790527, 7.450580596923828e-8, 0.23333334922790527, 7.450580596923828e-8, 0.20000001788139343, 7.450580596923828e-8, 0.20000001788139343, 0.08333341032266617, 0.20000001788139343, 0.08333341032266617, 0.23333334922790527, 0.08333341032266617, 0.20000001788139343, 7.450580596923828e-8, 0.20000001788139343, 7.450580596923828e-8, 0.1666666865348816, 7.450580596923828e-8, 0.1666666865348816, 0.08333341032266617, 0.1666666865348816, 0.08333341032266617, 0.20000001788139343, 0.08333341032266617, 0.1666666865348816, 7.450580596923828e-8, 0.1666666865348816, 7.450580596923828e-8, 0.13333335518836975, 7.450580596923828e-8, 0.13333335518836975, 0.08333341032266617, 0.13333335518836975, 0.08333341032266617, 0.1666666865348816, 0.08333341032266617, 0.13333335518836975, 7.450580596923828e-8, 0.13333335518836975, 7.450580596923828e-8, 0.10000002384185791, 7.450580596923828e-8, 0.10000002384185791, 0.08333341032266617, 0.10000002384185791, 0.08333341032266617, 0.13333335518836975, 0.08333341032266617, 0.10000002384185791, 7.450580596923828e-8, 0.10000002384185791, 7.450580596923828e-8, 0.06666669249534607, 7.450580596923828e-8, 0.06666669249534607, 0.08333341032266617, 0.06666669249534607, 0.08333341032266617, 0.10000002384185791, 0.08333341032266617, 0.06666669249534607, 7.450580596923828e-8, 0.06666669249534607, 7.450580596923828e-8, 0.03333335742354393, 7.450580596923828e-8, 0.03333335742354393, 0.08333341032266617, 0.03333335742354393, 0.08333341032266617, 0.06666669249534607, 0.08333341032266617, 0.03333335742354393, 7.450580596923828e-8, 0.03333335742354393, 7.450580596923828e-8, 2.2351741790771484e-8, 7.450580596923828e-8, 2.2351741790771484e-8, 0.08333341032266617, 2.2351741790771484e-8, 0.08333341032266617, 0.03333335742354393, 2, 0.4000000059604645, 1.9166666269302368, 0.4000000059604645, 1.9166666269302368, 0.36666667461395263, 1.9166666269302368, 0.36666667461395263, 2, 0.36666667461395263, 2, 0.4000000059604645, 2, 0.36666667461395263, 1.9166666269302368, 0.36666667461395263, 1.9166666269302368, 0.3333333432674408, 1.9166666269302368, 0.3333333432674408, 2, 0.3333333432674408, 2, 0.36666667461395263, 2, 0.3333333432674408, 1.9166666269302368, 0.3333333432674408, 1.9166666269302368, 0.30000001192092895, 1.9166666269302368, 0.30000001192092895, 2, 0.30000001192092895, 2, 0.3333333432674408, 2, 0.30000001192092895, 1.9166666269302368, 0.30000001192092895, 1.9166666269302368, 0.2666666805744171, 1.9166666269302368, 0.2666666805744171, 2, 0.2666666805744171, 2, 0.30000001192092895, 2, 0.2666666805744171, 1.9166666269302368, 0.2666666805744171, 1.9166666269302368, 0.23333334922790527, 1.9166666269302368, 0.23333334922790527, 2, 0.23333334922790527, 2, 0.2666666805744171, 2, 0.23333334922790527, 1.9166666269302368, 0.23333334922790527, 1.9166666269302368, 0.20000001788139343, 1.9166666269302368, 0.20000001788139343, 2, 0.20000001788139343, 2, 0.23333334922790527, 2, 0.20000001788139343, 1.9166666269302368, 0.20000001788139343, 1.9166666269302368, 0.1666666865348816, 1.9166666269302368, 0.1666666865348816, 2, 0.1666666865348816, 2, 0.20000001788139343, 2, 0.1666666865348816, 1.9166666269302368, 0.1666666865348816, 1.9166666269302368, 0.13333335518836975, 1.9166666269302368, 0.13333335518836975, 2, 0.13333335518836975, 2, 0.1666666865348816, 2, 0.13333335518836975, 1.9166666269302368, 0.13333335518836975, 1.9166666269302368, 0.10000002384185791, 1.9166666269302368, 0.10000002384185791, 2, 0.10000002384185791, 2, 0.13333335518836975, 2, 0.10000002384185791, 1.9166666269302368, 0.10000002384185791, 1.9166666269302368, 0.06666669249534607, 1.9166666269302368, 0.06666669249534607, 2, 0.06666669249534607, 2, 0.10000002384185791, 2, 0.06666669249534607, 1.9166666269302368, 0.06666669249534607, 1.9166666269302368, 0.03333335742354393, 1.9166666269302368, 0.03333335742354393, 2, 0.03333335742354393, 2, 0.06666669249534607, 2, 0.03333335742354393, 1.9166666269302368, 0.03333335742354393, 1.9166666269302368, 2.2351741790771484e-8, 1.9166666269302368, 2.2351741790771484e-8, 2, 2.2351741790771484e-8, 2, 0.03333335742354393, 1.9166666269302368, 0.4000000059604645, 1.8333332538604736, 0.4000000059604645, 1.8333332538604736, 0.36666667461395263, 1.8333332538604736, 0.36666667461395263, 1.9166666269302368, 0.36666667461395263, 1.9166666269302368, 0.4000000059604645, 1.9166666269302368, 0.36666667461395263, 1.8333332538604736, 0.36666667461395263, 1.8333332538604736, 0.3333333432674408, 1.8333332538604736, 0.3333333432674408, 1.9166666269302368, 0.3333333432674408, 1.9166666269302368, 0.36666667461395263, 1.9166666269302368, 0.3333333432674408, 1.8333332538604736, 0.3333333432674408, 1.8333332538604736, 0.30000001192092895, 1.8333332538604736, 0.30000001192092895, 1.9166666269302368, 0.30000001192092895, 1.9166666269302368, 0.3333333432674408, 1.9166666269302368, 0.30000001192092895, 1.8333332538604736, 0.30000001192092895, 1.8333332538604736, 0.2666666805744171, 1.8333332538604736, 0.2666666805744171, 1.9166666269302368, 0.2666666805744171, 1.9166666269302368, 0.30000001192092895, 1.9166666269302368, 0.2666666805744171, 1.8333332538604736, 0.2666666805744171, 1.8333332538604736, 0.23333334922790527, 1.8333332538604736, 0.23333334922790527, 1.9166666269302368, 0.23333334922790527, 1.9166666269302368, 0.2666666805744171, 1.9166666269302368, 0.23333334922790527, 1.8333332538604736, 0.23333334922790527, 1.8333332538604736, 0.20000001788139343, 1.8333332538604736, 0.20000001788139343, 1.9166666269302368, 0.20000001788139343, 1.9166666269302368, 0.23333334922790527, 1.9166666269302368, 0.20000001788139343, 1.8333332538604736, 0.20000001788139343, 1.8333332538604736, 0.1666666865348816, 1.8333332538604736, 0.1666666865348816, 1.9166666269302368, 0.1666666865348816, 1.9166666269302368, 0.20000001788139343, 1.9166666269302368, 0.1666666865348816, 1.8333332538604736, 0.1666666865348816, 1.8333332538604736, 0.13333335518836975, 1.8333332538604736, 0.13333335518836975, 1.9166666269302368, 0.13333335518836975, 1.9166666269302368, 0.1666666865348816, 1.9166666269302368, 0.13333335518836975, 1.8333332538604736, 0.13333335518836975, 1.8333332538604736, 0.10000002384185791, 1.8333332538604736, 0.10000002384185791, 1.9166666269302368, 0.10000002384185791, 1.9166666269302368, 0.13333335518836975, 1.9166666269302368, 0.10000002384185791, 1.8333332538604736, 0.10000002384185791, 1.8333332538604736, 0.06666669249534607, 1.8333332538604736, 0.06666669249534607, 1.9166666269302368, 0.06666669249534607, 1.9166666269302368, 0.10000002384185791, 1.9166666269302368, 0.06666669249534607, 1.8333332538604736, 0.06666669249534607, 1.8333332538604736, 0.03333335742354393, 1.8333332538604736, 0.03333335742354393, 1.9166666269302368, 0.03333335742354393, 1.9166666269302368, 0.06666669249534607, 1.9166666269302368, 0.03333335742354393, 1.8333332538604736, 0.03333335742354393, 1.8333332538604736, 2.2351741790771484e-8, 1.8333332538604736, 2.2351741790771484e-8, 1.9166666269302368, 2.2351741790771484e-8, 1.9166666269302368, 0.03333335742354393, 1.8333332538604736, 0.4000000059604645, 1.7499998807907104, 0.4000000059604645, 1.7499998807907104, 0.36666667461395263, 1.7499998807907104, 0.36666667461395263, 1.8333332538604736, 0.36666667461395263, 1.8333332538604736, 0.4000000059604645, 1.8333332538604736, 0.36666667461395263, 1.7499998807907104, 0.36666667461395263, 1.7499998807907104, 0.3333333432674408, 1.7499998807907104, 0.3333333432674408, 1.8333332538604736, 0.3333333432674408, 1.8333332538604736, 0.36666667461395263, 1.8333332538604736, 0.3333333432674408, 1.7499998807907104, 0.3333333432674408, 1.7499998807907104, 0.30000001192092895, 1.7499998807907104, 0.30000001192092895, 1.8333332538604736, 0.30000001192092895, 1.8333332538604736, 0.3333333432674408, 1.8333332538604736, 0.30000001192092895, 1.7499998807907104, 0.30000001192092895, 1.7499998807907104, 0.2666666805744171, 1.7499998807907104, 0.2666666805744171, 1.8333332538604736, 0.2666666805744171, 1.8333332538604736, 0.30000001192092895, 1.8333332538604736, 0.2666666805744171, 1.7499998807907104, 0.2666666805744171, 1.7499998807907104, 0.23333334922790527, 1.7499998807907104, 0.23333334922790527, 1.8333332538604736, 0.23333334922790527, 1.8333332538604736, 0.2666666805744171, 1.8333332538604736, 0.23333334922790527, 1.7499998807907104, 0.23333334922790527, 1.7499998807907104, 0.20000001788139343, 1.7499998807907104, 0.20000001788139343, 1.8333332538604736, 0.20000001788139343, 1.8333332538604736, 0.23333334922790527, 1.8333332538604736, 0.20000001788139343, 1.7499998807907104, 0.20000001788139343, 1.7499998807907104, 0.1666666865348816, 1.7499998807907104, 0.1666666865348816, 1.8333332538604736, 0.1666666865348816, 1.8333332538604736, 0.20000001788139343, 1.8333332538604736, 0.1666666865348816, 1.7499998807907104, 0.1666666865348816, 1.7499998807907104, 0.13333335518836975, 1.7499998807907104, 0.13333335518836975, 1.8333332538604736, 0.13333335518836975, 1.8333332538604736, 0.1666666865348816, 1.8333332538604736, 0.13333335518836975, 1.7499998807907104, 0.13333335518836975, 1.7499998807907104, 0.10000002384185791, 1.7499998807907104, 0.10000002384185791, 1.8333332538604736, 0.10000002384185791, 1.8333332538604736, 0.13333335518836975, 1.8333332538604736, 0.10000002384185791, 1.7499998807907104, 0.10000002384185791, 1.7499998807907104, 0.06666669249534607, 1.7499998807907104, 0.06666669249534607, 1.8333332538604736, 0.06666669249534607, 1.8333332538604736, 0.10000002384185791, 1.8333332538604736, 0.06666669249534607, 1.7499998807907104, 0.06666669249534607, 1.7499998807907104, 0.03333335742354393, 1.7499998807907104, 0.03333335742354393, 1.8333332538604736, 0.03333335742354393, 1.8333332538604736, 0.06666669249534607, 1.8333332538604736, 0.03333335742354393, 1.7499998807907104, 0.03333335742354393, 1.7499998807907104, 2.2351741790771484e-8, 1.7499998807907104, 2.2351741790771484e-8, 1.8333332538604736, 2.2351741790771484e-8, 1.8333332538604736, 0.03333335742354393, 1.7499998807907104, 0.4000000059604645, 1.6666665077209472, 0.4000000059604645, 1.6666665077209472, 0.36666667461395263, 1.6666665077209472, 0.36666667461395263, 1.7499998807907104, 0.36666667461395263, 1.7499998807907104, 0.4000000059604645, 1.7499998807907104, 0.36666667461395263, 1.6666665077209472, 0.36666667461395263, 1.6666665077209472, 0.3333333432674408, 1.6666665077209472, 0.3333333432674408, 1.7499998807907104, 0.3333333432674408, 1.7499998807907104, 0.36666667461395263, 1.7499998807907104, 0.3333333432674408, 1.6666665077209472, 0.3333333432674408, 1.6666665077209472, 0.30000001192092895, 1.6666665077209472, 0.30000001192092895, 1.7499998807907104, 0.30000001192092895, 1.7499998807907104, 0.3333333432674408, 1.7499998807907104, 0.30000001192092895, 1.6666665077209472, 0.30000001192092895, 1.6666665077209472, 0.2666666805744171, 1.6666665077209472, 0.2666666805744171, 1.7499998807907104, 0.2666666805744171, 1.7499998807907104, 0.30000001192092895, 1.7499998807907104, 0.2666666805744171, 1.6666665077209472, 0.2666666805744171, 1.6666665077209472, 0.23333334922790527, 1.6666665077209472, 0.23333334922790527, 1.7499998807907104, 0.23333334922790527, 1.7499998807907104, 0.2666666805744171, 1.7499998807907104, 0.23333334922790527, 1.6666665077209472, 0.23333334922790527, 1.6666665077209472, 0.20000001788139343, 1.6666665077209472, 0.20000001788139343, 1.7499998807907104, 0.20000001788139343, 1.7499998807907104, 0.23333334922790527, 1.7499998807907104, 0.20000001788139343, 1.6666665077209472, 0.20000001788139343, 1.6666665077209472, 0.1666666865348816, 1.6666665077209472, 0.1666666865348816, 1.7499998807907104, 0.1666666865348816, 1.7499998807907104, 0.20000001788139343, 1.7499998807907104, 0.1666666865348816, 1.6666665077209472, 0.1666666865348816, 1.6666665077209472, 0.13333335518836975, 1.6666665077209472, 0.13333335518836975, 1.7499998807907104, 0.13333335518836975, 1.7499998807907104, 0.1666666865348816, 1.7499998807907104, 0.13333335518836975, 1.6666665077209472, 0.13333335518836975, 1.6666665077209472, 0.10000002384185791, 1.6666665077209472, 0.10000002384185791, 1.7499998807907104, 0.10000002384185791, 1.7499998807907104, 0.13333335518836975, 1.7499998807907104, 0.10000002384185791, 1.6666665077209472, 0.10000002384185791, 1.6666665077209472, 0.06666669249534607, 1.6666665077209472, 0.06666669249534607, 1.7499998807907104, 0.06666669249534607, 1.7499998807907104, 0.10000002384185791, 1.7499998807907104, 0.06666669249534607, 1.6666665077209472, 0.06666669249534607, 1.6666665077209472, 0.03333335742354393, 1.6666665077209472, 0.03333335742354393, 1.7499998807907104, 0.03333335742354393, 1.7499998807907104, 0.06666669249534607, 1.7499998807907104, 0.03333335742354393, 1.6666665077209472, 0.03333335742354393, 1.6666665077209472, 2.2351741790771484e-8, 1.6666665077209472, 2.2351741790771484e-8, 1.7499998807907104, 2.2351741790771484e-8, 1.7499998807907104, 0.03333335742354393, 1.6666665077209472, 0.4000000059604645, 1.583333134651184, 0.4000000059604645, 1.583333134651184, 0.36666667461395263, 1.583333134651184, 0.36666667461395263, 1.6666665077209472, 0.36666667461395263, 1.6666665077209472, 0.4000000059604645, 1.6666665077209472, 0.36666667461395263, 1.583333134651184, 0.36666667461395263, 1.583333134651184, 0.3333333432674408, 1.583333134651184, 0.3333333432674408, 1.6666665077209472, 0.3333333432674408, 1.6666665077209472, 0.36666667461395263, 1.6666665077209472, 0.3333333432674408, 1.583333134651184, 0.3333333432674408, 1.583333134651184, 0.30000001192092895, 1.583333134651184, 0.30000001192092895, 1.6666665077209472, 0.30000001192092895, 1.6666665077209472, 0.3333333432674408, 1.6666665077209472, 0.30000001192092895, 1.583333134651184, 0.30000001192092895, 1.583333134651184, 0.2666666805744171, 1.583333134651184, 0.2666666805744171, 1.6666665077209472, 0.2666666805744171, 1.6666665077209472, 0.30000001192092895, 1.6666665077209472, 0.2666666805744171, 1.583333134651184, 0.2666666805744171, 1.583333134651184, 0.23333334922790527, 1.583333134651184, 0.23333334922790527, 1.6666665077209472, 0.23333334922790527, 1.6666665077209472, 0.2666666805744171, 1.6666665077209472, 0.23333334922790527, 1.583333134651184, 0.23333334922790527, 1.583333134651184, 0.20000001788139343, 1.583333134651184, 0.20000001788139343, 1.6666665077209472, 0.20000001788139343, 1.6666665077209472, 0.23333334922790527, 1.6666665077209472, 0.20000001788139343, 1.583333134651184, 0.20000001788139343, 1.583333134651184, 0.1666666865348816, 1.583333134651184, 0.1666666865348816, 1.6666665077209472, 0.1666666865348816, 1.6666665077209472, 0.20000001788139343, 1.6666665077209472, 0.1666666865348816, 1.583333134651184, 0.1666666865348816, 1.583333134651184, 0.13333335518836975, 1.583333134651184, 0.13333335518836975, 1.6666665077209472, 0.13333335518836975, 1.6666665077209472, 0.1666666865348816, 1.6666665077209472, 0.13333335518836975, 1.583333134651184, 0.13333335518836975, 1.583333134651184, 0.10000002384185791, 1.583333134651184, 0.10000002384185791, 1.6666665077209472, 0.10000002384185791, 1.6666665077209472, 0.13333335518836975, 1.6666665077209472, 0.10000002384185791, 1.583333134651184, 0.10000002384185791, 1.583333134651184, 0.06666669249534607, 1.583333134651184, 0.06666669249534607, 1.6666665077209472, 0.06666669249534607, 1.6666665077209472, 0.10000002384185791, 1.6666665077209472, 0.06666669249534607, 1.583333134651184, 0.06666669249534607, 1.583333134651184, 0.03333335742354393, 1.583333134651184, 0.03333335742354393, 1.6666665077209472, 0.03333335742354393, 1.6666665077209472, 0.06666669249534607, 1.6666665077209472, 0.03333335742354393, 1.583333134651184, 0.03333335742354393, 1.583333134651184, 2.2351741790771484e-8, 1.583333134651184, 2.2351741790771484e-8, 1.6666665077209472, 2.2351741790771484e-8, 1.6666665077209472, 0.03333335742354393, 1.583333134651184, 0.4000000059604645, 1.499999761581421, 0.4000000059604645, 1.499999761581421, 0.36666667461395263, 1.499999761581421, 0.36666667461395263, 1.583333134651184, 0.36666667461395263, 1.583333134651184, 0.4000000059604645, 1.583333134651184, 0.36666667461395263, 1.499999761581421, 0.36666667461395263, 1.499999761581421, 0.3333333432674408, 1.499999761581421, 0.3333333432674408, 1.583333134651184, 0.3333333432674408, 1.583333134651184, 0.36666667461395263, 1.583333134651184, 0.3333333432674408, 1.499999761581421, 0.3333333432674408, 1.499999761581421, 0.30000001192092895, 1.499999761581421, 0.30000001192092895, 1.583333134651184, 0.30000001192092895, 1.583333134651184, 0.3333333432674408, 1.583333134651184, 0.30000001192092895, 1.499999761581421, 0.30000001192092895, 1.499999761581421, 0.2666666805744171, 1.499999761581421, 0.2666666805744171, 1.583333134651184, 0.2666666805744171, 1.583333134651184, 0.30000001192092895, 1.583333134651184, 0.2666666805744171, 1.499999761581421, 0.2666666805744171, 1.499999761581421, 0.23333334922790527, 1.499999761581421, 0.23333334922790527, 1.583333134651184, 0.23333334922790527, 1.583333134651184, 0.2666666805744171, 1.583333134651184, 0.23333334922790527, 1.499999761581421, 0.23333334922790527, 1.499999761581421, 0.20000001788139343, 1.499999761581421, 0.20000001788139343, 1.583333134651184, 0.20000001788139343, 1.583333134651184, 0.23333334922790527, 1.583333134651184, 0.20000001788139343, 1.499999761581421, 0.20000001788139343, 1.499999761581421, 0.1666666865348816, 1.499999761581421, 0.1666666865348816, 1.583333134651184, 0.1666666865348816, 1.583333134651184, 0.20000001788139343, 1.583333134651184, 0.1666666865348816, 1.499999761581421, 0.1666666865348816, 1.499999761581421, 0.13333335518836975, 1.499999761581421, 0.13333335518836975, 1.583333134651184, 0.13333335518836975, 1.583333134651184, 0.1666666865348816, 1.583333134651184, 0.13333335518836975, 1.499999761581421, 0.13333335518836975, 1.499999761581421, 0.10000002384185791, 1.499999761581421, 0.10000002384185791, 1.583333134651184, 0.10000002384185791, 1.583333134651184, 0.13333335518836975, 1.583333134651184, 0.10000002384185791, 1.499999761581421, 0.10000002384185791, 1.499999761581421, 0.06666669249534607, 1.499999761581421, 0.06666669249534607, 1.583333134651184, 0.06666669249534607, 1.583333134651184, 0.10000002384185791, 1.583333134651184, 0.06666669249534607, 1.499999761581421, 0.06666669249534607, 1.499999761581421, 0.03333335742354393, 1.499999761581421, 0.03333335742354393, 1.583333134651184, 0.03333335742354393, 1.583333134651184, 0.06666669249534607, 1.583333134651184, 0.03333335742354393, 1.499999761581421, 0.03333335742354393, 1.499999761581421, 2.2351741790771484e-8, 1.499999761581421, 2.2351741790771484e-8, 1.583333134651184, 2.2351741790771484e-8, 1.583333134651184, 0.03333335742354393, 1.499999761581421, 0.4000000059604645, 1.4166663885116577, 0.4000000059604645, 1.4166663885116577, 0.36666667461395263, 1.4166663885116577, 0.36666667461395263, 1.499999761581421, 0.36666667461395263, 1.499999761581421, 0.4000000059604645, 1.499999761581421, 0.36666667461395263, 1.4166663885116577, 0.36666667461395263, 1.4166663885116577, 0.3333333432674408, 1.4166663885116577, 0.3333333432674408, 1.499999761581421, 0.3333333432674408, 1.499999761581421, 0.36666667461395263, 1.499999761581421, 0.3333333432674408, 1.4166663885116577, 0.3333333432674408, 1.4166663885116577, 0.30000001192092895, 1.4166663885116577, 0.30000001192092895, 1.499999761581421, 0.30000001192092895, 1.499999761581421, 0.3333333432674408, 1.499999761581421, 0.30000001192092895, 1.4166663885116577, 0.30000001192092895, 1.4166663885116577, 0.2666666805744171, 1.4166663885116577, 0.2666666805744171, 1.499999761581421, 0.2666666805744171, 1.499999761581421, 0.30000001192092895, 1.499999761581421, 0.2666666805744171, 1.4166663885116577, 0.2666666805744171, 1.4166663885116577, 0.23333334922790527, 1.4166663885116577, 0.23333334922790527, 1.499999761581421, 0.23333334922790527, 1.499999761581421, 0.2666666805744171, 1.499999761581421, 0.23333334922790527, 1.4166663885116577, 0.23333334922790527, 1.4166663885116577, 0.20000001788139343, 1.4166663885116577, 0.20000001788139343, 1.499999761581421, 0.20000001788139343, 1.499999761581421, 0.23333334922790527, 1.499999761581421, 0.20000001788139343, 1.4166663885116577, 0.20000001788139343, 1.4166663885116577, 0.1666666865348816, 1.4166663885116577, 0.1666666865348816, 1.499999761581421, 0.1666666865348816, 1.499999761581421, 0.20000001788139343, 1.499999761581421, 0.1666666865348816, 1.4166663885116577, 0.1666666865348816, 1.4166663885116577, 0.13333335518836975, 1.4166663885116577, 0.13333335518836975, 1.499999761581421, 0.13333335518836975, 1.499999761581421, 0.1666666865348816, 1.499999761581421, 0.13333335518836975, 1.4166663885116577, 0.13333335518836975, 1.4166663885116577, 0.10000002384185791, 1.4166663885116577, 0.10000002384185791, 1.499999761581421, 0.10000002384185791, 1.499999761581421, 0.13333335518836975, 1.499999761581421, 0.10000002384185791, 1.4166663885116577, 0.10000002384185791, 1.4166663885116577, 0.06666669249534607, 1.4166663885116577, 0.06666669249534607, 1.499999761581421, 0.06666669249534607, 1.499999761581421, 0.10000002384185791, 1.499999761581421, 0.06666669249534607, 1.4166663885116577, 0.06666669249534607, 1.4166663885116577, 0.03333335742354393, 1.4166663885116577, 0.03333335742354393, 1.499999761581421, 0.03333335742354393, 1.499999761581421, 0.06666669249534607, 1.499999761581421, 0.03333335742354393, 1.4166663885116577, 0.03333335742354393, 1.4166663885116577, 2.2351741790771484e-8, 1.4166663885116577, 2.2351741790771484e-8, 1.499999761581421, 2.2351741790771484e-8, 1.499999761581421, 0.03333335742354393, 1.4166663885116577, 0.4000000059604645, 1.3333330154418945, 0.4000000059604645, 1.3333330154418945, 0.36666667461395263, 1.3333330154418945, 0.36666667461395263, 1.4166663885116577, 0.36666667461395263, 1.4166663885116577, 0.4000000059604645, 1.4166663885116577, 0.36666667461395263, 1.3333330154418945, 0.36666667461395263, 1.3333330154418945, 0.3333333432674408, 1.3333330154418945, 0.3333333432674408, 1.4166663885116577, 0.3333333432674408, 1.4166663885116577, 0.36666667461395263, 1.4166663885116577, 0.3333333432674408, 1.3333330154418945, 0.3333333432674408, 1.3333330154418945, 0.30000001192092895, 1.3333330154418945, 0.30000001192092895, 1.4166663885116577, 0.30000001192092895, 1.4166663885116577, 0.3333333432674408, 1.4166663885116577, 0.30000001192092895, 1.3333330154418945, 0.30000001192092895, 1.3333330154418945, 0.2666666805744171, 1.3333330154418945, 0.2666666805744171, 1.4166663885116577, 0.2666666805744171, 1.4166663885116577, 0.30000001192092895, 1.4166663885116577, 0.2666666805744171, 1.3333330154418945, 0.2666666805744171, 1.3333330154418945, 0.23333334922790527, 1.3333330154418945, 0.23333334922790527, 1.4166663885116577, 0.23333334922790527, 1.4166663885116577, 0.2666666805744171, 1.4166663885116577, 0.23333334922790527, 1.3333330154418945, 0.23333334922790527, 1.3333330154418945, 0.20000001788139343, 1.3333330154418945, 0.20000001788139343, 1.4166663885116577, 0.20000001788139343, 1.4166663885116577, 0.23333334922790527, 1.4166663885116577, 0.20000001788139343, 1.3333330154418945, 0.20000001788139343, 1.3333330154418945, 0.1666666865348816, 1.3333330154418945, 0.1666666865348816, 1.4166663885116577, 0.1666666865348816, 1.4166663885116577, 0.20000001788139343, 1.4166663885116577, 0.1666666865348816, 1.3333330154418945, 0.1666666865348816, 1.3333330154418945, 0.13333335518836975, 1.3333330154418945, 0.13333335518836975, 1.4166663885116577, 0.13333335518836975, 1.4166663885116577, 0.1666666865348816, 1.4166663885116577, 0.13333335518836975, 1.3333330154418945, 0.13333335518836975, 1.3333330154418945, 0.10000002384185791, 1.3333330154418945, 0.10000002384185791, 1.4166663885116577, 0.10000002384185791, 1.4166663885116577, 0.13333335518836975, 1.4166663885116577, 0.10000002384185791, 1.3333330154418945, 0.10000002384185791, 1.3333330154418945, 0.06666669249534607, 1.3333330154418945, 0.06666669249534607, 1.4166663885116577, 0.06666669249534607, 1.4166663885116577, 0.10000002384185791, 1.4166663885116577, 0.06666669249534607, 1.3333330154418945, 0.06666669249534607, 1.3333330154418945, 0.03333335742354393, 1.3333330154418945, 0.03333335742354393, 1.4166663885116577, 0.03333335742354393, 1.4166663885116577, 0.06666669249534607, 1.4166663885116577, 0.03333335742354393, 1.3333330154418945, 0.03333335742354393, 1.3333330154418945, 2.2351741790771484e-8, 1.3333330154418945, 2.2351741790771484e-8, 1.4166663885116577, 2.2351741790771484e-8, 1.4166663885116577, 0.03333335742354393, 1.3333330154418945, 0.4000000059604645, 1.2499996423721313, 0.4000000059604645, 1.2499996423721313, 0.36666667461395263, 1.2499996423721313, 0.36666667461395263, 1.3333330154418945, 0.36666667461395263, 1.3333330154418945, 0.4000000059604645, 1.3333330154418945, 0.36666667461395263, 1.2499996423721313, 0.36666667461395263, 1.2499996423721313, 0.3333333432674408, 1.2499996423721313, 0.3333333432674408, 1.3333330154418945, 0.3333333432674408, 1.3333330154418945, 0.36666667461395263, 1.3333330154418945, 0.3333333432674408, 1.2499996423721313, 0.3333333432674408, 1.2499996423721313, 0.30000001192092895, 1.2499996423721313, 0.30000001192092895, 1.3333330154418945, 0.30000001192092895, 1.3333330154418945, 0.3333333432674408, 1.3333330154418945, 0.30000001192092895, 1.2499996423721313, 0.30000001192092895, 1.2499996423721313, 0.2666666805744171, 1.2499996423721313, 0.2666666805744171, 1.3333330154418945, 0.2666666805744171, 1.3333330154418945, 0.30000001192092895, 1.3333330154418945, 0.2666666805744171, 1.2499996423721313, 0.2666666805744171, 1.2499996423721313, 0.23333334922790527, 1.2499996423721313, 0.23333334922790527, 1.3333330154418945, 0.23333334922790527, 1.3333330154418945, 0.2666666805744171, 1.3333330154418945, 0.23333334922790527, 1.2499996423721313, 0.23333334922790527, 1.2499996423721313, 0.20000001788139343, 1.2499996423721313, 0.20000001788139343, 1.3333330154418945, 0.20000001788139343, 1.3333330154418945, 0.23333334922790527, 1.3333330154418945, 0.20000001788139343, 1.2499996423721313, 0.20000001788139343, 1.2499996423721313, 0.1666666865348816, 1.2499996423721313, 0.1666666865348816, 1.3333330154418945, 0.1666666865348816, 1.3333330154418945, 0.20000001788139343, 1.3333330154418945, 0.1666666865348816, 1.2499996423721313, 0.1666666865348816, 1.2499996423721313, 0.13333335518836975, 1.2499996423721313, 0.13333335518836975, 1.3333330154418945, 0.13333335518836975, 1.3333330154418945, 0.1666666865348816, 1.3333330154418945, 0.13333335518836975, 1.2499996423721313, 0.13333335518836975, 1.2499996423721313, 0.10000002384185791, 1.2499996423721313, 0.10000002384185791, 1.3333330154418945, 0.10000002384185791, 1.3333330154418945, 0.13333335518836975, 1.3333330154418945, 0.10000002384185791, 1.2499996423721313, 0.10000002384185791, 1.2499996423721313, 0.06666669249534607, 1.2499996423721313, 0.06666669249534607, 1.3333330154418945, 0.06666669249534607, 1.3333330154418945, 0.10000002384185791, 1.3333330154418945, 0.06666669249534607, 1.2499996423721313, 0.06666669249534607, 1.2499996423721313, 0.03333335742354393, 1.2499996423721313, 0.03333335742354393, 1.3333330154418945, 0.03333335742354393, 1.3333330154418945, 0.06666669249534607, 1.3333330154418945, 0.03333335742354393, 1.2499996423721313, 0.03333335742354393, 1.2499996423721313, 2.2351741790771484e-8, 1.2499996423721313, 2.2351741790771484e-8, 1.3333330154418945, 2.2351741790771484e-8, 1.3333330154418945, 0.03333335742354393, 1.2499996423721313, 0.4000000059604645, 1.1666662693023681, 0.4000000059604645, 1.1666662693023681, 0.36666667461395263, 1.1666662693023681, 0.36666667461395263, 1.2499996423721313, 0.36666667461395263, 1.2499996423721313, 0.4000000059604645, 1.2499996423721313, 0.36666667461395263, 1.1666662693023681, 0.36666667461395263, 1.1666662693023681, 0.3333333432674408, 1.1666662693023681, 0.3333333432674408, 1.2499996423721313, 0.3333333432674408, 1.2499996423721313, 0.36666667461395263, 1.2499996423721313, 0.3333333432674408, 1.1666662693023681, 0.3333333432674408, 1.1666662693023681, 0.30000001192092895, 1.1666662693023681, 0.30000001192092895, 1.2499996423721313, 0.30000001192092895, 1.2499996423721313, 0.3333333432674408, 1.2499996423721313, 0.30000001192092895, 1.1666662693023681, 0.30000001192092895, 1.1666662693023681, 0.2666666805744171, 1.1666662693023681, 0.2666666805744171, 1.2499996423721313, 0.2666666805744171, 1.2499996423721313, 0.30000001192092895, 1.2499996423721313, 0.2666666805744171, 1.1666662693023681, 0.2666666805744171, 1.1666662693023681, 0.23333334922790527, 1.1666662693023681, 0.23333334922790527, 1.2499996423721313, 0.23333334922790527, 1.2499996423721313, 0.2666666805744171, 1.2499996423721313, 0.23333334922790527, 1.1666662693023681, 0.23333334922790527, 1.1666662693023681, 0.20000001788139343, 1.1666662693023681, 0.20000001788139343, 1.2499996423721313, 0.20000001788139343, 1.2499996423721313, 0.23333334922790527, 1.2499996423721313, 0.20000001788139343, 1.1666662693023681, 0.20000001788139343, 1.1666662693023681, 0.1666666865348816, 1.1666662693023681, 0.1666666865348816, 1.2499996423721313, 0.1666666865348816, 1.2499996423721313, 0.20000001788139343, 1.2499996423721313, 0.1666666865348816, 1.1666662693023681, 0.1666666865348816, 1.1666662693023681, 0.13333335518836975, 1.1666662693023681, 0.13333335518836975, 1.2499996423721313, 0.13333335518836975, 1.2499996423721313, 0.1666666865348816, 1.2499996423721313, 0.13333335518836975, 1.1666662693023681, 0.13333335518836975, 1.1666662693023681, 0.10000002384185791, 1.1666662693023681, 0.10000002384185791, 1.2499996423721313, 0.10000002384185791, 1.2499996423721313, 0.13333335518836975, 1.2499996423721313, 0.10000002384185791, 1.1666662693023681, 0.10000002384185791, 1.1666662693023681, 0.06666669249534607, 1.1666662693023681, 0.06666669249534607, 1.2499996423721313, 0.06666669249534607, 1.2499996423721313, 0.10000002384185791, 1.2499996423721313, 0.06666669249534607, 1.1666662693023681, 0.06666669249534607, 1.1666662693023681, 0.03333335742354393, 1.1666662693023681, 0.03333335742354393, 1.2499996423721313, 0.03333335742354393, 1.2499996423721313, 0.06666669249534607, 1.2499996423721313, 0.03333335742354393, 1.1666662693023681, 0.03333335742354393, 1.1666662693023681, 2.2351741790771484e-8, 1.1666662693023681, 2.2351741790771484e-8, 1.2499996423721313, 2.2351741790771484e-8, 1.2499996423721313, 0.03333335742354393, 1.1666662693023681, 0.4000000059604645, 1.083332896232605, 0.4000000059604645, 1.083332896232605, 0.36666667461395263, 1.083332896232605, 0.36666667461395263, 1.1666662693023681, 0.36666667461395263, 1.1666662693023681, 0.4000000059604645, 1.1666662693023681, 0.36666667461395263, 1.083332896232605, 0.36666667461395263, 1.083332896232605, 0.3333333432674408, 1.083332896232605, 0.3333333432674408, 1.1666662693023681, 0.3333333432674408, 1.1666662693023681, 0.36666667461395263, 1.1666662693023681, 0.3333333432674408, 1.083332896232605, 0.3333333432674408, 1.083332896232605, 0.30000001192092895, 1.083332896232605, 0.30000001192092895, 1.1666662693023681, 0.30000001192092895, 1.1666662693023681, 0.3333333432674408, 1.1666662693023681, 0.30000001192092895, 1.083332896232605, 0.30000001192092895, 1.083332896232605, 0.2666666805744171, 1.083332896232605, 0.2666666805744171, 1.1666662693023681, 0.2666666805744171, 1.1666662693023681, 0.30000001192092895, 1.1666662693023681, 0.2666666805744171, 1.083332896232605, 0.2666666805744171, 1.083332896232605, 0.23333334922790527, 1.083332896232605, 0.23333334922790527, 1.1666662693023681, 0.23333334922790527, 1.1666662693023681, 0.2666666805744171, 1.1666662693023681, 0.23333334922790527, 1.083332896232605, 0.23333334922790527, 1.083332896232605, 0.20000001788139343, 1.083332896232605, 0.20000001788139343, 1.1666662693023681, 0.20000001788139343, 1.1666662693023681, 0.23333334922790527, 1.1666662693023681, 0.20000001788139343, 1.083332896232605, 0.20000001788139343, 1.083332896232605, 0.1666666865348816, 1.083332896232605, 0.1666666865348816, 1.1666662693023681, 0.1666666865348816, 1.1666662693023681, 0.20000001788139343, 1.1666662693023681, 0.1666666865348816, 1.083332896232605, 0.1666666865348816, 1.083332896232605, 0.13333335518836975, 1.083332896232605, 0.13333335518836975, 1.1666662693023681, 0.13333335518836975, 1.1666662693023681, 0.1666666865348816, 1.1666662693023681, 0.13333335518836975, 1.083332896232605, 0.13333335518836975, 1.083332896232605, 0.10000002384185791, 1.083332896232605, 0.10000002384185791, 1.1666662693023681, 0.10000002384185791, 1.1666662693023681, 0.13333335518836975, 1.1666662693023681, 0.10000002384185791, 1.083332896232605, 0.10000002384185791, 1.083332896232605, 0.06666669249534607, 1.083332896232605, 0.06666669249534607, 1.1666662693023681, 0.06666669249534607, 1.1666662693023681, 0.10000002384185791, 1.1666662693023681, 0.06666669249534607, 1.083332896232605, 0.06666669249534607, 1.083332896232605, 0.03333335742354393, 1.083332896232605, 0.03333335742354393, 1.1666662693023681, 0.03333335742354393, 1.1666662693023681, 0.06666669249534607, 1.1666662693023681, 0.03333335742354393, 1.083332896232605, 0.03333335742354393, 1.083332896232605, 2.2351741790771484e-8, 1.083332896232605, 2.2351741790771484e-8, 1.1666662693023681, 2.2351741790771484e-8, 1.1666662693023681, 0.03333335742354393, 1.083332896232605, 0.4000000059604645, 0.9999995827674866, 0.4000000059604645, 0.9999995827674866, 0.36666667461395263, 0.9999995827674866, 0.36666667461395263, 1.083332896232605, 0.36666667461395263, 1.083332896232605, 0.4000000059604645, 1.083332896232605, 0.36666667461395263, 0.9999995827674866, 0.36666667461395263, 0.9999995827674866, 0.3333333432674408, 0.9999995827674866, 0.3333333432674408, 1.083332896232605, 0.3333333432674408, 1.083332896232605, 0.36666667461395263, 1.083332896232605, 0.3333333432674408, 0.9999995827674866, 0.3333333432674408, 0.9999995827674866, 0.30000001192092895, 0.9999995827674866, 0.30000001192092895, 1.083332896232605, 0.30000001192092895, 1.083332896232605, 0.3333333432674408, 1.083332896232605, 0.30000001192092895, 0.9999995827674866, 0.30000001192092895, 0.9999995827674866, 0.2666666805744171, 0.9999995827674866, 0.2666666805744171, 1.083332896232605, 0.2666666805744171, 1.083332896232605, 0.30000001192092895, 1.083332896232605, 0.2666666805744171, 0.9999995827674866, 0.2666666805744171, 0.9999995827674866, 0.23333334922790527, 0.9999995827674866, 0.23333334922790527, 1.083332896232605, 0.23333334922790527, 1.083332896232605, 0.2666666805744171, 1.083332896232605, 0.23333334922790527, 0.9999995827674866, 0.23333334922790527, 0.9999995827674866, 0.20000001788139343, 0.9999995827674866, 0.20000001788139343, 1.083332896232605, 0.20000001788139343, 1.083332896232605, 0.23333334922790527, 1.083332896232605, 0.20000001788139343, 0.9999995827674866, 0.20000001788139343, 0.9999995827674866, 0.1666666865348816, 0.9999995827674866, 0.1666666865348816, 1.083332896232605, 0.1666666865348816, 1.083332896232605, 0.20000001788139343, 1.083332896232605, 0.1666666865348816, 0.9999995827674866, 0.1666666865348816, 0.9999995827674866, 0.13333335518836975, 0.9999995827674866, 0.13333335518836975, 1.083332896232605, 0.13333335518836975, 1.083332896232605, 0.1666666865348816, 1.083332896232605, 0.13333335518836975, 0.9999995827674866, 0.13333335518836975, 0.9999995827674866, 0.10000002384185791, 0.9999995827674866, 0.10000002384185791, 1.083332896232605, 0.10000002384185791, 1.083332896232605, 0.13333335518836975, 1.083332896232605, 0.10000002384185791, 0.9999995827674866, 0.10000002384185791, 0.9999995827674866, 0.06666669249534607, 0.9999995827674866, 0.06666669249534607, 1.083332896232605, 0.06666669249534607, 1.083332896232605, 0.10000002384185791, 1.083332896232605, 0.06666669249534607, 0.9999995827674866, 0.06666669249534607, 0.9999995827674866, 0.03333335742354393, 0.9999995827674866, 0.03333335742354393, 1.083332896232605, 0.03333335742354393, 1.083332896232605, 0.06666669249534607, 1.083332896232605, 0.03333335742354393, 0.9999995827674866, 0.03333335742354393, 0.9999995827674866, 2.2351741790771484e-8, 0.9999995827674866, 2.2351741790771484e-8, 1.083332896232605, 2.2351741790771484e-8, 1.083332896232605, 0.03333335742354393, 1, 0.4000000059604645, 0.9166666865348816, 0.4000000059604645, 0.9166666865348816, 0.36666667461395263, 0.9166666865348816, 0.36666667461395263, 1, 0.36666667461395263, 1, 0.4000000059604645, 1, 0.36666667461395263, 0.9166666865348816, 0.36666667461395263, 0.9166666865348816, 0.3333333432674408, 0.9166666865348816, 0.3333333432674408, 1, 0.3333333432674408, 1, 0.36666667461395263, 1, 0.3333333432674408, 0.9166666865348816, 0.3333333432674408, 0.9166666865348816, 0.30000001192092895, 0.9166666865348816, 0.30000001192092895, 1, 0.30000001192092895, 1, 0.3333333432674408, 1, 0.30000001192092895, 0.9166666865348816, 0.30000001192092895, 0.9166666865348816, 0.2666666805744171, 0.9166666865348816, 0.2666666805744171, 1, 0.2666666805744171, 1, 0.30000001192092895, 1, 0.2666666805744171, 0.9166666865348816, 0.2666666805744171, 0.9166666865348816, 0.23333334922790527, 0.9166666865348816, 0.23333334922790527, 1, 0.23333334922790527, 1, 0.2666666805744171, 1, 0.23333334922790527, 0.9166666865348816, 0.23333334922790527, 0.9166666865348816, 0.20000001788139343, 0.9166666865348816, 0.20000001788139343, 1, 0.20000001788139343, 1, 0.23333334922790527, 1, 0.20000001788139343, 0.9166666865348816, 0.20000001788139343, 0.9166666865348816, 0.1666666865348816, 0.9166666865348816, 0.1666666865348816, 1, 0.1666666865348816, 1, 0.20000001788139343, 1, 0.1666666865348816, 0.9166666865348816, 0.1666666865348816, 0.9166666865348816, 0.13333335518836975, 0.9166666865348816, 0.13333335518836975, 1, 0.13333335518836975, 1, 0.1666666865348816, 1, 0.13333335518836975, 0.9166666865348816, 0.13333335518836975, 0.9166666865348816, 0.10000002384185791, 0.9166666865348816, 0.10000002384185791, 1, 0.10000002384185791, 1, 0.13333335518836975, 1, 0.10000002384185791, 0.9166666865348816, 0.10000002384185791, 0.9166666865348816, 0.06666669249534607, 0.9166666865348816, 0.06666669249534607, 1, 0.06666669249534607, 1, 0.10000002384185791, 1, 0.06666669249534607, 0.9166666865348816, 0.06666669249534607, 0.9166666865348816, 0.03333335742354393, 0.9166666865348816, 0.03333335742354393, 1, 0.03333335742354393, 1, 0.06666669249534607, 1, 0.03333335742354393, 0.9166666865348816, 0.03333335742354393, 0.9166666865348816, 2.2351741790771484e-8, 0.9166666865348816, 2.2351741790771484e-8, 1, 2.2351741790771484e-8, 1, 0.03333335742354393, 0.9166666865348816, 0.4000000059604645, 0.8333333730697632, 0.4000000059604645, 0.8333333730697632, 0.36666667461395263, 0.8333333730697632, 0.36666667461395263, 0.9166666865348816, 0.36666667461395263, 0.9166666865348816, 0.4000000059604645, 0.9166666865348816, 0.36666667461395263, 0.8333333730697632, 0.36666667461395263, 0.8333333730697632, 0.3333333432674408, 0.8333333730697632, 0.3333333432674408, 0.9166666865348816, 0.3333333432674408, 0.9166666865348816, 0.36666667461395263, 0.9166666865348816, 0.3333333432674408, 0.8333333730697632, 0.3333333432674408, 0.8333333730697632, 0.30000001192092895, 0.8333333730697632, 0.30000001192092895, 0.9166666865348816, 0.30000001192092895, 0.9166666865348816, 0.3333333432674408, 0.9166666865348816, 0.30000001192092895, 0.8333333730697632, 0.30000001192092895, 0.8333333730697632, 0.2666666805744171, 0.8333333730697632, 0.2666666805744171, 0.9166666865348816, 0.2666666805744171, 0.9166666865348816, 0.30000001192092895, 0.9166666865348816, 0.2666666805744171, 0.8333333730697632, 0.2666666805744171, 0.8333333730697632, 0.23333334922790527, 0.8333333730697632, 0.23333334922790527, 0.9166666865348816, 0.23333334922790527, 0.9166666865348816, 0.2666666805744171, 0.9166666865348816, 0.23333334922790527, 0.8333333730697632, 0.23333334922790527, 0.8333333730697632, 0.20000001788139343, 0.8333333730697632, 0.20000001788139343, 0.9166666865348816, 0.20000001788139343, 0.9166666865348816, 0.23333334922790527, 0.9166666865348816, 0.20000001788139343, 0.8333333730697632, 0.20000001788139343, 0.8333333730697632, 0.1666666865348816, 0.8333333730697632, 0.1666666865348816, 0.9166666865348816, 0.1666666865348816, 0.9166666865348816, 0.20000001788139343, 0.9166666865348816, 0.1666666865348816, 0.8333333730697632, 0.1666666865348816, 0.8333333730697632, 0.13333335518836975, 0.8333333730697632, 0.13333335518836975, 0.9166666865348816, 0.13333335518836975, 0.9166666865348816, 0.1666666865348816, 0.9166666865348816, 0.13333335518836975, 0.8333333730697632, 0.13333335518836975, 0.8333333730697632, 0.10000002384185791, 0.8333333730697632, 0.10000002384185791, 0.9166666865348816, 0.10000002384185791, 0.9166666865348816, 0.13333335518836975, 0.9166666865348816, 0.10000002384185791, 0.8333333730697632, 0.10000002384185791, 0.8333333730697632, 0.06666669249534607, 0.8333333730697632, 0.06666669249534607, 0.9166666865348816, 0.06666669249534607, 0.9166666865348816, 0.10000002384185791, 0.9166666865348816, 0.06666669249534607, 0.8333333730697632, 0.06666669249534607, 0.8333333730697632, 0.03333335742354393, 0.8333333730697632, 0.03333335742354393, 0.9166666865348816, 0.03333335742354393, 0.9166666865348816, 0.06666669249534607, 0.9166666865348816, 0.03333335742354393, 0.8333333730697632, 0.03333335742354393, 0.8333333730697632, 2.2351741790771484e-8, 0.8333333730697632, 2.2351741790771484e-8, 0.9166666865348816, 2.2351741790771484e-8, 0.9166666865348816, 0.03333335742354393, 0.8333333730697632, 0.4000000059604645, 0.7500000596046448, 0.4000000059604645, 0.7500000596046448, 0.36666667461395263, 0.7500000596046448, 0.36666667461395263, 0.8333333730697632, 0.36666667461395263, 0.8333333730697632, 0.4000000059604645, 0.8333333730697632, 0.36666667461395263, 0.7500000596046448, 0.36666667461395263, 0.7500000596046448, 0.3333333432674408, 0.7500000596046448, 0.3333333432674408, 0.8333333730697632, 0.3333333432674408, 0.8333333730697632, 0.36666667461395263, 0.8333333730697632, 0.3333333432674408, 0.7500000596046448, 0.3333333432674408, 0.7500000596046448, 0.30000001192092895, 0.7500000596046448, 0.30000001192092895, 0.8333333730697632, 0.30000001192092895, 0.8333333730697632, 0.3333333432674408, 0.8333333730697632, 0.30000001192092895, 0.7500000596046448, 0.30000001192092895, 0.7500000596046448, 0.2666666805744171, 0.7500000596046448, 0.2666666805744171, 0.8333333730697632, 0.2666666805744171, 0.8333333730697632, 0.30000001192092895, 0.8333333730697632, 0.2666666805744171, 0.7500000596046448, 0.2666666805744171, 0.7500000596046448, 0.23333334922790527, 0.7500000596046448, 0.23333334922790527, 0.8333333730697632, 0.23333334922790527, 0.8333333730697632, 0.2666666805744171, 0.8333333730697632, 0.23333334922790527, 0.7500000596046448, 0.23333334922790527, 0.7500000596046448, 0.20000001788139343, 0.7500000596046448, 0.20000001788139343, 0.8333333730697632, 0.20000001788139343, 0.8333333730697632, 0.23333334922790527, 0.8333333730697632, 0.20000001788139343, 0.7500000596046448, 0.20000001788139343, 0.7500000596046448, 0.1666666865348816, 0.7500000596046448, 0.1666666865348816, 0.8333333730697632, 0.1666666865348816, 0.8333333730697632, 0.20000001788139343, 0.8333333730697632, 0.1666666865348816, 0.7500000596046448, 0.1666666865348816, 0.7500000596046448, 0.13333335518836975, 0.7500000596046448, 0.13333335518836975, 0.8333333730697632, 0.13333335518836975, 0.8333333730697632, 0.1666666865348816, 0.8333333730697632, 0.13333335518836975, 0.7500000596046448, 0.13333335518836975, 0.7500000596046448, 0.10000002384185791, 0.7500000596046448, 0.10000002384185791, 0.8333333730697632, 0.10000002384185791, 0.8333333730697632, 0.13333335518836975, 0.8333333730697632, 0.10000002384185791, 0.7500000596046448, 0.10000002384185791, 0.7500000596046448, 0.06666669249534607, 0.7500000596046448, 0.06666669249534607, 0.8333333730697632, 0.06666669249534607, 0.8333333730697632, 0.10000002384185791, 0.8333333730697632, 0.06666669249534607, 0.7500000596046448, 0.06666669249534607, 0.7500000596046448, 0.03333335742354393, 0.7500000596046448, 0.03333335742354393, 0.8333333730697632, 0.03333335742354393, 0.8333333730697632, 0.06666669249534607, 0.8333333730697632, 0.03333335742354393, 0.7500000596046448, 0.03333335742354393, 0.7500000596046448, 2.2351741790771484e-8, 0.7500000596046448, 2.2351741790771484e-8, 0.8333333730697632, 2.2351741790771484e-8, 0.8333333730697632, 0.03333335742354393, 0.7500000596046448, 0.4000000059604645, 0.6666667461395264, 0.4000000059604645, 0.6666667461395264, 0.36666667461395263, 0.6666667461395264, 0.36666667461395263, 0.7500000596046448, 0.36666667461395263, 0.7500000596046448, 0.4000000059604645, 0.7500000596046448, 0.36666667461395263, 0.6666667461395264, 0.36666667461395263, 0.6666667461395264, 0.3333333432674408, 0.6666667461395264, 0.3333333432674408, 0.7500000596046448, 0.3333333432674408, 0.7500000596046448, 0.36666667461395263, 0.7500000596046448, 0.3333333432674408, 0.6666667461395264, 0.3333333432674408, 0.6666667461395264, 0.30000001192092895, 0.6666667461395264, 0.30000001192092895, 0.7500000596046448, 0.30000001192092895, 0.7500000596046448, 0.3333333432674408, 0.7500000596046448, 0.30000001192092895, 0.6666667461395264, 0.30000001192092895, 0.6666667461395264, 0.2666666805744171, 0.6666667461395264, 0.2666666805744171, 0.7500000596046448, 0.2666666805744171, 0.7500000596046448, 0.30000001192092895, 0.7500000596046448, 0.2666666805744171, 0.6666667461395264, 0.2666666805744171, 0.6666667461395264, 0.23333334922790527, 0.6666667461395264, 0.23333334922790527, 0.7500000596046448, 0.23333334922790527, 0.7500000596046448, 0.2666666805744171, 0.7500000596046448, 0.23333334922790527, 0.6666667461395264, 0.23333334922790527, 0.6666667461395264, 0.20000001788139343, 0.6666667461395264, 0.20000001788139343, 0.7500000596046448, 0.20000001788139343, 0.7500000596046448, 0.23333334922790527, 0.7500000596046448, 0.20000001788139343, 0.6666667461395264, 0.20000001788139343, 0.6666667461395264, 0.1666666865348816, 0.6666667461395264, 0.1666666865348816, 0.7500000596046448, 0.1666666865348816, 0.7500000596046448, 0.20000001788139343, 0.7500000596046448, 0.1666666865348816, 0.6666667461395264, 0.1666666865348816, 0.6666667461395264, 0.13333335518836975, 0.6666667461395264, 0.13333335518836975, 0.7500000596046448, 0.13333335518836975, 0.7500000596046448, 0.1666666865348816, 0.7500000596046448, 0.13333335518836975, 0.6666667461395264, 0.13333335518836975, 0.6666667461395264, 0.10000002384185791, 0.6666667461395264, 0.10000002384185791, 0.7500000596046448, 0.10000002384185791, 0.7500000596046448, 0.13333335518836975, 0.7500000596046448, 0.10000002384185791, 0.6666667461395264, 0.10000002384185791, 0.6666667461395264, 0.06666669249534607, 0.6666667461395264, 0.06666669249534607, 0.7500000596046448, 0.06666669249534607, 0.7500000596046448, 0.10000002384185791, 0.7500000596046448, 0.06666669249534607, 0.6666667461395264, 0.06666669249534607, 0.6666667461395264, 0.03333335742354393, 0.6666667461395264, 0.03333335742354393, 0.7500000596046448, 0.03333335742354393, 0.7500000596046448, 0.06666669249534607, 0.7500000596046448, 0.03333335742354393, 0.6666667461395264, 0.03333335742354393, 0.6666667461395264, 2.2351741790771484e-8, 0.6666667461395264, 2.2351741790771484e-8, 0.7500000596046448, 2.2351741790771484e-8, 0.7500000596046448, 0.03333335742354393, 0.6666667461395264, 0.4000000059604645, 0.583333432674408, 0.4000000059604645, 0.583333432674408, 0.36666667461395263, 0.583333432674408, 0.36666667461395263, 0.6666667461395264, 0.36666667461395263, 0.6666667461395264, 0.4000000059604645, 0.6666667461395264, 0.36666667461395263, 0.583333432674408, 0.36666667461395263, 0.583333432674408, 0.3333333432674408, 0.583333432674408, 0.3333333432674408, 0.6666667461395264, 0.3333333432674408, 0.6666667461395264, 0.36666667461395263, 0.6666667461395264, 0.3333333432674408, 0.583333432674408, 0.3333333432674408, 0.583333432674408, 0.30000001192092895, 0.583333432674408, 0.30000001192092895, 0.6666667461395264, 0.30000001192092895, 0.6666667461395264, 0.3333333432674408, 0.6666667461395264, 0.30000001192092895, 0.583333432674408, 0.30000001192092895, 0.583333432674408, 0.2666666805744171, 0.583333432674408, 0.2666666805744171, 0.6666667461395264, 0.2666666805744171, 0.6666667461395264, 0.30000001192092895, 0.6666667461395264, 0.2666666805744171, 0.583333432674408, 0.2666666805744171, 0.583333432674408, 0.23333334922790527, 0.583333432674408, 0.23333334922790527, 0.6666667461395264, 0.23333334922790527, 0.6666667461395264, 0.2666666805744171, 0.6666667461395264, 0.23333334922790527, 0.583333432674408, 0.23333334922790527, 0.583333432674408, 0.20000001788139343, 0.583333432674408, 0.20000001788139343, 0.6666667461395264, 0.20000001788139343, 0.6666667461395264, 0.23333334922790527, 0.6666667461395264, 0.20000001788139343, 0.583333432674408, 0.20000001788139343, 0.583333432674408, 0.1666666865348816, 0.583333432674408, 0.1666666865348816, 0.6666667461395264, 0.1666666865348816, 0.6666667461395264, 0.20000001788139343, 0.6666667461395264, 0.1666666865348816, 0.583333432674408, 0.1666666865348816, 0.583333432674408, 0.13333335518836975, 0.583333432674408, 0.13333335518836975, 0.6666667461395264, 0.13333335518836975, 0.6666667461395264, 0.1666666865348816, 0.6666667461395264, 0.13333335518836975, 0.583333432674408, 0.13333335518836975, 0.583333432674408, 0.10000002384185791, 0.583333432674408, 0.10000002384185791, 0.6666667461395264, 0.10000002384185791, 0.6666667461395264, 0.13333335518836975, 0.6666667461395264, 0.10000002384185791, 0.583333432674408, 0.10000002384185791, 0.583333432674408, 0.06666669249534607, 0.583333432674408, 0.06666669249534607, 0.6666667461395264, 0.06666669249534607, 0.6666667461395264, 0.10000002384185791, 0.6666667461395264, 0.06666669249534607, 0.583333432674408, 0.06666669249534607, 0.583333432674408, 0.03333335742354393, 0.583333432674408, 0.03333335742354393, 0.6666667461395264, 0.03333335742354393, 0.6666667461395264, 0.06666669249534607, 0.6666667461395264, 0.03333335742354393, 0.583333432674408, 0.03333335742354393, 0.583333432674408, 2.2351741790771484e-8, 0.583333432674408, 2.2351741790771484e-8, 0.6666667461395264, 2.2351741790771484e-8, 0.6666667461395264, 0.03333335742354393, 0.583333432674408, 0.4000000059604645, 0.5000001192092895, 0.4000000059604645, 0.5000001192092895, 0.36666667461395263, 0.5000001192092895, 0.36666667461395263, 0.583333432674408, 0.36666667461395263, 0.583333432674408, 0.4000000059604645, 0.583333432674408, 0.36666667461395263, 0.5000001192092895, 0.36666667461395263, 0.5000001192092895, 0.3333333432674408, 0.5000001192092895, 0.3333333432674408, 0.583333432674408, 0.3333333432674408, 0.583333432674408, 0.36666667461395263, 0.583333432674408, 0.3333333432674408, 0.5000001192092895, 0.3333333432674408, 0.5000001192092895, 0.30000001192092895, 0.5000001192092895, 0.30000001192092895, 0.583333432674408, 0.30000001192092895, 0.583333432674408, 0.3333333432674408, 0.583333432674408, 0.30000001192092895, 0.5000001192092895, 0.30000001192092895, 0.5000001192092895, 0.2666666805744171, 0.5000001192092895, 0.2666666805744171, 0.583333432674408, 0.2666666805744171, 0.583333432674408, 0.30000001192092895, 0.583333432674408, 0.2666666805744171, 0.5000001192092895, 0.2666666805744171, 0.5000001192092895, 0.23333334922790527, 0.5000001192092895, 0.23333334922790527, 0.583333432674408, 0.23333334922790527, 0.583333432674408, 0.2666666805744171, 0.583333432674408, 0.23333334922790527, 0.5000001192092895, 0.23333334922790527, 0.5000001192092895, 0.20000001788139343, 0.5000001192092895, 0.20000001788139343, 0.583333432674408, 0.20000001788139343, 0.583333432674408, 0.23333334922790527, 0.583333432674408, 0.20000001788139343, 0.5000001192092895, 0.20000001788139343, 0.5000001192092895, 0.1666666865348816, 0.5000001192092895, 0.1666666865348816, 0.583333432674408, 0.1666666865348816, 0.583333432674408, 0.20000001788139343, 0.583333432674408, 0.1666666865348816, 0.5000001192092895, 0.1666666865348816, 0.5000001192092895, 0.13333335518836975, 0.5000001192092895, 0.13333335518836975, 0.583333432674408, 0.13333335518836975, 0.583333432674408, 0.1666666865348816, 0.583333432674408, 0.13333335518836975, 0.5000001192092895, 0.13333335518836975, 0.5000001192092895, 0.10000002384185791, 0.5000001192092895, 0.10000002384185791, 0.583333432674408, 0.10000002384185791, 0.583333432674408, 0.13333335518836975, 0.583333432674408, 0.10000002384185791, 0.5000001192092895, 0.10000002384185791, 0.5000001192092895, 0.06666669249534607, 0.5000001192092895, 0.06666669249534607, 0.583333432674408, 0.06666669249534607, 0.583333432674408, 0.10000002384185791, 0.583333432674408, 0.06666669249534607, 0.5000001192092895, 0.06666669249534607, 0.5000001192092895, 0.03333335742354393, 0.5000001192092895, 0.03333335742354393, 0.583333432674408, 0.03333335742354393, 0.583333432674408, 0.06666669249534607, 0.583333432674408, 0.03333335742354393, 0.5000001192092895, 0.03333335742354393, 0.5000001192092895, 2.2351741790771484e-8, 0.5000001192092895, 2.2351741790771484e-8, 0.583333432674408, 2.2351741790771484e-8, 0.583333432674408, 0.03333335742354393, 0.5000001192092895, 0.4000000059604645, 0.41666677594184875, 0.4000000059604645, 0.41666677594184875, 0.36666667461395263, 0.41666677594184875, 0.36666667461395263, 0.5000001192092895, 0.36666667461395263, 0.5000001192092895, 0.4000000059604645, 0.5000001192092895, 0.36666667461395263, 0.41666677594184875, 0.36666667461395263, 0.41666677594184875, 0.3333333432674408, 0.41666677594184875, 0.3333333432674408, 0.5000001192092895, 0.3333333432674408, 0.50000011920928